editor_objects = {}
editor_currobjlist = {}
editor_objlist_reference = {}

function clearobjlist()
	editor_objects = {}
	editor_currobjlist = {}
	
	objlistdata.tags = {}
	objlistdata.tags_currobjlist = {}
	objlistdata.objectreference = {}
	objlistdata.tilereference = {}
	objlistdata.gridreference_overlap = {}
	objlistdata.gridreference_full = {}
	objlistdata.search = ""
	objlistdata.search_currobjlist = ""
	editor2.strings[SEARCHSTRING] = ""
	editor4.strings[SEARCHSTRING_CURROBJLIST] = ""
	editor4.strings[CURRENTTAGS] = ""
end

function formatobjlist()
	for i,v in pairs(editor_objlist) do
		editor_objlist_reference[v.name] = i
	end
end

editor_objlist_order = {"algae","text_algae","arm","text_arm","arrow","text_arrow","baba","text_baba","badbad","text_badbad","banana","text_banana","bat","text_bat","bean","text_bean","bed","text_bed","bee","text_bee","belt","text_belt","bird","text_bird","blob","text_blob","boat","text_boat","boba","text_boba","bog","text_bog","bolt","text_bolt","bomb","text_bomb","book","text_book","bone","text_bone","bottle","text_bottle","box","text_box","brain","text_brain","brick","text_brick","bubble","text_bubble","bucket","text_bucket","bug","text_bug","bunny","text_bunny","burger","text_burger","cactus","text_cactus","cake","text_cake","car","text_car","cart","text_cart","cash","text_cash","cat","text_cat","chair","text_chair","cheese","text_cheese","chili","text_chili","circle","text_circle","cliff","text_cliff","clock","text_clock","cloud","text_cloud","cog","text_cog","crab","text_crab","crystal","text_crystal","cup","text_cup","dog","text_dog","donut","text_donut","door","text_door","dot","text_dot","drink","text_drink","drum","text_drum","dust","text_dust","ear","text_ear","egg","text_egg","eye","text_eye","fence","text_fence","fire","text_fire","fish","text_fish","flag","text_flag","flower","text_flower","fofo","text_fofo","foliage","text_foliage","foot","text_foot","fort","text_fort","fox","text_fox","frog","text_frog","fruit","text_fruit","fungi","text_fungi","fungus","text_fungus","gate","text_gate","gem","text_gem","ghost","text_ghost","grass","text_grass","guitar","text_guitar","hand","text_hand","hedge","text_hedge","hihat","text_hihat","hotdog","text_hotdog","house","text_house","husk","text_husk","husks","text_husks","ice","text_ice","it","text_it","jelly","text_jelly","jiji","text_jiji","keke","text_keke","key","text_key","knight","text_knight","ladder","text_ladder","lamp","text_lamp","lava","text_lava","leaf","text_leaf","lever","text_lever","lift","text_lift","lily","text_lily","line","text_line","lizard","text_lizard","lock","text_lock","love","text_love","me","text_me","mirror","text_mirror","monitor","text_monitor","monster","text_monster","moon","text_moon","nose","text_nose","orb","text_orb","palm","text_palm","pants","text_pants","paper","text_paper","pawn","text_pawn","piano","text_piano","pillar","text_pillar","pipe","text_pipe","pixel","text_pixel","pizza","text_pizza","plane","text_plane","planet","text_planet","plank","text_plank","potato","text_potato","pumpkin","text_pumpkin","reed","text_reed","ring","text_ring","road","text_road","robot","text_robot","rock","text_rock","rocket","text_rocket","rose","text_rose","rubble","text_rubble","sax","text_sax","scissors","text_scissors","seed","text_seed","shell","text_shell","shirt","text_shirt","shovel","text_shovel","sign","text_sign","skull","text_skull","snail","text_snail","spike","text_spike","sprout","text_sprout","square","text_square","star","text_star","statue","text_statue","stick","text_stick","stump","text_stump","sun","text_sun","sword","text_sword","table","text_table","teeth","text_teeth","tile","text_tile","tower","text_tower","track","text_track","train","text_train","tree","text_tree","trees","text_trees","triangle","text_triangle","trumpet","text_trumpet","turnip","text_turnip","turtle","text_turtle","ufo","text_ufo","vase","text_vase","vine","text_vine","wall","text_wall","water","text_water","what","text_what","wind","text_wind","worm","text_worm","yes","text_yes","no","text_no","text_all","text_text","text_level","text_group","text_group2","text_group3","text_empty","text_not","text_is","text_and","text_has","text_eat","text_fear","text_follow","text_make","text_mimic","text_play","text_write","text_become","text_you","text_you2","text_push","text_pull","text_stop","text_move","text_shift","text_right","text_up","text_left","text_down","text_fall","text_fallright","text_fallup","text_fallleft","text_nudgedown","text_nudgeright","text_nudgeup","text_nudgeleft","text_turn","text_deturn","text_defeat","text_hot","text_melt","text_open","text_shut","text_sink","text_boom","text_safe","text_float","text_phantom","text_hide","text_reverse","text_auto","text_back","text_broken","text_sleep","text_still","text_lockeddown","text_lockedright","text_lockedup","text_lockedleft","text_hold","text_swap","text_tele","text_weak","text_win","text_more","text_word","text_idle","text_lonely","text_often","text_seldom","text_on","text_near","text_nextto","text_facing","text_facedby","text_seeing","text_without","text_above","text_below","text_besideleft","text_besideright","text_feeling","text_power","text_powered","text_power2","text_powered2","text_power3","text_powered3","text_red","text_orange","text_yellow","text_lime","text_green","text_cyan","text_blue","text_purple","text_pink","text_rosy","text_black","text_grey","text_silver","text_white","text_brown","text_best","text_party","text_pet","text_happy","text_sad","text_angry","text_wonder","text_chill","text_bonus","text_end","text_done","text_revert","cursor","text_cursor","text_select","text_3d","text_a","text_b","text_c","text_d","text_e","text_f","text_g","text_h","text_i","text_j","text_k","text_l","text_m","text_n","text_o","text_p","text_q","text_r","text_s","text_t","text_u","text_v","text_w","text_x","text_y","text_z","text_0","text_1","text_2","text_3","text_4","text_5","text_6","text_7","text_8","text_9","text_sharp","text_flat"}

editor_objlist = {
	[1] = {
		name = "algae",
		unittype = "object",
		tags = {"water","plant","decorative"},
		tiling = -1,
		type = 0,
		layer = 15,
		colour = {5, 2},
	},
	[2] = {
		name = "text_algae",
		unittype = "text",
		tags = {"water","plant","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 0},
		colour_active = {5, 1},
	},
	[3] = {
		name = "baba",
		unittype = "object",
		tags = {"animal","common"},
		tiling = 2,
		type = 0,
		layer = 18,
		colour = {0, 3},
	},
	[4] = {
		name = "text_baba",
		unittype = "text",
		tags = {"animal","common"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
	},
	[5] = {
		name = "bat",
		unittype = "object",
		tags = {"cave","animal"},
		tiling = 4,
		type = 0,
		layer = 14,
		colour = {3, 1},
	},
	[6] = {
		name = "text_bat",
		unittype = "text",
		tags = {"cave","animal"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 0},
		colour_active = {3, 1},
	},
	[7] = {
		name = "belt",
		unittype = "object",
		tags = {"common","machine","movement"},
		tiling = 3,
		type = 0,
		layer = 9,
		colour = {1, 1},
	},
	[8] = {
		name = "text_belt",
		unittype = "text",
		tags = {"common","machine","movement"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 3},
	},
	[9] = {
		name = "bird",
		unittype = "object",
		tags = {"mountain","animal","sky"},
		tiling = 0,
		type = 0,
		layer = 17,
		colour = {2, 3},
	},
	[10] = {
		name = "text_bird",
		unittype = "text",
		tags = {"mountain","animal","sky"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 2},
		colour_active = {2, 3},
	},
	[11] = {
		name = "text_w",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[12] = {
		name = "bog",
		sprite = "water",
		unittype = "object",
		tags = {"obstacle","forest"},
		tiling = 1,
		type = 0,
		layer = 2,
		colour = {5, 1},
	},
	[13] = {
		name = "text_bog",
		unittype = "text",
		tags = {"obstacle","forest"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
	},
	[14] = {
		name = "bolt",
		unittype = "object",
		tags = {"machine","sky","danger"},
		tiling = 0,
		type = 0,
		layer = 16,
		colour = {2, 4},
	},
	[15] = {
		name = "text_bolt",
		unittype = "text",
		tags = {"machine","sky","danger"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 3},
		colour_active = {2, 4},
	},
	[16] = {
		name = "box",
		unittype = "object",
		tags = {"common","machine","item","town"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {6, 2},
	},
	[17] = {
		name = "text_box",
		unittype = "text",
		tags = {"common","machine","item","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 0},
		colour_active = {6, 1},
	},
	[18] = {
		name = "brick",
		unittype = "object",
		tags = {"ruins","floor","decorative","town"},
		tiling = 1,
		type = 0,
		layer = 10,
		colour = {6, 3},
	},
	[19] = {
		name = "text_brick",
		unittype = "text",
		tags = {"ruins","floor","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 0},
		colour_active = {6, 1},
	},
	[20] = {
		name = "bubble",
		unittype = "object",
		tags = {"water","decorative"},
		tiling = 4,
		type = 0,
		layer = 12,
		colour = {1, 4},
	},
	[21] = {
		name = "text_bubble",
		unittype = "text",
		tags = {"water","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 3},
		colour_active = {1, 4},
	},
	[22] = {
		name = "bug",
		unittype = "object",
		tags = {"forest","animal"},
		tiling = 0,
		type = 0,
		layer = 17,
		colour = {6, 2},
	},
	[23] = {
		name = "text_bug",
		unittype = "text",
		tags = {"forest","animal"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 0},
		colour_active = {6, 2},
	},
	[24] = {
		name = "cake",
		unittype = "object",
		tags = {"item","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 17,
		colour = {4, 2},
	},
	[25] = {
		name = "text_cake",
		unittype = "text",
		tags = {"item","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 1},
		colour_active = {4, 2},
	},
	[26] = {
		name = "cash",
		unittype = "object",
		tags = {"item","danger","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 12,
		colour = {5, 2},
	},
	[27] = {
		name = "text_cash",
		unittype = "text",
		tags = {"item","danger","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
	},
	[28] = {
		name = "cliff",
		unittype = "object",
		tags = {"cave","obstacle"},
		tiling = 1,
		type = 0,
		layer = 14,
		colour = {6, 1},
	},
	[29] = {
		name = "text_cliff",
		unittype = "text",
		tags = {"cave","obstacle"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 0},
		colour_active = {6, 2},
	},
	[30] = {
		name = "cloud",
		unittype = "object",
		tags = {"sky","obstacle"},
		tiling = 1,
		type = 0,
		layer = 14,
		colour = {1, 4},
	},
	[31] = {
		name = "text_cloud",
		unittype = "text",
		tags = {"sky","obstacle"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 3},
		colour_active = {1, 4},
	},
	[32] = {
		name = "cog",
		unittype = "object",
		tags = {"machine","item","decorative"},
		tiling = 4,
		type = 0,
		layer = 16,
		colour = {0, 1},
	},
	[33] = {
		name = "text_cog",
		unittype = "text",
		tags = {"machine","item","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 2},
	},
	[34] = {
		name = "crab",
		unittype = "object",
		tags = {"water","animal"},
		tiling = 0,
		type = 0,
		layer = 17,
		colour = {2, 2},
	},
	[35] = {
		name = "text_crab",
		unittype = "text",
		tags = {"water","animal"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[36] = {
		name = "cup",
		unittype = "object",
		tags = {"item","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 13,
		colour = {3, 3},
	},
	[37] = {
		name = "text_cup",
		unittype = "text",
		tags = {"item","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 2},
		colour_active = {3, 3},
	},
	[38] = {
		name = "cursor",
		unittype = "object",
		special = true,
		tags = {"common"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 2},
	},
	[39] = {
		name = "door",
		unittype = "object",
		tags = {"common","obstacle","town"},
		tiling = -1,
		type = 0,
		layer = 15,
		colour = {2, 2},
	},
	[40] = {
		name = "text_door",
		unittype = "text",
		tags = {"common","obstacle","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[41] = {
		name = "dot",
		unittype = "object",
		tags = {"abstract","decorative"},
		tiling = -1,
		type = 0,
		layer = 12,
		colour = {0, 3},
	},
	[42] = {
		name = "text_dot",
		unittype = "text",
		tags = {"abstract","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[43] = {
		name = "dust",
		unittype = "object",
		tags = {"sky","decorative"},
		tiling = -1,
		type = 0,
		layer = 12,
		colour = {6, 2},
	},
	[44] = {
		name = "text_dust",
		unittype = "text",
		tags = {"sky","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 2},
		colour_active = {2, 4},
	},
	[45] = {
		name = "fence",
		unittype = "object",
		tags = {"autumn","obstacle","town"},
		tiling = 1,
		type = 0,
		layer = 14,
		colour = {6, 1},
	},
	[46] = {
		name = "text_fence",
		unittype = "text",
		tags = {"autumn","obstacle","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 0},
		colour_active = {6, 1},
	},
	[47] = {
		name = "fire",
		unittype = "object",
		tags = {"cave","decorative","danger"},
		tiling = -1,
		type = 0,
		layer = 15,
		colour = {2, 3},
	},
	[48] = {
		name = "text_fire",
		unittype = "text",
		tags = {"cave","decorative","danger"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 0},
		colour_active = {2, 2},
	},
	[49] = {
		name = "flag",
		unittype = "object",
		tags = {"common","item"},
		tiling = -1,
		type = 0,
		layer = 17,
		colour = {2, 4},
	},
	[50] = {
		name = "text_flag",
		unittype = "text",
		tags = {"common","item"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {2, 4},
	},
	[51] = {
		name = "flower",
		unittype = "object",
		tags = {"plant","forest","decorative"},
		tiling = -1,
		type = 0,
		layer = 12,
		colour = {3, 3},
	},
	[52] = {
		name = "text_flower",
		unittype = "text",
		tags = {"plant","forest","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 2},
		colour_active = {3, 3},
	},
	[53] = {
		name = "foliage",
		unittype = "object",
		tags = {"autumn","plant","decorative","floor"},
		tiling = -1,
		type = 0,
		layer = 17,
		colour = {6, 0},
	},
	[54] = {
		name = "text_foliage",
		unittype = "text",
		tags = {"autumn","plant","decorative","floor"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 2},
		colour_active = {2, 3},
	},
	[55] = {
		name = "fruit",
		unittype = "object",
		tags = {"plant","forest","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 2},
	},
	[56] = {
		name = "text_fruit",
		unittype = "text",
		tags = {"plant","forest","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[57] = {
		name = "fungi",
		unittype = "object",
		tags = {"plant","autumn","decorative"},
		tiling = -1,
		type = 0,
		layer = 8,
		colour = {6, 1},
	},
	[58] = {
		name = "text_fungi",
		unittype = "text",
		tags = {"plant","autumn","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 0},
		colour_active = {6, 2},
	},
	[59] = {
		name = "fungus",
		unittype = "object",
		tags = {"plant","autumn","item","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {6, 1},
	},
	[60] = {
		name = "text_fungus",
		unittype = "text",
		tags = {"plant","autumn","item","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 0},
		colour_active = {6, 1},
	},
	[61] = {
		name = "ghost",
		unittype = "object",
		tags = {"autumn","animal"},
		tiling = 0,
		type = 0,
		layer = 17,
		colour = {4, 2},
	},
	[62] = {
		name = "text_ghost",
		unittype = "text",
		tags = {"autumn","animal"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 1},
		colour_active = {4, 2},
	},
	[63] = {
		name = "grass",
		unittype = "object",
		tags = {"plant","forest","floor"},
		tiling = 1,
		type = 0,
		layer = 10,
		colour = {5, 0},
	},
	[64] = {
		name = "text_grass",
		unittype = "text",
		tags = {"plant","forest","floor"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
	},
	[65] = {
		name = "hand",
		unittype = "object",
		tags = {"abstract"},
		tiling = 0,
		type = 0,
		layer = 17,
		colour = {3, 1},
	},
	[66] = {
		name = "text_hand",
		unittype = "text",
		tags = {"abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 1},
		colour_active = {4, 2},
	},
	[67] = {
		name = "hedge",
		unittype = "object",
		tags = {"plant","obstacle"},
		tiling = 1,
		type = 0,
		layer = 14,
		colour = {5, 1},
	},
	[68] = {
		name = "text_hedge",
		unittype = "text",
		tags = {"plant","obstacle"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 0},
		colour_active = {5, 1},
	},
	[69] = {
		name = "husk",
		unittype = "object",
		tags = {"plant","obstacle","autumn"},
		tiling = -1,
		type = 0,
		layer = 15,
		colour = {6, 1},
	},
	[70] = {
		name = "text_husk",
		unittype = "text",
		tags = {"plant","obstacle","autumn"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {6, 1},
	},
	[71] = {
		name = "ice",
		unittype = "object",
		tags = {"mountain","floor","common"},
		tiling = 1,
		type = 0,
		layer = 9,
		colour = {1, 2},
	},
	[72] = {
		name = "text_ice",
		unittype = "text",
		tags = {"mountain","floor","common"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 3},
	},
	[73] = {
		name = "jelly",
		unittype = "object",
		tags = {"water","animal","danger"},
		tiling = -1,
		type = 0,
		layer = 17,
		colour = {1, 4},
	},
	[74] = {
		name = "text_jelly",
		unittype = "text",
		tags = {"water","animal","danger"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 3},
		colour_active = {1, 4},
	},
	[75] = {
		name = "keke",
		unittype = "object",
		tags = {"common","animal"},
		tiling = 2,
		type = 0,
		layer = 18,
		colour = {2, 2},
	},
	[76] = {
		name = "text_keke",
		unittype = "text",
		tags = {"common","animal"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[77] = {
		name = "key",
		unittype = "object",
		tags = {"common","item","town"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 4},
	},
	[78] = {
		name = "text_key",
		unittype = "text",
		tags = {"common","item","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {2, 4},
	},
	[79] = {
		name = "ladder",
		unittype = "object",
		tags = {"item","machine","town"},
		tiling = -1,
		type = 0,
		layer = 10,
		colour = {2, 3},
	},
	[80] = {
		name = "text_ladder",
		unittype = "text",
		tags = {"item","machine","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 2},
		colour_active = {2, 3},
	},
	[81] = {
		name = "lava",
		sprite = "water",
		unittype = "object",
		tags = {"obstacle","cave","danger"},
		tiling = 1,
		type = 0,
		layer = 2,
		colour = {2, 3},
	},
	[82] = {
		name = "text_lava",
		unittype = "text",
		tags = {"obstacle","cave","danger"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 2},
		colour_active = {2, 3},
	},
	[83] = {
		name = "leaf",
		unittype = "object",
		tags = {"plant","autumn","decorative"},
		tiling = -1,
		type = 0,
		layer = 8,
		colour = {2, 4},
	},
	[84] = {
		name = "text_leaf",
		unittype = "text",
		tags = {"plant","autumn","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {2, 4},
	},
	[85] = {
		name = "line",
		unittype = "object",
		tags = {"abstract","common"},
		tiling = 1,
		type = 0,
		layer = 20,
		colour = {0, 3},
	},
	[86] = {
		name = "text_line",
		unittype = "text",
		tags = {"abstract","common"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 2},
		colour_active = {0, 3},
	},
	[87] = {
		name = "love",
		unittype = "object",
		tags = {"common","abstract","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {4, 2},
	},
	[88] = {
		name = "text_love",
		unittype = "text",
		tags = {"common","abstract","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 1},
		colour_active = {4, 2},
	},
	[89] = {
		name = "me",
		unittype = "object",
		tags = {"common","animal"},
		tiling = 2,
		type = 0,
		layer = 18,
		colour = {3, 1},
	},
	[90] = {
		name = "text_me",
		unittype = "text",
		tags = {"common","animal"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 0},
		colour_active = {3, 1},
	},
	[91] = {
		name = "moon",
		unittype = "object",
		tags = {"sky","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 4},
	},
	[92] = {
		name = "text_moon",
		unittype = "text",
		tags = {"sky","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {2, 4},
	},
	[93] = {
		name = "orb",
		unittype = "object",
		tags = {"common","item"},
		tiling = -1,
		type = 0,
		layer = 17,
		colour = {4, 1},
	},
	[94] = {
		name = "text_orb",
		unittype = "text",
		tags = {"common","item"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
	},
	[95] = {
		name = "pillar",
		unittype = "object",
		tags = {"ruins","obstacle"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {0, 1},
	},
	[96] = {
		name = "text_pillar",
		unittype = "text",
		tags = {"ruins","obstacle"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 1},
		colour_active = {0, 1},
	},
	[97] = {
		name = "pipe",
		unittype = "object",
		tags = {"machine","obstacle"},
		tiling = 1,
		type = 0,
		layer = 14,
		colour = {1, 1},
	},
	[98] = {
		name = "text_pipe",
		unittype = "text",
		tags = {"machine","obstacle"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 1},
		colour_active = {0, 1},
	},
	[99] = {
		name = "reed",
		unittype = "object",
		tags = {"forest","plant","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {6, 2},
	},
	[100] = {
		name = "text_reed",
		unittype = "text",
		tags = {"forest","plant","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[101] = {
		name = "robot",
		unittype = "object",
		tags = {"machine"},
		tiling = 2,
		type = 0,
		layer = 17,
		colour = {0, 1},
	},
	[102] = {
		name = "text_robot",
		unittype = "text",
		tags = {"machine"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 1},
		colour_active = {0, 1},
	},
	[103] = {
		name = "rocket",
		unittype = "object",
		tags = {"machine","sky"},
		tiling = 0,
		type = 0,
		layer = 15,
		colour = {0, 1},
	},
	[104] = {
		name = "text_rocket",
		unittype = "text",
		tags = {"machine","sky"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 1},
		colour_active = {0, 1},
	},
	[105] = {
		name = "rock",
		unittype = "object",
		tags = {"common","item","cave"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {6, 2},
	},
	[106] = {
		name = "text_rock",
		unittype = "text",
		tags = {"common","item","cave"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 0},
		colour_active = {6, 1},
	},
	[107] = {
		name = "rose",
		unittype = "object",
		tags = {"plant","decorative","forest"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 2},
	},
	[108] = {
		name = "text_rose",
		unittype = "text",
		tags = {"plant","decorative","forest"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[109] = {
		name = "rubble",
		unittype = "object",
		tags = {"mountain","decorative","floor"},
		tiling = 1,
		type = 0,
		layer = 8,
		colour = {6, 0},
	},
	[110] = {
		name = "text_rubble",
		unittype = "text",
		tags = {"mountain","decorative","floor"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 0},
		colour_active = {6, 1},
	},
	[111] = {
		name = "text_x",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[112] = {
		name = "shirt",
		unittype = "object",
		tags = {"item","town"},
		tiling = -1,
		type = 0,
		layer = 15,
		colour = {2, 1},
	},
	[113] = {
		name = "text_shirt",
		unittype = "text",
		tags = {"item","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 1},
		colour_active = {2, 1},
	},
	[114] = {
		name = "skull",
		unittype = "object",
		tags = {"common","danger"},
		tiling = 0,
		type = 0,
		layer = 17,
		colour = {2, 1},
	},
	[115] = {
		name = "text_skull",
		unittype = "text",
		tags = {"common","danger"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 0},
		colour_active = {2, 1},
	},
	[116] = {
		name = "spike",
		unittype = "object",
		tags = {"mountain","decorative","danger"},
		tiling = -1,
		type = 0,
		layer = 10,
		colour = {1, 1},
	},
	[117] = {
		name = "text_spike",
		unittype = "text",
		tags = {"mountain","decorative","danger"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 1},
		colour_active = {0, 1},
	},
	[118] = {
		name = "star",
		unittype = "object",
		tags = {"sky","decorative","item"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 4},
	},
	[119] = {
		name = "text_star",
		unittype = "text",
		tags = {"sky","decorative","item"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {2, 4},
	},
	[120] = {
		name = "statue",
		unittype = "object",
		tags = {"ruins","decorative"},
		tiling = 0,
		type = 0,
		layer = 17,
		colour = {0, 1},
	},
	[121] = {
		name = "text_statue",
		unittype = "text",
		tags = {"ruins","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 2},
	},
	[122] = {
		name = "stump",
		unittype = "object",
		tags = {"ruins","forest","plant","decorative","obstacle"},
		tiling = -1,
		type = 0,
		layer = 12,
		colour = {6, 1},
	},
	[123] = {
		name = "text_stump",
		unittype = "text",
		tags = {"ruins","forest","plant","decorative","obstacle"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 0},
		colour_active = {6, 2},
	},
	[124] = {
		name = "sun",
		unittype = "object",
		tags = {"mountain","decorative","sky"},
		tiling = -1,
		type = 0,
		layer = 14,
		colour = {2, 4},
	},
	[125] = {
		name = "text_sun",
		unittype = "text",
		tags = {"mountain","decorative","sky"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 3},
		colour_active = {2, 4},
	},
	[126] = {
		name = "text_right",
		unittype = "text",
		tags = {"text_quality","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 3},
		colour_active = {1, 4},
	},
	[127] = {
		name = "text_up",
		unittype = "text",
		tags = {"text_quality","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 3},
		colour_active = {1, 4},
	},
	[128] = {
		name = "text_left",
		unittype = "text",
		tags = {"text_quality","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 3},
		colour_active = {1, 4},
	},
	[129] = {
		name = "text_down",
		unittype = "text",
		tags = {"text_quality","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 3},
		colour_active = {1, 4},
	},
	[130] = {
		name = "text_all",
		unittype = "text",
		unpaired = true,
		tags = {"text_special"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[131] = {
		name = "text_and",
		unittype = "text",
		tags = {"text_verb","common"},
		tiling = -1,
		type = 6,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[132] = {
		name = "text_best",
		unittype = "text",
		tags = {"text_quality","decorative"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {2, 3},
		colour_active = {2, 4},
	},
	[133] = {
		name = "text_red",
		unittype = "text",
		tags = {"text_quality","decorative","colour"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[134] = {
		name = "text_blue",
		unittype = "text",
		tags = {"text_quality","decorative","colour"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {3, 2},
		colour_active = {3, 3},
	},
	[135] = {
		name = "text_green",
		unittype = "text",
		tags = {"text_quality","decorative","colour"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 2},
	},
	[136] = {
		name = "text_yellow",
		unittype = "text",
		tags = {"text_quality","decorative","colour"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {6, 1},
		colour_active = {2, 4},
	},
	[137] = {
		name = "text_purple",
		unittype = "text",
		tags = {"text_quality","decorative","colour"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {3, 0},
		colour_active = {3, 1},
	},
	[138] = {
		name = "text_pink",
		unittype = "text",
		tags = {"text_quality","decorative","colour"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
	},
	[139] = {
		name = "text_grey",
		unittype = "text",
		tags = {"text_quality","decorative","colour"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 1},
		colour_active = {0, 1},
	},
	[140] = {
		name = "text_black",
		unittype = "text",
		tags = {"text_quality","decorative","colour"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 1},
		colour_active = {0, 1},
	},
	[141] = {
		name = "text_white",
		unittype = "text",
		tags = {"text_quality","decorative","colour"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[142] = {
		name = "text_brown",
		unittype = "text",
		tags = {"text_quality","decorative","colour"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {2, 1},
		colour_active = {6, 1},
	},
	[143] = {
		name = "text_orange",
		unittype = "text",
		tags = {"text_quality","decorative","colour"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {2, 2},
		colour_active = {2, 3},
	},
	[144] = {
		name = "text_bonus",
		unittype = "text",
		tags = {"common","text_quality","text_special"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
		advanced = true,
	},
	[145] = {
		name = "text_chill",
		unittype = "text",
		tags = {"text_quality","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {3, 2},
		colour_active = {3, 3},
	},
	[146] = {
		name = "text_cursor",
		unittype = "text",
		tags = {"text_special","common"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 3},
		colour_active = {2, 4},
		special = true,
	},
	[147] = {
		name = "text_defeat",
		unittype = "text",
		tags = {"text_quality","danger","common"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {2, 0},
		colour_active = {2, 1},
	},
	[148] = {
		name = "text_eat",
		unittype = "text",
		tags = {"text_verb"},
		tiling = -1,
		type = 1,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[149] = {
		name = "text_empty",
		unittype = "text",
		tags = {"common","abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[150] = {
		name = "text_end",
		unittype = "text",
		tags = {"text_quality","text_special"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[151] = {
		name = "text_facing",
		unittype = "text",
		tags = {"text_condition"},
		tiling = -1,
		type = 7,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		argextra = {"right","up","left","down"},
	},
	[152] = {
		name = "text_back",
		unittype = "text",
		tags = {"text_quality","abstract","text_special","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
		advanced = true,
	},
	[153] = {
		name = "text_fall",
		sprite = "text_falldown",
		unittype = "text",
		tags = {"text_quality","sky","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
	},
	[154] = {
		name = "text_fallright",
		unittype = "text",
		tags = {"text_quality","sky","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
	},
	[155] = {
		name = "text_fallup",
		unittype = "text",
		tags = {"text_quality","sky","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
	},
	[156] = {
		name = "text_fallleft",
		unittype = "text",
		tags = {"text_quality","sky","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
	},
	[157] = {
		name = "text_fear",
		unittype = "text",
		tags = {"text_verb","danger","movement"},
		tiling = -1,
		type = 1,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[158] = {
		name = "text_float",
		unittype = "text",
		tags = {"text_quality","water"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 4},
	},
	[159] = {
		name = "text_follow",
		unittype = "text",
		tags = {"text_verb","movement"},
		tiling = -1,
		type = 1,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
	},
	[160] = {
		name = "text_group",
		unittype = "text",
		tags = {"common","text_special"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 2},
		colour_active = {3, 3},
	},
	[161] = {
		name = "text_has",
		unittype = "text",
		tags = {"text_verb","common"},
		tiling = -1,
		type = 1,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[162] = {
		name = "text_hide",
		unittype = "text",
		tags = {"text_quality","text_special","abstract"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {3, 2},
		colour_active = {3, 3},
	},
	[163] = {
		name = "text_hot",
		unittype = "text",
		tags = {"text_quality","cave","danger","common"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {2, 2},
		colour_active = {2, 3},
		pairedwith = "text_melt",
	},
	[164] = {
		name = "text_idle",
		unittype = "text",
		tags = {"text_condition","text_prefix"},
		tiling = -1,
		type = 3,
		layer = 20,
		colour = {2, 2},
		colour_active = {2, 3},
	},
	[165] = {
		name = "text_is",
		unittype = "text",
		tags = {"text_verb","common"},
		tiling = -1,
		type = 1,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		argtype = {0, 2},
	},
	[166] = {
		name = "text_level",
		unittype = "text",
		tags = {"text_special","common"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
		advanced = true,
	},
	[167] = {
		name = "text_lonely",
		unittype = "text",
		tags = {"text_condition","text_prefix","mountain"},
		tiling = -1,
		type = 3,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[168] = {
		name = "text_often",
		unittype = "text",
		tags = {"text_condition","text_prefix","abstract","common"},
		tiling = -1,
		type = 3,
		layer = 20,
		colour = {5, 2},
		colour_active = {5, 3},
	},
	[169] = {
		name = "text_seldom",
		unittype = "text",
		tags = {"text_condition","text_prefix","abstract","common"},
		tiling = -1,
		type = 3,
		layer = 20,
		colour = {3, 2},
		colour_active = {3, 3},
	},
	[170] = {
		name = "text_make",
		unittype = "text",
		tags = {"text_verb","common"},
		tiling = -1,
		type = 1,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[171] = {
		name = "text_melt",
		unittype = "text",
		tags = {"text_quality","cave","danger","common"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 3},
		pairedwith = "text_hot",
	},
	[172] = {
		name = "text_more",
		unittype = "text",
		tags = {"text_quality","abstract","common"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
	},
	[173] = {
		name = "text_move",
		unittype = "text",
		tags = {"text_quality","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
	},
	[174] = {
		name = "text_near",
		unittype = "text",
		tags = {"text_condition","common"},
		tiling = -1,
		type = 7,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[175] = {
		name = "text_not",
		unittype = "text",
		tags = {"text_special","common"},
		tiling = -1,
		type = 4,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[176] = {
		name = "text_on",
		unittype = "text",
		tags = {"text_condition","common"},
		tiling = -1,
		type = 7,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[177] = {
		name = "text_open",
		unittype = "text",
		tags = {"text_quality","common","obstacle"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {6, 1},
		colour_active = {2, 4},
		pairedwith = "text_shut",
	},
	[178] = {
		name = "text_you2",
		unittype = "text",
		tags = {"text_quality","text_special","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
		advanced = true,
	},
	[179] = {
		name = "text_play",
		unittype = "text",
		tags = {"text_verb","common","music"},
		tiling = -1,
		type = 1,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
		argtype = {8},
		customobjects = 
			{
			"c","csharp","cflat","d","dsharp","dflat","e","esharp","eflat","f","fsharp","fflat","g","gsharp","gflat","a","asharp","aflat","b","bsharp","bflat",
			"c4","csharp4","cflat4","d4","dsharp4","dflat4","e4","esharp4","eflat4","f4","fsharp4","fflat4","g4","gsharp4","gflat4","a4","asharp4","aflat4","b4","bsharp4","bflat4",
			"c5","csharp5","cflat5","d5","dsharp5","dflat5","e5","esharp5","eflat5","f5","fsharp5","fflat5","g5","gsharp5","gflat5","a5","asharp5","aflat5","b5","bsharp5","bflat5",
			"c6","csharp6","d6","dsharp6","dflat6","e6","esharp6","eflat6","f6","fsharp6","fflat6","g6","gsharp6","gflat6","a6","aflat6",
			},
		--redacted = true,
	},
	[180] = {
		name = "text_powered",
		unittype = "text",
		tags = {"text_condition","text_prefix","machine"},
		tiling = -1,
		type = 3,
		layer = 20,
		colour = {6, 1},
		colour_active = {2, 4},
		pairedwith = "text_power",
	},
	[181] = {
		name = "text_power",
		unittype = "text",
		tags = {"text_quality","machine"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {6, 1},
		colour_active = {2, 4},
		pairedwith = "text_powered",
	},
	[182] = {
		name = "text_pull",
		unittype = "text",
		tags = {"text_quality","common","obstacle","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[183] = {
		name = "text_push",
		unittype = "text",
		tags = {"text_quality","common","obstacle","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {6, 0},
		colour_active = {6, 1},
	},
	[184] = {
		name = "text_sad",
		unittype = "text",
		tags = {"text_quality","decorative"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 1},
		colour_active = {3, 2},
	},
	[185] = {
		name = "text_safe",
		unittype = "text",
		tags = {"text_quality","common"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[186] = {
		name = "text_shift",
		unittype = "text",
		tags = {"text_quality","common","machine","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 3},
	},
	[187] = {
		name = "text_shut",
		unittype = "text",
		tags = {"text_quality","common","obstacle"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
		pairedwith = "text_open",
	},
	[188] = {
		name = "text_sink",
		unittype = "text",
		tags = {"text_quality","common","obstacle","water","danger"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 3},
	},
	[189] = {
		name = "text_sleep",
		unittype = "text",
		tags = {"text_quality","sky","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 3},
		colour_active = {1, 4},
	},
	[190] = {
		name = "text_stop",
		unittype = "text",
		tags = {"text_quality","common","movement","obstacle"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {5, 0},
		colour_active = {5, 1},
	},
	[191] = {
		name = "text_swap",
		unittype = "text",
		tags = {"text_quality","abstract","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {3, 0},
		colour_active = {3, 1},
	},
	[192] = {
		name = "text_tele",
		unittype = "text",
		tags = {"text_quality","abstract","machine","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 4},
	},
	[193] = {
		name = "text_text",
		unittype = "text",
		tags = {"text_special","common","abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
	},
	[194] = {
		name = "tile",
		unittype = "object",
		tags = {"common","floor","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 4,
		colour = {0, 0},
	},
	[195] = {
		name = "text_tile",
		unittype = "text",
		tags = {"common","floor","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 1},
		colour_active = {0, 1},
	},
	[196] = {
		name = "tree",
		unittype = "object",
		tags = {"forest","plant","obstacle"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {5, 2},
	},
	[197] = {
		name = "text_tree",
		unittype = "text",
		tags = {"forest","plant","obstacle"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 2},
	},
	[198] = {
		name = "ufo",
		unittype = "object",
		tags = {"sky","machine"},
		tiling = -1,
		type = 0,
		layer = 17,
		colour = {4, 2},
	},
	[199] = {
		name = "text_ufo",
		unittype = "text",
		tags = {"sky","machine"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
	},
	[200] = {
		name = "wall",
		unittype = "object",
		tags = {"common","obstacle","town"},
		tiling = 1,
		type = 0,
		layer = 14,
		colour = {1, 1},
	},
	[201] = {
		name = "text_wall",
		unittype = "text",
		tags = {"common","obstacle","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 1},
		colour_active = {0, 1},
	},
	[202] = {
		name = "water",
		unittype = "object",
		tags = {"water","obstacle","danger"},
		tiling = 1,
		type = 0,
		layer = 2,
		colour = {1, 3},
	},
	[203] = {
		name = "text_water",
		unittype = "text",
		tags = {"water","obstacle","danger"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 3},
	},
	[204] = {
		name = "text_weak",
		unittype = "text",
		tags = {"text_quality","danger"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 1},
		colour_active = {1, 2},
	},
	[205] = {
		name = "text_win",
		unittype = "text",
		tags = {"text_quality","common"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {6, 1},
		colour_active = {2, 4},
	},
	[206] = {
		name = "text_without",
		unittype = "text",
		tags = {"text_condition","common"},
		tiling = -1,
		type = 7,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[207] = {
		name = "text_wonder",
		unittype = "text",
		tags = {"text_quality","decorative"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[208] = {
		name = "text_word",
		unittype = "text",
		tags = {"text_quality","text_special"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {0, 2},
		colour_active = {0, 3},
		advanced = true,
	},
	[209] = {
		name = "text_you",
		unittype = "text",
		tags = {"text_quality","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
	},
	[210] = {
		name = "husks",
		unittype = "object",
		tags = {"plant","autumn","decorative"},
		tiling = -1,
		type = 0,
		layer = 9,
		colour = {6, 1},
	},
	[211] = {
		name = "trees",
		unittype = "object",
		tags = {"forest","plant","decorative"},
		tiling = -1,
		type = 0,
		layer = 9,
		colour = {5, 2},
	},
	[212] = {
		name = "text_a",
		unittype = "text",
		tags = {"text_letter","music"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[213] = {
		name = "text_b",
		unittype = "text",
		tags = {"text_letter","music"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[214] = {
		name = "text_c",
		unittype = "text",
		tags = {"text_letter","music"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[215] = {
		name = "text_d",
		unittype = "text",
		tags = {"text_letter","music"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[216] = {
		name = "text_e",
		unittype = "text",
		tags = {"text_letter","music"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[217] = {
		name = "text_f",
		unittype = "text",
		tags = {"text_letter","music"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[218] = {
		name = "text_g",
		unittype = "text",
		tags = {"text_letter","music"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[219] = {
		name = "text_h",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[220] = {
		name = "text_i",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[221] = {
		name = "text_l",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[222] = {
		name = "text_m",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[223] = {
		name = "text_n",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[224] = {
		name = "text_o",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[225] = {
		name = "text_r",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[226] = {
		name = "text_s",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[227] = {
		name = "text_t",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[228] = {
		name = "text_u",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[229] = {
		name = "text_v",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[230] = {
		name = "text_j",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[231] = {
		name = "text_k",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[232] = {
		name = "text_p",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[233] = {
		name = "text_q",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[234] = {
		name = "text_y",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[235] = {
		name = "text_z",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[236] = {
		name = "text_broken",
		unittype = "text",
		tags = {"text_quality","abstract"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
		advanced = true,
	},
	[237] = {
		name = "text_nudgeright",
		unittype = "text",
		tags = {"text_quality","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
		advanced = true,
	},
	[238] = {
		name = "text_nudgeup",
		unittype = "text",
		tags = {"text_quality","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
		advanced = true,
	},
	[239] = {
		name = "text_nudgeleft",
		unittype = "text",
		tags = {"text_quality","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
		advanced = true,
	},
	[240] = {
		name = "text_nudgedown",
		unittype = "text",
		tags = {"text_quality","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
		advanced = true,
	},
	[241] = {
		name = "text_turn",
		unittype = "text",
		tags = {"text_quality","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 4},
		pairedwith = "text_deturn",
	},
	[242] = {
		name = "text_deturn",
		unittype = "text",
		tags = {"text_quality","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 4},
		pairedwith = "text_turn",
	},
	[243] = {
		name = "text_done",
		unittype = "text",
		tags = {"text_quality","text_special"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[244] = {
		name = "text_mimic",
		unittype = "text",
		tags = {"text_verb","abstract"},
		tiling = -1,
		type = 1,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
		advanced = true,
	},
	[245] = {
		name = "sign",
		unittype = "object",
		tags = {"common","item","town"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {6, 1},
	},
	[246] = {
		name = "text_sign",
		unittype = "text",
		tags = {"common","item","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[247] = {
		name = "text_still",
		unittype = "text",
		tags = {"text_quality","abstract","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
		advanced = true,
	},
	[248] = {
		name = "circle",
		unittype = "object",
		tags = {"item","abstract"},
		tiling = -1,
		type = 0,
		layer = 17,
		colour = {5, 3},
	},
	[249] = {
		name = "text_circle",
		unittype = "text",
		tags = {"item","abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
	},
	[250] = {
		name = "square",
		unittype = "object",
		tags = {"item","abstract"},
		tiling = -1,
		type = 0,
		layer = 17,
		colour = {4, 1},
	},
	[251] = {
		name = "text_square",
		unittype = "text",
		tags = {"item","abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
	},
	[252] = {
		name = "triangle",
		unittype = "object",
		tags = {"item","abstract"},
		tiling = -1,
		type = 0,
		layer = 17,
		colour = {3, 2},
	},
	[253] = {
		name = "text_triangle",
		unittype = "text",
		tags = {"item","abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 2},
		colour_active = {3, 3},
	},
	[254] = {
		name = "crystal",
		unittype = "object",
		tags = {"cave","obstacle","item"},
		tiling = 0,
		type = 0,
		layer = 16,
		colour = {4, 2},
	},
	[255] = {
		name = "text_crystal",
		unittype = "text",
		tags = {"cave","obstacle","item"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 1},
		colour_active = {4, 2},
	},
	[256] = {
		name = "foot",
		unittype = "object",
		tags = {"abstract"},
		tiling = 0,
		type = 0,
		layer = 17,
		colour = {3, 1},
	},
	[257] = {
		name = "text_foot",
		unittype = "text",
		tags = {"abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 1},
		colour_active = {4, 2},
	},
	[258] = {
		name = "eye",
		unittype = "object",
		tags = {"abstract"},
		tiling = 2,
		type = 0,
		layer = 19,
		colour = {3, 1},
	},
	[259] = {
		name = "text_eye",
		unittype = "text",
		tags = {"abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 1},
		colour_active = {4, 2},
	},
	[260] = {
		name = "worm",
		unittype = "object",
		tags = {"forest","animal"},
		tiling = 2,
		type = 0,
		layer = 19,
		colour = {0, 3},
	},
	[261] = {
		name = "text_worm",
		unittype = "text",
		tags = {"forest","animal"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[262] = {
		name = "text_above",
		unittype = "text",
		tags = {"text_condition","common"},
		tiling = -1,
		type = 7,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 4},
		advanced = true,
	},
	[263] = {
		name = "text_below",
		unittype = "text",
		tags = {"text_condition","common"},
		tiling = -1,
		type = 7,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 4},
		advanced = true,
	},
	[264] = {
		name = "text_select",
		unittype = "text",
		tags = {"text_quality","text_special","common"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {2, 3},
		colour_active = {2, 4},
	},
	[265] = {
		name = "gem",
		unittype = "object",
		tags = {"item","cave","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {4, 2},
	},
	[266] = {
		name = "text_gem",
		unittype = "text",
		tags = {"item","cave","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 1},
		colour_active = {4, 2},
	},
	[267] = {
		name = "text_husks",
		unittype = "text",
		tags = {"plant","autumn","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {6, 1},
	},
	[268] = {
		name = "text_trees",
		unittype = "text",
		tags = {"forest","plant","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 2},
	},
	[269] = {
		name = "text_feeling",
		unittype = "text",
		tags = {"text_condition"},
		tiling = -1,
		type = 7,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		argtype = {2},
	},
	[270] = {
		name = "text_cyan",
		unittype = "text",
		tags = {"text_quality","decorative","colour"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 4},
	},
	[271] = {
		name = "track",
		unittype = "object",
		tags = {"machine","floor","town"},
		tiling = 1,
		type = 0,
		layer = 9,
		colour = {6, 0},
	},
	[272] = {
		name = "text_track",
		unittype = "text",
		tags = {"machine","floor","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 0},
		colour_active = {6, 1},
	},
	[273] = {
		name = "train",
		unittype = "object",
		tags = {"machine","item","danger","town"},
		tiling = 0,
		type = 0,
		layer = 18,
		colour = {5, 2},
	},
	[274] = {
		name = "text_train",
		unittype = "text",
		tags = {"machine","item","danger","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 2},
	},
	[275] = {
		name = "text_rosy",
		unittype = "text",
		tags = {"text_quality","decorative","colour"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {4, 1},
		colour_active = {4, 2},
	},
	[276] = {
		name = "text_lime",
		unittype = "text",
		tags = {"text_quality","decorative","colour"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
	},
	[277] = {
		name = "text_silver",
		unittype = "text",
		tags = {"text_quality","decorative","colour"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 2},
	},
	[278] = {
		name = "ring",
		unittype = "object",
		tags = {"item","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 17,
		colour = {2, 4},
	},
	[279] = {
		name = "text_ring",
		unittype = "text",
		tags = {"item","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 3},
		colour_active = {2, 4},
	},
	[280] = {
		name = "arrow",
		unittype = "object",
		tags = {"abstract","movement"},
		tiling = 0,
		type = 0,
		layer = 9,
		colour = {5, 2},
	},
	[281] = {
		name = "text_arrow",
		unittype = "text",
		tags = {"abstract","movement"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 2},
	},
	[282] = {
		name = "cart",
		unittype = "object",
		tags = {"machine","item","danger","town"},
		tiling = 0,
		type = 0,
		layer = 18,
		colour = {5, 2},
	},
	[283] = {
		name = "text_cart",
		unittype = "text",
		tags = {"machine","item","danger","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 2},
	},
	[284] = {
		name = "book",
		unittype = "object",
		tags = {"item","ruins","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 3},
	},
	[285] = {
		name = "text_book",
		unittype = "text",
		tags = {"item","ruins","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {2, 3},
	},
	[286] = {
		name = "tower",
		unittype = "object",
		tags = {"ruins","obstacle","town"},
		tiling = -1,
		type = 0,
		layer = 17,
		colour = {0, 1},
	},
	[287] = {
		name = "text_tower",
		unittype = "text",
		tags = {"ruins","obstacle","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 1},
		colour_active = {0, 1},
	},
	[288] = {
		name = "seed",
		unittype = "object",
		tags = {"forest","plant","item"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {6, 2},
	},
	[289] = {
		name = "text_seed",
		unittype = "text",
		tags = {"forest","plant","item"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[290] = {
		name = "sprout",
		unittype = "object",
		tags = {"forest","plant","item"},
		tiling = -1,
		type = 0,
		layer = 17,
		colour = {5, 3},
	},
	[291] = {
		name = "text_sprout",
		unittype = "text",
		tags = {"forest","plant","item"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
	},
	[292] = {
		name = "jiji",
		unittype = "object",
		tags = {"animal","common"},
		tiling = 2,
		type = 0,
		layer = 18,
		colour = {2, 3},
	},
	[293] = {
		name = "text_jiji",
		unittype = "text",
		tags = {"animal","common"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 2},
		colour_active = {2, 3},
	},
	[294] = {
		name = "fofo",
		unittype = "object",
		tags = {"animal","common"},
		tiling = 2,
		type = 0,
		layer = 18,
		colour = {5, 2},
	},
	[295] = {
		name = "text_fofo",
		unittype = "text",
		tags = {"animal","common"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 2},
	},
	[296] = {
		name = "vine",
		unittype = "object",
		tags = {"obstacle","decorative","forest","plant"},
		tiling = 1,
		type = 0,
		layer = 15,
		colour = {5, 2},
	},
	[297] = {
		name = "text_vine",
		unittype = "text",
		tags = {"obstacle","decorative","forest","plant"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 2},
	},
	[298] = {
		name = "wind",
		unittype = "object",
		tags = {"abstract","movement","mountain","sky"},
		tiling = 0,
		type = 0,
		layer = 8,
		colour = {1, 4},
	},
	[299] = {
		name = "text_wind",
		unittype = "text",
		tags = {"abstract","movement","mountain","sky"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 3},
		colour_active = {1, 4},
	},
	[300] = {
		name = "fort",
		unittype = "object",
		tags = {"obstacle","ruins","town"},
		tiling = 1,
		type = 0,
		layer = 16,
		colour = {1, 1},
	},
	[301] = {
		name = "text_fort",
		unittype = "text",
		tags = {"obstacle","ruins","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 1},
		colour_active = {0, 1},
	},
	[302] = {
		name = "text_auto",
		unittype = "text",
		tags = {"text_quality","movement","text_special"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
	},
	[303] = {
		name = "bee",
		unittype = "object",
		tags = {"animal","forest"},
		tiling = 0,
		type = 0,
		layer = 17,
		colour = {2, 4},
	},
	[304] = {
		name = "text_bee",
		unittype = "text",
		tags = {"animal","forest"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {2, 4},
	},
	[305] = {
		name = "pants",
		unittype = "object",
		tags = {"item","town"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {3, 2},
	},
	[306] = {
		name = "text_pants",
		unittype = "text",
		tags = {"item","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 2},
		colour_active = {3, 3},
	},
	[307] = {
		name = "text_0",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[308] = {
		name = "text_1",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[309] = {
		name = "text_2",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[310] = {
		name = "text_3",
		unittype = "text",
		tags = {"text_letter","music"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[311] = {
		name = "text_4",
		unittype = "text",
		tags = {"text_letter","music"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[312] = {
		name = "text_5",
		unittype = "text",
		tags = {"text_letter","music"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[313] = {
		name = "text_6",
		unittype = "text",
		tags = {"text_letter","music"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[314] = {
		name = "text_7",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[315] = {
		name = "text_8",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[316] = {
		name = "text_9",
		unittype = "text",
		tags = {"text_letter"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[317] = {
		name = "text_sharp",
		unittype = "text",
		tags = {"text_letter","music"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[318] = {
		name = "text_flat",
		unittype = "text",
		tags = {"text_letter","music"},
		tiling = -1,
		type = 5,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[319] = {
		name = "text_revert",
		unittype = "text",
		tags = {"text_quality","text_special"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {2, 2},
		colour_active = {2, 3},
		advanced = true,
	},
	[320] = {
		name = "lizard",
		unittype = "object",
		tags = {"animal","forest","cave"},
		tiling = 2,
		type = 0,
		layer = 19,
		colour = {2, 2},
	},
	[321] = {
		name = "text_lizard",
		unittype = "text",
		tags = {"animal","forest","cave"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[322] = {
		name = "shell",
		unittype = "object",
		tags = {"animal","water","item"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {4, 2},
	},
	[323] = {
		name = "text_shell",
		unittype = "text",
		tags = {"animal","water","item"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 1},
		colour_active = {4, 2},
	},
	[324] = {
		name = "fish",
		unittype = "object",
		tags = {"animal","water","movement"},
		tiling = 0,
		type = 0,
		layer = 17,
		colour = {1, 3},
	},
	[325] = {
		name = "text_fish",
		unittype = "text",
		tags = {"animal","water","movement"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 3},
	},
	[326] = {
		name = "house",
		unittype = "object",
		tags = {"obstacle","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {6, 1},
	},
	[327] = {
		name = "text_house",
		unittype = "text",
		tags = {"obstacle","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[328] = {
		name = "gate",
		unittype = "object",
		tags = {"obstacle","decorative","ruins"},
		tiling = -1,
		type = 0,
		layer = 15,
		colour = {2, 2},
	},
	[329] = {
		name = "text_gate",
		unittype = "text",
		tags = {"obstacle","decorative","ruins"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[330] = {
		name = "boat",
		unittype = "object",
		tags = {"water","movement","machine","decorative"},
		tiling = 0,
		type = 0,
		layer = 16,
		colour = {6, 1},
	},
	[331] = {
		name = "text_boat",
		unittype = "text",
		tags = {"water","movement","machine","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[332] = {
		name = "pumpkin",
		unittype = "object",
		tags = {"plant","autumn","decorative"},
		tiling = 0,
		type = 0,
		layer = 16,
		colour = {2, 3},
	},
	[333] = {
		name = "text_pumpkin",
		unittype = "text",
		tags = {"plant","autumn","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {2, 3},
	},
	[334] = {
		name = "lamp",
		unittype = "object",
		tags = {"item","autumn","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 4},
	},
	[335] = {
		name = "text_lamp",
		unittype = "text",
		tags = {"item","autumn","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 2},
		colour_active = {2, 4},
	},
	[336] = {
		name = "lift",
		unittype = "object",
		tags = {"machine","movement","town"},
		tiling = 0,
		type = 0,
		layer = 17,
		colour = {0, 1},
	},
	[337] = {
		name = "text_lift",
		unittype = "text",
		tags = {"machine","movement","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 2},
	},
	[338] = {
		name = "ear",
		unittype = "object",
		tags = {"abstract"},
		tiling = 0,
		type = 0,
		layer = 18,
		colour = {3, 1},
	},
	[339] = {
		name = "text_ear",
		unittype = "text",
		tags = {"abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 1},
		colour_active = {4, 2},
	},
	[340] = {
		name = "nose",
		unittype = "object",
		tags = {"abstract"},
		tiling = 0,
		type = 0,
		layer = 18,
		colour = {3, 1},
	},
	[341] = {
		name = "text_nose",
		unittype = "text",
		tags = {"abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 1},
		colour_active = {4, 2},
	},
	[342] = {
		name = "monitor",
		unittype = "object",
		tags = {"machine","item","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {0, 1},
	},
	[343] = {
		name = "text_monitor",
		unittype = "text",
		tags = {"machine","item","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 2},
	},
	[344] = {
		name = "stick",
		unittype = "object",
		tags = {"item","decorative","forest"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {6, 1},
	},
	[345] = {
		name = "text_stick",
		unittype = "text",
		tags = {"item","decorative","forest"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[346] = {
		name = "bucket",
		unittype = "object",
		tags = {"item","decorative","cave"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 2},
	},
	[347] = {
		name = "text_bucket",
		unittype = "text",
		tags = {"item","decorative","cave"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[348] = {
		name = "shovel",
		unittype = "object",
		tags = {"item","decorative","cave"},
		tiling = 0,
		type = 0,
		layer = 16,
		colour = {3, 1},
	},
	[349] = {
		name = "text_shovel",
		unittype = "text",
		tags = {"item","decorative","cave"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 1},
		colour_active = {4, 2},
	},
	[350] = {
		name = "it",
		unittype = "object",
		tags = {"common","animal"},
		tiling = 2,
		type = 0,
		layer = 18,
		colour = {1, 4},
	},
	[351] = {
		name = "text_it",
		unittype = "text",
		tags = {"common","animal"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 4},
	},
	[352] = {
		name = "plane",
		unittype = "object",
		tags = {"sky","movement","machine"},
		tiling = 0,
		type = 0,
		layer = 16,
		colour = {2, 2},
	},
	[353] = {
		name = "text_plane",
		unittype = "text",
		tags = {"sky","movement","machine"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[354] = {
		name = "text_lockeddown",
		unittype = "text",
		tags = {"text_quality","abstract","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {4, 1},
		colour_active = {4, 2},
		advanced = true,
	},
	[355] = {
		name = "text_lockedright",
		unittype = "text",
		tags = {"text_quality","abstract","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {4, 1},
		colour_active = {4, 2},
		advanced = true,
	},
	[356] = {
		name = "text_lockedup",
		unittype = "text",
		tags = {"text_quality","abstract","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {4, 1},
		colour_active = {4, 2},
		advanced = true,
	},
	[357] = {
		name = "text_lockedleft",
		unittype = "text",
		tags = {"text_quality","abstract","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {4, 1},
		colour_active = {4, 2},
		advanced = true,
	},
	[358] = {
		name = "text_phantom",
		unittype = "text",
		tags = {"text_quality","abstract","movement","obstacle"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {1, 1},
		colour_active = {0, 1},
		advanced = true,
	},
	[359] = {
		name = "planet",
		unittype = "object",
		tags = {"sky","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 3},
	},
	[360] = {
		name = "text_planet",
		unittype = "text",
		tags = {"sky","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 2},
		colour_active = {2, 3},
	},
	[361] = {
		name = "road",
		unittype = "object",
		tags = {"floor","decorative","town"},
		tiling = 1,
		type = 0,
		layer = 7,
		colour = {0, 1},
	},
	[362] = {
		name = "text_road",
		unittype = "text",
		tags = {"floor","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 2},
	},
	[363] = {
		name = "banana",
		unittype = "object",
		tags = {"plant","forest","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 4},
	},
	[364] = {
		name = "text_banana",
		unittype = "text",
		tags = {"plant","forest","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 2},
		colour_active = {2, 4},
	},
	[365] = {
		name = "burger",
		unittype = "object",
		tags = {"town","item","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 3},
	},
	[366] = {
		name = "text_burger",
		unittype = "text",
		tags = {"town","item","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {2, 3},
	},
	[367] = {
		name = "drink",
		unittype = "object",
		tags = {"town","item","decorative","water"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {4, 4},
	},
	[368] = {
		name = "text_drink",
		unittype = "text",
		tags = {"town","item","decorative","water"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 2},
		colour_active = {4, 4},
	},
	[369] = {
		name = "turnip",
		unittype = "object",
		tags = {"plant","forest","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {6, 2},
	},
	[370] = {
		name = "text_turnip",
		unittype = "text",
		tags = {"plant","forest","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[371] = {
		name = "pixel",
		unittype = "object",
		tags = {"obstacle","abstract"},
		tiling = -1,
		type = 0,
		layer = 9,
		colour = {0, 3},
	},
	[372] = {
		name = "text_pixel",
		unittype = "text",
		tags = {"obstacle","abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[373] = {
		name = "guitar",
		unittype = "object",
		tags = {"item","decorative","music"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {6, 2},
	},
	[374] = {
		name = "text_guitar",
		unittype = "text",
		tags = {"item","decorative","music"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[375] = {
		name = "piano",
		unittype = "object",
		tags = {"item","decorative","music"},
		tiling = 0,
		type = 0,
		layer = 16,
		colour = {1, 3},
	},
	[376] = {
		name = "text_piano",
		unittype = "text",
		tags = {"item","decorative","music"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 3},
	},
	[377] = {
		name = "sax",
		unittype = "object",
		tags = {"item","decorative","music"},
		tiling = 0,
		type = 0,
		layer = 16,
		colour = {3, 4},
	},
	[378] = {
		name = "text_sax",
		unittype = "text",
		tags = {"item","decorative","music"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {3, 4},
	},
	[379] = {
		name = "blob",
		unittype = "object",
		tags = {"obstacle","danger"},
		tiling = 1,
		type = 0,
		layer = 8,
		colour = {5, 2},
	},
	[380] = {
		name = "text_blob",
		unittype = "text",
		tags = {"obstacle","danger"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 2},
	},
	[381] = {
		name = "drum",
		unittype = "object",
		tags = {"item","decorative","music"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 3},
	},
	[382] = {
		name = "text_drum",
		unittype = "text",
		tags = {"item","decorative","music"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 2},
		colour_active = {2, 3},
	},
	[383] = {
		name = "hihat",
		unittype = "object",
		tags = {"item","decorative","music"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 4},
	},
	[384] = {
		name = "text_hihat",
		unittype = "text",
		tags = {"item","decorative","music"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {2, 4},
	},
	[385] = {
		name = "text_group2",
		unittype = "text",
		tags = {"common","text_special"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[386] = {
		name = "text_group3",
		unittype = "text",
		tags = {"common","text_special"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 2},
		colour_active = {5, 3},
	},
	[387] = {
		name = "text_party",
		unittype = "text",
		tags = {"text_quality","decorative"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {2, 2},
		colour_active = {2, 3},
	},
	[388] = {
		name = "potato",
		unittype = "object",
		tags = {"plant","forest","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {6, 1},
	},
	[389] = {
		name = "text_potato",
		unittype = "text",
		tags = {"plant","forest","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[390] = {
		name = "text_pet",
		unittype = "text",
		tags = {"text_quality","decorative"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {3, 1},
		colour_active = {4, 2},
	},
	[391] = {
		name = "donut",
		unittype = "object",
		tags = {"item","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {4, 1},
	},
	[392] = {
		name = "text_donut",
		unittype = "text",
		tags = {"item","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 1},
		colour_active = {4, 2},
	},
	[393] = {
		name = "text_reverse",
		unittype = "text",
		tags = {"text_quality","common","movement"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {5, 2},
		colour_active = {5, 3},
	},
	[394] = {
		name = "text_besideleft",
		unittype = "text",
		tags = {"text_condition","common"},
		tiling = -1,
		type = 7,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 4},
		advanced = true,
	},
	[395] = {
		name = "text_besideright",
		unittype = "text",
		tags = {"text_condition","common"},
		tiling = -1,
		type = 7,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 4},
		advanced = true,
	},
	[396] = {
		name = "frog",
		unittype = "object",
		tags = {"water","animal"},
		tiling = 2,
		type = 0,
		layer = 18,
		colour = {5, 3},
	},
	[397] = {
		name = "text_frog",
		unittype = "text",
		tags = {"water","animal"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
	},
	[398] = {
		name = "trumpet",
		unittype = "object",
		tags = {"item","decorative","music"},
		tiling = 0,
		type = 0,
		layer = 16,
		colour = {3, 4},
	},
	[399] = {
		name = "text_trumpet",
		unittype = "text",
		tags = {"item","decorative","music"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 3},
		colour_active = {2, 4},
	},
	[400] = {
		name = "pawn",
		unittype = "object",
		tags = {"item","decorative"},
		tiling = -1,
		type = 0,
		layer = 17,
		colour = {2, 2},
	},
	[401] = {
		name = "text_pawn",
		unittype = "text",
		tags = {"item","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[402] = {
		name = "knight",
		unittype = "object",
		tags = {"item","decorative"},
		tiling = -1,
		type = 0,
		layer = 17,
		colour = {2, 2},
	},
	[403] = {
		name = "text_knight",
		unittype = "text",
		tags = {"item","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[404] = {
		name = "turtle",
		unittype = "object",
		tags = {"water","animal","forest"},
		tiling = 2,
		type = 0,
		layer = 18,
		colour = {5, 4},
	},
	[405] = {
		name = "text_turtle",
		unittype = "text",
		tags = {"water","animal","forest"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 2},
		colour_active = {5, 4},
	},
	[406] = {
		name = "cat",
		unittype = "object",
		tags = {"animal","forest","town"},
		tiling = 2,
		type = 0,
		layer = 18,
		colour = {6, 2},
	},
	[407] = {
		name = "text_cat",
		unittype = "text",
		tags = {"animal","forest","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[408] = {
		name = "sword",
		unittype = "object",
		tags = {"item","decorative","danger"},
		tiling = 0,
		type = 0,
		layer = 16,
		colour = {1, 4},
	},
	[409] = {
		name = "text_sword",
		unittype = "text",
		tags = {"item","decorative","danger"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 4},
	},
	[410] = {
		name = "clock",
		unittype = "object",
		tags = {"item","decorative","town"},
		tiling = 4,
		type = 0,
		layer = 16,
		colour = {3, 3},
	},
	[411] = {
		name = "text_clock",
		unittype = "text",
		tags = {"item","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 2},
		colour_active = {3, 3},
	},
	[412] = {
		name = "bed",
		unittype = "object",
		tags = {"item","decorative","town"},
		tiling = 0,
		type = 0,
		layer = 16,
		colour = {0, 3},
	},
	[413] = {
		name = "text_bed",
		unittype = "text",
		tags = {"item","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[414] = {
		name = "pizza",
		unittype = "object",
		tags = {"item","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 3},
	},
	[415] = {
		name = "text_pizza",
		unittype = "text",
		tags = {"item","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 2},
		colour_active = {2, 3},
	},
	[416] = {
		name = "vase",
		unittype = "object",
		tags = {"item","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {0, 2},
	},
	[417] = {
		name = "text_vase",
		unittype = "text",
		tags = {"item","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 2},
	},
	[418] = {
		name = "bottle",
		unittype = "object",
		tags = {"item","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {1, 4},
	},
	[419] = {
		name = "text_bottle",
		unittype = "text",
		tags = {"item","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 2},
		colour_active = {1, 4},
	},
	[420] = {
		name = "car",
		unittype = "object",
		tags = {"machine","danger","town"},
		tiling = 0,
		type = 0,
		layer = 17,
		colour = {2, 2},
	},
	[421] = {
		name = "text_car",
		unittype = "text",
		tags = {"machine","danger","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[422] = {
		name = "egg",
		unittype = "object",
		tags = {"item","decorative","animal","forest"},
		tiling = 0,
		type = 0,
		layer = 16,
		colour = {0, 3},
	},
	[423] = {
		name = "text_egg",
		unittype = "text",
		tags = {"item","decorative","animal","forest"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[424] = {
		name = "plank",
		unittype = "object",
		tags = {"floor","town"},
		tiling = 1,
		type = 0,
		layer = 8,
		colour = {6, 0},
	},
	[425] = {
		name = "text_plank",
		unittype = "text",
		tags = {"floor","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[426] = {
		name = "dog",
		unittype = "object",
		tags = {"animal","forest","town"},
		tiling = 2,
		type = 0,
		layer = 18,
		colour = {0, 2},
	},
	[427] = {
		name = "text_dog",
		unittype = "text",
		tags = {"animal","forest","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 2},
	},
	[428] = {
		name = "mirror",
		unittype = "object",
		tags = {"item","decorative","town","ruins"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {4, 4},
	},
	[429] = {
		name = "text_mirror",
		unittype = "text",
		tags = {"item","decorative","town","ruins"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 2},
		colour_active = {4, 4},
	},
	[430] = {
		name = "lily",
		unittype = "object",
		tags = {"water","decorative","plant"},
		tiling = -1,
		type = 0,
		layer = 9,
		colour = {5, 2},
	},
	[431] = {
		name = "text_lily",
		unittype = "text",
		tags = {"water","decorative","plant"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 2},
	},
	[432] = {
		name = "text_3d",
		unittype = "text",
		tags = {"abstract","text_special","text_quality"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
		advanced = true,
	},
	[433] = {
		name = "lock",
		unittype = "object",
		tags = {"common","obstacle","item"},
		tiling = -1,
		type = 0,
		layer = 14,
		colour = {0, 2},
	},
	[434] = {
		name = "text_lock",
		unittype = "text",
		tags = {"common","obstacle","item"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 2},
	},
	[435] = {
		name = "boba",
		unittype = "object",
		tags = {"decorative","town","item"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {6, 2},
	},
	[436] = {
		name = "text_boba",
		unittype = "text",
		tags = {"decorative","town","item"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[437] = {
		name = "badbad",
		unittype = "object",
		tags = {"animal","common"},
		tiling = 2,
		type = 0,
		layer = 18,
		colour = {1, 4},
	},
	[438] = {
		name = "text_badbad",
		unittype = "text",
		tags = {"animal","common"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {1, 3},
		colour_active = {1, 4},
	},
	[439] = {
		name = "what",
		unittype = "object",
		tags = {"decorative","abstract"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {0, 3},
	},
	[440] = {
		name = "text_what",
		unittype = "text",
		tags = {"decorative","abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[441] = {
		name = "text_boom",
		unittype = "text",
		tags = {"text_quality","danger"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
		advanced = true,
	},
	[442] = {
		name = "text_nextto",
		unittype = "text",
		tags = {"text_condition","common"},
		tiling = -1,
		type = 7,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[443] = {
		name = "monster",
		unittype = "object",
		tags = {"ruins","danger","animal"},
		tiling = 2,
		type = 0,
		layer = 19,
		colour = {4, 1},
	},
	[444] = {
		name = "text_monster",
		unittype = "text",
		tags = {"ruins","danger","animal"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 0},
		colour_active = {4, 1},
	},
	[445] = {
		name = "text_seeing",
		unittype = "text",
		tags = {"text_condition","common"},
		tiling = -1,
		type = 7,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[446] = {
		name = "teeth",
		unittype = "object",
		tags = {"abstract","decorative"},
		tiling = 4,
		type = 0,
		layer = 18,
		colour = {0, 3},
	},
	[447] = {
		name = "text_teeth",
		unittype = "text",
		tags = {"abstract","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 2},
		colour_active = {0, 3},
	},
	[448] = {
		name = "lever",
		unittype = "object",
		tags = {"machine","decorative"},
		tiling = 0,
		type = 0,
		layer = 16,
		colour = {0, 2},
	},
	[449] = {
		name = "text_lever",
		unittype = "text",
		tags = {"machine","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 2},
	},
	[450] = {
		name = "text_write",
		unittype = "text",
		tags = {"text_verb","text_special"},
		tiling = -1,
		type = 1,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		argtype = {0, 2},
		advanced = true,
	},
	[451] = {
		name = "text_powered2",
		unittype = "text",
		tags = {"text_condition","text_prefix","machine"},
		tiling = -1,
		type = 3,
		layer = 20,
		colour = {5, 2},
		colour_active = {5, 3},
		pairedwith = "text_power2",
	},
	[452] = {
		name = "text_power2",
		unittype = "text",
		tags = {"text_quality","machine"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {5, 2},
		colour_active = {5, 3},
		pairedwith = "text_powered2",
	},
	[453] = {
		name = "text_powered3",
		unittype = "text",
		tags = {"text_condition","text_prefix","machine"},
		tiling = -1,
		type = 3,
		layer = 20,
		colour = {3, 2},
		colour_active = {4, 4},
		pairedwith = "text_power3",
	},
	[454] = {
		name = "text_power3",
		unittype = "text",
		tags = {"text_quality","machine"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {3, 2},
		colour_active = {4, 4},
		pairedwith = "text_powered3",
	},
	[455] = {
		name = "chair",
		unittype = "object",
		tags = {"town","decorative","item"},
		tiling = 0,
		type = 0,
		layer = 16,
		colour = {6, 2},
	},
	[456] = {
		name = "text_chair",
		unittype = "text",
		tags = {"town","decorative","item"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[457] = {
		name = "table",
		unittype = "object",
		tags = {"town","decorative","item"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {6, 1},
	},
	[458] = {
		name = "text_table",
		unittype = "text",
		tags = {"town","decorative","item"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[459] = {
		name = "cheese",
		unittype = "object",
		tags = {"town","decorative","item"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 4},
	},
	[460] = {
		name = "text_cheese",
		unittype = "text",
		tags = {"town","decorative","item"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 3},
		colour_active = {2, 4},
	},
	[461] = {
		name = "bomb",
		unittype = "object",
		tags = {"machine","danger","item"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {0, 1},
	},
	[462] = {
		name = "text_bomb",
		unittype = "text",
		tags = {"machine","danger","item"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 2},
	},
	[463] = {
		name = "paper",
		unittype = "object",
		tags = {"item","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 9,
		colour = {0, 3},
	},
	[464] = {
		name = "text_paper",
		unittype = "text",
		tags = {"item","decorative","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[465] = {
		name = "scissors",
		unittype = "object",
		tags = {"item","decorative","town","danger"},
		tiling = 3,
		type = 0,
		layer = 16,
		colour = {4, 4},
	},
	[466] = {
		name = "text_scissors",
		unittype = "text",
		tags = {"item","decorative","town","danger"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 2},
		colour_active = {4, 4},
	},
	[467] = {
		name = "arm",
		unittype = "object",
		tags = {"abstract"},
		tiling = 3,
		type = 0,
		layer = 15,
		colour = {3, 1},
	},
	[468] = {
		name = "text_arm",
		unittype = "text",
		tags = {"abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {3, 1},
		colour_active = {4, 2},
	},
	[469] = {
		name = "bunny",
		unittype = "object",
		tags = {"animal","forest"},
		tiling = 2,
		type = 0,
		layer = 19,
		colour = {0, 3},
	},
	[470] = {
		name = "text_bunny",
		unittype = "text",
		tags = {"animal","forest"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[471] = {
		name = "snail",
		unittype = "object",
		tags = {"animal","forest"},
		tiling = 0,
		type = 0,
		layer = 19,
		colour = {6, 2},
	},
	[472] = {
		name = "text_snail",
		unittype = "text",
		tags = {"animal","forest"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {6, 1},
		colour_active = {6, 2},
	},
	[473] = {
		name = "bean",
		unittype = "object",
		tags = {"plant","forest","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 1},
	},
	[474] = {
		name = "text_bean",
		unittype = "text",
		tags = {"plant","forest","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[475] = {
		name = "hotdog",
		unittype = "object",
		tags = {"town","item","decorative"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {2, 3},
	},
	[476] = {
		name = "text_hotdog",
		unittype = "text",
		tags = {"town","item","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 2},
		colour_active = {2, 3},
	},
	[477] = {
		name = "yes",
		unittype = "object",
		tags = {"abstract"},
		tiling = -1,
		type = 0,
		layer = 19,
		colour = {5, 3},
	},
	[478] = {
		name = "text_yes",
		unittype = "text",
		tags = {"abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 2},
		colour_active = {5, 3},
	},
	[479] = {
		name = "no",
		unittype = "object",
		tags = {"abstract"},
		tiling = -1,
		type = 0,
		layer = 19,
		colour = {2, 2},
	},
	[480] = {
		name = "text_no",
		unittype = "text",
		tags = {"abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[481] = {
		name = "text_hold",
		unittype = "text",
		tags = {"text_quality","movement","obstacle"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[482] = {
		name = "brain",
		unittype = "object",
		tags = {"abstract"},
		tiling = 0,
		type = 0,
		layer = 19,
		colour = {4, 2},
	},
	[483] = {
		name = "text_brain",
		unittype = "text",
		tags = {"abstract"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {4, 1},
		colour_active = {4, 2},
	},
	[484] = {
		name = "chili",
		unittype = "object",
		tags = {"plant","forest","decorative"},
		tiling = -1,
		type = 0,
		layer = 12,
		colour = {2, 2},
	},
	[485] = {
		name = "text_chili",
		unittype = "text",
		tags = {"plant","forest","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[486] = {
		name = "text_angry",
		unittype = "text",
		tags = {"text_quality","decorative"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 2},
	},
	[487] = {
		name = "text_happy",
		unittype = "text",
		tags = {"text_quality","decorative"},
		tiling = -1,
		type = 2,
		layer = 20,
		colour = {5, 2},
		colour_active = {5, 4},
	},
	[488] = {
		name = "bone",
		unittype = "object",
		tags = {"danger","decorative"},
		tiling = 0,
		type = 0,
		layer = 9,
		colour = {0, 3},
	},
	[489] = {
		name = "text_bone",
		unittype = "text",
		tags = {"danger","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
	},
	[490] = {
		name = "text_become",
		unittype = "text",
		tags = {"text_verb","abstract"},
		tiling = -1,
		type = 1,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[491] = {
		name = "text_facedby",
		unittype = "text",
		tags = {"text_condition"},
		tiling = -1,
		type = 7,
		layer = 20,
		colour = {0, 1},
		colour_active = {0, 3},
		advanced = true,
	},
	[492] = {
		name = "cactus",
		unittype = "object",
		tags = {"plant","forest","decorative"},
		tiling = 0,
		type = 0,
		layer = 15,
		colour = {5, 2},
	},
	[493] = {
		name = "text_cactus",
		unittype = "text",
		tags = {"plant","forest","decorative"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 2},
	},
	[494] = {
		name = "fox",
		unittype = "object",
		tags = {"animal","forest","town"},
		tiling = 2,
		type = 0,
		layer = 18,
		colour = {2, 3},
	},
	[495] = {
		name = "text_fox",
		unittype = "text",
		tags = {"animal","forest","town"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {2, 1},
		colour_active = {2, 3},
	},
	[496] = {
		name = "palm",
		unittype = "object",
		tags = {"forest","plant","obstacle"},
		tiling = -1,
		type = 0,
		layer = 16,
		colour = {5, 3},
	},
	[497] = {
		name = "text_palm",
		unittype = "text",
		tags = {"forest","plant","obstacle"},
		tiling = -1,
		type = 0,
		layer = 20,
		colour = {5, 1},
		colour_active = {5, 3},
	},
}