// Anime4K CNN Effect - Anime4K Upscale Denoise UL
// Based on Anime4K project by bloc97

//!BGFX EFFECT
//!VERSION 1
//!NAME Anime4K Upscale Denoise UL
//!CATEGORY Anime4K
//!DESCRIPTION 2x CNN upscaler with integrated denoising. Ultra-Large variant for maximum quality.
//!CAPABILITY FP16
//!USE MulAdd

//!TEXTURE
Texture2D INPUT;

//!TEXTURE
//!WIDTH INPUT_WIDTH * 2
//!HEIGHT INPUT_HEIGHT * 2
Texture2D OUTPUT;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_tf;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_tf1;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_tf2;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_1_tf;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_1_tf1;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_1_tf2;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_2_tf;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_2_tf1;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_2_tf2;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_3_tf;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_3_tf1;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_3_tf2;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_4_tf;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_4_tf1;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_4_tf2;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_5_tf;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_5_tf1;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_5_tf2;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_6_tf;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_6_tf1;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
Texture2D conv2d_6_tf2;

//!SAMPLER
//!FILTER POINT
SamplerState sam;

//!SAMPLER
//!FILTER LINEAR
SamplerState sam1;


//!PASS 1
//!DESC Conv-4x3x3x3
//!IN INPUT
//!OUT conv2d_tf, conv2d_tf1, conv2d_tf2
//!BLOCK_SIZE 16
//!NUM_THREADS 64

void Pass1(uint2 blockStart, uint3 threadId) {
	uint2 gxy = (TileSwizzle8x8(threadId.x) << 1) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	
	uint i, j;

	MF3 src[4][4];
	[unroll]
	for (i = 0; i <= 2; i += 2) {
		[unroll]
		for (j = 0; j <= 2; j += 2) {
			float2 tpos = (gxy + uint2(i, j)) * inputPt;
			const MF4 sr = INPUT.GatherRed(sam, tpos);
			const MF4 sg = INPUT.GatherGreen(sam, tpos);
			const MF4 sb = INPUT.GatherBlue(sam, tpos);

			// w z
			// x y
			src[i][j] = MF3(sr.w, sg.w, sb.w);
			src[i][j + 1] = MF3(sr.x, sg.x, sb.x);
			src[i + 1][j] = MF3(sr.z, sg.z, sb.z);
			src[i + 1][j + 1] = MF3(sr.y, sg.y, sb.y);
		}
	}

	[unroll]
	for (i = 1; i <= 2; ++i) {
		[unroll]
		for (j = 1; j <= 2; ++j) {
			uint2 destPos = gxy + uint2(i - 1, j - 1);

			if (i != 1 || j != 1) {
				if (destPos.x >= inputSize.x || destPos.y >= inputSize.y) {
					continue;
				}
			}

			MF4 target1 = { 0.0366252, 0.028346894, 0.033923555, 0.00025824012 };
			target1 = MulAdd(src[i - 1][j - 1], MF3x4(-0.21481565, -0.0914136, -0.067639425, -0.13521406, 0.14386347, -0.007917821, -0.0018606511, -0.07272963, 0.09651574, 0.09874618, 0.06434639, 0.1787858), target1);
			target1 = MulAdd(src[i - 1][j], MF3x4(-0.06402414, -0.014693245, -0.25395226, 0.2960157, -0.12494867, 0.17711689, 0.31812787, -0.22346497, -0.1172598, -0.17087954, -0.031076867, -0.26865217), target1);
			target1 = MulAdd(src[i - 1][j + 1], MF3x4(-0.19254248, -0.049369957, 0.08171505, -0.12660322, 0.11544268, 0.15840095, -0.11473022, 0.144489, 0.07068809, 0.041438796, 0.10749463, -0.057156503), target1);
			target1 = MulAdd(src[i][j - 1], MF3x4(0.040826935, 0.0030781324, 0.094986334, -0.2573781, -0.11649985, 0.018165307, 0.039985053, -0.15652324, -0.014886749, -0.00988401, -0.15025067, -0.0031970344), target1);
			target1 = MulAdd(src[i][j], MF3x4(-0.15658751, 0.08227927, 0.23491348, 0.29900867, -0.45667845, 0.0438649, -0.39066258, 0.6590342, 0.009331404, 0.097770594, 0.21618316, 0.25005254), target1);
			target1 = MulAdd(src[i][j + 1], MF3x4(-0.16455166, 0.013149855, 0.21515559, 0.03110101, -0.008973558, 0.33310282, -0.03276024, -0.3356557, 0.007899698, 0.295166, -0.73289853, 0.16696596), target1);
			target1 = MulAdd(src[i + 1][j - 1], MF3x4(0.2691608, 0.09478436, 0.006536417, -0.04095308, -0.10942356, -0.0481289, -0.039660163, -0.20591366, -0.08013109, -0.052268907, 0.046878606, -0.024840442), target1);
			target1 = MulAdd(src[i + 1][j], MF3x4(0.17120434, -0.06828329, -0.23515487, 0.11830264, 0.67815524, -0.10693793, 0.2392081, -0.3192851, 0.06719006, -0.03441811, 0.020009553, -0.21328516), target1);
			target1 = MulAdd(src[i + 1][j + 1], MF3x4(0.30072933, 0.0348702, 0.15155697, -0.15580897, -0.12755825, -0.57249874, -0.10091004, 0.22914392, -0.017671, -0.26088336, -0.00079997425, -0.022365946), target1);

			MF4 target2 = { -0.043337345, 0.16099554, -0.030338328, 0.0074565704 };
			target2 = MulAdd(src[i - 1][j - 1], MF3x4(0.042849753, -0.11642484, 0.073895186, 0.15186316, -0.024499241, 0.056690346, 0.05013788, -0.10182528, -0.024302427, 0.06578479, -0.028199008, -0.070577), target2);
			target2 = MulAdd(src[i - 1][j], MF3x4(-0.040659044, 0.22913207, -0.1847038, -0.11781796, 0.044752445, 0.009552658, -0.11374249, 0.12798874, 0.056919675, -0.20839268, 0.11021251, 0.044297826), target2);
			target2 = MulAdd(src[i - 1][j + 1], MF3x4(-0.009999239, 0.1996945, -0.29797587, -0.4280957, -0.008521183, -0.10773894, 0.22186345, 0.254737, -0.003993275, -0.07186837, 0.16690473, 0.19043307), target2);
			target2 = MulAdd(src[i][j - 1], MF3x4(-0.16174923, 0.26882383, 0.50559163, 0.38955548, 0.14091976, -0.15637094, -0.11826545, -0.23424837, 0.01674066, -0.08578336, -0.16907434, -0.19845173), target2);
			target2 = MulAdd(src[i][j], MF3x4(0.10735882, -0.016069679, 0.42237386, -0.19937111, 0.07271503, 0.07596921, -0.24035113, 0.12406044, 0.059160866, -0.051063746, -0.36897844, 0.061272774), target2);
			target2 = MulAdd(src[i][j + 1], MF3x4(0.015712388, -0.34878746, -0.66418105, -0.35441992, -0.12208571, 0.042238027, 0.30143425, 0.3610614, -0.09538538, 0.25334427, 0.24629802, 0.030739667), target2);
			target2 = MulAdd(src[i + 1][j - 1], MF3x4(-0.0035519397, 0.07191882, -0.20775351, -0.15425798, 0.07919461, 0.07578178, 0.12668823, 0.0011835548, 0.03245292, -0.105801836, 0.24585879, 0.13730717), target2);
			target2 = MulAdd(src[i + 1][j], MF3x4(0.2415042, -0.16800308, 0.48690978, 0.75166744, 0.3876131, 0.038878918, -0.3293806, -0.47433355, 0.057803743, 0.09533431, -0.1342232, -0.2982094), target2);
			target2 = MulAdd(src[i + 1][j + 1], MF3x4(-0.18697992, -0.60250723, -0.11149202, -0.015566043, -0.57483697, 0.07203411, 0.050863862, -0.078300595, -0.09433572, 0.27099958, -0.03195694, 0.10535165), target2);

			MF4 target3 = { -0.51499516, 0.026265146, 0.05636954, 0.03170462 };
			target3 = MulAdd(src[i - 1][j - 1], MF3x4(-0.05112635, -0.09334158, -0.031148188, -0.041258592, -0.04633252, 0.022155467, 0.16979018, 0.06819186, 0.094320215, 0.02111737, -0.15604521, -0.15083192), target3);
			target3 = MulAdd(src[i - 1][j], MF3x4(0.10213034, 0.41852444, 0.32454407, -0.058512308, -0.054484565, -0.24399261, -0.26164648, -0.34274867, -0.06912002, 0.02257528, 0.2588075, 0.24375258), target3);
			target3 = MulAdd(src[i - 1][j + 1], MF3x4(0.019957408, 0.06354756, 0.10109863, 0.16890836, 0.06791468, 0.1259216, 0.3096521, 0.07912831, -0.08293642, -0.16565439, -0.050881315, -0.0576009), target3);
			target3 = MulAdd(src[i][j - 1], MF3x4(0.19822149, 0.34747612, -0.20176221, 0.042434175, -0.029007072, -0.1637076, -0.09433387, 0.32732537, -0.12577844, -0.049755163, 0.091352955, 0.27023584), target3);
			target3 = MulAdd(src[i][j], MF3x4(-0.26348627, 0.52249527, -0.4091685, -0.41065818, 0.050318573, 0.06534145, -0.15470429, 0.52704567, 0.08808197, -0.37854514, -0.22827432, 0.1498618), target3);
			target3 = MulAdd(src[i][j + 1], MF3x4(-0.0865881, -0.8053624, 0.088793345, -0.22072543, -0.0141816195, 0.0049849018, 0.21256319, -0.327414, 0.1364984, 0.4927693, 0.1848864, -0.18559869), target3);
			target3 = MulAdd(src[i + 1][j - 1], MF3x4(-0.11838837, 0.056446314, 0.08738398, 0.31899074, 0.056432292, -0.0008520313, 0.018734995, -0.33501405, -0.00918473, -0.040785775, 0.04093389, -0.19747448), target3);
			target3 = MulAdd(src[i + 1][j], MF3x4(0.66065794, -0.5208613, -0.018835181, 0.26112127, 0.055486765, 0.113573246, -0.05028873, 0.05364108, 0.040549137, 0.28754827, -0.16565348, -0.37204087), target3);
			target3 = MulAdd(src[i + 1][j + 1], MF3x4(0.06361742, 0.00907182, 0.06848412, 0.0057870117, -0.05289465, 0.068106346, -0.15660144, -0.20288356, -0.093512855, -0.17268412, 0.030761726, 0.36189792), target3);

			conv2d_tf[destPos] = target1;
			conv2d_tf1[destPos] = target2;
			conv2d_tf2[destPos] = target3;
		}
	}
}

//!PASS 2
//!DESC Conv-4x3x3x24
//!IN conv2d_tf, conv2d_tf1, conv2d_tf2
//!OUT conv2d_1_tf, conv2d_1_tf1, conv2d_1_tf2
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass2(uint2 blockStart, uint3 threadId) {
	uint2 gxy = TileSwizzle8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	MF4 a1 = conv2d_tf.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b1 = conv2d_tf.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c1 = conv2d_tf.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d1 = conv2d_tf.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e1 = conv2d_tf.SampleLevel(sam, pos, 0);
	MF4 f1 = conv2d_tf.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g1 = conv2d_tf.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h1 = conv2d_tf.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i1 = conv2d_tf.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na1 = max(-a1, 0);
	MF4 nb1 = max(-b1, 0);
	MF4 nc1 = max(-c1, 0);
	MF4 nd1 = max(-d1, 0);
	MF4 ne1 = max(-e1, 0);
	MF4 nf1 = max(-f1, 0);
	MF4 ng1 = max(-g1, 0);
	MF4 nh1 = max(-h1, 0);
	MF4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	MF4 a2 = conv2d_tf1.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b2 = conv2d_tf1.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c2 = conv2d_tf1.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d2 = conv2d_tf1.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e2 = conv2d_tf1.SampleLevel(sam, pos, 0);
	MF4 f2 = conv2d_tf1.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g2 = conv2d_tf1.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h2 = conv2d_tf1.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i2 = conv2d_tf1.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na2 = max(-a2, 0);
	MF4 nb2 = max(-b2, 0);
	MF4 nc2 = max(-c2, 0);
	MF4 nd2 = max(-d2, 0);
	MF4 ne2 = max(-e2, 0);
	MF4 nf2 = max(-f2, 0);
	MF4 ng2 = max(-g2, 0);
	MF4 nh2 = max(-h2, 0);
	MF4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

	MF4 a3 = conv2d_tf2.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b3 = conv2d_tf2.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c3 = conv2d_tf2.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d3 = conv2d_tf2.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e3 = conv2d_tf2.SampleLevel(sam, pos, 0);
	MF4 f3 = conv2d_tf2.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g3 = conv2d_tf2.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h3 = conv2d_tf2.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i3 = conv2d_tf2.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na3 = max(-a3, 0);
	MF4 nb3 = max(-b3, 0);
	MF4 nc3 = max(-c3, 0);
	MF4 nd3 = max(-d3, 0);
	MF4 ne3 = max(-e3, 0);
	MF4 nf3 = max(-f3, 0);
	MF4 ng3 = max(-g3, 0);
	MF4 nh3 = max(-h3, 0);
	MF4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	MF4 target = MF4(-0.117853574, 0.036960166, -0.0057268855, -0.032133963);
	target = MulAdd(a1, MF4x4(0.028563375, 0.075096495, 0.054740135, -0.097906366, -0.26889417, 0.0982474, 0.0013334368, 0.10432092, 0.2450199, -0.12516013, 0.11230964, 0.01147953, 0.085179225, 0.117808536, -0.123295836, 0.1002614), target);
	target = MulAdd(b1, MF4x4(0.19004358, 0.077133805, -0.42637873, -0.08600882, 0.041925456, -0.2716079, -0.1856413, 0.017397093, 0.037734076, 0.21233109, -0.2645201, 0.074807495, 0.047724582, -0.027935218, -0.003907437, -0.04731259), target);
	target = MulAdd(c1, MF4x4(0.09745319, 0.22767977, 0.37006328, 0.05020985, 0.039997175, -0.029447127, 0.1779581, -0.01620031, -0.010955076, 0.13874966, -0.053154904, 0.020808663, -0.11724862, -0.20081818, 0.047436096, -0.08110093), target);
	target = MulAdd(d1, MF4x4(0.18583415, -0.20435709, 0.01911209, -0.026401127, -0.12581685, 0.014082952, -0.2001187, -0.08042616, -0.10389668, -0.10207221, 0.04581297, -0.08704452, 0.09200634, -0.13755022, -0.007857635, 0.10011377), target);
	target = MulAdd(e1, MF4x4(0.21004692, 0.30619434, 0.10146727, -0.012386493, -0.093512, -0.22519337, 0.16826348, 0.14847179, -0.019215466, -0.18989901, 0.09468501, 0.26023552, -0.07841198, 0.23280892, 0.00941152, 0.16808987), target);
	target = MulAdd(f1, MF4x4(0.26988962, -0.022920275, -0.195991, 0.08438454, 0.12282865, -0.07083694, 0.07814293, -0.08369662, -0.05397518, 0.06164561, 0.070263356, -0.049779683, -0.12997615, -0.12259467, -0.29498726, -0.2244981), target);
	target = MulAdd(g1, MF4x4(0.22414525, -0.022969153, -0.063833915, -0.027190238, 0.13401125, 0.02098015, -0.22264218, -0.12177459, -0.12630488, 0.14246967, -0.06480293, -0.11353247, -0.12755829, -0.02848558, 0.006076032, 0.14054467), target);
	target = MulAdd(h1, MF4x4(0.13391276, 0.06295799, 0.31367007, -0.19527563, -0.040563866, 0.11965244, 0.27989656, -0.057327088, 0.035627916, -0.119488806, -0.24792899, 0.13612582, 0.029112214, -0.08201902, 0.17605872, -0.089963086), target);
	target = MulAdd(i1, MF4x4(-0.01927269, -0.034413125, -0.18000118, 0.042171028, 0.0791958, -0.1210223, -0.07674829, 0.02870783, 0.1884872, -0.012900881, 0.1311204, 0.06283302, 0.0027031084, -0.11157234, 0.06318397, -0.13527857), target);
	target = MulAdd(a2, MF4x4(0.1419255, -0.16276762, 0.00092816725, 0.0078547085, -0.48728654, -0.05630108, -0.33906484, 0.025995376, 0.07410779, -0.06377176, -0.038708985, -0.10480868, 0.096948944, -0.08378831, 0.08217461, 0.126169), target);
	target = MulAdd(b2, MF4x4(-0.07488089, -0.2994524, 0.23773918, -0.034476187, 0.0592535, 0.29324362, -0.030512415, -0.17258315, 0.08022449, -0.17212203, 0.17636995, 0.06854101, -0.029770015, -0.10313743, 0.46230134, 0.026522856), target);
	target = MulAdd(c2, MF4x4(-0.018750735, -0.032278806, -0.16665034, -0.05022533, 0.057606205, 0.13155009, 0.06575953, 0.10044875, -0.09888156, 0.263175, -0.3478382, -0.08823663, -0.081383094, -0.044876218, -0.47501948, -0.062558904), target);
	target = MulAdd(d2, MF4x4(-0.105735146, 0.30434787, -0.04748756, 0.13275737, 0.3215866, -0.097894445, 0.027429244, -0.2778113, 0.07703074, 0.0012649142, -0.54314685, 0.17256977, 0.16500366, -0.0060054287, 0.17721342, -0.37938938), target);
	target = MulAdd(e2, MF4x4(0.14780188, 0.2596772, 0.31135467, -0.02797583, -0.015622625, -0.006320702, -0.08333076, -0.018904723, 0.1389364, 0.19142458, 0.6817067, -0.054837633, 0.21896258, 0.036575202, -0.9033377, -0.25137353), target);
	target = MulAdd(f2, MF4x4(-0.12165315, 0.18358506, -0.1983472, 0.08618611, -0.1101336, -0.02491273, 0.36231366, 0.24619159, 0.07281212, 0.35466114, 0.32505757, 0.022900501, -0.25818315, -0.49635252, 0.2928282, 0.057359587), target);
	target = MulAdd(g2, MF4x4(-0.23839255, 0.1707951, 0.09135314, 0.1034047, -0.034727763, -0.1243241, 0.118879616, 0.06359015, -0.12569816, -0.116403826, 0.13372615, -0.04866488, -0.070711434, 0.21472852, 0.098126635, 0.16186984), target);
	target = MulAdd(h2, MF4x4(-0.0020077212, -0.1095719, -0.20081437, 0.028084867, -0.1479706, -0.028820625, -0.09085524, 0.118761584, -0.15923466, -0.32149267, -0.50690764, 0.040582787, 0.039979883, 0.026478326, -0.040531024, -0.13908122), target);
	target = MulAdd(i2, MF4x4(-0.085969776, 0.18301825, 0.11408605, 0.025418868, 0.11126661, -0.044224992, -0.061021794, -0.015779478, 0.10210226, -0.19080523, -0.14473902, 0.14097509, 0.14796504, 0.14814787, 0.11975678, -0.039735712), target);
	target = MulAdd(a3, MF4x4(0.27801284, 0.20288002, -1.2655782, 0.32888517, -0.02334678, 0.18978934, 0.23810555, 0.0074393786, 0.08552408, -0.1274367, -0.086998045, -0.024746515, 0.102745675, -0.086740054, -0.038129628, -0.0651254), target);
	target = MulAdd(b3, MF4x4(-1.190979, -0.19575417, -0.569518, -0.17817745, -0.059261408, 0.09253248, -0.27272785, 0.17687175, 0.12146025, -0.07960662, 0.15846346, -0.14022483, 0.007532498, -0.096234165, 0.2769003, -0.14700246), target);
	target = MulAdd(c3, MF4x4(-0.042687517, 0.022726525, -1.078912, -0.6248177, 0.11832816, -0.1086772, 0.1261872, 0.16775566, -0.05851938, -0.0732127, -0.01822243, -0.009363452, 0.015375079, 0.036912445, 0.11969059, -0.07526642), target);
	target = MulAdd(d3, MF4x4(0.31373152, 0.0693334, -0.07900261, 0.0070532965, -0.13916558, -0.08116685, -0.85886157, 0.18724924, 0.023858327, -0.2971659, -0.2337722, -0.17136115, 0.034164, 0.09053483, 0.28138685, -0.050052963), target);
	target = MulAdd(e3, MF4x4(0.69782144, -0.17773196, -1.8466626, -1.029225, -0.010800972, -0.0059786057, 0.7224214, 0.45541716, 0.09066342, -0.13732997, 0.009828377, 0.115971304, 0.13013129, 0.35331696, -0.633545, 0.23484547), target);
	target = MulAdd(f3, MF4x4(-0.24049048, 0.16627774, -0.020105539, -0.117568016, -0.0043368824, -0.20639539, 0.10247316, -0.037546206, 0.18750127, 0.12931745, -0.14076929, -0.08036072, 0.045171227, 0.19917291, -0.068400174, 0.17796516), target);
	target = MulAdd(g3, MF4x4(0.09404375, 0.049048338, 0.24326289, 0.17646226, -0.11654813, 0.2592855, 0.32776543, 0.4599728, -0.19997491, 0.11202324, 0.18054682, -0.005742288, -0.036823884, -0.042750888, 0.22441903, 0.038635597), target);
	target = MulAdd(h3, MF4x4(0.036728445, 0.08352167, 0.08909888, -0.02035385, 0.090846755, -0.14406498, -0.025689734, 0.057863228, -0.04390429, -0.25868183, 0.29578558, 0.30690736, -0.05475277, -0.10149075, -0.034297444, 0.10515887), target);
	target = MulAdd(i3, MF4x4(-0.062532455, -0.12673786, 0.16426907, -0.25397223, 0.051807977, 0.112844475, -0.496193, -0.2551257, 0.025220035, 0.15157217, -0.08517411, 0.07161397, -0.06691877, -0.13205263, -0.117163956, 0.065052904), target);
	target = MulAdd(na1, MF4x4(0.07364788, -0.05812666, -0.05958767, -0.027094465, 0.26366132, 0.07415391, 0.040515613, 0.039676376, -0.006552745, -0.012837193, -0.17393842, 0.02813939, -0.121285915, 0.0030941493, 0.16669592, -0.0712934), target);
	target = MulAdd(nb1, MF4x4(0.03629398, -0.3745122, 0.3940434, -0.06701516, 0.083452255, 0.03055438, 0.15637632, 0.0019212369, 0.019995827, -0.21137866, 0.2645297, -0.09081918, 0.025669578, -0.1560248, -0.10008925, -0.07828463), target);
	target = MulAdd(nc1, MF4x4(-0.053625695, -0.10420973, -0.35323003, -0.022054465, -0.08156209, 0.008921794, -0.15391788, -0.03960033, 0.017107122, -0.13479686, 0.068978906, -0.12981713, 0.025973944, -0.09934198, -0.022112468, 0.020573085), target);
	target = MulAdd(nd1, MF4x4(0.0018295953, 0.13670065, 0.004993195, 0.059238344, -0.13972434, -0.13108826, 0.1942548, 0.18194143, -0.12335718, 0.024078835, -0.13328132, 0.06978434, -0.0107950205, 0.14398722, -0.022609226, -0.0041353432), target);
	target = MulAdd(ne1, MF4x4(0.27635157, 0.15513352, -0.12534688, 0.15107392, 0.22048512, -0.044253547, -0.1429736, -0.39647785, 0.029876633, 0.1842563, -0.06762048, -0.06029809, 0.07537981, -0.035769306, -0.0261646, -0.110136114), target);
	target = MulAdd(nf1, MF4x4(-0.12261548, 0.22167495, 0.18503761, 0.02638229, -0.094690226, 0.061862398, -0.081829205, 0.15912767, 0.006990079, -0.010121606, -0.12535281, 0.024284743, 0.18360399, 0.16907142, 0.25744098, 0.24359013), target);
	target = MulAdd(ng1, MF4x4(-0.14717774, -0.09528236, 0.054552622, 0.0036530807, -0.5273358, -0.03762757, 0.21280535, 0.25522852, 0.20926028, -0.022236722, 0.0377064, -0.07160359, 0.06345197, -0.046687063, 0.021401843, -0.14337662), target);
	target = MulAdd(nh1, MF4x4(0.17630331, 0.06953194, -0.26126865, 0.029734965, 0.13158317, -0.11239223, -0.2805452, 0.106054045, -0.053220887, 0.09541345, 0.26539528, 0.15052572, 0.042701412, -0.025114734, -0.22815101, 0.06797245), target);
	target = MulAdd(ni1, MF4x4(-0.11562362, 0.037828114, 0.15033676, 0.006264337, -0.049709305, 0.13406959, 0.055033628, -0.11243884, -0.18540126, 0.04862983, -0.13387235, -0.13529298, -0.096242204, 0.16761206, -0.032110162, 0.24142851), target);
	target = MulAdd(na2, MF4x4(-0.21116647, 0.058380276, 0.080453075, -0.2679615, -0.28600135, 0.042669408, 0.17540424, -0.14219923, 0.017092299, 0.05328859, 0.0065248194, 0.02395608, 0.05216899, 0.12829328, -0.116384834, -0.2828383), target);
	target = MulAdd(nb2, MF4x4(0.009241691, 0.10957236, -0.22526564, 0.2957556, -0.025253482, -0.08254481, 0.09223265, -0.051697835, -0.071490794, 0.094247855, -0.32692534, -0.12678702, 0.052934665, -0.050429285, -0.18388982, -0.039230555), target);
	target = MulAdd(nc2, MF4x4(-0.16137493, -0.04317478, 0.11681715, 0.16198912, -0.048432272, -0.22682366, -0.01725331, -0.04194597, 0.03203572, -0.16799524, 0.4784258, 0.086616606, 0.0017708768, -0.049688417, 0.064586475, -0.057059586), target);
	target = MulAdd(nd2, MF4x4(-0.11059055, 0.0029538488, 0.038545247, 0.066895224, 0.011218007, -0.003137218, 0.021355668, -0.168016, -0.0026601932, -0.14172328, 0.51700294, -0.33690482, -0.18839404, 0.07191177, -0.05362303, 0.20618927), target);
	target = MulAdd(ne2, MF4x4(-0.24159928, -0.1053597, -0.28113043, 0.007160803, -0.0974629, 0.020222154, 0.050444435, -0.11046227, 0.24656764, -0.24290104, -0.53290504, 0.07402318, -0.015612266, 0.123455755, 0.018084416, -0.019945476), target);
	target = MulAdd(nf2, MF4x4(0.09311286, -0.1032696, 0.19615465, 0.04846074, 0.029715529, 0.012683276, -0.38939312, -0.15030165, 0.0103463745, -0.3906085, -0.5047903, -0.1061866, 0.20654117, 0.32689643, 0.0086037805, -0.0681904), target);
	target = MulAdd(ng2, MF4x4(0.18691367, -0.046374205, -0.05107187, -0.017465474, 0.11804314, 0.090009406, -0.075490244, 0.0036797172, -0.09327475, 0.18428694, -0.17598015, -0.076990046, 0.03992913, -0.116993815, -0.24077141, -0.48880583), target);
	target = MulAdd(nh2, MF4x4(-0.0056006587, 0.104048744, 0.19665402, 0.0032775581, 0.15130368, 0.04196182, 0.050959308, 0.02474336, 0.036360126, 0.2724413, 0.35197738, 0.04588593, -0.24590112, -0.08575977, 0.18552561, 0.16555585), target);
	target = MulAdd(ni2, MF4x4(0.09420384, -0.113198765, -0.13239664, 0.019001532, -0.0027163615, 0.078038216, 0.09880948, 0.15455763, -0.028529879, 0.20345445, 0.27439958, -0.094165966, -0.10702775, -0.18507981, -0.10240351, -0.02831745), target);
	target = MulAdd(na3, MF4x4(-0.05168434, 0.20330708, 0.10572813, 0.26246095, 0.021435333, -0.10574623, -0.1401922, 0.42713496, -0.030233249, 0.043342397, 0.11101976, 0.032030135, -0.12287885, 0.006734168, 0.024990475, -0.05208304), target);
	target = MulAdd(nb3, MF4x4(0.15237613, -0.15887943, -0.12718262, -0.06986501, 0.03136358, -0.0035889314, 0.2054987, -0.14852847, -0.22284113, -0.3410994, -0.2125513, 0.04496407, 0.094411716, -0.16842332, -0.25714603, 0.08910682), target);
	target = MulAdd(nc3, MF4x4(-0.19709085, -0.10590203, 0.07929334, 0.09949157, -0.0808941, 0.17018095, -0.09984616, -0.03477169, 0.11511119, 0.016829535, 0.05470175, 0.000366129, -0.07609101, -0.10981034, -0.14416353, -0.012299061), target);
	target = MulAdd(nd3, MF4x4(-0.12151653, -0.017303294, 0.055218883, 0.048941534, 0.1476368, 0.31801772, 0.68790305, 0.13284543, 0.11992122, -0.2362068, 0.20126005, 0.14724149, 0.01645638, 0.05896895, -0.30263412, 0.12367781), target);
	target = MulAdd(ne3, MF4x4(0.19272023, 0.09102746, 0.31454524, -0.27032062, 0.2674956, 0.040032856, -0.670905, -0.12510742, -0.02879305, 0.34733048, 0.055205155, -0.22118829, 0.18704127, -0.27267426, 0.59989405, -0.14810604), target);
	target = MulAdd(nf3, MF4x4(0.025540218, -0.07248532, -0.15664534, -0.19372375, 0.03556883, 0.03597721, -0.14901096, 0.27721658, -0.010668913, -0.29144233, 0.11746931, -0.13459797, 0.005971381, -0.08445966, 0.14954261, -0.11475002), target);
	target = MulAdd(ng3, MF4x4(0.08029168, -0.061888658, -0.14104845, -0.06396443, 0.15312983, -0.2487142, -0.26357505, -0.049171742, 0.11320337, -0.055089038, -0.145923, -0.44234648, 0.03747512, 0.09540022, -0.20250735, 0.03820108), target);
	target = MulAdd(nh3, MF4x4(-0.0191974, -0.05480732, -0.1930927, 0.01147343, -0.15684529, 0.28367257, -0.15252224, 0.45261058, 0.13849851, 0.08685002, -0.33513635, -0.14976694, 0.07475008, 0.01998271, 0.066315226, -0.13143158), target);
	target = MulAdd(ni3, MF4x4(0.07728802, 0.14218356, 0.0850198, 0.09061631, -0.27746883, -0.18180014, 0.52573866, 0.19462089, 0.015337635, -0.3014013, 0.13493168, -0.055304635, 0.07148734, 0.10548237, 0.034149908, -0.12699014), target);
	conv2d_1_tf[gxy] = target;
	
	target = MF4(0.06651301, -0.00047524707, 0.04855725, -0.15500803);
	target = MulAdd(a1, MF4x4(0.04775777, 0.08222661, 0.061593954, 0.12055235, 0.008962983, -0.009267361, -0.53843796, 0.16952439, 0.016025536, 0.10542892, -0.042894494, 0.057321973, -0.055204723, -0.06992498, -0.00064485346, 0.007825405), target);
	target = MulAdd(b1, MF4x4(-0.09411942, -0.23469426, 0.35026586, -0.22138432, 0.045611277, -0.20210607, -0.24638987, 0.22675677, -0.14620386, 0.04001241, 0.06581148, -0.18093623, 0.08063868, 0.16085242, -0.28524494, -0.04407303), target);
	target = MulAdd(c1, MF4x4(0.016880078, 0.10823597, -0.0856685, 0.1394186, -0.035895467, 0.13400109, 0.08679763, 0.11814033, 0.06898399, 0.01606696, 0.01784015, 0.006547478, -0.042100497, 0.039176684, -0.09559512, -0.19490835), target);
	target = MulAdd(d1, MF4x4(-0.10115389, -0.11022993, -0.004623271, 0.12206448, -0.040075306, 0.013587107, -0.059400085, 0.18945488, -0.009945642, -0.4523725, 0.20760842, -0.3546684, 0.10930277, 0.14101993, 0.17574343, 0.005993813), target);
	target = MulAdd(e1, MF4x4(-0.31806734, 0.31059268, 0.0034255723, -0.23206042, 0.26745492, 0.19362858, 0.12183108, 0.29931548, 0.09186783, 0.4084161, 0.04199913, -0.23650031, -0.14427313, -0.036473513, 0.11935153, 0.113769025), target);
	target = MulAdd(f1, MF4x4(0.20892154, -0.08097856, -0.20722318, -0.18344022, -0.05412969, 0.16550343, 0.12085539, 0.10199144, 0.112941146, 0.08606901, -0.036151443, -0.036627453, -0.12987532, -0.28756067, -0.06838574, -0.23512506), target);
	target = MulAdd(g1, MF4x4(-0.052661214, -0.104233526, -0.08693217, -0.1819736, -0.052437317, -0.15960887, 0.056683555, -0.040860362, -0.13381086, 0.13378991, -0.073331766, 0.047169458, -0.0479799, -0.0043481477, 0.0048899767, 0.019455308), target);
	target = MulAdd(h1, MF4x4(-0.13005687, 0.11126603, 0.09237425, 0.07877169, -0.042795215, -0.0542181, -0.056731407, 0.08586777, 0.08175868, -0.019688416, -0.104517676, 0.16199689, 0.0044128234, 0.0475487, 0.12852396, 0.024199896), target);
	target = MulAdd(i1, MF4x4(0.16616863, -0.16998464, -0.19154428, -0.09432494, -0.037008844, -0.12210065, 0.0055908067, 0.010815051, 0.17710204, -0.12695597, -0.110427454, 0.13080561, 0.09322074, -0.0012365612, 0.026606066, -0.10843771), target);
	target = MulAdd(a2, MF4x4(-0.47415322, -0.07343328, -0.041209448, 0.08565837, -0.17691295, -0.26137534, 0.2907085, 0.0946057, -0.10768325, -0.10086646, 0.13768727, -0.1253546, 0.12256107, 0.092663676, 0.006136057, 0.10492505), target);
	target = MulAdd(b2, MF4x4(-0.36130214, 0.31970572, 0.01609707, 0.12488642, 0.09801414, 0.18358822, 0.08739752, 0.031744014, -0.07303357, -0.06802441, -0.05988708, -0.26767713, 0.08153729, 0.24952291, 0.12436414, -0.0748625), target);
	target = MulAdd(c2, MF4x4(-0.09533404, -0.14277202, 0.0020947633, 0.1547468, -0.009082152, 0.025103271, 0.032984417, -0.120028794, -0.045810502, -0.2012922, -0.02991531, -0.13404511, 0.08140658, 0.064424135, 0.104641765, 0.067367226), target);
	target = MulAdd(d2, MF4x4(0.053343832, -0.16905542, -0.05830104, -0.106561475, -0.078095205, -0.054910798, 0.061377183, 0.1524315, -0.16384287, -0.019450802, 0.13370255, -0.05160498, 0.15796599, 0.17254125, -0.12769255, 0.15248339), target);
	target = MulAdd(e2, MF4x4(-0.050160643, 0.005053776, -0.031104388, 0.09726363, -0.07693938, 0.102812484, -0.0756477, -0.048515156, 0.29591817, 0.35934618, 0.23326933, -0.23171274, -0.30232304, -0.43113515, -0.14196996, 0.28424993), target);
	target = MulAdd(f2, MF4x4(-0.10621949, -0.4280808, -0.08031358, -0.15168424, 0.26016018, 0.3142917, -0.11831494, -0.09303453, 0.10852745, -0.24068268, -0.037653822, -0.104800984, 0.0067478805, 0.14183025, -0.02230052, 0.2649731), target);
	target = MulAdd(g2, MF4x4(0.028874233, 0.12075906, 0.059678186, -9.616167e-05, -0.11149614, 0.122945406, -0.0767243, -0.040111836, 0.0735182, 0.21608177, 0.07806742, 0.0202061, -0.04776724, -0.11418923, -0.07523717, -0.12865649), target);
	target = MulAdd(h2, MF4x4(0.13507326, 0.06364227, 0.09873092, 0.038835276, 0.053677257, -0.036088385, -0.09081554, 0.02088773, 0.12252468, 0.15228558, 0.20928514, 0.09626035, -0.092850804, 0.12056272, -0.12500086, 0.14586885), target);
	target = MulAdd(i2, MF4x4(0.05855229, 0.11076543, 0.0058000707, -0.05286595, 0.06674972, -0.1913259, -0.04221818, 0.02681795, 0.18707529, -0.014904326, -0.1690741, 0.010544146, -0.07513052, -0.010648717, 0.15841635, 0.017503424), target);
	target = MulAdd(a3, MF4x4(0.09306208, -0.6048318, -0.16323692, -0.26322865, -0.064382344, 0.27984452, 0.0035378935, -0.0036242867, -0.08108908, 0.03801275, 0.09272382, 0.04653927, -0.09639203, 0.15146226, -0.022994163, -0.023005866), target);
	target = MulAdd(b3, MF4x4(0.03692586, -0.1367785, -0.051587723, 0.35746527, -0.05847086, -0.28233027, -0.31080168, 0.08979567, -0.057873387, -0.11724922, 0.11995725, -0.076051556, 0.12823316, 0.20808434, -0.07491586, -0.04471266), target);
	target = MulAdd(c3, MF4x4(0.17172146, -0.05962528, 0.10311508, -0.083008684, 0.017513666, 0.22941439, 0.08524968, -0.10340499, 0.047763754, 0.044772595, -0.087630406, -0.03647204, -0.043207247, -0.063256174, 0.14618406, 0.016736707), target);
	target = MulAdd(d3, MF4x4(0.014591894, -0.16730154, 0.019834492, -0.2323314, 0.2671534, -0.14437476, -0.10937011, -0.10888569, -0.16981846, -0.02661075, 0.011989267, 0.06811342, 0.084967375, 0.22203213, 0.05655957, -0.047086637), target);
	target = MulAdd(e3, MF4x4(-0.5673005, -0.54090023, 0.03939861, 0.008678989, -0.06290456, 0.2747319, -0.09248065, -0.06692429, -0.029515319, 0.08507081, -0.06997918, 0.16636486, 0.04376864, -0.606549, -0.16454232, 0.0572748), target);
	target = MulAdd(f3, MF4x4(-0.048000906, 0.3200884, -0.23506963, 0.15561248, -0.06658933, 0.18984286, 0.018985203, -0.018811712, 0.107549496, -0.24059664, 0.112164706, -0.14813146, 0.08943945, 0.030038312, 0.01712719, -0.06440537), target);
	target = MulAdd(g3, MF4x4(-0.04633894, 0.06511225, -0.006903819, 0.3651269, -0.05099921, 0.13553265, -0.07041649, 0.051354278, -0.026775079, 0.071171924, -0.10163997, 0.056618143, 0.121235944, 0.04077609, -0.006905747, 0.055543922), target);
	target = MulAdd(h3, MF4x4(-0.1529992, -0.07230882, 0.020437848, -0.15099072, 0.091357104, 0.10063594, 0.048747428, -0.07472622, 0.35976312, 0.110254094, -0.23728304, 0.32811522, 0.05135238, -0.124221064, 0.05848079, 0.0090888655), target);
	target = MulAdd(i3, MF4x4(0.10010241, -0.1336736, -0.0735869, 0.09731084, -0.23581249, -0.13519719, 0.2017027, 0.0660746, 0.073186494, 0.0008078537, 0.052478943, 0.031610224, 0.094252445, 0.14641911, -0.0314029, -0.070713595), target);
	target = MulAdd(na1, MF4x4(-0.001959657, -0.090372644, -0.1899317, -0.18170601, -0.015885344, -0.016746698, -0.17908786, 0.12600435, 0.13394068, -0.45021582, -0.059900366, -0.045920644, 0.0831188, 0.07898813, -0.058199428, 0.010207674), target);
	target = MulAdd(nb1, MF4x4(0.10158406, 0.34609744, -0.4304491, -0.039079092, -0.053127635, 0.32419643, 0.16021784, -0.02009982, 0.22342832, 0.25363946, -0.10637694, 0.084691174, 0.1643795, -0.11600526, 0.048834067, 0.007816396), target);
	target = MulAdd(nc1, MF4x4(-0.030290471, -0.12146855, -0.098269686, -0.14657338, 0.024690658, -0.059267156, -0.04505794, -0.0884074, -0.048493493, -0.07872248, 0.024751894, 0.021942955, 0.026951233, -0.05689244, 0.1141836, 0.086177684), target);
	target = MulAdd(nd1, MF4x4(-0.024428055, 0.1539053, 0.035455618, -0.11955061, -0.32286185, -0.046298236, -0.29223973, 0.3565024, 0.19302315, -0.35743472, -0.108984865, -0.041046027, -0.0797479, -0.11923923, -0.11282003, 0.048069157), target);
	target = MulAdd(ne1, MF4x4(-0.0021274649, -0.24638395, -0.051017568, 0.07722604, -0.13842508, -0.14636074, -0.09374905, 0.08258244, -0.09629832, 0.16782042, 0.036874052, -0.0015951502, 0.036216017, 0.09414314, -0.066247694, -0.051199514), target);
	target = MulAdd(nf1, MF4x4(-0.20425437, -0.08040027, -0.1613387, 0.06440151, 0.029663296, -0.20683208, -0.058772508, -0.0026178176, -0.15718235, -0.14013653, 0.005723365, 0.09514025, 0.07905292, 0.188446, 0.16387165, 0.1911544), target);
	target = MulAdd(ng1, MF4x4(0.07689394, 0.18216269, -0.02506441, 0.21607292, 0.14311059, 0.06318058, -0.081483, 0.28077206, 0.03948571, 0.17749293, 0.04567801, -0.07832511, 0.057806063, -0.0427108, 0.06306852, 0.0066801202), target);
	target = MulAdd(nh1, MF4x4(0.04399039, -0.07077558, -0.0015600047, -0.118459396, 0.060310606, 0.13951941, 0.2013669, -0.021006014, -0.15264805, 0.26732397, 0.035647463, -0.002574387, -0.065619715, -0.05531379, -0.048837233, -0.059936836), target);
	target = MulAdd(ni1, MF4x4(-0.05266133, 0.1071349, -0.053710256, -0.016416542, 0.022659063, -0.029553248, 0.09507555, 0.028677419, -0.20630527, 0.0651505, 0.077009074, -0.096268155, -0.14078818, 0.032669708, -0.01846629, 0.028775593), target);
	target = MulAdd(na2, MF4x4(-0.30971712, 0.19178517, 0.10254193, -0.12659942, 0.17826228, -0.26435316, -0.16852173, 0.04514394, 0.08112456, 0.11184146, -0.028571317, -0.030222327, 0.026687294, 0.17175198, 0.017020982, 0.0100025395), target);
	target = MulAdd(nb2, MF4x4(-0.1281852, -0.13685723, 0.046906084, -0.09659713, -0.02647301, 0.08286363, -0.19404687, -0.019731732, 0.12224579, -0.20480815, 0.08022694, 0.024619367, -0.040805798, -0.06307641, 0.07815454, 0.007009711), target);
	target = MulAdd(nc2, MF4x4(-0.036796696, 0.118744195, 0.020730056, -0.12533775, 0.018716114, 0.0073301513, 0.036968995, 0.009758767, 0.124895856, 0.105648, 0.1285451, 0.14944635, -0.22190575, -0.13435498, -0.07461175, -0.055744182), target);
	target = MulAdd(nd2, MF4x4(-0.41541776, 0.20976903, 0.089350834, 0.26153743, 0.050798908, 0.14616759, -0.06876315, -0.095800444, 0.21727456, -0.0044885483, -0.14532812, -0.03674323, -0.263549, 0.021403335, 0.090946734, 0.13801022), target);
	target = MulAdd(ne2, MF4x4(-0.20373783, 0.23166335, 0.12597165, -0.041975934, -0.10023279, -0.08657454, 0.16618101, 0.079674155, 0.018388273, -0.5596407, -0.04870662, -0.23710895, 0.18640874, 0.57623607, -0.02575096, 0.28287143), target);
	target = MulAdd(nf2, MF4x4(0.1625267, 0.343577, -0.04365838, 0.052335635, -0.2559281, -0.27649525, 0.13431759, 0.03831019, -0.03469164, 0.12000331, 0.073944256, -0.0061821216, 0.012677158, -0.1627391, 0.06749103, -0.20975526), target);
	target = MulAdd(ng2, MF4x4(-0.05379292, -0.10857011, 0.008266894, -0.012603182, 0.04662801, -0.070871636, 0.084626876, 0.16364849, -0.06294956, -0.06461058, -0.063480906, -0.044693593, 0.1537702, 0.079038486, 0.10722227, 0.16421016), target);
	target = MulAdd(nh2, MF4x4(-0.13676143, -0.117330894, -0.03341758, 0.052417997, -0.069416024, -0.005539735, 0.027587742, -0.01569091, 0.031894185, 0.019352077, -0.14948286, -0.09691313, -0.10240472, -0.06529738, 0.20694919, 0.04939535), target);
	target = MulAdd(ni2, MF4x4(-0.046459045, -0.2141496, -0.0023247367, 0.05856765, 0.0020768675, 0.19858378, 0.03415911, -0.021161001, -0.09474892, 0.09751605, 0.24057122, -0.085236825, 0.17543921, -0.09822015, -0.15396087, 0.024678698), target);
	target = MulAdd(na3, MF4x4(0.040772438, -0.025752101, -0.03428472, 0.061078012, -0.1637086, 0.019983971, -0.018367078, -0.08065508, -0.025617149, -0.041705422, -0.02537782, 0.103540875, 0.13783963, -0.056066163, 0.028678486, -0.025464006), target);
	target = MulAdd(nb3, MF4x4(0.16858733, -0.4178858, -0.30253845, -0.11040479, 0.0029255438, 0.44697702, 0.03196007, -0.02552841, 0.126962, -0.009455916, -0.04901387, 0.04048729, -0.07694209, -0.21343406, 0.02947534, -0.11690606), target);
	target = MulAdd(nc3, MF4x4(-0.15951762, 0.34968317, 0.08819681, 0.15680845, -0.072727524, -0.26647118, -0.253673, 0.058939222, 0.05429744, 0.003959121, 0.051335268, -0.030295422, -0.0600908, 0.030300785, -0.13709414, -0.050647613), target);
	target = MulAdd(nd3, MF4x4(0.031981096, 0.056341853, 0.006849355, 0.10382841, -0.2824565, 0.4246147, -0.057729505, 0.058494158, 0.39074966, -0.017238816, -0.15450741, 0.087315544, -0.1110259, -0.1719534, -0.053078342, 0.009343979), target);
	target = MulAdd(ne3, MF4x4(-0.041215084, 0.2654432, 0.1962931, 0.16274457, -0.08469727, -0.28789485, 0.05036308, -0.085442595, 0.12922712, -0.20311458, 0.38513032, -0.067850955, -0.025917724, 0.5953373, 0.12789808, 0.04950751), target);
	target = MulAdd(nf3, MF4x4(-0.08700668, -0.2649261, -0.095573485, -0.07602774, 0.04200743, -0.23400396, -0.186786, -0.123978846, 0.022072228, 0.18627988, -0.0038654353, 0.18318067, 0.034251608, -0.008562812, -0.035015855, -0.043611784), target);
	target = MulAdd(ng3, MF4x4(0.10827922, -0.03552119, 0.06193929, -0.18593708, 0.047373053, -0.2638056, 0.10326646, -0.040205717, 0.24228886, -0.0551458, 0.15253973, -0.215037, -0.07719752, -0.09540623, 0.028147982, -0.06663598), target);
	target = MulAdd(nh3, MF4x4(0.033009805, -0.044830184, 0.050585333, 0.07272593, -0.057132445, -0.30405456, -0.14489187, 0.015766555, -0.096756496, -0.13879722, 0.16658057, -0.0430357, -0.06502151, 0.05498304, -0.10471709, 0.10994919), target);
	target = MulAdd(ni3, MF4x4(-0.07091344, -0.01140124, -0.020643137, -0.067839414, -0.019193463, 0.07130566, -0.024614796, -0.09281402, -0.14832619, 0.18952662, 0.14351283, 0.11984917, 0.0012140581, -0.18912585, 0.07516603, -0.049291328), target);
	conv2d_1_tf1[gxy] = target;

	target = MF4(-0.062370587, 0.08095664, -0.05361836, 0.18749565);
	target = MulAdd(a1, MF4x4(0.046912298, 0.12213301, -0.05918361, 0.052398715, 0.117780685, -0.19340032, -0.26262107, 0.09843582, 0.16532594, 0.034989428, 0.118674256, -0.01665863, 0.01827071, 0.04668548, 0.022670027, -0.06799), target);
	target = MulAdd(b1, MF4x4(-0.40916896, 0.3377319, 0.029743252, 0.11290685, -0.07931422, -0.28883788, 0.3388208, -0.14807604, -0.33062622, 0.07752993, 0.049297906, -0.05600763, -0.14054057, 0.023377405, -0.0025995467, -0.14438824), target);
	target = MulAdd(c1, MF4x4(0.07433483, -0.20579776, 0.03441041, -0.039957307, 0.04162799, 0.07110215, -0.0790704, 0.08862456, 0.01354682, 0.008087094, -0.07781531, -0.0068795225, -0.27620977, 0.09188319, -0.0017635573, -0.057698507), target);
	target = MulAdd(d1, MF4x4(-0.18007079, 0.061591875, -0.06492421, 0.039863963, 0.09325244, -0.14426552, -0.13588732, 0.004743928, 0.12880403, 0.115125105, -0.01579009, -0.1262388, 0.23080756, 0.12070204, 0.11815605, -0.29426062), target);
	target = MulAdd(e1, MF4x4(0.1900564, 0.0071030534, 0.15973419, -0.30519736, -0.25476542, 0.0012610232, 0.09859447, -0.027793204, 0.11796082, 0.22148512, -0.02944728, -0.2323803, -0.072938465, 0.17895398, -0.2180017, 0.00051390607), target);
	target = MulAdd(f1, MF4x4(0.14343776, -0.18127762, -0.1516819, -0.18503034, 0.13295251, 0.16055906, 0.001688556, 0.15969595, 0.069709465, -0.096013926, -0.0023911218, -0.06369028, -0.0918679, 0.010184961, 0.32301244, -0.5343658), target);
	target = MulAdd(g1, MF4x4(-0.22987153, 0.013441173, -0.0016071151, 0.04102444, 0.23534702, 0.035319816, 0.0796226, 0.030342614, 0.111898474, 0.16501214, 0.06689771, 0.115711525, -0.12146473, 0.09451704, 0.019306619, 0.047459804), target);
	target = MulAdd(h1, MF4x4(0.09487664, -0.1618273, -0.008389976, -0.19419155, -0.26922193, -0.02975308, -0.0045531704, 0.05960872, -0.0601089, -0.14437221, 0.04238319, 0.15810688, -0.13148667, -0.15829994, -0.088278085, -0.21758209), target);
	target = MulAdd(i1, MF4x4(-0.14536136, -0.07484773, 0.037670642, 0.1888735, 0.0018068363, -0.059262045, -0.018976264, 0.027972398, -0.14075996, -0.109049946, -0.25289303, -0.016418003, -0.06421179, -0.15405136, -0.13614438, -0.20679462), target);
	target = MulAdd(a2, MF4x4(-0.24795865, -0.13466923, 0.1273892, 0.091988094, 0.22714299, 0.28389248, 0.10408641, -0.03565174, 0.10762112, 0.27623466, 0.025095293, -0.019155044, 0.022266177, -0.103916764, 0.02987535, -0.08026279), target);
	target = MulAdd(b2, MF4x4(-0.10837975, -0.21041337, 0.38324556, 0.34692577, -0.049697887, 0.1109414, 0.015196173, -0.13062784, -0.110540874, 0.085793406, 0.12470218, -0.034204576, 0.15388155, -0.10489124, -0.014710256, -0.024052056), target);
	target = MulAdd(c2, MF4x4(0.14277099, -0.08891012, 0.12166876, 0.005790089, 0.0022349167, -0.06719074, 0.0009688607, -0.06891284, -0.10870797, 0.031759914, 0.07620448, 0.025514454, 0.07622103, -0.017910544, -0.1925603, -0.020678718), target);
	target = MulAdd(d2, MF4x4(0.3488881, -0.3531885, -0.02848998, -0.105604745, 0.13216074, 0.059472002, 0.00468112, -0.003199541, -0.13952927, 0.12537865, 0.059789866, 0.047229134, 0.062295817, -0.20364402, -0.10756547, 0.010344998), target);
	target = MulAdd(e2, MF4x4(0.054537307, 0.003383981, -0.14703383, 0.23609836, 0.071702175, -0.03523012, -0.15024048, -0.15333411, -0.006573282, -0.17805523, 0.027630433, -0.10086782, -0.038341325, 0.16954458, -0.06587281, 0.061757658), target);
	target = MulAdd(f2, MF4x4(-0.14850424, -0.039801933, 0.091273226, 0.01890946, -0.074723765, -0.19870473, -0.10696538, 0.075856574, 0.18456846, -0.0575884, -0.19248867, 0.23468357, -0.06493671, 0.24994756, 0.2669619, -0.09178425), target);
	target = MulAdd(g2, MF4x4(0.05370938, -0.17381185, -0.06286066, -0.1121635, -0.124206446, 0.08903896, 0.01332919, 0.033238333, 0.10354104, 0.05441239, 0.093867265, -0.09941308, -0.13401549, -0.051170647, -0.05475329, 0.18579331), target);
	target = MulAdd(h2, MF4x4(0.17690988, 0.09592665, 0.0041792435, -0.012296416, -0.043736733, -0.19874738, -0.039244816, 0.093517475, 0.19160083, 0.0072470056, 0.20383999, -0.1518599, -0.056091193, -0.08362639, -0.13275301, 0.27358964), target);
	target = MulAdd(i2, MF4x4(0.03788787, 0.0504576, 0.011746947, -0.050620113, -0.13353047, 0.027618041, -0.015241799, 0.07525403, -0.016854452, -0.15185213, -0.23187985, 0.07745663, 0.019076057, 0.10091556, 0.22063738, -0.19460426), target);
	target = MulAdd(a3, MF4x4(0.4485975, -0.036630977, 0.08908842, -0.041333213, -0.33832982, -0.013137168, -0.12192155, 0.084681444, 0.05839531, 0.13613869, 0.01453744, -0.0015414358, 0.0554445, -0.0350119, 0.06942154, -0.09860217), target);
	target = MulAdd(b3, MF4x4(-0.6445962, -0.04228771, 0.018886134, 0.19037853, 0.18697917, 0.08801122, 0.023849122, 0.00056543655, -0.1744559, -0.039909426, -0.015196202, 0.09911629, -0.19838926, -0.20182554, 0.030066699, -0.061113726), target);
	target = MulAdd(c3, MF4x4(-0.28461948, -0.08841962, -0.03426622, 0.22100773, 0.10822605, 0.097787164, -0.035841815, 0.05503456, -0.038095083, -0.033080425, 0.059760638, -0.04379428, 0.016105307, 0.0015185064, -0.021058328, 0.07868167), target);
	target = MulAdd(d3, MF4x4(-0.09884352, 0.226838, 0.0069547887, -0.31872275, 0.051640913, -0.103925325, -0.033120554, -0.19772157, -0.33196652, 0.10513085, 0.008538118, -0.0693001, 0.3184994, -0.073985405, 0.0021704638, -0.20955746), target);
	target = MulAdd(e3, MF4x4(0.09394457, -0.37714124, -0.45972842, 0.11636775, 0.15764596, 0.14252996, -0.16795024, 0.04769986, 0.31756726, -0.0994127, 0.36237487, -0.12276988, 0.062678345, 0.11386392, -0.18050511, -0.029450653), target);
	target = MulAdd(f3, MF4x4(0.10891149, 0.23599482, 0.19260155, -0.01750993, -0.04561139, 0.040145233, 0.11951016, 0.008283346, -0.060648404, -0.1730897, -0.011636677, -0.2882733, 0.03563051, 0.15347542, -0.21334615, 0.17908043), target);
	target = MulAdd(g3, MF4x4(-0.04223735, -0.106301874, 0.101336, 0.047846835, -0.1828391, -0.1129037, -0.034007143, 0.106865816, 0.05654089, -0.02757468, -0.012872868, 0.07485427, 0.086521536, -0.009762037, 0.08281756, -0.015632132), target);
	target = MulAdd(h3, MF4x4(-0.2240338, 0.031013511, -0.09923691, -0.0038778447, -0.058668714, -0.01593757, 0.05261272, -0.016138611, -0.0143839605, 0.023330573, 0.024790224, 0.09925016, -0.08682536, 0.11822586, -0.055234805, -0.32288945), target);
	target = MulAdd(i3, MF4x4(0.27888787, -0.0025142857, -0.17712368, -0.067581266, 0.10133261, 0.1115825, 0.015883798, -0.24481313, -0.10126581, 0.06092374, -0.0786993, 0.16768995, 0.053283595, 0.08446579, -0.032040086, 0.046178747), target);
	target = MulAdd(na1, MF4x4(-0.04943332, -0.027568894, -0.017933179, -0.13208579, 0.16813855, -0.06046279, 0.03472982, 0.24612981, -0.03915912, -0.120075725, -0.08060205, 0.106469646, 0.103227176, 0.000895164, -0.028227922, -0.059619144), target);
	target = MulAdd(nb1, MF4x4(0.10014512, -0.11341153, 0.0827132, -0.10706114, 0.076696716, 0.383278, -0.08201294, 0.14486443, 0.036368996, -0.07771363, 0.008495598, 0.0022753903, -0.13788359, -0.038493663, -0.051340178, 0.06483918), target);
	target = MulAdd(nc1, MF4x4(0.12283316, 0.22500943, -0.20364822, 0.117888406, 0.052540295, -0.016513767, -0.008835836, -0.008336872, 0.008117048, -0.014924188, 0.070445575, -0.011796183, 0.120677724, -0.08490536, -0.040835287, 0.021124307), target);
	target = MulAdd(nd1, MF4x4(0.07237057, -0.07651541, -0.07781679, -0.046119276, -0.29511476, -0.15473935, 0.12942854, -0.037749447, 0.055873062, 0.081330314, -0.115750924, -0.1830763, -0.35462645, -0.11207306, -0.14393376, 0.18869524), target);
	target = MulAdd(ne1, MF4x4(-0.05859993, 0.09575829, -0.10934191, 0.1593984, 0.014064624, 0.23580766, -0.12417294, -0.0774491, -0.23603149, -0.17111291, 0.20246223, 0.24380091, 0.3189054, -0.21762544, 0.053053148, -0.057418585), target);
	target = MulAdd(nf1, MF4x4(0.056782614, 0.2491224, 0.15162024, 0.25830385, -0.045144927, -0.067923054, -0.12930688, -0.049425337, 0.0071653076, 0.046733644, -0.013108831, 0.09266598, 0.095575206, 0.08086839, -0.14152451, 0.26396653), target);
	target = MulAdd(ng1, MF4x4(0.079944104, -0.05263471, 0.021151286, 0.017748618, -0.20886436, -0.06915706, -0.078341156, -0.034786303, 0.053623807, -0.0655836, -0.11273695, -0.15438432, 0.06902305, 0.01620085, -0.011239084, -0.12818597), target);
	target = MulAdd(nh1, MF4x4(0.0032226495, 0.12590717, -0.0031638641, 0.14866307, 0.21612068, 0.07715579, -0.105438486, -0.17400137, 0.04665547, 0.18666393, -0.127797, -0.19163142, -0.03993708, 0.16110541, 0.05756885, 0.13376385), target);
	target = MulAdd(ni1, MF4x4(0.1687002, 0.021816095, -0.038648866, -0.052668236, 0.01839634, 0.07918797, -0.002949174, -0.062981784, 0.10759527, 0.096810766, 0.26538077, 0.042877536, 0.030417666, 0.2126483, 0.090904295, 0.12819949), target);
	target = MulAdd(na2, MF4x4(0.2518047, -0.06681589, 0.04622388, -0.070787035, -0.15511023, -0.41387925, -0.1730613, 0.044104673, -0.07129825, -0.16490258, -0.008386942, 0.016624527, -0.08768237, -0.018135691, -0.010196062, -0.012061386), target);
	target = MulAdd(nb2, MF4x4(-0.001268586, 0.061798558, 0.21913844, -0.044886224, 0.05442666, -0.16555135, 0.11374653, 0.035642505, 0.18183587, 0.08264069, -0.12153259, 0.11140945, -0.23343492, -0.11151265, 0.0064260047, 0.098349355), target);
	target = MulAdd(nc2, MF4x4(-0.13696936, 0.03562409, -0.0101959305, 0.07757505, 0.0394099, 0.08446535, 0.005326397, 0.06953561, 0.26667434, 0.070835635, -0.013025369, -0.09135739, -0.19930726, -0.15466705, 0.068868525, 0.06432818), target);
	target = MulAdd(nd2, MF4x4(-0.03636396, 0.082273535, 0.14712979, 0.00055138784, -0.29863998, -0.1502358, -0.10165026, -0.031016732, 0.017641982, -0.18515474, -0.13060197, -0.037918076, 0.0948058, 0.12216852, 0.1061389, 0.0049280017), target);
	target = MulAdd(ne2, MF4x4(0.0772463, -0.16946481, 0.43130034, -0.07500874, 0.11102152, -0.16219406, 0.095144905, 0.09938664, -0.103036284, 0.17237557, 0.03153515, 0.17011715, 0.04090995, -0.19434042, 0.034989282, -0.10372025), target);
	target = MulAdd(nf2, MF4x4(0.17383884, 0.00505153, -0.112281226, -0.034794528, 0.067649566, 0.20247048, 0.11118917, -0.10395416, -0.21711119, 0.032752357, 0.41753212, -0.16500826, 0.2285505, -0.10731952, -0.33513266, 0.17423174), target);
	target = MulAdd(ng2, MF4x4(0.13510819, 0.05318901, 0.06842423, 0.111380026, 0.032170407, -0.07004064, -0.004727209, -0.055246145, -0.041120853, -0.066667765, -0.12091067, 0.064465545, 0.30983046, 0.062509745, 0.13394639, -0.2320897), target);
	target = MulAdd(nh2, MF4x4(-0.11820305, -0.13822947, 0.042539548, -0.033613026, -0.0246929, 0.22179885, -0.0126101235, -0.12915117, -0.13849965, 0.02132361, -0.08306424, 0.25891247, 0.18283567, 0.031577725, 0.09138907, -0.26405686), target);
	target = MulAdd(ni2, MF4x4(-0.0025576213, -0.0058528413, -0.03972553, 0.016412497, 0.13415, 0.11366292, 0.06300578, -0.082534134, 0.035222337, 0.14385511, 0.34487328, -0.069680765, 0.06340447, -0.05378387, -0.27624515, 0.14444257), target);
	target = MulAdd(na3, MF4x4(0.015041839, -0.05496326, -0.077136815, 0.06463054, 0.3453119, 0.1475871, 0.0863952, -0.13123451, 0.13890652, -0.1339041, -0.070329, 0.0090441145, -0.10499933, -0.031464122, -0.087687746, 0.14039505), target);
	target = MulAdd(nb3, MF4x4(0.03533054, -0.17344387, 0.07036492, -0.14549953, -0.17900857, 0.13214236, -0.06371722, 0.08584117, 0.124349214, -0.05172205, 0.0056213615, 0.0025381348, -0.07292916, 0.15549947, -0.12606966, 0.008277057), target);
	target = MulAdd(nc3, MF4x4(0.088395566, 0.16676022, -0.014194714, 0.15820222, -0.12253527, 0.008114694, 0.04552204, -0.0402224, -0.044774655, 0.00047680718, -0.061174177, 0.004499639, 0.0028164221, 0.021954915, 0.007457284, -0.016612154), target);
	target = MulAdd(nd3, MF4x4(0.07245913, -0.12444683, 0.08628018, -0.013259242, -0.00566908, 0.23597822, 0.030804869, 0.1812487, -0.28520152, -0.12640676, -0.014197547, 0.17321649, -0.3233707, 0.015355323, -0.04023063, 0.134901), target);
	target = MulAdd(ne3, MF4x4(-0.008877037, 0.11245896, 0.013970579, -0.010476636, 0.046391398, -0.040462412, 0.43888882, -0.0028177807, 0.11008175, 0.22642863, -0.1705455, 0.25688764, -0.00687498, -0.0091281, 0.29534963, -0.023319326), target);
	target = MulAdd(nf3, MF4x4(-0.08283213, -0.2042435, -0.117713675, -0.11703066, -0.16029139, -0.26878926, -0.30223095, 0.052414846, 0.019514319, 0.16193534, 0.053438045, 0.13924578, 0.120410524, -0.07575857, 0.19710456, -0.103417814), target);
	target = MulAdd(ng3, MF4x4(-0.07692482, 0.034123767, -0.039485577, -0.11130344, 0.18672933, 0.07824195, 0.084815666, -0.1272111, -0.02006524, 0.20917512, -0.01049663, -0.15457591, -0.008278168, 0.08425196, -0.028542537, 0.021139478), target);
	target = MulAdd(nh3, MF4x4(0.1287116, 0.08821239, 0.016782869, -0.042757493, -0.06598697, 0.0057867267, 0.0031201676, -0.09951182, -0.17255504, 0.037690736, 0.22092989, -0.14002815, -0.021178395, -0.05137917, -0.0183439, 0.12713785), target);
	target = MulAdd(ni3, MF4x4(-0.12517771, 0.001307841, 0.102680914, -0.076987654, -0.063097425, -0.0044313464, -0.15392491, 0.18540211, 0.037581213, 0.0076559735, 0.064688995, -0.09571449, -0.079910435, 0.02357281, 0.102179624, 0.0054658144), target);
	conv2d_1_tf2[gxy] = target;
}

//!PASS 3
//!DESC Conv-4x3x3x24
//!IN conv2d_1_tf, conv2d_1_tf1, conv2d_1_tf2
//!OUT conv2d_2_tf, conv2d_2_tf1, conv2d_2_tf2
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass3(uint2 blockStart, uint3 threadId) {
	uint2 gxy = TileSwizzle8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	MF4 a1 = conv2d_1_tf.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b1 = conv2d_1_tf.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c1 = conv2d_1_tf.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d1 = conv2d_1_tf.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e1 = conv2d_1_tf.SampleLevel(sam, pos, 0);
	MF4 f1 = conv2d_1_tf.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g1 = conv2d_1_tf.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h1 = conv2d_1_tf.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i1 = conv2d_1_tf.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na1 = max(-a1, 0);
	MF4 nb1 = max(-b1, 0);
	MF4 nc1 = max(-c1, 0);
	MF4 nd1 = max(-d1, 0);
	MF4 ne1 = max(-e1, 0);
	MF4 nf1 = max(-f1, 0);
	MF4 ng1 = max(-g1, 0);
	MF4 nh1 = max(-h1, 0);
	MF4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	MF4 a2 = conv2d_1_tf1.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b2 = conv2d_1_tf1.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c2 = conv2d_1_tf1.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d2 = conv2d_1_tf1.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e2 = conv2d_1_tf1.SampleLevel(sam, pos, 0);
	MF4 f2 = conv2d_1_tf1.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g2 = conv2d_1_tf1.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h2 = conv2d_1_tf1.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i2 = conv2d_1_tf1.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na2 = max(-a2, 0);
	MF4 nb2 = max(-b2, 0);
	MF4 nc2 = max(-c2, 0);
	MF4 nd2 = max(-d2, 0);
	MF4 ne2 = max(-e2, 0);
	MF4 nf2 = max(-f2, 0);
	MF4 ng2 = max(-g2, 0);
	MF4 nh2 = max(-h2, 0);
	MF4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

	MF4 a3 = conv2d_1_tf2.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b3 = conv2d_1_tf2.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c3 = conv2d_1_tf2.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d3 = conv2d_1_tf2.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e3 = conv2d_1_tf2.SampleLevel(sam, pos, 0);
	MF4 f3 = conv2d_1_tf2.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g3 = conv2d_1_tf2.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h3 = conv2d_1_tf2.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i3 = conv2d_1_tf2.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na3 = max(-a3, 0);
	MF4 nb3 = max(-b3, 0);
	MF4 nc3 = max(-c3, 0);
	MF4 nd3 = max(-d3, 0);
	MF4 ne3 = max(-e3, 0);
	MF4 nf3 = max(-f3, 0);
	MF4 ng3 = max(-g3, 0);
	MF4 nh3 = max(-h3, 0);
	MF4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	MF4 target = MF4(-5.518393e-05, 0.0062874877, -0.02661609, 0.07653855);
	target = MulAdd(a1, MF4x4(0.06917031, -0.09608972, 0.012436778, -0.026526913, 0.06718373, 0.057737235, 0.05510206, -0.103320934, 0.032443568, 0.05391639, -0.051994696, -0.036722053, 0.07307222, 0.030999443, 0.28896815, 0.12696978), target);
	target = MulAdd(b1, MF4x4(-0.1135206, -0.0036884204, -0.067575626, -0.183155, 0.06799192, -0.040569484, 0.013326, -0.09218988, 0.027661508, 0.026157893, 0.07750759, 0.022186747, 0.034232542, -0.0006357425, -0.22527017, 0.09684553), target);
	target = MulAdd(c1, MF4x4(-0.02058118, -0.09091551, -0.020349659, 0.026089376, -0.0035277302, -0.025624726, 0.069313295, -0.0885836, 0.03267256, 0.0021243643, -0.02949528, -0.015609551, -0.014725211, -0.067495994, -0.013350565, -0.02226788), target);
	target = MulAdd(d1, MF4x4(-0.037397973, 0.031443134, 0.13686793, 0.033780698, -0.037809733, 0.14600267, -0.08467033, -0.062086526, -0.0037683318, -0.0025683658, -0.018997764, -0.032396015, 0.0760254, -0.06528604, 0.19034758, 0.25288334), target);
	target = MulAdd(e1, MF4x4(-0.01004077, 0.16253367, 0.02167237, -0.15804967, -0.07540531, -0.49940315, -0.08783108, -0.014712835, -0.0036181745, -0.13094778, 0.00012775385, -0.07735516, 0.00239906, 0.09345624, -0.44146279, 0.079626575), target);
	target = MulAdd(f1, MF4x4(0.018002989, 0.024756921, 0.08182335, -0.083457224, 0.033952054, 0.049469676, 0.06050263, -0.069849506, 0.0052918023, 0.06281211, 0.029289972, -0.033092137, -0.036357265, -0.10439873, 0.0023779173, 0.07888209), target);
	target = MulAdd(g1, MF4x4(-0.01730506, -0.022740714, 0.021063361, 0.082628556, -0.024639448, 0.023705823, -0.092249826, -0.0768989, -0.014783317, 0.0063639064, 0.0041929237, -0.015559529, 0.020817379, 0.065355465, -0.002106009, 0.04489612), target);
	target = MulAdd(h1, MF4x4(0.15640244, -0.016673775, 0.14370853, 0.0632943, -0.38425842, 0.106750414, 0.024923261, -0.31814602, -0.06830921, 0.028625946, 0.13381885, -0.022478523, -0.045712356, -0.045846578, -0.18020678, 0.09754457), target);
	target = MulAdd(i1, MF4x4(-0.08042041, -0.0629804, 0.00179941, 0.031233454, -0.031198358, 0.07125946, 0.13403404, -0.14895652, -0.007848355, 0.0073721707, 0.09500398, 0.008454506, 0.13026032, -0.067450196, -0.005805801, 0.028892282), target);
	target = MulAdd(a2, MF4x4(-0.08412081, 0.014766277, -0.020149631, 0.118712135, -0.04914816, -0.05792105, 0.29227188, 0.026034147, 0.1120047, 0.095002666, 0.00085259863, -0.048058935, 0.059555218, 0.016806047, -0.040286265, -0.013871916), target);
	target = MulAdd(b2, MF4x4(-0.029837646, -0.12694171, -0.091747016, 0.06701937, 0.03595908, -0.06499107, 0.07718667, 0.16839191, 0.060453057, -0.062339257, 0.06462464, -0.12997168, -0.012287718, 0.021051696, 0.036752645, -0.012775891), target);
	target = MulAdd(c2, MF4x4(0.020795425, 0.05475492, -0.05951276, -0.089259975, -0.016781978, -0.018492289, 0.037464686, 0.022631813, 0.04591149, -0.028302602, 0.021350577, -0.0019535497, 0.05372676, 0.0542445, -0.12681359, -0.16613637), target);
	target = MulAdd(d2, MF4x4(-0.06331373, 0.08271697, 0.0863126, -0.12388494, 0.032725193, -0.056309905, 0.23224412, 0.2616971, 0.09393073, 0.117842734, 0.24552049, 0.022186337, -0.100860044, 0.08032638, 0.08049447, -0.09940537), target);
	target = MulAdd(e2, MF4x4(0.3909181, -0.07477156, -0.36466175, -0.17175487, -0.055392284, 0.23718156, -0.34149098, -0.3924147, 0.07390285, -0.028201863, -0.2988869, -0.059178505, -0.035545774, -0.049048856, -0.18053558, -0.15981394), target);
	target = MulAdd(f2, MF4x4(0.12357816, 0.016537879, 0.08740827, -0.16022646, 0.03273305, -0.0133974645, -0.089761056, 0.044843633, -0.08129866, 0.06891703, 0.0075367647, -0.037070137, -0.12439461, -0.0033269753, -0.06834715, 0.08675626), target);
	target = MulAdd(g2, MF4x4(0.0064779734, 0.014426835, 0.035886277, 0.06754253, 0.02203813, -0.04712386, 0.023021698, 0.16410176, -0.0851561, 0.04949104, 0.23652297, -0.09268624, -0.04759872, 0.0015944376, 0.05121314, 0.03872179), target);
	target = MulAdd(h2, MF4x4(-0.03296315, -0.07756158, 0.011254165, 0.07215864, 0.05212682, -0.119309366, -0.10098557, 0.065113194, -0.6075043, 0.0944948, -0.0025391292, 0.07257945, -0.059234653, -0.02663308, -0.0056367065, 0.07748455), target);
	target = MulAdd(i2, MF4x4(0.1963255, -0.094376676, 0.077393346, -0.061023213, -0.023002017, 0.011871082, -0.035235405, -0.14450419, -0.010873058, -0.10108094, -0.026334947, -0.048716616, 0.15553881, -0.056554224, 0.07016727, 0.09666785), target);
	target = MulAdd(a3, MF4x4(-0.045733463, -0.07430657, 0.08238815, -0.123395115, -0.040635027, -0.059792377, 0.04978978, 0.14278086, -0.0541127, -0.10427179, -0.16961274, -0.1371796, -0.0011499986, 0.012152467, -0.0815682, -0.054046102), target);
	target = MulAdd(b3, MF4x4(0.0727944, 0.052526925, 0.009230718, -0.1476749, -0.09698198, -0.025520593, 0.02144377, 0.16131893, 0.0781747, -0.11812555, -0.035372186, -0.08136449, 0.05059057, 0.038647998, -0.037999127, -0.0015969436), target);
	target = MulAdd(c3, MF4x4(-0.018785287, 0.03944137, 0.11725696, -0.05008342, -0.10257986, 0.20005476, -0.06610143, 0.06656378, 0.006863046, -0.047056478, -0.093303435, 0.05993721, 0.020760732, 0.019373491, 0.062371906, -0.037439793), target);
	target = MulAdd(d3, MF4x4(-0.09267274, -0.098096795, 0.13675432, -0.06826833, -0.070104465, 0.099336594, -0.056031886, -0.089224756, -0.024747698, -0.0409895, -0.12682493, -0.2713339, -0.03058857, 0.074631155, 0.10274793, 0.0003064175), target);
	target = MulAdd(e3, MF4x4(-0.22578365, 0.35256356, -0.03433281, -0.16781186, 0.21457422, -0.028583825, 0.1498506, -0.17183648, -0.08763252, 0.12665057, 0.11524475, -0.122246034, 0.253632, -0.4412073, 0.1340533, 0.18091358), target);
	target = MulAdd(f3, MF4x4(-0.021586075, -0.13002236, 0.051525775, 0.018828293, -0.02971698, 0.1655956, -0.03223926, 0.097215585, -0.056743864, -0.029945962, 0.02934507, 0.03346959, 0.0409185, -0.0018111896, 0.04084656, -0.033254143), target);
	target = MulAdd(g3, MF4x4(0.029116312, 0.03399277, 0.05797433, -0.005187739, 0.051238127, 0.00043336756, -0.13381082, -0.11246873, 0.0627832, -0.1257258, 0.14857215, 0.08276562, -0.060543623, 0.066337794, 0.17844212, -0.039553978), target);
	target = MulAdd(h3, MF4x4(0.2723402, -0.08208666, -0.095256135, 0.097162515, -0.14603227, 0.098899886, -0.0382611, -0.13691731, 0.15835975, -0.11403104, 0.12741292, -0.0561908, -0.10390587, 0.1448454, -0.12705886, -0.08887692), target);
	target = MulAdd(i3, MF4x4(-0.07991212, -0.0016143702, -0.12167386, 0.07029745, -0.10117478, 0.02916672, -0.1567343, 0.037017304, 0.051464945, 0.040837154, -0.057838146, -0.043935794, -0.076173924, -0.0036469682, -0.16645731, 0.0867253), target);
	target = MulAdd(na1, MF4x4(-0.11595775, 0.1284538, -0.05438797, 0.0022007078, -0.029448986, -0.07199994, 0.08756202, -0.07034043, -0.025051784, -0.033049546, 0.042392526, -0.06789869, -0.02947519, -0.045615688, -0.04309908, 0.08332548), target);
	target = MulAdd(nb1, MF4x4(0.004717529, -0.103543915, -0.1741877, -0.22649112, -0.11224518, 0.03693626, 0.033321906, -0.10395231, 0.0022406306, 0.0030015993, -0.086861975, -0.08997641, -0.101462744, 0.018904945, 0.30255163, 0.18846805), target);
	target = MulAdd(nc1, MF4x4(-0.025068762, 0.117842294, -0.019883728, -0.30935752, 0.054619815, -0.00034203878, 0.045184523, -0.05716641, -0.0042491746, -0.014026439, 0.032082856, -0.076196544, 0.022468993, -0.03835101, 0.048660267, 0.11286454), target);
	target = MulAdd(nd1, MF4x4(0.02735938, -0.014684669, -0.08023435, 0.026778111, -0.0005380734, -0.11492771, 0.33912078, -0.042256307, 0.014511671, -0.0021652458, -0.032238156, -0.031997375, 0.0039656083, -0.023291625, 0.004515741, -0.08897747), target);
	target = MulAdd(ne1, MF4x4(0.19014491, -0.016315972, -0.042010665, 0.09270843, 0.023101632, 0.47071022, 0.17964542, -0.077132106, -0.0037992029, 0.10508138, 0.06516077, -0.062698394, -0.09827762, -0.08044165, 0.04393759, -0.09197626), target);
	target = MulAdd(nf1, MF4x4(0.032177076, -0.013111677, 0.074961565, -0.11895858, -0.027409771, -0.0819813, 0.1690814, -0.10718659, -0.011605623, -0.03553455, 0.057705663, 0.015013183, 0.056808244, 0.0005760722, -0.112802945, -0.077581756), target);
	target = MulAdd(ng1, MF4x4(-0.05866174, -0.007548838, 0.06423205, 0.1352578, 0.0021120945, 0.038740613, 0.17343003, -0.1917378, -0.0038229288, 0.0017887303, -0.007761856, -0.040798064, 0.014540869, -0.03441534, 0.04668393, 0.03392203), target);
	target = MulAdd(nh1, MF4x4(0.108784005, -0.032867312, 0.0037662825, 0.11089765, 0.29503173, -0.08232824, -0.034738302, 0.06927913, 0.013991651, -0.025746813, -0.020098314, -0.06911749, 0.030166877, 0.0090379, 0.009309999, -0.10990043), target);
	target = MulAdd(ni1, MF4x4(0.07052432, 0.0040574945, -0.051168878, 0.03484591, 0.07261664, -0.07470608, -0.024008736, -0.021155195, 0.020727258, -0.03774776, -0.07994904, 0.0009939631, -0.06001779, 0.09822139, 0.08215828, -0.20103115), target);
	target = MulAdd(na2, MF4x4(0.04484158, -0.09804021, 0.030515645, 0.14875132, 0.10324463, 0.024846723, -0.067153946, 0.21652295, 0.025289498, -0.02001657, -0.0704581, 0.03809796, 0.022647271, -0.005611969, -0.036561944, -0.113084584), target);
	target = MulAdd(nb2, MF4x4(-0.05300202, 0.021789892, 0.059347153, 0.31309023, -0.051712107, 0.12630393, -0.08832499, 0.051365335, 0.040092044, 0.05133063, 0.0385234, 0.12962072, 0.17568372, -0.0060678395, -0.1781195, -0.14315312), target);
	target = MulAdd(nc2, MF4x4(-0.023102503, -0.0285927, -0.10403815, 0.09859985, -0.02698703, 0.08473415, -0.104872644, 0.05867982, 0.017683612, -0.03389112, 0.0026875678, 0.12684359, -0.009682843, -0.06191043, 0.054384083, -0.06014585), target);
	target = MulAdd(nd2, MF4x4(-0.02089963, -0.052726943, 0.07328917, 0.09252698, -0.027794342, 0.096590534, -0.059459552, -0.016572969, -0.079190515, -0.101752184, -0.21771683, -0.08526713, -0.10136575, -0.19844209, -0.00960798, 0.18323036), target);
	target = MulAdd(ne2, MF4x4(-0.12765591, -0.118523166, 0.2949308, 0.3062008, 0.006089219, -0.19795562, 0.10176345, 0.5433496, -0.13549669, 0.18662079, 0.34634838, 0.15632492, -0.3137212, 0.09296755, 0.40942043, 0.35158914), target);
	target = MulAdd(nf2, MF4x4(-0.044083003, 0.046661552, -0.29044914, 0.18718201, 0.019889789, -0.038973954, -0.13862126, 0.019615972, 0.06718448, -0.078045554, -0.15514913, 0.20315526, 0.12544951, -0.059773993, 0.011969989, -0.13825978), target);
	target = MulAdd(ng2, MF4x4(0.024059854, -0.036478736, -0.06911277, -0.06703136, 0.018607026, 0.03248238, -0.045660738, -0.020493727, 0.07143626, -0.057682987, -0.14735365, -0.050512917, 0.086959876, -0.09022049, 0.17235179, -0.12725815), target);
	target = MulAdd(nh2, MF4x4(0.13649525, 0.12862304, -0.17249407, 0.068115726, -0.038493074, 0.05827213, -0.1687499, 0.065070905, 0.27157575, -0.07905134, -0.087201245, -0.08858087, 0.034717344, 0.044884644, 0.08977019, 0.13647328), target);
	target = MulAdd(ni2, MF4x4(-0.119835004, -0.02438879, -0.18067439, 0.20293695, 0.015848989, -0.04166136, 0.071957104, 0.124382295, -0.072059005, 0.071483135, -0.13201202, 0.0012418783, -0.10581831, 0.058075972, -0.17210579, 0.004112411), target);
	target = MulAdd(na3, MF4x4(0.00090041093, 0.0011212958, 0.031937573, -0.054099638, -0.017531581, 0.04035068, 0.037017923, 0.0010776994, 0.12191318, -0.007862255, 0.36464828, 0.21806385, 0.049670342, -0.011668101, 0.022543898, -0.025934925), target);
	target = MulAdd(nb3, MF4x4(-0.02645012, 0.02542059, 0.061260298, -0.029378504, 0.086143106, 0.030658819, -0.102650695, -0.10079073, -0.13305493, 0.121691555, 0.17571746, 0.20150271, -0.0353368, 0.13240956, -0.11879112, -0.09438184), target);
	target = MulAdd(nc3, MF4x4(-0.030693492, 0.023771469, -0.058636706, -0.08192801, 0.04515666, -0.18397073, -0.012662945, 0.0027336187, -0.036037542, -0.0677095, -0.030037174, 0.09132202, -0.042739432, 0.0677498, -0.0044881506, -0.08441004), target);
	target = MulAdd(nd3, MF4x4(0.10048813, 0.009793138, -0.041463297, 0.044800177, 0.04865773, -0.013068343, 0.11084613, -0.021099264, -0.16284342, 0.059396107, 0.34094337, -0.00569898, -0.013943217, 0.0776132, -0.2202739, 0.08115887), target);
	target = MulAdd(ne3, MF4x4(0.09100969, -0.30055302, 0.027439067, 0.14045873, -0.06795197, 0.02795258, -0.3790362, -0.0782406, -0.044285815, 0.060324147, -0.06306254, 0.048571646, -0.010744797, 0.09238931, -0.30406076, -0.034953397), target);
	target = MulAdd(nf3, MF4x4(-0.08555992, 0.30496204, -0.10318121, -0.109611206, 0.009205826, -0.13284884, -0.034745734, 0.116899915, 0.020474067, 0.087303326, -0.15484655, 0.07619201, 0.048834864, 0.09276454, 0.21443385, -0.16547905), target);
	target = MulAdd(ng3, MF4x4(0.029452972, -0.029714083, -0.034528464, 0.092740804, 0.059716754, -0.036405306, 0.054758668, 0.20863086, -0.09970437, 0.021823952, -0.057097975, -0.31107625, -0.014428003, -0.055435028, -0.079654545, -0.014873982), target);
	target = MulAdd(nh3, MF4x4(-0.30689985, 0.18918608, 0.08052377, 0.013860911, 0.07167599, 0.012683613, 0.09667366, 0.23917674, -0.092894726, 0.12865026, -0.23075777, -0.08828766, -0.19403586, -0.0040206606, 0.25459036, -0.09281851), target);
	target = MulAdd(ni3, MF4x4(0.038235266, -0.028659683, 0.009189875, 0.035079453, 0.066741906, -0.09272636, 0.15878148, 0.22836047, 0.024399906, -0.15650764, 0.030108603, -0.02879869, 0.06306548, 0.020737246, 0.17805946, -0.0968242), target);
	conv2d_2_tf[gxy] = target;
	
	target = MF4(-0.020544212, -0.052849937, -0.027093843, 0.018372845);
	target = MulAdd(a1, MF4x4(-0.11049855, -0.018907964, 0.10167619, -0.07320527, 0.16380642, 0.042582814, 0.15773618, -0.11309016, 0.030760022, 0.013475277, 0.034111183, -0.10673562, -0.06446281, 0.03170585, 0.065783545, -0.08132259), target);
	target = MulAdd(b1, MF4x4(-0.10073572, -0.038558394, -0.18257987, 0.09736078, 0.07116485, 0.10689451, 0.037241623, 0.06911952, 0.15752609, 0.025548095, 0.09447296, -0.16955513, 0.015093913, 0.026273884, 0.26519024, -0.3108458), target);
	target = MulAdd(c1, MF4x4(-0.07013285, 0.012493501, -0.03444474, 0.10600023, 0.031901475, -0.07758261, -0.036816508, -0.008185776, 0.04998539, 0.026604375, 0.08036296, -0.18479921, -0.098254114, 0.009431431, -0.056532584, 0.02986586), target);
	target = MulAdd(d1, MF4x4(-0.0944328, -0.016084116, 0.057588827, -0.03322943, -0.21524993, -0.0121686235, 0.14730252, -0.23106548, 0.038413823, 0.03569419, 0.14861591, -0.10776637, -0.052853543, -0.019915907, 0.11759964, 0.11250295), target);
	target = MulAdd(e1, MF4x4(0.06219863, 0.04539895, 0.04698554, -0.31864423, -0.012272204, 0.36264813, 0.068282306, 0.2822775, 0.012628343, 0.02692176, 0.09148334, -0.08816395, -0.16482702, -0.06446881, -0.18384305, -0.29771352), target);
	target = MulAdd(f1, MF4x4(0.100148946, -0.09134751, -0.063103884, 0.1403596, -0.016843816, -0.046195876, 0.030014044, -0.004548106, 0.048431028, -0.040574916, 0.014735356, -0.15846166, -0.2263108, 0.13999973, -0.0633166, 0.27665257), target);
	target = MulAdd(g1, MF4x4(-0.12594071, 0.0677989, -0.049229424, -0.15385626, -0.12750685, 0.020224968, 0.072655775, -0.37103048, -0.013367309, 0.017096536, 0.07398892, -0.16839914, 0.006098842, 0.018147936, 0.055607572, 0.0040595555), target);
	target = MulAdd(h1, MF4x4(0.12726252, -0.06711981, 0.11226904, -0.034675833, 0.13163973, 0.09057499, 0.15357189, -0.35910082, 0.0003699172, 0.01971659, -0.041180152, -0.12111229, 0.00043315487, -0.053538464, -0.076018356, 0.042511243), target);
	target = MulAdd(i1, MF4x4(0.14136468, 0.06641704, 0.046442796, -0.025372686, 0.100791246, 0.03306327, 0.07611193, -0.17730577, -0.027955538, -0.0078110253, 0.008712534, -0.087275945, 0.08230878, -0.0052679684, -0.103350714, 0.0865688), target);
	target = MulAdd(a2, MF4x4(0.13361642, -0.039004393, -0.023543444, 0.07136099, -0.12098764, -0.02865035, 0.092850566, -0.082029596, 0.036575377, 0.14037344, 0.09989788, -0.06525852, 0.10002514, -0.026618406, -0.12002266, 0.04573298), target);
	target = MulAdd(b2, MF4x4(-0.28081807, -0.08057377, -0.06789116, 0.019678107, -0.027069533, -0.016614377, -0.01618704, 0.24995302, -0.052341353, -0.07172657, 0.12574856, 0.1313798, -0.15072265, -0.09125269, 0.16099194, -0.13485655), target);
	target = MulAdd(c2, MF4x4(-0.19550133, -0.04183744, 0.024049545, -0.09530149, 0.100007616, -0.05702025, -0.013796386, 0.04444768, 0.1344129, 0.0993129, 0.10404407, 0.09173625, 0.012862574, 0.06720736, 0.06611082, -0.055998694), target);
	target = MulAdd(d2, MF4x4(0.16142978, -0.03735292, -0.043507334, -0.110913426, 0.10257733, -0.041712806, -0.18747051, 0.13936411, 0.020649113, -0.02688488, 0.21794553, -0.0689589, 0.16157758, -0.031158462, 0.13341765, -0.097379625), target);
	target = MulAdd(e2, MF4x4(-0.14022216, 0.15108277, -0.12174897, 0.034505684, -0.28282407, -0.0030200025, 0.06294236, -0.44982272, 0.09119184, 0.02005879, -0.09758412, -0.13265614, -0.21872388, 0.039521, -0.087356746, -0.20212357), target);
	target = MulAdd(f2, MF4x4(0.12638997, 0.5495008, 0.17717126, -0.08970275, 0.018967377, 0.04660826, 0.059454307, 0.17593576, -0.23507589, 0.12473919, -0.08162357, -0.06400482, -0.02973915, 0.009761158, 0.005129572, 0.051037535), target);
	target = MulAdd(g2, MF4x4(0.021429846, -0.034670793, 0.08353943, 0.02352908, 0.05054778, -0.019557012, -0.09459167, 0.2277268, 0.05714867, 0.075109184, 0.060369328, -0.10815987, 0.039977793, -0.058211602, -0.070377484, -0.0347485), target);
	target = MulAdd(h2, MF4x4(0.017368738, -0.015973292, 0.07625957, -0.08961148, 0.047681917, 0.050915856, 0.0910593, -0.0091246255, 0.14573355, 0.052380197, 0.15116148, -0.068882786, -0.0140725635, 0.02823435, -0.1579844, 0.07299422), target);
	target = MulAdd(i2, MF4x4(0.061255533, 0.03280513, 0.060110033, -0.036644097, -0.037236962, -0.026364978, 0.052616216, -0.13499284, 0.05801061, -0.0673201, -0.14684524, 0.23741283, -0.025241269, -0.1356566, -0.05841229, 0.1051435), target);
	target = MulAdd(a3, MF4x4(0.00022173181, 0.0643927, 0.028364835, 0.03683199, -0.031283405, -0.09468918, -0.29093724, 0.15719903, -0.021024697, 0.043887176, 0.0935728, 0.03710646, -0.0015930429, 0.1128033, 0.035463266, -0.017833339), target);
	target = MulAdd(b3, MF4x4(0.016239017, 0.033160247, -0.0012980856, 0.1643084, -0.068570554, -0.011817288, 0.07238526, 0.09016985, -0.037720326, 0.039096065, 0.18127714, 0.040145792, -0.072754, -0.010240024, 0.003931741, 0.1961971), target);
	target = MulAdd(c3, MF4x4(0.1582716, 0.059197184, -0.07311528, 0.15047154, 0.11910138, -0.16538778, -0.05161302, -0.13114272, 0.06918401, 0.09988292, -0.009128961, 0.022979198, -0.05816623, -0.0010521389, 0.049138065, 0.025934359), target);
	target = MulAdd(d3, MF4x4(0.005232625, 0.06572209, 0.08158597, -0.041485008, 0.10972084, -0.100233644, -0.08123889, 0.22106615, -0.15856642, -0.00089599646, -0.2508091, -0.18100697, 0.05062669, 0.015029212, 0.037986293, -0.042927373), target);
	target = MulAdd(e3, MF4x4(-0.059474643, 0.027163196, -0.2604915, -0.010336377, -0.12445887, 0.13566798, -0.30654848, -0.060082927, 0.23085387, -0.091465, 0.39375424, 0.042889137, -0.056025308, 0.032562573, -0.24045426, -0.066820875), target);
	target = MulAdd(f3, MF4x4(0.37940925, 0.059039116, -0.23255952, 0.13268405, 0.09298355, -0.3546018, 0.20099486, 0.110705115, 0.1028718, 0.15027377, -0.052708015, 0.077674516, -0.012042469, -0.24452698, -0.0897586, -0.05299548), target);
	target = MulAdd(g3, MF4x4(-0.08723447, -0.04039763, 0.06555755, -0.01244263, 0.0631391, -0.07041029, 0.09457601, -0.07120963, -0.006443017, 0.022470789, 0.083783925, -0.21022923, 0.09100827, 0.004317152, 0.14609122, -0.058026843), target);
	target = MulAdd(h3, MF4x4(-0.0845435, 0.117686994, -0.12543106, 0.12503773, -0.10377896, -0.0026920936, 0.1349612, -0.069376774, 0.084404066, 0.11193638, 0.09126277, -0.054743435, -0.0032069946, 0.06509136, 0.0048303395, 0.10628396), target);
	target = MulAdd(i3, MF4x4(-0.029292313, 0.007759757, 0.025865927, 0.056625884, -0.07793367, -0.04091509, -0.003351621, -0.033380255, 0.07060131, -0.036421955, 0.081770964, -0.043511044, 0.017399874, 0.043617025, 0.005139266, -0.021786831), target);
	target = MulAdd(na1, MF4x4(-0.022271145, 0.00039645372, 0.010613543, -0.11776198, -0.02635221, 0.11864236, -0.0024596716, 0.03923893, 0.0029042386, 0.005011855, 0.0018216589, 0.008130081, 0.011119617, 0.06787836, -0.066421315, 0.08031844), target);
	target = MulAdd(nb1, MF4x4(-0.09813517, 0.06568305, -0.13860098, -0.0010828839, 0.14380379, -0.13478349, -0.022100717, 0.17066574, -0.029020214, -0.022638777, -0.0070202127, 0.030224288, 0.16366352, -0.06265367, -0.18798734, 0.011478987), target);
	target = MulAdd(nc1, MF4x4(0.05996043, -0.053815104, 0.11500831, -0.08236374, 0.044013776, -0.041716296, 0.041496664, 0.14121005, 0.08279138, 0.009773295, -0.010372792, 0.025527438, 0.014913059, -0.066181764, -0.011920773, 0.10358109), target);
	target = MulAdd(nd1, MF4x4(0.05652108, -0.004097921, -0.062982805, 0.1622035, 0.16812254, 0.03779725, 0.09811821, -0.30795518, -0.03712885, 0.014134829, -0.07531538, -0.0353742, -0.014039425, -0.011970228, 0.036651116, -0.0004495905), target);
	target = MulAdd(ne1, MF4x4(0.11922151, -0.17507777, -0.04528375, -0.07090318, 0.19573775, -0.11706877, 0.0641675, -0.3705396, 0.0054832795, -0.048944287, -0.09650737, 0.09810468, -0.18202507, -0.08735016, 0.082755096, -0.018619625), target);
	target = MulAdd(nf1, MF4x4(-0.2286063, 0.06487897, 0.041627876, -0.112286136, 0.055056084, -0.024040936, -0.072515465, 0.095542595, 0.017591938, 0.037572965, 0.086499356, -0.044066917, 0.09246921, -0.14498484, 0.017450534, -0.0031692435), target);
	target = MulAdd(ng1, MF4x4(0.120006956, 0.029871983, -0.04091446, 0.1845348, 0.07152837, 0.0031324874, 0.3271476, -0.3842661, 0.015676577, 0.007722651, -0.01355098, 0.03852728, -0.036933925, -0.055561922, -0.08608098, 0.016633974), target);
	target = MulAdd(nh1, MF4x4(0.042973485, -0.016934913, -0.054753687, 0.0057244487, 0.080229886, 0.07153676, 0.121217705, -0.1422365, -0.022736007, -0.005441552, 0.059987642, -0.06661513, -0.008356551, 0.026571274, 0.014096615, -0.034175288), target);
	target = MulAdd(ni1, MF4x4(-0.10869293, 0.020983249, 0.014934219, -0.048246913, -0.043031503, 0.014160269, 0.012524968, 9.1027774e-05, 0.06874907, 0.041440487, 0.04364499, -0.049117107, -0.11006862, -0.028361427, 0.0666895, -0.15525119), target);
	target = MulAdd(na2, MF4x4(-0.13360004, -0.040586635, -0.011065811, 0.07590281, -0.17862478, 0.03176052, -0.0060847234, 0.06482111, -0.10241082, -0.06991013, -0.04906971, 0.111663744, -0.20776138, -0.065589525, 0.16063885, -0.1169129), target);
	target = MulAdd(nb2, MF4x4(-0.08239939, -0.016491726, -0.17447554, -0.17412238, -0.023073941, 0.024335802, 0.009998651, -0.2594834, 0.09212794, -0.047131993, 0.0023678474, -0.13931216, -0.093529895, 0.14654796, 0.2062498, -0.0979242), target);
	target = MulAdd(nc2, MF4x4(0.037110724, 0.16630705, -0.07703024, -0.09271235, -0.065290235, 0.011327393, 0.01392625, -0.08141591, -0.2544335, 0.11532231, -0.0038528284, -0.14333782, 0.052138682, 0.11441084, -0.13260897, 0.16820511), target);
	target = MulAdd(nd2, MF4x4(-0.30918753, -0.024295764, -0.027942184, -0.0860215, -0.055746336, -0.016570807, 0.17202388, 0.035703283, -0.16252916, 0.058050476, -0.15769738, 0.15678713, -0.116991155, 0.043470733, -0.383855, 0.18544619), target);
	target = MulAdd(ne2, MF4x4(0.110480964, -0.0018562422, 0.11564728, -0.15973495, 0.28632364, 0.07150075, -0.02442135, 0.09562533, -0.031401016, -0.04514724, 0.31314585, -0.09337406, 0.108728535, 0.017531324, -0.024494028, -0.093123734), target);
	target = MulAdd(nf2, MF4x4(-0.0803049, -0.23596147, -0.1215564, -0.07627238, -0.06644555, -0.02015921, -0.1534082, -0.0035896646, 0.20785846, -0.07450932, 0.083064035, 0.06505109, -0.06643723, -0.05675558, -0.06931419, -0.07988197), target);
	target = MulAdd(ng2, MF4x4(0.0042541623, 0.026418367, 0.06019002, -0.120204665, -0.041487366, 0.021887602, 0.060255744, -0.07371016, -0.12069726, -0.12678316, -0.049600363, -0.12936749, 0.23514399, 0.037363835, 0.014190557, 0.12650439), target);
	target = MulAdd(nh2, MF4x4(-0.09167683, -0.04038391, -0.022526316, -0.009859018, 0.008543954, -0.021847846, -0.09823242, 0.100713, 0.090360984, 0.09792457, -0.20315544, -0.035371944, 0.1085808, -0.06695963, 0.02482221, 0.024650661), target);
	target = MulAdd(ni2, MF4x4(-0.20332499, -0.07027695, -0.087853126, 0.18171547, -0.047613457, -0.024246145, -0.10522111, 0.23672101, 0.036521245, -0.08921485, -0.03288885, -0.031625647, -0.06543899, -0.069383, -0.00516059, -0.0017956651), target);
	target = MulAdd(na3, MF4x4(0.024934843, 0.03389753, -0.08901605, -0.037079386, -0.046384435, -0.02585016, 0.11197663, 0.00346106, -0.36492983, -0.093989864, -0.04062576, -0.026857732, -0.0070361346, -0.043496076, -0.015871098, 0.043276284), target);
	target = MulAdd(nb3, MF4x4(-0.03606492, 0.004693198, 0.06704513, -0.06954089, -0.06506014, -0.037918013, -0.08111133, -0.009501841, 0.068508595, 0.08327213, -0.019518502, -0.022806957, 0.2190603, 0.17022887, 0.14800793, -0.08281432), target);
	target = MulAdd(nc3, MF4x4(-0.064694725, -0.07497781, -0.04672195, 0.014982018, 0.043382764, 0.18891387, -0.038317963, 0.07969728, -0.063571155, 0.030154549, -0.08465413, 0.16925031, 0.12671013, -0.04915839, -0.096187495, -0.051536918), target);
	target = MulAdd(nd3, MF4x4(-0.009621753, -0.0195934, -0.045811757, 0.13657679, -0.064056486, 0.038231816, -0.054827668, -0.12231228, 0.26552272, 0.12414302, 0.18624337, -0.046787616, -0.022237374, -0.053084116, 0.14358921, -0.042177454), target);
	target = MulAdd(ne3, MF4x4(-0.07842658, 0.013456938, 0.032272052, 0.28887707, -0.10770709, -0.21856956, 0.37743518, 0.23959023, 0.37210184, 0.9503002, -0.025512097, -0.03633097, 0.022222593, 0.071377136, -0.20658484, 0.52729785), target);
	target = MulAdd(nf3, MF4x4(-0.099430755, -0.24070781, 0.065863, -0.07808372, -0.16720702, 0.2676829, -0.27154264, -0.049355835, 0.19279453, 0.06852905, 0.06272968, 0.13116297, 0.07394523, 0.12975569, 0.26263225, 0.15205261), target);
	target = MulAdd(ng3, MF4x4(-0.014191022, 0.018638015, -0.08631605, 0.061950725, -0.13144706, 0.084606856, -0.024304552, 0.0024966071, 0.021148616, 0.020798182, 0.13002335, -0.049378537, 0.017035907, -0.0116185695, -0.20568894, 0.2350694), target);
	target = MulAdd(nh3, MF4x4(-0.013792852, -0.05215396, 0.06764889, -0.012962138, -0.11838281, -0.015625363, -0.12466692, 0.12504981, 0.14459728, 0.034634247, 0.14713274, -0.118111566, 0.18801935, -0.14544547, 0.04915958, -0.14483985), target);
	target = MulAdd(ni3, MF4x4(0.04480321, 0.029159583, -0.06726701, -0.065100566, 0.094168976, 0.012941809, -0.035608374, 0.086288646, 0.043504182, 0.057368, -0.054148387, 0.09442852, 0.07997, -0.050284415, 0.046459693, -0.11076571), target);
	conv2d_2_tf1[gxy] = target;

	target = MF4(0.057122286, 0.012267435, -0.008509618, -0.033430006);
	target = MulAdd(a1, MF4x4(0.039423067, 0.078436814, -0.069983914, -0.038171016, 0.14237583, -0.02642111, -0.20049703, 0.100611456, -0.029072462, -0.5085375, -0.018193128, 0.059373964, -0.030980011, -0.11949504, -0.06939915, -0.0759268), target);
	target = MulAdd(b1, MF4x4(0.059159596, 0.17550206, 0.05612233, 0.13204549, -0.0050658686, -0.21678181, 0.07797472, -0.09275905, -0.06803014, -0.65021074, -0.07766355, 0.018018546, -0.26769254, 0.16147457, -0.2786428, 0.117244564), target);
	target = MulAdd(c1, MF4x4(0.08737985, -0.10133755, -0.026567303, -0.03721374, 0.03300279, 0.15863386, 0.14206086, 0.10378439, -0.024067098, -0.41554677, -0.096829094, 0.037365302, 0.047267284, -0.014426036, 0.08224506, -0.02312597), target);
	target = MulAdd(d1, MF4x4(0.054744978, 0.0014223085, 0.107521415, 0.044979066, -0.039141048, 0.23803799, -0.19850029, 0.19078358, -0.053693853, -0.51473075, -0.026663598, -0.03709435, 0.068645775, -0.461768, 0.05462371, -0.034951005), target);
	target = MulAdd(e1, MF4x4(-0.29620552, -0.008875074, 0.07487369, -0.22165461, -0.19263655, 0.048992947, -0.19407378, -0.04266071, -0.0410519, -0.9824355, -0.04094819, 0.1591373, -0.003784664, -0.03243022, 0.18372828, -0.21720201), target);
	target = MulAdd(f1, MF4x4(0.009888709, 0.13686997, -0.094822176, 0.05202961, 0.07718702, -0.111160606, -0.008345299, -0.03728517, 0.08747702, -0.609868, -0.004057196, -0.044258054, 0.06356071, 0.25430042, 0.020177737, 0.0132764075), target);
	target = MulAdd(g1, MF4x4(0.11496065, 0.21552022, -0.04389089, -0.0086625945, 0.09537117, -0.13809446, 0.08995812, 0.112047695, 0.011121139, -0.5289336, -0.022189362, 0.038001932, -0.1164996, 0.23712026, 0.020787118, -0.0011653812), target);
	target = MulAdd(h1, MF4x4(-0.09048339, -0.39137346, 0.21572241, 0.051918186, 0.11814622, 0.3203632, 0.024965152, -0.04971828, 0.009413184, -0.27384368, -0.06055165, 0.011737885, 0.06622072, 0.004352992, -0.16232811, -0.04402811), target);
	target = MulAdd(i1, MF4x4(0.09248723, 0.0889905, 0.024224376, 0.030123342, 0.03877418, -0.08895352, -0.13702047, 0.108477026, 0.040580783, -0.38253292, -0.017656842, -0.02734635, -0.10592393, -0.078880526, 0.06576184, 0.08253187), target);
	target = MulAdd(a2, MF4x4(0.015141747, -0.1309331, -0.02695935, -0.17821482, 0.06992731, 0.008076907, 0.04242278, -0.041699618, -0.2879429, 0.19774953, 0.049024932, 0.2859851, 0.07940857, 0.119633004, -0.0559928, 0.030878706), target);
	target = MulAdd(b2, MF4x4(-0.24421887, 0.13531625, 0.16485777, -0.16606078, 0.013032199, 0.22538358, -0.08584098, -0.09070285, 0.2687854, 0.16989781, -0.032257568, -0.017058974, -0.009155003, 0.24833599, -0.037294723, -0.030808553), target);
	target = MulAdd(c2, MF4x4(0.02493932, 0.114831686, 0.033882387, 0.14481047, -0.01829352, 0.115675755, -0.03021338, -0.004733893, 0.015008595, -0.19344689, -0.12460783, 0.047182407, -0.1743983, -0.09997754, -0.27779073, 0.07800383), target);
	target = MulAdd(d2, MF4x4(-0.043531906, 0.07293452, -0.071971625, -0.0019219422, -0.04766082, -0.1400812, 0.025305094, 0.05111917, 0.08387639, -0.31426215, -0.004437485, 0.15080883, 0.046185132, -0.34772637, 0.1205064, -0.073153645), target);
	target = MulAdd(e2, MF4x4(-0.18307851, 0.09229181, -0.17735274, 0.50427365, 0.034740254, -0.13563888, 0.027704779, -0.10706108, 0.32057324, 0.1820803, -0.28548205, -0.20837711, 0.026674472, 0.015941067, -0.07913227, 0.10543624), target);
	target = MulAdd(f2, MF4x4(-0.19075814, -0.07901908, -0.09471109, 0.38521093, -0.051173307, 0.22712201, -0.0057217837, -0.008397543, -0.094950974, -0.07692618, 0.08312472, -0.1183983, 0.042578284, 0.055876415, 0.0013518286, -0.024476144), target);
	target = MulAdd(g2, MF4x4(0.07312584, -0.14143293, 0.039240487, -0.04388676, -0.040030226, 0.23504035, 0.049412448, 0.047472715, 0.01382807, -0.2750679, 0.21508247, 0.053023193, 0.029611293, -0.0056723547, -0.01997564, 0.03959638), target);
	target = MulAdd(h2, MF4x4(-0.15638126, -0.19253428, 0.10116556, 0.08715779, -0.11614563, 0.098930575, 0.087547146, -0.028423786, 0.21491656, 0.13664484, -0.24975125, -0.08325575, 0.032616112, -0.18295531, 0.065003626, 0.021616168), target);
	target = MulAdd(i2, MF4x4(-0.007087224, 0.3169042, 0.14880657, -0.18242247, 0.0064674197, 0.06109478, -0.059897806, -0.0011404125, 0.18070918, -0.08458671, -0.12923287, -0.08353918, -0.01897949, 0.06979917, 0.09025345, -0.017417897), target);
	target = MulAdd(a3, MF4x4(0.05179286, -0.034726117, 0.21951278, 0.082072996, 0.07295873, -0.08012756, 0.014272455, -0.056287043, -0.017637976, -0.013951062, 0.054536913, 0.017742792, -0.009336327, -0.03538978, 0.011911002, -0.11776655), target);
	target = MulAdd(b3, MF4x4(0.13707292, -0.023107344, -0.00069132133, -0.08294918, -0.23168655, -0.096478485, 0.08214384, -0.059408333, 0.18943588, -0.03707817, -0.08321206, -0.22239017, -0.15046118, 0.120259546, 0.07002098, -0.09866878), target);
	target = MulAdd(c3, MF4x4(-0.012951499, -0.27445596, -0.14348228, 0.0447087, 0.046177246, 0.017482923, 0.05994589, 0.015270621, 0.06457534, -0.05479883, 0.013528706, -0.12819076, -0.06994984, 0.07996559, -0.06996563, 0.054592125), target);
	target = MulAdd(d3, MF4x4(0.10614017, -0.053328507, 0.08286402, -0.10957647, -0.12656961, 0.040465187, 0.17095993, 0.051273175, 0.04530683, 0.18120332, -0.027397426, -0.08206453, 0.069643475, -0.12606093, -0.058229, 0.18432495), target);
	target = MulAdd(e3, MF4x4(0.17823172, 0.41447365, 0.11639968, -0.06486261, 0.19411229, -0.19174264, -0.038545858, -0.10247162, -0.019421054, -0.009120293, 0.13342139, 0.04569454, -0.11488296, 0.080402605, 0.13746685, 0.14873841), target);
	target = MulAdd(f3, MF4x4(-0.0829372, -0.30971724, 0.032577418, 0.07669426, 0.018960338, 0.1791047, -0.047290523, -0.008268177, -0.04843848, 0.06855169, -0.07592713, 0.04155206, 0.08097685, 0.051547952, 0.011747727, -0.033211578), target);
	target = MulAdd(g3, MF4x4(-0.1373094, 0.15334417, -0.06870011, -0.06123882, 0.00090525567, 0.1162759, -0.082836166, 0.11193168, -0.08798139, 0.035071023, 0.01123731, -0.05533123, -0.024120709, 0.050991498, -0.1336545, -0.043407314), target);
	target = MulAdd(h3, MF4x4(-0.06407508, -0.33745393, 0.23901443, 0.052661825, 0.10159286, 0.07630392, -0.15228964, -0.03295662, -0.0060571227, 0.0071413037, 0.17815827, -0.12300588, 0.1899591, -0.25670734, 0.0070533925, -0.043219138), target);
	target = MulAdd(i3, MF4x4(-0.1732961, 0.30729872, 0.2262359, -0.21156187, 0.06456767, 0.021306427, 0.05425214, -0.083489835, -0.044103798, 0.052490056, -0.0044859303, -0.02098116, -0.0504092, -0.00038908, 0.039689723, -0.07444564), target);
	target = MulAdd(na1, MF4x4(-0.033599377, -0.08571998, -0.10530651, -0.08143152, -0.12479356, -0.060760368, 0.121969484, 0.038539995, 0.013419648, -0.08396321, 0.05109183, 0.017426316, -0.07328041, 0.05684259, 0.070007846, 0.10744751), target);
	target = MulAdd(nb1, MF4x4(-0.274972, 0.4282744, 0.22896598, -0.10019718, 0.16731918, 0.030695973, 0.041302808, 0.067710035, 0.023648342, -0.07225423, -0.038274363, 0.05649214, 0.2907932, -0.42040724, -0.012518357, -0.017642522), target);
	target = MulAdd(nc1, MF4x4(0.13465816, 0.25740397, 0.15255588, 0.095492624, 0.043392237, 0.020608524, 0.028149592, -0.02565965, 0.06586847, 0.0011866485, -0.037156094, 0.055193666, -0.04400515, 0.08791553, 0.010484813, -0.15319423), target);
	target = MulAdd(nd1, MF4x4(0.040082783, -0.06577737, -0.07995138, -0.16504121, 0.09325564, -0.22239633, 0.1648208, 0.028321613, 0.015860023, -0.08520523, -0.051657148, 0.061537597, 0.073225826, -0.14896914, 0.1299073, -0.006399767), target);
	target = MulAdd(ne1, MF4x4(-0.09663643, -0.53566885, 0.025700806, 0.55880916, 0.2808175, 0.05318815, 0.062414836, 0.10828044, 0.05490069, -0.081015244, 0.09650798, -0.12189763, -0.07257968, 0.26949814, -0.012583941, 0.0008959956), target);
	target = MulAdd(nf1, MF4x4(-0.011190751, 0.35855585, 0.1862791, 0.14002089, 0.027401952, 0.0042707003, -0.022745244, 0.10868378, -0.09141326, -0.17373067, 0.028805451, 0.017749606, 0.040033735, -0.011070057, -0.025801158, -0.13208073), target);
	target = MulAdd(ng1, MF4x4(0.024512364, 0.08858363, -0.18131207, -0.027412666, -0.04424581, 0.011799249, -0.082901396, 0.038419988, 0.024691217, 0.052292384, -0.009439586, -0.00092504063, 0.008878617, 0.025503607, 0.021490294, 0.056503642), target);
	target = MulAdd(nh1, MF4x4(-0.12956679, -0.34502396, 0.2046284, 0.026422406, -0.051775485, -0.004565459, 0.033549815, 0.24834748, -0.014039569, -0.008843974, -0.024532126, -0.028356941, 0.086490355, 0.19347343, -0.06651103, 0.01359097), target);
	target = MulAdd(ni1, MF4x4(0.026218938, -0.071594626, 0.058404952, -0.0064054746, 0.021394106, 0.003737053, 0.013854575, 0.11512703, 0.041950155, -0.12979212, 0.029137189, -0.035896428, -0.052289136, 0.14120553, -0.069520056, 0.083379924), target);
	target = MulAdd(na2, MF4x4(0.10193102, -0.011678638, -0.08350273, -0.1182253, -0.15432937, 0.20543317, -0.20413567, -0.080253944, 0.07646635, -0.020952104, -0.0104566, -0.10925271, 0.055971812, 0.032747865, 0.04048261, 0.08953569), target);
	target = MulAdd(nb2, MF4x4(-0.016132157, -0.08411032, -0.14439175, 0.056656662, -0.12841295, -0.051562544, -0.040920693, -0.027162159, -0.05479628, -0.13349691, -0.28604138, 0.053583436, 0.13565014, 0.11799203, -0.28183892, -0.14269474), target);
	target = MulAdd(nc2, MF4x4(-0.062003274, -0.048884556, -0.20334347, 0.22376512, -0.089073546, 0.11118097, -0.009234466, -0.07418679, -0.14703932, 0.16732392, -0.07114778, -0.06633442, 0.04149066, 0.061250567, 0.18997967, 4.3616074e-05), target);
	target = MulAdd(nd2, MF4x4(-0.013199228, 0.04439229, 0.022987943, 0.031648617, 0.028317936, -0.065302536, 0.12444893, -0.10333742, -0.055278953, 0.0026120062, 0.292226, -0.048765816, 0.094359584, 0.080392964, 0.04476662, -0.05632204), target);
	target = MulAdd(ne2, MF4x4(0.30331823, -0.13950066, 0.046152875, -0.049017597, -0.030433452, -0.098067395, 0.05823237, 0.23484923, -0.052533124, -0.17569515, 0.043904085, 0.34406292, 0.09246567, 0.44028738, -0.1541278, 0.10462374), target);
	target = MulAdd(nf2, MF4x4(-0.053813357, -0.06074867, -0.08128881, -0.015421247, 0.1122167, 0.06750029, -0.07663203, 0.06962623, 0.016814634, -0.018121587, -0.17165172, 0.06247406, -0.061192635, -0.21323347, -0.20642947, 0.024856035), target);
	target = MulAdd(ng2, MF4x4(-0.017261975, 0.001956938, 0.03585212, -0.051244717, -0.012848608, 0.060172677, -0.110458344, -0.14227545, 0.074150845, 0.122560345, 0.0022584137, 0.124024406, -0.0020875141, -0.44394484, 0.21422713, -0.04319881), target);
	target = MulAdd(nh2, MF4x4(-0.034175355, -0.010641907, -0.035431314, 0.009394309, 0.06870524, -0.020846654, 0.0075500663, -0.10564474, 0.031213112, 0.32362583, -0.01739634, -0.080315515, -0.026090765, -0.2125432, 0.17748094, 0.08196893), target);
	target = MulAdd(ni2, MF4x4(0.023425572, 0.058883358, -0.08460052, -0.06000809, -0.07512468, 0.15626664, 0.007509836, 0.019525077, 0.054792758, -0.23570415, -0.05554373, -0.14720254, -0.022515034, 0.04687545, -0.09122355, -0.08824173), target);
	target = MulAdd(na3, MF4x4(0.03242358, 0.009580177, 0.020231772, 0.022309156, -0.12902056, 0.14806129, -0.027296314, 0.063802026, -0.039501395, -0.01489755, -0.19859995, -0.10364646, 0.09310042, -0.028172733, -0.08560778, -0.030869158), target);
	target = MulAdd(nb3, MF4x4(-0.101350136, 0.05526243, 0.0035860895, 0.09896092, 0.19400865, 0.2449927, -0.18022242, 0.09199169, -0.0077618533, -0.18838565, -0.45503637, 0.20625886, 0.041608825, -0.114395924, -0.0850152, 0.0733077), target);
	target = MulAdd(nc3, MF4x4(-0.08502301, 0.15609683, 0.017885443, -0.02539383, -0.026503822, -0.036420856, 0.0021276672, 0.06999657, -0.046073034, 0.16763787, -0.14055778, -0.0049013835, 0.009052177, -0.09790551, 0.117615454, 0.048404485), target);
	target = MulAdd(nd3, MF4x4(-0.028804805, 0.004398154, 0.02801529, -0.0806873, -0.03933947, 0.12910266, -0.1326506, 0.08548417, -0.5164903, 0.07406561, 0.22457983, 0.14813408, -0.05975599, -0.019444315, 0.07565449, -0.23129421), target);
	target = MulAdd(ne3, MF4x4(-0.2850856, -0.12607557, 0.014540369, -0.08426361, -0.027262088, 0.20371006, -0.12156548, 0.17130668, -0.31521708, 0.049210936, -0.35247996, 0.18296543, 0.42723244, 0.2039884, -0.035021685, 1.1381091), target);
	target = MulAdd(nf3, MF4x4(0.08956528, -0.00317981, -0.07248739, -0.055904776, -0.03996253, 0.025405107, 0.00059332704, -0.037291884, -0.09004787, -0.23186557, -0.16186874, 0.0020177872, 0.022994975, -0.20395516, -0.17148314, 0.14748491), target);
	target = MulAdd(ng3, MF4x4(-0.0061345818, -0.16014275, 0.17222595, -0.07567761, -0.061348878, -0.1720377, 0.12391044, -0.1664243, 0.20054317, 0.053534795, 0.18869756, -0.15747075, 0.023294995, 0.19970472, 0.14656426, 0.033892497), target);
	target = MulAdd(nh3, MF4x4(-0.0951606, 0.114271455, -0.035583224, -0.0395411, -0.324703, -0.3520329, 0.32128307, -0.05776112, -0.12950924, 0.10391318, -0.0319499, -0.050979655, -0.13066222, -0.25933158, 0.021341946, 0.09927698), target);
	target = MulAdd(ni3, MF4x4(0.18134786, -0.057574477, -0.1466477, -0.046258144, -0.024677455, 0.04083935, 0.14517285, -0.25801346, 0.18157719, -0.090125926, -0.0036604172, -0.20966503, -0.00015470991, -0.016252374, -0.03844368, 0.06726928), target);
	conv2d_2_tf2[gxy] = target;
}

//!PASS 4
//!DESC Conv-4x3x3x24
//!IN conv2d_2_tf, conv2d_2_tf1, conv2d_2_tf2
//!OUT conv2d_3_tf, conv2d_3_tf1, conv2d_3_tf2
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass4(uint2 blockStart, uint3 threadId) {
	uint2 gxy = TileSwizzle8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	MF4 a1 = conv2d_2_tf.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b1 = conv2d_2_tf.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c1 = conv2d_2_tf.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d1 = conv2d_2_tf.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e1 = conv2d_2_tf.SampleLevel(sam, pos, 0);
	MF4 f1 = conv2d_2_tf.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g1 = conv2d_2_tf.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h1 = conv2d_2_tf.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i1 = conv2d_2_tf.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na1 = max(-a1, 0);
	MF4 nb1 = max(-b1, 0);
	MF4 nc1 = max(-c1, 0);
	MF4 nd1 = max(-d1, 0);
	MF4 ne1 = max(-e1, 0);
	MF4 nf1 = max(-f1, 0);
	MF4 ng1 = max(-g1, 0);
	MF4 nh1 = max(-h1, 0);
	MF4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	MF4 a2 = conv2d_2_tf1.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b2 = conv2d_2_tf1.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c2 = conv2d_2_tf1.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d2 = conv2d_2_tf1.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e2 = conv2d_2_tf1.SampleLevel(sam, pos, 0);
	MF4 f2 = conv2d_2_tf1.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g2 = conv2d_2_tf1.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h2 = conv2d_2_tf1.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i2 = conv2d_2_tf1.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na2 = max(-a2, 0);
	MF4 nb2 = max(-b2, 0);
	MF4 nc2 = max(-c2, 0);
	MF4 nd2 = max(-d2, 0);
	MF4 ne2 = max(-e2, 0);
	MF4 nf2 = max(-f2, 0);
	MF4 ng2 = max(-g2, 0);
	MF4 nh2 = max(-h2, 0);
	MF4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

	MF4 a3 = conv2d_2_tf2.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b3 = conv2d_2_tf2.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c3 = conv2d_2_tf2.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d3 = conv2d_2_tf2.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e3 = conv2d_2_tf2.SampleLevel(sam, pos, 0);
	MF4 f3 = conv2d_2_tf2.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g3 = conv2d_2_tf2.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h3 = conv2d_2_tf2.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i3 = conv2d_2_tf2.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na3 = max(-a3, 0);
	MF4 nb3 = max(-b3, 0);
	MF4 nc3 = max(-c3, 0);
	MF4 nd3 = max(-d3, 0);
	MF4 ne3 = max(-e3, 0);
	MF4 nf3 = max(-f3, 0);
	MF4 ng3 = max(-g3, 0);
	MF4 nh3 = max(-h3, 0);
	MF4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	MF4 target = MF4(0.06617475, 0.031411394, -0.08600086, -0.12331019);
	target = MulAdd(a1, MF4x4(0.04442572, -0.021079494, 0.08133416, -0.14203873, -0.07575563, -0.036278915, -0.02581178, 0.074260384, 0.110657595, 0.022575535, 0.14307183, 0.009784463, 0.0019734183, -0.022827094, -0.10990385, 0.018472824), target);
	target = MulAdd(b1, MF4x4(0.21470577, -0.102078706, -0.19685651, -0.10499778, -0.14538614, 0.12205785, -0.119196534, -0.12512656, -0.0157255, 0.06778767, 0.051144827, -0.061093763, -0.014912816, -0.10668368, 0.16782193, 0.04672345), target);
	target = MulAdd(c1, MF4x4(0.23532265, -0.06437796, -0.1636927, 0.096415624, -0.14463958, 0.07062449, -0.009412339, -0.053424593, -0.020204574, 0.048089918, -0.036215715, -0.140922, -0.11925414, -0.05972305, 0.0024522278, 0.09344713), target);
	target = MulAdd(d1, MF4x4(-0.007486091, -0.041294333, 0.03958969, 0.053319015, -0.0508917, -0.05159112, 0.11288304, 0.26939824, 0.024348699, 0.060014047, -0.034696687, 0.009803982, -0.019758658, -0.108922645, 0.14256927, -0.027265849), target);
	target = MulAdd(e1, MF4x4(0.08267747, 0.01354375, 0.33666995, 0.101669155, -0.110209286, 0.14248498, -0.16946654, -0.35839102, 0.20460105, 0.11426335, 0.11318654, -0.044304296, -0.076097116, 0.029738575, 0.15636109, -0.0552018), target);
	target = MulAdd(f1, MF4x4(0.14432563, 0.0046133446, -0.10694144, 0.022137064, -0.5636542, -0.13867012, -0.008164329, -0.12708999, 0.044234607, 0.115975946, -0.092227295, -0.07865807, 0.108110346, -0.017337924, 0.043074783, -0.041216116), target);
	target = MulAdd(g1, MF4x4(0.026432367, -0.06873426, 0.061831556, -0.00605308, -0.056780808, -0.07177329, -0.0057719476, 0.07050306, 0.027728474, 0.09348229, -0.09152759, -0.09133902, 0.024218138, 0.03562348, -0.018500235, 0.024786536), target);
	target = MulAdd(h1, MF4x4(-0.015634011, 0.00043256918, -0.08569041, 0.099786475, -0.13876541, 0.06958842, -0.21906306, 0.11165318, -0.09130837, 0.14580032, -0.102398746, 0.051243573, 0.059544906, 0.057559166, -0.033218343, 0.08339028), target);
	target = MulAdd(i1, MF4x4(0.006991434, -0.0743791, -0.088750206, -0.021417037, -0.29907656, 0.007902655, -0.036114752, -0.122924, -0.067659825, 0.029919846, 0.14793514, -0.097599104, 0.016503064, -0.1095046, -0.028360674, -0.058358364), target);
	target = MulAdd(a2, MF4x4(0.004909281, 0.071267895, 0.16850118, -0.054999575, -0.14304577, 0.02441106, 0.050973237, 0.009992714, -0.109278284, 0.07919291, 0.0077810627, 0.034462743, 0.047741413, 0.12163777, -0.12122584, 0.013382445), target);
	target = MulAdd(b2, MF4x4(0.0005590338, -0.015862202, -0.046375863, -0.091307804, -0.20246892, -0.059480507, 0.11874404, 0.17396803, -0.17960979, -0.034825385, 0.004660247, 0.1359996, 0.0032430585, 0.07977283, 0.148807, -0.05778742), target);
	target = MulAdd(c2, MF4x4(0.18160479, 0.043647032, -0.017925482, 0.017439943, 0.015033334, 0.011356719, 0.03396472, 0.004971239, -0.13910371, 0.044191893, -0.12855305, -0.056105338, 0.056831665, 0.133879, -0.063164115, 0.0071621994), target);
	target = MulAdd(d2, MF4x4(-0.113280386, 0.0025519284, 0.18671317, 0.08804424, 0.20677073, -0.0804015, -0.08834917, 0.09533873, 0.083148256, -0.048961774, -0.07908736, -0.02688625, 0.035848085, 0.10695606, -0.22634004, -0.13171262), target);
	target = MulAdd(e2, MF4x4(0.1707226, 0.08533742, 0.21622618, -0.21757056, -0.1274536, 0.08398028, 0.3202134, 0.022998685, 0.04880864, -0.34749946, 0.13356782, 0.054071113, 0.27817082, 0.082054846, 0.1917598, -0.028963286), target);
	target = MulAdd(f2, MF4x4(0.017651493, 0.026090013, -0.15366435, 0.04745487, -0.083071895, 0.04845406, 0.05552361, 0.096130624, -0.010397022, 0.053183064, -0.07440269, -0.027566215, -0.1770849, -0.02905562, 0.07577059, 0.01106056), target);
	target = MulAdd(g2, MF4x4(-0.09079958, 0.07023978, 0.013599515, 0.03719188, -0.029139029, -0.12541416, -0.1298324, -0.089526765, 0.026374, -0.03675827, -0.0664432, -0.10954637, -0.03706898, 0.07195458, 0.2083045, -0.13173243), target);
	target = MulAdd(h2, MF4x4(0.119648434, 0.085478894, 0.1322845, -0.217921, -0.0493358, 0.016056411, -0.008486342, 0.121576615, -0.15643454, 0.03276933, 0.096999034, -0.04267362, -0.0680802, 0.19929416, -0.09860732, -0.20886037), target);
	target = MulAdd(i2, MF4x4(-0.03567257, 0.09823424, 0.097885884, -0.0057406626, -0.007873974, -0.103281036, -0.013342071, -0.052842017, -0.15585557, -0.127313, -0.08575327, 0.012302473, 0.14850815, 0.1284913, -0.11507875, -0.053595018), target);
	target = MulAdd(a3, MF4x4(-0.054356705, 0.029001048, 0.017115368, 0.03151991, 0.18608244, 0.13901179, 0.57566303, 0.06494094, 0.028459521, 0.14781436, 0.06256118, 0.030419847, 0.07467109, -0.06440686, 0.053834237, -0.0071851187), target);
	target = MulAdd(b3, MF4x4(0.007199532, -0.121588215, 0.044833265, 0.27465758, 0.3438028, -0.023367146, 0.51061314, -0.238366, -0.2637815, 0.10414675, 0.23945883, 0.12390733, 0.23056524, -0.036144268, 0.029334458, -0.022119714), target);
	target = MulAdd(c3, MF4x4(-0.05376701, -0.06664099, 0.059821654, -0.0018416446, 0.2638233, 0.043670908, 0.3815553, -0.13832693, -0.0050786, 0.09253983, 0.23859836, 0.07963589, 0.07718028, -0.079752676, 0.11433723, 0.011501202), target);
	target = MulAdd(d3, MF4x4(0.1874364, -0.17093459, 0.010855328, 0.120664425, 0.111470625, 0.1484681, 0.5195336, -0.0069446685, 0.042319857, 0.05145161, -0.039009307, -0.01998825, -0.07303624, 0.09134541, 0.10079329, 0.030079208), target);
	target = MulAdd(e3, MF4x4(-0.2186243, -0.4428867, 0.092963874, 0.13073802, -0.019760692, 0.08763586, 0.34470505, -0.23975423, -0.49366876, 0.03650021, -0.26312304, -0.10178505, -0.19149905, 0.08961964, -0.03015555, -0.41838256), target);
	target = MulAdd(f3, MF4x4(-0.028188573, 0.031499006, -0.063600264, 0.24837458, 0.19443984, 0.058427423, 0.28769475, -0.08521067, -0.071029276, 0.14094949, 0.11166354, 0.049317956, -0.010624909, -0.06265303, 0.1114735, 0.02864904), target);
	target = MulAdd(g3, MF4x4(-0.052337993, -0.017547317, -0.03520667, 0.002673191, 0.1905491, 0.17264749, 0.32332307, 0.061626773, 0.136209, 0.19794804, 0.16509542, -0.04580146, 0.028514566, 0.041068107, 0.043710496, -0.13467996), target);
	target = MulAdd(h3, MF4x4(0.057524405, -0.0670017, 0.0016474138, 0.10262694, 0.036269784, 0.036402486, 0.44747186, 0.12797451, -0.047264162, 0.0766207, -0.23309897, -0.1266668, 0.074957475, 0.015929028, 0.2692563, 0.036415808), target);
	target = MulAdd(i3, MF4x4(0.17724822, -0.109371126, -0.0682871, 0.14675598, 0.054630626, 0.062969014, 0.36832303, -0.013787229, 0.024231227, 0.12613758, -0.055872746, -0.04053383, -0.006620505, 0.015584234, 0.035116877, 0.01693195), target);
	target = MulAdd(na1, MF4x4(0.19397566, 0.07098955, 0.18101004, 0.083367795, -0.070514366, -0.044412676, -0.062800385, 0.068795145, -0.19326128, -0.10733093, -0.1681797, 0.02347941, 0.09339788, 0.15950295, 0.057467394, 0.056237224), target);
	target = MulAdd(nb1, MF4x4(0.136637, -0.07271869, 0.26881287, 0.34395644, -0.04324773, 0.103202775, -0.16522674, -0.044781554, -0.086582124, 0.054414462, 0.065597564, 0.033376656, -0.111290336, -0.0014986617, -0.2212502, -0.25075877), target);
	target = MulAdd(nc1, MF4x4(-0.06789657, -0.18068478, 0.09911924, -0.23166406, -0.044929348, -0.031290393, 0.13361748, 0.03413577, -0.040923, 0.049681865, -0.07380375, 0.08915985, 0.07288317, 0.06554518, -0.1643758, 0.055818856), target);
	target = MulAdd(nd1, MF4x4(0.2203703, -0.037368517, 0.09785233, -0.06491308, -0.092911914, -0.031082682, -0.104810245, 0.034624774, -0.023380022, 0.0052404683, 0.06841838, -0.023614911, -0.03593765, -0.046437703, -0.1844866, -0.14166127), target);
	target = MulAdd(ne1, MF4x4(0.05909365, -0.36332077, -0.2689632, 0.1739602, -0.45130134, 0.12989542, -0.005341447, -0.06824331, -0.15072067, -0.05676317, -0.13605535, -0.18169174, 0.07681412, 0.124912, -0.021684267, 0.0894891), target);
	target = MulAdd(nf1, MF4x4(-0.035549298, -0.21778642, 0.097288795, -0.26111203, 0.10414918, 0.0061409012, -0.0556371, -0.032494467, 0.052588258, 0.06812076, -0.16265821, 0.118465446, -0.099786356, 0.0869041, -0.25942245, 0.009399633), target);
	target = MulAdd(ng1, MF4x4(0.11580169, -0.024714155, 0.010325179, 0.013701658, -0.076200895, 0.10303264, -0.094055474, -0.029318763, 0.07376417, 0.049632907, 0.032555673, 0.10790659, -0.101094194, 0.071630724, -0.109847575, 0.0077851396), target);
	target = MulAdd(nh1, MF4x4(0.1398949, -0.04883586, 0.23428173, -0.15378661, -0.100387186, 0.009293077, -0.008328632, -0.10520436, 0.035526622, 0.064958505, -0.1684589, -0.12430499, 0.13108692, 0.028732104, -0.0724291, -0.14364761), target);
	target = MulAdd(ni1, MF4x4(0.13408709, 0.037318103, 0.030060692, -0.02245396, -0.11561478, -0.07266053, -0.14419918, -0.15680459, 0.104011424, 0.0289589, -0.05245363, 0.02856205, -0.0973203, -0.009120509, 0.08775658, -0.08062229), target);
	target = MulAdd(na2, MF4x4(0.115849026, 0.06085271, -0.015712146, -0.035179697, 0.14623754, -0.027535545, 0.105676346, 0.28401312, 0.00610444, -0.18113948, 0.003972312, 0.022277411, 0.030053148, -0.06660701, -0.007032331, -0.026460487), target);
	target = MulAdd(nb2, MF4x4(0.105825655, 0.031863045, -0.011142612, -0.023293436, 0.0680703, 0.12657744, -0.31427047, -0.045503054, 0.019428464, 0.055280883, 0.033349436, -0.0824765, 0.04048357, -0.039309558, -0.13541335, -0.0711577), target);
	target = MulAdd(nc2, MF4x4(0.00587736, 0.066619515, -0.1982745, -0.12112423, -0.001499343, -0.06931127, -0.17176788, 0.030141942, -0.10718468, 0.07443775, -0.12964384, 0.122857764, -0.06771741, -0.07971639, -0.044493467, -0.0075695426), target);
	target = MulAdd(nd2, MF4x4(0.023990182, 0.052072257, -0.07704469, -0.05818583, 0.2703359, -0.1253082, 0.3321394, 0.51275367, -0.20541172, 0.087123945, -0.21254195, -0.21670723, 0.00083692186, -0.04276457, 0.10195174, 0.03721505), target);
	target = MulAdd(ne2, MF4x4(0.080449946, 0.18648995, -0.11595206, -0.15039912, -0.07889376, -0.31233358, -0.2996588, 0.551305, -0.20122233, 0.24880885, -0.04481761, -0.3973453, 0.10033973, 0.05511902, 0.029888729, 0.021694044), target);
	target = MulAdd(nf2, MF4x4(0.03702065, -0.088798195, 0.06667468, 0.044227604, 0.07188657, -0.04998249, 0.2439061, -0.1476103, -0.064125344, 0.034045372, -0.13339408, 0.109842144, 0.19029056, -0.029507356, -0.08236508, 0.07658855), target);
	target = MulAdd(ng2, MF4x4(0.028597932, -0.03854459, 0.047724374, 0.065792255, -0.09860975, -0.08000352, 0.10390718, 0.23593639, -0.11188388, 0.016842902, -0.11817977, 0.06368645, 0.055055078, 0.058349103, -0.08001618, -0.024517627), target);
	target = MulAdd(nh2, MF4x4(-0.16921136, -0.04083932, -0.00835477, 0.2030543, -0.012638247, -0.27452287, 0.0956476, -0.04617994, 0.15653826, 0.06020273, -0.10202549, -0.06836085, 0.11841569, 0.048987422, -0.07977096, -0.012123196), target);
	target = MulAdd(ni2, MF4x4(-0.0235341, -0.046976402, 0.032694343, -0.16520928, -0.017081633, -0.03708282, 0.07898976, -0.11212351, 0.11997062, 0.15722035, 0.06421537, 0.00097069755, 0.037570357, -0.040770754, -0.0743307, 0.0534563), target);
	target = MulAdd(na3, MF4x4(0.09699342, -0.09981163, -0.10912867, 0.10897145, -0.030223582, -0.014247349, -0.03482929, -0.01305651, -0.038396984, 0.009796579, -0.1132907, 0.077554524, 0.031296402, 0.014200385, 0.22940783, 0.13804206), target);
	target = MulAdd(nb3, MF4x4(0.1207108, -0.1887047, 0.15963583, 0.03816067, -0.017255, 0.008443818, -0.065400094, 0.044166937, 0.17263496, 0.14113733, 0.082817905, 0.082012236, 0.096803635, -0.06069386, -0.062445905, -0.04569513), target);
	target = MulAdd(nc3, MF4x4(-0.03677858, 0.027012087, -0.20495425, 0.16764086, -0.025615353, -0.0020314269, 0.007159334, -0.0044264444, -0.04242938, -0.04116411, -0.063763745, -0.016643412, -0.022430163, -0.09297498, 0.0027288082, 0.09743419), target);
	target = MulAdd(nd3, MF4x4(0.098948084, -0.13285282, 0.19235732, 0.2794696, 0.004499766, -0.015963264, -0.0557736, 0.0024319638, -0.048159864, 0.029840004, -0.32350582, -0.21436322, 0.11063215, -0.07647232, -0.061627094, -0.09123133), target);
	target = MulAdd(ne3, MF4x4(0.13004114, -0.12624854, -0.1305723, -0.18789066, 0.041747153, 0.019262334, 0.17703997, 0.02054544, 0.16357894, 0.09787803, 0.07931654, 0.23711719, 0.07959038, -0.14655703, 0.19117653, 0.5182774), target);
	target = MulAdd(nf3, MF4x4(-0.021226425, -0.15988874, -0.25700846, 0.08832854, 0.012499655, 0.011893902, 0.029938264, -0.0056565106, -0.047849346, -0.07041324, 0.1554268, -0.09428568, -0.057141136, 0.0027243465, 0.08234678, 0.028744241), target);
	target = MulAdd(ng3, MF4x4(0.011884608, -0.14763886, -0.021171318, 0.14934142, -0.018248998, -0.024268437, -0.014130621, -0.0027485457, -0.0809039, 0.05827554, -0.14076029, -0.1408414, 0.033655114, -0.113111265, 0.007957397, 0.024406865), target);
	target = MulAdd(nh3, MF4x4(-0.03952874, -0.10756346, -0.21955557, 0.07950554, -0.05224832, -0.0015799722, 0.019645864, 0.046215426, 0.025174068, 0.05614136, -0.02355428, 0.12604117, -0.05630602, -0.104844145, 0.0040577715, 0.20292816), target);
	target = MulAdd(ni3, MF4x4(0.08337458, -0.04375854, 0.12814969, -0.0505745, -0.02162198, -0.022859862, -0.009827576, -0.06884463, -0.13378213, -0.024044786, -0.1587514, -0.09542159, -0.079674646, -0.118072495, -0.015328217, -0.034902822), target);
	conv2d_3_tf[gxy] = target;
	
	target = MF4(-0.06898461, -0.06177714, -0.06478548, 0.022993876);
	target = MulAdd(a1, MF4x4(0.104435995, 0.08523803, 0.13313451, 0.01485225, -0.067918435, 0.17933276, 0.021827344, 0.0296916, -0.07059249, 0.0037901546, 0.016877035, -0.029718481, 0.013821487, 0.0051245163, -0.009027754, -0.0703365), target);
	target = MulAdd(b1, MF4x4(-0.13151535, 0.05132924, 0.2739186, 0.48619145, 0.13476053, 0.3685631, -0.027353717, -0.07500873, -0.05480841, -0.014034983, -0.085864894, 0.08971871, 0.07406436, -0.01183941, 0.16449541, -0.06773314), target);
	target = MulAdd(c1, MF4x4(0.013538097, 0.1583598, -0.055277165, 0.07637614, 0.07473682, 0.22345996, 0.030919895, -0.06126728, 0.02978074, -0.10157281, -0.1264838, 0.00084818545, 0.10940815, -0.0269847, 0.063068226, -0.03479123), target);
	target = MulAdd(d1, MF4x4(0.043592498, 0.18918565, 0.21017411, -0.023375075, -0.021484343, -0.06985366, 0.21826547, -0.00875028, 0.07610231, -0.08861247, 0.03791508, 0.0031226536, -0.028661136, 0.060399413, 0.0592066, -0.06264682), target);
	target = MulAdd(e1, MF4x4(0.21633635, 0.22528979, 0.47684777, -0.058535807, 0.08307837, -0.19632038, 0.12323838, -0.02472063, 0.056115244, 0.07563149, -0.083180495, -0.07311292, 0.03583403, -0.2776853, -0.20366116, -0.022084663), target);
	target = MulAdd(f1, MF4x4(0.057834644, 0.19703801, -0.047718063, 0.079801254, 0.12549312, 0.026414996, 0.023341564, 0.082731344, 0.14167784, 0.048134133, -0.04772942, 0.09571532, -0.097056195, 0.007009441, 0.06857669, 0.026794193), target);
	target = MulAdd(g1, MF4x4(0.041096892, 0.006188847, 0.11750499, -0.13447829, 0.0017394158, 0.01783059, 0.15956202, -0.03767544, 0.02673659, -0.05342451, -0.14283001, 0.004724371, -0.024063434, 0.023162393, 0.054349884, -0.10900122), target);
	target = MulAdd(h1, MF4x4(0.07189023, 0.014259161, -0.028867813, -0.045834795, 0.14308538, 0.17444627, 0.17258337, 0.022358263, -0.05739824, 0.07874781, 0.00055093376, -0.12329737, -0.063672766, 0.025692929, -0.052464493, 0.17745042), target);
	target = MulAdd(i1, MF4x4(0.026802428, 0.13577338, -0.06985617, 0.074659124, 0.1569288, 0.08905961, 0.012837567, -0.052218303, -0.025591483, 0.119624466, 0.024393069, 0.19790728, -0.037801497, 0.05334152, 0.019320685, -0.012112278), target);
	target = MulAdd(a2, MF4x4(0.05892214, -0.032721363, -0.045643594, -0.030719811, -0.104445435, -0.1574105, -0.06973961, 0.0880568, -0.015203705, -0.13851601, -0.01675903, -0.025943246, 0.05482791, -0.08070468, 0.0048817545, -0.2195491), target);
	target = MulAdd(b2, MF4x4(0.21571757, -0.1806072, -0.010998025, 0.020393362, 0.021816706, -0.018158916, -0.11101471, 0.016325697, -0.12101562, -0.049236, -0.20187455, 0.1455995, 0.04611496, 0.08955074, -0.098323554, 0.009564463), target);
	target = MulAdd(c2, MF4x4(0.005143037, 0.031717982, -0.050139457, -0.1109613, 0.03775848, 0.00954106, -0.06293631, 0.0890101, -0.00040289984, -0.03748492, -0.06439364, 0.07678777, 0.08420904, -0.019876583, -0.122263946, -0.06204237), target);
	target = MulAdd(d2, MF4x4(-0.20215075, 0.050689973, -0.046013024, 0.0023596657, -0.15971628, -0.20731676, 0.12560777, 0.29917854, -0.111574054, -0.04077845, -0.11790463, 0.04522926, 0.18117487, -0.17887163, -0.09449106, -0.32954872), target);
	target = MulAdd(e2, MF4x4(-0.048394788, 0.0773854, 0.069474846, -0.15471548, -0.22533698, -0.03836189, 0.042107325, 0.07787484, -0.19023094, -0.31975862, 0.027023884, 0.22310641, -0.30156738, -0.18671185, 0.10680384, -0.17596984), target);
	target = MulAdd(f2, MF4x4(-0.049384125, -0.10053522, -0.02494229, 0.13089181, 0.12716612, -0.011930183, -0.055107582, -0.011396776, -0.037174955, -0.07332422, -0.037290994, -0.020584442, 0.12331001, -0.15849335, -0.11254808, -0.0070635113), target);
	target = MulAdd(g2, MF4x4(0.10335844, 0.014899349, -0.064154595, -0.0028669129, 0.034805696, -0.18495506, 0.005376811, 0.08496156, 0.013403576, -0.014818112, -0.01596864, -0.03724775, 0.07349724, -0.0763195, 0.0443468, -0.22289227), target);
	target = MulAdd(h2, MF4x4(0.121551886, 0.006529306, -0.013299677, -0.19693732, -0.0043474436, -0.19871178, -0.052884568, 0.074092165, -0.038850788, 0.033550348, -0.08163774, 0.06271596, 0.20859785, 0.0067883697, -0.046475146, -0.48063815), target);
	target = MulAdd(i2, MF4x4(0.083180554, 0.052318644, 0.03218632, 0.11313337, -0.031635284, -0.09441545, -0.004538136, 0.03766669, -0.15290408, 0.029063439, -0.08709602, 0.20032041, 0.10752559, -0.025936332, -0.16803461, -0.31867516), target);
	target = MulAdd(a3, MF4x4(-0.011112246, 0.05966688, 0.08825975, -0.06790863, -0.0754694, -0.19575286, 0.08554758, -0.18269138, -0.1280453, 0.18379766, -0.08955887, 0.17286651, -0.013172642, -0.0035751443, 0.055351105, -0.02254156), target);
	target = MulAdd(b3, MF4x4(-0.11329527, 0.181477, -0.054028887, 0.037797876, -0.14424248, -0.15426451, -0.0749264, -0.15829895, -0.09827482, 0.13866791, 0.013977896, 0.3066159, 0.03892076, 0.0022721966, 0.088637464, -0.18673263), target);
	target = MulAdd(c3, MF4x4(0.052434247, 0.1075718, 0.09951973, -0.026689908, -0.082213305, -0.068657055, -0.10954474, -0.36598998, 0.059983972, 0.071539626, 0.105706535, -0.014004922, -0.04493435, -0.00943364, 0.014306285, -0.086277805), target);
	target = MulAdd(d3, MF4x4(-0.07653824, -0.05569481, 0.12022612, -0.02960086, -0.0827238, -0.12082348, 0.018902717, -0.17416616, -0.03121552, 0.008206833, -0.10166017, 0.0037599066, -0.009543466, 0.0020527479, 0.050042894, -0.10293714), target);
	target = MulAdd(e3, MF4x4(0.14261888, -0.1898871, -0.15847605, 0.028050601, -0.016525509, -0.03094436, -0.19239494, -0.18140908, 0.14230183, -0.33403888, -0.39611194, 0.13778488, 0.1988197, -0.06581933, 0.002683303, -0.108148), target);
	target = MulAdd(f3, MF4x4(-0.037351307, -0.09952294, 0.024785696, -0.0168355, -0.07218153, -0.1065052, -0.081961505, -0.15091445, 0.18406965, 0.13677996, -0.14867578, 0.089149386, -0.05840212, -0.059798297, -0.0201243, -0.029525604), target);
	target = MulAdd(g3, MF4x4(-0.009857878, -0.087470345, 0.011972532, -0.13542594, 0.0354294, -0.20797616, -0.024621738, -0.08760984, 0.072218195, -0.13620329, -0.050354343, -0.17628804, 0.0071922955, 0.0018819867, -0.03858231, 0.018087402), target);
	target = MulAdd(h3, MF4x4(-0.1553403, -0.03627257, 0.004989727, -0.0921159, -0.05149391, -0.21778369, -0.06126919, -0.072652444, 0.22329745, -0.11201775, -0.122997835, 0.05540077, -0.07249663, 0.0042517297, -0.05706445, 0.017356722), target);
	target = MulAdd(i3, MF4x4(-0.05847665, -0.015685597, 0.14335254, -0.007372796, -0.0077773617, -0.08556339, 0.06739385, -0.04068274, 0.15799382, 0.038163103, 0.05265575, -0.08238097, 0.040807348, -0.07065019, 0.028166778, -0.15436243), target);
	target = MulAdd(na1, MF4x4(-0.16044334, 0.283655, -0.022656776, 0.08448171, -0.038254652, -0.044832315, 0.08454063, 0.007472126, -0.009800128, 0.18591672, 0.10872203, -0.058036473, -0.098420285, 0.023155827, -0.04196021, 0.09891162), target);
	target = MulAdd(nb1, MF4x4(-0.17852576, 0.54625523, -0.081733584, 0.081366554, -0.069625385, -0.11218507, 0.028421586, 0.071588986, -0.014985082, -0.087979324, 0.3142317, -0.19760501, -0.16015647, 0.13895224, -0.2701074, 0.30648437), target);
	target = MulAdd(nc1, MF4x4(-0.014566373, 0.02057931, 0.10014358, 0.06578205, -0.15359782, -0.11839336, 0.13061163, 0.076945096, -0.01413561, -0.013397205, 0.015244041, -0.10279087, 0.09975661, -0.023128696, -0.016278943, 0.18001132), target);
	target = MulAdd(nd1, MF4x4(-0.06356644, 0.14646067, 0.016344864, -0.013904187, 0.064943634, -0.1281504, -0.06950529, -0.028252209, -0.011304186, 0.04061305, 0.09251525, -0.05251633, 0.09714447, -0.05430799, -0.17469239, 0.1850043), target);
	target = MulAdd(ne1, MF4x4(-0.14378282, 0.22984904, 0.32252252, 0.26133427, 0.45289674, 0.14866802, -0.24101377, -0.18861331, -0.030501021, -0.1883431, -0.13604005, -0.15657176, 0.020317623, 0.23096721, 0.10420801, 0.15710264), target);
	target = MulAdd(nf1, MF4x4(0.06454669, -0.04189079, 0.056962494, -0.04948231, -0.2148223, -0.039649688, -0.0113121355, 0.20814565, 0.111416936, -0.035151463, -0.056465276, -0.080573045, -0.07819258, 0.018179936, -0.2283728, 0.12155499), target);
	target = MulAdd(ng1, MF4x4(-0.02560027, 0.070398115, -0.02989104, 0.028688442, 0.04278315, 0.013474358, -0.07253673, 0.02276444, 0.12581308, -0.03901054, 0.08311041, -0.08153711, 0.02564736, -0.043852035, -0.028089473, -0.044236403), target);
	target = MulAdd(nh1, MF4x4(0.09625976, 0.005770156, 0.16631871, -0.1034893, -0.19147423, 0.004631949, -0.07540428, 0.015621006, 0.03929467, 0.04762953, -0.080173716, -0.10179307, 0.059833538, 0.05659006, -0.13382521, -0.0313998), target);
	target = MulAdd(ni1, MF4x4(0.07715199, -0.03317866, -0.024203375, -0.1298324, -0.09655965, -0.026206894, 0.18922973, 0.07624604, -0.007847103, -0.058786727, -0.049493928, 0.019805223, -0.008090047, -0.019503202, -0.064513676, 0.10351463), target);
	target = MulAdd(na2, MF4x4(0.022054255, -0.07858889, -0.10127163, -0.06832876, -0.07584891, 0.04215273, -0.0029053919, 0.08290376, -0.03475005, 0.08332925, 0.009553486, 0.07245685, -0.017920833, 0.015080806, -0.0002565289, 0.006093501), target);
	target = MulAdd(nb2, MF4x4(0.09178481, 0.013873079, -0.02395207, -0.133258, -0.08877421, -0.21369275, -0.11754095, 0.17205496, 0.012909828, 0.10264451, 0.23808923, 0.055029023, 0.034399036, -0.046347205, 0.0067525543, 0.0777463), target);
	target = MulAdd(nc2, MF4x4(-0.02699122, 0.04746888, -0.113287434, -0.025223, -0.005920497, -0.21902934, -0.13731015, 0.014423957, 0.036004063, 0.05559045, -0.0655789, 0.13083544, -0.06181434, 0.042077873, 0.022695009, 0.043042142), target);
	target = MulAdd(nd2, MF4x4(0.05076442, -0.06772015, -0.044568565, -0.018430268, -0.046832457, 0.14489225, 0.118378006, 0.053310696, 0.117090195, 0.23086876, 0.058276806, -0.03198186, -0.026497893, 0.09645919, 0.08429416, -0.022437949), target);
	target = MulAdd(ne2, MF4x4(0.06788362, -0.071499035, -0.03412108, -0.1442882, -0.061426826, 0.15115702, 0.20443979, 0.42235458, 0.34301203, 0.15906362, -0.4573595, -0.38218448, 0.074763715, 0.03956433, -0.2741876, -0.045825735), target);
	target = MulAdd(nf2, MF4x4(0.042785604, 0.086842, 0.06526033, -0.26330376, -0.13392642, -0.09802622, -0.060285453, -0.04659627, 0.063904576, 0.030205727, -0.02990855, -0.03692373, 0.009259516, -0.033007562, -0.027945964, 0.12487634), target);
	target = MulAdd(ng2, MF4x4(-0.04833785, 0.025812654, 0.09670586, -0.0398005, 0.084576905, 0.006827775, 0.21430464, -0.062337395, 0.01071662, 0.042277753, -0.07786652, 0.080589384, 0.050834, -0.018442666, -0.10043296, 0.0051965285), target);
	target = MulAdd(nh2, MF4x4(-0.06940597, 0.0052362564, 0.11979121, 0.002420146, -0.014626038, -0.033247836, 0.07638099, 0.024731234, 0.13817027, -0.034607813, 0.069013715, -0.1591328, 0.017410269, 0.020814985, -0.071453065, 0.07467316), target);
	target = MulAdd(ni2, MF4x4(-0.03586743, 0.0875829, 0.14604242, -0.08374493, -0.015870938, -0.037566822, -0.04257119, 0.013528102, 0.051471747, -0.00025074458, -0.043193746, -0.10538127, -0.0122199105, -0.0105835805, 0.096613646, -0.0008547738), target);
	target = MulAdd(na3, MF4x4(-0.09195929, -0.01251629, 0.1138194, -0.03152187, -0.027415436, 0.017695861, -0.05137721, -0.0006171527, 0.021749081, 0.070172004, 0.057883944, -0.031044329, -0.036268383, -0.17082807, -0.0331674, -0.03538632), target);
	target = MulAdd(nb3, MF4x4(-0.27754265, -0.029477704, 0.34336638, -0.0011287191, -0.025141917, 0.034894004, 0.048627432, 0.053214233, -0.053281713, 0.03867139, -0.028029127, 0.09459172, 0.008080466, -0.122576915, -0.020655254, -0.1817124), target);
	target = MulAdd(nc3, MF4x4(-0.1662597, -0.15292045, -0.0053951927, -0.067345075, 0.00020036062, -0.0026049272, -0.038856488, 0.00017393462, -0.03796784, -0.03248859, -0.024195418, 0.06486219, 0.09273242, -0.1581097, 0.03317699, -0.08153722), target);
	target = MulAdd(nd3, MF4x4(-0.11341117, 0.036644243, 0.20370142, -0.12600902, 0.02261616, -0.033919003, 0.028898139, 0.019782161, 0.20895214, -0.09579635, -0.08383094, -0.04259736, 0.0101915635, -0.034835722, 0.05754228, 0.027356239), target);
	target = MulAdd(ne3, MF4x4(-0.104123175, 0.122171596, 0.2642155, -0.08453785, 0.019124847, -0.03925304, 0.08668516, -0.16025878, -0.17377967, 0.3448709, 0.024630664, -0.080416046, -0.41245192, 0.062051725, 0.0105510065, -0.19370769), target);
	target = MulAdd(nf3, MF4x4(0.021447789, -0.06635468, 0.01480373, 0.04688862, 0.02536135, 0.031706117, 0.019310655, -0.045567643, -0.109611645, -0.11746073, 0.07113426, 0.16584454, 0.05936068, -0.027226295, 0.073482916, -0.12929685), target);
	target = MulAdd(ng3, MF4x4(0.0190673, 0.0045874445, 0.09324168, -0.13466571, 0.010220709, 0.037733227, -0.0111948475, 0.006582617, -0.027675852, 0.103390485, -0.15095036, 0.1242396, 0.04393306, -0.0034322627, 0.12748775, -0.08938276), target);
	target = MulAdd(nh3, MF4x4(0.05321518, 0.025193566, 0.17684115, -0.017202778, -0.019295435, -0.046254706, 0.055901498, 0.02723333, -0.1394657, 0.054581758, -0.0807223, -0.047655288, 0.048698746, -0.045940652, 0.19415994, 0.0033838819), target);
	target = MulAdd(ni3, MF4x4(-0.017342623, 0.116635494, 0.012575626, 0.04339496, 0.0025065525, -0.004621888, -0.049964648, 0.0034235734, 0.04433295, 0.033285826, -0.11080989, 0.124883905, 0.06634157, -0.040422186, -0.04232008, 0.07501063), target);
	conv2d_3_tf1[gxy] = target;

	target = MF4(0.067609355, -0.057853002, -0.09608125, 0.087347224);
	target = MulAdd(a1, MF4x4(0.0349472, -0.09146782, -0.015455071, -0.02013195, -0.013576279, 0.1715199, -0.060827523, -0.060094133, -0.06020249, -0.02977466, -0.010053687, -0.0333128, 0.08293437, 0.08380394, -0.062162157, 0.09678952), target);
	target = MulAdd(b1, MF4x4(0.09930308, -0.07924828, 0.013899443, -0.44464898, -0.03707883, -0.006584696, -0.05389371, -0.060199857, -0.019344926, -0.01931973, -0.09749517, -0.0686553, -0.07339165, -0.048708685, 0.01131454, 0.1376503), target);
	target = MulAdd(c1, MF4x4(-0.26070634, 0.040811583, 0.116160385, 0.21038511, -0.27048224, 0.0031473516, 0.032511245, 0.121619865, 0.047579095, -0.114472836, 0.058695633, 0.019592037, -0.03866724, 0.15776725, -0.008668879, 0.05827778), target);
	target = MulAdd(d1, MF4x4(0.121598184, 0.08180447, -0.03398555, -0.063269034, 0.20604548, 0.0030689642, -0.009161656, -0.10142109, -0.09195833, -0.12376092, -0.05792068, 0.071478724, 0.055384632, 0.0047193686, -0.037130035, -0.04934333), target);
	target = MulAdd(e1, MF4x4(0.12193808, 0.1254089, 0.4908329, -0.21140434, 0.12811103, -0.15737641, -0.23926133, 0.43005112, 0.15134192, -0.08466868, 0.12739879, 0.0066337097, 0.16472779, -0.105588906, -0.22597887, 0.14652383), target);
	target = MulAdd(f1, MF4x4(-0.16729999, -0.03391507, 0.07358867, 0.060984816, -0.12153663, 0.06727532, 0.18193701, 0.08977565, 0.11250762, -0.018742424, -0.15230577, -0.14556353, 0.16327548, 0.095403135, -0.13089553, 0.072550654), target);
	target = MulAdd(g1, MF4x4(0.13752456, 0.03894747, 0.031068675, 0.023082117, 0.17917861, 0.07080096, -0.011008945, -0.09391019, -0.006836284, -0.015607849, 0.046196267, 0.015853055, -0.12630671, -0.081082314, -0.086036764, 0.1590758), target);
	target = MulAdd(h1, MF4x4(0.012728998, -0.09810741, 0.14294422, -0.059659157, 0.03056563, -0.024036996, -0.015403818, -0.118189946, -0.051906176, -0.17971419, -0.0959625, 0.08985921, 0.10979987, 0.10597462, -0.043452974, 0.03186385), target);
	target = MulAdd(i1, MF4x4(0.020659165, 0.049573228, 0.051704157, 0.028366942, 0.022190692, -0.051479015, 0.054295983, -0.017384693, 0.0026946815, 0.010077197, -0.012801315, 0.0016714733, 0.08869389, 0.05164402, 0.03406929, -0.037191015), target);
	target = MulAdd(a2, MF4x4(-0.10028344, -0.16634189, 0.019711684, 0.020383958, -0.084915325, 0.11053288, -0.07768085, -0.01981037, 0.107243344, -0.012217411, -0.023985125, -0.08483301, -0.19850655, -0.06305865, 0.03655547, 0.06864395), target);
	target = MulAdd(b2, MF4x4(0.20698719, -0.2885775, 0.059498087, -0.008909828, -0.08331985, 0.13849287, 0.032946825, 0.14271452, -0.104721665, 0.12004092, 0.14654724, -0.004502498, 0.006716589, -0.17328952, 0.014115839, -0.016801946), target);
	target = MulAdd(c2, MF4x4(0.041014872, -0.080156274, -0.043762606, 0.0528254, -0.04514068, -0.073835544, 0.04116111, -0.0028962197, 0.06113734, -0.00660851, 0.04496306, -0.19104107, 0.10144654, -0.19428198, -0.04189575, -0.027004357), target);
	target = MulAdd(d2, MF4x4(0.076202326, 0.031882156, -0.08089088, 0.02722187, -0.24690835, -0.035489604, 0.17377102, -0.046913855, 0.09538933, 0.13880032, 0.032495037, -0.053468306, 0.018272033, -0.13557187, -0.0016809801, 0.16564687), target);
	target = MulAdd(e2, MF4x4(-0.1318004, 0.0781202, 0.026608787, 0.2782413, -0.015252272, 0.06966941, 0.6830404, -0.21273687, 0.035827838, -0.013433616, -0.19725588, 0.115758345, 0.12179782, -0.1338549, -0.041967906, 0.3419551), target);
	target = MulAdd(f2, MF4x4(-0.06732849, -0.00047242, -0.09643446, -0.048419215, 0.030914927, -0.13920021, 0.08296221, 0.042942315, 0.18975921, 0.023672665, -0.08061805, -0.11823857, -0.055623423, -0.1345549, 0.1951731, 0.10466201), target);
	target = MulAdd(g2, MF4x4(-0.042122774, -0.14092919, 0.097806625, -0.16809812, -0.0017256415, 0.07320015, 0.02623979, 0.056631763, -0.059066445, 0.050315112, 0.022210397, 0.020917628, 0.07918204, -0.047513902, -0.022105288, 0.017238917), target);
	target = MulAdd(h2, MF4x4(-0.10645019, -0.2826466, 0.06739196, 0.09756199, 0.031106336, -0.08260654, -0.036933657, 0.050086416, 0.0987824, -0.033137392, 0.08894681, -0.23773453, 0.023050837, -0.23565383, -0.09519961, 0.09613443), target);
	target = MulAdd(i2, MF4x4(-0.05644008, -0.21541502, 0.11537729, -0.13721548, -0.020957267, 0.10175056, -0.052707233, 0.17628355, 0.028461214, 0.3014536, -0.038585383, -0.014727664, -0.044595238, -0.10416226, -0.04355546, 0.22365475), target);
	target = MulAdd(a3, MF4x4(-0.08733939, 0.08058479, -0.004023699, -0.025807053, -0.002117148, -0.23746334, 0.065963335, 0.020958645, -0.22460108, -0.009205423, -0.07651075, -0.15989082, 0.05807728, 0.023019457, -0.05400351, 0.075997986), target);
	target = MulAdd(b3, MF4x4(-0.18092917, 0.29806077, 0.024918934, 0.114404745, 0.049839694, -0.18546863, 0.12478854, 0.13304788, -0.15392973, 0.051560715, -0.06856269, -0.3036006, 0.08124072, -0.05298596, -0.030516481, 0.12273301), target);
	target = MulAdd(c3, MF4x4(-0.09820723, 0.08067553, 0.029639702, 0.03668786, -0.10049537, -0.19294576, 0.17826727, 0.1635976, -0.16384046, -0.1220917, 0.008744192, 0.012697882, -0.043205783, 0.10298051, 0.021135183, 0.15958472), target);
	target = MulAdd(d3, MF4x4(0.021761253, 0.1893263, -0.0020750812, 0.14222866, -0.103759706, -0.13740262, 0.08272797, -0.059319258, 0.13402042, -0.07973959, 0.08683529, -0.15174694, -0.1330933, -0.036825962, -0.0028282823, 0.021407785), target);
	target = MulAdd(e3, MF4x4(0.12504603, 0.2479715, -0.35803804, -0.026018003, 0.022745723, -0.07542199, 0.23766859, -0.056435704, 0.033115927, 0.22251359, 0.09025703, -0.39158693, 0.28631303, -0.13876301, -0.4956844, 0.55813307), target);
	target = MulAdd(f3, MF4x4(0.16973238, 0.107451506, -0.10936354, 0.025205612, -0.0154478075, -0.22515228, 0.0618484, -0.053435117, -0.1634102, -0.2720532, 0.22150621, 0.0012615388, 0.045661222, 0.028745374, 0.043213993, 0.014749005), target);
	target = MulAdd(g3, MF4x4(0.08600755, 0.11467286, -0.030524427, 0.025168872, -0.10489299, -0.37458676, 0.07771989, -0.0042441254, -0.11694848, -0.35681316, 0.04747507, -0.0027261428, -0.025253184, -0.08753649, -0.006478329, -0.027177837), target);
	target = MulAdd(h3, MF4x4(-0.0007465437, 0.28975293, -0.18405293, 0.119266, -0.10667221, -0.1802464, 0.19241495, 0.02650873, 0.010430683, -0.23149595, -0.031080026, -0.0006125235, 0.037027247, -0.09754189, 0.04630445, -0.018924896), target);
	target = MulAdd(i3, MF4x4(0.019050436, 0.17480409, -0.13520603, 0.09094483, -0.02445997, -0.21114577, 0.050991118, -0.029637761, -0.16994584, -0.2239252, 0.11126132, -0.06577722, 0.056996938, 0.006512977, -0.049459394, 0.07697084), target);
	target = MulAdd(na1, MF4x4(0.16364041, -0.058814153, -0.07960281, -0.22106613, 0.051421925, 0.13432528, 0.03029435, -0.053310465, -0.043934733, 0.28936264, -0.07070681, -0.04899224, -0.11805805, -0.028338438, 0.100599535, -0.048358817), target);
	target = MulAdd(nb1, MF4x4(-0.14466347, 0.2542083, 0.114321895, 0.060320944, 1.432933e-05, -0.009625721, -0.037658967, -0.22428983, -0.0722048, 0.03882146, 0.17885631, 0.16377795, 0.112711646, -0.13564147, -0.022007236, -0.20185186), target);
	target = MulAdd(nc1, MF4x4(0.1199308, 0.065274626, 0.040273953, -0.029960137, 0.14304884, 0.059161276, -0.02586767, -0.19456553, -0.020681847, -0.03329421, 0.026978612, 0.06485361, 0.088268556, -0.0095202075, -0.1777034, -0.06573516), target);
	target = MulAdd(nd1, MF4x4(0.19750524, -0.124522515, 0.04549369, -0.14726287, -0.13690545, 0.06770214, 0.105929896, 0.10787474, 0.21234562, 0.15915224, 0.12821364, -0.10518945, -0.019162156, 0.060908437, 0.0070991656, -0.05853554), target);
	target = MulAdd(ne1, MF4x4(-0.332194, -0.1090442, 0.11825454, 0.0843628, -0.03258615, 0.08459736, 0.11480732, -0.047636237, -0.095243596, 0.07337737, -0.11959047, 0.14512871, 0.034495726, -0.086968474, 0.19812642, -0.013120597), target);
	target = MulAdd(nf1, MF4x4(0.038461242, 0.03316589, 0.09561463, 0.18557192, -0.010941443, 0.0907286, -0.016086651, -0.23144832, -0.044253506, -0.058702238, -0.0011041966, -0.045634367, -0.09162548, -0.045157652, -0.021990022, 0.13162635), target);
	target = MulAdd(ng1, MF4x4(-0.02456783, -0.03417151, 0.053517457, 0.0039862576, -0.005629444, -0.027595684, -0.09233445, -0.05521366, -0.028361535, -0.10314045, 0.05208228, -0.01962492, -0.096213296, -0.024513567, -0.05102384, 0.13520533), target);
	target = MulAdd(nh1, MF4x4(0.08790174, -0.1792104, 0.06702363, 0.036870077, -0.08648169, 0.2826172, -0.17046972, 0.019982012, -0.036582787, -0.055289216, -0.008255741, 0.004824183, 0.03871658, 0.032730278, -0.05807295, 0.06396422), target);
	target = MulAdd(ni1, MF4x4(0.032679293, -0.15864716, 0.06863736, 0.038946554, -0.009387644, 0.2248399, -0.022594031, -0.18380828, 0.08792525, -0.053283963, -0.112759285, 0.027726877, -0.086085774, -0.12300368, 0.05827494, -0.17386718), target);
	target = MulAdd(na2, MF4x4(0.08048039, -0.1314228, -0.037761286, 0.047317382, -0.08880487, 0.06179501, 0.07499687, 0.05924045, -0.045838207, 0.18014897, -0.025729936, 0.16530922, 0.06670338, 0.048252247, -0.012380218, 0.02654277), target);
	target = MulAdd(nb2, MF4x4(0.090738244, -0.07097098, 0.02538609, 0.025717502, -0.031697266, -0.09336655, -0.018525556, -0.18561147, 0.036027636, -0.044611387, -0.06725372, -0.183522, 0.0788194, -0.02451563, 0.034200825, -0.032755863), target);
	target = MulAdd(nc2, MF4x4(0.06220659, -0.042783756, -0.021792164, -0.0828951, -0.060966644, 0.0074828877, 0.10836738, 0.12144929, -0.07855744, -0.022806635, 0.02449449, -0.08472964, -0.00337497, 0.14822102, -0.0063337362, -0.022158459), target);
	target = MulAdd(nd2, MF4x4(-0.015443758, -0.14636597, 0.092075996, -0.032396555, 0.57801515, -0.038087387, -0.002455976, -0.21212098, -0.25436863, -0.0014624707, -0.06944989, 0.041554075, 0.07314171, -0.031875722, -0.0898564, -0.009711315), target);
	target = MulAdd(ne2, MF4x4(0.39667594, -0.19510192, -0.15319824, 0.09397803, 0.11162815, 0.08910584, -0.17241088, -0.32170787, 0.099810265, -0.24704264, 0.3502755, 0.076993406, -0.011241086, -0.027046101, 0.24804646, -0.03629868), target);
	target = MulAdd(nf2, MF4x4(0.04532466, -0.025737574, 0.076878645, -0.022860521, -0.21166173, 0.0066573257, 0.11451736, 0.098494835, 0.054614626, 0.0324795, -0.07475363, -0.016862292, 0.12980871, -0.12060518, -0.078866445, -0.037514597), target);
	target = MulAdd(ng2, MF4x4(-0.077329785, 0.20992881, -0.024529329, 0.032680444, 0.28252345, -0.053790633, 0.17370275, -0.14319752, -0.19114175, 0.012085368, 0.0410558, 0.08803704, -0.077949844, -0.15750417, 0.030377569, 0.0388851), target);
	target = MulAdd(nh2, MF4x4(-0.063492425, 0.12690471, 0.008844376, -0.14553507, 0.17035894, 0.18411207, 0.21632117, -0.015488823, -0.02806988, -0.13371038, -0.12625034, 0.20475954, -0.059775293, -0.055161443, -0.05210265, 0.15280373), target);
	target = MulAdd(ni2, MF4x4(-0.03649832, 0.09987268, 0.05120556, 0.025184184, -0.058899805, -0.07387821, 0.18710648, -0.10555811, -0.02759419, -0.19976474, -0.064043306, 0.030171674, 0.016179368, 0.04791283, -0.053911958, 0.050767425), target);
	target = MulAdd(na3, MF4x4(0.03843477, 0.25258064, 0.016070124, 0.028574495, -0.0068474114, 0.06865137, 0.022342455, -0.0075285095, -0.025927907, 0.029985406, 0.013440689, -0.012433278, 0.014569347, -0.11100144, 0.12033138, 0.010771042), target);
	target = MulAdd(nb3, MF4x4(-0.015851736, 0.3167264, -0.0836191, -0.005717406, -0.064080216, 0.070136465, -0.06756247, -0.023658438, 0.011184833, -0.17086872, -0.01512278, -0.13807635, -0.077147275, 0.06359306, 0.044558518, 0.17371671), target);
	target = MulAdd(nc3, MF4x4(0.016337229, 0.2540961, -0.1538914, 0.05068191, 0.027084729, 0.00067840813, -0.00576344, -0.00596408, -0.011028981, 0.036047217, 0.03535427, -0.0008666505, -0.01604948, -0.035426773, 0.09279044, 0.16961862), target);
	target = MulAdd(nd3, MF4x4(0.26191124, 0.17618547, -0.060725193, -0.10107231, 0.028958656, 0.0012716176, 0.0041506914, -0.0021748038, -0.35696867, -0.09372129, 0.12742971, 0.23923989, 0.09219072, 0.024196591, 0.003192825, -0.041768644), target);
	target = MulAdd(ne3, MF4x4(-0.17835465, 0.8621154, 0.32936049, -0.058551144, -0.021967549, -0.15256044, 0.07056792, -0.010208738, -0.25470692, -0.31490391, -0.16554967, 0.08553254, -0.14494352, 0.077428155, 0.29464936, -0.25275782), target);
	target = MulAdd(nf3, MF4x4(-0.06149193, 0.16008708, 0.08229276, 0.027298545, -0.043383293, -0.025251184, 0.035522345, 0.043242358, -0.016117992, 0.0016717165, -0.011271885, -0.08116671, -0.06230632, -0.0059490846, 0.06996346, 0.087275974), target);
	target = MulAdd(ng3, MF4x4(0.2020623, 0.18089826, -0.052554823, 0.09357937, 0.007033659, 0.026354209, 0.013584589, -0.005457746, -0.22913294, 0.13770905, -0.056017175, 0.027802086, 0.18037985, 0.03405338, 0.006718533, 0.02469646), target);
	target = MulAdd(nh3, MF4x4(0.028112786, 0.16723098, 0.0066787126, 0.07016463, 0.046073828, 0.044055372, -0.047022585, -0.060435526, -0.041117955, 0.03657766, 0.0816698, -0.15707959, 0.22355783, 0.020610418, 0.0853779, -0.12445744), target);
	target = MulAdd(ni3, MF4x4(0.05012942, -0.045172162, 0.08681702, -0.06541369, -0.01762828, 0.011376011, 0.015611381, 0.027792938, 0.013394507, 0.034215946, 0.06960491, -0.064838886, 0.03150636, -0.038445942, 0.17026442, 0.023619778), target);
	conv2d_3_tf2[gxy] = target;
}

//!PASS 5
//!DESC Conv-4x3x3x24
//!IN conv2d_3_tf, conv2d_3_tf1, conv2d_3_tf2
//!OUT conv2d_4_tf, conv2d_4_tf1, conv2d_4_tf2
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass5(uint2 blockStart, uint3 threadId) {
	uint2 gxy = TileSwizzle8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	MF4 a1 = conv2d_3_tf.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b1 = conv2d_3_tf.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c1 = conv2d_3_tf.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d1 = conv2d_3_tf.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e1 = conv2d_3_tf.SampleLevel(sam, pos, 0);
	MF4 f1 = conv2d_3_tf.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g1 = conv2d_3_tf.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h1 = conv2d_3_tf.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i1 = conv2d_3_tf.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na1 = max(-a1, 0);
	MF4 nb1 = max(-b1, 0);
	MF4 nc1 = max(-c1, 0);
	MF4 nd1 = max(-d1, 0);
	MF4 ne1 = max(-e1, 0);
	MF4 nf1 = max(-f1, 0);
	MF4 ng1 = max(-g1, 0);
	MF4 nh1 = max(-h1, 0);
	MF4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	MF4 a2 = conv2d_3_tf1.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b2 = conv2d_3_tf1.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c2 = conv2d_3_tf1.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d2 = conv2d_3_tf1.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e2 = conv2d_3_tf1.SampleLevel(sam, pos, 0);
	MF4 f2 = conv2d_3_tf1.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g2 = conv2d_3_tf1.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h2 = conv2d_3_tf1.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i2 = conv2d_3_tf1.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na2 = max(-a2, 0);
	MF4 nb2 = max(-b2, 0);
	MF4 nc2 = max(-c2, 0);
	MF4 nd2 = max(-d2, 0);
	MF4 ne2 = max(-e2, 0);
	MF4 nf2 = max(-f2, 0);
	MF4 ng2 = max(-g2, 0);
	MF4 nh2 = max(-h2, 0);
	MF4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

	MF4 a3 = conv2d_3_tf2.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b3 = conv2d_3_tf2.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c3 = conv2d_3_tf2.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d3 = conv2d_3_tf2.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e3 = conv2d_3_tf2.SampleLevel(sam, pos, 0);
	MF4 f3 = conv2d_3_tf2.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g3 = conv2d_3_tf2.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h3 = conv2d_3_tf2.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i3 = conv2d_3_tf2.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na3 = max(-a3, 0);
	MF4 nb3 = max(-b3, 0);
	MF4 nc3 = max(-c3, 0);
	MF4 nd3 = max(-d3, 0);
	MF4 ne3 = max(-e3, 0);
	MF4 nf3 = max(-f3, 0);
	MF4 ng3 = max(-g3, 0);
	MF4 nh3 = max(-h3, 0);
	MF4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	MF4 target = MF4(0.07657865, -0.057940323, 0.09216576, 0.08710758);
	target = MulAdd(a1, MF4x4(0.0903666, 0.07326563, 0.12570351, -0.0861333, 0.08773195, 0.08107881, -0.23008522, 0.081658274, -0.080930784, 0.095189065, -0.09599475, -0.012844856, -0.057758823, -0.05387305, 0.035611577, 0.06831291), target);
	target = MulAdd(b1, MF4x4(0.10193587, 0.24297304, 0.052464593, -0.23271905, -0.051271625, -0.04671388, -0.41551715, 0.096072406, -0.08061266, 0.15575954, -0.02978901, 0.02782589, -0.12731546, 0.100969315, -0.036334585, 0.04111131), target);
	target = MulAdd(c1, MF4x4(-0.07986279, 0.06354848, 0.054493763, 0.02064465, 0.1899048, -0.23340854, -0.020978438, -0.11192701, 0.0894504, 0.10851951, 0.022597404, -0.093431845, 0.1323124, -0.037850555, -0.07144082, -0.11149757), target);
	target = MulAdd(d1, MF4x4(0.20984441, 0.1316296, 0.028271135, -0.3395805, -0.060018715, 0.09772287, 0.023952218, 0.09067281, -0.024634736, 0.11768398, 0.12226884, 0.11482385, 0.09000994, 0.17652623, 0.16630758, -0.11148413), target);
	target = MulAdd(e1, MF4x4(0.16063517, 0.05484425, -0.013026712, 0.09420388, -0.07708702, -0.15001677, -0.17628206, -0.29337302, -0.12929626, 0.19321969, -0.19692437, 0.18910687, -0.5376053, 0.0024577375, 0.18347259, -0.036233984), target);
	target = MulAdd(f1, MF4x4(-0.06877196, 0.057344403, -0.18521468, -0.26043263, -0.027829815, -0.3474636, 0.074399404, 0.02000891, 0.10101197, 0.18005812, 0.018405264, 0.16208377, 0.2572691, -0.061031613, 0.12526059, 0.015687834), target);
	target = MulAdd(g1, MF4x4(0.12139206, 0.10150127, 0.12223164, -0.0033110923, 0.025267506, 0.0043354593, 0.04014963, 0.054613993, 0.0041964273, 0.18711057, 0.1130988, -0.010105996, -0.11398717, 0.15550865, 0.011355651, 0.0013034486), target);
	target = MulAdd(h1, MF4x4(0.018920925, -0.1981446, -0.0015773224, 0.17280231, -0.1158759, 0.034413345, 0.18601055, -0.058082208, -0.05751512, -0.014871481, 0.026116839, 0.22214632, -0.109278515, -0.07075786, 0.14865029, 0.06923859), target);
	target = MulAdd(i1, MF4x4(-0.04858135, 0.06361807, 0.03608349, -0.35027486, -0.22905546, 0.228983, -0.080485426, -0.12832811, -0.08297812, 0.27370456, -0.040313505, 0.12175736, -0.0088722585, -0.027337799, 0.082081, 0.036823895), target);
	target = MulAdd(a2, MF4x4(-0.09081754, -0.121576175, -0.004420886, 0.03107195, -0.009208461, 0.093130514, -0.100094385, 0.07485617, 0.10638224, 0.10978887, 0.033434544, -0.0109705, 0.051747587, -0.04629124, 0.022032369, -0.061933544), target);
	target = MulAdd(b2, MF4x4(-0.026675375, 0.24803858, -0.3505403, 0.061843242, 0.22817075, -0.22713637, 0.030461052, -0.28470376, 0.021492813, 0.026554195, -0.014637818, 0.05059166, 0.26264945, 0.019178726, -0.084112, -0.11228049), target);
	target = MulAdd(c2, MF4x4(0.24368168, -0.09750266, -0.08355252, -0.19701716, -0.07022316, -0.021431576, -0.041753594, 0.097228795, 0.05831718, 0.046489198, -0.013535228, -0.1277287, -0.028432956, 0.11263107, -0.038870994, 0.052972272), target);
	target = MulAdd(d2, MF4x4(0.34507847, 0.16310076, 0.3261618, -0.08031221, -0.024778686, 0.030581996, -0.23252021, 0.07368026, -0.1457359, -0.05583193, -0.08619469, 0.025661029, 0.122622915, 0.107637696, 0.07717542, -0.0069369692), target);
	target = MulAdd(e2, MF4x4(-0.025063993, -0.32267594, 0.04222844, -0.6405562, 0.08737213, 0.05898279, -0.24921863, -0.37281784, 0.33026382, -0.037117995, -0.48083028, -0.1576151, 0.031603996, 0.13712752, 0.08525082, 0.13751547), target);
	target = MulAdd(f2, MF4x4(-0.1717367, 0.16379626, -0.080398574, 0.02730318, -0.08700865, 0.18012185, -0.039455075, 0.1875848, -0.058620475, 0.070274726, -0.07203947, -0.004408652, 0.11834384, -0.17019957, -0.1841911, -0.16539739), target);
	target = MulAdd(g2, MF4x4(-0.00306162, -0.009568686, 0.04615716, 0.29750574, -0.016171249, -0.22235759, -0.032884303, -0.09805467, -0.23468043, -0.03662323, -0.03754542, 0.031607516, 0.1192756, 0.037513345, 0.06270457, -0.010091852), target);
	target = MulAdd(h2, MF4x4(-0.03238403, 0.044085886, -0.15184736, -0.16677259, 0.21868308, 0.033742618, 0.12541051, -0.20726953, 0.21332125, 0.18820943, 0.11516147, -0.04046913, -0.099226944, 0.008198145, 0.0044930377, 0.10445432), target);
	target = MulAdd(i2, MF4x4(-0.04825399, -0.10125744, -0.016809255, -0.2170602, -0.008085673, -0.0055932486, -0.14474209, 0.12402969, -0.06304857, -0.058890864, -0.03977117, 0.08338651, 0.051681735, -0.046300244, -0.027098775, -0.07750968), target);
	target = MulAdd(a3, MF4x4(-0.110792324, -0.07082374, -0.07643967, 0.0007350921, 0.12548494, 0.027903408, 0.08646201, -0.060506143, -0.0042042546, -0.037406266, 0.13233368, -0.040573254, -0.011526989, 0.0017727965, -0.024684377, 0.023611743), target);
	target = MulAdd(b3, MF4x4(0.10507391, -0.11524923, -0.045419905, -0.018232401, 0.11517856, -0.017063787, -0.06844106, 0.01649028, 0.042487442, -0.0018217458, -0.048760284, -0.027432851, 0.0701538, -0.07122821, -0.040997203, -0.044356424), target);
	target = MulAdd(c3, MF4x4(-0.16667375, 0.08508152, -0.1130823, 0.10425934, 0.048882842, 0.0026840174, -0.03628384, 0.017808143, 0.06952142, 0.056811754, -0.06279424, -0.08361375, 0.02647836, 0.07310232, 0.077748105, -0.086376086), target);
	target = MulAdd(d3, MF4x4(-0.057241924, -0.0933121, -0.071363084, 0.04463695, 0.082285576, 0.11622887, 0.18159458, -0.109704174, -0.13580221, 0.07275989, 0.01771122, 0.05640307, 0.07454414, 0.14722411, 0.111302465, 0.07975774), target);
	target = MulAdd(e3, MF4x4(-0.1331026, -0.054009046, 0.12211443, 0.083527334, -0.13672769, -0.015313354, 0.13764748, -0.086164065, 0.12795652, -0.03282714, 0.1579073, 0.048787095, 0.012054846, -0.01882002, 0.13269778, -0.2241914), target);
	target = MulAdd(f3, MF4x4(-0.14854619, 0.11223546, -0.07340829, 0.17087477, -0.035288546, 0.073113, 0.031149026, 0.08732851, 0.11652912, 0.11133054, -0.011138846, -0.04347902, 0.22826026, -0.06315385, -0.083217576, -0.16983536), target);
	target = MulAdd(g3, MF4x4(6.0946622e-05, -0.1391396, -0.029762868, -0.07732276, 0.08408844, -0.0067310245, 0.018747361, 0.10870239, -0.14702435, 0.04659678, 0.049279176, -0.089539565, 0.008640545, -0.12693758, -0.012340728, -0.0010518627), target);
	target = MulAdd(h3, MF4x4(-0.031445112, -0.059538055, -0.10110316, -0.009243974, 0.07312848, -0.045987524, -0.07739988, -0.18289267, 0.19408458, 0.049652096, 0.1430416, 0.007823552, 0.12752487, 0.1404086, 0.014550228, -0.2000237), target);
	target = MulAdd(i3, MF4x4(-0.02328158, -0.055340275, -0.00890452, 0.05107875, 0.04028763, -0.033579618, -0.14551812, -0.07084914, 0.031724613, -0.11050497, 0.030539952, 0.017960407, 0.013022372, 0.048110507, -0.059791975, -0.069656074), target);
	target = MulAdd(na1, MF4x4(-0.011159195, 0.061231583, 0.023733439, 0.08318157, 0.051980533, -0.081164956, -0.12936994, 0.031314097, 0.038792897, -0.19316009, 0.012015963, 0.1274062, 0.007457571, -0.053334422, -0.06087007, -0.07500442), target);
	target = MulAdd(nb1, MF4x4(-0.12612286, -0.059262786, 0.0013960898, 0.16076264, -0.02753848, -0.040280215, 0.11748305, -0.06767023, -0.08982183, -0.2259159, 0.021500308, -0.050233077, 0.0174376, 0.08059276, -0.011338266, -0.021669568), target);
	target = MulAdd(nc1, MF4x4(-0.09231125, 0.05039252, 0.06589666, 0.0699502, -0.016866742, 0.16463608, 0.008424828, -0.044754602, 0.08277166, -0.26685247, -0.054916486, 0.035318345, 0.017051857, 0.004787585, 0.07064183, 0.08143896), target);
	target = MulAdd(nd1, MF4x4(0.040472284, 0.02196483, 0.019647326, -0.0042990106, -0.0111499615, 0.064750694, -0.1685468, 0.1236021, -0.14509638, -0.23636436, -0.03507012, -0.05882796, -0.003939107, -0.03427979, -0.15588285, 0.14955762), target);
	target = MulAdd(ne1, MF4x4(-0.29209736, -0.056658156, 0.12503433, 0.059094626, 0.33155647, -0.31607324, -0.17409548, 0.28301534, -0.07269221, 0.31217432, -0.032151274, 0.13320662, 0.0067921844, 0.12724863, -0.079603665, -0.20445012), target);
	target = MulAdd(nf1, MF4x4(0.04944913, -0.24652547, 0.084156096, -0.044976614, 0.13094465, -0.041729383, -0.0043662624, -0.025976455, 0.10950043, -0.24576949, 0.07637044, -0.17560403, 0.03770707, -0.14604908, -0.13370425, -0.08169505), target);
	target = MulAdd(ng1, MF4x4(0.06215933, 0.014817449, -0.17584182, -0.119785294, 0.025916845, -0.0045085796, 0.051403407, -0.13932867, -0.029478246, -0.23803446, 0.026629616, -0.04838478, -0.05731936, -0.15141651, -0.014330421, 0.03173533), target);
	target = MulAdd(nh1, MF4x4(-0.18867792, 0.1690159, 0.0077506024, -0.08768171, 0.13987596, -0.10401963, -0.00020402495, 0.095776096, -0.059084885, -0.15369008, 0.121360734, 0.11111317, -0.06857354, -0.24787377, -0.07358934, 0.05282127), target);
	target = MulAdd(ni1, MF4x4(-0.05825966, 0.15936251, -0.009718466, 0.026246214, -0.054192465, 0.11259584, 0.106545866, 0.0037204623, 0.015858173, -0.2466447, -0.006608056, -0.08228397, 0.014153731, -0.024114707, -0.14019284, -0.008368259), target);
	target = MulAdd(na2, MF4x4(-0.12620875, -0.035311706, -0.017309954, 0.038676415, 0.010007554, 0.103891194, 0.2074349, -0.067182384, 0.04545331, 0.04189184, 0.04593296, 0.01145646, 0.027835514, 0.16188826, 0.12302215, 0.005847866), target);
	target = MulAdd(nb2, MF4x4(-0.08673945, -0.03605757, 0.008751013, 0.006012169, -0.100793496, -0.06794951, 0.22445437, 0.16843331, -0.04668748, 0.15526527, 0.16405432, 0.08034733, 0.095660806, 0.13993011, 0.0714316, -0.2271875), target);
	target = MulAdd(nc2, MF4x4(-0.051425643, -0.060941234, 0.014853939, -0.04170188, -0.040981892, 0.014460391, 0.06914827, -0.092892915, 0.011654809, -0.07164335, 0.05665548, -0.021757752, -0.15187486, 0.25099215, 0.06707618, 0.0014576896), target);
	target = MulAdd(nd2, MF4x4(-0.21007836, -0.02975774, -0.17765106, 0.08210864, 0.04128445, -0.03473088, 0.13388512, -0.062689856, -0.024399463, 0.060575683, 0.016895741, 0.053625587, -0.16646849, 0.20665659, -0.097400986, -0.11676045), target);
	target = MulAdd(ne2, MF4x4(-0.012981402, -0.0035834755, -0.19967668, -0.055962507, 0.05755364, 0.16290179, 0.16108987, 0.0443184, 0.022384012, -0.21550876, 0.1993019, 0.10249744, 0.027157044, -0.48223755, 0.14306773, -0.042821236), target);
	target = MulAdd(nf2, MF4x4(-0.023187606, -0.0006282703, -0.030281521, -0.034422845, 0.1269488, -0.046393935, 0.056179423, -0.07986905, -0.08863301, 0.033617917, 0.28032312, -0.016831966, -0.09741306, 0.082168706, -0.07072508, 0.1714769), target);
	target = MulAdd(ng2, MF4x4(-0.10699955, 0.004617793, -0.13971107, -0.08070923, -0.18738483, 0.37386385, 0.095100455, 0.057784997, -0.048351936, -0.19038375, -0.1161272, 0.088465944, 0.21603039, 0.14161706, -0.17377359, 0.053336773), target);
	target = MulAdd(nh2, MF4x4(-0.1607158, 0.11756463, 0.050999135, -0.082914345, -0.13728271, -0.29792574, 0.28438056, 0.45129618, 0.024746796, 0.15315229, -0.117851384, 0.07257279, -0.108341694, 0.20533404, 0.026013765, -0.34590483), target);
	target = MulAdd(ni2, MF4x4(-0.14288151, 0.040327024, -0.14112945, -0.08908226, 0.22330604, -0.015938131, 0.033910606, -0.16407411, -0.016470572, 0.09259821, 0.08344142, 0.014396606, -0.04143325, 0.10638457, 0.12549427, 0.016800882), target);
	target = MulAdd(na3, MF4x4(-0.07430705, -0.21602099, -0.02395794, 0.16806927, 0.18771775, 0.040755376, 0.2715868, -0.034169577, 0.00522744, -0.02654015, -0.020816373, 0.16446163, -0.087030225, 0.01551686, 0.0048509445, 0.022507116), target);
	target = MulAdd(nb3, MF4x4(-0.024786156, 0.09243609, 0.09324701, 0.08799725, -0.03968033, -0.14894229, 0.0776629, -0.21654569, -0.099934116, -0.06997516, 0.10485336, 0.040500306, -0.25174686, -0.20299411, 0.13843295, 0.25696677), target);
	target = MulAdd(nc3, MF4x4(0.092044, -0.07171784, 0.23683146, -0.009319925, -0.08805518, 0.12598065, 0.06375242, 0.02844835, -0.029605612, -0.12549727, 0.022440229, 0.006380783, 0.1313304, 0.15739907, 0.08373962, 0.08992246), target);
	target = MulAdd(nd3, MF4x4(-0.27224204, -0.26631516, -0.027027579, -0.030660763, 0.069010764, 0.00686249, -0.17444538, -0.05701314, -0.035538822, -0.26050144, -0.010451579, -0.061782375, 0.16745842, -0.108107746, 0.030468695, -0.16402762), target);
	target = MulAdd(ne3, MF4x4(-0.07276476, -0.15297028, -0.25568548, 0.27668282, 0.09677458, 0.098981895, -0.0004217196, -0.00091525156, -0.3077419, 0.44434202, -0.09468051, -0.08462181, -0.26978543, 0.27369836, -0.03669818, 0.2912635), target);
	target = MulAdd(nf3, MF4x4(-0.28734738, 0.14579459, 0.22083919, -0.2297294, 0.17505005, -0.04844878, 0.021834318, -0.16736999, 0.0016747294, -0.060896724, 0.028344678, -0.06341938, 0.43723574, -0.2615166, 0.05107712, -0.20119043), target);
	target = MulAdd(ng3, MF4x4(0.0272994, 0.22280678, 0.17716415, -0.093996234, -0.11316552, 0.18234952, -0.0010922098, -0.12163143, 0.04821719, 0.0022455743, -0.036408488, 0.022185026, -0.03437743, 0.022541165, -0.11003119, 0.14187692), target);
	target = MulAdd(nh3, MF4x4(0.00013664822, -0.34958616, 0.33965272, 0.4091369, 0.047315825, 0.18665253, -0.09821825, 0.070298485, -0.07052871, -0.2640913, -0.13192001, 0.017230166, -0.22303015, 0.0023083845, -0.1482968, 0.0031197562), target);
	target = MulAdd(ni3, MF4x4(-0.053096205, -0.023291215, -0.038235445, -0.2354219, -0.012032332, 0.17776853, 0.03697497, -0.25305814, 0.043709055, -0.09948032, -0.08828663, -0.09534956, 0.036391728, 0.05996495, 0.038689792, 0.053753372), target);
	conv2d_4_tf[gxy] = target;
	
	target = MF4(0.050651863, 0.044697866, 0.016666446, -0.015238534);
	target = MulAdd(a1, MF4x4(0.12020708, 0.030450096, -0.022563199, 0.13941783, 0.42781577, 0.07196431, 0.03032568, -0.24368697, -0.12174075, 0.18298386, 0.09977972, 0.06440271, -0.021667495, -0.09582143, -0.02372221, -0.012161217), target);
	target = MulAdd(b1, MF4x4(-0.08614557, -0.16138618, 0.17409417, 0.06457713, 0.2130565, 0.3841125, -0.030690523, 0.014650334, -0.024490908, 0.09859328, -0.033240438, 0.21537182, -0.11260519, 0.3600062, -0.21786173, 0.29394957), target);
	target = MulAdd(c1, MF4x4(-0.065436006, 0.18217164, -0.009773951, 0.29613763, 0.15861033, 0.19769754, 0.026605047, -0.13012406, 0.049954694, -0.21985927, -0.114034064, -0.19775811, 0.15509593, -0.0096983, 0.04010453, -0.14786181), target);
	target = MulAdd(d1, MF4x4(-0.12755093, -0.15312608, -0.12672725, 0.14637707, -0.044712905, -0.018509148, 0.34769905, 0.094541386, 0.018899806, -0.068810396, 0.03567579, 0.010715141, 0.26642382, 0.021787789, -0.045413516, -0.0099886125), target);
	target = MulAdd(e1, MF4x4(0.09399624, -0.22073774, -0.03728268, -0.14593096, -0.14311165, 0.01572586, -0.043170083, 0.14196606, -0.0057723937, -0.22462656, 0.28189817, -0.27393398, -0.04240093, -0.22494912, 0.088402055, -0.15256752), target);
	target = MulAdd(f1, MF4x4(-0.054694295, 0.24343663, 0.042853344, 0.2742606, -0.16395031, 0.25720948, -0.12372541, 0.15020733, 0.07335946, 0.06307917, -0.0035989506, 0.045006167, 0.12430964, -0.20227802, 0.16280155, -0.060202613), target);
	target = MulAdd(g1, MF4x4(0.015143897, 0.21408756, -0.12505236, -0.21357507, -0.103595965, -0.074590206, 0.015860647, 0.16365165, 0.082501106, -0.015283817, -0.047005404, 0.048750408, 0.06636161, 0.2280071, 0.0033000826, 0.15148918), target);
	target = MulAdd(h1, MF4x4(0.051213, 0.121158004, -0.2882391, 0.048057787, -0.15921837, -0.04850743, -0.32060388, -0.11430066, 0.0148464935, -0.069417626, 0.11761673, -0.030637275, 0.0030618436, 0.2583576, -0.03774937, -0.23215541), target);
	target = MulAdd(i1, MF4x4(-0.06589957, -0.18402125, -0.1908057, -0.15999734, -0.20722501, -0.41220245, -0.08732743, -0.2800872, -0.11615179, 0.08338717, 0.070668146, 0.16140378, -0.07519341, 0.04610659, 0.025006918, 0.09886883), target);
	target = MulAdd(a2, MF4x4(-0.05963709, 0.021905743, 0.019461332, 0.30714118, 0.053338766, -0.0036449512, 0.051735114, 0.031359527, -0.055139918, -0.03070095, 0.035309043, 0.03333981, -0.028844094, 0.076006815, 0.05232068, -0.0012779629), target);
	target = MulAdd(b2, MF4x4(0.14548303, 0.08283497, 0.08181831, 0.015030586, 0.0053907307, -0.014007569, 0.051146433, 0.04916237, 0.15514989, 0.07423488, -0.08177836, 0.07886526, 0.05780981, 0.06978046, -0.015533511, 0.11043233), target);
	target = MulAdd(c2, MF4x4(0.2718494, -0.019822083, -0.0057829386, -0.22661845, -0.099374995, 0.009107718, -0.06340475, -0.0010754272, 0.028092189, -0.20054619, -0.051893793, -0.29571667, 0.093114756, 0.07853305, -0.100233726, -0.0047704247), target);
	target = MulAdd(d2, MF4x4(0.14986612, 0.0022451372, -0.062067125, -0.17486928, -0.0863647, 0.043254074, 0.2403272, 0.008611301, 0.022587517, -0.11991351, 0.021465946, -0.0043859156, 0.016005747, 0.15905066, -0.07992088, 0.0744741), target);
	target = MulAdd(e2, MF4x4(-0.28244218, 0.1579932, -0.53319496, -0.17382297, -0.015739711, -0.1284182, 0.14516716, 0.29700696, 0.11660257, 0.023022393, 0.07765215, -0.17613792, -0.0067801042, 0.103040695, 0.1726775, -0.05101466), target);
	target = MulAdd(f2, MF4x4(-0.07244159, 0.12475429, -0.15444236, 0.040789705, -0.12216188, 0.025828373, -0.15603372, 0.05882803, 0.18985634, -0.16016626, -0.068549834, -0.39872447, -0.018761588, 0.06250271, 0.16675957, -0.064201385), target);
	target = MulAdd(g2, MF4x4(0.11573142, 0.3193422, -0.07796038, 0.076522775, -0.17158118, -0.078293145, 0.100592226, 0.059703935, 0.12754959, -0.08411796, -0.18692641, -0.18266907, 0.06325651, -0.07590812, 0.16482389, 0.11334052), target);
	target = MulAdd(h2, MF4x4(0.043070253, -0.097845815, -0.16063489, 0.06901578, -0.12220174, 0.07733114, -0.057676736, -0.16375609, 0.14565262, 0.13176636, -0.16553006, 0.05554225, -0.09373497, -0.057028443, -0.23270036, -0.1320336), target);
	target = MulAdd(i2, MF4x4(0.004274229, -0.08707873, -0.07182644, -0.2983437, -0.04152557, 0.04764718, 0.18148302, 0.25483704, -0.079726525, 0.042573344, -0.108663455, -0.11411879, 0.04527909, -0.01938232, -0.0720563, -0.033436943), target);
	target = MulAdd(a3, MF4x4(-0.05914969, 0.03217603, 0.05620841, 0.11179769, 0.008934773, 0.13958941, -0.049832776, 0.011027975, 0.065970905, -0.0034222854, 0.03403987, 0.0469571, 0.046986744, 0.02688478, 0.10363807, -0.07991329), target);
	target = MulAdd(b3, MF4x4(-0.08938713, 0.10607981, -0.042589642, -0.15378094, 0.031732727, 0.066124596, 0.045595378, 0.0021127507, 0.054374907, 0.0107482, -0.10671928, 0.0074089314, 0.04903823, 0.09358932, -0.018505096, 0.07349409), target);
	target = MulAdd(c3, MF4x4(-0.010238883, 0.21940914, 0.007697137, 0.21205641, 0.06893976, 0.12995858, 0.057945974, 0.0840761, 0.08816238, 0.071576215, -0.042484447, 0.08113807, 0.08687212, -0.055440724, -0.08699462, -0.09570027), target);
	target = MulAdd(d3, MF4x4(-0.106894106, -0.2096638, 0.05298109, 0.010998865, -0.08867521, 0.12988189, 0.10647452, -0.097984925, 0.0915472, 0.20006137, 0.18479815, 0.16927278, 0.1631858, 0.008064966, 0.027587382, -0.03482675), target);
	target = MulAdd(e3, MF4x4(-0.19826272, -0.1342889, -0.26001906, 0.04669503, 0.010580549, 0.004505948, -0.01596666, 0.101886965, 0.51708573, 0.01397845, 0.26731327, 0.048002556, -0.41174927, 0.22574128, 0.117833406, -0.06960611), target);
	target = MulAdd(f3, MF4x4(-0.14917673, -0.13293903, -0.031218676, 0.049667537, -0.1060632, 0.10442213, -0.09595242, 0.12595569, -0.016390745, -0.14521241, -0.11187397, -0.09977547, 0.25035715, -0.16168214, 0.1920289, -0.15843187), target);
	target = MulAdd(g3, MF4x4(-0.02411851, -0.11056269, 0.055056043, 0.043598007, -0.0066189542, 0.04634859, 0.12737647, 0.06846502, 0.056652352, -0.10612263, 0.08477219, -0.13697919, -0.04940175, -0.04095268, -0.007203606, 0.16084097), target);
	target = MulAdd(h3, MF4x4(0.052976605, 0.04408607, 0.072765656, -0.08981313, -0.058496203, -0.13047524, 0.04112392, 0.10585218, -0.1758069, -0.015050289, 0.17501082, 0.042282905, -0.12833239, -0.16907021, 0.034734186, -0.117356636), target);
	target = MulAdd(i3, MF4x4(0.009886183, -0.1072079, 0.032444023, 0.008510553, -0.09062318, 0.087005824, 0.03727608, 0.009528718, -0.10054762, -0.10859511, -0.048893284, -0.07000767, 0.056854695, -0.10528974, 0.05492607, -0.07096842), target);
	target = MulAdd(na1, MF4x4(-0.17860578, -0.0105161, 0.029562278, 0.024690636, 0.33631963, -0.029712414, -0.005475538, -0.03374888, 0.11327619, -0.04078819, 0.0033871653, 0.02554949, -0.12539335, 0.043788597, -0.091408, 0.049923938), target);
	target = MulAdd(nb1, MF4x4(0.06232113, 0.12859604, -0.062801324, -0.054190084, 0.024198689, -0.03283934, -0.11320382, -0.17320402, -0.051317126, -0.05357262, 0.06503374, 0.010334861, 0.18220812, -0.23972702, 0.026034402, -0.094274506), target);
	target = MulAdd(nc1, MF4x4(0.0039012742, 0.03340159, 0.00041976577, -0.09593378, -0.08368581, -0.171641, -0.15441188, -0.05075565, 0.017398436, -0.15752153, 0.11208059, -0.07801636, -0.024276018, -0.14415129, 0.053215727, 0.05285977), target);
	target = MulAdd(nd1, MF4x4(-0.0033036366, -0.0017531791, -0.06987429, 0.14468694, 0.32040435, -0.115356, -0.114271276, 0.08943164, -0.10405339, -0.08873277, -0.12369199, 0.10631109, 0.072591804, 0.07545677, 0.007450515, -0.062508635), target);
	target = MulAdd(ne1, MF4x4(-0.32389352, 0.36626276, -0.24318767, 0.1114559, -0.041673217, 0.0123305125, 0.08265207, -0.089765444, 0.04077425, -0.10462959, 0.008208994, -0.24475563, 0.21966444, 0.4274681, 0.02538749, -0.072384804), target);
	target = MulAdd(nf1, MF4x4(-0.060664598, -0.07931745, -0.04031839, 0.032503996, 0.09535501, 0.060271315, 0.050842766, -0.017118635, 0.20283295, 0.21311453, 0.048262708, 0.13562958, 0.09995353, 0.24902335, 0.166433, 0.1362172), target);
	target = MulAdd(ng1, MF4x4(0.09678776, -0.022411423, 0.031022416, 0.04797599, -0.038225997, -0.049748596, 0.0046548736, -0.1178436, -0.070659816, 0.11345608, -0.0496577, -0.04467185, -0.05449646, -0.13758712, 0.037184708, -0.050822448), target);
	target = MulAdd(nh1, MF4x4(-0.14028446, -0.019469494, 0.065940395, -0.058915302, -0.044744235, 0.20379432, 0.19095756, 0.077816576, 0.17204207, 0.1072162, -0.1361738, 0.08552834, 0.18237999, 0.08205425, -0.040794145, 0.20306163), target);
	target = MulAdd(ni1, MF4x4(0.10820412, -0.0103201205, 0.11818202, 0.05081286, -0.034519948, -0.022716366, 0.012558799, -0.061788525, -0.019103106, -0.024869766, -0.01484149, -0.0041896743, 0.10513332, 0.0644455, -0.0060386304, 0.119789764), target);
	target = MulAdd(na2, MF4x4(-0.12900162, -0.024052832, 0.091144815, 0.042586617, 0.023100799, -0.008685231, -0.18520203, 0.04126034, 0.22155929, -0.053283233, 0.010883973, -0.23124413, 0.015983205, -0.16272338, -0.047610354, 0.09509212), target);
	target = MulAdd(nb2, MF4x4(-0.043675106, -0.13593669, 0.15423402, 0.006204822, -0.20298089, -0.24486437, 0.0793193, -0.04431099, -0.10573373, 0.14105141, 0.008124834, 0.08031386, -0.02944676, -0.0324013, -0.21952143, -0.14495796), target);
	target = MulAdd(nc2, MF4x4(0.096100524, 0.0038778677, 0.08775855, -0.061556816, -0.18265049, 0.10941394, 0.054334268, 0.21996409, -0.050350484, -0.004098584, 0.04015653, -0.022499854, -0.14539535, 0.14758524, -0.34231094, 0.010245374), target);
	target = MulAdd(nd2, MF4x4(-0.23592138, 0.108827986, 0.011998022, 0.08459366, 0.0366679, 0.17635424, -0.09780912, -0.0835654, 0.118454255, 0.035510838, -0.05113816, -0.14397779, 0.07003334, -0.012582954, -0.08026196, -0.07726739), target);
	target = MulAdd(ne2, MF4x4(-0.065133855, -0.1601996, 0.30335194, -0.07679822, 0.0087142885, 0.36574212, -0.5694481, -0.0020462046, -0.08609347, -0.020676374, -0.13731648, 0.0025803284, -0.07613569, 0.011341814, -0.238015, 0.17618194), target);
	target = MulAdd(nf2, MF4x4(0.056766525, -0.13898206, 0.031484123, 0.037802573, -0.11768987, 0.043203767, -0.12557015, 0.21512888, -0.20422752, 0.0033964422, -0.1128001, 0.031649, -0.18963163, -0.06865018, -0.015203186, 0.017272811), target);
	target = MulAdd(ng2, MF4x4(-0.22707051, -0.12006254, 0.047220945, 0.033206593, -0.11796534, 0.14222418, -0.17649753, -0.07965604, -0.08325816, -0.04103228, 0.122222394, 0.05513519, 0.03045633, -0.014383039, 0.2659631, -0.14282666), target);
	target = MulAdd(nh2, MF4x4(0.050211295, 0.106638566, -0.12575938, 0.042698536, 0.4065789, 0.48643333, -0.40594426, 0.23580477, -0.09891945, -0.27204368, 0.38514468, -0.17403792, -0.00021442943, 0.036901742, -0.07350521, -0.1137957), target);
	target = MulAdd(ni2, MF4x4(0.08275032, -0.10175439, 0.024990086, 0.09118366, 0.054295644, 0.07601656, -0.17207645, 0.071827434, -0.09406783, -0.29794717, 0.062402938, -0.19291654, 0.057635557, 0.10152742, -0.16145273, 0.078694634), target);
	target = MulAdd(na3, MF4x4(-0.14024283, -0.020712407, -0.0006742049, -0.07990848, -0.2780156, 0.01990348, -0.007274932, 0.01683584, 0.058766432, -0.011117602, -0.11561118, -0.085818544, -0.07759575, -0.06813459, -0.117720075, 0.117459066), target);
	target = MulAdd(nb3, MF4x4(-0.11406997, 0.00070567254, 0.0015214743, -0.13617793, -0.1844734, 0.10463744, 0.042494643, 0.09081247, -0.1682752, -0.12013825, 0.15428415, 0.003604667, -0.04138629, -0.37951693, 0.18619955, -0.12595965), target);
	target = MulAdd(nc3, MF4x4(-0.09695181, 0.29682228, 0.042676754, 0.16024598, -0.094654515, -0.10530867, 0.02741278, -0.054255832, -0.02117601, -0.03741268, 0.10694513, -0.04951851, -0.106426254, -0.33196932, -0.14139625, -0.13504466), target);
	target = MulAdd(nd3, MF4x4(-0.1909862, -0.25864232, -0.050149377, -0.01613201, -0.27878955, 0.15964217, -0.16596937, 0.061238922, -0.21866739, -0.15153229, -0.27351984, -0.052200224, -0.04497165, 0.12572336, -0.08926984, -0.13085754), target);
	target = MulAdd(ne3, MF4x4(0.1186159, -0.44323534, 0.24520016, -0.17869183, 0.07235415, 0.2055049, -0.15923528, -0.012734702, -0.7115807, -0.0783967, -0.48488334, -0.06875676, 0.2530569, -0.036582347, 0.029272651, 0.16227534), target);
	target = MulAdd(nf3, MF4x4(-0.20962486, 0.36621055, -0.2653163, -0.12183859, -0.05926225, 0.19594035, 0.17680155, 0.3601037, 0.08084663, 0.076976806, 0.06040379, 0.16425474, 0.033630535, 0.1259935, 0.15317655, 0.16241911), target);
	target = MulAdd(ng3, MF4x4(0.05553488, 0.13082667, 0.07025236, -0.16599798, -0.0755003, -0.06938985, -0.038283534, 0.010487185, -0.0030434306, 0.101001985, -0.09891444, -0.057115134, -0.10988094, 0.13917845, -0.16996992, -0.06362086), target);
	target = MulAdd(nh3, MF4x4(0.052476093, 0.2736097, -0.34467006, 0.08840096, -0.2191552, 0.19051385, 0.04366143, 0.084381446, 0.24772783, 0.24381915, -0.19055025, 0.06811196, -0.049013868, 0.0047574267, -0.17637779, 0.18330449), target);
	target = MulAdd(ni3, MF4x4(0.061494384, 0.19728619, 0.05241455, -0.12846167, -0.035130713, 0.20945111, 0.08781453, 0.3240593, 0.16286173, 0.028478097, 0.11730352, -0.057671197, 0.04265479, 0.053791273, -0.017982712, 0.0750495), target);
	conv2d_4_tf1[gxy] = target;

	target = MF4(-0.052461267, 0.15198341, -0.02276772, -0.03120894);
	target = MulAdd(a1, MF4x4(-0.024237188, -0.10422616, 0.06723804, 0.1826598, 0.012947932, 0.45517665, -0.44863597, -0.23032583, -0.13114794, 0.09810647, 0.058437135, -0.08195182, 0.08179358, -0.039700896, -0.039574802, -0.14186196), target);
	target = MulAdd(b1, MF4x4(0.1629186, -0.2774174, 0.06411593, 0.07094711, -0.3600775, 0.32915217, -0.32015067, -0.28613016, -0.1612731, 0.010733298, -0.05708089, -0.15946425, 0.082519636, 0.09780667, 0.056797463, -0.11305572), target);
	target = MulAdd(c1, MF4x4(-0.04339018, -0.05268632, 0.012107386, -0.050289553, 0.055016138, 0.09554764, -0.088567086, 0.07149162, 0.040378995, 0.18996446, -0.07771632, 0.13777791, 0.135759, 0.00097233645, -0.05469941, -0.0403182), target);
	target = MulAdd(d1, MF4x4(-0.0817291, 0.21801636, 0.21970823, 0.32005847, 0.064489774, 0.06965839, -0.30358747, -0.11341012, -0.14858796, 0.11928792, -0.021813538, 0.17499882, 0.12947294, -0.051210806, -0.058405858, -0.025849868), target);
	target = MulAdd(e1, MF4x4(-0.017480569, -0.07665342, 0.055402935, 0.024532886, -0.103406206, 0.052755862, -0.13945164, -0.023136819, -0.08034683, 0.0090520345, -0.10195203, -0.11921826, -0.23000433, 0.35529178, 0.043689124, -0.39272285), target);
	target = MulAdd(f1, MF4x4(0.18001455, -0.19694266, 0.041117262, -0.004510925, 0.23145959, -0.119057, -0.27721423, 0.24195382, -0.10873344, 0.120489694, 0.0634931, 0.010593836, 0.12439531, 0.024893748, -0.34153914, 0.117560826), target);
	target = MulAdd(g1, MF4x4(0.10838369, 0.09057026, 0.051982816, 0.16478422, 0.18629162, -0.103127524, -0.14309822, -0.033989307, 0.021934774, -0.008789755, -0.04308787, -0.06250701, 0.12962283, -0.16955297, -0.14072357, -0.1573379), target);
	target = MulAdd(h1, MF4x4(-0.05150477, 0.19018193, -0.0018513565, 0.049800653, -0.0072638886, -0.09453535, 0.086251326, 0.19729123, -0.0754909, 0.14370134, -0.053820826, -0.04315332, -0.028823897, 0.075814255, -0.06760011, 0.010474355), target);
	target = MulAdd(i1, MF4x4(0.13249592, -0.12863821, -0.098677255, -0.008903099, -0.00075161987, -0.1422283, 0.1321076, -0.016739735, -0.052078467, 0.10682752, 0.072102524, 0.044046365, 0.016139982, 0.06351777, -0.09472882, -0.017490232), target);
	target = MulAdd(a2, MF4x4(-0.024706522, 0.048243694, -0.013107904, -0.19985148, 0.14576256, 0.06643448, -0.063278124, -0.037488308, 0.096271195, -0.05229867, -0.012707279, 0.004028418, -0.06064612, 0.12454419, 0.035423573, 0.19192193), target);
	target = MulAdd(b2, MF4x4(0.058306698, 0.4169323, -0.2137428, 0.39399233, -0.018209185, -0.047926553, 0.0047757244, 0.18491194, -0.047317795, 0.027071197, 0.065773524, -0.16662115, 0.1758542, 0.040357858, -0.16389023, -0.08795879), target);
	target = MulAdd(c2, MF4x4(0.1123842, -0.030895762, -0.027667578, -0.07902935, -0.102031484, -0.0044085253, 0.13276444, 0.0027152307, 0.11011939, -0.022880847, 0.08871766, 0.11890982, -0.16875012, 0.0763821, -0.01840331, 0.02001359), target);
	target = MulAdd(d2, MF4x4(-0.02286322, 0.024675928, 0.10812478, 0.3268884, 0.18656765, -0.089817695, -0.045856882, -0.048997983, 0.09179813, -0.14574316, -0.05584585, 0.04601508, -0.04663327, 0.13533741, -0.027007475, 0.13568604), target);
	target = MulAdd(e2, MF4x4(0.3305947, 0.003312709, 0.38421127, 0.29569045, 0.27463832, -0.15641807, 0.27655235, 0.02949218, -0.049430016, 0.09262954, -0.05639441, -0.0015801551, -0.0867195, 0.01903508, -0.18103446, -0.13115436), target);
	target = MulAdd(f2, MF4x4(0.032399632, 0.035522558, 0.02029329, -0.15271226, -0.22600263, 0.018570898, 0.2614411, -0.043230906, -0.16090661, -0.03576041, 0.1163746, -0.12655982, 0.14196678, 0.043999534, -0.003735901, 0.041733805), target);
	target = MulAdd(g2, MF4x4(-0.17129399, 0.035248592, 0.03326124, 0.05614414, 0.08734728, 0.00025759568, -0.017390147, -0.018484343, -0.18716696, -0.11577566, -0.09411038, -0.0005942758, 0.20385277, -0.1574145, -0.13516964, -0.011578805), target);
	target = MulAdd(h2, MF4x4(0.10666493, 0.04735373, -0.0013807884, 0.0704135, -0.09550784, 0.12478301, 0.13349667, 0.11381725, 0.10344638, 0.036749367, -0.07850732, 0.067993365, -0.27189222, 0.12209588, 0.039368622, -0.11650519), target);
	target = MulAdd(i2, MF4x4(-0.048749734, -0.015611218, -0.058593888, -0.11054869, 0.15889384, -0.027153673, -0.15524355, -0.14243808, -0.078478426, -0.0005193828, 0.12036652, -0.10402722, -0.02370969, 0.13715413, 0.06436259, 0.06815996), target);
	target = MulAdd(a3, MF4x4(-0.018909978, 0.18138056, -0.10334352, -0.021526821, 0.010916664, -0.048124075, 0.06859281, -0.076912865, 0.09164643, 0.057818342, -0.17802145, -0.090189666, 0.03645826, 0.10256138, -0.0069766566, 0.036947094), target);
	target = MulAdd(b3, MF4x4(-0.20622449, 0.012804213, 0.015042242, 0.19055699, -0.08001165, 0.03541219, -0.12968656, -0.030422881, -0.14057401, 0.13156182, -0.13859963, 0.00040263348, 0.10254204, -0.014539082, -0.107229605, -0.17474675), target);
	target = MulAdd(c3, MF4x4(-0.107353106, 0.0014355447, 0.028790096, -0.0302504, -0.10989408, 0.038959417, -0.110921286, 0.0625821, -0.05460621, 0.002502421, 0.000936639, 0.048315868, 0.011345627, 0.08441578, -0.048639838, 0.09363101), target);
	target = MulAdd(d3, MF4x4(0.028981669, 0.099419065, -0.14213188, -0.022163093, -0.05122637, -0.0046859765, 0.09862167, 0.049731493, 0.07676605, 0.003952691, -0.04136734, -0.24915272, 0.008263169, -0.22285973, -0.0962458, 0.172863), target);
	target = MulAdd(e3, MF4x4(-0.37248972, 0.11385456, 0.2061119, 0.022263438, 0.019234778, 0.00025653432, -0.050672278, 0.055690683, -0.123369195, 0.23665325, -0.071705356, 0.28199664, 0.22527444, -0.2209345, 0.109758556, -0.09677416), target);
	target = MulAdd(f3, MF4x4(-0.040162217, -0.076559134, -0.16174191, 0.04257142, -0.06335363, -0.014538781, 0.031642947, 0.07644203, 0.0073738038, 0.035876762, -0.025717935, 0.07372835, 0.07390335, 0.021775434, -0.0935753, 0.17936146), target);
	target = MulAdd(g3, MF4x4(0.038021766, 0.02849221, -0.04236583, -0.013963447, 0.019651154, 0.05580235, -0.13790283, -0.060389396, 0.021969974, 0.0056073754, -0.018980214, -0.025460985, -0.045908038, -0.010549833, -0.09338662, -0.057856735), target);
	target = MulAdd(h3, MF4x4(-0.08452829, 0.042145252, -0.0141162975, -0.07190146, 0.15463473, -0.063039616, 0.008285841, 0.0198927, 0.15278462, 0.023722362, -0.035441626, 0.09403419, 0.07525972, -0.044377264, -0.041365236, 0.043310255), target);
	target = MulAdd(i3, MF4x4(-0.0011264209, -0.06592647, 0.0049777217, -0.0060350257, 0.07328435, -0.18793981, -0.08557498, -0.04078665, 0.03258842, 0.07107648, 0.041932624, 0.037395928, 0.13042633, -0.032260742, -0.012588843, 0.023788324), target);
	target = MulAdd(na1, MF4x4(0.07511876, 0.019309277, -0.02078693, -0.14132647, 0.070082344, 0.04199505, -0.15632215, -0.032079816, 0.118265875, -0.08141349, -0.050177153, 0.11479062, 0.013268761, 0.1936229, -0.055244733, 0.020521875), target);
	target = MulAdd(nb1, MF4x4(-0.07828548, 0.018267812, 0.0028122417, 0.08941742, -0.019510742, -0.0045468058, 0.07431564, 0.24580373, 0.03412491, -0.21398748, 0.13018401, -0.01707844, 0.029651346, 0.020107506, -0.032851487, -0.10630331), target);
	target = MulAdd(nc1, MF4x4(0.049285315, -0.036977254, 0.15186474, -0.041290153, 0.036063142, -0.045490168, 0.046358738, -0.09886548, 0.08557266, -0.0694686, -0.068183534, 0.020261671, -0.026039243, -0.033528827, -0.07751181, -0.019434886), target);
	target = MulAdd(nd1, MF4x4(0.07950834, -0.0741639, 0.061423566, -0.15268423, 0.06533783, -0.03808615, -0.013910495, 0.020066373, -0.017489634, 0.050359994, 0.00039101843, 0.019134337, 0.16694714, -0.024450665, -0.065044865, -0.10637288), target);
	target = MulAdd(ne1, MF4x4(0.24476409, -0.2805558, 0.10909579, 0.13605182, -0.01699378, 0.0065869414, -0.14624152, 0.1877048, -0.067427725, 0.21585129, 0.0055718115, -0.14159104, 0.31355727, -0.30447352, -0.13559367, -0.03584342), target);
	target = MulAdd(nf1, MF4x4(0.01840529, 0.03616268, -0.062101822, -0.03462444, -0.09809899, 0.05688681, -0.06383556, 0.054451026, 0.046791434, -0.046537004, 0.0062966137, 0.036369126, 0.091391616, -0.06889375, -0.034196682, -0.09181384), target);
	target = MulAdd(ng1, MF4x4(0.08672015, -0.15510495, 0.04554155, -0.05996463, -0.00072026957, -0.09829958, 0.15477605, 0.01794818, -0.012825052, 0.11114408, -0.040433116, -0.00646929, -0.043805078, 0.012829818, -0.008625017, -0.021682253), target);
	target = MulAdd(nh1, MF4x4(-0.053777024, -0.12807386, 0.20205054, -0.05613513, 0.08030871, 0.12273628, -0.19011892, -0.007974216, -0.111842796, 0.09764242, 0.072857365, 0.049412534, -0.1310995, 0.12386843, -0.16210727, -0.001777189), target);
	target = MulAdd(ni1, MF4x4(0.0018172731, 0.046203706, 0.16447084, -0.09419196, 0.0027008723, 0.037259165, 0.018473836, -0.007634073, -0.0017314702, -0.013679133, -0.061678763, 0.033567235, -0.073024705, 0.1608741, -0.093601726, 0.05785441), target);
	target = MulAdd(na2, MF4x4(-0.05863952, 0.07315827, 0.022440575, 0.035979047, 0.016238341, -0.24431372, 0.041630965, -0.0057747364, -0.10777149, -0.13047433, 0.070022196, 0.044547863, 0.13226376, -0.28246558, 0.062450863, -0.004404347), target);
	target = MulAdd(nb2, MF4x4(0.011212715, 0.05243611, -0.037797686, -0.15245487, 0.27008712, -0.40122086, 0.0011378871, 0.05367511, 0.07193383, -0.14046453, 0.12873498, 0.07182839, 0.1820151, 0.04283299, 0.11596543, 0.15673809), target);
	target = MulAdd(nc2, MF4x4(-0.07652156, 0.02990215, -0.038398147, 0.04733479, -0.05695788, -0.04636123, -0.05849599, -0.05204433, 0.057833705, -0.18150161, -0.030429238, -0.06927262, -0.14094613, 0.046653654, 0.1901663, -0.12395862), target);
	target = MulAdd(nd2, MF4x4(0.14467525, -0.1326973, 0.10119535, -0.019431135, -0.06226663, -0.0053785043, 0.08981591, 0.07009579, -0.17320351, 0.023860384, 0.062086526, 0.053025734, 0.18955843, -0.22512685, 0.05108636, 0.022267245), target);
	target = MulAdd(ne2, MF4x4(0.10990955, 0.01449569, -0.17729793, -0.22559568, 0.011237511, -0.25115016, -0.24866548, -0.13571861, 0.072065, -0.10518834, 0.16031964, 0.33091673, 0.30525, -0.054976556, -0.051654782, 0.05343294), target);
	target = MulAdd(nf2, MF4x4(-0.022414321, -0.03275696, 0.06263573, 0.0031694071, 0.08556633, -0.12222284, -0.01304348, -0.120147005, -0.04688651, -0.037210416, -0.072757326, 0.0537857, 0.08831744, -0.16069758, 0.07254542, -0.10207554), target);
	target = MulAdd(ng2, MF4x4(-0.0033381188, -0.013647447, 0.05272343, 0.020168653, 0.064766616, 0.006531628, 0.08387307, 0.005267065, -0.1460191, 0.021020414, -0.012950353, -0.08051581, 0.11163487, -0.32247993, 0.04997282, 0.10706656), target);
	target = MulAdd(nh2, MF4x4(0.1307456, -0.044469688, 0.0073461267, 0.037865613, -0.37522125, 0.29075947, -0.14347716, -0.037057046, 0.08405833, -0.22944225, 0.048562963, 0.016957987, 0.3850271, -0.2642814, 0.24302341, -0.009866295), target);
	target = MulAdd(ni2, MF4x4(0.07751665, -0.07116216, -0.018697955, 0.013728456, 0.114070326, 0.082404934, -0.06866586, 0.0653056, -0.048189763, -0.094798714, 0.073528245, -0.09311469, 0.08910833, -0.0861494, -0.13601573, -0.03716929), target);
	target = MulAdd(na3, MF4x4(-0.3285286, -0.19887583, 0.22604318, -0.06683799, 0.07519015, -0.37451786, 0.341761, 0.47940642, -0.13582104, -0.0568941, 0.055691198, 0.077822134, -0.044976532, -0.16769643, 0.106551185, 0.06167237), target);
	target = MulAdd(nb3, MF4x4(0.2570433, -0.20537715, 0.057150505, 0.5306126, 0.23061736, -0.07200678, 0.23587582, -0.021194493, 0.0306967, -0.13228704, 0.05531426, 0.205256, -0.23213351, -0.32205653, 0.04496151, -0.114729114), target);
	target = MulAdd(nc3, MF4x4(0.08585821, -0.16611692, 0.19137008, 0.07955234, -0.07067079, -0.028957745, 0.116818264, 0.030655704, 0.044361178, 0.01137771, 0.13505548, -0.122196645, -0.120850466, 0.041478753, 0.1446364, 0.019547235), target);
	target = MulAdd(nd3, MF4x4(-0.39282933, 0.15466502, 0.21281202, -0.10871069, 0.09141795, -0.047807757, 0.13347113, -0.0070413537, -0.30001637, 0.1590897, 0.13185735, 0.26315352, 0.060256246, 0.013501628, 0.21543017, 0.18577099), target);
	target = MulAdd(ne3, MF4x4(-0.104001306, -0.5267066, -0.4119273, 0.08457817, -0.077629924, 0.16720273, 0.12549257, -0.1173481, 0.36272144, -0.7772537, 0.17534287, -0.23318143, -0.15383753, 0.095170036, 0.2495684, -0.122358866), target);
	target = MulAdd(nf3, MF4x4(0.12718932, -0.23085114, 0.44935048, -0.021294393, 0.005949905, 0.019026272, 0.075566776, 0.15591605, 0.115685046, -0.14728822, -0.05144243, 0.06136992, 0.13333684, -0.012480303, -0.088788785, 0.037873793), target);
	target = MulAdd(ng3, MF4x4(0.07020059, -0.06063198, 0.1457899, 0.0056248507, -0.008290764, -0.06342888, 0.18459271, 0.015399551, -0.11359522, 0.17675807, 0.069318, -0.040129766, -0.07564287, -0.026339471, 0.14574161, 0.23760302), target);
	target = MulAdd(nh3, MF4x4(-0.4500806, 0.37602243, 0.13479808, -0.003117945, 0.063341856, 0.061276495, 0.1102818, 0.19250661, -0.25082627, 0.22803108, 0.08279026, -0.07739116, -0.05543028, -0.1009643, 0.28930148, -0.08104323), target);
	target = MulAdd(ni3, MF4x4(-0.009021877, 0.16090877, -0.03602814, 0.1261343, 0.034350336, -0.052137982, 0.21462724, -0.02009136, -0.070031494, 0.03347469, -0.052788753, -0.05233215, -0.16940826, -0.09597297, 0.12662534, 0.019423395), target);
	conv2d_4_tf2[gxy] = target;
}

//!PASS 6
//!DESC Conv-4x3x3x24
//!IN conv2d_4_tf, conv2d_4_tf1, conv2d_4_tf2
//!OUT conv2d_5_tf, conv2d_5_tf1, conv2d_5_tf2
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass6(uint2 blockStart, uint3 threadId) {
	uint2 gxy = TileSwizzle8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	MF4 a1 = conv2d_4_tf.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b1 = conv2d_4_tf.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c1 = conv2d_4_tf.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d1 = conv2d_4_tf.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e1 = conv2d_4_tf.SampleLevel(sam, pos, 0);
	MF4 f1 = conv2d_4_tf.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g1 = conv2d_4_tf.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h1 = conv2d_4_tf.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i1 = conv2d_4_tf.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na1 = max(-a1, 0);
	MF4 nb1 = max(-b1, 0);
	MF4 nc1 = max(-c1, 0);
	MF4 nd1 = max(-d1, 0);
	MF4 ne1 = max(-e1, 0);
	MF4 nf1 = max(-f1, 0);
	MF4 ng1 = max(-g1, 0);
	MF4 nh1 = max(-h1, 0);
	MF4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	MF4 a2 = conv2d_4_tf1.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b2 = conv2d_4_tf1.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c2 = conv2d_4_tf1.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d2 = conv2d_4_tf1.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e2 = conv2d_4_tf1.SampleLevel(sam, pos, 0);
	MF4 f2 = conv2d_4_tf1.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g2 = conv2d_4_tf1.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h2 = conv2d_4_tf1.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i2 = conv2d_4_tf1.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na2 = max(-a2, 0);
	MF4 nb2 = max(-b2, 0);
	MF4 nc2 = max(-c2, 0);
	MF4 nd2 = max(-d2, 0);
	MF4 ne2 = max(-e2, 0);
	MF4 nf2 = max(-f2, 0);
	MF4 ng2 = max(-g2, 0);
	MF4 nh2 = max(-h2, 0);
	MF4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

	MF4 a3 = conv2d_4_tf2.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b3 = conv2d_4_tf2.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c3 = conv2d_4_tf2.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d3 = conv2d_4_tf2.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e3 = conv2d_4_tf2.SampleLevel(sam, pos, 0);
	MF4 f3 = conv2d_4_tf2.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g3 = conv2d_4_tf2.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h3 = conv2d_4_tf2.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i3 = conv2d_4_tf2.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na3 = max(-a3, 0);
	MF4 nb3 = max(-b3, 0);
	MF4 nc3 = max(-c3, 0);
	MF4 nd3 = max(-d3, 0);
	MF4 ne3 = max(-e3, 0);
	MF4 nf3 = max(-f3, 0);
	MF4 ng3 = max(-g3, 0);
	MF4 nh3 = max(-h3, 0);
	MF4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	MF4 target = MF4(-0.05178692, 0.012992142, -0.09760262, -0.088807374);
	target = MulAdd(a1, MF4x4(0.091359325, -0.047575854, -0.0801013, 0.20167087, -0.09074628, 0.14914455, 0.06205747, 0.08365782, -0.07602618, 0.12077156, -0.14313725, -0.00097601005, 0.1820761, -0.24430461, 0.02867478, -0.115407124), target);
	target = MulAdd(b1, MF4x4(-0.017759264, -0.17924258, -0.0345519, 0.08500409, -0.07076207, 0.080482826, 0.022080237, -0.007573794, 0.34499946, 0.008354738, 0.14645022, -0.3155209, 0.41903394, 0.008933743, -0.26766288, 0.12653211), target);
	target = MulAdd(c1, MF4x4(-0.003709739, 0.027829988, 0.14320208, -0.011639459, -0.03870455, -0.06727105, -0.23741855, -0.04182651, 0.09618168, 0.06922006, -0.03409518, -0.038725164, -0.07008305, -0.09782443, 0.06599439, -0.055400725), target);
	target = MulAdd(d1, MF4x4(0.12684472, 0.42739755, 0.05868158, 0.07929677, 0.062750086, 0.122842215, -0.2262321, -0.057169817, -0.10190911, 0.06661454, -0.2044338, -0.058569092, 0.06513055, -0.38419202, -0.2889477, 0.00075288495), target);
	target = MulAdd(e1, MF4x4(0.15597402, 0.050789982, 0.4612256, -0.1232455, 0.09143189, -0.056280397, 0.21547496, -0.043968584, -0.017269861, 0.1459616, -0.23092718, 0.27603424, 0.070095435, 0.42628354, 0.09857772, 0.023654036), target);
	target = MulAdd(f1, MF4x4(0.03566403, -0.089161746, -0.06622656, -0.043728504, 0.012655346, 0.07107657, 0.15460275, 0.09053651, -0.07001083, -0.09635171, 0.030271877, -0.010034998, 0.090245664, 0.11612592, -0.18119843, 0.115030274), target);
	target = MulAdd(g1, MF4x4(-0.055906393, 0.020972524, 0.04405409, -0.08206327, -0.030148225, 0.015709205, 0.056204747, -0.104014955, 0.044074293, -0.3603162, 0.009822444, -0.12735473, 0.0067433324, 0.21345942, -0.16173074, 0.062634476), target);
	target = MulAdd(h1, MF4x4(-0.048287738, 0.04504366, -0.16253331, -0.06976707, -0.13551746, -0.0069742347, -0.11613854, 0.13235438, 0.07955257, 0.14578325, -0.3022118, 0.02631827, 0.3573758, 0.12363717, -0.039339956, -0.21598001), target);
	target = MulAdd(i1, MF4x4(-0.075250365, -0.023891231, 0.13229692, -0.022614656, 0.08825453, 0.061776746, -0.0993127, -0.10578799, -0.1690626, 0.03054397, -0.07695639, -0.079353474, 0.0615981, 0.0034620631, 0.08599167, -0.085487425), target);
	target = MulAdd(a2, MF4x4(-0.13306135, 0.070102595, 0.0018800788, -0.09813606, -0.03170419, 0.01839398, -0.05142857, -0.010052865, -0.11429524, -0.07586167, -0.060972217, -0.022728505, -0.037173454, -0.01240384, 0.1636404, -0.1259204), target);
	target = MulAdd(b2, MF4x4(0.21663728, -0.0165655, -0.19682632, 0.13902938, -0.081392035, 0.02523787, 0.1569057, -0.016838314, -0.20710535, 0.10089684, 0.2759473, -0.06408284, -0.17343125, -0.050983876, -0.09340315, 0.042417858), target);
	target = MulAdd(c2, MF4x4(-0.44453263, -0.10516173, -0.056139067, 0.24120103, 0.14092721, 0.09527867, -0.10289124, 0.07447457, -0.07255724, -0.07065093, -0.19831358, -0.03145072, 0.062462587, -0.13137348, 0.1398097, -0.08052687), target);
	target = MulAdd(d2, MF4x4(-0.20226036, -0.089287, -0.20396022, 0.16342834, -0.0715875, 0.030659283, -0.09019761, -0.050632484, -0.087833114, -0.4390073, 0.19481303, 0.03432329, 0.22792237, 0.023274168, 0.029200593, -0.018187294), target);
	target = MulAdd(e2, MF4x4(0.46787158, 0.17991507, 0.0023480568, -0.031941783, -0.060549572, -0.09330203, 0.055897802, 0.12673432, 0.4230312, -0.4516835, -0.00064001186, 0.109839454, 0.2836279, 0.07375687, 0.17711547, -0.34547985), target);
	target = MulAdd(f2, MF4x4(0.06408312, 0.009809225, 0.12017534, 0.12778811, 0.01949525, 0.00639294, -0.022816632, -0.20515566, -0.026015112, -0.088214, 0.09398295, 0.14219733, 0.021610592, -0.0133708725, 0.15716344, 0.15374821), target);
	target = MulAdd(g2, MF4x4(-0.38632336, 0.1055968, -0.16746776, 0.031227939, 0.048837874, 0.08812276, 0.08459655, 0.037026476, -0.012736664, -0.032292336, -0.043989874, 0.030728273, -0.117319904, 0.13062797, -0.17748901, 0.20819202), target);
	target = MulAdd(h2, MF4x4(0.02485017, -0.08059275, -0.14782152, 0.16193154, 0.038559932, 0.16653356, -0.01829594, -0.32613558, 0.09611959, -0.14201616, 0.19360055, -0.16462325, 0.110373735, -0.013233708, 0.06437815, 0.05023126), target);
	target = MulAdd(i2, MF4x4(-0.0939555, 0.08396099, -0.19401367, -0.072351895, 0.0011377602, -0.08304909, 0.18247987, -0.06868134, -0.13975257, -0.072047986, 0.13241461, -0.027208991, -0.13384572, -0.04257672, -0.19476503, 0.1448576), target);
	target = MulAdd(a3, MF4x4(-0.014496433, -0.08627452, 0.013479882, 0.08189796, -0.39928418, -0.23446554, 0.033236828, -0.073348634, 0.20772837, -0.12541759, 0.12547676, 0.15118147, 0.06343077, 0.13170359, 0.07456327, 0.037460607), target);
	target = MulAdd(b3, MF4x4(0.22783525, -0.062255867, -0.015669081, 0.18545356, -0.14074744, -0.0977361, -0.15016074, 0.12626553, 0.025569597, 0.05259659, -0.1401111, 0.07791122, -0.25046918, 0.14517197, 0.051306423, 0.10093671), target);
	target = MulAdd(c3, MF4x4(0.10963008, 0.10075975, -0.09315192, 0.03928484, -0.05507595, -0.027855752, -0.17043641, 0.013336898, -0.14907023, -0.098712295, -0.055508208, -0.017730046, -0.11934544, -0.10822632, -0.07726361, 0.070103206), target);
	target = MulAdd(d3, MF4x4(-0.1622651, -0.12376016, -0.048875168, 0.030344466, -0.104258224, -0.30643496, 0.0542774, -0.21803202, -0.14617568, 0.3079984, -0.3006482, -0.116233975, -0.034087032, -0.21282312, -0.08974353, -0.21706651), target);
	target = MulAdd(e3, MF4x4(-0.17512108, -0.015798012, -0.2049979, 0.16415326, -0.037209652, -0.148847, 0.6209044, 0.35860595, 0.18044792, -0.030519703, 0.053781435, -0.4150754, 0.025012434, -0.049011238, -0.09130766, -0.12138916), target);
	target = MulAdd(f3, MF4x4(-0.044045687, 0.025672063, -0.021289285, -0.12346778, -0.12262819, -0.11085004, 0.15677044, -0.18353437, 0.35993704, -0.060050707, 0.36173448, 0.12406324, -0.006029473, -0.038038015, 0.10273825, 0.004656042), target);
	target = MulAdd(g3, MF4x4(0.08824971, 0.055099364, -0.029784897, -0.14293, 0.21541874, -0.3471079, 0.19006546, -0.25032708, 0.17953677, 0.07634346, 0.0943904, -0.14774932, -0.038256116, -0.043757852, -0.18224706, -0.0767931), target);
	target = MulAdd(h3, MF4x4(-0.14115013, -0.027943728, 0.043077346, 0.16837053, -0.30298868, -0.0012479749, -0.21017027, 0.08538537, -0.18856743, -0.1644689, 0.106126145, -0.05934489, -0.23814213, 0.089396715, -0.042591337, 0.07807625), target);
	target = MulAdd(i3, MF4x4(0.1340491, 0.052864898, 0.030508095, -0.053534534, 0.0763844, -0.083921455, -0.007467296, 0.10813974, -0.13826096, 0.07286494, 0.017945437, 0.12293839, -0.14042178, -0.02947513, -0.031838633, 0.12082989), target);
	target = MulAdd(na1, MF4x4(0.1102285, 0.19918683, 0.040284276, -0.0514123, -0.047394637, -0.021792434, 0.012939052, -0.0023403286, 0.23044759, 0.21366574, -0.1535014, 0.15519466, -0.006563226, 0.07491919, 0.122444265, -0.093628265), target);
	target = MulAdd(nb1, MF4x4(-0.23274226, 0.104155675, 0.1884381, 0.02142028, 0.11323431, 0.1554841, 0.123437695, -0.03776226, -0.45464247, -0.25061348, -0.032978028, -0.018654265, -0.024727726, 0.06470798, -0.122398995, -0.21492854), target);
	target = MulAdd(nc1, MF4x4(0.14285532, 0.0013011715, -0.06574208, 0.086654305, -0.048436016, -0.16197361, 0.008795141, -0.018098531, 0.3623435, 0.12052228, 0.21655083, -0.057346217, -0.08660433, 0.20646246, -0.145056, 0.009912266), target);
	target = MulAdd(nd1, MF4x4(-0.120041594, -0.25241104, -0.6336183, -0.12418686, 0.008573801, -0.06827598, -0.09228199, -0.07655123, 0.07855638, 0.089592285, 0.15033577, -0.2273755, 0.06294413, -0.011506087, -0.2499483, -0.35493052), target);
	target = MulAdd(ne1, MF4x4(-0.06940104, -0.06756523, -0.53161937, 0.12494837, -0.06503322, 0.11604297, -0.34153852, 0.04156643, -0.45669356, -0.044081815, 0.004695825, -0.072227545, -0.02530914, -0.17312789, -0.09068418, -0.09982657), target);
	target = MulAdd(nf1, MF4x4(-0.29282403, -0.010049017, -0.024964066, 0.017599167, 0.078072265, -0.02860973, 0.19687887, 0.19570877, 0.0462925, 0.09549612, -0.1492184, -0.23970652, 0.1505322, 0.019254023, -0.042950142, -0.015978891), target);
	target = MulAdd(ng1, MF4x4(-0.03936397, -0.16615695, 0.031633284, -0.15845262, 0.07402319, -0.10969973, 0.1627256, -0.082409754, 0.25605643, 0.12996247, 0.0026216798, 0.09912746, 0.05241615, -0.19865209, 0.16946888, 0.05068021), target);
	target = MulAdd(nh1, MF4x4(0.01114184, 0.084049165, 0.21976121, 0.2706964, -0.1294367, -0.06303496, -0.023219386, 0.077690855, 0.27775633, 0.00947329, -0.15350725, -0.33890706, -0.11828109, 0.09787361, -0.016221395, 0.016552113), target);
	target = MulAdd(ni1, MF4x4(0.06600668, -0.038050972, 0.05673705, -0.074460626, -0.033874847, 0.04394138, -0.09962254, 0.024659669, 0.22614685, 0.0010322065, 0.09654571, -0.06633969, -0.10417394, -0.026023693, -0.022211308, 0.07900881), target);
	target = MulAdd(na2, MF4x4(0.036456246, -0.2124808, -0.012558569, -0.005300579, -0.00047140988, 0.35318285, -0.06906561, 0.17434907, 0.062296104, 0.07322263, 0.07417871, 0.018067235, -0.08858221, -0.14630227, 0.029234141, -0.15545718), target);
	target = MulAdd(nb2, MF4x4(0.0863986, -0.040072814, -0.06980794, 0.2665523, -0.16316326, 0.110833816, 0.095236875, -0.2692474, 0.04447339, 0.06251346, 0.22095545, -0.041103855, 0.06609487, -0.019505464, -0.05033705, 0.22964026), target);
	target = MulAdd(nc2, MF4x4(0.29361203, 0.13948435, -0.04883785, -0.055638783, -0.21016635, 0.06452464, 0.2573405, 0.015132235, -0.20484985, -0.21653354, 0.21269105, 0.0118991295, -0.081802815, 0.105966985, -0.3921394, 0.20990291), target);
	target = MulAdd(nd2, MF4x4(-0.08627829, 0.03343112, 0.31935173, 0.20275539, 0.069561645, 0.44631377, -0.16738373, -0.35273424, 0.1321877, 0.41263857, 0.15853775, 0.1095465, -0.14425585, 0.046967953, 0.052787095, 0.20420372), target);
	target = MulAdd(ne2, MF4x4(-0.6400273, -0.02383611, 0.002919604, 0.20062971, 0.22101505, 0.13407028, -0.3607917, 0.097198665, -0.009687387, 0.20925479, -0.22717565, -0.077685565, -0.10238261, -0.30386773, -0.07093403, 0.3789904), target);
	target = MulAdd(nf2, MF4x4(0.19998863, 0.11971228, -0.12407401, -0.020293633, 0.17083226, 0.07682446, 0.017597012, 0.16630399, -0.044776015, 0.038629167, 0.09155888, 0.2775535, 0.17645419, 0.05448149, 0.26603785, -0.23594949), target);
	target = MulAdd(ng2, MF4x4(0.13560197, -0.12419031, -0.001434453, 0.096761554, -0.025025826, 0.23237492, -0.22578233, 0.39105797, -0.1521174, 0.012731402, -0.12703973, 0.17032094, -0.23923986, 0.15013756, -0.079769395, 0.21047747), target);
	target = MulAdd(nh2, MF4x4(0.023834813, 0.042676624, -0.043734103, -0.0489564, 0.2968653, 0.12845509, 0.26865506, -0.1339746, 0.1031858, 0.06713386, 0.035661936, -0.008399658, -0.023008743, 0.14043713, -0.10849628, -0.29047936), target);
	target = MulAdd(ni2, MF4x4(-0.15448047, 0.018301843, -0.11298581, 0.0643367, 0.19861038, 0.054608114, 0.053602763, -0.12229704, 0.1838333, 0.060085677, -0.054444484, -0.03963665, -0.09128162, -0.002571187, -0.011031746, 0.013937809), target);
	target = MulAdd(na3, MF4x4(-0.19042498, -0.10742417, -0.009482582, -0.13710654, 0.07004467, 0.054024436, -0.079347484, -0.069204524, -0.066065274, 0.029851453, 0.057536937, -0.10738562, -0.0019049636, -0.05961882, 0.015954375, -0.046048168), target);
	target = MulAdd(nb3, MF4x4(-0.30546746, 0.026462605, -0.16525201, -0.14865883, -0.22890806, -0.064678855, -0.07405687, -0.060555395, 0.19689551, -0.10453069, -0.13507089, 0.044260368, 0.3549059, -0.2059544, -0.017047137, -0.085279755), target);
	target = MulAdd(nc3, MF4x4(0.15902059, 0.27806246, -0.02470931, -0.071123265, -0.10959986, -0.061866783, 0.18073395, 0.027781103, 0.01899935, 0.0068895225, 0.09553635, 0.014020304, 0.48340565, 0.1568511, 0.18551165, -0.03941332), target);
	target = MulAdd(nd3, MF4x4(0.18007858, -0.18097854, -0.032877125, -0.13505274, 0.12229551, -0.19246832, 0.07324526, 0.16423881, -0.07985383, 0.102822796, 0.022348268, 0.20718963, 0.1657745, 0.09994554, -0.044875868, -0.04791159), target);
	target = MulAdd(ne3, MF4x4(-0.1522259, -0.15503414, 0.5213648, 0.048220746, -0.03673415, -0.048296932, -0.0035913677, -0.33058712, -0.37347135, -0.107429914, -0.27443045, 0.1444104, -0.12858333, -0.0898987, 0.18059024, 0.2385074), target);
	target = MulAdd(nf3, MF4x4(-0.17812404, 0.027946725, -0.15453176, -0.16888796, -0.1454275, -0.08521876, -0.09842795, 0.017285218, -0.15038043, 0.12944756, -0.0074227825, 0.049601924, -0.2942431, 0.3029513, 0.2346801, -0.010824461), target);
	target = MulAdd(ng3, MF4x4(-0.13489157, -0.19739941, 0.19581558, -0.08267463, -0.16068561, 0.019075824, 0.0042642844, 0.1025828, 0.009590443, -0.042244606, 0.0069560697, 0.18787669, 0.08875559, 0.12666185, 0.27844438, -0.014087231), target);
	target = MulAdd(nh3, MF4x4(-0.15345146, -0.088549316, -0.2007104, 0.08694364, 0.097901054, -0.09112625, 0.17398718, -0.08376772, 0.13471653, -0.11526493, 0.09551537, 0.000994288, 0.10547293, 0.027825898, 0.13316914, 0.27184469), target);
	target = MulAdd(ni3, MF4x4(-0.2831289, -0.1077123, -0.015594004, -0.15530941, 0.030916838, -0.007725551, -0.0013768732, -0.0542834, 0.14217895, -0.019043038, -0.121255994, 0.1774951, -0.02571608, 0.08931403, -0.05238016, 0.49422094), target);
	conv2d_5_tf[gxy] = target;
	
	target = MF4(0.06121498, 0.024510587, -0.012219787, 0.074479066);
	target = MulAdd(a1, MF4x4(0.06822733, 0.047476072, 0.010553384, -0.06512182, -0.014951614, -0.023422068, 0.12602834, -0.06063965, 0.11658996, -0.0075021465, -0.015290296, -0.18518211, 0.06179118, 0.06263638, 0.2701791, 0.03897366), target);
	target = MulAdd(b1, MF4x4(-0.005936342, 0.0046865293, 0.1009514, 0.113875, -0.22882754, 0.06882264, 0.044918634, -0.15084246, 0.27190965, -0.09802474, -0.17399205, -0.28109655, 0.115927316, 0.065323986, -0.07905437, 0.31301168), target);
	target = MulAdd(c1, MF4x4(-0.058077507, 0.060739186, -0.047071032, 0.08625859, 0.18279932, -0.062378623, -0.020198788, -0.020209447, -0.03725052, -0.17194895, -0.009185631, -0.061395645, -0.10394699, 0.13250858, -0.02054919, 0.17315096), target);
	target = MulAdd(d1, MF4x4(0.14755291, -0.15426354, -0.038297612, -0.002863782, 0.014281958, -0.1430333, -0.15214095, -0.25977355, 0.055283524, -0.020698514, -0.031711206, 0.043652818, -0.011913896, -0.15935701, 0.30120242, -0.07141416), target);
	target = MulAdd(e1, MF4x4(-0.07511256, 0.097857445, 0.1280642, -0.23440666, 0.07341128, 0.025019338, 0.2676868, -0.6392872, -0.018604822, -0.41209763, 0.036267836, 0.048222575, -0.049899656, 0.12035686, -0.415035, 0.111109026), target);
	target = MulAdd(f1, MF4x4(0.06660235, 0.10465846, 0.03231821, -0.057176817, -0.33603838, -0.117789224, -0.08611003, -0.14391285, -0.07540102, -0.049893077, 0.06534853, 0.014703251, 0.1686735, 0.21635768, -0.0004174196, -0.06970894), target);
	target = MulAdd(g1, MF4x4(-0.09123483, -0.02650008, -0.26045164, 0.008752753, -0.038899194, 0.056095514, -0.15680234, -0.21681328, -0.1807998, -0.08361851, -0.20086065, 0.13148476, 0.009767108, -0.0006198602, 0.15239619, -0.07983563), target);
	target = MulAdd(h1, MF4x4(0.07919758, -0.10799586, -0.11674191, 0.07721418, -0.02489812, 0.013862152, 0.14324659, -0.19167677, 0.47860634, 0.016703675, -0.025147682, -0.13012366, 0.021707488, -0.049213693, -0.049455807, -0.122704044), target);
	target = MulAdd(i1, MF4x4(-0.1036183, -0.0016137742, -0.010286528, 0.03161724, 0.111006066, -0.010090895, -0.13061818, -0.12827039, -0.06817742, -0.08191259, -0.010029781, 0.0756146, -0.024297824, 0.08189767, 0.0012347228, -0.061834745), target);
	target = MulAdd(a2, MF4x4(0.074035384, -0.0054270145, -0.054232355, 0.052020255, 0.039064236, 0.07612554, -0.07112709, -0.041343223, -0.04877365, -0.081693694, -0.19036053, -0.07976283, -0.019394593, 0.11878604, -0.17398894, 0.066551484), target);
	target = MulAdd(b2, MF4x4(0.021499138, 0.11031255, 0.07942792, 0.19678888, -0.1660272, 0.12142711, 0.053864148, -0.09273723, -0.04266638, -0.092488594, 0.052425362, -0.13612169, 0.055963192, -0.08253813, -0.03933135, 0.01831182), target);
	target = MulAdd(c2, MF4x4(-0.009105146, 0.25351846, 0.021370875, 0.07980244, 0.08131595, 0.0045822896, 0.024319764, 0.13540691, 0.10949155, -0.036669955, -0.0440662, 0.031805526, 0.0076850317, 0.0050480044, 0.010493236, -0.20307945), target);
	target = MulAdd(d2, MF4x4(0.035208475, -0.016913606, 0.06748526, 0.28376573, -0.09829214, 0.03491954, -0.048616122, -0.022004133, 0.033356942, 0.041457683, -0.1141923, 0.053526472, 0.1301348, 0.032898832, 0.14776024, 0.11034088), target);
	target = MulAdd(e2, MF4x4(0.25044763, 0.1022549, 0.13824631, 0.15358314, -0.01792875, -0.023492826, -0.16425751, -0.04925489, -0.5415385, 0.22712392, 0.32446757, 0.061109796, -0.016136007, 0.09170503, -0.020712415, 0.22309552), target);
	target = MulAdd(f2, MF4x4(-0.16366409, -0.017794464, -0.12714142, -0.021118859, 0.03178183, 0.067133196, 0.105975136, 0.009305183, 0.08399536, 0.15291104, -0.029605338, 0.0134068895, -0.09861506, -0.059872147, -0.03844756, -0.12674972), target);
	target = MulAdd(g2, MF4x4(-0.07806115, 0.043562375, -0.009290437, 0.04422061, 0.044749737, 0.06424069, 0.026669348, 0.03424551, 0.024359688, -0.07599093, -0.037592914, 0.054648582, 0.06240557, 0.061408926, 0.030988218, 0.08729672), target);
	target = MulAdd(h2, MF4x4(-0.010351677, 0.028773759, 0.12303081, -0.046040278, -0.06785082, -0.24544333, -0.14512034, 0.028818216, -0.030756637, -0.070427775, 0.029058386, 0.11266564, -0.0126586575, -0.099691354, 0.23675011, 0.021924842), target);
	target = MulAdd(i2, MF4x4(0.29327697, 0.04030911, -0.10077885, -0.048846, -0.16350128, -0.054487552, 0.070820816, 0.047305796, -0.12812468, 0.007919711, -0.09975894, 0.06570609, 0.041386835, -0.027804038, 0.054338817, -0.09551541), target);
	target = MulAdd(a3, MF4x4(-0.08264294, 0.0022153752, 0.17625731, 0.108203925, -0.1994716, 0.13532871, 0.004684368, -0.068710595, 0.118159816, -0.07109689, 0.0926224, -0.24703208, -0.01173713, 0.033426084, -0.016495464, 0.12449714), target);
	target = MulAdd(b3, MF4x4(-0.0937873, -0.065207124, 0.1289635, 0.17735708, -0.07141622, -0.116392545, -0.012032065, 0.2256439, -0.16182312, -0.12979633, 0.13266288, -0.029406255, -0.11667275, 0.010681019, -0.03679369, 0.12324768), target);
	target = MulAdd(c3, MF4x4(-0.08298939, -0.04220063, 0.03483479, 0.13134407, 0.21608235, -0.034893714, -0.12628594, 0.16904697, 0.021075964, 0.1242292, 0.049865, 0.0012191305, 0.02183184, 0.106443465, -0.097153716, 0.10045028), target);
	target = MulAdd(d3, MF4x4(-0.15327847, -0.03231816, 0.048716772, 0.04888897, 0.042859055, 0.15434006, -0.20086974, -0.05871333, -0.06012798, -0.16594929, -0.41956443, 0.02897127, 0.10374121, 0.0979167, -0.06796184, -0.16530903), target);
	target = MulAdd(e3, MF4x4(0.4286096, -0.29660472, -0.16605186, 0.27494267, 0.026896525, 0.28659457, -0.03428165, 0.2044704, 0.48915815, -0.33265522, 0.21135275, 0.33785677, 0.18982616, 0.10604258, -0.064662024, 0.096615575), target);
	target = MulAdd(f3, MF4x4(0.016727265, 0.17198113, -0.05871693, 0.054799933, -0.02786635, 0.15011124, -0.23983961, 0.033867355, -0.19206874, -0.13592441, 0.07261021, -0.043166462, -0.12164969, -0.07333818, 0.037067372, 0.08996417), target);
	target = MulAdd(g3, MF4x4(-0.070286445, -0.10659555, -0.04422945, -0.053230558, 0.0013350527, -0.017993074, -0.049735866, 0.11409308, 0.04892686, -0.06817943, -0.12813167, 0.039810136, 0.05252391, -0.06560004, -0.063294955, -0.07105003), target);
	target = MulAdd(h3, MF4x4(-0.13546339, 0.14185336, 0.006366223, -0.28422508, -0.21820036, 0.039592113, -0.07649182, -0.27793187, -0.2901769, -0.046293516, 0.25072086, -0.1427351, -0.0032531293, 0.03191745, -0.029102972, 0.050067473), target);
	target = MulAdd(i3, MF4x4(0.07247183, -0.0060611004, -0.04357295, -0.10875274, 0.12985152, 0.08760643, -0.19915642, -0.014556378, 0.1215484, 0.25098228, -0.21922487, 0.021113032, 0.0839372, 0.055542022, 0.13710897, -0.027615722), target);
	target = MulAdd(na1, MF4x4(0.19114621, 0.099159814, 0.011108828, 0.029784255, 0.08460498, 0.015443031, -0.044587217, 0.09834142, 0.10807179, -0.05328408, 0.13301793, 0.11193144, 0.18251152, 0.083096996, -0.08564835, -0.15828381), target);
	target = MulAdd(nb1, MF4x4(-0.28161234, 0.1756162, 0.17534174, -0.15757571, -0.08024952, 0.05677887, -0.1527151, -0.035949282, -0.16559522, -0.03176932, -0.15242305, 0.026554676, 0.07632302, -0.07731726, -0.17139448, -0.3687111), target);
	target = MulAdd(nc1, MF4x4(0.08050096, -0.0065235267, 0.064694345, -0.014644451, -0.079178736, 0.042656552, 0.09551645, 0.036842708, -0.03371497, -0.088755935, 0.07605894, -0.10299958, 0.08336513, -0.1338214, -0.051605105, -0.19725145), target);
	target = MulAdd(nd1, MF4x4(0.051400978, -0.02814356, -0.5582187, 0.05216139, -0.12328604, 0.07732251, -0.16055895, 0.14309604, 0.017186563, 0.08711397, -0.17381294, -0.011499491, -0.0481547, -0.04854952, -0.46566048, -0.3058923), target);
	target = MulAdd(ne1, MF4x4(0.5119618, -0.38263124, 0.15986086, 0.010742568, 0.38711935, -0.336849, 0.040117126, 0.4004001, 0.19877116, 0.47289473, 0.021661036, -0.015238145, 0.09152666, 0.038322717, 0.06817698, 0.049476456), target);
	target = MulAdd(nf1, MF4x4(-0.10441812, 0.21133856, -0.057014488, 0.23972808, -0.24930222, -0.050501857, 0.032259904, 0.12751378, 0.27306128, 0.30964115, -0.11031131, 0.12801209, 0.178222, -0.062289014, 0.022079576, -0.11246125), target);
	target = MulAdd(ng1, MF4x4(-0.03134103, -0.22539799, 0.06857922, -0.10189109, -0.05753412, -0.024686527, 0.013851189, 0.1957986, -0.020091414, 0.14719157, 0.11946867, -0.09724786, 0.0028783937, 0.060009662, 0.013492387, 0.11172315), target);
	target = MulAdd(nh1, MF4x4(0.025690198, 0.23751663, 0.12185973, -0.019141376, -0.084277906, 0.11608392, 0.16283877, 0.042005546, 0.072981484, -0.2306133, -0.071143106, -0.18201771, -0.031751275, -0.020903533, 0.12043939, 0.20526986), target);
	target = MulAdd(ni1, MF4x4(-0.033504594, -0.09981515, 0.19222768, -0.00037204215, 0.07057902, 0.10403715, -0.03022699, 0.098804235, 0.18592818, 0.024603445, 0.11061402, -0.11533017, -0.12443965, 0.011813011, 0.07349946, 0.038668673), target);
	target = MulAdd(na2, MF4x4(-0.23181002, -0.17350966, 0.048837297, -0.08551675, 0.18603337, 0.058313303, 0.04316692, 0.058691278, -0.004881664, 0.0729517, -0.03626247, 0.15820287, -0.02682429, -0.0048006307, -0.094057836, -0.14746818), target);
	target = MulAdd(nb2, MF4x4(0.1383817, -0.1420967, 0.1424335, 0.22556119, -0.00086617674, 0.16489741, -0.26023895, -0.20425053, -0.034436412, 0.2758035, -0.059897684, -0.13402066, -0.16843258, -0.121999204, 0.3507855, 0.12512234), target);
	target = MulAdd(nc2, MF4x4(0.0632651, -0.025671296, -0.07224494, -0.037086867, -0.09273154, 0.0072819768, -0.049275056, -0.1953304, -0.17975083, 0.082679234, 0.053353265, -0.006074758, 0.20823684, 0.062092874, 0.11811291, 0.1815561), target);
	target = MulAdd(nd2, MF4x4(0.078111276, 0.25469536, 0.29218477, 0.004212939, -0.1232599, 0.021684207, -0.66154927, -0.343972, 0.010710011, -0.08535829, 0.18138462, 0.09095369, -0.103921935, 0.057450265, 0.25861067, -0.15153539), target);
	target = MulAdd(ne2, MF4x4(-0.10782405, 0.18735452, -0.19443172, -0.15904504, 0.18990147, 0.48975512, 0.4310995, 0.1340281, 0.3089527, -0.10327674, -0.09608584, -0.123780966, -0.08807219, 0.14264533, -0.3084031, 0.02124611), target);
	target = MulAdd(nf2, MF4x4(0.15577073, -0.06495954, 0.060370963, -0.114554875, 0.0047810473, 0.3622068, -0.3659395, 0.15643036, -0.07608074, 0.04065042, -0.039538994, -0.02360629, -0.02197194, 0.0048276316, 0.110902175, -0.16704206), target);
	target = MulAdd(ng2, MF4x4(-0.0020525095, -0.012990091, 0.094804876, -0.02951601, 0.24626282, 0.124219425, 0.0463335, 0.094997995, -0.048861977, -0.005314135, 0.0059577175, -0.105576694, 0.048093226, 0.09738743, 0.21545859, 0.054231316), target);
	target = MulAdd(nh2, MF4x4(0.07456489, 0.02194597, -0.20656359, -0.15409991, -0.04743203, -0.15427557, -0.24320696, 0.23521787, 0.016238466, -0.012914946, -0.05602358, 0.06522049, 0.102704614, -0.23755711, -0.08094957, 0.008219577), target);
	target = MulAdd(ni2, MF4x4(0.035681196, -0.033441707, -0.11075713, 0.055746105, 0.019134156, -0.049570475, 0.06607101, -0.0073855054, 0.07943337, -0.11261986, 0.0008748123, -0.10753691, -0.10877436, -0.0108197965, -0.04098305, 0.020095402), target);
	target = MulAdd(na3, MF4x4(0.027692698, -0.023028603, -0.100124516, -0.103564754, 0.039096612, -0.010974292, -0.02888593, 0.08225068, -0.022655668, -0.023619713, -0.04132294, 0.06264889, 0.11349463, 0.074886896, -0.026237458, -0.13935888), target);
	target = MulAdd(nb3, MF4x4(-0.07625777, -0.02026929, -0.16509674, -0.07015678, 0.12159663, 0.11826456, -0.16222349, 0.02991282, 0.31014135, -0.18721381, 0.015715228, 0.013268594, -0.0226595, -0.086094275, 0.24472123, -0.10165225), target);
	target = MulAdd(nc3, MF4x4(-0.0046345745, -0.08258393, -0.0949934, -0.18188646, -0.082375005, 0.07654353, 0.023176871, -0.020692138, 0.024534898, -0.115623355, -0.012813735, 0.06324557, 0.10770564, -0.08825215, 0.049195863, -0.076814786), target);
	target = MulAdd(nd3, MF4x4(-0.038878765, -0.10554748, -0.03482947, -0.2024768, -0.09590611, -0.05518289, 0.17108603, 0.10745178, 0.14090835, 0.04451474, 0.33331943, -0.09338132, -0.13840568, -0.06591041, -0.13315365, 0.14895599), target);
	target = MulAdd(ne3, MF4x4(-0.7184948, 0.20635058, -0.01087146, -0.25665486, 0.0694774, -0.08051657, -0.20419565, -0.29972658, -0.31587854, 0.26213837, -0.14282377, -0.14769338, -0.29376042, -0.24546684, 0.37429252, -0.01691138), target);
	target = MulAdd(nf3, MF4x4(0.010284815, -0.29481632, 0.18720046, 0.028168285, -0.025520338, -0.031638097, 0.07629401, 0.23760115, -0.06497784, -0.09899808, -0.025247818, -0.141932, 0.30421942, 0.0839128, 0.15210237, -0.2547937), target);
	target = MulAdd(ng3, MF4x4(-0.11730973, 0.08676562, -0.12592962, 0.059735335, 0.036849916, 0.01789285, -0.02247672, 0.034570415, 0.069350585, -0.047193673, 0.06288105, -0.016742256, -0.06302216, 0.00919547, 0.12617198, -0.001655632), target);
	target = MulAdd(nh3, MF4x4(0.13489273, -0.05945722, 0.15636152, 0.10246266, -0.0492767, 0.13209876, -0.022542313, 0.1869006, 0.18273778, -0.009863488, 0.1475087, 0.009797511, 0.18775922, -0.08949364, 0.031399027, 0.16898693), target);
	target = MulAdd(ni3, MF4x4(-0.17234778, -0.113925606, 0.0285368, 0.093877554, -0.010534175, 0.002686299, 0.033060588, -0.019788781, 0.12574218, 0.03520547, 0.0032812972, 0.04480523, 0.06951987, -0.25137702, 0.01562915, -0.02552195), target);
	conv2d_5_tf1[gxy] = target;

	target = MF4(0.06602671, 0.113320544, -0.04297089, 0.007400785);
	target = MulAdd(a1, MF4x4(-0.06058286, 0.2195084, 0.19780184, -0.05155375, 0.09216426, 0.03457752, -0.096646644, -0.015035897, -0.13803566, 0.025244685, 0.13735959, -0.009401512, -0.16166702, -0.1815502, 0.007993552, 0.0069571338), target);
	target = MulAdd(b1, MF4x4(0.047445912, 0.11488218, -0.17851587, -0.1392721, -0.038011838, 0.17368795, 0.106928326, -0.13197932, -0.2733485, -0.087136164, 0.07961574, 0.020573204, 0.029977003, -0.1667677, -0.17820576, 0.0118401665), target);
	target = MulAdd(c1, MF4x4(0.07106099, -0.00185452, -0.027270012, -0.09875212, 0.06354194, -0.16046102, -0.034993082, -0.053045254, 0.068700135, 0.09387552, -0.09717345, -0.06485704, 0.050274733, -0.015956623, -0.14531186, -0.023925254), target);
	target = MulAdd(d1, MF4x4(-0.020267177, 0.09845256, -0.22237779, -0.0704043, -0.03563008, 0.0058337585, -0.053230047, -0.0151015995, -0.004355268, -0.16663343, -0.022371203, 0.17783938, 0.27934113, 0.038911168, 0.053898126, 0.067584395), target);
	target = MulAdd(e1, MF4x4(-0.35373348, -0.04811985, -0.003069958, 0.22371289, 0.039519783, 0.08697823, 0.12242937, -0.05692152, 0.34154105, -0.30326834, -0.23093781, 0.060490705, -0.3779121, -0.12894416, 0.03531685, 0.27401015), target);
	target = MulAdd(f1, MF4x4(-0.27760014, 0.024816839, 0.16137716, 0.060659613, -0.0962453, -0.023302421, -0.0679713, 0.08072911, 0.10419372, -0.1286133, -0.06336595, -0.13529508, -0.033300906, 0.077698715, 0.13658288, -0.046092913), target);
	target = MulAdd(g1, MF4x4(0.004510119, -0.018816976, -0.023925988, -0.056694455, 0.021134097, 0.15678076, -0.034855466, -0.052143726, 0.11061209, -0.03679294, -0.15515395, 0.22478753, 0.030984117, 0.01664375, -0.010612448, -0.01799207), target);
	target = MulAdd(h1, MF4x4(0.18006827, 0.168574, 0.15232614, -0.1295002, -0.05264042, -0.12097018, -0.08624036, -0.20883065, 0.22397974, 0.041060217, -0.23898268, 0.09747489, 0.0005401559, -0.17116228, 0.03260164, 0.2373106), target);
	target = MulAdd(i1, MF4x4(0.0005155169, -0.10857663, -0.014398447, 0.004808808, -0.05587811, 0.1242163, 0.14578046, -0.09588132, 0.14351574, -0.10559421, -0.041078355, 0.0059864363, -0.061656762, -0.07678676, -0.10182491, -0.10634101), target);
	target = MulAdd(a2, MF4x4(-0.04443192, 0.13661186, -0.076222196, -0.081149, -0.041719135, -0.12614048, 0.018182557, 0.03125801, 0.06955725, 0.09229393, -0.0070879795, 0.038897008, 0.0052797156, 0.13088952, -0.073197, -0.11281815), target);
	target = MulAdd(b2, MF4x4(0.19961423, 0.13726334, 0.27169493, 0.05927113, 0.0028651909, -0.1287458, 0.026732842, -0.095184654, 0.016316563, -0.11783113, 0.2360606, -0.30774674, 0.108432285, 0.23025006, -0.085001394, 0.08807084), target);
	target = MulAdd(c2, MF4x4(-0.060046196, 0.15679826, 0.2430814, -0.13272808, 0.019943269, 0.015503196, -0.030504405, 0.06340887, 0.1670832, -0.13615952, -0.13015799, 0.042683575, -0.06566812, -0.062855676, 0.056155447, -0.13632087), target);
	target = MulAdd(d2, MF4x4(-0.04923022, 0.053739548, 0.23691703, 0.045897946, 0.08574055, 0.015698176, 0.30700058, 0.03893632, -0.09240451, 0.13776198, -0.01634878, 0.1086944, -0.10443478, -0.038250007, -0.16425894, 0.069837235), target);
	target = MulAdd(e2, MF4x4(-0.4527755, -0.16416265, 0.45300293, 0.11527787, 0.06872868, 0.03514386, -0.02678375, 0.04558898, -0.21735664, -0.38876057, 0.15125597, 0.20117617, -0.15160187, -0.2531804, 0.15049757, -0.018326014), target);
	target = MulAdd(f2, MF4x4(0.013021216, 0.07807231, -0.025769137, 0.13387477, -0.16259682, -0.054581523, 0.17289965, -0.08043052, 0.0063357623, 0.11866516, -0.13520378, 0.0152135575, 0.061740812, 0.052589882, -0.16574025, 0.024117855), target);
	target = MulAdd(g2, MF4x4(0.04268464, 0.06037914, 0.06682348, 0.054433875, -0.14284062, 0.007709387, 0.05249287, -0.008818238, 0.02744223, 0.026029283, -0.068422645, 0.104170494, 0.011463976, 0.10870952, 0.11592658, 0.07393047), target);
	target = MulAdd(h2, MF4x4(-0.03750191, 0.0014403146, 0.1580456, 0.1137993, 0.08569837, 0.0005632574, 0.08939288, -0.004063193, 0.03108807, -0.1707586, 0.06543877, -0.02108999, -0.044783764, -0.09259009, 0.0018684827, 0.10293258), target);
	target = MulAdd(i2, MF4x4(-0.072144635, 0.13235292, 0.13174231, 0.06512337, 0.061325137, -0.1140173, -0.10778849, -0.0933897, -0.0026419833, 0.031816084, -0.05882651, -0.05534951, 0.05234496, -0.03341018, -0.028817033, -0.034064483), target);
	target = MulAdd(a3, MF4x4(0.06916357, -0.11582247, -0.06554703, 0.09624395, 0.11644621, 0.019876527, -0.08696374, 0.017086076, -0.054255698, 0.28372917, -0.000972655, -0.06400794, 0.030290179, -0.08620439, -0.08410291, -0.012277875), target);
	target = MulAdd(b3, MF4x4(0.06226754, -0.040624045, -0.11270401, 0.10805481, 0.18899143, -0.1973884, -0.034787323, 0.05666152, -0.087144844, 0.032518808, -0.12266705, -0.12644689, 0.035625648, 0.13503525, 0.10947289, -0.02394309), target);
	target = MulAdd(c3, MF4x4(-0.022302793, 0.10360904, 0.016256806, -0.021677233, 0.12430526, 0.042963423, -0.18037538, -0.14628161, 0.016152794, -0.11254728, 0.06434654, -0.005073352, 0.016403137, -0.035858087, -0.06591741, 0.08597588), target);
	target = MulAdd(d3, MF4x4(0.004012092, -0.050453838, 0.07977573, 0.15305792, -0.05928047, -0.09349286, -0.14555392, 0.12337536, 0.16214384, -0.109313816, -0.044248413, -0.2963013, -0.14371789, -0.13369437, 0.07077758, 0.10006308), target);
	target = MulAdd(e3, MF4x4(0.06548829, -0.13058634, -0.26494655, -0.28315514, -0.45161557, -0.07177602, 0.10558368, 0.21007149, 0.45134485, 0.53428864, -0.24526665, -0.51175225, -0.16881745, 0.39553252, -0.059874248, -0.15100208), target);
	target = MulAdd(f3, MF4x4(-0.034883123, 0.09653819, 0.16275059, -0.10605186, -0.16961089, 0.15750273, -0.28543097, -0.12217311, 0.19074517, 0.00074714713, -0.07579063, 0.14993025, -0.013494211, 0.19434276, -0.038070716, 0.041972294), target);
	target = MulAdd(g3, MF4x4(0.077254616, 0.013449401, -0.068184, 0.10592368, 0.024376335, 0.0051301597, -0.13352032, 0.17067592, -0.07192257, 0.055784814, -0.12246667, 0.01487913, 0.116122164, 0.10971574, 0.026872944, -0.026666151), target);
	target = MulAdd(h3, MF4x4(0.05711798, -0.0010387006, -0.11265493, 0.27974793, 0.091452494, -0.20599814, -0.15438712, 0.32230932, -0.105436936, -0.35339028, -0.08469404, -0.03431861, -0.0006499669, -0.2701855, -0.011796139, -0.04423021), target);
	target = MulAdd(i3, MF4x4(-0.0829698, 0.06493657, -0.036546737, 0.024583373, 0.048521917, 0.1649191, -0.056993846, 0.08988572, -0.12735078, 0.3074979, 0.08563853, 0.119320676, 0.18576288, 0.14356904, -0.026636694, 0.05132804), target);
	target = MulAdd(na1, MF4x4(-0.0991048, -0.10884221, -0.12869547, 0.034603372, -0.06870907, -0.18230984, -0.021502903, 0.11301028, 0.18878941, -0.110253036, 0.040812176, -0.06389069, -0.15005918, 0.0037244866, 0.2132717, -0.013256287), target);
	target = MulAdd(nb1, MF4x4(-0.08388061, -0.112235, 0.065214306, -0.13957025, -0.19478679, 0.11254506, 0.054630954, 0.053645436, -0.2522801, 0.15058047, -0.07061216, -0.096459135, -0.11855631, -0.056933407, 0.035139047, 0.068258055), target);
	target = MulAdd(nc1, MF4x4(-0.06917721, 0.094096094, 0.07469013, 0.16470721, -0.11484115, -0.18424381, 0.016549148, 0.08468404, 0.04055001, -0.33645272, -0.0059957053, 0.08970189, 0.09028248, 0.04077987, -0.06547463, -0.006269863), target);
	target = MulAdd(nd1, MF4x4(0.21908568, 0.08401723, 0.0843042, 0.06545498, -0.08450129, -0.028926728, 0.19440761, 0.09694871, 0.07596912, 0.045503646, -0.006316475, -0.27986103, 0.06910375, -0.43196592, 0.03879253, 0.1638245), target);
	target = MulAdd(ne1, MF4x4(0.8879269, -0.02551214, -0.030510996, -0.36941388, 0.3126625, 0.21035604, -0.15371346, -0.2780625, 0.06461355, 0.18609639, -0.149495, -0.23149131, 0.46026996, 0.035948373, 0.18278143, -0.20113651), target);
	target = MulAdd(nf1, MF4x4(0.055903055, 0.08408526, 0.054170065, -0.2976025, 0.18558906, 0.029338092, -0.09893593, 0.059603147, -0.19218643, -0.008077081, 0.09550512, 0.051217057, -0.0276843, 0.33184877, -0.018644275, -0.11763111), target);
	target = MulAdd(ng1, MF4x4(0.23338239, 0.011580942, -0.0787839, 0.09754503, 0.009759483, -0.075707465, -0.10206689, 0.08720839, -0.3039172, -0.2001228, 0.30864987, -0.16379629, -0.03914539, -0.06503792, -0.03883409, -0.065077074), target);
	target = MulAdd(nh1, MF4x4(-0.1440983, 0.2827839, -0.07015957, 0.11515792, -0.1266345, -0.06969393, -0.009006173, 0.12875685, 0.031837627, 0.09990079, -0.1656627, 0.13870959, -0.08637978, 0.024281958, 0.12342855, -0.08816514), target);
	target = MulAdd(ni1, MF4x4(-0.015464915, -0.19240353, -0.01967364, -0.11796279, -0.06462456, 0.154628, 0.076811045, 0.098927125, -0.20375597, 0.023598116, -0.10710138, 0.08929812, 0.07584669, -0.11928781, 0.049687184, -0.06122156), target);
	target = MulAdd(na2, MF4x4(0.16479358, 0.19148158, 0.098467164, 0.0618447, 0.0751567, 0.010100359, 0.05155746, -0.0778876, 0.0011591897, -0.056076154, -0.041074045, 0.024008576, -0.017050695, -0.18685716, -0.08527556, 0.0037657958), target);
	target = MulAdd(nb2, MF4x4(0.16866666, -0.29083413, -0.18637179, 0.0018769886, -0.2018132, 0.46180528, 0.13246574, -0.23898588, -0.12212059, 0.3341523, 0.1091505, 0.08251535, 0.19041067, -0.16169062, 0.07583192, 0.050573617), target);
	target = MulAdd(nc2, MF4x4(0.0129842255, -0.008741855, -0.053530104, -0.03131398, -0.0020409364, -0.07680617, 0.33556506, -0.011717628, -0.13952619, -0.05453907, 0.10336836, -0.027125375, 0.1751553, -0.030947112, -0.025735123, 0.041072566), target);
	target = MulAdd(nd2, MF4x4(-0.036542114, 0.10128076, -0.1880457, -0.17261198, 0.1431477, -0.18661828, 0.32769415, 0.0663247, 0.03365178, 0.19796737, -0.09132497, -0.21413301, 0.043885235, 0.20412171, 0.14644071, -0.06985309), target);
	target = MulAdd(ne2, MF4x4(-0.2735308, 0.19792703, -0.21177524, 0.21988408, 0.32919964, 0.11183913, 0.2913821, 0.06404769, -0.004921694, 0.22249468, -0.010577357, -0.09632516, -0.15458032, -0.2982006, -0.041645106, 0.087833084), target);
	target = MulAdd(nf2, MF4x4(-0.07113276, 0.07723143, -0.058266032, 0.08239994, -0.18380593, -0.09771933, 0.12499344, 0.031730324, 0.042094275, -0.010583603, 0.009981995, 0.107384935, -0.20355527, 0.017341057, 0.018268948, -0.15857501), target);
	target = MulAdd(ng2, MF4x4(0.0013823194, -0.044928502, 0.025921093, 0.0012451003, -0.30528855, 0.3374342, 0.34150144, -0.09229386, -0.08328619, -0.10615052, 0.16300991, -0.19953482, -0.10911166, -0.036731765, 0.098331414, -0.06403792), target);
	target = MulAdd(nh2, MF4x4(-0.023653124, 0.04610296, -0.03044758, -0.025650993, -0.32529983, 0.062136825, 0.24734603, -0.019307928, 0.03787457, 0.34381005, 0.113464035, -0.02037722, 0.32398093, 0.05488551, 0.055344287, 0.017325766), target);
	target = MulAdd(ni2, MF4x4(0.0385026, 0.079174675, 0.059799727, -0.00725753, -0.0573653, -0.0420986, 0.16784842, 0.14938053, -0.009344561, -0.0778813, -0.017263457, -0.01132742, 0.077959225, -0.14751856, -0.20435876, -0.010041575), target);
	target = MulAdd(na3, MF4x4(-0.05931535, -0.08731735, 0.11970444, -0.09924397, 0.033911336, -0.0016364546, 0.0087679215, -0.076540634, 0.0077172252, 0.14911291, 0.11776904, -0.017065775, -0.059564207, 0.017132213, 0.06148217, -0.07582431), target);
	target = MulAdd(nb3, MF4x4(0.071270525, -0.24058339, -0.20233437, 0.001615171, 0.021383315, 0.09934347, -0.0011403296, -0.04854113, 0.12778723, 0.061408937, -0.071042776, 0.26612863, -0.10339047, -0.08749296, -0.04532682, -0.0615132), target);
	target = MulAdd(nc3, MF4x4(0.06391922, -0.016149543, -0.002464466, -0.00664347, -0.06338617, 0.04004229, 0.034720086, 0.054125533, 0.121965334, 0.2502773, -0.12270718, 0.011068944, -0.00047330794, 0.06449109, 0.17593135, 0.0040256707), target);
	target = MulAdd(nd3, MF4x4(0.03477346, -0.31120908, 0.28306037, 0.22833072, -0.017806482, -0.056919, 0.055360638, 0.020397838, -0.060393255, 0.02178207, -0.20644443, 0.088335134, 0.030195525, -0.19925289, -0.016580708, -0.007094466), target);
	target = MulAdd(ne3, MF4x4(0.028902626, 0.12521821, 0.29966938, 0.20124513, 0.11820484, 0.23270105, -0.27059364, 0.0034185604, -0.0808993, -0.21187486, 0.14866447, 0.2362522, 0.2997781, 0.25243583, -0.010675219, -0.21490887), target);
	target = MulAdd(nf3, MF4x4(0.017603166, -0.1354112, 0.07734325, -0.10108977, 0.095413536, -0.27478248, 0.15811092, 0.08514367, -0.0648521, -0.23040737, -0.015424236, -0.102597706, 0.018168293, 0.049426224, 0.24017967, -0.0076911957), target);
	target = MulAdd(ng3, MF4x4(0.040054902, 0.10045824, -0.00088240346, 0.10863258, 0.004609783, 0.08008685, 0.0008943593, 0.04380173, 0.04113014, 0.17802699, 0.19284193, -0.09775915, -0.082003035, -0.04828276, -0.2212439, -0.08810767), target);
	target = MulAdd(nh3, MF4x4(0.110144354, -0.17653003, -0.18453437, -0.13516864, -0.12592733, -0.031436298, 0.10997709, -0.26131755, 0.13670647, 0.33671942, 0.06641791, 0.022009498, -0.0843429, 0.2000657, 0.1431977, 0.23156545), target);
	target = MulAdd(ni3, MF4x4(0.18203191, -0.30493334, 0.0012451819, 0.040420715, -0.09400875, -0.058327, -0.092143685, 0.08411573, 0.06618551, 0.066164635, -0.08439327, 0.07001009, 0.22673227, -0.1294288, -0.46530777, 0.2499909), target);
	conv2d_5_tf2[gxy] = target;
}

//!PASS 7
//!DESC Conv-4x3x3x24
//!IN conv2d_5_tf, conv2d_5_tf1, conv2d_5_tf2
//!OUT conv2d_6_tf, conv2d_6_tf1, conv2d_6_tf2
//!BLOCK_SIZE 8
//!NUM_THREADS 64

void Pass7(uint2 blockStart, uint3 threadId) {
	uint2 gxy = TileSwizzle8x8(threadId.x) + blockStart;
	uint2 inputSize = GetInputSize();
	if (gxy.x >= inputSize.x || gxy.y >= inputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = (gxy + 0.5f) * inputPt;

	// [ a, d, g ]
	// [ b, e, h ]
	// [ c, f, i ]
	MF4 a1 = conv2d_5_tf.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b1 = conv2d_5_tf.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c1 = conv2d_5_tf.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d1 = conv2d_5_tf.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e1 = conv2d_5_tf.SampleLevel(sam, pos, 0);
	MF4 f1 = conv2d_5_tf.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g1 = conv2d_5_tf.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h1 = conv2d_5_tf.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i1 = conv2d_5_tf.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na1 = max(-a1, 0);
	MF4 nb1 = max(-b1, 0);
	MF4 nc1 = max(-c1, 0);
	MF4 nd1 = max(-d1, 0);
	MF4 ne1 = max(-e1, 0);
	MF4 nf1 = max(-f1, 0);
	MF4 ng1 = max(-g1, 0);
	MF4 nh1 = max(-h1, 0);
	MF4 ni1 = max(-i1, 0);

	a1 = max(a1, 0);
	b1 = max(b1, 0);
	c1 = max(c1, 0);
	d1 = max(d1, 0);
	e1 = max(e1, 0);
	f1 = max(f1, 0);
	g1 = max(g1, 0);
	h1 = max(h1, 0);
	i1 = max(i1, 0);

	MF4 a2 = conv2d_5_tf1.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b2 = conv2d_5_tf1.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c2 = conv2d_5_tf1.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d2 = conv2d_5_tf1.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e2 = conv2d_5_tf1.SampleLevel(sam, pos, 0);
	MF4 f2 = conv2d_5_tf1.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g2 = conv2d_5_tf1.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h2 = conv2d_5_tf1.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i2 = conv2d_5_tf1.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na2 = max(-a2, 0);
	MF4 nb2 = max(-b2, 0);
	MF4 nc2 = max(-c2, 0);
	MF4 nd2 = max(-d2, 0);
	MF4 ne2 = max(-e2, 0);
	MF4 nf2 = max(-f2, 0);
	MF4 ng2 = max(-g2, 0);
	MF4 nh2 = max(-h2, 0);
	MF4 ni2 = max(-i2, 0);

	a2 = max(a2, 0);
	b2 = max(b2, 0);
	c2 = max(c2, 0);
	d2 = max(d2, 0);
	e2 = max(e2, 0);
	f2 = max(f2, 0);
	g2 = max(g2, 0);
	h2 = max(h2, 0);
	i2 = max(i2, 0);

	MF4 a3 = conv2d_5_tf2.SampleLevel(sam, pos + float2(-inputPt.x, -inputPt.y), 0);
	MF4 b3 = conv2d_5_tf2.SampleLevel(sam, pos + float2(-inputPt.x, 0), 0);
	MF4 c3 = conv2d_5_tf2.SampleLevel(sam, pos + float2(-inputPt.x, inputPt.y), 0);
	MF4 d3 = conv2d_5_tf2.SampleLevel(sam, pos + float2(0, -inputPt.y), 0);
	MF4 e3 = conv2d_5_tf2.SampleLevel(sam, pos, 0);
	MF4 f3 = conv2d_5_tf2.SampleLevel(sam, pos + float2(0, inputPt.y), 0);
	MF4 g3 = conv2d_5_tf2.SampleLevel(sam, pos + float2(inputPt.x, -inputPt.y), 0);
	MF4 h3 = conv2d_5_tf2.SampleLevel(sam, pos + float2(inputPt.x, 0), 0);
	MF4 i3 = conv2d_5_tf2.SampleLevel(sam, pos + float2(inputPt.x, inputPt.y), 0);

	MF4 na3 = max(-a3, 0);
	MF4 nb3 = max(-b3, 0);
	MF4 nc3 = max(-c3, 0);
	MF4 nd3 = max(-d3, 0);
	MF4 ne3 = max(-e3, 0);
	MF4 nf3 = max(-f3, 0);
	MF4 ng3 = max(-g3, 0);
	MF4 nh3 = max(-h3, 0);
	MF4 ni3 = max(-i3, 0);

	a3 = max(a3, 0);
	b3 = max(b3, 0);
	c3 = max(c3, 0);
	d3 = max(d3, 0);
	e3 = max(e3, 0);
	f3 = max(f3, 0);
	g3 = max(g3, 0);
	h3 = max(h3, 0);
	i3 = max(i3, 0);

	MF4 target = MF4(-0.06036478, 0.0356493, -0.059101366, 0.0024990432);
	target = MulAdd(a1, MF4x4(0.19466089, -0.10927993, 0.09179887, 0.15121523, -0.037340622, 0.06053471, 0.038131684, -0.008113673, -0.18904036, -0.09559259, -0.17113, 0.03717301, -0.043611653, -0.16189677, 6.720818e-05, 0.087884724), target);
	target = MulAdd(b1, MF4x4(-0.2376871, 0.07507205, 0.08144118, 0.266135, -0.0016601613, -0.075726755, 0.1405083, 0.05794102, 0.082300104, 0.42289656, -0.21715559, 0.066831395, 0.31216174, -0.14317952, 0.1725695, -0.17751537), target);
	target = MulAdd(c1, MF4x4(0.037299458, -0.11762432, -0.011837041, 0.1465751, 0.039899126, -0.049513657, -0.0037649425, -0.17213967, 0.13214532, -0.035151232, 0.098905504, 0.25259635, -0.034471225, 0.22866723, 0.056768697, 0.04517098), target);
	target = MulAdd(d1, MF4x4(-0.032002304, 0.0033130902, -0.11396168, -0.24947542, -0.01432499, 0.059397, 0.011829774, -0.039037425, 0.2855777, 0.38178965, 0.061862387, -0.3191097, 0.0013762182, 0.10873268, 0.13221635, 0.11438935), target);
	target = MulAdd(e1, MF4x4(-0.444183, 0.07429998, -0.24415193, 0.20763457, 0.005403234, -0.09182405, -0.33746308, 0.23260857, 0.80383587, 0.42822048, 0.15259221, 0.08751457, -0.18719546, 0.3931829, -0.3559663, 0.1288945), target);
	target = MulAdd(f1, MF4x4(0.038999066, 0.20546576, 0.17918825, 0.06601807, -0.09185307, 0.08308848, 0.3533222, 0.20337574, 0.2909968, -0.25924757, -0.18089646, -0.0856463, 0.1436575, -0.20405407, 0.08083093, -0.13420194), target);
	target = MulAdd(g1, MF4x4(-0.08427221, 0.029255591, 0.016859733, -0.011943696, 0.13574867, 0.040940672, 0.013232511, 0.026956066, 0.071955554, -0.06337127, -0.15357494, -0.026208352, -0.04108415, -0.06945617, 0.018760698, -0.023912333), target);
	target = MulAdd(h1, MF4x4(0.07994412, -0.00968056, 0.08030741, 0.16342168, 0.04104326, 0.073546335, 0.10782922, -0.27047744, -0.027339334, 0.012742752, 0.07632864, 0.3130092, -0.026107019, 0.14022668, 0.0019065946, 0.050307225), target);
	target = MulAdd(i1, MF4x4(-0.064752, -0.114935696, -0.101320885, -0.13594441, -0.0035874723, -0.21959865, -0.20514846, 0.06435263, -0.07910371, 0.22121632, -0.027385276, 0.11370377, -0.087538995, 0.02242176, 0.05138211, -0.055027794), target);
	target = MulAdd(a2, MF4x4(-0.07418348, -0.013085453, -0.23711763, 0.13872914, 0.10102951, 0.034057204, 0.09149018, 0.060473535, -0.00067378976, 0.05151344, -0.038349435, 0.05791031, 0.0049775504, -0.0063300184, 0.11502679, 0.11189162), target);
	target = MulAdd(b2, MF4x4(-0.17575283, -0.026091507, -0.012820658, 0.02245792, 0.15239143, -0.12657113, 0.062418584, -0.12840585, 0.07613884, 0.12033655, -0.05695382, 0.03669604, -0.17113449, -0.15366605, 0.17787598, 0.06278569), target);
	target = MulAdd(c2, MF4x4(0.015337286, -0.050423414, -0.08879978, 0.04760555, 0.12424041, -0.03367427, -0.0459138, 0.22050953, 0.12919267, 0.26828563, -0.1061058, -0.10099044, -0.04658635, -0.016307753, 0.14689955, -0.14597629), target);
	target = MulAdd(d2, MF4x4(-0.01102339, 0.014672111, 0.13931917, -0.1345445, 0.031524513, -0.32458848, -0.056687858, 0.22222418, -0.056350503, 0.035747256, -0.10304222, -0.21285744, 0.25462946, 0.09982579, 0.09516444, -0.016217945), target);
	target = MulAdd(e2, MF4x4(-0.076081604, -0.23594818, 0.15077876, -0.21414931, 0.2282169, 0.59579784, -0.12744917, 0.35256362, -0.074862994, 0.16357085, 0.19566183, -0.05933472, 0.6046422, 0.17888334, -0.015507464, -0.08096589), target);
	target = MulAdd(f2, MF4x4(-0.07068054, -0.0079010865, 0.036364477, 0.14502864, -0.021085994, -0.07906985, 0.09793876, 0.07399657, 0.12093952, -0.18547052, -0.110405356, -0.10768624, 0.016976682, -0.030136436, 0.3050347, 0.25278243), target);
	target = MulAdd(g2, MF4x4(-0.010475713, -0.10232612, -0.108958706, -0.011528059, 0.11610843, -0.0014788646, 0.17262968, 0.031911, 0.08343287, -0.0021717772, -0.021841958, 0.0973525, -0.046819497, -0.05605018, 0.1291599, 0.09826176), target);
	target = MulAdd(h2, MF4x4(0.04663343, 0.04400759, -0.035258498, 0.00895981, -0.23123324, -0.055122357, 0.089720264, 0.09339213, 0.16230758, 0.01740431, 0.0010832906, 0.019101601, -0.28437567, -0.017914291, 0.06484634, -0.00661367), target);
	target = MulAdd(i2, MF4x4(0.08788325, 0.017547041, -0.12180048, -0.01287628, 0.014391497, 0.0098254625, -0.1297012, -0.08183671, 0.018999657, 0.09840126, 0.047082353, 0.24155243, 0.12269502, -0.08142539, 0.10323659, -0.033276822), target);
	target = MulAdd(a3, MF4x4(-0.14859885, -0.03888739, -0.15384491, -0.17175777, 0.04767615, 0.042373076, 0.013757687, -0.13237329, -0.04965534, 0.020163631, -0.11415436, -0.056286413, -0.16989873, 0.024179472, 0.037168648, -0.12176204), target);
	target = MulAdd(b3, MF4x4(-0.05709518, -0.09206574, 0.04486005, -0.033150986, -0.017180622, 0.06052779, 0.16889273, -0.15518297, -0.24440864, 0.12658344, -0.139649, 0.037917744, -0.14727007, 0.038368758, -0.05098604, 0.09547945), target);
	target = MulAdd(c3, MF4x4(-0.08096385, -0.010406064, -0.057036124, 0.13355646, -0.00612782, -0.0033356852, -0.06850302, 0.029461807, -0.17608377, -0.10943067, 0.030028753, 0.08070524, 0.022253908, -0.005548474, -0.045125946, 0.02093025), target);
	target = MulAdd(d3, MF4x4(0.10988742, 0.27972367, -0.04232453, -0.43071312, -0.08219865, -0.12530999, -0.0016445538, 0.05443371, -0.014415479, -0.08840511, 0.066499956, -0.01336885, -0.15110426, 0.062335182, 0.052890446, 0.1044874), target);
	target = MulAdd(e3, MF4x4(0.33606815, -0.17963116, 0.34632006, 0.3946198, -0.10691484, -0.1038113, -0.019460114, 0.06895735, 0.59190637, -0.10203456, 0.008359275, 0.06353352, -0.32418385, -0.12430192, 0.24380416, -0.23094086), target);
	target = MulAdd(f3, MF4x4(-0.020480068, -0.01640171, -0.09763355, -0.02580198, -0.041970506, -0.042252183, -0.09769974, -0.045537427, 0.14187063, 0.06059797, 0.033730645, 0.020378796, -0.033819746, 0.09553117, -0.05334098, -0.09202247), target);
	target = MulAdd(g3, MF4x4(0.0246489, -0.086129375, 0.05148198, 0.16396165, -0.042565763, 0.047137372, 0.08882997, -0.0076635084, 0.020555299, -0.0018504986, -0.093162216, -0.002001032, -0.09805734, -0.09600409, -0.0027830484, -0.12433019), target);
	target = MulAdd(h3, MF4x4(-0.016701702, 0.19712164, -0.13269165, -0.10036325, -0.008542912, -0.006157372, -0.09184331, -0.097038, -0.11304494, 0.27655166, 0.060221743, 0.096516214, -0.043898825, 0.010273238, -0.07468758, -0.21701947), target);
	target = MulAdd(i3, MF4x4(-0.11392737, -0.15646808, -0.16859137, -0.1773589, 0.062430523, 0.0633658, 0.1578782, -0.02552433, -0.09023146, -0.03037661, -0.050063506, -0.018076949, 0.021033524, -0.06344241, 0.08951326, 0.06231262), target);
	target = MulAdd(na1, MF4x4(-0.094271734, 0.0114940265, -0.04097972, -0.06457978, 0.20086573, 0.035297886, -0.03792428, -0.15497704, 0.12542814, 0.006359964, 0.049963623, 0.06472255, -0.14664528, 0.10833471, 0.03922276, -0.1675095), target);
	target = MulAdd(nb1, MF4x4(-0.18032873, 0.011285189, -0.061522707, 0.008256017, 0.13692558, 0.15130165, 0.13422745, -0.22135267, 0.19946684, 0.24516532, 0.10290738, -0.2294601, -0.052056555, -0.13473587, 0.23919931, -0.042362213), target);
	target = MulAdd(nc1, MF4x4(-0.025423648, 0.026715705, 0.0060757576, -0.06410553, -0.04461674, -0.3029843, 0.092734374, 0.04524039, 0.033247333, -0.02790855, 0.056930248, -0.15256552, 0.02607904, 0.09423549, -0.18153918, 0.13832009), target);
	target = MulAdd(nd1, MF4x4(-0.049555343, 0.017360087, 0.057959676, 0.07956772, -0.075296454, -0.1470046, 0.021892669, 0.10043102, -0.024857812, -0.10644472, 0.09769508, 0.1249294, 0.007206734, -0.028977863, 0.10593961, 0.26716354), target);
	target = MulAdd(ne1, MF4x4(-0.029734008, -0.3227415, 0.23771009, -0.19591968, -0.51607347, -0.25314853, -0.056235682, -0.07140848, 0.111049965, -0.06368735, -0.2866811, 0.013670416, 0.06847308, 0.30838242, -0.12282098, 0.0034061049), target);
	target = MulAdd(nf1, MF4x4(-0.12762555, -0.04628489, -0.12804574, -0.040225446, 0.20549247, 0.40988892, 0.046733934, 0.0011979616, 0.060588628, 0.15362865, -0.022557247, -0.09853034, 0.06939786, -0.08854213, 0.0033144224, -0.20143713), target);
	target = MulAdd(ng1, MF4x4(0.05962723, 0.05745424, -0.094456606, -0.20003895, -0.070974536, 0.026771205, 0.02564145, -0.02845018, -0.035351314, -0.0117768, 0.113437235, 0.08942642, 0.058360267, 0.024181651, 0.024502836, -0.073039465), target);
	target = MulAdd(nh1, MF4x4(0.12510774, 0.045879837, -0.010349814, -0.019377183, -0.008772124, -0.16534139, -0.13212264, -0.21540141, 0.036527056, -0.10918482, 0.0049819928, -0.019343467, 0.13203917, -0.08569981, -0.061810624, -0.05108862), target);
	target = MulAdd(ni1, MF4x4(0.04002694, -0.055285487, 0.053127788, 0.10067933, -0.027899982, -0.0050923983, -0.039490424, -0.121817835, -0.09340064, -0.0429694, 0.18118261, 0.049474712, 0.038677018, 0.14249925, 0.09504422, 0.122608855), target);
	target = MulAdd(na2, MF4x4(-0.14135127, 0.09016643, 0.025633719, 0.000614705, 0.070762664, -0.030985976, 0.042064067, 0.057410795, 0.0660935, -0.05050625, -0.10755477, 0.039620418, -0.10203836, -0.07814099, -0.014446629, 0.18048128), target);
	target = MulAdd(nb2, MF4x4(0.43030277, 0.18589582, 0.256173, -0.2844, 0.13945708, 0.14931135, 0.22740678, -0.3956166, -0.0724625, -0.08001986, 0.081810005, 0.025289046, 0.06736611, -0.07330548, -0.29192784, 0.21637453), target);
	target = MulAdd(nc2, MF4x4(-0.08737932, -0.1372706, 0.03159939, -0.21679185, -0.09027622, -0.041193455, 0.11512235, -0.24278319, -0.08837681, -0.018710367, 0.041880753, -0.014190375, 0.033047616, 0.06708754, -0.03391409, -0.07711031), target);
	target = MulAdd(nd2, MF4x4(0.12588775, 0.4317977, 0.077132806, -0.42811748, 0.031082593, 0.23937033, 0.08018833, -0.22718322, 0.060632102, 0.08067565, -0.042863563, -0.091845684, -0.04759955, 0.009588551, -0.17780636, -0.22400473), target);
	target = MulAdd(ne2, MF4x4(-0.06745702, -0.0795159, -0.4350959, 0.35561585, -0.13962667, -0.5940183, -0.54777396, -0.68051004, -0.16509765, -0.34696493, 0.038297307, 0.13719557, -0.040833995, 0.031406473, -0.5174053, -0.08789825), target);
	target = MulAdd(nf2, MF4x4(-0.12779349, 0.2936602, 0.13704172, 0.13110651, 0.10102365, 0.24163464, -0.069620885, -0.16209678, -0.07489114, -0.019360917, -0.070400774, -0.023681173, -0.1102226, -0.09275758, -0.31730032, 0.03576276), target);
	target = MulAdd(ng2, MF4x4(-0.0986982, -0.14386573, 0.06295539, 0.2667051, 0.029192172, 0.028653674, -0.13940518, -0.022916485, -0.091007926, -0.062984526, 0.026765045, 0.058111303, 0.028423572, -0.016102828, -0.09699887, 0.118749924), target);
	target = MulAdd(nh2, MF4x4(-0.40428874, 0.45658726, 0.20199502, 0.020573912, -0.08588765, 0.15927678, 0.29527012, 0.40756142, -0.15820621, 0.009576386, -0.009194596, -0.08242508, 0.0012625816, -0.03771835, -0.22807057, 0.035798464), target);
	target = MulAdd(ni2, MF4x4(0.13749583, -0.04876742, -0.0065646684, -0.28335539, 0.117720984, 0.087982565, 0.16954121, 0.2363482, -0.17796999, -0.106926255, 0.0060180747, -0.11523375, 0.038097225, 0.09647209, -0.06873753, -0.056800433), target);
	target = MulAdd(na3, MF4x4(0.1768557, 0.13145363, 0.12556404, 0.03251624, -0.02287178, 0.12941027, -0.2394559, -0.37159434, 0.14269918, 0.08204633, 0.20483865, 0.05722901, 0.06699899, -0.04848409, 0.12399497, 0.124153495), target);
	target = MulAdd(nb3, MF4x4(0.14586149, 0.09655288, 0.03812125, 0.052801564, 0.065902874, -0.043486778, 0.0657983, 0.14589024, 0.011490019, -0.0021060712, -0.18636304, 0.24038431, 0.2249946, 0.14451164, -0.13322833, 0.109084174), target);
	target = MulAdd(nc3, MF4x4(-0.03467399, 0.076331206, -0.047301926, -0.10028459, -0.069450885, 0.103480145, -0.08315761, -0.00030933326, 0.04021727, 0.06693238, -0.02885415, 0.12737286, -0.042063054, -0.075277805, 0.21915779, 0.14529525), target);
	target = MulAdd(nd3, MF4x4(-0.21753858, 0.13885236, -0.03733484, 0.070192896, -0.42111662, 0.2257056, -0.0020320695, -0.4404435, -0.011731456, -0.031235369, -0.17156643, -0.00023724366, 0.16697505, 0.19261077, 0.054627284, -0.2635247), target);
	target = MulAdd(ne3, MF4x4(0.4114966, -0.21771282, -0.30367702, -0.24675573, -0.41803458, 0.31936127, 0.13296337, 0.2682109, -0.035749484, 0.22223838, 0.012987173, -0.20490278, 0.013631246, -0.34068218, -0.60729563, -0.13018902), target);
	target = MulAdd(nf3, MF4x4(-0.011740597, 0.07837384, 0.12748203, -0.013336406, -0.07607798, -0.39041027, 0.1939761, -0.08242594, -0.008299102, -0.23057082, 0.13972911, -0.21057422, 0.18126678, 0.004605364, 0.27230838, 0.04088039), target);
	target = MulAdd(ng3, MF4x4(-0.0761628, 0.08201472, 0.00067113456, -0.000108762404, 0.119982824, 0.0067928904, -0.048988946, -0.007609898, 0.049381327, 0.010086041, 0.025384359, 0.002726633, -0.009928298, 0.05588474, 0.050830763, 0.17467195), target);
	target = MulAdd(nh3, MF4x4(0.074037455, -0.16637659, -0.017491426, 0.013344787, 0.054212473, -0.29519126, -0.2467157, -0.17357266, -0.13876535, -0.04991683, 0.1392161, 0.05660303, 0.03868982, 0.10992501, 0.13167763, 0.060129613), target);
	target = MulAdd(ni3, MF4x4(0.027297564, 0.069763646, 0.15132809, 0.11143169, -0.08621777, 0.23928702, 0.00017447853, 0.115308166, -0.061112467, 0.044474706, -0.02718813, 0.19822854, -0.057888303, 0.06540743, -0.051538624, -0.002416074), target);
	conv2d_6_tf[gxy] = target;
	
	target = MF4(0.07303222, -0.017307714, -0.017054217, -0.004928735);
	target = MulAdd(a1, MF4x4(0.0023940788, -0.2570281, 0.021624887, -0.14413927, -0.042929508, 0.024798246, 0.06039514, -0.0385923, 0.18157732, -0.18974024, 0.3197193, -0.086097986, -0.23871095, -0.085877284, -0.15280978, 0.054582383), target);
	target = MulAdd(b1, MF4x4(-0.2892671, -0.35989672, 0.14361507, 0.10109185, -0.008244152, -0.07610182, 0.016237438, 0.109711155, -0.03325961, 0.056557924, 0.093826056, 0.16487189, 0.12098654, 0.26959404, -0.32664284, -0.33652756), target);
	target = MulAdd(c1, MF4x4(0.20426908, 0.00921726, -0.131825, -0.30112436, -0.29350808, -0.0059835073, -0.20881179, -0.15929249, 0.14798939, -0.039377835, 0.0022686112, -0.31745487, 0.1383128, 0.095711716, 0.24649502, 0.3734734), target);
	target = MulAdd(d1, MF4x4(0.08007145, 0.059220374, -0.11955456, 0.02726716, -0.012340195, -3.9396626e-05, 0.23562932, 0.02603672, 0.0024148317, 0.48585725, -0.25960997, 0.12831855, 0.034503214, 0.26429248, 0.19966535, 0.34653723), target);
	target = MulAdd(e1, MF4x4(0.16401817, 0.05824359, 0.23210622, -0.4564646, 0.09790885, 0.0017682983, 0.12023501, -0.34214047, -0.3808189, -0.59095186, 0.3224012, 0.054841924, -0.14028488, -0.35759392, -0.012464827, -0.42101544), target);
	target = MulAdd(f1, MF4x4(0.18710142, -0.022806095, -0.03905798, 0.050422203, 0.21642984, -0.071577035, 0.165218, 0.10126085, 0.18105839, -0.09810516, -0.43905553, 0.5793889, -0.16706131, 0.13636151, 0.029069345, 0.28394657), target);
	target = MulAdd(g1, MF4x4(0.03242417, 0.03540981, 0.06596982, -0.11404851, -0.043041103, 0.118582286, -0.16384825, -0.021553654, -0.12775607, -0.055402167, -0.016003367, -0.06356131, -0.063166484, -0.09225374, 0.21487807, 0.18778628), target);
	target = MulAdd(h1, MF4x4(-0.29311153, -0.09822076, 0.1706967, -0.30188912, -0.11062667, -0.08119463, -0.13738254, -0.24389322, 0.2796491, 0.21054858, -0.08765812, 0.3177179, 0.10164016, 0.14627174, 0.15129958, -0.13566513), target);
	target = MulAdd(i1, MF4x4(-0.12295195, -0.12036253, -0.040527046, 0.10602722, -0.19854495, -0.05223541, -0.032363445, 0.122390084, 0.27342895, 0.09667149, 0.0423871, -0.17246284, -0.031107228, -0.005470437, 0.051434256, 0.07954733), target);
	target = MulAdd(a2, MF4x4(0.17945234, 0.051398605, 0.3032336, -0.36277965, -0.015693031, 0.0847029, -0.1128904, 0.04994005, 0.08276063, 0.07031328, 0.06770377, -0.1687264, -0.17490897, -0.09989766, -0.07715023, -0.010953815), target);
	target = MulAdd(b2, MF4x4(0.014114998, -0.06209966, 0.057450738, 0.21318321, -0.093205266, -0.15646473, -0.22241333, -0.08228401, -0.4973326, -0.12547962, -0.07989991, -0.06822309, -0.106437586, -0.19071254, 0.14178663, 0.10448926), target);
	target = MulAdd(c2, MF4x4(-0.005078645, -0.028730195, -0.04966596, -0.024377774, 0.0039325077, 0.10179092, -0.105298065, -0.1688019, -0.23554938, 0.058782354, 0.19999442, -0.027954772, -0.10502022, 0.016704066, -0.033541992, 0.1382609), target);
	target = MulAdd(d2, MF4x4(-0.30713797, -0.0631538, -0.17524256, 0.12141287, 0.18175098, -0.13446523, -0.15921354, -0.0050512427, -0.00880753, -0.24464725, 0.10351903, -0.122694805, 0.2637432, 0.10111337, -0.05550657, -0.024864933), target);
	target = MulAdd(e2, MF4x4(-0.4845733, -0.13332175, 0.007910284, 0.5203373, 0.72870463, 0.15518989, -0.12580696, 0.04916096, 0.6244038, 0.3593719, 0.16328047, -0.14490198, 0.07803236, 0.26987454, -0.02258877, -0.21130653), target);
	target = MulAdd(f2, MF4x4(0.20343359, -0.048075967, 0.17489576, -0.18971623, -0.14069648, -0.029665243, -0.24902415, 0.07167198, -0.6412736, -0.041664686, 0.58569616, 0.02399211, 0.12831652, -0.058278285, -0.07922422, -0.108734205), target);
	target = MulAdd(g2, MF4x4(-0.004269588, -0.11554386, -0.0022618338, 0.12235181, 0.07379002, 0.0548718, -0.040107626, -0.040337294, -0.060385335, 0.119979575, -0.27628905, -0.023228448, -0.04064614, 0.0047100694, 0.048138026, 0.0057798214), target);
	target = MulAdd(h2, MF4x4(0.15257028, -0.005850462, -0.1434922, 0.07164339, -0.062233947, -0.0156128965, -0.019673312, -0.0002651659, -0.19478518, 0.11921539, -0.2361836, -0.09110679, 0.02719977, 0.0033712897, 0.17245373, 0.2532936), target);
	target = MulAdd(i2, MF4x4(0.0030309292, 0.10147757, -0.31425565, -0.10256, -0.05862195, -0.08736711, 0.084856585, 0.016700774, 0.06286386, -0.07443701, 0.08754631, -0.18171762, 0.06868201, -0.09278428, -0.053383432, 0.03826822), target);
	target = MulAdd(a3, MF4x4(-0.10183099, 0.06891697, 0.056318853, 0.13647571, -0.03353045, 0.016239524, 0.005603497, 0.035521563, 0.18905343, 0.041940115, 0.10048305, -0.04986043, 0.04298795, 0.050817303, 0.17744416, -0.010589751), target);
	target = MulAdd(b3, MF4x4(-0.31862193, -0.13207828, -0.1375938, -0.23549932, -0.06217893, 0.0019514537, -0.005417935, 0.13736913, -0.10263318, -0.18941346, 0.15843, 0.27492487, 0.058868844, -0.1804736, 0.24544486, 0.10051148), target);
	target = MulAdd(c3, MF4x4(0.15876879, 0.07879244, 0.0513651, 0.07673734, 0.015635801, 0.048305415, 0.019661602, -0.0479435, 0.027511599, -0.065881185, 0.21485852, -0.010372607, -0.19896457, -0.05555933, -0.054646876, -0.09143982), target);
	target = MulAdd(d3, MF4x4(0.21596268, 0.21091351, 0.234315, -0.0006641688, 0.03455969, -0.12185912, -0.03052869, 0.15622592, -0.18506715, -0.24213594, -0.19364369, -0.07659142, 0.0379824, 0.0091246925, 0.1708395, 0.036304265), target);
	target = MulAdd(e3, MF4x4(-0.2730932, -0.23328209, 0.6977438, -0.2445981, 0.031650152, -0.004327604, -0.050584223, -0.07061773, -0.10755705, 0.30620542, -0.15688588, 0.16850896, -0.088513345, 0.2162286, -0.4329111, -0.52770174), target);
	target = MulAdd(f3, MF4x4(-0.068270594, 0.039348822, -0.08555022, 0.23533496, -0.062174525, 0.0193457, -0.13714077, 0.060169753, -0.06355557, -0.010862508, -0.17664193, -0.24809086, 0.032538615, 0.08074848, 0.20644335, 0.085532546), target);
	target = MulAdd(g3, MF4x4(-0.07677775, 0.0007320281, 0.0139939515, 0.19423772, 0.02928719, 0.05200053, 0.012181974, -0.005785729, 0.08011629, 0.03698694, 0.15808755, 0.04080324, -0.21732025, -0.10937562, -0.050028726, 0.088937156), target);
	target = MulAdd(h3, MF4x4(-0.06772194, 0.09471782, -0.0830642, -0.13875008, 0.003456362, 0.010889541, 0.08989434, 0.03261672, 0.19459227, 0.18803298, 0.16107602, 0.1490853, -0.22943772, 0.0005637327, 0.052380536, -0.06956663), target);
	target = MulAdd(i3, MF4x4(-0.15136889, -0.2523378, -0.037718855, 0.1728913, 0.067127876, -0.038833655, 0.14237632, -0.07256634, 0.0052903728, -0.11813482, -0.06309155, -0.015444354, 0.044696916, 0.0011587966, -0.008295438, 0.045684442), target);
	target = MulAdd(na1, MF4x4(0.029596262, 0.013380705, 0.19451803, -0.0217206, -0.03430266, 0.066089645, -0.22101538, 0.016455501, 0.122556984, -0.018319963, -0.06570934, -0.05489828, -0.13112561, 0.10740249, -0.07405227, 0.23262945), target);
	target = MulAdd(nb1, MF4x4(0.039601505, -0.0795478, 0.1524426, 0.22525507, -0.18371256, 0.009809418, -0.09180862, 0.03985826, -0.17215611, 0.104956195, -0.012817112, 0.12702619, -0.119846344, -0.1763627, -0.010298178, 0.059241127), target);
	target = MulAdd(nc1, MF4x4(-0.0823085, -0.07456769, 0.054212615, 0.009188054, 0.0017495407, -0.07561583, -0.17030309, 0.007888594, -0.11013637, -0.08417068, 0.061450012, -0.081912406, 0.11603573, 0.0490229, 0.119570516, -0.111465424), target);
	target = MulAdd(nd1, MF4x4(-0.21657833, -0.1643494, 0.19958968, -0.042039983, -0.0037797047, -0.13965121, -0.019386362, -0.024111586, 0.06518915, -0.15928997, -0.08175624, 0.050481785, 0.37915838, -0.09272705, 0.4887356, -0.13048859), target);
	target = MulAdd(ne1, MF4x4(-0.3364342, -0.08892259, 0.2356529, 0.22063124, 0.31071013, 0.101701945, 0.25302443, 0.25084528, 0.22127245, 0.23771746, 0.35111645, -0.14120491, 0.09563979, 0.2781042, -0.17586009, -0.09176989), target);
	target = MulAdd(nf1, MF4x4(-0.11986394, -0.093885854, 0.11733581, 0.05637956, 0.23623823, -0.007359601, 0.28527632, -0.16477823, 0.0035151376, 0.042055942, -0.0062996866, 0.021584665, -0.28436866, 0.1456055, -0.25843173, -0.07554441), target);
	target = MulAdd(ng1, MF4x4(-0.03815117, 0.07561848, -0.07897604, -0.012987363, 0.02319023, 0.04150643, -0.019950474, 0.041954774, -0.07800387, -0.011202695, -0.11299979, -0.00864291, -0.114811376, 0.124991566, -0.46519995, 0.060762767), target);
	target = MulAdd(nh1, MF4x4(-0.048102316, -0.04349749, -0.045696992, -0.06968446, -0.10201568, -0.10664441, -0.1271327, 0.014041653, -0.06944334, -0.024820644, 0.06449197, -0.118919216, -0.100525826, -0.081692286, -0.0036934754, -0.0950572), target);
	target = MulAdd(ni1, MF4x4(0.028598474, 0.101999335, -0.10409241, -0.0008725121, -0.24365604, 0.09376613, -0.10155709, -0.019243455, -0.08370451, -0.08886542, 0.15643747, 0.094012596, 0.0989398, -0.003263144, 0.24052359, -0.05086219), target);
	target = MulAdd(na2, MF4x4(0.22825857, -0.041577056, 0.3575971, -0.019246848, 0.09680159, 0.05570423, -0.20628895, -0.02993351, 0.05210484, -0.049776137, 0.005964223, -0.22305849, 0.030647328, -0.088792734, 0.0043907063, 0.08531383), target);
	target = MulAdd(nb2, MF4x4(-0.30464846, -0.12842661, -0.3743522, 0.13156073, -0.32281575, 0.030088687, -0.09418602, 0.13464968, -0.0695602, 0.0936232, -0.038296524, 0.33601308, 0.17701761, 0.14289881, -0.047556065, -0.3338849), target);
	target = MulAdd(nc2, MF4x4(-0.005924107, 0.043742385, -0.064937405, 0.15786234, -0.09955057, -0.082465865, -0.03392436, 0.21772122, 0.15173042, 0.10373368, 0.051570628, 0.11137272, 0.15423453, 0.09124828, -0.014710869, 0.030298932), target);
	target = MulAdd(nd2, MF4x4(0.043112267, 0.5992106, -0.32294464, 0.31510955, -0.25169763, 0.04839851, 0.16124408, -0.14096124, -0.097060055, 0.06045283, -0.27082244, -0.12048959, 0.009364686, 0.11915612, 0.008150039, 0.08678112), target);
	target = MulAdd(ne2, MF4x4(0.47620735, 0.6078475, -0.018170241, -0.50504035, -0.30020222, -0.24147978, 0.33480522, 0.43817788, -0.15983123, -0.19762735, 0.1549511, 0.292026, -0.31289634, -0.15204595, 0.3059814, 0.30576986), target);
	target = MulAdd(nf2, MF4x4(0.13746189, -0.039151277, 0.62028766, -0.19905351, 0.13143681, 0.1407726, 0.18850237, -0.057907805, 0.086882025, 0.107989915, -0.0065579475, 0.31578153, -0.15049165, -0.20889415, -0.13337761, -0.035084542), target);
	target = MulAdd(ng2, MF4x4(-0.071805745, -0.18944815, 0.25147218, -0.03606807, 0.23967369, 0.02687493, 0.0513247, -0.18633473, 0.063457586, -0.08531119, 0.21456662, 0.07793248, -0.08192292, -0.11563025, -0.020568466, -0.15659434), target);
	target = MulAdd(nh2, MF4x4(0.17281517, 0.4232067, 0.32460606, -0.3712845, 0.41458213, 0.06034276, 0.2704778, 0.17323148, -0.06306892, -0.10192465, 0.17620242, -0.009122019, 0.1198333, 0.11001577, -0.3855991, 0.08933198), target);
	target = MulAdd(ni2, MF4x4(-0.28324863, -0.041409206, 0.03248429, 0.24548076, 0.26409158, 0.24419361, -0.012711284, -0.30516157, -0.20289323, -0.13157755, 0.028014898, 0.16276212, 0.007050667, 0.08335203, 0.102254696, -0.11343822), target);
	target = MulAdd(na3, MF4x4(0.043687776, -0.004411872, -0.098016165, -0.055542797, 0.22615008, 0.13183828, 0.7488022, -0.33078304, 0.11318944, -0.047168892, 0.38564375, -0.030084245, 0.09062325, -0.16808534, -0.07371455, 0.20058438), target);
	target = MulAdd(nb3, MF4x4(0.19956557, -0.08747039, -0.029969914, 0.13122557, 0.049196698, -0.13465631, -0.22565748, -0.08703051, 0.26813537, 0.00821654, 0.032616418, -0.18458223, 0.17407443, 0.28091452, -0.16240835, -0.27060813), target);
	target = MulAdd(nc3, MF4x4(0.04535802, 0.037094936, 0.11686145, -0.002455908, 0.16012727, 0.14261092, -0.08348427, 0.18832053, 0.029025842, 0.054300968, 0.018998424, 0.014601349, 0.07728862, -0.034569506, 0.09937842, -0.076810405), target);
	target = MulAdd(nd3, MF4x4(-0.42146468, -0.10226207, -0.03932444, -0.17184897, -0.21222934, 0.050341085, 0.19828026, -0.07519326, -0.016190661, 0.08705493, -0.14219207, -0.08652689, -0.095818594, 0.18254876, -0.29907924, 0.049119983), target);
	target = MulAdd(ne3, MF4x4(0.015439721, 0.24500765, -0.01930081, 0.24527666, -0.13847429, 0.5195186, 0.13352336, 0.12092768, -0.10859864, 0.043220174, -0.37466663, -0.0432489, -0.38647306, -0.33819455, 0.24641274, 0.6657115), target);
	target = MulAdd(nf3, MF4x4(0.15343782, -0.004420619, -0.047215153, -0.16960907, -0.0707756, -0.29501325, -0.09699802, -0.15991725, -0.19104993, -0.115666404, -0.3558544, -0.0149508845, -0.1138187, -0.07019453, -0.16961712, -0.1560539), target);
	target = MulAdd(ng3, MF4x4(-0.0016192662, 0.041725244, 0.003358041, -0.027749699, -0.001091161, 0.06779037, -0.15775087, -0.04927482, 0.016525732, -0.061703153, -0.011079543, -0.04828491, 0.19724323, 0.11623055, 0.11814769, -0.08236815), target);
	target = MulAdd(nh3, MF4x4(-0.009845684, -0.18635233, -0.09976992, 0.12431404, -0.34134167, -0.34342697, -0.026243573, 0.088327765, 0.056699544, 0.07774804, 0.062026564, 0.09743545, 0.14937103, 0.11164576, 0.11233316, -0.071940914), target);
	target = MulAdd(ni3, MF4x4(0.093613006, 0.08761063, 0.11849382, -0.06467931, 0.13939771, -0.05646352, -0.08747582, -0.3780521, 0.2270502, -0.042743817, 0.34419978, -0.11905452, 0.18841426, 0.044176128, 0.08761558, -0.0007557414), target);
	conv2d_6_tf1[gxy] = target;

	target = MF4(-0.003073506, -0.033630643, 0.028479056, -0.025402397);
	target = MulAdd(a1, MF4x4(0.07753503, 0.18257454, 0.16630161, 0.018181466, 0.032217313, -0.029755782, -0.09729085, 0.090185136, 0.036025215, -0.07385567, -0.11479112, -0.009775693, -0.09510068, 0.099653766, 0.12464123, 0.11700322), target);
	target = MulAdd(b1, MF4x4(0.63560385, 0.086338535, -0.13764763, 0.47561046, -0.124727264, 0.12672219, 0.070208505, -0.19783491, -0.17025535, -0.06808678, -0.020102726, -0.04832835, 0.036826584, -0.42171007, -0.06695269, 0.110764995), target);
	target = MulAdd(c1, MF4x4(-0.21227197, 0.007874801, 0.23701921, 0.1677161, -0.09035146, -0.078691766, -0.14215821, 0.124355234, 0.22710884, 0.033057146, -0.056999616, -0.23319073, 0.22966021, -0.06883101, 0.16328879, -0.06578935), target);
	target = MulAdd(d1, MF4x4(-0.054363396, -0.02026726, -0.3616366, 0.06780306, -0.04632169, 0.10096817, 0.0533077, -0.083695725, 0.23162244, 0.16473895, 0.19103514, 0.0071199746, 0.2165012, 0.04725686, 0.035206214, 0.022603447), target);
	target = MulAdd(e1, MF4x4(0.6271094, -0.09669194, 0.07382753, -0.30720463, 0.15260984, -0.36707088, -0.031697996, 0.01600927, -0.39879522, 0.101928055, -0.6943482, 0.14665292, -0.3587046, 0.021466898, -0.047919527, 0.2560715), target);
	target = MulAdd(f1, MF4x4(0.019088794, -0.0771604, -0.028177094, 0.088726945, -0.057697777, 0.2596943, 0.17144933, 0.058258526, 0.08891237, 0.106383145, 0.396072, 0.29374352, 0.06596987, -0.105576634, 0.055430118, -0.12292237), target);
	target = MulAdd(g1, MF4x4(-0.17208415, 0.12158739, 0.04662299, 0.21695717, 0.11738881, -0.067407556, -0.039283432, -0.1076609, 0.107738726, -0.121356055, -0.062349405, 0.048801728, 0.09052609, -0.11955365, 0.006165453, 0.06702327), target);
	target = MulAdd(h1, MF4x4(0.23194505, -0.2278423, -0.4579323, -0.4102899, -0.33038944, 0.10686308, 0.12578374, 0.14304528, -0.03290542, -0.22190952, -0.15582415, 0.10534921, 0.0939146, -0.04590803, -0.03591444, -0.030313203), target);
	target = MulAdd(i1, MF4x4(0.013647308, 0.16051029, 0.024319794, -0.10505089, 0.054013297, -0.06920784, -0.020672748, -0.08262819, 0.14681742, -0.07409691, -0.063802995, 0.05206, -0.041670747, -0.022410793, -0.034180272, 0.0044075833), target);
	target = MulAdd(a2, MF4x4(-0.16723743, -0.062276114, -0.06804346, -0.06663604, 0.14639418, -0.0013829652, 0.14537166, 0.08992991, 0.00034609268, -0.11339855, -0.24834645, -0.18017055, 0.08099037, -0.22302043, -0.1160269, 0.23041926), target);
	target = MulAdd(b2, MF4x4(0.19984062, 0.11262733, -0.021448923, 0.005645689, -0.22319363, 0.025013078, 0.050730385, 0.04427755, 0.10756255, 0.65996444, 0.17024773, -0.16237848, -0.032943483, 0.3259415, -0.08211643, -0.17815286), target);
	target = MulAdd(c2, MF4x4(0.022923036, 0.00817696, -0.024639564, -0.017746205, 0.08000752, -0.09480044, 0.049720343, -0.039725818, -0.07954878, -0.26012203, -0.053556137, 0.28696015, -0.145685, -0.12854065, -0.030942779, 0.15013586), target);
	target = MulAdd(d2, MF4x4(0.050982554, 0.067020066, -0.041660026, 0.07976747, -0.31219116, -0.1589965, -0.14711075, -0.2931567, -0.12886077, 0.108178794, 0.112790324, 0.18239829, 0.028661542, 0.066967815, 0.36810458, 0.07042916), target);
	target = MulAdd(e2, MF4x4(0.019871455, 0.13281262, -0.24303706, -0.053014435, 0.056483634, 0.2225138, 0.32238156, 0.09232671, 0.19425367, -0.96300596, 0.25233442, 0.34456885, 0.2688357, -0.14355205, 0.04201295, -0.09642235), target);
	target = MulAdd(f2, MF4x4(0.0021202683, 0.010281568, -0.009938761, 0.074630536, -0.23044111, 0.005154135, -0.04620688, -0.10301254, -0.17195332, -0.04863239, 0.07042225, -0.20654899, 0.029428456, 0.0045313304, 0.0051823566, 0.046590757), target);
	target = MulAdd(g2, MF4x4(0.061882593, -0.005337726, 0.10121195, 0.01023931, -0.1310065, 0.10085874, 0.13651021, -0.09158545, 0.09086723, -0.031106705, 0.03951561, 0.03958167, 0.00533062, -0.058091614, -0.11571378, -0.18051541), target);
	target = MulAdd(h2, MF4x4(0.012350476, 0.020112693, 0.0865518, 0.025516901, -0.2874268, 0.00638599, -0.3849406, 0.043449268, 0.27883583, -0.06104393, 0.17362429, 0.3229962, -0.18683271, -0.051683012, -0.14111629, 0.20863265), target);
	target = MulAdd(i2, MF4x4(0.06548792, -0.031812105, 0.032238998, 0.070259914, -0.0037810719, 0.106959336, 0.030661082, -0.11430295, 0.075470194, -0.035097398, -0.08884117, 0.15083537, -0.048511047, 0.09958945, 0.2043977, -0.14497246), target);
	target = MulAdd(a3, MF4x4(-0.025868082, 0.06237453, -0.034789152, -0.035199117, -0.021047676, -0.04558201, -0.0013141828, 0.033968918, -0.068529084, -0.06589172, -0.035473417, -0.03182408, 0.016299484, 0.07821524, -0.19162482, -0.06681627), target);
	target = MulAdd(b3, MF4x4(0.0052780746, 0.043558404, -0.24577554, 0.11166642, 0.016039649, 0.020174565, 0.0054034027, 0.023591455, 0.24817981, 0.08734375, -0.1477572, 0.1215117, -0.017666219, -0.012353692, -0.049153887, 0.0784066), target);
	target = MulAdd(c3, MF4x4(0.06988246, 0.06763118, 0.09934897, -0.042905882, -0.09801134, -0.033267114, 0.01741649, 0.059379116, -0.08127772, 0.010377487, -0.012631491, -0.077160686, -0.08947271, -0.067014046, -0.14255494, -0.03131322), target);
	target = MulAdd(d3, MF4x4(0.0059068906, 0.32045186, 0.3258453, 0.0071538044, -0.027888278, 0.0068888674, -0.0015216616, -0.050514743, -0.11685065, 0.02886966, -0.008737784, -0.09290019, -0.04111259, 0.0329059, -0.2584297, -0.07026411), target);
	target = MulAdd(e3, MF4x4(-0.25162768, -0.093273714, -0.029060591, 0.050672933, -0.025395831, 0.029609011, -0.13621128, -0.08097387, 0.39335665, -0.18867645, 0.8212168, 0.12602827, 0.5734114, 0.38603428, 0.23521046, 0.21041085), target);
	target = MulAdd(f3, MF4x4(0.020245805, -0.054311104, -0.0021298525, -0.08635577, 0.04203476, 0.054419816, 0.0032106396, 0.082799725, -0.03885507, -0.12756048, -0.19565445, -0.022734454, 0.10178226, 0.08269887, -0.0018781893, 0.11515606), target);
	target = MulAdd(g3, MF4x4(0.08051269, -0.25091916, -0.08014612, -0.29471904, -0.08183992, 0.02096263, -0.04595293, 0.053499684, -0.10576831, -0.01105415, 0.054239217, 0.05486181, -0.18503998, 0.06235187, -0.046460405, -0.072068095), target);
	target = MulAdd(h3, MF4x4(-0.14105208, 0.06913383, -0.129492, 0.18553926, 0.03405444, 0.0772168, 0.10576763, -0.04969428, 0.17356592, -0.10986026, -0.33151895, -0.11582152, -0.0016404261, -0.003514874, -0.2096539, 0.03649547), target);
	target = MulAdd(i3, MF4x4(0.020758089, 0.17374831, 0.039282177, -0.039052464, 0.050139774, -0.0005518581, -0.025435442, 0.023258803, -0.1458097, 0.090529695, 0.025673594, -0.026266405, 0.072392054, -0.055323754, 0.03383548, -0.033020195), target);
	target = MulAdd(na1, MF4x4(-0.09315446, -0.036772106, -0.09159718, -0.12479503, -0.018140549, -0.022523982, 0.047108658, -0.04837651, 0.007124631, -0.009751111, 0.055076525, -0.0057495553, 0.07268171, -0.054520987, -0.079869404, 0.28962412), target);
	target = MulAdd(nb1, MF4x4(0.040367916, 0.041719466, -0.07215196, -0.026521962, 0.23269388, 0.08115016, 0.10487475, 0.05837459, 0.09574069, 0.03150842, 0.12011107, 0.104198076, -0.25915185, 0.31970975, -0.053038772, -0.23452167), target);
	target = MulAdd(nc1, MF4x4(-0.089933544, 0.00026363076, -0.037807353, -0.0067500956, -0.13427527, 0.11757816, 0.020407641, -0.15267986, -0.13672389, -0.07098531, -0.050623354, -0.04904697, 0.05156428, -0.07822598, 0.07232775, 0.12266631), target);
	target = MulAdd(nd1, MF4x4(-0.050988704, -0.11840922, -0.06057243, -0.023974465, -0.047475163, -0.1388251, -0.052473098, 0.06360512, -0.016356083, -0.12530154, -0.044482324, -0.035020005, -0.02834032, -0.031647444, 0.07049413, -0.08899642), target);
	target = MulAdd(ne1, MF4x4(-0.060299333, 0.2991397, 0.0035407627, -0.12897336, -0.39282677, 0.42156345, -0.22449674, -0.11054013, 0.04733773, -0.094842866, -0.11086912, 0.10083519, 0.13186517, 0.1557214, 0.11726571, -0.23863392), target);
	target = MulAdd(nf1, MF4x4(-0.03155107, -0.002008898, -0.037107117, 0.04468562, 0.037719093, -0.10104318, -0.0021850376, -0.033998992, -0.033299964, -0.026892597, 0.012233978, -0.09816237, -0.15987061, -0.11821871, -0.11293413, 0.041385822), target);
	target = MulAdd(ng1, MF4x4(-0.03189814, 0.028700352, 0.030834107, 0.008420813, -0.029382093, 0.10250884, 0.032190785, 0.042566366, -0.0066131293, 0.019135946, -0.06836444, -0.082475856, 0.0020301298, 0.06428329, 0.05401348, 0.10219137), target);
	target = MulAdd(nh1, MF4x4(0.09569376, -0.104563974, 0.04412079, 0.046004657, -0.179229, 0.07610759, 0.21264501, -0.03126616, -0.08888636, 0.049238402, 0.09623378, 0.08347852, 0.034179587, 0.04112591, 0.020796875, 0.016594669), target);
	target = MulAdd(ni1, MF4x4(-0.022230666, -0.06919777, 0.0070929914, -0.040181976, 0.04288458, -0.057510544, -0.15865, -0.046124704, -0.06199105, -0.033739343, -0.12126394, -0.053888205, 0.003457772, -0.05709056, 0.009589608, 0.061582502), target);
	target = MulAdd(na2, MF4x4(-0.2261687, -0.010483538, 0.070508964, 0.16609758, -0.07575776, 0.07133805, 0.108534805, 0.016434515, -0.06777619, -0.053581562, -0.009408219, -0.0219316, -0.009917843, -0.056226153, 0.09495687, 0.103568204), target);
	target = MulAdd(nb2, MF4x4(0.26707995, 0.038988136, 0.15722616, -0.15202025, 0.011516332, -0.22326125, -0.21010138, 0.021120701, 0.052979603, -0.052226435, 0.03128543, -0.02211858, 0.16997981, 0.060853012, 0.17988598, -0.042057697), target);
	target = MulAdd(nc2, MF4x4(-0.19020362, -0.0019182847, 0.11082178, 0.18037713, -0.086572066, 0.072597384, -0.08759872, -0.064898625, 0.0427911, 0.101790726, 0.035692267, -0.17279546, 0.049133815, 0.08832157, 0.03645548, 0.011682866), target);
	target = MulAdd(nd2, MF4x4(0.27870035, 0.06836818, 0.36847374, -0.38926098, 0.05053419, -0.2971805, -0.22622849, 0.1165501, 0.037631556, 0.1250731, 0.059861004, 0.1194484, -0.002153221, 0.28717375, 0.071283594, 0.0974051), target);
	target = MulAdd(ne2, MF4x4(-0.040311184, 0.21025413, 0.32822168, -0.031298842, -0.06347585, 0.1510298, 0.00070645136, -0.34678075, -0.21172246, 0.05277019, -0.15126394, -0.33598784, -0.36668247, -0.36057234, -0.2734601, -0.2903695), target);
	target = MulAdd(nf2, MF4x4(-0.28878236, 0.100743115, -0.012016584, -0.15287946, 0.1262014, 0.015991366, 0.07392021, 0.06277959, 0.07709602, 0.060382154, 0.013840257, -0.1493553, 0.12138542, -0.032591913, -0.002609394, 0.13922709), target);
	target = MulAdd(ng2, MF4x4(0.13982488, -0.034557592, -0.35006866, -0.2928353, 0.11529845, 0.23494898, 0.0991676, 0.32742763, -0.03035729, 0.016935157, -0.04650478, -0.039851867, 0.16783717, -0.065768905, -0.102848, -0.03003262), target);
	target = MulAdd(nh2, MF4x4(-0.53978115, 0.026080003, 0.018700078, 0.077284, 0.2975522, -0.11212302, 0.118295476, 0.088821776, -0.22738294, 0.030945897, -0.1766137, -0.098558865, 0.039936017, 0.046374835, 0.19131522, 0.19770078), target);
	target = MulAdd(ni2, MF4x4(0.16857389, -0.020288788, 0.04038437, -0.25337628, -0.034605104, -0.094041236, -0.0049146856, -0.10170456, -0.14423485, 0.021705322, -0.09162893, -0.15423405, 0.08731724, 0.114831835, -0.028548159, -0.09497847), target);
	target = MulAdd(na3, MF4x4(-0.019900214, 0.17017384, -0.0002794323, -0.021626309, -0.5123191, -0.23828037, -0.10549822, -0.48781806, -0.12835194, -0.049513552, 0.08051828, -0.3390981, 0.21935092, 0.012243462, 0.13521184, 0.09005778), target);
	target = MulAdd(nb3, MF4x4(0.090306774, -0.31387252, -0.1616645, -0.063887075, 0.3674563, 0.19566801, 0.042223614, -0.38199827, -0.08814569, -0.14486119, 0.087531656, 0.18280624, -0.041397072, -0.025872236, -0.02853888, -0.047817115), target);
	target = MulAdd(nc3, MF4x4(-0.07662397, 0.10808078, 0.08065922, 0.033938166, 0.09167725, 0.09102921, 0.10393655, 0.09121259, 0.15521088, 0.026846137, 0.033644184, -0.006811738, -0.110427104, 0.0722537, 0.014346524, 0.019231822), target);
	target = MulAdd(nd3, MF4x4(-0.14094852, -0.21157825, 0.2149605, 0.28070143, -0.24665649, -0.16250402, -0.0730695, -0.1935525, 0.02327017, -0.13742846, -0.20341669, -0.19092573, 0.3781883, -0.14726567, 0.0033765805, -0.026217941), target);
	target = MulAdd(ne3, MF4x4(0.23381747, -0.21297243, -0.16462179, -0.4404414, 0.2630713, -0.06808036, 0.5769483, 0.13606368, -0.14412731, 0.17307961, 0.15431021, -0.06048075, -0.93423635, 0.2661323, -0.27400798, -0.71388435), target);
	target = MulAdd(nf3, MF4x4(-0.057459023, -0.044256542, -0.14173234, 0.17559054, 0.009228982, -0.20965119, -0.23656605, 0.0805913, -0.18358104, 0.04514636, -0.09859629, -0.00032626695, -0.10969266, -0.171687, -0.085197695, 0.067852624), target);
	target = MulAdd(ng3, MF4x4(0.0783408, 0.0022921865, -0.20093176, -0.094298504, -0.031999376, 0.03923688, 0.088507205, 0.1756585, 0.0325784, 0.09271384, 0.08411006, -0.011803396, 0.060698293, -0.0653917, -0.02558477, -0.02075619), target);
	target = MulAdd(nh3, MF4x4(-0.10503856, -0.058553405, 0.38081455, 0.13121964, 0.5770783, -0.10269853, -0.4627, -0.4232826, 0.11166562, -0.058157276, -0.15944225, 0.048007622, 0.06506096, -0.0067857644, -0.03218101, 0.08807966), target);
	target = MulAdd(ni3, MF4x4(0.032330092, -0.07843012, -0.037207145, 0.06599961, -0.28124368, 0.14263964, -0.0070453, 0.14530747, -0.05910883, 0.16203453, 0.064827256, -0.0043987543, -0.03808922, 0.102124214, 0.06162945, 0.103994325), target);
	conv2d_6_tf2[gxy] = target;
}

//!PASS 8
//!DESC Conv-4x1x1x120, Depth-to-Space
//!IN INPUT, conv2d_2_tf, conv2d_2_tf1, conv2d_2_tf2, conv2d_3_tf, conv2d_3_tf1, conv2d_3_tf2, conv2d_4_tf, conv2d_4_tf1, conv2d_4_tf2, conv2d_5_tf, conv2d_5_tf1, conv2d_5_tf2, conv2d_6_tf, conv2d_6_tf1, conv2d_6_tf2
//!OUT OUTPUT
//!BLOCK_SIZE 16
//!NUM_THREADS 64

void Pass8(uint2 blockStart, uint3 threadId) {
	uint2 gxy = (TileSwizzle8x8(threadId.x) << 1) + blockStart;
	
	const uint2 outputSize = GetOutputSize();
	if (gxy.x >= outputSize.x || gxy.y >= outputSize.y) {
		return;
	}

	float2 inputPt = GetInputPt();
	float2 pos = ((gxy >> 1) + 0.5f) * inputPt;

	MF4 g0 = conv2d_2_tf.SampleLevel(sam, pos, 0);
	MF4 g1 = conv2d_2_tf1.SampleLevel(sam, pos, 0);
	MF4 g2 = conv2d_2_tf2.SampleLevel(sam, pos, 0);
	MF4 g3 = conv2d_3_tf.SampleLevel(sam, pos, 0);
	MF4 g4 = conv2d_3_tf1.SampleLevel(sam, pos, 0);
	MF4 g5 = conv2d_3_tf2.SampleLevel(sam, pos, 0);
	MF4 g6 = conv2d_4_tf.SampleLevel(sam, pos, 0);
	MF4 g7 = conv2d_4_tf1.SampleLevel(sam, pos, 0);
	MF4 g8 = conv2d_4_tf2.SampleLevel(sam, pos, 0);
	MF4 g9 = conv2d_5_tf.SampleLevel(sam, pos, 0);
	MF4 g10 = conv2d_5_tf1.SampleLevel(sam, pos, 0);
	MF4 g11 = conv2d_5_tf2.SampleLevel(sam, pos, 0);
	MF4 g12 = conv2d_6_tf.SampleLevel(sam, pos, 0);
	MF4 g13 = conv2d_6_tf1.SampleLevel(sam, pos, 0);
	MF4 g14 = conv2d_6_tf2.SampleLevel(sam, pos, 0);

	MF4 ng0 = max(-g0, 0);
	MF4 ng1 = max(-g1, 0);
	MF4 ng2 = max(-g2, 0);
	MF4 ng3 = max(-g3, 0);
	MF4 ng4 = max(-g4, 0);
	MF4 ng5 = max(-g5, 0);
	MF4 ng6 = max(-g6, 0);
	MF4 ng7 = max(-g7, 0);
	MF4 ng8 = max(-g8, 0);
	MF4 ng9 = max(-g9, 0);
	MF4 ng10 = max(-g10, 0);
	MF4 ng11 = max(-g11, 0);
	MF4 ng12 = max(-g12, 0);
	MF4 ng13 = max(-g13, 0);
	MF4 ng14 = max(-g14, 0);

	g0 = max(g0, 0);
	g1 = max(g1, 0);
	g2 = max(g2, 0);
	g3 = max(g3, 0);
	g4 = max(g4, 0);
	g5 = max(g5, 0);
	g6 = max(g6, 0);
	g7 = max(g7, 0);
	g8 = max(g8, 0);
	g9 = max(g9, 0);
	g10 = max(g10, 0);
	g11 = max(g11, 0);
	g12 = max(g12, 0);
	g13 = max(g13, 0);
	g14 = max(g14, 0);

	MF4 target1 = MF4(-0.00339168, 0.022745693, -0.021186745, 0.007273877);
	target1 = MulAdd(g0, MF4x4(-0.06761509, 0.0010596798, 0.118115634, 0.14935187, -0.05466623, 0.091785856, -0.03665047, 0.076207176, -0.15206745, -0.074811794, -0.041557387, 0.020541618, -0.037649132, -0.07627772, -0.10156735, -0.07498991), target1);
	target1 = MulAdd(g1, MF4x4(-0.0541389, 0.007155582, -0.06095953, -0.016313383, -0.13457695, -0.03827954, -0.034835886, 0.04974308, 0.008285558, -0.06611796, -0.067563675, -0.11533022, -0.08719109, 0.042913426, -0.083873115, 0.027492668), target1);
	target1 = MulAdd(g2, MF4x4(0.17322378, -0.07721062, 0.076297946, -0.1325289, 0.00692486, 0.019282155, 0.038707003, 0.056305885, -0.037604675, -0.17109787, 0.052209407, -0.11086336, 0.0052244705, 0.056766637, -0.017374612, 0.06740667), target1);
	target1 = MulAdd(ng0, MF4x4(0.053550255, 0.07344529, -0.10690144, -0.08243465, 0.028142922, -0.07358604, 0.070248306, 0.0053416835, 0.009705257, 0.09426246, 0.05850371, 0.08341002, 0.06166079, 0.102394834, 0.058707405, 0.19911417), target1);
	target1 = MulAdd(ng1, MF4x4(-0.009806288, 0.061949313, 0.011325549, 0.031676874, 0.113277406, 0.07123387, -0.0022331094, -0.05520811, -0.021068804, 0.0073448666, 0.031778157, 0.06381251, -0.022977686, -0.0044090333, -0.028826792, -0.005600321), target1);
	target1 = MulAdd(ng2, MF4x4(-0.13628425, -0.107186474, 0.010461016, 0.045646533, 0.010563035, 0.0005640543, 0.002957052, -0.01454462, 0.106655054, 0.13992403, -0.01641908, 0.0264948, 0.014378123, 0.024764376, -0.06435794, -0.076860085), target1);
	target1 = MulAdd(g3, MF4x4(0.031931117, 0.062713124, -0.049225837, -0.02620178, 0.20593183, 0.03311921, -0.02824421, -0.19422682, -0.017965427, 0.05093508, -0.07729694, -0.013976707, -0.054889455, -0.008431357, -0.00865999, 0.05323866), target1);
	target1 = MulAdd(g4, MF4x4(-0.07898102, 0.13033123, -0.24963257, -0.046712235, -0.017762529, -0.07267942, 0.039491024, -0.034781307, 0.02270499, -0.12520099, -0.02714401, -0.13284011, 0.014340563, -0.007257448, -0.07413879, -0.12837824), target1);
	target1 = MulAdd(g5, MF4x4(0.09598721, -0.006008832, 0.051995635, -0.07847789, 0.109905876, 0.18126504, -0.086034976, -0.0360382, 0.19074084, 0.054656357, 0.06871617, -0.041497722, 0.064660124, -0.10478427, 0.052080367, -0.1518587), target1);
	target1 = MulAdd(ng3, MF4x4(-0.044614766, -0.08404386, 0.06729217, 0.03758003, -0.23567544, -0.0450765, 0.014905518, 0.19749434, 0.0070031853, -0.068472505, 0.04280405, -0.009026482, 0.03368337, 0.037044305, 0.014582284, -0.015817456), target1);
	target1 = MulAdd(ng4, MF4x4(0.05070276, -0.13125883, 0.24694905, 0.049511425, 0.021699967, 0.080548055, -0.03720478, 0.032441437, -0.01215519, 0.09360713, 0.024676912, 0.11170701, -0.024200387, 0.0021200276, 0.06300166, 0.10979445), target1);
	target1 = MulAdd(ng5, MF4x4(-0.1055991, 0.007073368, -0.07666124, 0.06573558, -0.10762247, -0.16527167, 0.09825201, 0.051373113, -0.1926851, -0.046607103, -0.07601954, 0.05199459, -0.06756806, 0.092222616, -0.026166819, 0.1535803), target1);
	target1 = MulAdd(g6, MF4x4(0.0067429054, 0.014872415, -0.019792963, 0.0014269215, 0.041500363, 0.018643422, 0.04487991, 0.031431414, -0.0278133, -0.028131608, -0.019798402, -0.041768856, -0.0063227355, 0.007656633, 0.0019235855, 0.00076331315), target1);
	target1 = MulAdd(g7, MF4x4(0.025489544, 0.023983652, 0.029175067, 0.0075372118, -0.010194142, -0.014977182, 0.011589661, 0.00036903258, -0.012841702, -0.010945794, -0.012143497, -0.0069256728, 0.007313037, 0.007576904, -0.016960602, 0.009170305), target1);
	target1 = MulAdd(g8, MF4x4(0.004188971, 0.017998729, -0.0046976185, -0.0034182668, 0.021841675, 0.012860078, 0.009202975, -0.0071324864, -0.0037808695, 0.01139587, -0.016267903, 0.007991299, 0.008879691, 0.007677154, 0.016209174, 0.011406443), target1);
	target1 = MulAdd(ng6, MF4x4(-0.008698401, -0.017972758, 0.026514322, -0.0024080887, 0.00012845756, 0.021530064, 0.0014967524, 0.0060274163, 0.017589558, 0.031043446, 0.014386793, 0.051733218, -0.013435874, -0.020567564, 0.011874828, 0.0030195254), target1);
	target1 = MulAdd(ng7, MF4x4(0.008565417, 0.0073839244, -0.012248247, -0.019089373, -0.04383907, 0.01000193, -0.003246391, 0.0502051, 0.012343873, 0.027492827, -0.011591099, 0.010474208, -0.009317595, -0.009244615, -0.00889853, -0.015167559), target1);
	target1 = MulAdd(ng8, MF4x4(-0.0149119655, -0.05737016, 0.027463723, 0.0013402153, 0.0012228708, 4.653676e-05, 5.3374144e-05, 0.010701133, 0.011828213, -0.012499855, -0.009720743, -0.035716657, -0.06976149, -0.05596556, 0.0028440042, 0.013388718), target1);
	target1 = MulAdd(g9, MF4x4(-0.010236228, 0.08551208, -0.060067203, 0.012999882, -0.0060008806, 0.003534564, 0.009385839, 0.010742909, 0.02672157, -0.17606625, 0.13504161, -0.035290483, -0.014812689, -0.0236554, 0.031493064, 0.01800991), target1);
	target1 = MulAdd(g10, MF4x4(0.0005283657, -0.032297328, 0.023884023, 0.024165852, 0.0017424148, -0.015371204, 0.0058860597, -0.04624227, 0.04947679, 0.09081732, -0.04592456, -0.03128466, 0.00023743653, -0.032846384, -0.0013158394, 0.0037953698), target1);
	target1 = MulAdd(g11, MF4x4(0.0034766623, -0.006661828, 0.027227342, 0.033958994, -0.007990619, 0.0025515554, -0.016197672, -0.0010064896, 0.022598108, 0.014734878, 0.021482255, -0.0059315437, -0.038538814, 0.03478085, -0.05926627, 0.012918195), target1);
	target1 = MulAdd(ng9, MF4x4(-0.023291608, -0.013129155, 0.0032865414, 0.026531553, -0.004495095, 0.0043812403, -0.027177097, -0.009125319, -0.006041235, -0.0031154896, -0.030664662, 0.005782464, -0.008880747, 0.015690446, -0.0108247, -0.022403536), target1);
	target1 = MulAdd(ng10, MF4x4(-0.07639219, 0.05440532, 0.016447276, -0.055569574, 0.0014948049, -0.03464865, -0.006925237, 0.024131197, 0.009468209, -0.011771851, 0.013548103, 0.004704814, 0.063868396, 0.04857746, 0.08745972, 0.0690927), target1);
	target1 = MulAdd(ng11, MF4x4(0.021505289, -0.06289818, 0.031038022, -0.047952045, 0.014759762, 0.10819852, -0.044093642, -0.020913709, -0.017672667, 0.007322798, -0.0030338434, -0.015471056, 0.017840479, -0.052742675, 0.044256743, -0.014589662), target1);
	target1 = MulAdd(g12, MF4x4(0.037849434, 0.04017271, 0.01840757, -0.05590355, 0.041468013, -0.015397055, -0.059170194, 0.08708615, 0.021914955, -0.0045240326, 0.03308673, 0.0141805615, -0.045770008, 0.048188016, -0.08913234, 0.046581928), target1);
	target1 = MulAdd(g13, MF4x4(-0.09374169, 0.07681035, -0.032266654, 0.066911325, 0.0071584303, 0.06599442, -0.0031403983, -0.062489454, 0.013248783, 0.018261025, -0.00095267413, -0.026741864, -0.0059258267, 0.03542517, -0.033440042, -0.0007421821), target1);
	target1 = MulAdd(g14, MF4x4(0.06491965, 0.0354909, -0.035559855, -0.07943817, 0.028543673, 0.026842002, -0.0029009457, -0.0022229373, 0.045988, -0.08896797, -0.04740724, 0.002011393, -0.067833476, -0.048432026, 0.025755037, 0.042066928), target1);
	target1 = MulAdd(ng12, MF4x4(-0.0011515832, -0.067060925, 0.02632549, 0.019017957, -0.0021755556, 0.004405696, 0.03028079, -0.043944478, -0.06373467, -0.032911435, -0.07619137, -0.055402283, -0.014293524, -0.009286333, 0.032950103, 0.0020192636), target1);
	target1 = MulAdd(ng13, MF4x4(0.033251163, -0.012636667, -0.019736348, -0.02221555, -0.035174683, -0.0024467881, -0.0020635366, 0.021488743, 0.054788366, -0.085087426, 0.06572526, -0.037050918, -0.06467607, -0.1047945, 0.10937466, 0.058931317), target1);
	target1 = MulAdd(ng14, MF4x4(-0.0015108787, 0.016789518, -0.02054971, 0.014368727, -0.083879344, -0.0024550394, 0.047329154, 0.018185811, -0.008528356, 0.04782707, 0.0019893225, 0.0095295245, -0.0024202724, -0.022640519, 0.0033455987, 0.010862984), target1);

	MF4 target2 = MF4(0.015986905, 0.006547183, 0.017682848, 0.0020978956);
	target2 = MulAdd(g0, MF4x4(0.016521078, 0.02344092, -0.04535869, -0.02916889, -0.06936641, -0.1118498, -0.07784149, -0.10769916, 0.042465053, 0.023522044, 0.0057797814, -0.00933453, 0.0013065349, 0.006887965, 0.019049056, 0.00018660461), target2);
	target2 = MulAdd(g1, MF4x4(0.047062866, 0.030671, 0.018363738, 0.015970303, 0.03619224, 0.0009964193, 0.027005734, -0.010791107, -0.027404316, -0.017589977, 0.0027660786, 0.0064380392, 0.003131181, -0.03881711, 0.017278498, -0.026646316), target2);
	target2 = MulAdd(g2, MF4x4(-0.09417044, -0.030767195, -0.07023792, -0.015087274, -0.0007041566, -0.007214834, -0.010352469, -0.0208777, -0.006043107, 0.041942447, -0.027989924, 0.02058792, -0.004574836, -0.030063841, 0.0009874715, -0.030957421), target2);
	target2 = MulAdd(ng0, MF4x4(0.008398759, -0.014724292, 0.05661028, 0.03329433, 0.06970151, 0.09905173, 0.045296658, 0.06785315, -0.0044002533, -0.033776686, -0.018678186, -0.029671727, -0.019401457, -0.018823013, -0.015008842, -0.06645454), target2);
	target2 = MulAdd(ng1, MF4x4(-0.012770869, -0.039806906, -0.020173356, -0.033546574, -0.01800492, 0.005292071, -0.0040793624, 0.028466543, -0.0059105135, -0.01909232, -0.008970177, -0.023610232, 0.015667727, 0.021344513, 0.008805983, 0.012206504), target2);
	target2 = MulAdd(ng2, MF4x4(0.09997275, 0.08955608, 0.035512842, 0.028650196, -0.0030424239, -0.0024058563, 0.0016431157, 0.006236751, -0.036105607, -0.04603557, 0.009145427, -0.0048202197, -0.020911733, -0.02017906, 0.016494693, 0.026199821), target2);
	target2 = MulAdd(g3, MF4x4(-0.038404938, -0.060263526, -6.756075e-05, -0.027351642, -0.088377364, -0.018328555, 0.0054546758, 0.080624446, 0.011837796, -0.020218652, 0.018197412, 0.0060563446, 0.025623528, 0.048627276, 0.023259064, 0.040498782), target2);
	target2 = MulAdd(g4, MF4x4(0.001184946, -0.010515342, 0.07386562, 0.059235208, 0.05555331, 0.062187005, 0.05260689, 0.053744275, -0.05839836, -0.037090734, -0.039248314, -0.020784492, -0.028018624, -0.019818485, 0.0076861596, 0.02911364), target2);
	target2 = MulAdd(g5, MF4x4(-0.00855134, 0.026217, 0.008748317, 0.044626243, -0.031007087, -0.040997487, 0.05034173, 0.048289847, -0.055651344, -0.0043054484, -0.022927478, 0.035169583, -0.008501671, 0.04446119, 0.011305084, 0.07596592), target2);
	target2 = MulAdd(ng3, MF4x4(0.02517117, 0.04711998, 0.013574831, 0.035244223, 0.075724855, -0.0018857572, -0.01328286, -0.08398966, -0.018110974, 0.010837328, -0.040522598, -0.018411685, -0.059188075, -0.04547794, -0.029902466, -0.016604925), target2);
	target2 = MulAdd(ng4, MF4x4(-0.035855412, 0.046150643, -0.10446721, -0.026326178, -0.04509233, -0.059326984, -0.035487395, -0.047976315, 0.07541923, 0.014728924, 0.046932008, 0.015592031, 0.017363356, 0.009260565, -0.014755931, -0.04052638), target2);
	target2 = MulAdd(ng5, MF4x4(0.021554522, -0.011627397, -0.01343262, -0.04844844, 0.027149484, 0.05269421, -0.038861327, -0.034239817, 0.045947555, 0.0040015248, 0.007324502, -0.033051178, 0.0059830896, -0.069709964, 0.0073222807, -0.07108966), target2);
	target2 = MulAdd(g6, MF4x4(-0.009433482, 0.014257062, -0.034876116, -0.006570796, 0.01594308, 0.006663722, 0.025571914, 0.017348047, -0.00696648, 0.0012649806, -0.009151321, -0.016255042, -0.009809473, -0.0066239014, 0.013773972, 0.0009501933), target2);
	target2 = MulAdd(g7, MF4x4(0.026438858, 0.021545267, 0.028909115, -0.00084199436, -0.011350823, -0.010261177, 0.0064784726, 0.0028340816, 4.6254245e-05, 0.0022755957, 0.008798779, 0.010278017, -0.0011969887, 0.0035411653, -0.018417642, 0.0038709878), target2);
	target2 = MulAdd(g8, MF4x4(0.013238081, 6.1892446e-05, 0.002711564, -0.009014244, 0.03579594, 0.0009713739, 0.018199503, -0.010510502, -0.0019577555, -0.0035989769, -0.027621416, -0.000649344, 0.012450313, 0.005054388, 0.028295556, 0.016118951), target2);
	target2 = MulAdd(ng6, MF4x4(0.0014749946, -0.023122363, 0.03635473, 0.0058698757, -0.001502294, 0.0056668227, -0.00653508, -0.0045331884, 0.0019510906, -0.0004722523, 0.0015459604, 0.02002365, -0.012883676, -0.02313574, 0.0055781654, 0.00042050896), target2);
	target2 = MulAdd(ng7, MF4x4(0.010353148, 0.0061610388, -0.01620723, -0.025678562, -0.050585296, 0.0015720357, 0.006579174, 0.04645622, 0.0034451822, 0.01640892, -0.019171385, -0.002445667, 0.002142384, -0.00157746, -0.007453497, -0.012107003), target2);
	target2 = MulAdd(ng8, MF4x4(-0.023626367, -0.03362931, 0.02775251, 0.00854008, -0.00731221, 0.0058875666, -0.0042465483, 0.011091973, 0.01608576, 0.008776418, -0.005520655, -0.02189608, -0.07337467, -0.04255072, 0.008632718, 0.024232844), target2);
	target2 = MulAdd(g9, MF4x4(-0.012279061, 0.09683549, -0.058048066, 0.009577618, -0.007927522, 0.0030408904, 0.0026037316, 0.0097128665, 0.039862663, -0.18592681, 0.15766914, -0.02878756, -0.015735846, -0.025808172, 0.035324212, 0.025404148), target2);
	target2 = MulAdd(g10, MF4x4(0.006978013, -0.023965824, 0.04186123, 0.035988815, 0.009321329, -0.015712317, 0.0018002216, -0.052822754, 0.05654876, 0.111119345, -0.041984286, -0.029346094, -0.007712756, -0.034608763, -0.0036700158, 0.0038703915), target2);
	target2 = MulAdd(g11, MF4x4(0.010860362, 0.006824253, 0.03891404, 0.049122907, -0.008826647, -0.0010997625, -0.021827312, -0.007863293, 0.033063967, 0.022403365, 0.032778744, 0.007655028, -0.04496311, 0.041045222, -0.07040422, 0.004163393), target2);
	target2 = MulAdd(ng9, MF4x4(-0.024705354, -0.015902927, 0.0062216455, 0.032576248, -0.0073882695, 0.00312872, -0.034358293, -0.0108961025, -0.013837597, -0.01177598, -0.04495569, -0.0055595962, -0.01059331, 0.012361757, -0.014834784, -0.033682585), target2);
	target2 = MulAdd(ng10, MF4x4(-0.09480182, 0.03846278, -0.0028056598, -0.07323092, -0.005995085, -0.043553468, -0.005056617, 0.024003377, 0.004277762, -0.012972639, 0.012475677, 0.008617157, 0.10223809, 0.07649263, 0.12168736, 0.097682655), target2);
	target2 = MulAdd(ng11, MF4x4(0.015393864, -0.07291429, 0.02954706, -0.05294187, 0.013404429, 0.120944545, -0.042298347, -0.01288604, -0.019713184, 0.0020540208, -0.011201426, -0.02414191, 0.007575817, -0.07666445, 0.0432983, -0.026015261), target2);
	target2 = MulAdd(g12, MF4x4(0.03819905, 0.04372597, 0.01904637, -0.061578088, 0.040888324, -0.016588384, -0.064523876, 0.09287848, 0.01574791, -0.014614555, 0.02938285, 0.0042374404, -0.046039872, 0.056844704, -0.08844019, 0.052806962), target2);
	target2 = MulAdd(g13, MF4x4(-0.096315265, 0.07987954, -0.031859763, 0.072237074, 0.015652604, 0.07566605, -0.00032600394, -0.05746408, 0.014229001, 0.017113304, -0.0023968874, -0.03106284, -0.0069599864, 0.03968875, -0.038528994, -0.003121002), target2);
	target2 = MulAdd(g14, MF4x4(0.07314791, 0.03615158, -0.03678017, -0.0791755, 0.03634212, 0.039138626, 0.0035000257, 0.00436604, 0.044376615, -0.09974018, -0.051570408, -0.002901859, -0.06796205, -0.05585607, 0.02609314, 0.04431718), target2);
	target2 = MulAdd(ng12, MF4x4(0.0026970597, -0.07160132, 0.03102004, 0.022031954, 0.000259048, 0.004125086, 0.033309445, -0.04846637, -0.06566389, -0.029620873, -0.07882971, -0.053104673, -0.013712152, -0.015054757, 0.033180926, 0.00034900242), target2);
	target2 = MulAdd(ng13, MF4x4(0.034628514, -0.01001147, -0.021473913, -0.022840675, -0.045706123, -0.010280426, -0.0069577876, 0.01667532, 0.055181097, -0.087735586, 0.06744914, -0.034818206, -0.066513196, -0.10804274, 0.11681918, 0.06460058), target2);
	target2 = MulAdd(ng14, MF4x4(-0.005054911, 0.01865763, -0.021856284, 0.010207481, -0.090607546, -0.014940299, 0.04399175, 0.013478195, -0.0072319377, 0.057889264, 0.0061306353, 0.021376813, -0.00018109869, -0.022432365, 0.004136804, 0.011778294), target2);

	MF4 target3 = MF4(0.00428531, -0.011541925, 0.00898425, -0.01374321);
	target3 = MulAdd(g0, MF4x4(0.17312507, 0.18378204, 0.07926516, 0.1067288, 0.21052518, 0.13378853, 0.19536258, 0.14002354, 0.11711924, 0.08335183, 0.056983225, 0.028226014, 0.03449669, 0.044664416, 0.06761993, 0.044069722), target3);
	target3 = MulAdd(g1, MF4x4(0.049151406, 0.027747469, 0.013829845, 0.010793505, 0.16125697, 0.10510845, 0.13865222, 0.08505211, -0.20990449, -0.19430009, -0.15810025, -0.15454805, -0.035844944, -0.11059333, -0.018675208, -0.09188628), target3);
	target3 = MulAdd(g2, MF4x4(0.006685408, 0.11628241, 0.039672334, 0.1436817, 0.015559294, 0.009202889, 0.004621052, -0.006609141, 0.007991005, 0.08041883, -0.014427849, 0.057766948, -0.067192554, -0.10489045, -0.058118373, -0.10879217), target3);
	target3 = MulAdd(ng0, MF4x4(-0.13102308, -0.16938946, -0.049558997, -0.08738032, -0.15949999, -0.098247744, -0.21387893, -0.16764748, -0.036459852, -0.08977845, -0.063770026, -0.085683785, -0.04874994, -0.050357077, -0.040709995, -0.12104794), target3);
	target3 = MulAdd(ng1, MF4x4(-0.0016424131, -0.04231474, -0.008843509, -0.026220948, -0.13888876, -0.10844901, -0.10787409, -0.067019746, 0.1705322, 0.16687205, 0.16005264, 0.15010779, 0.084698394, 0.092028156, 0.07699169, 0.079460666), target3);
	target3 = MulAdd(ng2, MF4x4(0.0075197075, -0.020141402, -0.1006905, -0.11359611, -0.0085215755, -0.005612361, -0.0018493677, 0.007426326, -0.06751104, -0.08159549, 0.0120629985, -0.012342098, 0.03995728, 0.036384724, 0.09553051, 0.09851564), target3);
	target3 = MulAdd(g3, MF4x4(-0.029465627, -0.054333087, 0.02729686, -0.0045043076, -0.13339953, -0.032064863, 0.0070489575, 0.1158326, -0.0006455828, -0.05559491, 0.016300855, -0.016093824, 0.0035336027, 0.025718046, -0.002194457, 0.009156581), target3);
	target3 = MulAdd(g4, MF4x4(-0.03060067, -0.088183194, 0.08511207, 0.023555957, 0.030279126, 0.037585177, 0.016086163, 0.017970216, -0.05365472, 0.008709411, -0.022766082, 0.026308894, -0.026761275, -0.012835554, 0.02677239, 0.06120358), target3);
	target3 = MulAdd(g5, MF4x4(-0.030154163, 0.016827311, -0.0070917453, 0.049568735, -0.06463202, -0.095433265, 0.059520688, 0.039794426, -0.11667492, -0.040507805, -0.05257038, 0.025766404, -0.04885214, 0.042495333, -0.022887079, 0.08385772), target3);
	target3 = MulAdd(ng3, MF4x4(0.024346549, 0.054313555, -0.005122175, 0.019812366, 0.13365328, 0.014708698, -0.010476813, -0.1185288, 0.0023148789, 0.052297566, -0.03189476, 0.005272433, -0.03835005, -0.026765257, -0.0094220815, 0.0047409064), target3);
	target3 = MulAdd(ng4, MF4x4(-0.007440264, 0.12066173, -0.12320844, 0.0016777752, -0.011408617, -0.029569637, 0.008827655, -0.007016294, 0.06650651, -0.031428255, 0.034667335, -0.023670185, 0.007218744, -0.004491109, -0.035605032, -0.07145819), target3);
	target3 = MulAdd(ng5, MF4x4(0.049787126, -0.0017957676, -0.006283968, -0.058967303, 0.05774073, 0.09960317, -0.059987612, -0.036502153, 0.07282059, 0.005348924, 0.013446346, -0.04757274, 0.045422055, -0.0634229, 0.024715338, -0.08555914), target3);
	target3 = MulAdd(g6, MF4x4(-0.005835691, 0.016965812, -0.028456861, -0.0033920892, 0.009836867, 0.0006767609, 0.01886044, 0.012588657, -0.00884555, -0.0037418597, -0.009430517, -0.019091168, -0.002798804, 0.0039561144, 0.017126411, 0.004825749), target3);
	target3 = MulAdd(g7, MF4x4(0.028191822, 0.029202491, 0.032901034, 0.011502915, -0.010819439, -0.0069572316, 0.006472295, 0.0053685335, 0.00079939753, 0.0037769184, 0.011775226, 0.01399779, 0.0033956952, 0.0052899374, -0.010259701, 0.0077763535), target3);
	target3 = MulAdd(g8, MF4x4(0.008361512, -0.0117131, -0.0049652294, -0.01998969, 0.022627737, -0.008692346, 0.0019018264, -0.023467707, -0.008756792, -0.017017934, -0.031440705, -0.008512948, 0.0054877545, -0.00070786494, 0.019616788, 0.00793716), target3);
	target3 = MulAdd(ng6, MF4x4(-0.013002159, -0.03813209, 0.026482832, -0.00023578315, -0.004977621, 0.0014138863, -0.0057627726, -0.0042974507, -0.007416917, -0.008726386, -0.011688116, 0.010687058, -0.011166254, -0.020983206, 0.0066195372, 0.003834876), target3);
	target3 = MulAdd(ng7, MF4x4(0.0048169903, 0.0076203775, -0.015507004, -0.023508213, -0.052957263, -0.0069484734, -0.0011737008, 0.03410549, 0.0030833874, 0.012800496, -0.019242208, -0.005873537, -0.005420416, -0.009030759, -0.01785444, -0.01966881), target3);
	target3 = MulAdd(ng8, MF4x4(-0.012387838, -0.014545728, 0.035943765, 0.024116462, 0.0008325086, 0.017050253, 0.0024911535, 0.019210132, 0.02221826, 0.020303903, 0.004521489, -0.009177796, -0.07020659, -0.040271588, 0.013064882, 0.028324096), target3);
	target3 = MulAdd(g9, MF4x4(-0.0069806273, 0.09828906, -0.049242873, 0.014799003, -0.008970328, 0.003844374, 0.0010211956, 0.008877965, 0.039977968, -0.17025097, 0.14956547, -0.02214056, -0.00973778, -0.018551195, 0.034893923, 0.027594449), target3);
	target3 = MulAdd(g10, MF4x4(0.011814281, -0.015895301, 0.04550156, 0.04049697, 0.0076704635, -0.018837227, 0.005477875, -0.04887477, 0.05526271, 0.11000575, -0.03529281, -0.023258513, -0.0022530397, -0.026560089, -0.0021712275, 0.0056000547), target3);
	target3 = MulAdd(g11, MF4x4(0.013357528, 0.014710138, 0.043349367, 0.053752452, -0.010020186, -0.0048438436, -0.023880936, -0.011357083, 0.033450976, 0.022771686, 0.0326334, 0.0068722614, -0.0512848, 0.026570365, -0.07270785, -0.006190101), target3);
	target3 = MulAdd(ng9, MF4x4(-0.025186045, -0.01740991, 0.003838567, 0.027091907, -0.0071685803, -0.00027341367, -0.02992052, -0.008542527, -0.013445479, -0.015780428, -0.042524435, -0.00881602, -0.011120149, 0.009015556, -0.013422532, -0.032560103), target3);
	target3 = MulAdd(ng10, MF4x4(-0.09606898, 0.025490688, -0.008527585, -0.075416856, -0.0028138838, -0.035580438, -0.006531162, 0.023687562, 0.0055310167, -0.010112962, 0.014539237, 0.01172912, 0.09965159, 0.075306684, 0.11886721, 0.095253), target3);
	target3 = MulAdd(ng11, MF4x4(0.011965668, -0.072057776, 0.024608271, -0.054251578, 0.012394993, 0.114785306, -0.0419942, -0.011279603, -0.021266261, -0.0042840955, -0.015289745, -0.029362924, 0.0103631085, -0.06942332, 0.042722963, -0.021691492), target3);
	target3 = MulAdd(g12, MF4x4(0.033176757, 0.04084371, 0.015103838, -0.057419725, 0.037109293, -0.016537853, -0.059167393, 0.08598897, 0.015969522, -0.010902342, 0.03118472, 0.008363948, -0.041729625, 0.057053857, -0.08161458, 0.052837733), target3);
	target3 = MulAdd(g13, MF4x4(-0.092430755, 0.07110693, -0.034382034, 0.062702626, 0.014907711, 0.07141848, -0.0019698131, -0.054372307, 0.0128283445, 0.013943152, -0.0034115645, -0.030608373, -0.005405216, 0.03866557, -0.034109335, -0.0013265307), target3);
	target3 = MulAdd(g14, MF4x4(0.06594738, 0.029660825, -0.037681, -0.07724883, 0.03563272, 0.041913237, 0.0042468007, 0.0069140824, 0.039035708, -0.09520566, -0.04894546, -0.0034723799, -0.06357319, -0.052821137, 0.022598358, 0.041650392), target3);
	target3 = MulAdd(ng12, MF4x4(0.004992455, -0.06508938, 0.030750059, 0.022826253, 0.002092941, 0.0037119875, 0.030300831, -0.0454966, -0.05877186, -0.024108075, -0.07177208, -0.047089674, -0.014241358, -0.015470063, 0.029174741, -0.0012050892), target3);
	target3 = MulAdd(ng13, MF4x4(0.033182934, -0.0073093693, -0.017909355, -0.018535342, -0.0415075, -0.010425076, -0.0039859596, 0.015540642, 0.05229552, -0.08504954, 0.06377993, -0.035305116, -0.06266023, -0.102613874, 0.10803333, 0.06006112), target3);
	target3 = MulAdd(ng14, MF4x4(-0.0026692066, 0.020269373, -0.018895708, 0.010902005, -0.084507205, -0.018323625, 0.03897616, 0.008709061, -0.005905961, 0.05540135, 0.0050392286, 0.019433267, -0.0011370446, -0.02185742, 0.004525434, 0.010520601), target3);

	float2 outputPt = GetOutputPt();
	
	pos -= 0.5f * outputPt;
	OUTPUT[gxy] = MF4(MF3(target1.x, target2.x, target3.x) + INPUT.SampleLevel(sam1, pos, 0).rgb, 1);

	++gxy.x;
	pos.x += outputPt.x;
	OUTPUT[gxy] = MF4(MF3(target1.y, target2.y, target3.y) + INPUT.SampleLevel(sam1, pos, 0).rgb, 1);
	
	++gxy.y;
	pos.y += outputPt.y;
	OUTPUT[gxy] = MF4(MF3(target1.w, target2.w, target3.w) + INPUT.SampleLevel(sam1, pos, 0).rgb, 1);

	--gxy.x;
	pos.x -= outputPt.x;
	OUTPUT[gxy] = MF4(MF3(target1.z, target2.z, target3.z) + INPUT.SampleLevel(sam1, pos, 0).rgb, 1);
}
