// Solid Color Background
// Fills pillarbox/letterbox areas with a customizable solid color

//!BGFX EFFECT
//!VERSION 1
//!NAME Solid Color
//!CATEGORY Background
//!DESCRIPTION Fills the black bars with a solid color of your choice. Simple and clean.

//!PARAMETER
//!LABEL Red
//!DESC Red color component (0-1)
//!DEFAULT 0.1
//!MIN 0.0
//!MAX 1.0
//!STEP 0.01
float colorR;

//!PARAMETER
//!LABEL Green
//!DESC Green color component (0-1)
//!DEFAULT 0.1
//!MIN 0.0
//!MAX 1.0
//!STEP 0.01
float colorG;

//!PARAMETER
//!LABEL Blue
//!DESC Blue color component (0-1)
//!DEFAULT 0.1
//!MIN 0.0
//!MAX 1.0
//!STEP 0.01
float colorB;

//!TEXTURE
Texture2D INPUT;

//!TEXTURE
//!WIDTH RENDERER_WIDTH
//!HEIGHT RENDERER_HEIGHT
Texture2D OUTPUT;

//!SAMPLER
//!FILTER LINEAR
SamplerState linearSampler;

//!PASS 1
//!DESC Solid Color Background
//!STYLE PS
//!IN INPUT
//!OUT OUTPUT

float4 Pass1(float2 pos) {
    float2 inputSize = float2(GetInputSize());
    float2 outputSize = float2(GetOutputSize());

    float inputAspect = inputSize.x / inputSize.y;
    float outputAspect = outputSize.x / outputSize.y;

    float2 contentScale;
    float2 contentOffset;

    if (inputAspect > outputAspect) {
        contentScale = float2(1.0, outputAspect / inputAspect);
        contentOffset = float2(0.0, (1.0 - contentScale.y) * 0.5);
    } else {
        contentScale = float2(inputAspect / outputAspect, 1.0);
        contentOffset = float2((1.0 - contentScale.x) * 0.5, 0.0);
    }

    float2 contentUV = (pos - contentOffset) / contentScale;
    bool insideContent = all(contentUV >= 0.0) && all(contentUV <= 1.0);

    if (insideContent) {
        return INPUT.SampleLevel(linearSampler, contentUV, 0);
    }

    return float4(colorR, colorG, colorB, 1.0);
}
