// ============================================================================
// BGFX - BorderlessGaming Effects System
// Built-in definitions for IDE/intellisense support
// ============================================================================

// ----------------------------------------------------------------------------
// Thread Configuration
// ----------------------------------------------------------------------------
#define BG_BLOCK_WIDTH 8
#define BG_BLOCK_HEIGHT 8
#define BG_NUM_THREADS_X 64
#define BG_NUM_THREADS_Y 1
#define BG_NUM_THREADS_Z 1

// ----------------------------------------------------------------------------
// Precision Types
// When FP16 is enabled, these become min16float variants for better performance
// ----------------------------------------------------------------------------
#define MF float
#define MF1 float1
#define MF2 float2
#define MF3 float3
#define MF4 float4

// Matrix types (rows x columns)
#define MF1x1 float1x1
#define MF1x2 float1x2
#define MF1x3 float1x3
#define MF1x4 float1x4
#define MF2x1 float2x1
#define MF2x2 float2x2
#define MF2x3 float2x3
#define MF2x4 float2x4
#define MF3x1 float3x1
#define MF3x2 float3x2
#define MF3x3 float3x3
#define MF3x4 float3x4
#define MF4x1 float4x1
#define MF4x2 float4x2
#define MF4x3 float4x3
#define MF4x4 float4x4

// ----------------------------------------------------------------------------
// Texture & Size Functions
// ----------------------------------------------------------------------------

/// Returns the input texture dimensions in pixels
uint2 GetInputSize() { return uint2(0, 0); }

/// Returns the size of one pixel in input texture UV space (1.0 / size)
float2 GetInputPt() { return float2(0, 0); }

/// Returns the output texture dimensions in pixels
uint2 GetOutputSize() { return uint2(0, 0); }

/// Returns the size of one pixel in output texture UV space (1.0 / size)
float2 GetOutputPt() { return float2(0, 0); }

/// Returns the scale factor between output and input (output / input)
float2 GetScale() { return float2(0, 0); }

// ----------------------------------------------------------------------------
// Thread Mapping
// ----------------------------------------------------------------------------

/// Maps thread index (0-63) to 8x8 block coordinates in swizzle order
/// Improves texture cache coherency for compute shaders
uint2 TileSwizzle8x8(uint a) { return uint2(a / 8, a % 8); }

// ----------------------------------------------------------------------------
// Time & Animation (requires //!USE_DYNAMIC)
// ----------------------------------------------------------------------------

/// Returns total frames rendered since scaling started
uint GetFrameCount() { return 0; }

/// Returns elapsed time in seconds since scaling started
float GetTime() { return 0.0; }

/// Returns time since last frame in seconds (delta time)
float GetTimeDelta() { return 0.0; }

/// Returns time in seconds since a history frame was captured
/// age: 1-7 (1 = previous frame, 7 = oldest)
/// Useful for LCD response time simulation
float GetHistoryTimeDelta(int age) { return 0.0; }

// ----------------------------------------------------------------------------
// Optimized Math (requires //!USE MulAdd)
// Fused multiply-add operations for matrix computations
// Equivalent to: mul(x, y) + a
// ----------------------------------------------------------------------------

MF2 MulAdd(MF2 x, MF2x2 y, MF2 a) { return mul(x, y) + a; }
MF3 MulAdd(MF2 x, MF2x3 y, MF3 a) { return mul(x, y) + a; }
MF4 MulAdd(MF2 x, MF2x4 y, MF4 a) { return mul(x, y) + a; }
MF2 MulAdd(MF3 x, MF3x2 y, MF2 a) { return mul(x, y) + a; }
MF3 MulAdd(MF3 x, MF3x3 y, MF3 a) { return mul(x, y) + a; }
MF4 MulAdd(MF3 x, MF3x4 y, MF4 a) { return mul(x, y) + a; }
MF2 MulAdd(MF4 x, MF4x2 y, MF2 a) { return mul(x, y) + a; }
MF3 MulAdd(MF4 x, MF4x3 y, MF3 a) { return mul(x, y) + a; }
MF4 MulAdd(MF4 x, MF4x4 y, MF4 a) { return mul(x, y) + a; }
