//!BGFX EFFECT
//!VERSION 1
//!NAME Feedback Test
//!CATEGORY Temporal
//!DESCRIPTION Test effect - creates obvious motion trail/smear using PassFeedback.
//!USE _DYNAMIC

// Demonstrates PassFeedback by creating a strong motion trail effect
// The image smears/trails as objects move, proving feedback accumulation works
// 90% previous frame + 10% current = strong persistence

//!TEXTURE
Texture2D INPUT;

//!TEXTURE
Texture2D OUTPUT;

//!TEXTURE
//!FEEDBACK Smear
Texture2D PrevFrame;

//!SAMPLER
//!FILTER LINEAR
SamplerState sam;

//!PASS 1
//!NAME Smear
//!STYLE PS
//!IN INPUT, PrevFrame
//!OUT OUTPUT

float4 Pass1(float2 pos) {
    float4 current = INPUT.SampleLevel(sam, pos, 0);
    float4 prev = PrevFrame.SampleLevel(sam, pos, 0);

    // Strong blend with previous frame creates obvious trail
    float4 result = lerp(current, prev, 0.9);
    result.a = 1.0;
    return result;
}
