//!BGFX EFFECT
//!VERSION 1
//!NAME History Test
//!CATEGORY Temporal
//!DESCRIPTION Test effect - shows current + 7 history frames in a 4x2 grid.
//!USE _DYNAMIC

// Displays all 8 frames (current + 7 history) in a 4x2 grid
// Top row: Current, History1, History2, History3
// Bottom row: History4, History5, History6, History7

//!TEXTURE
Texture2D INPUT;

//!TEXTURE
Texture2D OUTPUT;

//!TEXTURE
//!HISTORY 1
Texture2D History1;

//!TEXTURE
//!HISTORY 2
Texture2D History2;

//!TEXTURE
//!HISTORY 3
Texture2D History3;

//!TEXTURE
//!HISTORY 4
Texture2D History4;

//!TEXTURE
//!HISTORY 5
Texture2D History5;

//!TEXTURE
//!HISTORY 6
Texture2D History6;

//!TEXTURE
//!HISTORY 7
Texture2D History7;

//!SAMPLER
//!FILTER LINEAR
SamplerState sam;

//!PASS 1
//!STYLE PS
//!IN INPUT, History1, History2, History3, History4, History5, History6, History7
//!OUT OUTPUT

float4 Pass1(float2 pos) {
    // Determine grid cell (4 columns x 2 rows)
    int col = int(pos.x * 4.0);
    int row = int(pos.y * 2.0);
    int cell = row * 4 + col;

    // Sample position within cell
    float2 cellPos = frac(pos * float2(4.0, 2.0));

    float4 result;
    switch (cell) {
        case 0: result = INPUT.SampleLevel(sam, cellPos, 0); break;
        case 1: result = History1.SampleLevel(sam, cellPos, 0); break;
        case 2: result = History2.SampleLevel(sam, cellPos, 0); break;
        case 3: result = History3.SampleLevel(sam, cellPos, 0); break;
        case 4: result = History4.SampleLevel(sam, cellPos, 0); break;
        case 5: result = History5.SampleLevel(sam, cellPos, 0); break;
        case 6: result = History6.SampleLevel(sam, cellPos, 0); break;
        case 7: result = History7.SampleLevel(sam, cellPos, 0); break;
        default: result = float4(0, 0, 0, 1); break;
    }

    return result;
}
