//!BGFX EFFECT
//!VERSION 1
//!NAME Mouse Test
//!CATEGORY Test
//!DESCRIPTION Test mouse position - shows spotlight that follows cursor, click to leave a mark
//!USE _DYNAMIC

// Mouse Test Effect
// - Spotlight follows mouse cursor
// - Click to leave a colored mark at click position
// - Shows current mouse coordinates

//!PARAMETER
//!LABEL Spotlight Size
//!DEFAULT 100
//!MIN 20
//!MAX 300
//!STEP 10
float spotlightSize;

//!PARAMETER
//!LABEL Spotlight Intensity
//!DEFAULT 0.5
//!MIN 0
//!MAX 1
//!STEP 0.05
float spotlightIntensity;

//!TEXTURE
Texture2D INPUT;

//!TEXTURE
Texture2D OUTPUT;

//!SAMPLER
//!FILTER LINEAR
SamplerState sam;

//!PASS 1
//!STYLE PS
//!IN INPUT
//!OUT OUTPUT

float4 Pass1(float2 pos) {
    float4 color = INPUT.SampleLevel(sam, pos, 0);
    uint2 outputSize = GetOutputSize();
    float2 pixelPos = pos * outputSize;

    // Get mouse data (xy=current pos, zw=click pos, all in normalized 0-1 coordinates)
    float4 mouse = GetMouse();
    float2 mousePos = abs(mouse.xy) * outputSize;
    float2 clickPos = abs(mouse.zw) * outputSize;
    bool isClicked = mouse.z > 0;

    // Spotlight effect following mouse
    float distToMouse = length(pixelPos - mousePos);
    float spotlight = 1.0 - smoothstep(0, spotlightSize, distToMouse);

    // Brighten around mouse cursor
    color.rgb = lerp(color.rgb, color.rgb + float3(0.3, 0.3, 0.3), spotlight * spotlightIntensity);

    // Show click marker (red when clicked, blue for last click position)
    float distToClick = length(pixelPos - clickPos);
    if (distToClick < 15) {
        float3 clickColor = isClicked ? float3(1, 0.2, 0.2) : float3(0.2, 0.2, 1);
        color.rgb = lerp(color.rgb, clickColor, 0.8);
    }

    // Draw crosshair at mouse position
    if (abs(pixelPos.x - mousePos.x) < 1 || abs(pixelPos.y - mousePos.y) < 1) {
        if (distToMouse < spotlightSize * 0.5 && distToMouse > 5) {
            color.rgb = lerp(color.rgb, float3(1, 1, 0), 0.5);
        }
    }

    return color;
}
