//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//!BGFX EFFECT
//!VERSION 1
//!NAME NNEDI3_nns256_win8x4
//!CATEGORY Neural Network
//!DESCRIPTION NNEDI3 - Neural network edge-directed interpolation for high-quality image upscaling

//!TEXTURE
Texture2D INPUT;

//!SAMPLER
//!FILTER POINT
SamplerState sam_INPUT;

//!TEXTURE
//!WIDTH  INPUT_WIDTH * 1 * 2
//!HEIGHT INPUT_HEIGHT * 2 * 1
Texture2D OUTPUT;

//!SAMPLER
//!FILTER LINEAR
SamplerState sam_INPUT_LINEAR;

//!TEXTURE
//!FORMAT R16_FLOAT
//!WIDTH  INPUT_WIDTH * 1
//!HEIGHT INPUT_HEIGHT * 2
Texture2D temp;

//!SAMPLER
//!FILTER POINT
SamplerState sam_temp;

//!COMMON
#include "prescalers.hlsli"

#define LAST_PASS 2

//!PASS 1
//!DESC NNEDI3 (double_y, nns256, win8x4)
//!IN INPUT
//!OUT temp
//!BLOCK_SIZE 32, 16
//!NUM_THREADS 32, 8
#pragma optionNV(inline none)
float nnedi3(vec4 samples[8]) {
	float sum = 0.0, sumsq = 0.0;
	[unroll] for (int i = 0; i < 8; i++) {
		sum += dot(samples[i], vec4(1.0, 1.0, 1.0, 1.0));
		sumsq += dot(samples[i], samples[i]);
	}
	float mstd0 = sum / 32.0;
	float mstd1 = sumsq / 32.0 - mstd0 * mstd0;
	float mstd2 = mix(0.0, inversesqrt(mstd1), mstd1 >= 1.192092896e-7);
	mstd1 *= mstd2;
	float vsum = 0.0, wsum = 0.0, sum1, sum2;
#define T(x) intBitsToFloat(x)
#define W(i, w0, w1, w2, w3) dot(samples[i], vec4(T(w0), T(w1), T(w2), T(w3)))
#define WS(w0, w1)                                                                                                     \
	sum1 = exp(sum1 * mstd2 + T(w0));                                                                                  \
	sum2 = sum2 * mstd2 + T(w1);                                                                                       \
	wsum += sum1;                                                                                                      \
	vsum += sum1 * (sum2 / (1.0 + abs(sum2)));
	sum1 = W(0, 1024871952, -1091961907, 1049937838, 1023328805) + W(1, 1026430476, -1103990249, 1052012307, 994719130)
		 + W(2, 1041094851, -1086639391, 1057524239, -1110763811)
		 + W(3, 992987016, -1085365048, 1063527595, -1102193240) + W(4, 1034372511, -1087585419, 1061081007, 1046466539)
		 + W(5, 1007997243, -1093414958, 1057188600, -1131716095)
		 + W(6, 1038248733, -1100793414, -1104832955, 1042167685)
		 + W(7, 1009484684, -1099588502, -1114088341, 1037858632);
	sum2 = W(0, -1122170202, -1115075619, -1113824159, 1016746290)
		 + W(1, -1117362461, 1050294809, 1022334174, 1016781702)
		 + W(2, -1125932452, 1041506545, -1098709995, 1031697879)
		 + W(3, -1100385246, -1100233118, -1104291570, 1033455014)
		 + W(4, 1020071642, -1100362988, 1072797337, 1050444141) + W(5, 1025043913, 1047005177, 1053652830, -1106922881)
		 + W(6, 1017078274, 1012082941, -1100425628, -1081909907)
		 + W(7, 1018043750, -1112302377, -1155649364, -1086585813);
	WS(-1096195455, 1061976972);
	sum1 =
		W(0, -1107583849, -1094469481, 1057261454, 1032308806) + W(1, 1045016510, -1104061589, 1051975353, 1046697387)
		+ W(2, -1102048399, -1082981042, 1058403546, -1093320254)
		+ W(3, 1050507709, -1086991635, 1061386858, 1051876218)
		+ W(4, -1138600128, -1087760032, 1052980216, -1106246183)
		+ W(5, 1004076226, -1088999402, 1052828202, -1112945129) + W(6, 1049677870, -1111975782, 1055128500, 1045880594)
		+ W(7, -1106918697, -1089081125, 1048525839, -1116677906);
	sum2 =
		W(0, 976892690, -1095110912, -1080663089, 1075827337) + W(1, 1043646796, -1114450783, -1074060607, 1075290035)
		+ W(2, -1131052969, 1052886335, -1068434194, 1070007941) + W(3, 1047930742, -1113296119, 1048011859, 1046007784)
		+ W(4, -1099144563, -1088067101, 1042920440, -1090506241)
		+ W(5, 1035354913, 1040578653, 1058047003, -1099371585)
		+ W(6, -1115191227, -1102673565, 1057110709, -1096675048)
		+ W(7, -1111106463, 1051335047, 1038060178, -1096378099);
	WS(-1095930303, -1128843438);
	sum1 = W(0, -1113225514, 1000563038, 1038763268, -1104281110)
		 + W(1, 1030842449, -1103461662, 1052682210, -1105449143)
		 + W(2, -1120882464, -1098779087, 1055587560, -1106219642)
		 + W(3, -1111398934, -1156245815, 1046999855, -1105879965)
		 + W(4, -1098488134, 1057689814, -1090605975, 1039743648)
		 + W(5, -1098728413, 1058114717, -1106232348, 1030902068)
		 + W(6, -1111237296, 1041725787, -1106563184, -1111582036)
		 + W(7, -1104159890, 1046074787, -1119168797, 1033984854);
	sum2 = W(0, -1109947141, -1078961084, 1053833634, 1049299145)
		 + W(1, -1087141194, -1081851502, -1102894339, 1040634467)
		 + W(2, 1007133897, 1057831088, 1046573470, 1035108031) + W(3, -1099413759, 1067440534, 1058568743, -1114324751)
		 + W(4, 1026690396, -1095618356, 1058025266, -1094447449)
		 + W(5, 1045509921, 1022398658, -1115002147, 1023241606) + W(6, -1117657274, 1029712906, -1109832065, 987652806)
		 + W(7, 1051942463, 1049871690, -1099467737, -1104714655);
	WS(1018627052, -1077328537);
	sum1 = W(0, -1107592280, -1098360952, 1054425801, -1121256842)
		 + W(1, 1011043872, -1103889731, 1045838144, 1016847523)
		 + W(2, -1138466445, -1088654431, 1063939041, -1114759963)
		 + W(3, 1041422472, -1079526160, 1057394281, -1109966789)
		 + W(4, -1112294435, -1109020730, 1061143403, -1115564074)
		 + W(5, 1012707679, -1095389295, 1057286118, -1117689671)
		 + W(6, -1150731309, -1102056896, 1040465365, -1133534770)
		 + W(7, -1118891707, -1101414784, 1042544156, 1028492087);
	sum2 =
		W(0, -1161717665, 1033867626, 1028201267, -1124228530) + W(1, -1138679732, -1115218580, -1096378423, 1029766795)
		+ W(2, -1121504639, 1030621655, 1071708903, -1128256742) + W(3, 1050854432, -1096361601, 1079482342, 1035298280)
		+ W(4, -1106511096, 1044499063, -1064184100, 1035336882)
		+ W(5, 1030373815, -1104067382, -1089118805, -1105361644) + W(6, 980628162, 1040061476, 1048273255, -1119150405)
		+ W(7, 1031200951, -1122098343, -1109436715, 1035049634);
	WS(1045693694, 1057374369);
	sum1 = W(0, 1048369598, 1034312519, -1131023893, -1099588978)
		 + W(1, -1104752283, 1045853799, -1098373234, 1019902402)
		 + W(2, 1031950009, 1057046586, -1095062180, -1105510198)
		 + W(3, -1123958928, 1065585622, -1089164628, 1033283356)
		 + W(4, -1103831441, 1061666460, -1092432965, -1115031649)
		 + W(5, -1106189273, 1060939321, -1087345809, -1122647270)
		 + W(6, -1103850789, 1050689810, -1092965100, -1126666680)
		 + W(7, -1110300085, 1060417841, -1091010256, -1103574093);
	sum2 = W(0, -1087427905, -1098709872, 1072153031, -1089481634)
		 + W(1, 1058683530, -1099141199, -1088885778, 1056590706)
		 + W(2, -1081734921, 1032637312, 1061509476, -1092495010) + W(3, 1050776004, 1072181481, 1071890032, 1048814690)
		 + W(4, 1042479954, 1036599206, 1052304550, -1095810808)
		 + W(5, 1025544982, -1080357543, -1080881103, -1097308566)
		 + W(6, -1105492903, -1113642582, 1050862866, -1094462248)
		 + W(7, 1058740427, -1086527647, -1078556244, 1039671439);
	WS(-1081549664, 1060153996);
	sum1 = W(0, 992286043, 1063391104, -1087586274, -1105647870)
		 + W(1, -1115318586, 1055271797, -1095899708, 1025423024)
		 + W(2, -1105782456, 1062019397, -1085498120, 1033921889)
		 + W(3, 1026471870, 1061503832, -1089250259, -1113405924)
		 + W(4, -1114468402, 1058772501, -1090055577, -1113674825)
		 + W(5, 1037910210, 1045594046, -1102496824, -1106446561)
		 + W(6, -1130210466, 1049908468, -1103786988, -1118412923)
		 + W(7, 1043803882, 1040755007, -1104619012, -1096097592);
	sum2 = W(0, 1053790549, -1080860351, -1068185653, -1082483044)
		 + W(1, -1110257416, -1097530578, -1077346152, -1088866791)
		 + W(2, 1033688102, 1041061421, 1052310674, 1052658871) + W(3, -1102619530, 1064966059, 1072556372, -1104178634)
		 + W(4, -1117483359, 1050344847, 1075004369, -1108410079)
		 + W(5, -1098152061, 1040479494, 1064749402, 1040931499)
		 + W(6, -1105743952, 1051151965, -1110156824, -1137891932)
		 + W(7, -1083553679, 1065962098, 1045213317, 1053124980);
	WS(-1079020096, -1097079011);
	sum1 = W(0, -1109501731, -1096742621, 1057943754, 1016000225)
		 + W(1, 1033910555, -1092191510, 1055662529, 1020967408)
		 + W(2, 1015347636, -1089091160, 1059647341, -1102027816)
		 + W(3, -1108027795, -1087072713, 1068092504, -1109882648)
		 + W(4, 1042979875, -1087558450, 1059824411, -1106889398)
		 + W(5, 1019929124, -1089417126, -1117499817, -1117366414)
		 + W(6, 1040369234, -1104831498, 1043480574, -1104827345)
		 + W(7, -1134559750, -1091818621, 1050143023, 1049289276);
	sum2 = W(0, 1037631964, -1097479797, 1051023588, 1045348435)
		 + W(1, -1105851814, 1051380185, -1097950410, 1028003104)
		 + W(2, 1036652885, 1028410699, 1034374804, -1113269608) + W(3, -1110757790, 1044594400, 1053237761, 1041832368)
		 + W(4, 1024508007, 1041068006, -1132209182, 1033918380)
		 + W(5, -1139201564, 1046036650, -1088293598, -1089693526)
		 + W(6, -1113225064, 1054960427, -1081781977, -1099925151)
		 + W(7, -1104657620, -1105334641, 1065714224, -1106359824);
	WS(-1087384991, 1052875812);
	sum1 = W(0, 1041733252, -1109905397, 1041497057, -1113613058)
		 + W(1, -1138647561, -1104994285, 1032882549, -1117825756)
		 + W(2, 1034391503, -1107522048, 1050093354, -1108789794)
		 + W(3, -1106477875, 1057597757, -1091247383, 1028766931)
		 + W(4, -1100509868, 1062613266, -1087942224, 1042722079)
		 + W(5, -1098694249, 1055828187, -1090201627, 1013355333)
		 + W(6, -1110959830, 1052485297, -1098203032, 1034047139)
		 + W(7, -1120730421, 1044647290, -1100016695, 1038812681);
	sum2 = W(0, 1019350107, 1041831066, 1051650697, -1103332568)
		 + W(1, -1111428867, -1130655130, -1112274143, -1077765094)
		 + W(2, 1017374087, -1138336400, -1092155273, -1073481211)
		 + W(3, -1112005123, 1035402260, -1114034096, -1087514353)
		 + W(4, 1028700445, -1116945124, 1045953881, 1069095754) + W(5, -1112772903, 1041636268, 1041190902, 1074086485)
		 + W(6, 1027823157, -1107238338, 1049171133, 1057277153) + W(7, 999439052, 1033528252, 1027833254, -1107727987);
	WS(1050457727, 1041689780);
	sum1 =
		W(0, -1131312139, 992358355, -1092744895, 1048008788) + W(1, -1116681402, 1014710691, 1027381214, 1036450832)
		+ W(2, 1030961105, 1040368912, -1089348299, 1053966377) + W(3, -1140959985, -1105027369, 1050737138, 933247243)
		+ W(4, 1046496193, -1089290871, 1038810352, 1043432004) + W(5, 1048638526, -1090315138, 1055368676, -1119062181)
		+ W(6, 1007270019, -1098770776, 1040416748, 1023583738) + W(7, 1049181764, -1086147588, 1051301702, 1037141075);
	sum2 =
		W(0, -1107193278, 1057496780, 1072935738, -1080570956) + W(1, 1019433289, 1031729137, -1080020989, 1054527180)
		+ W(2, 1039188525, 1037283932, -1078950448, -1096917141)
		+ W(3, -1123892633, -1086728254, -1087453268, 1050123895)
		+ W(4, 1039851328, -1087309268, 1051352061, 1053948249) + W(5, 1032631611, -1092570464, 1059438018, 1042769096)
		+ W(6, 1044641782, 1035754242, 1051006721, 1029707984) + W(7, -1097026795, 1063903066, 1056300653, -1106545458);
	WS(-1084263519, -1088250567);
	sum1 =
		W(0, -1107101246, 1048954180, -1118116730, -1111017296) + W(1, 1049480649, -1096698757, 1027018719, 1043604572)
		+ W(2, -1097447514, 1059331526, -1108150329, -1098833704)
		+ W(3, 1049647488, -1119095878, -1090501921, 1050343697)
		+ W(4, -1099235545, 1040553109, 1044929028, -1096264890) + W(5, 1018612505, 1041330418, -1094468036, 1044030041)
		+ W(6, -1103944776, 1040723088, 1047463532, -1121471547)
		+ W(7, 1032447885, 1023387386, -1106285556, -1175819022);
	sum2 = W(0, 991719940, -1157381748, -1100952734, 1029794653) + W(1, 1034086314, -1121095386, 1027786887, 1016292894)
		 + W(2, 1055828179, -1103829652, -1085350121, 1067178121)
		 + W(3, 1034571486, -1100672658, -1118546758, -1098007098)
		 + W(4, 1049088345, -1090417467, 1049271738, 1008607005)
		 + W(5, -1098363481, 1050795943, -1140682323, -1110134488)
		 + W(6, -1111430799, -1113801830, 1035813474, -1115483467)
		 + W(7, -1111365517, 1037803588, -1164121191, -1133015817);
	WS(1066054400, -1125664425);
	sum1 = W(0, 1015260777, 1054574294, -1095241461, -1127045294)
		 + W(1, -1108545200, 1053284635, -1094415406, -1111343263)
		 + W(2, 1023624464, 1059735702, -1088764634, 1041542629)
		 + W(3, -1109354663, 1058150961, -1078845388, -1130514988)
		 + W(4, 1023465234, 1058102002, -1090401103, 1035892576)
		 + W(5, -1108921531, 1063397581, -1105651068, -1136829776)
		 + W(6, -1116445024, 1046571067, -1116790272, 1030749305)
		 + W(7, -1128865616, 1046728251, -1104354311, -1106930027);
	sum2 = W(0, 1041565398, -1104697837, -1115419200, -1158883614)
		 + W(1, -1103469615, 1029373537, 1031260861, 1035036640) + W(2, 1029690269, 1057447179, 1026403525, 1034486240)
		 + W(3, 1035794320, 1080145714, 1043319440, 1041655252) + W(4, 1035452008, -1103623095, 1050811672, -1114789346)
		 + W(5, -1107146771, -1066097425, -1103531154, -1114794272)
		 + W(6, -1124704946, -1097535851, -1090176537, 1036709484)
		 + W(7, 1040850628, -1103109309, 1055196268, -1102936938);
	WS(-1087901375, 1071177135);
	sum1 =
		W(0, -1121594272, -1110224028, 1030219348, 994425384) + W(1, -1122618691, -1109965218, 1047787782, 1027034090)
		+ W(2, -1114434254, -1120206908, -1114914192, -1106192913)
		+ W(3, 1044010486, 1010935165, -1113546820, 1040356168)
		+ W(4, -1113833999, -1108541318, 1046030645, -1112701798)
		+ W(5, -1108159437, 1041417229, 1035224125, -1130438655) + W(6, 997526195, -1109330685, 1017890711, -1151173965)
		+ W(7, -1123472883, 1039497451, 1022061139, -1125745551);
	sum2 = W(0, 1042217679, -1116367239, 1026421701, -1140328609)
		 + W(1, -1108814485, 1042859710, 1027395369, -1114630403)
		 + W(2, 1058334461, -1078638996, 1028343990, -1105295199)
		 + W(3, -1080767453, 1073929687, -1097310248, 1028261520)
		 + W(4, 1050991857, -1092080339, 1042808122, -1122297114)
		 + W(5, 1030602271, -1116721722, 1051491707, -1105219597) + W(6, 1034906705, -1106162437, 1024141024, 997359482)
		 + W(7, -1127683613, 1035114111, -1112071525, 1017171678);
	WS(1066545696, -1154623394);
	sum1 =
		W(0, -1105442505, -1114054203, 1057182265, -1123432545) + W(1, -1115505461, -1098488296, 1049322687, 1010507424)
		+ W(2, -1102287846, -1092352928, 1062190966, -1097309632)
		+ W(3, 1023914903, -1089108436, 1059635472, 1045294808) + W(4, 1021900696, -1087887754, 1057132007, -1098559779)
		+ W(5, 1016559928, -1096061654, 1043675118, 1042399967)
		+ W(6, -1142506442, -1097827287, 1048482034, -1110816589)
		+ W(7, -1129232035, -1095543703, 1055016957, 1026256390);
	sum2 =
		W(0, -1094410020, 1040526244, 1038890507, -1120085021) + W(1, -1073520568, -1119660436, -1105577163, 1014274624)
		+ W(2, -1076806727, 1072065972, 1038803075, -1119386280) + W(3, 1007932024, 1074284701, -1096715819, 1032586275)
		+ W(4, -1129053184, 1045336233, 1048625414, -1148623280)
		+ W(5, -1126774165, -1114285571, -1106066396, 1033069015)
		+ W(6, 1016297320, 1027498382, 1035667090, -1113847206)
		+ W(7, 1026440100, -1109537500, -1128514892, 1028560484);
	WS(1055250687, -1106970626);
	sum1 = W(0, 1033119688, 1042190962, -1096546392, -1117586055)
		 + W(1, -1105149829, 1055784922, -1103230410, -1125652468)
		 + W(2, 1043588463, 1039447718, -1093610964, 1035816565)
		 + W(3, -1098690473, 1060328969, -1094495495, -1103963220)
		 + W(4, 1051357302, -1105877415, -1104321127, 1047255951)
		 + W(5, -1111820283, 1050469874, -1102978667, -1108600424)
		 + W(6, 1036109552, -1123255849, 1034127854, -1157028943)
		 + W(7, -1119401059, 1044861546, -1097968467, 1018776031);
	sum2 = W(0, 1038757267, 1030211853, 1033894636, -1133782171)
		 + W(1, -1111076574, -1147844455, 1039985174, -1117005539)
		 + W(2, 1036628998, 1002666567, -1092985165, -1150866734)
		 + W(3, -1107631850, -1080902130, -1084645521, 1049641986)
		 + W(4, 1045867530, -1089131777, 1069738325, 1051354211)
		 + W(5, -1126199158, 1067727291, -1096580382, -1100550183)
		 + W(6, 1034641438, 1050167793, -1100096489, -1104598763)
		 + W(7, 1014361489, -1114432338, -1100261485, 1033251244);
	WS(1063662431, 1022143153);
	sum1 =
		W(0, -1101665898, 1028101088, 1045825111, -1107336877) + W(1, 1044567949, -1100200043, -1112112432, 1049135824)
		+ W(2, -1113912242, -1110575390, 1011332621, -1117269540)
		+ W(3, 1054985008, -1090770105, 1036354680, 1043762234) + W(4, -1089448239, 1042239925, 1053092900, -1090665684)
		+ W(5, 1031890901, 1034205190, 1020582213, 1045380738) + W(6, -1106608329, 1041117720, -1122250931, -1108114694)
		+ W(7, 1016341751, 1032506575, 1037368233, 1027635960);
	sum2 =
		W(0, -1109621945, 995625223, 1033690799, -1127273987) + W(1, 1044140338, -1125871763, -1131300267, 1031533647)
		+ W(2, 1011973298, 1059194369, 1019603073, -1100093028) + W(3, 1054192939, -1085775903, -1105557074, 1049649037)
		+ W(4, -1083519810, -1085690186, 1066625604, -1099380904)
		+ W(5, 1050669158, 1055305067, -1093331249, 1041330252) + W(6, 1015542539, -1115586758, 1025625789, -1109873113)
		+ W(7, 1007706050, 1024423563, -1163078190, 1021669909);
	WS(1065395904, 1046290614);
	sum1 = W(0, 996799560, -1125542553, 1038203972, -1122586727) + W(1, 1015596034, 1043656950, -1105153011, 1036793959)
		 + W(2, -1100668872, 1056396433, -1085640859, 1049715632)
		 + W(3, -1100927819, 1054862894, -1101762943, 1035554923)
		 + W(4, 1043886221, -1088911438, 1057024083, -1115152096)
		 + W(5, 1025322396, -1099487682, 1036429768, -1122121748)
		 + W(6, 1035443240, -1105531411, 1021072448, 1039652277)
		 + W(7, -1114934548, -1117673547, 1035195023, 1024299964);
	sum2 = W(0, 1029237671, 1017509749, -1104176053, 1032328729)
		 + W(1, -1133651707, -1140172751, 1038596873, 1037378915)
		 + W(2, -1114304490, 1030543605, 1050264307, -1104642832)
		 + W(3, -1114162505, -1092617066, -1093179067, 1049979232)
		 + W(4, -1125875827, 1051105475, 1071302855, -1110244360)
		 + W(5, -1112015576, 1033357967, -1090684841, -1085540383)
		 + W(6, 1015895733, 1011455075, -1100815852, -1135016203)
		 + W(7, 1035088799, -1105982664, 1003487558, 1015899853);
	WS(1058730335, 1038095077);
	sum1 = W(0, 1050009523, -1090412329, -1116071407, -1120619710)
		 + W(1, -1156396202, 1022785342, -1112028282, 1033123659) + W(2, 1045232946, 990514519, 1027669243, -1138222105)
		 + W(3, -1123440788, 1051849503, 1025171300, 1042856679) + W(4, 994853272, 1050259497, -1091444451, 1043400402)
		 + W(5, 1029074928, 1048747736, -1091116387, 1046148791)
		 + W(6, -1116532263, 1040337077, -1095024325, 1031722640)
		 + W(7, 1016043038, 1047238893, -1085293672, 1050565349);
	sum2 = W(0, 1046272294, 1056160584, -1069609928, -1086350256)
		 + W(1, -1119023958, 1047372879, -1100807597, 1012350161)
		 + W(2, -1106071503, 1066704996, 1063602974, -1093103672)
		 + W(3, -1097641458, 1062851774, 1071319304, -1165704932)
		 + W(4, -1099339001, -1127558738, -1123458905, -1099266547)
		 + W(5, -1122591395, -1095719050, 1049925865, 1039176837)
		 + W(6, -1120322169, 1012197993, 1037702687, -1104052164)
		 + W(7, -1112624405, -1094334166, 1046841945, 1043315186);
	WS(-1102208382, 1082454872);
	sum1 = W(0, -1121527792, -1097489215, 1044710709, 1024559218)
		 + W(1, 1019782131, -1109352802, 1043005718, 1025756170)
		 + W(2, -1111677734, -1089475261, 1059136208, -1098383546)
		 + W(3, 1042764822, -1094323164, -1113184692, 1034230961)
		 + W(4, -1098291428, 1057233791, -1102862820, -1121795355)
		 + W(5, -1109244559, 1055571354, -1113821821, 1034138424)
		 + W(6, -1122839755, 1036609181, 1016630678, -1148370726)
		 + W(7, 1023050790, 1023873367, -1122283881, 1021065311);
	sum2 = W(0, 1012975921, -1113722375, -1109752074, 1009270385)
		 + W(1, 1033684352, -1113902527, -1108511603, 1034062718)
		 + W(2, -1119837718, 1034379158, 1047596894, -1096952633) + W(3, 1048900749, 1065557700, 1065261424, 1042274647)
		 + W(4, -1088385914, 1033601684, -1110433219, -1110816087)
		 + W(5, -1106132930, -1078602486, -1113936114, 1038223706)
		 + W(6, -1107812043, 1048231286, -1106600777, 1037668398)
		 + W(7, 1047279942, -1117907500, -1110420048, -1111923151);
	WS(1055139903, 1066543323);
	sum1 = W(0, -1113216706, 1025777755, 1062476912, -1094834883)
		 + W(1, 1034160554, -1106690282, 1047449287, -1115394087)
		 + W(2, -1110997976, 1025857819, 1040533578, -1100641176)
		 + W(3, -1104052311, -1108040417, -1088276389, -1109281747)
		 + W(4, -1130057219, 1042814916, 1043316038, -1111790927)
		 + W(5, -1100344024, 1058801014, -1096553156, -1131081926)
		 + W(6, -1109060119, 1040801319, 1003175286, -1127882001)
		 + W(7, -1102181302, 1061190298, -1109923206, -1116502963);
	sum2 = W(0, 1032900543, -1093611286, -1093105706, -1103368978)
		 + W(1, 1026043047, -1143136704, -1104881087, 996537094)
		 + W(2, 1011969739, -1129502699, 1056641171, -1097512177) + W(3, 1005946567, 1065137024, 1062580590, 1038772124)
		 + W(4, -1104378201, 1034934846, -1137732946, -1108835309)
		 + W(5, -1106573410, 1044311979, -1102271464, 1035638256)
		 + W(6, -1149079854, -1128312106, -1106196955, 1028654910)
		 + W(7, -1098913457, -1107526541, -1097055308, -1144299515);
	WS(1037662203, -1095462961);
	sum1 =
		W(0, 1051208476, 1054332722, -1088537607, 1009988859) + W(1, 1007151360, 1048962332, -1096098779, -1120684294)
		+ W(2, 1047867778, 1056131053, -1089718811, 1043868050) + W(3, -1120692693, 1060311124, -1086623130, 1008468855)
		+ W(4, -1102286423, 1053179033, -1088149909, 1024446024) + W(5, 1029685138, 1057524976, -1093380227, 1041242535)
		+ W(6, -1117174983, 1045179237, -1094989189, -1121112609)
		+ W(7, 998066935, 1053688986, -1094538289, 1022948968);
	sum2 = W(0, -1075642964, 1064397427, 1042055631, 1049259770)
		 + W(1, -1078284587, 1070403917, 1050515956, -1100572061)
		 + W(2, -1077677369, 1072178178, -1094922849, 1038272909)
		 + W(3, -1086975712, 1071930150, -1096417404, -1110188613)
		 + W(4, 1050575143, -1093947328, -1094640520, 1033007627)
		 + W(5, -1109971278, -1119680819, 1045435393, -1109186235)
		 + W(6, 1043550667, -1134729809, -1109099138, 1040318497)
		 + W(7, 1046375822, -1094009133, -1106076462, 1038207101);
	WS(-1091974591, 1028524890);
	sum1 =
		W(0, -1119527298, 1050666155, -1104886813, -1119869997) + W(1, 1034997099, -1101120961, -1100807815, 1044100139)
		+ W(2, -1099802012, 1057798952, -1099838668, -1103774309)
		+ W(3, 1033463662, -1146674958, 1021707158, -1112176434)
		+ W(4, -1090658116, 1048486316, 1057612011, -1094617942) + W(5, 1044419888, 1054164791, -1093871840, 1036492177)
		+ W(6, -1099353751, 1033437822, 1029138830, -1113521820)
		+ W(7, -1110855131, 1053708795, -1104286795, 1028051362);
	sum2 =
		W(0, 1029285075, -1114745613, 1024121756, -1127985632) + W(1, -1113245689, 1037297246, 1034295695, -1103172653)
		+ W(2, 1046869988, -1113507597, -1081105309, -1097344586)
		+ W(3, -1099734421, 1057852752, 1063764387, -1092930743) + W(4, 1045806866, 1031538739, -1093953622, 1039548141)
		+ W(5, -1099048447, 1019950674, 1060684479, -1113791115) + W(6, 1040440310, 1039903515, -1099720743, 1024790472)
		+ W(7, -1129472848, -1115367833, 1051222485, -1106398082);
	WS(1058893599, -1078409713);
	sum1 =
		W(0, -1115244150, -1102829117, 1039336887, -1115623287) + W(1, 1036724056, -1100240992, 1053376406, -1114512019)
		+ W(2, -1098555735, -1094663483, 1053054383, 1041993169) + W(3, 1049246955, -1084866106, 1065100884, 1018575674)
		+ W(4, 1045222582, -1085064800, 1054590883, -1114852275)
		+ W(5, -1138283737, -1093243506, 1056764679, -1108377677)
		+ W(6, 1044966206, -1093950047, 1053059489, -1118180448)
		+ W(7, -1115412967, -1095580366, 1050610273, -1122449691);
	sum2 = W(0, -1130929736, -1101060123, 1045192083, -1105822172)
		 + W(1, 1009552185, -1090337753, 1061442923, -1103557108)
		 + W(2, -1084383778, 1072779570, 1050903982, -1106762492)
		 + W(3, 1050909748, 1053567468, -1089269841, -1117595750)
		 + W(4, 1049209322, -1079161361, 1029505799, -1111371347)
		 + W(5, -1096700837, 1057662166, -1094014597, 1025228376)
		 + W(6, 1051369678, -1097661058, 1046387683, -1138825972)
		 + W(7, -1129474226, -1112521942, -1105984421, 1030887459);
	WS(-1109369595, 1048740969);
	sum1 =
		W(0, 1040995480, 1051718495, -1091711555, -1125552391) + W(1, 1030414773, 1050319297, -1095167863, 1032958437)
		+ W(2, -1118646413, 1059003715, -1085356599, 1042985722) + W(3, 1043594790, 1046504696, -1083562713, 1045509569)
		+ W(4, -1129436350, -1135436979, -1096690237, 1023899916)
		+ W(5, 1037121811, 1043825845, -1098326935, 1019546753) + W(6, 1030207412, 1049475887, -1120665100, -1130219052)
		+ W(7, 1043560049, 1058279379, -1098718953, -1105013544);
	sum2 = W(0, -1113177829, -1117552581, -1100446453, 1041583669)
		 + W(1, 1043809265, -1109343151, 1039662186, 1009024316)
		 + W(2, -1095416462, 1052574118, -1114145263, -1118793923)
		 + W(3, 1034071291, 1063553374, 1053677817, 1018689733) + W(4, -1120341831, 1070912061, -1101063801, 1031195477)
		 + W(5, 1043900974, -1112203792, 1042882834, -1105538343)
		 + W(6, 1020015593, -1091338378, -1094258913, -1114748986)
		 + W(7, -1119209873, -1072794661, 1055602011, -1109237633);
	WS(-1093437503, 1065718162);
	sum1 =
		W(0, 1037550096, 1049488055, -1103061781, -1114711965) + W(1, -1101135841, 1042594425, 1046266118, -1097873069)
		+ W(2, 1044878747, 1049041945, -1087470164, 1046063170)
		+ W(3, -1107014286, 1066142676, -1106438298, -1091362312)
		+ W(4, 1042111087, -1100146203, -1111606545, 1037494709) + W(5, 1037051057, 1045825417, -1091131027, 1040258368)
		+ W(6, -1099961615, 1040663590, -1133427370, -1109172298)
		+ W(7, 1041500301, -1119554198, -1103590594, 1033770775);
	sum2 =
		W(0, -1106488910, -1123106758, 1050172947, -1124712996) + W(1, 1026201604, -1113590739, -1092748399, 1043391307)
		+ W(2, 1035711566, -1084666863, -1097703384, -1098783459)
		+ W(3, 1060425407, 1061776657, -1099741350, 1048423650) + W(4, -1098764525, 1055047321, -1120322586, 1041036039)
		+ W(5, -1096618367, -1119175762, 1050324229, -1099280352)
		+ W(6, -1182808622, -1103500958, 1025620288, 1048645442)
		+ W(7, -1127820908, 1041613778, -1105222946, -1118590758);
	WS(1056660607, -1113798601);
	sum1 = W(0, -1115305597, 1041913228, 1012656821, 1026504084) + W(1, -1101671294, 1008348404, 998498191, -1151777337)
		 + W(2, 1016801995, 1031963795, -1102006873, 1032505286)
		 + W(3, 1039904137, -1093680051, 1057450908, -1108358078)
		 + W(4, 1037148876, -1089471492, 1049874551, 1031920291) + W(5, 1040453028, 1034024758, -1111681498, 1043455038)
		 + W(6, -1110559226, -1111400057, -1109457443, -1129849213)
		 + W(7, -1154296528, 1031051312, 1036430914, -1125050675);
	sum2 = W(0, 1042939003, 1024638457, -1123927190, 998901155) + W(1, -1114796094, -1101207597, 1042777565, 1022659417)
		 + W(2, 1044529628, 1027593065, -1098782283, 1017512357)
		 + W(3, -1124781020, -1097759574, 1059165645, -1104939928)
		 + W(4, -1106748864, -1130307786, 1062760553, -1098668376)
		 + W(5, 1016881133, 1033669310, 1017094385, -1089791762)
		 + W(6, -1108227590, 1022409637, -1160993898, -1106217568)
		 + W(7, 1027959261, 1019735589, -1125388747, -1115680109);
	WS(1066155712, 1004288134);
	sum1 = W(0, 1047132567, 1049267618, -1089062279, -1138510971)
		 + W(1, 1029697589, 1048612844, -1092380195, 1046969501) + W(2, 1014062303, 1055750611, -1088453014, 1024451359)
		 + W(3, 1041631965, 1059093756, -1084647474, 1049129552) + W(4, 991515041, 1057479944, -1091963789, 1040560290)
		 + W(5, -1123217244, 1056993158, -1088742789, 1043007167)
		 + W(6, -1154741365, 1047138005, -1098495965, -1122630737)
		 + W(7, 1030265807, 1055767146, -1086886676, -1122583780);
	sum2 = W(0, 1011892235, 1040858440, -1127819845, 1010964983)
		 + W(1, -1111382628, -1103755803, -1109875610, -1106716388)
		 + W(2, 1037768402, -1125277089, -1096621612, 1032593498)
		 + W(3, 1032283234, -1084511950, -1071556311, 1040462902)
		 + W(4, -1114728106, -1090323786, -1071973667, -1100404332)
		 + W(5, 1009460031, -1159433014, -1099343032, 1040394500)
		 + W(6, -1112526532, 1053584755, 1076043190, 1007208771) + W(7, 1030203700, 1052886875, 1079690007, 1051792925);
	WS(-1086041375, 1049976369);
	sum1 =
		W(0, -1125608345, -1096855193, 1037693680, 1048607039) + W(1, 1025261033, -1097190986, 1051176741, 1030637974)
		+ W(2, 1032012444, -1086237883, 1059434222, 1026121224) + W(3, 1046732297, -1083643033, 1062665585, -1103554484)
		+ W(4, -1114869141, -1093631755, 1052924527, -1110078044)
		+ W(5, 1036081274, -1095059844, 1052562329, -1109004102) + W(6, 1036645660, -1132519191, 1041010310, 1035782593)
		+ W(7, -1119140736, -1095180224, 1048775023, -1118200972);
	sum2 =
		W(0, 1029601330, -1115199196, -1096390757, -1079547524)
		+ W(1, -1144560396, 1026958814, -1100298556, -1081990625) + W(2, 1032763954, 1032369083, 1076866217, 1041174181)
		+ W(3, -1115106220, -1106065675, -1108884178, 1041059708)
		+ W(4, -1111454114, 1042189754, -1116766618, 1024602232)
		+ W(5, -1121335223, 1029124674, 1025985538, -1127158528)
		+ W(6, -1109520646, 1022674491, -1115268590, 1007020790) + W(7, 1021645795, 1026253022, 1011072742, 1003377428);
	WS(-1111980027, 1060626277);
	sum1 = W(0, 1023621139, -1102882983, 1044706422, 1028429765)
		 + W(1, 1032179266, -1092055397, 1043529367, -1113080214)
		 + W(2, 1030954414, -1089823274, 1057090380, -1101761443)
		 + W(3, 1037158526, -1095093232, 1064981515, -1098683411)
		 + W(4, 1036765152, -1090725010, 1047303429, 1033439719) + W(5, 1036680203, -1139402199, 1042557255, 1030304674)
		 + W(6, -1146606447, -1116432156, 1028925358, -1104492078)
		 + W(7, -1119312598, -1108873773, 1041638915, -1112219839);
	sum2 =
		W(0, -1107703976, 1045439570, 1032849260, -1122224669) + W(1, 1046455264, -1090239140, -1096329612, 1035962913)
		+ W(2, -1093472442, 1028879562, 1030082819, -1098806672) + W(3, 1048924762, 1064195571, 1036056807, 1041148911)
		+ W(4, -1097201227, 1016778259, 1059898488, -1091828205) + W(5, 1049435664, 1027385222, -1091675747, 1041687668)
		+ W(6, -1106239872, 1028121257, 1053658286, -1098243254)
		+ W(7, -1119402461, -1105208479, -1117889585, -1104565052);
	WS(1062681599, 1040842201);
	sum1 =
		W(0, -1108789463, -1104300209, 1042117608, -1118282400)
		+ W(1, -1115361429, 1050445194, -1097788769, -1114475276)
		+ W(2, 1048981817, -1089127203, 1032428200, 1049574381) + W(3, -1092926921, 1063952639, 1049970971, -1090427073)
		+ W(4, 1054602509, 1043197406, -1088418847, 1045778638) + W(5, 1029602904, -1106041808, 1049956321, -1112080775)
		+ W(6, -1117967305, 1039191171, -1112931212, -1097758566)
		+ W(7, 1025443329, -1114238594, -1123051255, 1033393295);
	sum2 = W(0, 1038735267, -1126315713, -1111714958, -1111656758)
		 + W(1, -1100048068, 1043050536, -1115313021, -1115683900)
		 + W(2, -1115453090, 1053683464, 1046662525, -1093358619)
		 + W(3, -1110884051, 1058830244, 1061563017, -1105966973)
		 + W(4, -1090743949, -1100540415, 1052621807, 1037413595)
		 + W(5, -1153955669, 1037942519, -1104363663, -1101879362)
		 + W(6, -1112598570, -1098889179, -1118760183, 1044482581)
		 + W(7, -1103797208, 1040830228, 1007755797, -1098877089);
	WS(1062776447, 1069975051);
	sum1 = W(0, -1130308944, 1036893844, -1104137265, -1108240801)
		 + W(1, -1112835078, -1114635034, -1098478453, 1029922778)
		 + W(2, -1113144126, 1050058840, -1104852259, -1111877761)
		 + W(3, -1094805377, 1071110128, 1041368142, -1088740684)
		 + W(4, -1098008538, 1061455014, -1095764665, -1112520550)
		 + W(5, -1114270939, 1044746969, -1109080309, -1119589855)
		 + W(6, -1117364667, 1018226642, -1103882015, -1121527653)
		 + W(7, -1117827459, 1049407081, -1120810969, -1103102129);
	sum2 = W(0, 1028834725, -1113117380, 1037052904, -1113210551) + W(1, -1110297977, 1026197871, 996515330, 1032917698)
		 + W(2, 1035091068, -1099362318, 1043940575, -1106692355)
		 + W(3, 1034973002, 1077416661, -1069860026, -1103487680) + W(4, -1110025415, 1050456944, 969317772, 1034055293)
		 + W(5, -1154986018, -1112814852, 1021906202, 1006658352)
		 + W(6, -1120031976, 1027999489, -1115577362, 1018186436)
		 + W(7, 1030684381, 1016280910, 1013156184, -1124181989);
	WS(-1082599007, -1084302409);
	sum1 =
		W(0, -1127095446, 1056665680, -1087212124, 1035858193) + W(1, 1011517278, 1052281350, -1096260148, -1128228554)
		+ W(2, -1110892475, 1058821842, -1085877656, 1043137767) + W(3, 1024933540, 1061132051, -1087957451, 1023709101)
		+ W(4, -1111586789, 1054434479, -1089270826, 1037286635)
		+ W(5, 1039136849, 1052720805, -1102718609, -1111842501)
		+ W(6, -1108207315, 1043783817, -1106422582, -1130056576)
		+ W(7, 1049617952, -1159632952, -1106709957, -1115207149);
	sum2 = W(0, 1048459811, -1095160239, 1026509768, -1123792544)
		 + W(1, 1071226724, 1065850492, 1043007163, -1127547903) + W(2, 1075494724, -1121381976, 1043168485, 1027169380)
		 + W(3, 1074401127, -1099027008, -1093896652, -1107011198)
		 + W(4, 1044864951, 1031151008, 1012395574, 1037067951) + W(5, -1077687291, 1057399482, 1019701051, 1021690579)
		 + W(6, -1072311776, 1045213405, -1109946848, -1124089088)
		 + W(7, -1066953112, -1095971461, 1027278540, -1166810856);
	WS(-1118215158, -1130722305);
	sum1 = W(0, 1039784439, 1045520358, -1094865274, 966095017)
		 + W(1, -1119983743, 1040649785, -1098235299, -1166742058)
		 + W(2, 1027132090, -1126797149, -1085881139, 1023429181)
		 + W(3, -1101267710, 1070303194, -1106608186, -1127173569)
		 + W(4, -1106141431, 1059129261, -1088850304, -1112024885)
		 + W(5, -1119840977, 1056727436, -1093134907, 1030946302)
		 + W(6, -1131926580, 1040938982, -1098615277, -1160489077)
		 + W(7, -1158357571, 1050582583, -1104503154, -1106263629);
	sum2 = W(0, -1122933952, 1043676402, -1122578476, 1034421913)
		 + W(1, 1029904221, -1092335308, -1096734640, -1121365342)
		 + W(2, -1104768174, 1050667883, -1067932755, -1103315560)
		 + W(3, 1044174015, -1106663265, 1078656606, 1049347404) + W(4, -1122786276, 1035773679, 1056344301, 1027752905)
		 + W(5, 1032455763, 1033986578, -1106732625, -1114333025)
		 + W(6, -1118952582, -1123822916, 1033374173, 1025409455)
		 + W(7, -1120585334, 1030027555, -1116084330, -1129253837);
	WS(-1112296443, -1083191171);
	sum1 =
		W(0, 1030599873, 1049894985, -1100141489, -1124642344) + W(1, -1102688301, 1052276159, -1095734081, -1114229790)
		+ W(2, 1038739494, 1055519004, 1044438853, 1039505712) + W(3, -1091052013, 1061107959, -1078809864, -1108354137)
		+ W(4, -1120252367, 1059731464, -1100785926, 1037196526)
		+ W(5, -1118018759, 1052059899, -1095185489, -1129006466)
		+ W(6, -1105737735, 1050382861, -1092887220, 1034647259)
		+ W(7, 1036799090, 1050879021, -1113977245, -1123394945);
	sum2 =
		W(0, -1134366274, 1032198029, -1102569648, -1113629492) + W(1, 1040286055, -1093721101, 1059013351, -1099320981)
		+ W(2, -1103185345, 1064064153, -1076328416, 1062572765)
		+ W(3, -1089934078, 1038410574, 1075980540, -1079072621)
		+ W(4, -1104699884, 1053501328, -1081344728, 1057269325)
		+ W(5, -1135474394, 1053898256, -1093863519, 1039501040)
		+ W(6, 1039368980, -1088730122, 1061819985, -1089994189) + W(7, 984214720, 1045555557, -1089334779, 1050815727);
	WS(1051639487, -1077445112);
	sum1 = W(0, 1023584208, -1087680633, 1058381481, 1019116206)
		 + W(1, 1019039018, -1097242582, 1049175941, -1110819225)
		 + W(2, 1046978951, -1087958558, 1059595066, 1041321753)
		 + W(3, -1114024277, -1084584703, 1058705186, -1110784681)
		 + W(4, 1042440780, -1089578188, 1060807824, -1120949436)
		 + W(5, 1036430651, -1090497932, 1057261083, -1111841304)
		 + W(6, 1019910405, -1100840226, 1047705823, -1108976675)
		 + W(7, 1017051223, -1089989738, 1052092149, 1037750032);
	sum2 = W(0, -1103483317, 1043027417, 1043672886, -1126025102)
		 + W(1, -1103949071, 1024633771, -1105891820, -1101612494)
		 + W(2, 1036613850, 1050158855, -1113242263, 1051748473)
		 + W(3, -1096200772, -1096718424, 1053817256, -1144187697)
		 + W(4, -1094761445, 1057240079, 1043447632, -1129269697)
		 + W(5, -1090478844, 1037855330, 1053166295, -1114569970)
		 + W(6, -1091384835, 1036780676, 1043680942, -1102484885)
		 + W(7, 1024429003, -1103545669, 1034776200, 1044262941);
	WS(-1102141694, 1066754929);
	sum1 =
		W(0, 1024767465, -1097150806, -1121670572, 1047316983) + W(1, 1028037205, -1105574095, 1021251426, -1123186307)
		+ W(2, -1148374821, -1092607882, 1053426631, 1027553675) + W(3, 996156698, -1086231302, 1064662112, 1037457517)
		+ W(4, 1034886379, -1085570014, 1060264850, -1103359865) + W(5, 1011245536, -1090150659, 1058905527, 1031219256)
		+ W(6, 1017269224, -1093685286, 1047037217, -1108923303)
		+ W(7, 1023537404, -1100403588, 1048736520, 1039125668);
	sum2 = W(0, -1127568330, 1005444026, -1099850392, -1069105992)
		 + W(1, 1031019669, -1121000217, 1052911126, -1075891845)
		 + W(2, 1013355589, -1135062981, 1040255711, 1052106082)
		 + W(3, -1123247753, -1099801823, -1120914990, 1078854269)
		 + W(4, -1131101666, 1044314830, 1055431083, 1061745892)
		 + W(5, -1126559289, 1052295626, -1112663055, -1097592921)
		 + W(6, -1128009624, -1112001042, 1029993103, 1033712114)
		 + W(7, -1122774763, 1018744598, -1105142519, 1037317546);
	WS(-1092827839, 1049601702);
	sum1 =
		W(0, -1102748075, -1114726817, 1043768535, 1001409895) + W(1, 1048973336, -1100496851, 1037939345, 1025584388)
		+ W(2, -1101661842, 1056141590, -1092531310, 1043222609) + W(3, 1035794226, -1092935501, 1048278549, 1028885900)
		+ W(4, 1035295380, -1090189951, 1059458263, -1097823129) + W(5, 951002293, -1127762491, -1107678146, 1046084402)
		+ W(6, 1028700102, -1107070641, 1040739973, 1018269854)
		+ W(7, 1019995195, -1116434785, -1103464157, 1033486885);
	sum2 = W(0, 1047648616, -1099866854, 1040911688, -1104812914)
		 + W(1, 1049954711, -1087014785, -1127547935, 1032774583)
		 + W(2, -1086499077, 1059941103, 1006897087, -1118719608)
		 + W(3, 1036131868, 1059724034, -1147690453, -1112213150)
		 + W(4, 1021844703, -1104253425, -1094365093, 1020986307)
		 + W(5, -1144052469, -1116739540, 1046092804, 1037506252)
		 + W(6, 1036766656, -1123734224, -1117733622, 1020773629)
		 + W(7, -1114852932, -1119117496, 1045874226, -1120467144);
	WS(1062974879, -1132215613);
	sum1 = W(0, -1181157822, -1096960767, 1047884458, 1046591191)
		 + W(1, 1033235448, -1103300066, 1024586364, 1028472621)
		 + W(2, -1120645311, -1098273063, 1040665968, 1027902609)
		 + W(3, 1032693326, -1084817024, 1065496294, -1105457745)
		 + W(4, 1014937094, -1086871647, 1061273423, -1099580452)
		 + W(5, 1012846527, -1093312183, 1057013666, -1121668195)
		 + W(6, 1029466479, -1094276984, 1048826162, -1123904424)
		 + W(7, 1027727527, -1099477807, 1049029078, 1033797162);
	sum2 = W(0, -1120861164, -1114727130, 1051943787, 1073213517)
		 + W(1, 1023555157, -1127207629, 1021361633, 1067585393)
		 + W(2, -1114715157, 1049207316, -1100379929, -1095215585)
		 + W(3, 1039733942, -1100512081, 1049204344, -1072102567)
		 + W(4, -1111876903, 1044392032, 1029680046, -1085077901)
		 + W(5, -1121732899, -1113639142, 1040523175, 1017790060)
		 + W(6, 1028106223, -1107243417, -1113800818, -1115100698)
		 + W(7, -1136150442, 1035475508, 1017564481, -1111101803);
	WS(1038961915, -1122010239);
	sum1 = W(0, 1004620105, 1048595660, -1099376311, -1116246236)
		 + W(1, -1113106351, 1052250558, -1096833644, 1027857155)
		 + W(2, -1112775210, 1058549636, -1088891129, 1036452944)
		 + W(3, -1125534724, 1061573929, -1086812373, 1040782707)
		 + W(4, -1137271196, 1057522353, -1093214133, 1018281129)
		 + W(5, -1126589322, 1048822826, -1095914356, -1113857108)
		 + W(6, 1026657556, 1040718305, -1105329661, 1010557432)
		 + W(7, -1119328748, 1048641524, -1103878453, -1106455448);
	sum2 =
		W(0, -1116580406, 1027562258, 1055923683, 1077914250) + W(1, 1024927837, -1162615720, -1098456431, 1064911462)
		+ W(2, -1129828931, 1047581344, -1107918233, -1076359256)
		+ W(3, -1115420496, -1109513493, -1093462217, -1072190840)
		+ W(4, 1011185933, 1038795182, 1043574176, 1023726209) + W(5, -1123989928, -1118168090, 1042713369, -1114062645)
		+ W(6, -1146345634, 1030671240, -1118222006, -1119388396)
		+ W(7, -1132229127, 1038841827, 1029869485, -1111766417);
	WS(1058520191, -1103814144);
	sum1 =
		W(0, 1017038583, -1136595532, -1118053743, 1027978638) + W(1, 1027734728, 1016280509, -1128563239, -1097122909)
		+ W(2, 1045254802, -1109207324, 1044218638, -1104843131)
		+ W(3, -1107262661, 1062837304, -1096672636, 1033499055)
		+ W(4, -1105442246, 1058887264, -1085861660, 1025985831) + W(5, 1031430877, 1040464732, -1103880229, 1030848699)
		+ W(6, -1126950445, 1030731221, -1107144426, -1131329888)
		+ W(7, 1024536063, 1029953906, -1145128486, -1109411553);
	sum2 = W(0, 1034702970, -1176551015, 1007931783, -1110263367)
		 + W(1, -1125598974, -1168898884, -1090251816, -1089294892)
		 + W(2, -1114553387, 1041527709, 1067159008, -1085860022)
		 + W(3, 1027536136, -1101298022, 1043575777, 1061443693)
		 + W(4, -1115924578, 1036785061, 1028484706, -1099982080)
		 + W(5, 1035052048, -1106074654, -1104273626, 1042454777)
		 + W(6, -1132148431, 1030578400, -1148595850, 1027614804)
		 + W(7, 1025333585, 1024211757, -1114791455, -1123742626);
	WS(1061983711, -1098811342);
	sum1 =
		W(0, 1012577103, 1051270689, -1108510228, -1107438075) + W(1, -1126897281, 1046420622, -1106195699, -1107699151)
		+ W(2, -1105225996, 1058683087, -1088411008, 1036711743) + W(3, 1024253613, 1058369439, -1089548804, 1026749110)
		+ W(4, 1053413654, -1097514912, -1118840551, -1116819519)
		+ W(5, -1137207095, 1052214131, -1096732498, 1024709491)
		+ W(6, 1042674340, -1105013139, -1109015536, -1140694819)
		+ W(7, -1109172700, 1050302029, -1103000311, -1154413112);
	sum2 =
		W(0, 1018267361, 1036503366, -1126101987, -1099489904) + W(1, -1110181012, 1041828239, -1116783782, -1102883314)
		+ W(2, -1146613180, 1050199247, 1071387060, 1052019906) + W(3, 1038715850, -1085432172, -1080125372, 1047113133)
		+ W(4, 1024296823, 1038941240, -1093021050, 1035497971)
		+ W(5, 1036970119, -1123003584, -1114155200, -1112911441)
		+ W(6, 1022003098, 1013422114, -1149124484, -1119585859)
		+ W(7, -1124702635, 1021003447, -1143100940, -1131838862);
	WS(1061194367, -1092415693);
	sum1 = W(0, 1036390333, 1051201914, -1104881972, -1115149537)
		 + W(1, -1126263470, 1053058480, -1172862130, 1030237668)
		 + W(2, 1025725222, 1054554894, -1093268199, 1021350042) + W(3, 1043857157, 1047231542, -1076465248, 1036659934)
		 + W(4, 1035642972, 1057662314, -1087389459, 1039247491) + W(5, 1044002978, 1050872286, -1093150623, 1026362746)
		 + W(6, 998479342, 1045022613, -1111846627, 1017611295) + W(7, 1045699251, 1049392206, -1095910796, 1018350484);
	sum2 = W(0, -1129487679, 1018376667, -1097777178, -1117386048)
		 + W(1, 1042193002, -1087595144, -1098446206, -1106566736)
		 + W(2, -1108339354, 1054016721, -1106280983, -1108034123)
		 + W(3, -1095819059, 1063707892, 1068295659, -1104582586)
		 + W(4, 1041127864, 1036978867, 1052165187, -1102127104)
		 + W(5, -1103499785, -1103064253, -1110264861, 1036459063)
		 + W(6, 1034257999, -1103241982, -1135489703, -1104779766)
		 + W(7, -1118637794, -1112191100, -1107248782, 996655259);
	WS(-1094699455, 1066131816);
	sum1 =
		W(0, 1049793485, -1081848423, 1059460685, 1042128105) + W(1, 1029004921, -1088299640, 1048637514, -1139594888)
		+ W(2, 1050253240, -1084057276, 1060796209, 1026023615) + W(3, 1043166228, -1084821317, 1059873140, 1020508084)
		+ W(4, 1029407446, -1084563631, 1055943200, -1125172935) + W(5, 1041612884, -1104203619, 1047596309, 1048504406)
		+ W(6, 1035949114, -1099802604, 1050483936, -1115227886)
		+ W(7, 1012128942, -1096241030, -1105809528, 1051471881);
	sum2 =
		W(0, 1060779432, 1051802488, -1086062785, -1114203174) + W(1, -1118034101, -1097493973, 998397725, -1112558489)
		+ W(2, -1104519356, 1057101737, -1092333837, -1099984065)
		+ W(3, -1119327164, 1060027297, 1066349798, -1091352583) + W(4, -1101970936, 1044004337, 979464170, -1094257268)
		+ W(5, -1106905521, 1057962293, -1133317807, -1102635709)
		+ W(6, 1002331293, -1098665363, 1046794021, -1094504499)
		+ W(7, -1082144605, -1086721729, 1070824403, -1114333706);
	WS(-1074268304, 1079667699);
	sum1 =
		W(0, -1107189325, -1101508903, 1054199089, 1035260131) + W(1, 1027760991, -1090199334, 1054303683, -1107632246)
		+ W(2, -1136873402, -1090363950, 1062422475, 1005391451)
		+ W(3, -1113641470, -1087996124, 1067750847, -1101800081)
		+ W(4, 1031162561, -1083961527, -1113534839, 1034855959) + W(5, 1033891144, -1096484091, 1052689284, 1046337921)
		+ W(6, -1126712892, -1098094611, 1031942551, -1150999418)
		+ W(7, 1035917755, -1093567651, 1045977323, 1042992013);
	sum2 =
		W(0, -1109104193, -1100757902, 1040683096, -1125509919) + W(1, -1121805095, 1045040397, -1125556022, 1026278254)
		+ W(2, 1045986101, 1080470972, 1049174250, -1112163985) + W(3, 1048674700, -1080397282, -1095181876, 1050380898)
		+ W(4, -1091901802, -1070026310, -1122013099, -1131668233)
		+ W(5, 1048446997, 1054845861, -1110936398, 1033243862)
		+ W(6, -1113936425, -1109557127, 1038355211, -1144282357)
		+ W(7, 1027039508, -1113850952, -1103996340, 1036778147);
	WS(-1085238047, -1082053459);
	sum1 = W(0, -1106787663, 1039996894, 1048926451, -1104330662)
		 + W(1, -1138285833, 1010512412, -1119213276, -1128637723)
		 + W(2, -1108632776, 1053399812, -1130975030, -1108017347)
		 + W(3, -1094657608, 1045540841, 1010216242, -1096910157)
		 + W(4, -1101713608, 1051732998, 1034301867, -1101323868) + W(5, 1037328759, 1044326914, 1025236158, 1015829447)
		 + W(6, -1111697288, 976543556, -1128978334, -1111437732)
		 + W(7, -1109379868, 1057105320, -1109745879, -1108664266);
	sum2 =
		W(0, -1124623913, 1025825838, 1042257288, 1021162350) + W(1, 1032956443, -1119700813, -1135835500, -1114452863)
		+ W(2, 1027185909, 1032253087, 1053804277, -1109212782) + W(3, -1101336864, 1046009611, 1048892371, -1102267892)
		+ W(4, -1094263361, 1060071017, 1036906607, -1105958464)
		+ W(5, 1029736763, -1108021530, -1101254223, 1037505372)
		+ W(6, -1112090109, -1111711122, -1115069322, 996911332)
		+ W(7, 1039412150, -1092338318, -1114145526, -1125671849);
	WS(1060867039, -1136390908);
	sum1 =
		W(0, -1127355032, -1085412379, 1049179798, 1047055468) + W(1, 1034805910, -1094311080, 1049208039, -1108149971)
		+ W(2, 1035163860, -1093352008, 1060583566, 1036232649) + W(3, 1029669941, -1084691216, 1063283264, -1103012671)
		+ W(4, 1042066222, -1088428116, 1058522472, 1024178471) + W(5, 1021674692, -1088125293, 1055147879, 1026233836)
		+ W(6, 1040577786, -1096644095, 1050065089, -1126656770)
		+ W(7, 1021261983, -1091872390, 1041474713, 1049799631);
	sum2 = W(0, 1035672114, -1063752230, -1093487673, 1013645866)
		 + W(1, -1098827199, -1085747691, 1041803367, 1034418818)
		 + W(2, 1049155846, 1077059336, 1041184099, -1106855503) + W(3, 1035178389, 1075347264, -1096808218, 1049524211)
		 + W(4, -1107113032, 1056308660, -1129382302, -1122362105)
		 + W(5, -1144855824, 1034654874, -1119639669, 1030856901)
		 + W(6, 1035201737, -1121418857, -1122522987, 1027103888)
		 + W(7, -1127184278, 1014935340, 1011408026, -1115004359);
	WS(-1090674303, -1100343233);
	sum1 = W(0, -1120232797, -1091881416, 1051419109, 1036288004)
		 + W(1, 1040422273, -1094093465, 1052500896, 1023553551)
		 + W(2, 1026412864, -1085938046, 1061270771, -1112170192)
		 + W(3, -1138867958, -1089254334, 1067891162, -1115349187)
		 + W(4, 1033879777, -1089797193, 1060067146, -1112030904) + W(5, 1033565615, -1085407367, 1016645247, 998486818)
		 + W(6, 1019476032, -1095206984, 1041715172, 1027103050) + W(7, 988102399, -1105032111, 1036835111, 1040345019);
	sum2 = W(0, 1040618154, -1101425729, 1012698939, -1121139419)
		 + W(1, -1114130867, 1043012943, -1135257643, 1033653009)
		 + W(2, -1122148687, 1049717343, 1047429512, 1038119907) + W(3, 1044229537, 1078734719, 1020747990, -1131387750)
		 + W(4, -1110193301, 1058416067, 1045573328, -1162837210)
		 + W(5, -1097134960, -1066172228, -1105653505, -1124290574)
		 + W(6, 1037070268, -1087270128, -1098650023, -1142454518)
		 + W(7, 1037459780, 1051160418, 1029335953, -1119987003);
	WS(-1083751903, -1076119444);
	sum1 = W(0, -1115245576, 1056842307, -1093345814, -1108216057)
		 + W(1, -1106029427, 1054460828, -1096614035, -1118873130)
		 + W(2, -1102084379, 1062160243, -1087844584, 1032187759)
		 + W(3, -1113929101, 1061549380, -1088621915, -1118044066)
		 + W(4, -1115339007, 1051628466, -1095344475, -1125935063)
		 + W(5, 1029734646, 1034628298, 1039622221, -1114025640)
		 + W(6, -1110488366, 1040780998, 1023285463, -1103117229)
		 + W(7, -1147960477, 1027250487, 1052549785, -1101242061);
	sum2 = W(0, -1142266798, 1041896729, -1109207785, -1116438034)
		 + W(1, -1105635988, -1133541327, -1119640286, -1143926222)
		 + W(2, -1108468488, 1052249127, -1132044399, -1116983273)
		 + W(3, -1104742183, 1059101684, 1057719514, -1107716245)
		 + W(4, 1004562934, -1116644500, 1049160976, 1036001553)
		 + W(5, -1111519795, 1022626513, 1040987637, -1093640310)
		 + W(6, 1009402627, 1036478091, -1103527129, -1115139384)
		 + W(7, 1007186587, -1114250343, -1094402391, -1102449905);
	WS(1032624635, 1033521535);
	sum1 = W(0, -1131553039, -1098906814, 1051615627, 1045470610)
		 + W(1, -1117491096, -1100587359, 1047570260, 1025984961)
		 + W(2, -1112834618, -1081513385, 1060987922, 1036113314)
		 + W(3, 1049918570, -1078593782, 1043587024, 1040182861) + W(4, 1045795365, -1105649745, 1056209202, 1012071435)
		 + W(5, 1016822387, -1092053629, 1059398075, 1032631435) + W(6, 1035361729, -1096260814, 1049440024, 1023888652)
		 + W(7, -1113168565, -1095243062, 1051600524, 1034850724);
	sum2 = W(0, -1111826236, -1092384767, -1095745094, 1034661269)
		 + W(1, -1099208280, 1027875109, -1100947515, 1048636172)
		 + W(2, 1026789677, 1064661507, -1112642295, -1098451609)
		 + W(3, -1106561040, 1062273543, 1068550638, -1099981129)
		 + W(4, -1093448876, -1087164405, -1104229197, -1118651857)
		 + W(5, 1046407154, -1108191451, -1106740917, 1049739863)
		 + W(6, -1102666308, 1044380270, -1103404028, -1095995165)
		 + W(7, 1042570396, -1104593420, -1105841536, 1048025970);
	WS(-1085606847, 1061985400);
	sum1 =
		W(0, -1108997980, -1089905075, 1057688104, 1040581229) + W(1, -1117164584, -1114895517, 1056544190, -1114811305)
		+ W(2, 1031768707, -1095264598, 1062390314, -1107526493)
		+ W(3, -1103105924, -1077801587, 1055481056, -1110202349)
		+ W(4, 1041900981, -1097956992, 1062127874, -1118208771)
		+ W(5, -1110420181, -1088999487, 1051900674, -1108027100)
		+ W(6, 1037113665, -1098379486, 1048102065, 1024450541) + W(7, 1014163116, -1096151518, 1057425872, 1041210774);
	sum2 = W(0, 1025785873, 1048760593, 1035955606, -1126760968)
		 + W(1, 1048912334, -1090084783, -1119218892, 1008603006)
		 + W(2, -1096464036, -1114768213, 1007739746, -1094704139)
		 + W(3, 1056133856, 1066763200, 1064934573, -1080670875)
		 + W(4, -1104154812, -1086306359, -1089946445, 1031309677)
		 + W(5, -1121968309, 1058187354, 1050702067, -1125625514)
		 + W(6, 1033410161, -1113492694, 1025685973, -1109240237)
		 + W(7, 1015120151, -1128581905, -1102128709, 1039335694);
	WS(-1090966143, -1078936607);
	sum1 = W(0, -1116393227, -1086961670, 1058706816, -1116819366)
		 + W(1, -1108278025, -1108945587, 1041859343, 1035952359)
		 + W(2, 1051625062, -1086695325, 1060094467, 1041797992)
		 + W(3, -1105522375, -1081986687, 1059190367, -1104043025)
		 + W(4, 1058727904, -1089148367, 1061098519, 1053094890)
		 + W(5, -1091195697, -1086453117, 1055062080, -1093101306)
		 + W(6, 1052016408, -1092689140, 1056115606, 1015960496)
		 + W(7, -1109728971, -1091172115, 1058930855, 1034498693);
	sum2 =
		W(0, 1023528661, -1118025227, 1075422545, -1073269716) + W(1, -1119417071, 1050920275, 1065042273, -1077701631)
		+ W(2, -1105978590, -1112399565, 1069638520, -1078616397)
		+ W(3, 1009798795, -1098493686, 1067662601, -1083676116) + W(4, 1040834561, 1036263434, -1093932676, 1044144047)
		+ W(5, -1111364082, -1124489419, -1079439326, 1070390370)
		+ W(6, 1041397121, 1048582480, -1078082886, 1068400636)
		+ W(7, 1033368796, -1089345484, -1070108577, 1077727906);
	WS(-1079921856, 1049308945);
	sum1 = W(0, 1030068962, -1165865787, -1187780005, 1025440517)
		 + W(1, -1133949626, -1118082277, -1108803021, -1111921110)
		 + W(2, 1050882798, 1053008345, 1038634079, -1120535059)
		 + W(3, 1018623990, -1094507016, -1106873963, -1104818073)
		 + W(4, -1106924392, 1052481994, -1087778738, 1046575523)
		 + W(5, -1146454049, 1043504665, -1101591143, 1041667424)
		 + W(6, -1116987117, 1047635255, -1101174683, 1031519031)
		 + W(7, 1040905769, 1026870489, -1110197734, 1031554658);
	sum2 =
		W(0, -1116556974, 1059176005, -1096412953, -1114011261) + W(1, -1095066961, 1038856572, 1050790436, -1173649795)
		+ W(2, -1100395256, -1076691076, 1058179896, 1024138419) + W(3, 1050308919, 1055715442, -1097771226, 1040413046)
		+ W(4, 1040792410, 1046498927, 1039711359, -1106323994) + W(5, 1032406727, -1123959066, -1106160519, 1033840078)
		+ W(6, 1011901446, 1028959950, 1018212767, -1127468978)
		+ W(7, -1141998384, 1032868606, 1038360912, -1107910389);
	WS(1060842367, -1123947436);
	sum1 =
		W(0, 1024730985, 1048950736, -1097448124, -1122548355) + W(1, 1023159627, 1047784339, -1098772880, 1026072115)
		+ W(2, -1105241169, 1057388094, -1087773444, 1037590622) + W(3, 1017803651, 1060112037, -1085451727, 1037652837)
		+ W(4, 1037913699, 1062491953, -1088044111, 1034810634) + W(5, 1035962309, 1057656339, -1089872870, 1033785172)
		+ W(6, 1028045772, -1114528913, -1102522557, 1008900343)
		+ W(7, 1032728670, 997860858, -1103124285, -1114288296);
	sum2 = W(0, 1026131421, 1001103237, -1133854939, -1114822986)
		 + W(1, -1112740722, -1121600279, 1038637096, -1108393699)
		 + W(2, 1046858645, -1108221277, 1037424280, 1029862733)
		 + W(3, 1032928238, -1097923247, -1103185020, -1101308237)
		 + W(4, 1042166107, 1069212508, -1120290433, 1036213344) + W(5, 1040344552, 1057336110, 1019342369, -1145606165)
		 + W(6, -1082879617, -1095628134, 1039461314, -1111520861)
		 + W(7, -1091819295, -1107037379, -1122429445, 1034167562);
	WS(1038606587, 1058047160);
	sum1 =
		W(0, 1026865207, -1095018974, 1044423619, -1136300775) + W(1, 1042118304, -1093024127, 1048945010, -1117800769)
		+ W(2, 1051307036, -1082724754, 1054092644, 1005722288) + W(3, 1033639368, -1100730470, -1097872036, 1044405134)
		+ W(4, 1046742309, 1036658562, -1091674216, 1047528601) + W(5, -1109598961, 1040951763, 1033100505, 1044812414)
		+ W(6, 1028927539, -1113143704, 1030352835, 1032954286) + W(7, 1015037525, -1098528366, 1047837568, 1044220906);
	sum2 = W(0, 1050657429, 1045860939, -1111592920, -1103122208)
		 + W(1, -1103301852, 1052242374, 1013554208, -1106328874)
		 + W(2, 1060573163, -1100974944, -1111727364, 1015168980)
		 + W(3, -1091436731, 1066745360, 1055083328, -1113723980)
		 + W(4, -1104427284, -1079344782, -1098647652, 1051192034)
		 + W(5, -1097267636, -1113016512, 1034990326, 1034643320)
		 + W(6, 1038196249, -1119497008, -1110499846, -1122594772)
		 + W(7, -1107511544, -1113648424, 1042188938, -1140986496);
	WS(-1095257599, 1052962039);
	sum1 =
		W(0, -1106746181, -1097695335, 1053309708, 1036635571) + W(1, 1031300369, -1111219488, 1042046133, 1032102291)
		+ W(2, 1046667354, -1083536631, 1060606673, -1110849586)
		+ W(3, 1037361867, -1088861218, 1053570633, -1103814096)
		+ W(4, 1040829967, -1107201338, -1101583222, -1130665360)
		+ W(5, -1128966365, -1115618056, 1033575580, 1023220920) + W(6, 1034540700, -1117058422, 1029127944, 1009452933)
		+ W(7, -1115420664, -1138753100, 1041019129, 1041468947);
	sum2 = W(0, -1137205193, -1089705070, -1116057142, -1106134583)
		 + W(1, -1121249932, 1025195792, 1014073009, -1131583764)
		 + W(2, -1137006201, 1049206515, 1040872535, 1023734245) + W(3, -1101149788, 1054529493, 1044729510, 1030258377)
		 + W(4, 1034796937, 1039074115, 1024555690, 1045578999) + W(5, -1115985020, 1050074620, -1108168105, 1041497164)
		 + W(6, -1140489533, -1104546681, -1105229574, -1131316168)
		 + W(7, 1026538132, -1103055048, -1093226929, 1036128894);
	WS(1058062751, -1100017341);
	sum1 =
		W(0, -1129599006, 1055064995, -1094744478, -1110864465) + W(1, 1020928695, 1054737968, -1108714620, 1035506764)
		+ W(2, -1098371705, 1061839865, -1089137095, -1103907470)
		+ W(3, -1111175932, 1057524464, -1081607655, -1115102560)
		+ W(4, -1108928286, 1062722401, -1111400813, 1038105413)
		+ W(5, -1108487635, 1039434185, -1089739654, -1103382940) + W(6, 1028685770, 1053936411, 1037008853, 1038153674)
		+ W(7, -1134533769, 1054765971, -1094983833, -1101904010);
	sum2 =
		W(0, 1046625968, 1034733544, -1147999170, 1026537136) + W(1, -1114205611, -1100522159, -1093312378, -1103988998)
		+ W(2, -1097342682, 1034693600, 1057288295, 1049229753) + W(3, -1079666171, 1066071967, 1059803421, -1114956972)
		+ W(4, 1041595755, -1087077400, -1088579916, -1104980683) + W(5, 977545170, 1062799024, 1057064650, 1050850828)
		+ W(6, -1106070846, -1097179722, -1086854504, 997711860)
		+ W(7, -1145403458, 1015933409, 1055355590, -1115357129);
	WS(1033636603, -1075190676);
	sum1 = W(0, 1030520392, 1051253486, -1096251285, -1117233131)
		 + W(1, -1125697208, 1043969999, -1100430004, -1122877346)
		 + W(2, -1114269946, 1058583983, -1085953223, 1036037681)
		 + W(3, -1109653337, 1064791929, -1093290764, -1109909101)
		 + W(4, -1102211630, 1057642082, -1088005167, -1123582788)
		 + W(5, 1032435172, 1055881859, -1098086422, 1029223000)
		 + W(6, -1120127764, 1033241689, -1102333361, -1125435099)
		 + W(7, 996293820, 1053053914, -1119839106, -1103406294);
	sum2 =
		W(0, -1120200303, -1113787644, -1109535466, 1041916719) + W(1, 1024626781, 1041562727, -1106166077, 1028143351)
		+ W(2, 1013431061, -1114475538, 1029531851, -1097688999)
		+ W(3, -1124733431, -1112371618, 1051805575, 1068535590) + W(4, 1027814217, 1032748777, 1061661699, 1074776935)
		+ W(5, 999438554, -1098117165, -1114245048, 1029048009) + W(6, -1116912567, 1042886038, 1039886302, -1076933565)
		+ W(7, 1007930813, -1140542509, -1093997696, -1072079702);
	WS(1051996799, 1040628126);
	sum1 =
		W(0, -1106876926, -1096999331, 1064227732, 1032518006) + W(1, 1042171100, -1106536569, 1056769919, -1132737450)
		+ W(2, 1014013938, -1087433914, 1057736892, -1121739327) + W(3, 1040804174, -1079279688, 1052514885, 1035728257)
		+ W(4, 1038633599, -1085040172, 1059334684, -1115112214)
		+ W(5, 1024260165, -1090750082, 1058371760, -1126170017)
		+ W(6, 1032103150, -1096245875, 1051111478, -1129820331)
		+ W(7, -1111941370, -1091794355, 1050507101, 1036168684);
	sum2 = W(0, -1097197656, -1105938617, -1063141508, 1047663602)
		 + W(1, 1040517176, -1119182790, -1072247475, -1106333570)
		 + W(2, -1107105879, 1048788314, 1073986693, 1017343300) + W(3, 1050425804, 1048225474, 1082212097, 1014706728)
		 + W(4, -1108102513, 1050055380, 1063649950, 1023560998)
		 + W(5, 1044838414, -1097162220, -1108483496, -1105252179)
		 + W(6, 1026907274, 1028263310, 1040597170, 1016727612) + W(7, 978890108, 1043193320, -1096883524, 1025416282);
	WS(-1079662656, 1075711984);
	sum1 = W(0, -1136749190, 1054381451, -1099895821, -1111920714)
		 + W(1, -1108214827, 1049467004, -1104318006, -1124862997)
		 + W(2, -1112256994, 1060357369, -1094055613, -1099490085)
		 + W(3, -1102094902, 1064079536, -1088977984, -1093653775)
		 + W(4, 1019461885, 1058102849, -1094018397, 1047054555)
		 + W(5, -1113236619, 1050217386, -1093377643, 1026036560)
		 + W(6, -1115387518, 1046694646, -1102869707, -1122648846)
		 + W(7, 1015637672, 1053154499, -1097489705, -1117787456);
	sum2 =
		W(0, 1021596406, -1120307380, 1037868882, -1094559059) + W(1, 1027700788, 1049653321, 1038499992, -1099826066)
		+ W(2, 1031902674, -1100871897, 1074972319, -1070411479) + W(3, 1035450862, 1054975194, 1073269037, -1076192259)
		+ W(4, -1146279384, -1106853601, 992333684, 1024067187) + W(5, 1036068426, 1042197470, 1032586692, -1107184127)
		+ W(6, -1108044351, 1034125536, -1129244749, 1032061183)
		+ W(7, 1030087008, -1133477273, 1010404410, -1104237818);
	WS(-1121360374, -1077155152);
	sum1 = W(0, -1105583845, -1092428892, 1053987635, 1036329976)
		 + W(1, 1042009047, -1091586093, 1057449542, 1039912928)
		 + W(2, -1135496901, -1087526962, 1037542524, -1114441548)
		 + W(3, 1057317824, -1088356100, 1067018703, 1035631092) + W(4, 1037107234, -1084718223, 1053143538, 1024846769)
		 + W(5, 1028773828, -1086275726, 1051794540, 1020991498) + W(6, 1042777544, -1096882940, 1049337758, 1032759069)
		 + W(7, -1116736729, -1086839898, 1050512766, 1041911145);
	sum2 = W(0, -1122349048, -1108922684, -1102817435, 1024154790)
		 + W(1, 1027223630, 1050237475, 1047134367, -1105600910)
		 + W(2, -1123059666, -1093984844, -1086242189, 1041276041)
		 + W(3, -1097496437, 1061603028, 1069845393, -1090292072)
		 + W(4, -1101147358, 1054912466, -1091188340, -1122818012)
		 + W(5, 1008041239, -1136134543, -1107987422, -1109079234)
		 + W(6, -1113710228, 1050990810, -1126348732, 1047206075)
		 + W(7, -1103013196, 1037079763, -1097181289, -1109791787);
	WS(-1087087711, 1067831143);
	sum1 =
		W(0, 1034272753, -1110686621, 1034360523, 1006467012) + W(1, 1043354114, -1094089577, 1051348739, -1097882829)
		+ W(2, 1046815315, -1090322161, 1056352764, -1098171061) + W(3, 1041026663, 1019000899, 1049291409, -1099191041)
		+ W(4, -1116058688, 1048378971, -1098372646, 1036956791)
		+ W(5, -1131457456, 1054466495, -1090870248, 1036945505)
		+ W(6, -1115558139, 1045446607, -1103803571, -1124941614)
		+ W(7, 1032034947, 1043401342, -1098529593, 1026141794);
	sum2 = W(0, 1046033632, -1147554302, 1021728539, 1034466187)
		 + W(1, -1114282503, 1065651536, 1061103542, -1117467216) + W(2, 1044655964, 1052996561, 1047372498, 1040544990)
		 + W(3, -1106001859, -1076523823, -1081697027, -1105745303)
		 + W(4, -1104436397, -1095873418, -1094800655, -1119054372)
		 + W(5, -1101664028, 1059971501, 1058036758, -1110996319)
		 + W(6, 1015764662, 1037179306, -1113369666, -1120190386)
		 + W(7, 1023732858, -1119149512, 1033040332, 1028498617);
	WS(1040537598, -1164677141);
	sum1 = W(0, 1044447583, 1058921623, -1079854668, 1051360885) + W(1, 987031402, 1052904912, -1089009751, 1009017491)
		 + W(2, -1121775302, 1059494147, -1082135643, 1049103971)
		 + W(3, 1042738997, 1059765434, -1085199868, 1042102879) + W(4, 1038434732, 1053249925, -1087718171, 1037325507)
		 + W(5, 1049696256, 1045203303, -1094593271, 1033340813) + W(6, 1024826006, 1049549231, -1098502833, 1040792940)
		 + W(7, 1044766000, 1032179929, -1111725730, -1103499809);
	sum2 = W(0, -1105450770, -1076904032, 1034745372, 1064235564)
		 + W(1, -1099930216, -1110661913, -1104228342, -1133206564)
		 + W(2, -1087670985, 1054929191, 1055270313, -1159337186)
		 + W(3, -1097641768, 1067640588, 1058849806, -1095527236)
		 + W(4, -1093727900, 1043325457, 1055379319, -1097371942)
		 + W(5, 1034849198, 1041628489, 1047258529, -1123329564)
		 + W(6, -1089823109, 1024934811, -1091022953, 1053074558)
		 + W(7, 1026936119, 1071055811, -1093861556, -1079977593);
	WS(-1072228928, 1076959210);
	sum1 = W(0, 1049440860, -1102211417, 1052420434, 1046258910)
		 + W(1, -1100954468, -1090494943, 1049042513, -1094165323)
		 + W(2, 1040518102, -1089397123, 1057628335, -1113742940)
		 + W(3, 1055014377, -1085929645, 1059399711, -1115570152)
		 + W(4, -1102413547, -1092416799, 1055649007, -1095616949)
		 + W(5, 1056933930, -1103710088, 1056457065, 1054320058)
		 + W(6, -1100924366, -1099959722, 1043274798, -1096288332)
		 + W(7, 1025160513, -1097219837, 1043339918, -1113497047);
	sum2 =
		W(0, 1037249746, -1091193116, 1058952598, -1099278743) + W(1, -1106259401, 1057292562, -1089499743, 1035766214)
		+ W(2, -1118512137, 1045032769, 990544085, -1120311473) + W(3, 1033553146, -1101074553, 1052938455, -1107284433)
		+ W(4, -1118437421, 1047290760, -1096914685, 1032001159)
		+ W(5, 1049532353, -1085599381, 1060306657, -1105441959)
		+ W(6, -1112295163, 1045403080, -1095081062, 1037527897)
		+ W(7, -1112769969, 1036239865, 1036770528, -1117837555);
	WS(-1095248895, -1088416713);
	sum1 = W(0, 991086878, -1112623265, 1049658160, 1025280780) + W(1, 1041397006, 1023033498, -1129854724, 1018002536)
		 + W(2, -1100414321, -1095527100, 1056723856, -1101036339)
		 + W(3, -1106522737, -1085500137, 1061179113, -1098081679)
		 + W(4, 1032194452, -1103431285, 1050067968, -1121954805)
		 + W(5, 1040515607, -1093888960, 1055178889, 1040437430)
		 + W(6, -1113785099, 1025813699, 1027165141, -1107604207)
		 + W(7, -1119710941, -1112974208, 1044420741, -1122583614);
	sum2 = W(0, -1115281709, 1049351198, -1101546004, -1132663474)
		 + W(1, 1038308115, -1105447726, 1044927538, 1036918381)
		 + W(2, -1086190321, 1061131477, -1105825160, -1104633062)
		 + W(3, -1079410563, 1070791012, -1124003323, 1035199903)
		 + W(4, 1055352031, -1080774986, 1054621998, -1119052371)
		 + W(5, -1106071111, 1050939464, -1100497740, 1038597174)
		 + W(6, 1042421121, -1096576742, 1042910101, -1126972585)
		 + W(7, 999244165, 1021655353, -1123561791, -1141223925);
	WS(1057802399, -1081431823);
	sum1 = W(0, -1122831751, -1093480916, 1050038833, 1031929377)
		 + W(1, -1131892376, -1097592621, 1050095280, 1003466633)
		 + W(2, 1041203877, -1087992005, 1058335651, -1150646211)
		 + W(3, 1034931072, -1086955360, 1062569267, -1108251076)
		 + W(4, 1020249162, -1094219074, 1052617634, -1123920403)
		 + W(5, 1023514439, -1099624791, 1053253320, -1110979235)
		 + W(6, -1183605377, -1104094712, 1037479577, 1022403704)
		 + W(7, -1102408215, -1103351679, 1047799764, 1031403703);
	sum2 = W(0, -1104748298, 1032567526, 1030425414, 1028805714) + W(1, 1035677532, 1015597088, -1106402955, 1010146816)
		 + W(2, -1097271446, 1042180726, 1036072793, -1122721452)
		 + W(3, -1071563129, -1131466492, 1026492053, -1139412188)
		 + W(4, -1073203825, -1088097679, 1021201077, -1121571686)
		 + W(5, -1105574565, 1049167232, 1046304011, 1013464552)
		 + W(6, 1074066983, -1104411749, -1108010622, -1115684312)
		 + W(7, 1076846054, 1054919113, 1040423027, -1159010626);
	WS(1057159391, -1098185256);
	sum1 =
		W(0, -1115997840, 1062337777, -1099145229, -1108105457) + W(1, -1139848194, 1059107990, -1096884471, 1026934458)
		+ W(2, -1110900998, 1058844902, -1083284577, -1128707950)
		+ W(3, 1040272534, 1060188982, -1081840204, 1050661700) + W(4, -1124007614, 1050305613, -1086268415, 1025671020)
		+ W(5, 1022311680, 1055455830, -1088086212, 1018441343) + W(6, -1122049771, 1052112283, -1093503993, 1032949738)
		+ W(7, 1025640163, 1058488623, -1095187909, -1115150240);
	sum2 =
		W(0, 1056249112, -1063663228, -1090194820, -1098679170) + W(1, -1087901783, -1065703489, 1049313091, 1049727089)
		+ W(2, 1050240307, 1050922399, 1059446328, -1118968312) + W(3, -1096100666, 1074103439, -1091782161, 1043947681)
		+ W(4, 1050011361, 1078895155, 1051412884, -1103451878) + W(5, 1046757851, 1075028289, 999915799, 1046896549)
		+ W(6, -1111613200, 1011769164, -1097222567, 1036070334)
		+ W(7, 1031802636, 1041242105, 1040180956, -1120669738);
	WS(-1076050352, 1072169512);
	sum1 =
		W(0, -1112010473, -1127017300, 1032805651, -1127012698) + W(1, -1110549812, -1096217239, 1055039585, 1017026201)
		+ W(2, 1041474168, -1101316183, -1107675851, 1027743346)
		+ W(3, -1102358403, -1098236010, 1058693100, -1103052317)
		+ W(4, 1035256808, -1097462672, 1050718238, 1025923518) + W(5, -1103941101, 1015309803, 1047069339, -1108585145)
		+ W(6, -1126807163, -1109990262, 1040782175, 1029935559)
		+ W(7, -1127729580, -1124828306, 1033573870, 1030091394);
	sum2 =
		W(0, -1115222730, 1013406324, 1048651312, -1105744683) + W(1, -1103808603, 1044516259, -1091636530, 1036643390)
		+ W(2, -1133607278, 1056099238, -1082257366, 1056116581)
		+ W(3, 1035011293, -1093760521, 1065398243, -1087652578)
		+ W(4, 1045426354, -1097063741, 1052543946, -1106429625) + W(5, 1005150868, 1046105407, -1105190986, 1031045850)
		+ W(6, 1038138903, -1106358807, -1143243436, -1129675875)
		+ W(7, 1014354189, 1034790704, -1124610775, 1033997397);
	WS(1065781680, 1039008007);
	sum1 =
		W(0, 1041247860, 1052873269, -1087848896, -1122380132) + W(1, -1132228043, 1052030887, -1090939837, 1043969975)
		+ W(2, -1116017645, 1057769989, -1086321043, -1167945460)
		+ W(3, 1029031978, 1065817909, -1090130600, 1043124941) + W(4, -1114552992, 1059292430, -1093123180, 1037414446)
		+ W(5, 1018467582, 1052683781, -1089813139, 1037105136) + W(6, -1119698444, 1045381867, -1093950448, 1016187596)
		+ W(7, 1039500994, 1042767258, -1088918334, -1139723011);
	sum2 = W(0, 1038177586, -1105284792, -1114385091, 1023745983)
		 + W(1, 1024852101, -1131141686, -1105200928, 1044997454)
		 + W(2, 1031995320, -1123455081, 1057384109, -1102654886) + W(3, 1016571646, 999573799, 1073904332, 1045931554)
		 + W(4, 1033741319, -1107419527, 1075963065, -1113399825)
		 + W(5, -1108656521, 1052574782, -1130292726, 1041285787)
		 + W(6, 1035134998, -1099142208, -1072886122, -1101763500)
		 + W(7, -1120710323, -1103717942, -1070457563, 1044467987);
	WS(-1090516543, -1087531312);
	sum1 = W(0, -1105337757, 1040358473, 1026287071, -1112133319)
		 + W(1, -1135375282, 1025750638, -1109155234, 1043065477)
		 + W(2, -1113059195, 1034124454, -1111070925, 1049735832)
		 + W(3, -1111479074, -1082649657, -1113637434, 1048811350)
		 + W(4, 1044282546, -1098312091, 1056333811, -1104740686)
		 + W(5, 1036163039, -1114570479, 1044131649, -1111303053)
		 + W(6, -1123738614, -1112260786, 1049914271, -1128712224)
		 + W(7, -1110047807, 1044483760, 1039433994, -1136462731);
	sum2 = W(0, -1122757257, 1027164873, 1002742314, -1111953049)
		 + W(1, 1009904581, -1112829049, -1115430893, -1116391321)
		 + W(2, -1113467627, 1020364514, -1098221748, 1025748661)
		 + W(3, -1099518373, 1064179702, 1059311413, -1098741962)
		 + W(4, 1032421699, -1092934445, -1139891301, 1036551469)
		 + W(5, -1095677862, 1039050377, 1041708988, -1119491053)
		 + W(6, 1020800146, -1106885375, -1124766450, 1025848261)
		 + W(7, -1112743661, 1022655162, 1032689603, -1122814953);
	WS(1059528063, 1057564569);
	sum1 = W(0, 993737087, -1096201122, 1052073475, 1036364765) + W(1, 1023855952, -1112481934, 1044928820, -1119101474)
		 + W(2, 1051519336, -1089271861, 1057871347, 1026047377)
		 + W(3, -1100822612, -1101379550, -1090210244, -1095066725)
		 + W(4, 1027584566, -1129312776, 1027452795, 1043887545)
		 + W(5, -1109486813, -1101173547, 1051680014, 1038809676)
		 + W(6, -1127107174, 1031993577, 1038521522, -1152581582)
		 + W(7, 1035631854, -1097162722, 1050823828, 1037595092);
	sum2 =
		W(0, -1106514375, -1115270098, 1025588625, -1109616345) + W(1, 1034094594, 1029678117, -1103891997, 1044342701)
		+ W(2, -1112949179, -1095879627, 1029083209, -1107320484)
		+ W(3, 1009317700, 1052560633, 1062070608, -1103446924)
		+ W(4, -1126355148, -1128108776, -1100067512, -1131810302)
		+ W(5, 1021633582, 1034084538, 1035054672, -1098743078) + W(6, 1010987268, 1040297892, -1117785257, -1123491293)
		+ W(7, -1106252693, 1049223604, 990783407, -1102218346);
	WS(1061977215, -1122204685);
	sum1 =
		W(0, -1124031333, 1053794732, -1090279300, 1017895407) + W(1, -1109554099, 1053305789, -1096176108, 1027213295)
		+ W(2, -1105250724, 1058003360, -1093816822, 1024566052) + W(3, 1036027519, 1059361796, -1081723655, 1033714163)
		+ W(4, 959521497, 1055117810, -1090510080, -1125004641) + W(5, 1055353398, 1051669497, -1097892492, 1006220452)
		+ W(6, 1038275624, 1037705519, -1101480172, -1112881733)
		+ W(7, -1136942561, 1047158647, -1098784634, -1145512357);
	sum2 = W(0, -1113155109, 1028856727, 993552399, 1036996819) + W(1, 1032430477, 1021325630, -1128331832, -1139715524)
		 + W(2, -1105712018, 1050891972, 1042508384, -1111526035) + W(3, 1048044904, 1070862297, 1042132916, 1040898786)
		 + W(4, -1081128362, 1074403261, 1044319918, 1025048067)
		 + W(5, -1070110178, 1035516985, -1115800491, 1038841221)
		 + W(6, -1092435520, -1108990845, 1033559089, -1119663830)
		 + W(7, -1092804751, -1122256510, -1109033129, 1007165668);
	WS(-1096328959, 1070879408);
	sum1 = W(0, 1047483149, 1056909741, -1084253114, 1043610432)
		 + W(1, -1131726569, 1050717891, -1097194674, -1120381614)
		 + W(2, 1017405984, 1049879450, -1084428714, 1029856307) + W(3, 1016192218, 1064784543, -1088019878, 1046790989)
		 + W(4, -1134185032, 1054175424, -1087922381, 1044095416)
		 + W(5, -1130210629, 1055866677, -1096076442, -1106891777)
		 + W(6, 1039283496, 1052923070, -1098682228, 1045347898)
		 + W(7, 1022798351, 1050331269, -1089646420, -1103492015);
	sum2 =
		W(0, -1096731787, -1092572599, -1072213302, 1074300082) + W(1, 1041094096, -1083918511, -1081783724, 1061218424)
		+ W(2, 1030029833, -1081752188, -1088492050, 1062246408)
		+ W(3, -1134738767, 1050600846, -1098909280, 1055931246) + W(4, -1112066554, 1060518769, 1054813136, 1030722387)
		+ W(5, 1049526473, 1056806956, 1066457366, -1080408758) + W(6, -1103571503, 1052566197, 1061557517, -1082314750)
		+ W(7, 1038503381, 1040255570, 1074348460, -1074863778);
	WS(-1093955647, 1022010191);
	sum1 =
		W(0, 1027472455, 1051129150, -1126583382, -1110971745) + W(1, -1118029508, 1040858863, -1110637352, -1129027011)
		+ W(2, 1017520774, 1058284788, -1083829535, 1043546956) + W(3, -1100976252, 1064764899, -1092969620, 1032062845)
		+ W(4, 1048038797, -1094249656, -1093269900, 1049944248)
		+ W(5, 1019653215, 1054989120, -1098669306, -1114080636)
		+ W(6, 1015004427, -1137681219, -1101321193, 1039113958)
		+ W(7, 1006149335, 1047833420, -1092663640, -1120661351);
	sum2 =
		W(0, -1125700855, -1109340305, 1041739108, -1138307987) + W(1, 1010923567, -1099241242, -1121076246, 1010348245)
		+ W(2, -1097524591, -1097784845, -1122648580, 1043843262)
		+ W(3, -1086770251, 1061340682, 1059475190, -1104554020)
		+ W(4, -1119687254, -1091236020, -1097965354, 1042867821)
		+ W(5, -1136610695, 1059369820, 1048517727, -1105357691) + W(6, 1034141799, -1103210716, 1020884025, 1021404807)
		+ W(7, -1146172877, 1042204527, -1117941982, 1026766467);
	WS(1057685119, 1067243116);
	sum1 =
		W(0, -1129459555, -1098308652, 1053516928, 1029422892) + W(1, 1016923756, -1100618635, 1049587364, -1111775882)
		+ W(2, 1004671913, -1090418529, 1057639529, -1114348966)
		+ W(3, -1095493364, -1088191051, 1065512192, -1112549294)
		+ W(4, -1098633785, -1089905135, 1058720438, -1103551521)
		+ W(5, -1112175056, -1101363479, 1052631981, -1111153757) + W(6, 1046138501, -1106099897, 1043712557, 995391206)
		+ W(7, -1131471418, -1097291652, 1052947846, 1020473821);
	sum2 = W(0, -1131225411, -1140292462, 1018110051, 1018006973)
		 + W(1, -1130956898, 1023877693, -1137158572, -1128428036)
		 + W(2, -1103681442, 1042914798, -1224504659, 1020723155)
		 + W(3, -1077027280, 1069127322, 1043315619, -1147115303)
		 + W(4, -1076028808, 1071847872, -1120948958, 1020554514)
		 + W(5, 1031803188, -1103125793, 1043270022, -1133954299)
		 + W(6, -1101294062, 1043076855, -1113817590, 990350747) + W(7, 949706042, -1132087796, 1015417250, 1025989218);
	WS(-1097928959, -1082976358);
	sum1 =
		W(0, 1027664520, 1057835343, -1089326063, -1108038941) + W(1, -1123678010, 1050550727, -1096462854, 1032858337)
		+ W(2, -1106569905, 1057764410, -1083721351, 1021803093) + W(3, 1052451146, 1062299789, -1087127986, 1042469806)
		+ W(4, -1103556709, 1049034640, -1097735566, -1104920125)
		+ W(5, 1038567635, 1057826487, -1094118206, 1031016631)
		+ W(6, -1108799690, 1041175724, -1100805265, -1129264698)
		+ W(7, 1040222651, 1060823717, -1089053734, -1107162784);
	sum2 = W(0, 1059738223, -1087082495, -1092378156, 1034470847)
		 + W(1, 1048150071, -1095900368, 1046247330, 1025055065) + W(2, 1052511773, -1108343021, 1033545850, 1045395587)
		 + W(3, -1080186607, 1063110279, -1090059649, -1094453880)
		 + W(4, -1078381471, 1074904245, -1107095292, 1053230483)
		 + W(5, -1072132845, 1071639576, 1039712953, -1103894182)
		 + W(6, -1071450961, 1076364217, -1113577164, 1032308634)
		 + W(7, -1071397334, 1077341373, 1049211915, -1120241798);
	WS(-1093482751, 1040242403);
	sum1 = W(0, -1101135214, 1051279307, -1160860306, -1112732162)
		 + W(1, -1123956286, 1045008905, -1106067054, -1135242283)
		 + W(2, -1107524598, 1049489177, -1101021318, 1029341500)
		 + W(3, -1138012647, -1132973569, -1113266773, -1121978915)
		 + W(4, 1034129455, -1096848358, 1049504725, -1098727290)
		 + W(5, 1042720691, -1098383795, 1059206814, -1102892456)
		 + W(6, -1130324184, -1104810279, 1049756222, -1104163113)
		 + W(7, 998898338, -1118268600, 1052043149, -1099073308);
	sum2 = W(0, 1050603120, 1055811875, -1086548128, 1034695967)
		 + W(1, -1101078445, -1122671355, -1087609936, -1108269543)
		 + W(2, 1048531671, 1038805789, -1088336312, -1089139562)
		 + W(3, -1105220793, 1066111209, 1071017234, -1104320030)
		 + W(4, -1091713187, 1026095418, -1115602704, -1100901763)
		 + W(5, 1034851673, -1130092003, -1089969509, 1049804877)
		 + W(6, -1122031169, -1137910742, -1121274059, -1103744367)
		 + W(7, 1020293663, -1094690648, 1053616941, 1054827086);
	WS(-1112146683, -1077736475);
	sum1 = W(0, -1128590341, -1099064529, 1049253908, 1039097715)
		 + W(1, -1130792414, -1090490649, 1028859267, 1017948777)
		 + W(2, -1147973299, -1086623314, 1040872136, 1025770233)
		 + W(3, -1117834531, -1101063739, 1068918685, -1115616742)
		 + W(4, 1007065251, -1084449173, 1059458719, -1104116690)
		 + W(5, 1033724609, -1094725676, 1057886934, -1132647657) + W(6, 1024083798, -1097837640, 1044653558, 998082042)
		 + W(7, -1122914526, -1097461352, 1048946351, 1030833130);
	sum2 =
		W(0, 1038545045, 1044965772, 1038508364, 1032278560) + W(1, -1104316542, -1073797636, -1092377302, -1115941315)
		+ W(2, -1098913527, -1069601753, 1050236814, -1109127211) + W(3, 1054073276, 1079919017, 1044931722, 1042591612)
		+ W(4, 990615436, 1065620582, 1034922622, 997021068) + W(5, -1111960943, -1103381017, 1033398315, 1042220416)
		+ W(6, -1127436605, 1039512539, -1113162193, -1138197651)
		+ W(7, -1131799749, -1105195767, 1039327537, -1121388557);
	WS(-1090505151, -1074550453);
	sum1 = W(0, -1112838599, -1106878250, 1057615003, -1131143051)
		 + W(1, 1028498739, -1103427629, 1042960070, 1023192930)
		 + W(2, 1023419227, -1088602192, 1063645564, -1096958907)
		 + W(3, -1117182312, -1088941275, 1053033883, 1048242260)
		 + W(4, 1018948122, -1087514842, 1058641540, -1098164287)
		 + W(5, -1126145258, -1096920942, 1043052986, 1045189988)
		 + W(6, 1024711581, -1096615233, 1050742275, -1105551137)
		 + W(7, -1125422420, -1095073209, 1053972531, 1026824959);
	sum2 = W(0, 1051549752, 1021553919, -1106404197, 1031994963)
		 + W(1, 1081443218, -1111116920, 1044837835, -1113046369)
		 + W(2, 1072492444, -1073777225, -1113676512, 1032624041)
		 + W(3, 1048388769, -1067599847, -1089379201, 1025956540)
		 + W(4, 1035162847, -1096587672, -1109546151, 1027498280)
		 + W(5, -1139079606, 1029232562, 1030543674, -1132168419)
		 + W(6, -1121149576, -1115288719, -1122606689, 1034044071)
		 + W(7, -1123800689, 1042218632, -1125599605, -1115044631);
	WS(1051119487, 1041244378);
	sum1 = W(0, -1124974044, -1137238551, -1116593698, -1121323393)
		 + W(1, 1028120435, -1113671305, -1103177170, 1033078132)
		 + W(2, 1048876359, 1036964902, -1099611151, -1156053771)
		 + W(3, 1037118035, 1061504071, -1104164974, -1129960608)
		 + W(4, -1131477080, 1047204942, -1081804989, 1048068278)
		 + W(5, -1118427428, 1050660570, -1114906180, 1011539382)
		 + W(6, -1120234265, 1030267847, -1098831475, 1035846233)
		 + W(7, -1125985859, 1049717597, -1103929310, -1115091743);
	sum2 = W(0, 1018090488, 1027537220, 1019973834, -1117503915)
		 + W(1, -1104952272, 1048078363, -1095697091, 1045164128)
		 + W(2, -1105226064, 1055192952, -1101823824, -1106818318)
		 + W(3, -1128161694, -1102612387, 1074095781, -1087428157)
		 + W(4, -1134153828, -1102761937, -1074759173, 1061969021)
		 + W(5, 1024328280, -1101688104, 1063478353, -1092430375)
		 + W(6, -1118410723, 1035228556, -1092594125, 1050476000)
		 + W(7, -1117225997, 1016223417, 1041310640, -1110796930);
	WS(1062303263, 1031082743);
	sum1 =
		W(0, -1113216195, 1050954912, -1095964628, -1121789260) + W(1, -1099215391, 1012178225, -1095180416, 1027015379)
		+ W(2, 1052151297, 1065129152, -1088785601, 1041954507) + W(3, 1026092610, 1047492794, -1089641431, -1107401421)
		+ W(4, 1051942565, 1063700475, -1089295544, 1049634587)
		+ W(5, -1098039588, 1049517720, -1091476104, -1112964196)
		+ W(6, -1101893697, 1028060738, -1102410709, 1035520455)
		+ W(7, 1008063218, 1054989200, -1096414030, -1114231491);
	sum2 = W(0, 1033145987, -1175661064, 1021827842, -1165845202)
		 + W(1, -1111827051, -1152013649, -1104895942, -1187919119)
		 + W(2, -1103256184, 1050523165, 1034611383, -1125020091)
		 + W(3, -1063595607, 1084357731, -1094652398, 1042933311)
		 + W(4, -1101985731, 1048919805, 1029250458, -1108910008)
		 + W(5, -1141099147, 1025442742, -1102082303, 1040766920)
		 + W(6, -1136421288, -1145624409, 1021034188, -1126731425)
		 + W(7, 1030655939, -1133270551, -1121842648, 1017996705);
	WS(1057958943, -1104691893);
	sum1 =
		W(0, -1111014615, -1105424217, 1044401084, -1118336456) + W(1, -1128240917, 1046008396, -1100901945, 1038452148)
		+ W(2, -1146251723, -1090082375, 1057785284, -1119525902)
		+ W(3, -1095236657, 1054329938, 1040293502, -1093887914) + W(4, 1047913107, 1003615948, -1099597392, 1045607070)
		+ W(5, -1103203951, 1013130820, 1051440085, -1107674167)
		+ W(6, 1033356080, 1044802714, -1102604718, -1113361665)
		+ W(7, 1023941889, -1101796865, 1036253756, 1037874639);
	sum2 = W(0, 1010987018, 1041119120, -1110188142, -1127404253)
		 + W(1, -1105807463, -1111572952, 1045029856, 1029477872)
		 + W(2, -1102396693, -1117220749, 1057260834, 1019931869)
		 + W(3, 1054217500, -1087890507, -1087358521, 1056265374)
		 + W(4, -1123211893, 1070205457, -1081682663, -1091128546)
		 + W(5, 1029628166, -1101117061, 1051101181, -1124058781)
		 + W(6, -1106898625, -1113015450, 1042553654, 1025549544)
		 + W(7, 1028744914, -1121743361, -1135525482, 992401866);
	WS(1063883327, -1171419961);
	sum1 =
		W(0, -1131801844, 1049833398, -1102183011, -1101850371) + W(1, 1021098616, -1123871229, -1097479398, 1031224740)
		+ W(2, 1022023532, 1009731296, 1056730033, -1123343997) + W(3, -1121742227, 1044941350, 1041013425, -1127214008)
		+ W(4, -1090925859, 1060653970, -1095529687, -1107029405)
		+ W(5, 1024490200, 1043051923, -1097251239, 1042080318)
		+ W(6, -1102607801, 1048967870, -1104750961, -1107657120)
		+ W(7, -1123544461, 1050859794, -1097963532, 1009310536);
	sum2 = W(0, -1106082604, 1047581965, -1097195715, -1113941985)
		 + W(1, 1041248381, -1108094251, -1105642610, -1131232309)
		 + W(2, -1132935321, -1111186257, 1042983438, 1050509566)
		 + W(3, -1106587714, 1050591326, 1048334662, -1103031697)
		 + W(4, -1104172881, 1039028256, 1046273630, -1127691207)
		 + W(5, -1118244665, 1025922877, -1128737701, -1115007353)
		 + W(6, -1115368488, -1111866155, 1044426238, -1112751356)
		 + W(7, -1139264801, -1104769894, -1122157893, 1031938310);
	WS(1064944927, 1037595256);
	sum1 = W(0, -1116864018, -1089228760, 1063040538, -1107296590)
		 + W(1, 1023806679, -1095304482, 1057549004, -1106875789)
		 + W(2, 1017115436, -1087165700, 1060715233, -1103245163)
		 + W(3, 1009660557, -1086682215, 1064233001, -1106392275)
		 + W(4, 1028149000, -1088874517, 1056983460, -1132085516)
		 + W(5, -1109610248, -1099761351, 1052917089, -1107160974)
		 + W(6, -1148661421, -1116139780, 1041500021, -1129006079)
		 + W(7, -1102752831, -1131587330, 1045020525, -1152394658);
	sum2 =
		W(0, 1045832950, -1084008560, -1084775302, 1058474163) + W(1, -1110716731, 1049995423, -1093173621, -1102301410)
		+ W(2, 1025147898, -1089165996, 1054478967, -1128684365) + W(3, -1098226948, 1066542501, 1068786857, 1031931484)
		+ W(4, -1099749141, 1049362032, 1047038722, -1091779956)
		+ W(5, -1098250414, 1055260506, -1126019654, -1105326436)
		+ W(6, 1042544569, -1086997229, -1127724076, 1053449115)
		+ W(7, -1089530617, 1067285885, -1088213452, -1090548395);
	WS(-1082101344, -1089856493);
	sum1 =
		W(0, 1050831902, -1105691402, -1101015969, 1029275441) + W(1, -1112019073, 1030717682, -1098775681, -1120813832)
		+ W(2, 1030303546, 1055521064, -1097748442, -1139280937) + W(3, -1129997454, 1064695661, -1085520515, 965412887)
		+ W(4, -1110327174, 1061962758, -1086646154, 1041358014)
		+ W(5, -1117704076, 1058754169, -1089610799, -1122362798)
		+ W(6, -1112251093, 1047731210, -1093958751, 1028938947)
		+ W(7, -1131596868, 1056158989, -1094349907, 1016935004);
	sum2 = W(0, -1065128139, -1101130808, 1034565987, -1119435550)
		 + W(1, -1076824095, 1050826865, -1109355365, 1023890205)
		 + W(2, 1067439244, 1046966330, -1109830496, 1012867020) + W(3, 1079260085, 1049869634, -1112614302, 1015248786)
		 + W(4, 1056740148, 1051236860, -1123646153, -1122661198)
		 + W(5, -1103928218, -1114183173, 1051726295, -1136992532)
		 + W(6, -1135208116, 1033256035, 1035002893, -1119472799)
		 + W(7, 1039164015, -1104627926, -1109091637, -1136910724);
	WS(-1090711679, 1035967541);
	sum1 =
		W(0, -1111795270, -1104454427, 1050513973, 1030482278) + W(1, 1015715144, 1029360119, 1050454265, -1138269301)
		+ W(2, -1118064815, -1084526809, 1063535365, -1132452908)
		+ W(3, -1124564760, -1083278737, 1060834888, 1007072853) + W(4, 1033380937, -1083950349, 1050327592, 1028355007)
		+ W(5, 1041725555, -1091233609, 1054941014, 1029566323) + W(6, 1039158191, -1102432923, 1040417584, -1140656289)
		+ W(7, 1036708611, -1097260861, 1042099839, 1035976950);
	sum2 = W(0, 1030795338, -1099705557, -1100315818, -1124401732)
		 + W(1, -1104698754, -1088930785, -1129318753, 1047822852)
		 + W(2, -1086482027, -1087114188, -1088371087, 1041847465)
		 + W(3, -1086674278, 1063363970, 1059258270, 1007827043) + W(4, 1048689193, 1066258058, 1052412907, -1114489829)
		 + W(5, -1101252049, 1055138353, 1035784301, 1039056173)
		 + W(6, -1127107620, -1113111809, -1107499570, 1036879119)
		 + W(7, -1097010897, 1050900036, 1046424313, -1112035485);
	WS(-1098505599, -1075865372);
	sum1 = W(0, -1119631078, -1131715643, -1121509433, -1113178620)
		 + W(1, 1024188415, 1032178901, -1128987132, 1024883696)
		 + W(2, -1125460739, 1056750314, -1131145214, -1114020928)
		 + W(3, -1113150415, 1055366257, -1096447994, -1102601578)
		 + W(4, -1098117352, 1063530169, -1086227497, -1111953177)
		 + W(5, 1028789822, 1038512989, -1117796833, -1101470933)
		 + W(6, -1115205937, 1036256496, 1016180195, -1141768534)
		 + W(7, -1134520549, 1042179631, 1032402616, -1114797153);
	sum2 = W(0, -1098762498, 1039073687, 1035541163, 1030962008) + W(1, -1112826554, 1047439072, 1032611741, 981436096)
		 + W(2, -1099883844, 1024348972, 1050751610, 1048715774)
		 + W(3, -1090598021, 1068429254, 1066295533, -1089341195)
		 + W(4, 1060690639, -1078855206, -1081223881, -1094541311)
		 + W(5, -1101866176, 1052294530, -1097770507, 1041458546)
		 + W(6, 1051055486, -1095975199, -1126362074, 1044471119)
		 + W(7, -1111565268, 1034134076, -1121819739, 1024624177);
	WS(1057165023, -1106509195);
	sum1 = W(0, -1110663097, -1090373040, 1057389257, 1036322023)
		 + W(1, 1023353031, -1094296089, 1051297995, -1110472134)
		 + W(2, 1009641338, -1087820187, 1064196683, -1103525103)
		 + W(3, -1116674588, -1090764772, 1064337073, -1108191858)
		 + W(4, -1121179137, -1101809276, 1058239248, -1105116828)
		 + W(5, -1127866586, -1095695571, 1053143796, -1130262917)
		 + W(6, 1019708412, -1097119704, 1049182394, -1117889432)
		 + W(7, -1105922998, -1088811352, 1042633923, 1047174317);
	sum2 = W(0, -1112942365, -1106822390, -1102090209, 1043730009)
		 + W(1, 1048482322, -1115190843, 1042851055, 1035412483)
		 + W(2, -1100072975, 1034045428, -1103979279, -1105576965)
		 + W(3, -1097118067, 1068163863, 1056641862, 1028572696) + W(4, 991349250, 1063618710, -1105663689, -1113934073)
		 + W(5, -1108096389, -1107942623, 1049912171, -1105853831)
		 + W(6, 1053525633, -1090492700, -1130278628, 1039916278)
		 + W(7, 1000921969, -1076676559, -1111476815, -1106999228);
	WS(-1086493375, -1079336981);
	sum1 = W(0, 977772865, -1102983835, 1026410857, 1015269519)
		 + W(1, -1123924042, -1108602044, -1098146918, 1049374456)
		 + W(2, -1109993624, 1041059645, -1106936850, 1036994068)
		 + W(3, -1107908519, -1094902379, 1061697492, 1041174790)
		 + W(4, 1036636329, -1083260999, 1061962303, -1103125248)
		 + W(5, 1038934102, -1084987377, 1057432285, -1125738921)
		 + W(6, 1034769240, -1102484540, 1051050960, -1130650164)
		 + W(7, -1099048778, -1108629750, 1050989872, 1040252563);
	sum2 =
		W(0, -1104970914, 1042634099, 1052960430, -1112577728) + W(1, 1018133697, -1097448347, -1108255972, -1096543501)
		+ W(2, 1040842491, 1055662701, 1062139198, -1090800341) + W(3, -1093587851, 1074010545, 1064732329, -1093194079)
		+ W(4, -1093237537, -1089724369, -1083390778, 1015865539)
		+ W(5, -1102375178, -1099392752, 1025575413, 991452982)
		+ W(6, -1099804326, 1049771835, -1104347883, -1126119433)
		+ W(7, 1054809337, -1092159031, -1096888027, 1028159711);
	WS(-1088469887, 1068090411);
	sum1 =
		W(0, -1113244581, 1001301201, -1115331947, -1124374314) + W(1, -1123900274, 1023861926, 1035790701, -1105829923)
		+ W(2, 1049496346, -1082959002, 1057295251, -1096521435)
		+ W(3, -1110903326, 1050701400, 1048296635, -1119292644)
		+ W(4, -1119953152, 1060902689, -1081663133, 1048590454) + W(5, 1031904934, 1043052181, -1113327662, 1027826066)
		+ W(6, 1034227191, 1043817559, -1110964279, -1106468266)
		+ W(7, 1025939062, 1038313117, 1034951606, -1117293966);
	sum2 = W(0, 1046922708, -1106472578, 1033443280, -1111979165)
		 + W(1, 1033420508, -1114867820, -1109208012, 1050643686)
		 + W(2, -1112865289, -1087802072, 1020845388, -1101832932)
		 + W(3, -1096930035, 1058113813, 1048730658, -1129026525)
		 + W(4, -1101802092, 1050476308, 1059721445, -1104558996)
		 + W(5, 1017341032, -1103417477, -1107242470, -1135034393)
		 + W(6, 1036773342, -1105807138, -1136542442, 1037376476)
		 + W(7, -1107450994, 1033379085, -1104249476, 1023773731);
	WS(1052578175, -1092643724);
	sum1 = W(0, -1106584961, -1102735475, 1053304083, 993436516) + W(1, 1030893452, -1100779014, 1049737317, 1037510015)
		 + W(2, 1033955624, -1082492039, 1060101900, -1101687426)
		 + W(3, 1037358070, -1086815439, 1065824329, -1103135573)
		 + W(4, 1036710537, -1088009424, 1041943502, 1029815263)
		 + W(5, -1128189432, -1095075429, 1057719155, 1040440469)
		 + W(6, -1118327615, -1106908643, 1051335460, -1106074638)
		 + W(7, -1129060558, -1102841939, 1036237087, 1027836379);
	sum2 =
		W(0, -1115440098, 1015710974, 1041402597, -1130229431) + W(1, 1029771501, 1033337736, -1114856806, 1034787000)
		+ W(2, 1018065220, -1094728975, 1037520917, -1082769104) + W(3, 999202537, 1039453548, 1064530169, -1074584982)
		+ W(4, 1036811205, 1050012979, -1094040689, -1090370130) + W(5, -1111720654, 1032576025, 1073761042, 1032162938)
		+ W(6, -1125064265, -1103861773, 1063409170, -1105633547)
		+ W(7, 1019498859, 1040788513, -1090935047, 1034133532);
	WS(-1104397694, 1058392920);
	sum1 = W(0, 1012876448, 1051523414, -1094911217, 1023486907)
		 + W(1, -1126111401, 1050625047, -1106828476, 1033392977)
		 + W(2, -1142522206, 1043902243, -1089440467, -1119682235)
		 + W(3, -1115125816, 1063861817, -1093833780, 1019625524)
		 + W(4, -1103048369, 1056801600, -1087921625, -1096529922)
		 + W(5, 999529969, 1053396405, -1107310585, 1015514383) + W(6, 1016404519, 1042081404, -1104958721, 1039287934)
		 + W(7, -1117545451, 1054067798, -1097217844, -1113687714);
	sum2 = W(0, -1130009672, 1013515790, 1013756514, -1153587550)
		 + W(1, 1027809153, -1106180134, 1023886448, 1024050371)
		 + W(2, -1106384796, 1042067106, 1052609397, -1094102229)
		 + W(3, 1051460883, -1094561503, 1078005003, -1070026280)
		 + W(4, -1104521112, 1032257325, 1072194837, -1075632186)
		 + W(5, 1033821004, -1124940473, -1094906083, 1053282219)
		 + W(6, -1112259960, -1168427353, 1046140857, -1098407638)
		 + W(7, 1028508475, -1120291522, -1140922271, 1033718481);
	WS(1063327007, -1121248448);
	sum1 =
		W(0, 1017612078, -1113236667, 1042967269, 1035231217) + W(1, 1043030576, -1096763312, 1049218219, -1115130868)
		+ W(2, 1039059525, -1091103118, 1058517677, -1107367965) + W(3, -1115811128, 1053297652, 1033504868, 1009543939)
		+ W(4, -1095615210, 1063340055, -1082785422, 1047061435)
		+ W(5, -1099887459, 1054079124, -1088587000, 1042859328)
		+ W(6, -1140707177, 1041492110, -1101731443, -1120288724)
		+ W(7, -1120397682, -1126620524, 1029718569, -1104957341);
	sum2 = W(0, 1037909727, -1119813454, -1099212072, 1032936033)
		 + W(1, -1098298527, 1048025725, 1045330821, -1097673782)
		 + W(2, -1126569464, 1041835288, -1106229244, -1109675885)
		 + W(3, -1106955476, 1067026849, 1067954224, -1092590328)
		 + W(4, -1096969233, -1085288934, -1095495837, 1004812688)
		 + W(5, -1118592354, 1042571631, -1108169766, -1096486003)
		 + W(6, 1042882430, -1117602980, -1164085849, 1034064234)
		 + W(7, 1037216424, -1116313332, -1100305071, 1045459772);
	WS(-1114652667, 1051933605);
	sum1 =
		W(0, 1026700110, -1102428549, 1043087092, -1109604752) + W(1, 1037508767, -1105027032, 1048715843, -1113263092)
		+ W(2, -1128033780, -1106431647, 1062796090, -1098797270)
		+ W(3, 1034155035, 1043250735, -1089603768, 1023780992)
		+ W(4, -1102462575, 1059213449, -1090890112, -1112475685)
		+ W(5, 1024543544, 1038435705, -1106007014, -1121524254) + W(6, -1147042251, 1038748492, -1119096106, 986589794)
		+ W(7, 1032374633, 1016229610, -1104514210, 1007891224);
	sum2 = W(0, -1129141996, 1043866561, 1029019378, 1050935854)
		 + W(1, -1106880495, -1096921120, -1092013580, -1111274547)
		 + W(2, 1031191254, -1123077406, -1086673510, -1096956427)
		 + W(3, -1102244397, 1064276171, 1064706574, -1115781076)
		 + W(4, -1101040753, 1061828176, -1113110329, -1106057540)
		 + W(5, 1046080919, -1095750750, -1091369762, 1029696990)
		 + W(6, -1112883155, 1042185570, 1042119352, -1113619581)
		 + W(7, 1031234782, -1128566730, -1105256367, 1012473722);
	WS(1059465279, -1101420399);
	sum1 =
		W(0, 1033088680, 1043444330, -1101682761, -1124073107) + W(1, -1124176798, 1000916382, -1126261266, -1118729178)
		+ W(2, 1014063089, 1057398923, -1089602004, 1032573720) + W(3, 1035053989, 1034190184, 1039770557, -1114558729)
		+ W(4, 1045820204, -1087528660, 1057859064, -1096323421) + W(5, 1038292302, 1036787650, -1106381771, 1041172764)
		+ W(6, -1115007182, 1027988010, -1104773247, 1024683157)
		+ W(7, -1131477704, 1042732770, -1102530758, 1029511616);
	sum2 = W(0, -1093261173, -1081648717, -1107343332, 1020947921)
		 + W(1, -1100338012, -1096055698, 1016623505, -1121572837)
		 + W(2, 1016590929, 1049309077, 1058913944, 1035038069) + W(3, -1160318928, 1060463741, 1061699617, -1121635630)
		 + W(4, -1111261089, -1123677731, -1095509190, -1116667427)
		 + W(5, 1032510827, 1042247124, 988275856, -1130213341) + W(6, 1037987285, 1035681279, -1111758125, 1033159595)
		 + W(7, -1106728517, 1035240533, 979544481, -1112486763);
	WS(1060076127, 1072958059);
	sum1 =
		W(0, -1103118654, -1090537599, 1060753617, -1129584897) + W(1, 1043365506, -1097065432, 1046496158, 1025963976)
		+ W(2, -1115420333, -1086314390, 1060760746, -1106610556)
		+ W(3, 1031523031, -1088162978, 1055888777, 1040410096) + W(4, 1033412302, -1089193875, 1052645932, -1138875303)
		+ W(5, 1032254402, -1091959462, 1054239287, 1032279415) + W(6, 1031863013, -1111327644, 1044639698, 1032182482)
		+ W(7, -1127560355, -1086013855, 1056703661, 1044337291);
	sum2 =
		W(0, 1034238418, -1122429687, 1038471498, -1105287037) + W(1, 1026722605, -1113650971, 1047703041, -1106809975)
		+ W(2, -1123083006, -1101416602, 1050567163, -1099784158)
		+ W(3, 1044566349, -1095747837, 1073798913, -1077245954)
		+ W(4, -1114043742, 1044375513, 1074668356, -1072322090) + W(5, 1029836970, 1032414162, 1076147895, -1070521946)
		+ W(6, -1124457715, -1132025334, 1076524889, -1071353549)
		+ W(7, -1112207598, -1112893824, 1071535287, -1076180558);
	WS(-1114470395, -1114976351);
	sum1 = W(0, 1017446070, 991904560, 1034584479, -1110976571) + W(1, 1040990896, 1041627584, -1107221597, -1099251857)
		 + W(2, -1129681934, 1047992216, -1115356259, -1111571481)
		 + W(3, -1120446036, 1061349282, -1083497834, 1039733326)
		 + W(4, -1097641691, 1061559014, -1089507216, 1036247843)
		 + W(5, -1110115727, 1055187519, -1098995485, -1114440077)
		 + W(6, -1110184487, 1045114861, -1109668803, -1115117640)
		 + W(7, 1033457695, 1047040436, -1107186297, -1120899067);
	sum2 = W(0, -1093678598, -1084434022, 1064533419, 1042743345)
		 + W(1, 1002676269, 1057422860, 1067683118, -1108978134)
		 + W(2, 1055748356, 1066493380, -1078621547, -1117769694)
		 + W(3, 1044340647, -1079318791, -1079939901, 1015093293)
		 + W(4, -1118111722, -1116089022, 1054002901, 1049699290) + W(5, -1120084888, 1044705221, 1039926847, 986467602)
		 + W(6, 1001595675, -1112694927, -1112070298, -1107171922)
		 + W(7, -1123642691, 1031220790, 1023903081, 1037662763);
	WS(1048785023, 1039045299);
	sum1 =
		W(0, -1104130562, -1090140327, 1061197562, -1133671882) + W(1, 1043168659, -1100442863, 1040570004, 1032880081)
		+ W(2, -1117502116, -1085428843, 1062309944, -1102819715)
		+ W(3, 1029857553, -1093347651, 1050495728, 1038995485) + W(4, 1034838603, -1089406196, 1050259320, -1127149063)
		+ W(5, 1027207566, -1093521697, 1054560318, 1026681976) + W(6, 1024393315, -1120775857, 1039464338, 1035433414)
		+ W(7, -1130533431, -1086838999, 1056208688, 1041402190);
	sum2 =
		W(0, -1118465298, -1142302474, -1114395216, 1037219807) + W(1, 1011712973, 1025023956, -1104707163, 1039062755)
		+ W(2, -1128433260, 1041730218, -1095905892, 1046574176)
		+ W(3, 1029767219, -1097771962, -1080533844, 1069124140)
		+ W(4, 1021354231, -1094677866, -1075595300, 1073795377) + W(5, 982009542, -1122047812, -1072373863, 1075522683)
		+ W(6, 1014788797, 1028525757, -1072719492, 1074436097) + W(7, 1033540398, 1020814500, -1078361330, 1068741752);
	WS(1040594174, 1002085105);
	sum1 =
		W(0, 1041861603, -1113198522, -1137236930, 1041085614) + W(1, -1097746587, 1055071640, -1100468781, -1121524679)
		+ W(2, 1032164980, -1088672026, 1047493466, -1109849488) + W(3, 1031577622, 1050744420, -1105375081, 1048884604)
		+ W(4, -1102982955, 1057599999, -1087672398, -1113508732)
		+ W(5, 1044101411, -1103363988, 1050064611, -1098107838) + W(6, 1034678964, 1036351259, -1102178050, 1043931332)
		+ W(7, 1026039088, 1034848362, 1033863059, -1106488144);
	sum2 = W(0, -1099743490, 1011906269, 1037961444, -1108436276) + W(1, 1035577370, 1026663055, -1152297667, 991169347)
		 + W(2, -1115293072, 1057096352, -1095995741, 1045881501)
		 + W(3, -1102421679, 979639118, 1050233559, -1097952901) + W(4, 1038726510, 1044440375, 1022991474, -1122343653)
		 + W(5, 1032210717, 1032214892, -1139108605, 1026937641)
		 + W(6, -1107407193, 1028754425, -1115369483, -1105994898)
		 + W(7, -1120037205, -1123040177, -1104470915, 1022469878);
	WS(1066613200, -1123971367);
	sum1 =
		W(0, 1021072883, -1096708150, 1051074184, 1026036124) + W(1, -1125712504, -1090955664, 1051398158, -1108624754)
		+ W(2, 1041158633, -1159875842, 1058934814, 1040756057)
		+ W(3, -1106077125, -1079911082, 1061682240, -1090753503)
		+ W(4, 1036847484, -1093258685, 1055629981, -1114271443) + W(5, 1032267227, -1103560179, 1054180539, 1025501945)
		+ W(6, 1016782186, -1089925031, 1052861897, -1105228376)
		+ W(7, 1031886911, -1106725252, 1047227273, 1043536294);
	sum2 = W(0, -1120579723, -1102098813, -1103583809, 1039910130)
		 + W(1, -1104595791, 1059079365, 1035649855, -1110832147)
		 + W(2, 1060943463, -1078775742, 1055196914, -1115424415)
		 + W(3, -1081375340, 1070420847, 1036446407, -1092581761)
		 + W(4, 1048074442, -1106373275, 1050043459, -1101688097)
		 + W(5, 1049316438, -1084015554, 1050724789, -1115969635)
		 + W(6, -1088959333, 1065759760, -1088425301, 1051846236)
		 + W(7, 1054216959, -1087995034, 1052608338, -1103333947);
	WS(1015488492, -1082266482);
	sum1 = W(0, -1115294884, -1096364772, 1054950795, -1109722877)
		 + W(1, 1041881447, 1036768790, 1051075280, 1018280484)
		 + W(2, -1116482020, -1083421327, 1062057653, -1105734603)
		 + W(3, 1028536641, -1079950554, 1057564011, -1124656723)
		 + W(4, 1044897017, -1088856963, 1054170231, -1129161159)
		 + W(5, -1108243791, -1096513911, 1056273768, -1113027740)
		 + W(6, 1033207234, -1104622888, 1056919206, -1132093050)
		 + W(7, 1015505847, -1096156044, 1054606378, 1025701004);
	sum2 = W(0, -1103335141, -1123809016, 1056172663, -1093357581)
		 + W(1, -1087173612, -1080484881, 1047550056, -1112078382)
		 + W(2, 1045744538, 1068142929, 1051886373, -1102262951)
		 + W(3, -1106751239, 1065979347, 1064817240, -1097769156)
		 + W(4, -1089877767, 1048007586, 1065470183, -1095892093)
		 + W(5, 1054342226, -1086806497, -1098340366, 1033891425)
		 + W(6, 1047940388, -1098712592, -1102735881, -1105000175)
		 + W(7, -1120076732, -1082944418, -1088981287, 1059622670);
	WS(-1089551423, -1072840444);
	sum1 =
		W(0, 1041019406, 1055991358, -1086576149, 1027645528) + W(1, 1022173115, 1057526040, -1100702364, -1141651861)
		+ W(2, -1113297010, 1036785718, -1093552675, 1016689751) + W(3, 1015463395, 1059475300, -1089572736, 1031793146)
		+ W(4, -1103473726, 1056836657, -1091007140, -1125097480)
		+ W(5, 1040814976, 1050051043, -1090411145, 1041821422) + W(6, 1007312016, 1050846086, -1098618125, 1015074267)
		+ W(7, 1029778436, 1053584058, -1097362556, -1104623366);
	sum2 =
		W(0, 1069423067, -1076703167, 1041694716, 1032293264) + W(1, 1072187327, -1073855626, -1115348910, 1008297781)
		+ W(2, 1072064387, -1079134619, -1107764634, -1120515458)
		+ W(3, 1072314518, -1077864031, -1089838794, 1037018177)
		+ W(4, 1066704589, -1081021850, 1036250076, -1121141704) + W(5, 1063804587, -1081933355, 1028352388, 1025803257)
		+ W(6, 1053139391, -1094622730, -1114321992, -1123317222)
		+ W(7, 1042659879, -1099654949, 1035224325, 1027779018);
	WS(1053893247, -1106302313);
	sum1 =
		W(0, 1031892188, 1044357278, -1093335703, -1124627014) + W(1, -1110506435, 1051962248, -1098499127, -1121076939)
		+ W(2, -1127073177, 1061666784, -1085429924, 1038775118) + W(3, 1047997302, 1064449402, -1082436051, 1042378233)
		+ W(4, 1033243951, 1041901099, -1118050391, -1100759903)
		+ W(5, -1107646187, 1053582704, -1104422127, -1107823800)
		+ W(6, -1112186286, 1037482077, -1118004236, -1134911574)
		+ W(7, -1112631434, 1050110011, -1103845867, -1111029158);
	sum2 = W(0, 1045534781, -1106914963, -1093884354, 1048929407)
		 + W(1, -1136883904, -1105365809, 1058094665, -1099297773)
		 + W(2, 1027794169, -1087950271, -1076257974, 1057853479)
		 + W(3, -1091599460, 1049402813, 1070891205, -1101014716)
		 + W(4, -1105954111, 1059435817, 1057695328, -1088483015)
		 + W(5, -1110353364, 1056244223, -1096007662, -1116753268)
		 + W(6, 1026306116, -1106437513, 1042940020, -1107558514)
		 + W(7, -1105327762, 1049633694, 1019026622, -1111740866);
	WS(1043803134, 1031905225);
	sum1 = W(0, -1113675573, 1045344728, -1093561052, -1125193272)
		 + W(1, -1137620096, 1015450714, 1039772705, -1142985628)
		 + W(2, 1045527725, 1036603287, -1087612823, 1043570724) + W(3, 1047471777, 1057861093, -1131204708, 1032608022)
		 + W(4, 1025442024, 1007995990, -1109713128, -1125123818)
		 + W(5, -1101766076, 1048683192, -1098589181, 1017746514)
		 + W(6, 1041363873, -1103914745, -1142310312, -1137687994)
		 + W(7, -1104559247, 1053784172, -1096789826, -1120823545);
	sum2 =
		W(0, -1102611800, 1052608919, -1092971881, 1033368250) + W(1, 1042572795, -1112317124, 1050084573, -1099740129)
		+ W(2, -1143715563, 1036000712, -1099050864, 1046340985) + W(3, 1047906835, 1058925768, 1062269077, -1106615878)
		+ W(4, 1034463821, -1089628524, -1100033854, -1143169701)
		+ W(5, -1097650393, -1097284017, -1155008883, 1034459058)
		+ W(6, 1044772028, -1090965565, 1043620595, -1102441858)
		+ W(7, -1105069125, 1053414419, -1099181286, -1145018737);
	WS(1065606800, 1041895077);
	sum1 =
		W(0, 1041785011, 1041397665, -1108226929, -1113822832) + W(1, -1113293285, 1050236482, -1089967688, -1105474774)
		+ W(2, 1031552121, 1063682744, -1092426598, 1045393909)
		+ W(3, -1114204019, 1055253222, -1085544687, -1106251932)
		+ W(4, 1014586031, 1057927896, -1092878524, 1018782386) + W(5, 1032452466, 1054837340, -1094102329, -1135035573)
		+ W(6, -1103346054, 1043307490, -1097746379, -1114747425)
		+ W(7, 1025447425, 1058487624, -1098262983, -1119448485);
	sum2 =
		W(0, 1038489223, -1094743304, -1079775068, 1069957645) + W(1, 1032193624, -1106563024, -1075431018, 1074314813)
		+ W(2, -1137158564, 1029053577, -1075905408, 1067854461)
		+ W(3, 1048862753, -1103121169, 1061439417, -1090496129)
		+ W(4, -1107218869, 1018988618, 1061842524, -1083145579)
		+ W(5, -1112577633, 1015522148, 1055667456, -1093776696) + W(6, 1034028859, -1107822714, 1032002642, 1038458963)
		+ W(7, -1110240510, 1017646246, 1047594841, -1100108785);
	WS(1050857279, 1035401177);
	sum1 =
		W(0, 1029370009, 1049972466, -1100844155, -1114359850) + W(1, -1121232094, 1045749679, -1097541146, -1119608387)
		+ W(2, -1118971861, 1054737744, -1089471141, 1032044074)
		+ W(3, -1116554354, 1064433520, -1088203652, 1039513726)
		+ W(4, -1102118870, 1057059356, -1089223685, 1028806533) + W(5, 1035949272, 1055161550, -1095333099, 1039358524)
		+ W(6, -1118591397, 1035470985, -1098430605, -1114373271)
		+ W(7, -1155732684, 1050840570, -1105548665, -1113669781);
	sum2 =
		W(0, 1034282103, 1040723224, 1028955705, -1104697256) + W(1, -1111920318, -1118965841, 1031483971, -1123254751)
		+ W(2, 1023538768, -1128437695, 1043259383, 1034554870)
		+ W(3, -1133376386, 1038672881, -1148076972, -1078609243)
		+ W(4, -1119100907, 993338648, -1084940093, -1075024478) + W(5, 1014776166, 1050613235, 1050550535, -1100774866)
		+ W(6, -1117007635, -1108740075, -1098463376, 1069274341)
		+ W(7, -1121555310, 1040276790, 1054296012, 1072481706);
	WS(1059068159, -1095269543);
	sum1 =
		W(0, 1022243158, 1058751902, -1083015108, 1040310153) + W(1, -1126585055, 1052633434, -1095802212, 1009201364)
		+ W(2, -1113503115, 1061437964, -1083734386, 1040208083)
		+ W(3, 1034732162, 1062365313, -1087136899, -1116554445) + W(4, 1029695369, 1054753811, -1089074173, 1044292534)
		+ W(5, 1045709362, 1047783152, -1093733821, -1141695574) + W(6, 1005846771, 1043895001, -1096742887, 1042140272)
		+ W(7, 1049870212, -1119990530, -1106170901, -1106848091);
	sum2 =
		W(0, -1110453349, 1048158098, 1064329884, -1096499673) + W(1, -1118716929, -1117235638, -1122504669, 1023790996)
		+ W(2, -1111084235, 1037169053, 1037379653, 1035642078) + W(3, 1027079271, 1044450691, -1106426334, -1103100998)
		+ W(4, 1058163522, -1086959067, -1081956377, 1059064502)
		+ W(5, 1060433363, -1096141012, -1081432626, -1109003581)
		+ W(6, 1058751114, -1102281652, -1086790317, 1048822766)
		+ W(7, -1077532089, 1061563184, 1073667932, -1089552462);
	WS(-1079238176, -1098575359);
	sum1 =
		W(0, -1122061272, 1040856756, -1106993315, -1113276757) + W(1, 1012614613, -1098659523, 1049053518, -1110111537)
		+ W(2, 1049213476, 1050219649, -1088887964, 1048270483) + W(3, -1091368434, 1046432350, 1061247706, -1098550683)
		+ W(4, 1050034455, -1092787824, -1113029435, 1053252708)
		+ W(5, -1115399887, 1045840143, -1096901418, -1120030007)
		+ W(6, -1105000541, -1102913028, 1045569657, -1144293604)
		+ W(7, 1040609063, -1104981396, -1106428832, 1037272948);
	sum2 = W(0, 1035271628, -1096995906, -1097624644, 1051183735)
		 + W(1, 1033447544, 1032410306, 1048740225, -1095652467)
		 + W(2, -1113618952, 1053850685, -1109777102, 1037584786)
		 + W(3, -1104023060, 1054515359, 1058355960, -1116173683)
		 + W(4, 1022009109, -1114408860, -1139294461, -1096371453)
		 + W(5, -1104458884, 1030897990, -1116975083, 1030595307)
		 + W(6, 1044684178, -1115683354, -1099524388, -1117706649)
		 + W(7, -1104406640, -1106540716, 1036671037, -1108415342);
	WS(1064155455, 1041078114);
	sum1 =
		W(0, -1114884791, -1133388468, 1031759625, -1116707016) + W(1, 1038026665, -1103926126, 1051074474, -1135572861)
		+ W(2, 1040569148, -1088265213, 1049866386, -1145284192)
		+ W(3, -1123095214, -1088521037, 1060913876, -1110455500)
		+ W(4, -1113346810, -1094483240, 1044072016, -1116167073)
		+ W(5, -1098688777, 1052099081, 1034732568, 1029730485) + W(6, -1106297864, 1038941559, -1138713347, 1017022612)
		+ W(7, 1033022404, 1027852876, 1019301565, 1028095637);
	sum2 = W(0, 1027468398, -1120484835, 1033713911, 1037828351)
		 + W(1, -1111732215, -1115316427, -1113615213, -1102210431)
		 + W(2, -1149402831, 1042551085, 1015721118, 1027887653)
		 + W(3, -1136133524, -1101059653, 1005178376, -1105049969)
		 + W(4, 1058132410, 1067179636, -1112798365, 1033627060)
		 + W(5, -1084703700, -1093846517, 1036573120, -1112780439)
		 + W(6, -1103172541, 1015696434, 1035924289, 1025169534)
		 + W(7, 1011948492, -1119207903, -1106241198, 1034168377);
	WS(1056869759, -1097268032);
	sum1 = W(0, 1018133293, 1036411431, 1039633317, -1111689725)
		 + W(1, -1105532941, 1007771751, 1034605623, -1107937040)
		 + W(2, 1027243330, -1116024394, 1050783724, -1105991139)
		 + W(3, -1097428310, 1032024955, 1010531964, -1109581452)
		 + W(4, -1099204213, -1130187397, 1045069064, -1103861656)
		 + W(5, -1133851766, 1034973653, 1044277428, 1044990678)
		 + W(6, -1138393927, -1114469768, 1046520720, -1106353867)
		 + W(7, -1118550618, -1118964077, 1036629184, -1155661924);
	sum2 =
		W(0, 1031819015, 1040620760, -1130428603, -1130628701) + W(1, -1113612713, 1045122152, -1113774176, -1118722775)
		+ W(2, 1040659447, -1122637452, -1093905874, 1015363301)
		+ W(3, -1113225510, -1080510307, -1073670430, -1129641903)
		+ W(4, 1023788280, -1103769905, 1040925011, 1045479736) + W(5, -1115035325, 1050277803, 1074164392, 997650792)
		+ W(6, 1009487418, 1041168723, 1056579340, 1043373785) + W(7, 1023947578, -1112728330, 1044922942, -1122436477);
	WS(1064095487, 1025785067);
	sum1 =
		W(0, 1026371284, -1106851535, -1128892272, 1040514533) + W(1, -1097495743, 1042476562, 1049973404, -1103190740)
		+ W(2, 1050378694, -1104849584, -1115675316, 1040022019) + W(3, 1008396404, -1085976658, 1058008769, 1040395090)
		+ W(4, 1042871873, -1097042470, -1098054097, 1050097558)
		+ W(5, -1103138663, -1109264236, 1052615848, -1102548473)
		+ W(6, -1136206974, 1035073279, 1037088776, -1157051795)
		+ W(7, 1034556564, -1094929447, 1045135411, 1023679636);
	sum2 =
		W(0, -1124722923, 1033420628, -1105442746, 1029168594) + W(1, -1114618025, -1100145939, 1047309531, 1048079041)
		+ W(2, 1043439029, -1115804833, -1084852425, -1101613108)
		+ W(3, 1036363299, 1057589449, -1089136554, 1042227257) + W(4, -1096133271, 1053618149, 1028964970, 1045151454)
		+ W(5, 1049502378, -1091358477, 1056312267, 1041752672) + W(6, -1106999272, 1030436134, -1100909906, 1036382707)
		+ W(7, 1013819494, -1119548384, 1043379377, -1113267324);
	WS(1060109055, 1023402244);
	sum1 = W(0, 1039025762, 1051909299, -1098089231, -1107880995)
		 + W(1, -1109278395, 1054481389, -1093104548, 1018380380)
		 + W(2, -1125210976, 1061074499, -1087624466, -1167447218)
		 + W(3, -1107337262, 1069080830, -1092709234, -1119879878)
		 + W(4, -1119314274, 991275263, -1085745760, 1030906608) + W(5, 1038278743, 1049054227, -1093068092, 1028271716)
		 + W(6, -1120902815, 1043342663, -1102438460, -1122586985)
		 + W(7, 1024999351, 1051802331, -1098889074, -1107737008);
	sum2 =
		W(0, 995982518, 1035578813, -1118279893, -1115504751) + W(1, 1033194341, -1121421677, -1114972659, -1108849613)
		+ W(2, 1038373562, 1046888388, 1069469835, 1041670894) + W(3, 1040171687, -1103362299, 1078927590, 1050450381)
		+ W(4, -1108098969, 1050255581, -1065023683, -1097423961)
		+ W(5, 1027047733, -1096418856, -1082214759, -1114805949) + W(6, -1147696971, 1042040695, 1045909115, 964966831)
		+ W(7, 1033796110, -1116244525, -1112457727, 1025540676);
	WS(-1092049407, -1078216845);
	sum1 = W(0, 1019093687, 1057591089, -1089127853, -1109784091)
		 + W(1, 1030002432, 1050969332, -1096074010, 1043174565)
		 + W(2, -1100550858, 1056027116, -1082843219, -1126191805)
		 + W(3, 1055647027, 1063070242, -1088645600, 1049441628)
		 + W(4, -1103872766, 1039049940, -1097545633, -1097650089)
		 + W(5, 1041444210, 1057957242, -1095349663, 1024042875)
		 + W(6, -1115845919, 1034942714, -1103665506, -1123963793)
		 + W(7, 1042339236, 1059965491, -1089209262, -1105758607);
	sum2 =
		W(0, -1086426610, 1062347208, 1053593730, -1108806990) + W(1, -1096143108, 1055082976, -1101252044, -1138780047)
		+ W(2, -1089951657, 1045157118, -1111940928, -1099705126) + W(3, 1062855195, 1048769854, 1037201995, 1058343455)
		+ W(4, 1068897447, -1073459143, -1091098547, -1094950430)
		+ W(5, 1074016711, -1078468086, -1119407664, 1046274438)
		+ W(6, 1075026151, -1071781830, 1031118734, -1128975824)
		+ W(7, 1074160921, -1072043968, -1095931446, 1035271906);
	WS(-1092377983, 1032564911);
	sum1 =
		W(0, 1026968586, 1051240140, -1140824311, -1108814006) + W(1, 1001025293, -1135919542, -1114206145, 1031981930)
		+ W(2, -1101464865, 1047585891, 1035412731, -1105914151)
		+ W(3, -1099757657, 1046337282, -1093593858, -1111723206)
		+ W(4, -1099131534, 1042168181, 1042300945, -1114245051) + W(5, 1021990836, 1042765483, -1105010841, 1047084274)
		+ W(6, -1124857771, 1039475666, -1129901419, -1110153104)
		+ W(7, 1016095931, 1031087233, -1150842169, 1021006644);
	sum2 = W(0, -1152594313, -1103837493, -1119502913, 1035550709)
		 + W(1, -1114711758, -1102219265, 1049238470, -1111809635)
		 + W(2, -1122222477, 1021928584, 1051353268, 1038283603)
		 + W(3, -1119994373, 1043085394, 1069806319, -1113383091)
		 + W(4, -1117872135, -1098150014, 1040245198, 1038911980)
		 + W(5, -1136114154, -1114380427, -1084770114, -1106271331)
		 + W(6, -1118889611, -1103586212, -1097500544, -1109409577)
		 + W(7, -1120239593, 999997765, 1032457879, -1130668925);
	WS(1066805616, -1146277627);
	sum1 =
		W(0, -1135230785, -1097679853, 1046488473, 1036204713) + W(1, -1149155717, -1106566573, 1047676826, -1098488427)
		+ W(2, 1034010150, -1092037473, 1047117051, -1103697017) + W(3, 1042337650, -1085421897, 1062693860, 1057957971)
		+ W(4, -1127867356, -1091217395, 1049537116, -1114566390)
		+ W(5, 1036367663, -1094061036, 1056189429, 1034870184) + W(6, 1011804270, -1108406741, 1017502967, -1103604141)
		+ W(7, 998521116, -1096997053, 1049188263, 1029261884);
	sum2 = W(0, -1122819855, 1035645255, -1107161682, 1042480496)
		 + W(1, 1029215207, -1111163705, 1019166485, -1107159841)
		 + W(2, -1109976389, 1026839491, -1129473215, -1115971786)
		 + W(3, 1044451524, -1095838714, 1082201538, -1067229991)
		 + W(4, -1130065951, -1147512571, 1052773623, -1091650896)
		 + W(5, 1027965847, -1156411358, 1033233466, -1142132409)
		 + W(6, -1119702735, -1110332882, 1034307583, -1107215185)
		 + W(7, 1036873692, -1114357123, 1001850219, 1025815163);
	WS(1040205182, 1040987841);
	sum1 =
		W(0, 1032709552, 1050828331, -1098789018, -1130845956) + W(1, 1028035406, 1054299632, -1102534446, -1131566290)
		+ W(2, -1152624047, 1000765841, -1087146945, 1024089890) + W(3, 1047238622, 1064828620, -1084918512, 1044521480)
		+ W(4, -1110798127, 1059217829, -1080798168, 1041701723)
		+ W(5, -1160283945, 1057730984, -1094152707, -1105870556)
		+ W(6, -1129145589, 1050797759, -1154982570, -1121779940)
		+ W(7, 1035307633, 1040620053, -1104995442, -1110323595);
	sum2 = W(0, -1104834685, 1039834326, 1040649104, -1113573633)
		 + W(1, -1098615503, 1050496819, 1034170750, -1119108596)
		 + W(2, -1090508283, 1045914856, -1118657109, -1128160390)
		 + W(3, -1080862372, 1070974917, -1102559609, -1095002000)
		 + W(4, 1048874616, -1085801376, 1041220807, 1053594264) + W(5, 1063492499, -1081343708, 1047362948, 1022825140)
		 + W(6, 1035824034, 1033985362, -1099586035, 1041895669)
		 + W(7, 1062512173, -1089072248, -1130222490, -1115149866);
	WS(-1087487423, 1060332710);
	sum1 = W(0, -1105878689, -1095746139, 1053913286, 1037671952)
		 + W(1, 1042437466, -1089004262, 1055197099, -1117440135)
		 + W(2, 1040585322, -1081828961, 1059867107, -1114610404)
		 + W(3, -1121111477, -1099866351, 1061690846, 1028605502)
		 + W(4, -1112195269, -1115422148, -1104536871, 1040822242)
		 + W(5, -1112892785, 1039314504, -1102951638, 1041433743)
		 + W(6, -1122925576, -1117471766, -1107184778, 1048192776)
		 + W(7, 1012646976, -1108492170, -1130420108, 1029799624);
	sum2 = W(0, 1017331955, -1097747777, -1097037835, -1162485367)
		 + W(1, -1104677463, 1040900608, 1016355419, -1104406873)
		 + W(2, -1117673238, -1081336501, -1089023490, -1117660642)
		 + W(3, -1094338757, 1073518733, 1068423959, -1096388411)
		 + W(4, -1119646366, -1103573743, 1048344480, -1093216188)
		 + W(5, -1104710153, -1106204508, 1057220074, 1028492960)
		 + W(6, -1107625181, 1041186571, 1033091565, -1092192530)
		 + W(7, 1022869095, -1097636016, 1053959289, 1049060345);
	WS(-1096756863, 1051174382);
	sum1 =
		W(0, 1025372546, -1115668125, 1000611497, 1034391118) + W(1, -1106905723, 1039995714, -1105014230, 1041916975)
		+ W(2, -1114360751, 1043101563, -1117013085, 1027806076)
		+ W(3, 1025624474, -1089490746, 1058174613, -1111998130) + W(4, 1037998160, -1092891318, 1045000731, 1008039732)
		+ W(5, 1032794399, -1107085565, 1035643438, 1030397185) + W(6, 1034992970, -1114405501, -1121180749, 1018926829)
		+ W(7, -1114244794, -1168885266, -1120880459, 1029203969);
	sum2 =
		W(0, -1089960886, -1095856011, 1007316785, 1036775569) + W(1, -1092452707, -1106157919, 1041476280, -1107942220)
		+ W(2, 1049541326, 1074170001, 1050706137, 1021239050) + W(3, 1032119458, -1085150802, -1083810164, -1132331444)
		+ W(4, 1032929374, 1046048366, 1043182557, 1036225521)
		+ W(5, -1110883627, -1112079347, -1129593193, -1113579728)
		+ W(6, -1123073435, 1027735021, -1214669080, 1009639193)
		+ W(7, 1026522309, -1111935169, 1009058861, 1022066674);
	WS(1063524863, 1010978751);
	sum1 = W(0, 1033376264, -1090913225, 1054337940, 1034437913) + W(1, 1035248130, -1094935586, 1045510498, 1040021853)
		 + W(2, 1029138555, -1084407830, 1057961148, -1141033844)
		 + W(3, 1040606570, -1085174115, 1062831778, 1032741433)
		 + W(4, -1146340206, -1080254739, 1060252175, -1127614262)
		 + W(5, -1122169062, -1094320024, 1058700983, -1136275261)
		 + W(6, -1113033206, 1033710501, 1045946247, 1007782611) + W(7, -1115451138, 955403507, 1033261261, 1030604567);
	sum2 = W(0, -1096400044, 1053621644, 1017015195, 1037111777) + W(1, 1043917783, 1009306318, 1005897821, -1106811629)
		 + W(2, -1123678571, 1051339656, -1141989437, 1047789047)
		 + W(3, -1090244436, 1062093709, 1065539532, -1093438727)
		 + W(4, 1046901313, -1080576226, -1083332175, 1049955112)
		 + W(5, 1048870815, -1106342004, -1097183812, 1043219374)
		 + W(6, 1033884063, -1098524562, -1097464341, 1050393105)
		 + W(7, 1053211427, -1124418811, -1092155120, 1044056917);
	WS(-1085369887, -1080302329);
	sum1 = W(0, 1021216124, -1112260523, 1035888345, -1110274640)
		 + W(1, -1121762938, -1119192737, 1049037307, -1111476420)
		 + W(2, -1103047566, 1050211017, 1061443675, -1097892613)
		 + W(3, -1094342263, 1058411732, 1044828010, -1097171068)
		 + W(4, -1105630871, -1139271463, -1119204121, -1112160677)
		 + W(5, -1107174593, 1042276856, -1100915542, 1026261917)
		 + W(6, 1025950537, -1113852108, -1174284878, -1110403297)
		 + W(7, -1146340105, -1119668597, -1119790119, -1132483222);
	sum2 = W(0, -1115512925, 1035074177, -1191992884, -1115656893)
		 + W(1, -1146353705, 1040461813, 1043381354, -1137020948) + W(2, 1036066439, 1042528734, 1059049535, 1021899784)
		 + W(3, -1134998124, 1058355837, 1058956516, -1112812041)
		 + W(4, -1093678923, -1081621864, -1095612272, 1012903452)
		 + W(5, -1122018103, -1089980594, 1050844919, -1123282157)
		 + W(6, -1110317749, 1049357806, -1100731037, -1122890057)
		 + W(7, 1002801625, -1101025299, 1036998024, 1023124620);
	WS(-1106521214, -1077666555);
	sum1 = W(0, 1003321829, 1052142545, -1102912320, -1108686032)
		 + W(1, -1120901013, 1052094618, -1105733097, -1118608535)
		 + W(2, -1105222370, 1060439250, -1085669204, 1045702647)
		 + W(3, -1107011833, 1059969903, -1113880763, -1106161276)
		 + W(4, 1029823211, -1095361591, 1052882623, -1103122454)
		 + W(5, 1000924822, 1039904896, -1107186882, -1106172071)
		 + W(6, -1127794128, 1000548911, -1118745688, -1113781993)
		 + W(7, 1027793952, 1046166153, -1096551831, -1132637458);
	sum2 = W(0, 1034079401, 1025264110, -1123371956, -1116991392)
		 + W(1, -1123608512, -1119278092, -1104246380, -1156408861)
		 + W(2, 999851902, 1031056700, 1051208451, -1098806852) + W(3, -1128074608, 1059405503, 1063218900, 1038716729)
		 + W(4, -1102099502, -1123208440, -1110007228, -1136590423)
		 + W(5, -1109589984, -1081290516, -1131612640, 1034885175)
		 + W(6, -1127758712, 1015173988, -1124651080, 1009682031)
		 + W(7, 1032460032, -1121242732, 1025045004, -1115963068);
	WS(1061862175, -1081928168);
	sum1 = W(0, -1105584175, -1105871745, 1043886056, 1027658214) + W(1, 1024897880, -1093982770, 1052657028, 992865878)
		 + W(2, 1038516044, -1092069365, 1055074797, -1121064957)
		 + W(3, 1040792761, -1083616743, 1065026281, -1106374835)
		 + W(4, 1041867802, -1089303929, 1056987882, 1015027694)
		 + W(5, -1146323132, -1089274268, 1054263413, -1132520748)
		 + W(6, 1033649803, -1106858177, 1043742846, -1137844354)
		 + W(7, -1113939311, -1096909360, 1049053899, 1017619030);
	sum2 = W(0, 1078367032, 1027322757, 1023449836, -1115583846) + W(1, 1056220347, 1044756153, -1148770222, 993742973)
		 + W(2, -1078889751, -1096547764, 1043960988, -1130380138)
		 + W(3, -1073546091, -1101560565, -1126862726, -1147412718)
		 + W(4, -1104234997, 1042443775, 1029550531, -1115461788)
		 + W(5, -1129365336, 1048890957, -1133306383, 1019814478)
		 + W(6, -1132392998, -1104280017, -1130422948, -1143007558)
		 + W(7, -1105729449, 1028418751, 1042854212, -1123464959);
	WS(1052938943, -1103606318);
	sum1 = W(0, -1114719934, -1087051802, 1058073278, -1114447856)
		 + W(1, -1110318513, -1108424920, 1044445625, 1040769086)
		 + W(2, 1051495307, -1085940948, 1060893495, 1037779432)
		 + W(3, -1100729633, -1082198177, 1058839039, -1103818980)
		 + W(4, 1058926789, -1090825863, 1060585177, 1053070735)
		 + W(5, -1090569589, -1088355266, 1053564817, -1091337376)
		 + W(6, 1050591187, -1096343413, 1054456219, -1131842819)
		 + W(7, -1120060704, -1090847836, 1059253187, 1026807692);
	sum2 = W(0, 1015621136, 1033006755, -1072583370, 1074691924)
		 + W(1, 1032703681, -1098289077, -1084108607, 1067219112)
		 + W(2, 1048700747, -1098808895, -1081224226, 1064576163)
		 + W(3, -1098355550, 1046984196, -1081041246, 1066863963)
		 + W(4, 1047054427, -1083721832, 1069053051, -1084686190)
		 + W(5, -1097901072, 1061110777, 1046858869, -1086075738)
		 + W(6, -1126056922, -1109410901, 1068664236, -1079374171)
		 + W(7, -1165737020, 1047097145, 1076043754, -1071293986);
	WS(-1083248351, 1041375270);
	sum1 =
		W(0, 998616699, -1087439008, 1054645196, 1045294540) + W(1, -1142901727, -1092067298, 1052452449, -1128264947)
		+ W(2, 1043282847, -1097778587, 1050602866, 1042620067)
		+ W(3, -1128981712, -1084179155, 1058025241, -1146688137)
		+ W(4, 1049050406, -1090979219, 1061357806, -1127282486)
		+ W(5, -1110272759, -1086455104, 1053431193, -1125997182) + W(6, 1045114289, -1095775369, 1052134295, 981342481)
		+ W(7, -1170526381, -1087021556, 1053157267, 1046767364);
	sum2 =
		W(0, -1076239116, 1068235144, 1054062613, -1114529265) + W(1, -1079299620, 1068687973, 1019509447, -1116897962)
		+ W(2, -1079042334, 1068481951, 1057377046, 1041823371) + W(3, -1083365485, 1066921525, -1100834259, 1032806429)
		+ W(4, 1049726715, -1106704213, -1095788298, -1104989857)
		+ W(5, 1066758659, -1080829299, -1107253929, -1107915189)
		+ W(6, 1069675355, -1077473679, -1112126912, 1021289065)
		+ W(7, 1075688460, -1073149491, -1090199615, 1034867372);
	WS(-1089965567, 1041739713);
	sum1 = W(0, 1014059625, 1050606464, -1097348868, 1016608410)
		 + W(1, -1109541748, 1046384755, -1098095776, -1110057610)
		 + W(2, -1120181702, 1052952467, -1098227712, -1165355548)
		 + W(3, -1113826001, 1062759283, -1097909490, -1103909923)
		 + W(4, -1099389050, 1061539071, -1089710746, 1018410859)
		 + W(5, -1107441048, 1056969105, -1097990985, -1097884829)
		 + W(6, -1110918155, 1043585729, -1112431723, -1109883584)
		 + W(7, -1129336123, 1054439728, -1101291373, -1118732474);
	sum2 =
		W(0, 1035083591, -1113211599, 1032203968, -1112771443) + W(1, -1112359157, 1037267536, -1129901649, 999833884)
		+ W(2, 1037205500, -1110383577, 1050641640, -1113848439) + W(3, -1119560270, 1053336900, 1062183610, 1048127168)
		+ W(4, -1130432545, 1036846600, 1052549520, -1087091182) + W(5, 1033928454, 1029308948, 1037218786, -1080175934)
		+ W(6, -1111608107, 1035214305, -1098666781, -1106600446)
		+ W(7, 1027763767, -1137000642, 1041216407, -1105808372);
	WS(1040803966, -1079223548);
	sum1 = W(0, -1103550802, -1108233168, -1115946235, 1021078213)
		 + W(1, -1113401739, -1097729981, 1016715200, -1123835458)
		 + W(2, -1105545077, -1112466052, 1051122342, -1103483180)
		 + W(3, -1095164520, 1056711305, 1072346450, -1092700173)
		 + W(4, -1102562113, 1033129898, 1046866637, -1104392485)
		 + W(5, -1106149592, -1100704991, 1041579689, 1033532004)
		 + W(6, -1123094707, -1106323272, 1017795558, -1128003929)
		 + W(7, -1105989383, -1109921151, 1019070562, -1109398092);
	sum2 = W(0, -1132003761, -1097131135, 1033952970, -1114013558)
		 + W(1, -1126076753, -1098724323, -1102131199, 1027012993)
		 + W(2, 1028715469, -1094337061, 1043946979, -1109613274)
		 + W(3, -1094940877, 1075670208, 1037045260, 1026138301)
		 + W(4, -1096054213, -1092647285, 1052392413, -1107006741)
		 + W(5, 1050064171, -1119763725, -1101691459, 1032910718)
		 + W(6, -1095828963, -1104609741, -1104710657, -1127911473)
		 + W(7, 1024912709, -1103386045, 1042676905, -1109320626);
	WS(-1077711088, -1080462700);
	sum1 =
		W(0, 1016976667, -1095463505, 1048382760, 1033669226) + W(1, -1143635214, -1094028818, 1043759401, 1023995271)
		+ W(2, 1050435883, -1084473735, 1060944248, 1038367764) + W(3, 1025648038, -1081613943, 1061061657, -1104130812)
		+ W(4, 1033190198, -1092817267, 1059085444, 1035230572)
		+ W(5, -1119077035, -1089963906, 1058923652, -1115548134)
		+ W(6, -1127874241, -1112556483, 1024757337, 998948881)
		+ W(7, -1124293633, -1096263708, 1052630131, 1035279350);
	sum2 =
		W(0, -1118714905, 1038737245, 1045939428, -1084863446) + W(1, -1128906105, 1033599435, -1124872105, -1120736313)
		+ W(2, -1104617441, 1047074065, 1073600723, 1072627800)
		+ W(3, -1102497202, -1081197801, -1069501955, 1076529178)
		+ W(4, 1052988680, 1051590837, -1078764847, 1066278053) + W(5, 1025452854, 1036478618, -1078626366, -1115729701)
		+ W(6, -1147569173, 1034730428, -1094352359, -1119746081)
		+ W(7, 1045309195, -1096538670, -1097394746, 1001372341);
	WS(-1085605823, 1039908372);
	sum1 = W(0, -1110519177, -1101464226, 1050281295, -1136474287)
		 + W(1, 998302542, -1097280531, 1040574050, 1017687606) + W(2, -1105109851, 1050325520, -1112501642, 1027599892)
		 + W(3, 1051114493, -1093718398, -1095999987, 1038451002)
		 + W(4, 1047758692, -1109283231, 1052111506, -1112873934)
		 + W(5, 1047411644, -1103804777, 1013903280, 1026946257)
		 + W(6, 1008966514, -1107759461, -1131548857, 1007362713)
		 + W(7, 1027414133, -1099881946, 1037344125, 1030395745);
	sum2 = W(0, -1115357326, -1098998597, 1033193484, -1119934044)
		 + W(1, -1129481498, -1104582263, 1041990652, -1109942748)
		 + W(2, 1037423788, -1098625511, 1052524895, 1028176618) + W(3, -1149109833, 1036322812, 1029624616, 1032249206)
		 + W(4, -1107237807, 1050926614, -1102468922, -1117055607)
		 + W(5, -1098320683, 1045914812, 1016354632, 1026298641)
		 + W(6, -1118016391, 1029306918, 1029333966, -1116685452)
		 + W(7, -1111060805, 1035368549, 1036818044, -1113790705);
	WS(1066221936, -1112686252);
	sum1 =
		W(0, -1111426931, 1042737360, 1039181581, -1110677245) + W(1, 1049363148, -1108750629, -1105687720, 1035534704)
		+ W(2, -1090113310, 1053136109, 1051677110, -1101864162) + W(3, 1038796336, -1095853365, 1031102479, 1019901392)
		+ W(4, -1102958241, -1108890233, 1058267293, -1107302241)
		+ W(5, 1041899238, 1023718298, -1089545128, 1048841797) + W(6, -1104001476, 1033191264, 1047293124, -1106653499)
		+ W(7, -1112879133, -1165972390, 1010166848, 989728967);
	sum2 =
		W(0, 1019579309, -1121628281, -1104132268, -1133616314) + W(1, -1115216952, 1041466962, -1110659898, 1046938970)
		+ W(2, -1101014764, 1044350744, -1092586315, -1089581193)
		+ W(3, 1035949455, -1096356807, 1067161402, -1097777539) + W(4, -1125343389, 1019949697, 1044980625, 1025080038)
		+ W(5, 1020295703, 1011899626, 1028945397, 1042942659) + W(6, -1107189524, 1020414781, 1024223321, 1000298789)
		+ W(7, 1032252124, -1108620092, -1106879950, 1034429670);
	WS(1065647552, 1042223795);
	sum1 =
		W(0, -1118213891, -1090185691, 1054600851, 1042956769) + W(1, 1047859212, -1099254654, 1056675965, 1045938459)
		+ W(2, -1102035956, -1085546115, 1052764224, -1095542592)
		+ W(3, 1049817209, -1090115457, 1060918524, 1048397149)
		+ W(4, -1136727619, -1086839140, 1050058698, -1107166488)
		+ W(5, 1018314812, -1089622500, 1053194074, -1115710386) + W(6, 1048950515, -1103143659, 1055030644, 1046421002)
		+ W(7, -1111834851, -1088857895, 1046059111, 1019098869);
	sum2 =
		W(0, 1038047795, 1045715537, 1062099960, -1074982428) + W(1, -1100534663, -1109612723, 1074456323, -1071944747)
		+ W(2, 1043709757, -1109559353, 1074047524, -1086420775)
		+ W(3, -1098906327, -1088589586, 1061406543, -1087600981)
		+ W(4, 1054998296, 1046750383, -1109444720, 1058024333) + W(5, -1097979318, 1030039799, -1095255331, 1040647828)
		+ W(6, 1042447686, -1112135838, -1106577876, 1042372587)
		+ W(7, -1135615252, -1108474833, -1098188594, 1051479186);
	WS(-1099261566, -1102058551);
	sum1 = W(0, 1037460750, -1099740733, 1035868896, 1046250530) + W(1, -1118752449, 1038344912, 1028635221, 1040547388)
		 + W(2, 1048855473, -1097823268, -1135561696, 1049218244)
		 + W(3, 1046116085, -1077722267, -1089090112, 1053686776)
		 + W(4, 1041532007, -1086845489, 1054063629, 1041462458) + W(5, 1043443965, -1109540512, 1036245196, 1041323791)
		 + W(6, 1035797482, -1112472539, 1039520068, -1116084210)
		 + W(7, 1048656673, 1006300060, -1115462467, 1050214602);
	sum2 =
		W(0, -1107023704, -1099880087, 1047853298, -1106650230) + W(1, -1103130345, 1049640504, -1100868353, 1035820630)
		+ W(2, 1025081245, -1099241173, 1050410790, -1111373979) + W(3, 1007138702, 1060797185, -1096656068, 1048085306)
		+ W(4, 1020633935, -1096100738, 1053061345, -1098540289) + W(5, 1042694232, 1034621436, -1092716332, 1045275377)
		+ W(6, -1116958023, -1100840753, 1057695342, -1095110662)
		+ W(7, -1117764771, 1051814059, -1092707384, 1026583068);
	WS(-1081437504, -1086037448);
	sum1 = W(0, 1002898847, 1048903167, -1098037791, -1124004134)
		 + W(1, 1034161364, 1048827465, -1110924302, 1038960439)
		 + W(2, -1097339820, 1058952469, -1089826679, -1109622563)
		 + W(3, -1102052735, 1062493730, -1082951605, 1046141833)
		 + W(4, -1122224578, 1056452878, -1095802941, 1037494008)
		 + W(5, -1116847174, 1052097743, -1093057352, -1142221339)
		 + W(6, -1124219870, 1046287775, -1115921615, 1018754897)
		 + W(7, -1114337484, 1051622635, -1097214606, -1115514650);
	sum2 =
		W(0, 1026296217, -1098267531, 1056065541, -1107249906) + W(1, 1046658552, 1054123387, -1080723543, 1049528827)
		+ W(2, -1092482457, 1031912087, 1068312252, -1094476247)
		+ W(3, 1048926974, -1103258874, -1095327126, -1114829012)
		+ W(4, -1093986590, 1064081451, -1101319294, -1110151549)
		+ W(5, 1051240634, -1081783631, 1054428583, -1109929036) + W(6, 1031417427, 1052301313, -1095108256, 1023898518)
		+ W(7, -1116201775, -1136084293, 1032992382, -1131461985);
	WS(1059931039, 1045326059);
	sum1 =
		W(0, -1105339195, 1027626820, 1035394960, 1020852317) + W(1, -1116497429, -1102542884, 1045819641, -1110241387)
		+ W(2, -1104905094, 1042432944, 1050447189, -1120454715) + W(3, 1048600749, -1087368655, 1050459387, 1028063406)
		+ W(4, 1017781140, -1090841955, 1058872902, -1135766366) + W(5, 1028510504, -1098837680, 1038310627, 1046575867)
		+ W(6, -1104151378, -1135818261, 1009721182, -1121800177)
		+ W(7, 1006123003, -1102238241, 1039487803, -1138241103);
	sum2 =
		W(0, -1108715925, 1033521028, -1130002309, 1043372642) + W(1, -1125695753, -1107049318, 1043711791, -1096562690)
		+ W(2, -1106861101, -1126359337, 1069432650, 1055907536) + W(3, 1037467647, 1024736242, 1069236178, -1077602923)
		+ W(4, 1049447879, -1096919459, -1089672176, -1079492159)
		+ W(5, -1108013135, 1030099711, -1104043463, 1048192702) + W(6, 1016159100, 1038861546, -1102967963, 1041544949)
		+ W(7, 1025122350, 1027296385, -1115278753, 1038199238);
	WS(1065273279, -1155200022);
	sum1 =
		W(0, 1032043190, -1110724474, 1048813356, -1107914275) + W(1, 1042748400, -1113644224, -1113329098, 1017813644)
		+ W(2, 1044363154, -1103694886, -1138873982, -1119126921)
		+ W(3, -1101712885, 1049530899, 1013956115, 1030506334) + W(4, 1020290996, 1032343156, -1088512539, 1047677002)
		+ W(5, 1042545917, -1119655327, -1118975351, 1035449518)
		+ W(6, 1023679047, -1113927803, -1112426340, 1040385292) + W(7, 969146311, 1014066252, -1102619473, 1037002750);
	sum2 =
		W(0, -1105379539, 1040024171, 1054804566, 1020126178) + W(1, -1114326988, 1033596237, -1100858724, 1058095820)
		+ W(2, -1128505094, 1027874005, -1108932212, -1095228668)
		+ W(3, -1127815582, -1090164335, 1015111122, -1114002666)
		+ W(4, -1144273240, 1026082941, 1057491035, -1109234902)
		+ W(5, 1011114412, -1098155637, -1123558275, -1117423595)
		+ W(6, 1010998384, 1010514392, 1041639386, -1148517800) + W(7, 1008109660, -1110656550, 1025837089, 1028462436);
	WS(1064822335, -1095840736);
	sum1 =
		W(0, 1049019197, 1056391992, -1082098174, 1047279757) + W(1, -1114924672, 1052717533, -1097259572, -1158101509)
		+ W(2, 1006539024, 1053226600, -1083318869, 1028150783) + W(3, 1027273471, 1063307800, -1085358981, 1048033194)
		+ W(4, 1024001604, 1051465786, -1093212548, 1040827508) + W(5, 1023329786, 1056189595, -1096912972, -1122795750)
		+ W(6, 1034076369, 1051405604, -1097995110, 1040247311)
		+ W(7, 1032078653, 1049885284, -1090164049, -1102713147);
	sum2 = W(0, 1044291516, 1057945825, 1075245425, -1075047571)
		 + W(1, -1105536143, 1059138923, 1063262829, -1084742426)
		 + W(2, -1123279074, 1064153610, 1058517731, -1087050661)
		 + W(3, -1102729189, -1117658388, 1055818216, -1094508761)
		 + W(4, 1019015608, -1082824416, -1095331241, -1107921801)
		 + W(5, -1098099014, -1088923796, -1082492094, 1066223948)
		 + W(6, 1041233257, -1114762777, -1084810008, 1065694420)
		 + W(7, -1116414073, -1093119165, -1076437009, 1070896480);
	WS(-1090760447, 1052695066);
	sum1 = W(0, 1032827391, -1086160295, 1058956361, -1122589400)
		 + W(1, 1004836815, -1100507696, 1050270371, 1011775197)
		 + W(2, 1040820154, -1085279840, 1061054293, -1126907788)
		 + W(3, 1033221771, -1085951050, 1060000376, -1109718672)
		 + W(4, -1142824410, -1090476887, 1053225609, 1031459881)
		 + W(5, 1019263487, -1096291378, 1052048107, 1014310644) + W(6, 1033909728, -1104244158, 1044967298, 1002236306)
		 + W(7, 1030288497, -1096098979, -1123372967, 1050105184);
	sum2 = W(0, -1115548553, -1119133376, 1034230379, -1106450540)
		 + W(1, 1010795990, 1054475337, 1049648601, -1130742967) + W(2, 1025233265, -1126101085, 1031862009, 1074765700)
		 + W(3, -1108773712, -1096206384, 1056453743, 1076253468)
		 + W(4, 1028577219, 1025243447, -1092511031, 1067142167)
		 + W(5, -1123367926, -1123699076, 1040231624, -1082850789)
		 + W(6, 1027045545, -1116348436, 1052333940, -1074864896)
		 + W(7, 1016487959, 1026289255, -1098871930, -1066441953);
	WS(-1098442559, 1026469881);
	sum1 = W(0, -1149983818, 1050517915, -1114000872, -1106643136)
		 + W(1, -1119522441, 1049663660, -1102209381, -1107005098)
		 + W(2, -1111872220, 1057681670, -1097110004, -1107624656)
		 + W(3, -1148708523, 1054270423, -1080449641, 1044397088)
		 + W(4, 1033974589, 1065584902, -1089390067, 1040137492) + W(5, 1034687077, 1060962908, -1088971425, 1011262833)
		 + W(6, -1121497336, 1043551013, -1096207069, -1152197144)
		 + W(7, 1040191316, 1037520938, -1098201593, -1111636393);
	sum2 = W(0, -1093666199, 1067471948, 1044138823, -1087858714)
		 + W(1, 1049995354, -1083836095, -1089657247, 1040673003)
		 + W(2, -1104373549, 1067519925, 1068116530, -1086283540)
		 + W(3, -1108191449, 1075025493, 1070698122, -1107890740)
		 + W(4, -1086862321, -1079149522, -1077256496, 1052510667)
		 + W(5, -1109961150, -1092122258, -1092830464, 1044801958)
		 + W(6, -1105617480, -1118106953, -1104600439, -1113062539)
		 + W(7, 1057348983, -1090446878, -1095892285, 1040940184);
	WS(-1089367999, -1080592817);
	sum1 =
		W(0, 1050901372, 1020565079, -1098563453, -1123752726) + W(1, -1142600967, 1046045566, -1094642094, 1032349343)
		+ W(2, 1043029392, 1051791856, -1092783656, 1017360893) + W(3, 1042662963, 1059303201, -1082254536, 1040706037)
		+ W(4, -1131715556, 1060541458, -1088235102, 1038984656) + W(5, 1028335344, 1057651322, -1083519131, 1042767141)
		+ W(6, 1009439676, 1050310918, -1088554180, 1039511244) + W(7, 1040529906, 1061742083, -1084895582, 1037250730);
	sum2 =
		W(0, -1086948904, 1072921984, -1102597600, -1081008410) + W(1, 1044777691, -1096214776, -1086612116, 1053678014)
		+ W(2, -1085906527, 1069427540, 1055370552, -1094318103) + W(3, -1107333159, 1069014322, 1068187895, 1040782350)
		+ W(4, -1094251850, 1068759557, 1049876941, -1097053445)
		+ W(5, -1101622483, -1095651744, -1098339283, 1052418274)
		+ W(6, 1054103540, -1080635176, -1098368915, -1116179967)
		+ W(7, -1095334551, -1071443034, -1119710681, 1057760894);
	WS(-1072329816, 1074376722);
	sum1 =
		W(0, -1119826815, -1097135645, 1051061560, 1001332238) + W(1, 1034466519, -1100415357, 1050212013, 1009264740)
		+ W(2, -1121811611, -1123247055, 1057003368, -1119531350)
		+ W(3, 1040071236, -1078161261, 1050094223, 1047608180) + W(4, 1034412551, -1086793716, 1060987117, -1139666027)
		+ W(5, -1125783811, -1092987820, 1053182609, 1053959834)
		+ W(6, 1025497578, -1117997032, 1030369595, -1130537576) + W(7, 989295697, -1097292445, 1040352158, 1003451511);
	sum2 =
		W(0, 1010850411, 1033963983, 1041326744, -1110591524) + W(1, -1119692159, 1024673399, -1126975570, 1039643589)
		+ W(2, -1110113403, -1107122545, 1049177676, -1098235771) + W(3, 1041465994, 1041917938, 1075051781, 1061676083)
		+ W(4, 1019542894, 1031918417, 1057547658, -1072022345) + W(5, 1041361680, 1016152214, -1100210466, -1080793678)
		+ W(6, -1128076954, -1119110501, -1101468559, 1038326573)
		+ W(7, 1035827461, -1108745692, -1111890885, -1115279667);
	WS(-1089734463, 1065567745);
	sum1 = W(0, -1115310942, -1089748010, 1053493076, 1041536229)
		 + W(1, 1048676446, 1033541431, 1047890913, -1111760907) + W(2, 1051913151, -1091844976, 1060749357, 1031051700)
		 + W(3, 1041943745, -1078026925, 1057682191, 1033727319)
		 + W(4, 1032260949, -1083863979, 1060855949, -1117552023)
		 + W(5, -1123414147, -1088695462, 1057895644, -1123512523)
		 + W(6, 1025799735, -1097284573, 1049355215, -1134918146)
		 + W(7, -1118314271, -1090712276, 1052101531, 1037093278);
	sum2 = W(0, -1087048499, 1067110585, 1062551012, -1088705293)
		 + W(1, -1089227831, -1073947481, -1107011493, 1063056164)
		 + W(2, -1081828818, -1100054441, 1044700801, -1091908804)
		 + W(3, -1106022394, 1057992187, 1053279159, 1049660447) + W(4, 1057638724, -1096117153, 1047077354, 1041467137)
		 + W(5, 1053589051, 1049824990, -1098858111, -1112699600) + W(6, 1030725267, 1008667589, 1055551992, 991046018)
		 + W(7, 1050363813, 1047082764, -1093863007, -1118599281);
	WS(-1079109040, -1085312521);
	sum1 =
		W(0, 1023769582, 1037365911, -1113299189, -1127522065) + W(1, -1140282322, -1117579705, 1042794748, -1098682508)
		+ W(2, -1105105824, 1052645482, -1086336671, 1041518392) + W(3, 1041551140, 1061549365, -1087637436, 1049784787)
		+ W(4, 1030694836, -1092653220, 1051894263, -1104535548)
		+ W(5, -1111084358, 1050958145, -1111723928, -1112540051) + W(6, 955351653, -1113919416, 1039072513, 997865134)
		+ W(7, -1133450021, 1047664699, -1111528112, -1121426302);
	sum2 = W(0, -1112127727, -1182735741, 1027967369, -1099828018)
		 + W(1, 1037755147, -1116775242, -1108084106, -1106208929)
		 + W(2, -1117076760, -1110833901, 1047419656, -1106621688)
		 + W(3, -1096944427, 1050960349, 1057406540, -1093670465) + W(4, 920706880, 1057824022, -1106635563, 1046907280)
		 + W(5, -1126463908, 1025802869, 1030718323, -1104727129)
		 + W(6, 1025583781, -1117624689, -1129307942, 1024731263)
		 + W(7, 1016301114, -1106817101, -1146210056, -1133403952);
	WS(1066445424, -1114782683);
	sum1 = W(0, -1105169880, -1110498524, 1042140161, 1033176686)
		 + W(1, 1037849343, -1092096849, 1045982494, 1027992139)
		 + W(2, -1111719878, -1089773556, 1059787797, -1104315937)
		 + W(3, 1053025475, -1093199580, 1058443885, 1034263873)
		 + W(4, -1106443352, -1085224723, 1058982105, -1099213011)
		 + W(5, -1118185334, 1017432168, 1051015495, 1015617473)
		 + W(6, -1115180998, -1097477655, 1049335790, -1134277975)
		 + W(7, -1104379365, -1120659192, 1047806371, -1124174113);
	sum2 =
		W(0, 1035156885, -1104443938, 1020765936, 1034215267) + W(1, 1010861092, -1111353322, -1131256669, -1119467871)
		+ W(2, 1053142713, -1092519845, 1043066295, 1043572605) + W(3, 1050643378, 1033492110, -1093594884, -1120345789)
		+ W(4, -1093995815, 1061622434, -1090891830, 1035132204)
		+ W(5, -1100307988, 1045835461, 1051701313, -1120193257)
		+ W(6, -1094190457, 1054276307, -1115303200, -1107758441)
		+ W(7, -1095534688, -1118030035, 1044764145, 1010759898);
	WS(1053797695, 1034928741);
	sum1 =
		W(0, -1113709609, 1027306577, -1089618673, 1039738506) + W(1, -1101985872, 1036410350, -1094568298, 1041675949)
		+ W(2, -1098832221, 1048222316, -1089721378, 1049870789) + W(3, -1106547453, 1049396519, 1057932790, 1032602030)
		+ W(4, 1032341932, -1093507345, 1051551069, 1041034929) + W(5, 1038712045, -1098128846, 1042310981, 1020376402)
		+ W(6, 1020651977, -1102358117, 1032076306, 1038606871) + W(7, 1037110646, -1095739626, 1049811664, 1036847389);
	sum2 =
		W(0, -1107569978, -1096371488, -1091206842, -1113379832)
		+ W(1, 1048834253, -1100415470, -1140716449, -1098639187)
		+ W(2, 1032955728, -1097656368, -1099982688, -1102236471)
		+ W(3, 1047116738, 1057366407, 1067804624, -1112454303) + W(4, -1095875849, 1049724515, -1107732848, 1037256860)
		+ W(5, 1024141754, 1047568587, -1101898886, 1039735469) + W(6, -1117854930, 1025784853, -1104360749, 1034482735)
		+ W(7, 1031286951, 1040928209, -1099991629, -1122662653);
	WS(-1100599294, -1113486107);
	sum1 = W(0, 1041832895, 1058015130, -1095482492, -1123207408)
		 + W(1, -1113994869, 1043005476, -1095369841, -1120610968)
		 + W(2, -1101582062, 1065539217, -1088297536, 1040056719)
		 + W(3, -1100675730, 1054749782, -1085935041, -1111595960)
		 + W(4, 1015862616, 1046936430, 1054414015, -1110844045) + W(5, 1033573462, 1043027144, -1096194081, 1041950395)
		 + W(6, -1123901241, -1122192647, -1118572185, 1007333963)
		 + W(7, -1147102474, 1047923809, -1106262926, -1097939280);
	sum2 = W(0, 1033496750, -1105017139, -1118941046, 1012703263)
		 + W(1, -1118187780, 1043450683, -1142467441, 1009095593)
		 + W(2, 1041080086, -1106458832, -1096734279, 1025973118)
		 + W(3, -1102935461, 1057933296, 1063076098, -1089439993)
		 + W(4, 1023898015, -1098239652, -1119844388, -1124882200)
		 + W(5, -1122438380, -1111698692, 1048742138, 1004297609)
		 + W(6, 1007185073, 1023645924, -1096898561, 1046154393) + W(7, 999989929, 1034431733, -1090457759, 1048791679);
	WS(1058454143, -1086058342);
	sum1 = W(0, -1115074879, 1051341170, -1123276713, 1040408770)
		 + W(1, -1099743710, 1054019099, -1112675511, 1042487060)
		 + W(2, -1103933280, 1057240637, -1095853513, 1044345774)
		 + W(3, -1113530407, -1085932301, 1048593300, 1034191179)
		 + W(4, -1124606630, -1090466976, 1059272419, -1105205160)
		 + W(5, -1115568198, -1097279225, 1052135974, -1111240730)
		 + W(6, -1123572016, -1108988935, 1039376368, -1135917288)
		 + W(7, -1118699368, -1095706385, 1041536544, 1043157563);
	sum2 = W(0, 1047642666, -1106684338, -1097565895, 1038757740)
		 + W(1, -1094360366, -1104496052, -1137000462, -1120606628)
		 + W(2, -1111839157, -1101578828, 1017360469, 1043520604)
		 + W(3, -1101124559, 1062389037, 1056361687, -1110716481)
		 + W(4, -1119401007, -1099504899, 1057357121, -1121032787)
		 + W(5, -1114275291, -1102577927, -1111580608, -1174578992)
		 + W(6, 1010413358, -1121638606, 1047557438, 1020758339)
		 + W(7, 1018914035, -1100286365, -1108198790, 1031842399);
	WS(-1116191222, -1087222261);
	sum1 = W(0, 1051378220, -1092140039, -1098282527, -1115126509)
		 + W(1, 1026061480, 1041212802, -1108686318, 1018050395) + W(2, 1051132746, 1028855632, -1114615088, 1028919646)
		 + W(3, -1131139769, 1054776996, -1096808426, 1031880915)
		 + W(4, 1029438530, 1052461054, -1090181940, 1047407636) + W(5, 1010253799, 1056191968, -1089672580, 1041055121)
		 + W(6, -1140691900, 1041996679, -1095415146, 1025713945)
		 + W(7, 1032111196, 1051463563, -1084069643, 1049760258);
	sum2 = W(0, -1120688670, 1075791226, 1072772368, 1033088733)
		 + W(1, 988781159, -1079951996, -1096143661, -1126178338)
		 + W(2, 1023531678, -1080919050, -1087274515, 1039982901)
		 + W(3, 1034244658, -1078043585, -1074830486, -1153355920)
		 + W(4, 1038669521, 1061514147, -1138433181, 1047086021)
		 + W(5, -1125227753, 1050383220, -1091737459, -1117938706)
		 + W(6, -1122152897, 1043495776, 1043710967, 1036258954)
		 + W(7, -1123518214, 1056154705, 1064633897, -1090859740);
	WS(-1086114623, -1084816591);
	sum1 =
		W(0, -1119067590, 1036163639, -1106221778, 1015833809) + W(1, 1041053515, -1112478813, -1114565991, 1041839788)
		+ W(2, -1123050946, 1045609440, -1102274148, 1038604869) + W(3, 1050414506, -1091176571, 1041957568, 1049671879)
		+ W(4, 1017204584, -1096458464, -1140250052, 1016035267) + W(5, 1033253648, -1092456237, 1042499428, 1004159150)
		+ W(6, -1109025761, 1039781304, 1024592194, 1019624502)
		+ W(7, -1142909644, 1019336538, -1110741472, 1038938427);
	sum2 =
		W(0, 1006657945, -1115603798, 1043167348, 1032033598) + W(1, -1145756082, -1129023472, 1029036192, -1122908214)
		+ W(2, -1102183527, 1024575987, -1134024937, 1013148193)
		+ W(3, 1043063832, -1070476153, -1079118960, -1117007948) + W(4, 1048257970, 1078068971, 1058188063, 1026806223)
		+ W(5, 1030027167, 1034687231, 1026633068, -1106350665) + W(6, -1129422896, 1014471457, -1138449465, 1037397710)
		+ W(7, -1120006792, 998969122, 1035752331, -1119066852);
	WS(1058895967, -1115291633);
	sum1 = W(0, -1125313920, -1118075736, -1101537045, -1102743433)
		 + W(1, -1110715998, 1028840739, -1106860038, -1113756805)
		 + W(2, -1110540830, 1050429809, -1109809347, -1112821659)
		 + W(3, -1093243535, 1056177832, 1062536899, -1094426092)
		 + W(4, -1098773368, 1050921353, 1050429425, -1112140166)
		 + W(5, -1114664694, 1021103494, 1042267175, -1105504016)
		 + W(6, -1108229374, 1039051533, -1104944731, -1123143221)
		 + W(7, -1128878150, 1048765371, 1019165331, -1113092552);
	sum2 = W(0, -1118991740, 1049660250, -1072802862, -1093107290)
		 + W(1, 1035161218, -1092533458, -1084844108, -1131472334)
		 + W(2, 1031409558, 1052404039, 1059153934, -1099814906) + W(3, 1025873763, 1059098325, 1066715964, 1050189246)
		 + W(4, -1130385854, 1035329255, 1054800035, 1033113369)
		 + W(5, -1109675818, 1033133876, -1121630224, 1032032260) + W(6, 1035221069, -1100849576, 1017402854, 999987753)
		 + W(7, -1106515599, 1041079456, 1051036492, -1109656332);
	WS(-1088275071, -1079832501);
	sum1 =
		W(0, -1121609972, -1140631216, 1031902612, -1114449795) + W(1, 1054795207, 1001216956, 1053928586, 1049117898)
		+ W(2, -1091175970, -1109051587, -1100362195, -1089874193)
		+ W(3, 1036185063, -1108520810, -1118566269, 1024185910) + W(4, 1036253081, -1112588624, 1050418310, 1033419200)
		+ W(5, -1095852779, -1111932116, -1106845532, -1098704820)
		+ W(6, 1056993046, 1018114011, 1057036918, 1052334541)
		+ W(7, -1099614386, -1114447781, -1106898567, -1103629998);
	sum2 = W(0, 1034198694, -1099753021, 1052074243, -1101897553) + W(1, 981839325, 1036479145, 1033443852, -1125560160)
		 + W(2, 1050051875, -1087878645, 1061175239, -1090657055)
		 + W(3, 1043520387, -1099082069, 1044393022, -1126528836)
		 + W(4, -1099547613, 1049181233, 1036533430, -1113239720)
		 + W(5, 1020237946, -1106552091, -1125692060, -1111189720)
		 + W(6, -1112528204, 1051666481, -1100952955, 1038783930)
		 + W(7, 1032634213, -1105193718, 1038429221, -1110455840);
	WS(1055684799, 1057467177);
	sum1 =
		W(0, -1115635180, -1084593518, 1057349085, 1044528285) + W(1, 1040983065, -1097583958, 1048845932, -1108137881)
		+ W(2, 1033664034, -1088354001, 1059080519, 1042415046) + W(3, 1047016048, -1083875169, 1057461395, -1130549589)
		+ W(4, 1040303666, -1089538899, 1055847004, 1025308788) + W(5, 1031194256, -1090088564, 1052697432, 1040121956)
		+ W(6, 1036112338, -1096939300, 1050363555, -1124884732)
		+ W(7, 1031542812, -1092334596, 1025617138, 1051059157);
	sum2 = W(0, 1039076253, 1084724252, 1055999642, -1111202323) + W(1, 1043377438, 1057352437, -1108204793, 982595482)
		 + W(2, -1111770710, -1070809771, -1115649819, 1026864091)
		 + W(3, -1129064764, -1070013447, -1084654208, 1008953953)
		 + W(4, 1041506513, 1024963427, 1027889169, 1041107952)
		 + W(5, -1117340191, -1115045950, 1023558847, -1112891517)
		 + W(6, -1113661124, 1037860995, -1108774739, -1161342746)
		 + W(7, 1006037802, -1120758055, 1034794526, 1036271073);
	WS(-1089965247, 1033154456);
	sum1 =
		W(0, -1118330000, 1037068672, 1043453383, -1112803845) + W(1, 1043361746, -1091726905, 1027410848, 1030795409)
		+ W(2, 1028536899, -1106295439, 1047994631, -1111747193)
		+ W(3, -1106541856, -1087991002, 1053447482, -1109712917)
		+ W(4, -1103233833, -1094017778, 1058853977, -1110327970)
		+ W(5, 1037178020, 1026207675, 1049286760, -1111739348) + W(6, -1122355891, -1102222128, 1044913013, 1037236782)
		+ W(7, -1148310999, -1106998176, 1056026770, -1104668925);
	sum2 = W(0, -1104081637, -1104712414, 1038273275, -1102746442)
		 + W(1, -1115350296, 1065017407, 1027805677, 1038124336)
		 + W(2, -1102551062, -1101193417, -1097697554, 1025981021)
		 + W(3, 1033477476, 1054909386, 1069044481, -1090398660) + W(4, 1048930937, -1096226206, 1051154993, 1049254524)
		 + W(5, -1092653578, -1094950793, -1097937335, -1111378843)
		 + W(6, 1049862570, 1042131871, -1115393002, -1100983150)
		 + W(7, -1095610208, -1100838677, -1090656582, 1038627466);
	WS(1053522367, -1088249107);
	sum1 = W(0, 1041083642, 1049354980, -1104528935, -1116245577)
		 + W(1, -1109062519, 1050121221, -1089361286, -1108913352)
		 + W(2, 1041255149, 1062047573, -1094323010, 1044478835)
		 + W(3, -1129341567, 1050256849, -1085946707, -1106612546)
		 + W(4, -1122816004, 1058306025, -1092704114, 1010650184)
		 + W(5, 1034422596, 1054029415, -1096738148, -1127765836)
		 + W(6, -1105678140, 1043380368, -1095183726, 1004046811)
		 + W(7, 1002201935, 1057986114, -1098664466, -1116617606);
	sum2 = W(0, -1115691041, 1047105417, 1066880006, -1078420733)
		 + W(1, -1122196578, 1040512713, 1072356775, -1074089832)
		 + W(2, -1133382325, -1115639944, 1070833917, -1079250237)
		 + W(3, -1119943136, -1093984910, -1106032356, 1053171659)
		 + W(4, 1035619338, -1128164365, -1084317659, 1063302165)
		 + W(5, 1026693101, -1112542694, -1103058628, 1050228647)
		 + W(6, -1121646682, 1040561229, -1106694088, -1111273903)
		 + W(7, 1035287249, -1122951759, -1109474775, 1041535222);
	WS(1054980735, -1118400611);
	sum1 =
		W(0, 1023857233, 1056052581, -1108899938, -1098911041) + W(1, -1136534172, 1054619866, -1084632317, 1014993130)
		+ W(2, -1109579886, 1062631892, -1087670245, 1019079234) + W(3, 1024279465, 1063340895, -1087714282, 984908360)
		+ W(4, 1031638446, 1054891904, -1089981519, 1040973935) + W(5, 1042081899, 1032051762, -1091518889, 1034243544)
		+ W(6, 1025101580, 1036582853, -1100292439, 1038263499) + W(7, 1037741818, 1040187076, -1096282711, 1035333164);
	sum2 = W(0, 1048663857, -1103126769, -1090522781, -1135969141)
		 + W(1, -1115607290, -1089284711, -1135630263, -1096474341)
		 + W(2, 1050959246, -1106476140, -1116194786, -1110761886)
		 + W(3, -1094885185, 1065597134, 1068281966, -1097679100)
		 + W(4, 1032263390, -1114774312, -1114594327, 1030603925)
		 + W(5, -1094433235, 1044112203, 1034641663, 1025157613)
		 + W(6, 1034671855, -1110680696, -1120338125, -1121778209)
		 + W(7, -1100445080, 1044150663, 1039802827, -1101519530);
	WS(-1099426814, 1028666567);
	sum1 =
		W(0, 1017347599, 1050515008, -1097546199, -1122852442) + W(1, -1114817850, 1054909169, -1091252816, 1034424401)
		+ W(2, -1102332157, 1058789976, -1088740593, 1040697053) + W(3, 1038414608, 1049870885, 1026332624, -1119196265)
		+ W(4, 1040863441, -1096181150, 1050979384, -1096850298)
		+ W(5, 1043586729, -1094822147, 1046083753, -1101867410)
		+ W(6, 1033560385, -1110297504, 1043042893, -1112505198)
		+ W(7, 1024225691, 1035801215, -1106319780, 1022200238);
	sum2 = W(0, 1032296335, -1113854030, -1123218166, 1034439881)
		 + W(1, -1113414658, 1056314261, 1057288090, -1106401889) + W(2, 1032045591, 1056282685, 1048444709, 1027355020)
		 + W(3, -1096252543, -1076472908, -1076465599, -1099548772)
		 + W(4, 1039836782, 1041975936, 1054239999, 1041344971) + W(5, -1130462124, 1060789196, 1064414385, -1137373456)
		 + W(6, 1032505935, -1113045826, -1101415652, 1031341874)
		 + W(7, 1017080436, -1114544525, 1017354944, -1131418272);
	WS(1048405758, 1021439377);
	sum1 = W(0, -1095783591, 1056714988, -1095028931, -1099026446)
		 + W(1, 1004365570, 1053912029, -1097931508, 1040281084)
		 + W(2, -1111296393, 1060368018, -1093355890, 1042667324)
		 + W(3, -1090472608, 1058906144, -1084869763, -1099317986)
		 + W(4, 1053249340, 1059710205, -1111710658, 1058667863)
		 + W(5, -1096289768, 1050004859, -1089344390, -1094050929)
		 + W(6, -1116930177, 1050104788, -1098648430, 1032145973)
		 + W(7, 1031327257, 1057263364, -1095692170, -1127343131);
	sum2 =
		W(0, -1137650289, -1102128439, 1065729447, -1085103011) + W(1, -1108324664, 1038586891, 1042582877, -1096095433)
		+ W(2, -1107068637, -1102631398, 1055966210, -1096657292)
		+ W(3, 1053004242, -1096144010, 1066736444, -1084794119)
		+ W(4, -1096186406, 1065778432, -1077760412, 1061684194)
		+ W(5, 1044011702, -1087564484, -1109340585, 1053274132) + W(6, 1031462490, 1041037240, -1088233524, 1060428365)
		+ W(7, 1016473473, -1095964556, -1079487884, 1070082531);
	WS(-1120621558, -1109747932);
	sum1 = W(0, 1041405257, 1056552380, -1086075216, 1021959803) + W(1, 1034046808, 1057052863, -1102283433, 1009707220)
		 + W(2, -1118447615, 1034826244, -1089852749, 1002695151)
		 + W(3, 1031113092, 1061462741, -1087896594, 1030648525)
		 + W(4, -1118172841, 1057041023, -1089300195, 1017359341)
		 + W(5, 1039149197, 1051800560, -1089266110, 1034838445) + W(6, 1025628006, 1051243933, -1098077639, 1033512688)
		 + W(7, 1023987646, 1054503948, -1098034299, -1099231069);
	sum2 =
		W(0, -1072120352, 1076686179, -1096491690, -1109988374) + W(1, -1071453180, 1075980741, 1055107632, -1125676035)
		+ W(2, -1069998225, 1075876198, -1100816518, 1033428305) + W(3, -1071241469, 1076219984, 1048961210, 1018908197)
		+ W(4, -1073669228, 1072219376, -1123192163, 1040773271)
		+ W(5, -1079882002, 1071235859, -1097056656, -1129279043)
		+ W(6, -1086087106, 1056170781, 1049622318, 1030403985)
		+ W(7, -1096258120, 1057784547, -1098632303, -1116156171);
	WS(1014286296, 1057122707);
	sum1 = W(0, -1100574608, 1045128364, 1045637171, -1113867461)
		 + W(1, -1134927261, -1112841149, 1041785732, 1021982785)
		 + W(2, -1096946922, 1023155519, 1051848326, -1106336253)
		 + W(3, -1115033128, -1094208427, 1066937726, -1099783438)
		 + W(4, -1104533485, -1099169249, 1058599142, -1105189673)
		 + W(5, -1121259095, -1097752701, 1049921902, -1131816685)
		 + W(6, -1131995140, -1111007544, -1118760834, -1114789302)
		 + W(7, -1118839498, -1093400894, 1043420320, -1116552190);
	sum2 = W(0, 1049653051, -1095117458, 1052542945, 1018695699)
		 + W(1, -1094509070, 1054995367, 1021265631, -1101605993) + W(2, 1050525055, 1042728281, 1046926465, 1044635344)
		 + W(3, -1103662151, 1058124872, 1063131010, -1104882803) + W(4, 1043452805, 1049859565, 1029162962, 1042944443)
		 + W(5, -1102028885, -1097129382, -1116537562, -1110047725)
		 + W(6, -1109754017, -1098619851, -1092457406, -1107003327)
		 + W(7, -1111709279, 1051259496, -1078653130, -1114867517);
	WS(-1089617919, -1078924764);
	sum1 =
		W(0, 1038586191, 1054651431, -1087542485, 1032587193) + W(1, -1112517470, 1043170193, -1101086846, -1121720345)
		+ W(2, 1021690773, 1058605998, -1088163691, 1034793549)
		+ W(3, -1148410045, 1062049174, -1087004528, -1139319682)
		+ W(4, -1123773533, 1056236357, -1089020247, 1040971627) + W(5, 1037589846, 1058401044, -1089711896, 1052009144)
		+ W(6, -1114886949, 1034515388, -1095006441, 1017461287)
		+ W(7, 1015916580, 1056139353, -1089662071, -1138694970);
	sum2 =
		W(0, 1041183203, -1104791361, -1113641717, 1040266660) + W(1, -1109901203, -1103309504, 1018299463, -1124518657)
		+ W(2, 1047303939, -1109225788, 993644855, 1039912380) + W(3, -1146453442, 1050748307, 1050538753, -1107008276)
		+ W(4, -1103370030, 1032462009, 1024125183, -1094411631) + W(5, 1035308463, 1055570013, 1058013570, -1087158984)
		+ W(6, -1107592095, -1104507532, 1044744090, -1091454514)
		+ W(7, -1129723226, 1050955773, -1110543421, -1122733934);
	WS(-1102088830, 1068463311);
	sum1 = W(0, 1007817678, 1054791531, -1088166471, 1034628887)
		 + W(1, -1114291787, 1051084317, -1097682087, -1130503387)
		 + W(2, -1106493040, 1059023407, -1087032011, 1042839161)
		 + W(3, -1121377148, 1060487316, -1087032009, 1025313797)
		 + W(4, -1120569345, 1053262386, -1090195409, 1040112167)
		 + W(5, 1037434082, 1049438849, -1104445288, -1112558866)
		 + W(6, -1121570543, 1043319351, -1110294871, -1130274577)
		 + W(7, 1048479966, 1037267389, -1112047510, -1107488086);
	sum2 =
		W(0, -1092702026, 1046572938, -1113806693, 1023924734) + W(1, -1078842502, -1092761370, 1010298098, -1134107544)
		+ W(2, -1073165872, 1048469719, -1106037347, -1114438827)
		+ W(3, -1075365553, 1050413401, 1041503306, 1017902665) + W(4, -1101579557, -1110447061, 1037192623, 1011674154)
		+ W(5, 1066341075, -1104166524, 1033398310, -1109271682) + W(6, 1071992070, -1123716833, 1031702363, 1028552632)
		+ W(7, 1076187261, 1056626852, -1110743783, -1123830383);
	WS(1050299903, -1120086405);
	sum1 = W(0, 1001761330, 1015037916, 1045981578, 1032160884) + W(1, 1051426245, 1042953374, -1094503950, -1131440192)
		 + W(2, -1097473350, -1103780307, 1055197076, -1100940622)
		 + W(3, 1050955122, -1082933123, -1099126616, 1056645367)
		 + W(4, -1098718343, 1055455844, -1118831961, -1095742542)
		 + W(5, -1119699408, -1145769035, 1049761702, 1031622998)
		 + W(6, 1038117517, -1132909758, -1105955296, 1041481643)
		 + W(7, -1107622229, 1039587926, 1047033256, -1103124921);
	sum2 =
		W(0, 1033493706, -1100025935, -1117747708, -1131691420) + W(1, 1004282338, 1036668146, -1097774825, 1042472719)
		+ W(2, 1032395114, 1043333590, -1106149887, -1122758767)
		+ W(3, 1035721710, 1058018229, -1110236537, -1106477628)
		+ W(4, -1138557465, 1035348312, -1105971349, 1046834331)
		+ W(5, -1094630455, 1040910383, 1017216296, -1101697584) + W(6, 1050323990, 1034465026, -1110352462, 1040100106)
		+ W(7, -1102984389, 1044530527, -1108832665, -1099114129);
	WS(1059761855, -1093333930);
	sum1 = W(0, -1114738580, 1026403632, -1105736123, -1114933837)
		 + W(1, -1114617627, 1045397583, -1109519752, 1044731740)
		 + W(2, -1102727321, 1028768699, -1092041414, -1111636685)
		 + W(3, 1053910378, 1067649611, -1090720496, 1058839312)
		 + W(4, -1094270689, -1104323849, -1112030179, -1095377736)
		 + W(5, -1107452471, 1042776267, -1103704317, 1034877772)
		 + W(6, -1130455238, 1036450873, -1131764742, 1031929286)
		 + W(7, -1108958070, 1044075076, -1106063752, -1113359528);
	sum2 = W(0, 1033753751, -1111931472, 1037689465, 1023732592)
		 + W(1, -1102724392, 1032416705, -1105246922, -1126463180)
		 + W(2, -1104466296, 1029992729, 1052475163, -1118149766)
		 + W(3, -1083668043, 1069568682, -1090236396, -1106129378)
		 + W(4, 1048180527, -1114422988, -1122305941, 1038071226)
		 + W(5, -1130490520, -1133345747, -1123788932, -1124715334)
		 + W(6, -1103926430, 1038116955, -1127253836, -1117123194)
		 + W(7, 1029490699, -1129834714, -1122171294, 1029091180);
	WS(1058247519, 1058950523);
	sum1 = W(0, -1149972914, -1088063023, 1055543086, 1037155715)
		 + W(1, 1038957612, -1093535488, 1052729022, 1026693813) + W(2, 1039970419, -1086741707, 1058924163, 1030719286)
		 + W(3, 1008158544, -1077128706, 1057693884, 1032127358) + W(4, 1041515382, -1087332234, 1060656868, 1000958261)
		 + W(5, 1036144305, 1032313207, 1056531259, -1112386573)
		 + W(6, 1048236362, -1113848378, 1049522521, -1144612480)
		 + W(7, -1101573740, -1089306475, 1052006205, 1039554949);
	sum2 =
		W(0, 1037957789, 1050553491, -1089722328, 1050994656) + W(1, -1128637884, 1004874497, 1058234547, -1095571828)
		+ W(2, -1110859440, -1106433025, -1098594890, 1041665953)
		+ W(3, 1052981065, 1058989771, 1052545864, -1129708900) + W(4, 1040710261, 1058251934, -1106724054, -1111634443)
		+ W(5, -1090346288, -1076253449, 1032950959, 1015279680)
		+ W(6, -1107045102, -1079150504, 1055215751, 1053553553)
		+ W(7, -1092015484, 1073146781, 993278274, -1088813426);
	WS(-1079689312, 1054955487);
	sum1 =
		W(0, -1112827293, -1094091800, 1053343716, 1046408387) + W(1, 1038847520, -1099397203, 1057879171, -1099233409)
		+ W(2, -1106748654, -1102151838, 1023820222, -1154890390)
		+ W(3, 1038138418, -1086663035, 1057249493, 1012875058) + W(4, 1035397268, -1087965823, 1057985827, -1109124523)
		+ W(5, 1020226162, -1095805620, 1053821069, -1126965269) + W(6, 1030022886, -1098762192, 1051466543, 1036334304)
		+ W(7, -1108673687, -1096846716, 1049463311, 1027304762);
	sum2 = W(0, 1029906557, -1118908362, -1075330978, 1069116571)
		 + W(1, -1110945783, -1110004947, -1081100797, 1067844910)
		 + W(2, 1046588193, -1089040350, -1089891752, 1066162938)
		 + W(3, -1121400966, -1106443118, -1103643831, 1048795077)
		 + W(4, -1106274145, 1054044230, -1095873523, 1049522444)
		 + W(5, 1040948990, -1115139995, -1120742988, 1042365723)
		 + W(6, -1114149785, -1112260837, -1107023588, 1011222152)
		 + W(7, 1030737726, 1025987216, 1017833328, 1031208089);
	WS(1045323518, -1099573370);
	sum1 =
		W(0, 1043494028, 1054678847, -1087400961, 1041221965) + W(1, -1110296205, 1050638833, -1098183847, 1038272854)
		+ W(2, -1129034139, 1058657792, -1085969705, 1035507984) + W(3, 1040205415, 1062545342, -1082320511, 1038672050)
		+ W(4, 1019451328, 1053087270, -1092792902, 1018934299) + W(5, 1037480760, 1054717567, -1090230188, 1028598065)
		+ W(6, -1144942569, 1044080591, -1094581114, 1032398451)
		+ W(7, 1019441962, 1056118375, -1090342307, -1135273190);
	sum2 = W(0, -1115726367, -1100272494, 1026681555, -1095030133)
		 + W(1, 1028786141, -1113941052, -1107020345, 1043410282)
		 + W(2, 1044450180, -1104186275, 1044693748, -1120312046)
		 + W(3, -1097529180, 1042859033, 1067055887, -1093369648)
		 + W(4, 1047479398, -1097402721, 1064288021, -1083945294)
		 + W(5, -1105649332, 1051025911, 1073649944, -1073003592)
		 + W(6, -1127420023, 1025042835, 1067916626, -1079526678)
		 + W(7, 1035799966, -1139194229, 1054550763, -1086831079);
	WS(-1086660959, -1095040438);
	sum1 = W(0, -1137772688, -1101831491, 1047762270, 1026497863)
		 + W(1, -1103872010, -1108733164, 1048734598, -1112526127)
		 + W(2, 1033664792, -1099393082, 1053294440, 1036444877)
		 + W(3, -1114303830, -1091611870, 1032897582, -1105948909)
		 + W(4, 1043631948, -1111668992, 1054700448, 1045765800)
		 + W(5, -1110960013, -1092153253, 1051790266, -1102627253)
		 + W(6, -1112201312, -1104258339, 1038982672, 1030853145)
		 + W(7, 1004207675, -1111896549, 1042342295, 1024477884);
	sum2 =
		W(0, 1047134358, -1100773581, 1038575217, -1121016162) + W(1, 1032860761, 1019143260, -1097448906, 1027754828)
		+ W(2, 1058187056, -1086969962, 1050436365, -1118814167)
		+ W(3, -1089859690, 1060822499, -1092585260, 1047705700) + W(4, -1073724300, 1074524802, -1097001013, 992280012)
		+ W(5, -1113017653, -1127402252, 1052022456, -1115523910)
		+ W(6, -1123513506, 986153015, -1101541136, 1026625966) + W(7, 1005834992, 1026902445, 1040058169, -1115254226);
	WS(1065625968, 1033455989);
	sum1 = W(0, 1037701789, -1151616802, -1102944307, 1035789757)
		 + W(1, -1137040283, -1099349487, 1053320242, -1106274637)
		 + W(2, 1000406064, 1047711372, -1098462560, 1048627484)
		 + W(3, -1094784938, -1115632781, 1053161728, -1098374228)
		 + W(4, 1050863995, -1088133648, 1049613697, -1120581030)
		 + W(5, -1103592251, 1049293870, -1128175786, -1114622845)
		 + W(6, 1032127959, -1118922740, 1017489163, 1038993832)
		 + W(7, 1038622703, -1120882929, -1119810116, -1165953346);
	sum2 = W(0, 1035866397, -1099238508, 1052038184, -1107491561)
		 + W(1, -1103116216, 1047962584, -1105248240, 1027069673)
		 + W(2, 1059558286, -1082734190, 1057669233, -1098068789)
		 + W(3, 1058384307, -1088122523, -1091086098, 1053762892)
		 + W(4, -1096953271, 1056069525, -1083280561, 1064349048)
		 + W(5, 1042132369, -1106560803, 1032403631, -1107462772)
		 + W(6, -1111426470, 1038442279, -1104452063, 1040922744)
		 + W(7, -1128202268, 1028886015, -1150402298, 1012204557);
	WS(1066439152, -1108830929);
	sum1 = W(0, -1102916748, 1055608939, -1103898045, 1013732302)
		 + W(1, -1108788820, 1051866141, -1097938907, 1035488645)
		 + W(2, -1097607254, 1058768962, -1093577324, 1043113957)
		 + W(3, -1099017414, 1030462560, -1125603603, 1027216291)
		 + W(4, -1168846782, -1113005110, 1040477611, -1143171172)
		 + W(5, -1109193920, -1109987210, 1050862423, -1118580993)
		 + W(6, -1128476473, -1109670205, 1039038758, -1107320747)
		 + W(7, -1106724277, -1105116142, 1053895221, -1107171108);
	sum2 =
		W(0, 1050905005, 1051409035, -1123874142, -1099079861) + W(1, 1051922636, -1107944278, -1131839644, 1035659117)
		+ W(2, 1052154527, 1040207956, -1100926997, -1109355656) + W(3, 1005525738, 1060123319, 1046139234, 1029590720)
		+ W(4, 1024591478, 1032045878, -1113252250, 1032543174) + W(5, -1094205878, -1096175996, 1039675350, 1044310065)
		+ W(6, -1094330307, -1086096303, -1128729660, -1129395200)
		+ W(7, -1105421569, -1081193369, 1062516858, 1042520685);
	WS(-1094347903, 1040885342);
	sum1 =
		W(0, 1027015666, -1119901274, -1109404651, -1145327523) + W(1, -1097151811, 1047615033, 1051228067, -1096635113)
		+ W(2, 1050782150, -1115052947, -1096976391, 1048638245)
		+ W(3, -1106442815, 1051587896, -1096200649, -1105180361)
		+ W(4, 1051184308, -1105704339, -1126487153, 1051518582)
		+ W(5, -1091810963, 1046407197, 1040585575, -1092825760) + W(6, 1034433919, 1009768300, -1132445914, 1038762547)
		+ W(7, 1042242605, -1122889273, -1108464678, 1040013733);
	sum2 = W(0, -1121205117, -1124056141, -1106581817, 1026565438)
		 + W(1, 1031829824, -1109805410, 1007706034, 1029970286) + W(2, -1105324964, 1045427632, 1046732003, 1047283254)
		 + W(3, -1090390675, 1059020251, 1057752640, -1089850616)
		 + W(4, -1110420773, -1107061510, -1101115525, 1031976810)
		 + W(5, 1018005966, -1118368537, -1103994134, 1036394258)
		 + W(6, -1113281242, -1115675784, 1036673543, -1112565336)
		 + W(7, 1032068637, -1113920834, 1042522746, -1145818031);
	WS(1066366016, -1121083386);
	sum1 =
		W(0, -1127500850, 1026624689, 1013565235, -1127181143) + W(1, -1122305754, -1114017662, 1052467062, 1035730049)
		+ W(2, 1025706181, -1088657475, -1121688536, 1045310349)
		+ W(3, -1104671484, -1098749979, 1066224034, 1026340635)
		+ W(4, 1043832110, -1085705014, -1112016562, -1121566277)
		+ W(5, -1111488580, 1037547214, 1041900405, -1127673329) + W(6, -1123271764, -1112264441, 1043675185, 998683632)
		+ W(7, 1015742169, -1105147876, 1022047173, -1132045794);
	sum2 = W(0, -1102951634, 1043023116, -1104735391, 1035018995)
		 + W(1, 1044058166, -1093545812, 1058451408, -1112978123)
		 + W(2, 1037657608, -1093647750, -1104370519, 1043811519)
		 + W(3, -1091261805, 1070997171, -1105620254, 1052846459)
		 + W(4, 1057746121, -1082044166, -1091103100, -1097428497)
		 + W(5, -1106029228, 1051593249, -1096225251, -1127092852)
		 + W(6, 1006392595, -1100798567, 1052307063, -1107453736)
		 + W(7, -1119100020, 1013819138, -1121077487, 1041369362);
	WS(1059191103, 1030618557);
	sum1 =
		W(0, 1034200101, 1032351793, -1100440271, -1148363237) + W(1, 1053678608, 1049973094, -1098031908, 1026486548)
		+ W(2, -1114145283, 1058794603, -1087452589, -1194991971)
		+ W(3, 1047695489, 1053292689, -1078695803, 1043453347) + W(4, -1114663316, 1055818163, -1125225546, 1033675947)
		+ W(5, -1137634576, 1053263444, -1094543429, 966472909)
		+ W(6, -1125278731, 1041016873, -1116533557, -1115520783)
		+ W(7, -1138534517, 1043320696, -1104858229, -1119664758);
	sum2 =
		W(0, 1021496216, -1095812325, -1116672596, 1031503244) + W(1, -1072453458, -1094113031, -1112299630, 1023122856)
		+ W(2, -1079530578, 1068683999, -1135088113, 1036078566) + W(3, 1063841069, 1074699170, -1126165044, 1036242384)
		+ W(4, -1095958945, 1043477830, -1107446259, -1100441243)
		+ W(5, 1042172731, 1031880682, -1119142347, 1009915385) + W(6, 1015153576, -1121439437, 1037216194, -1114450875)
		+ W(7, -1132334880, -1115200049, 1034903618, 1017712520);
	WS(-1096433855, 1052342409);
	sum1 = W(0, -1117693364, 1042163431, 1006023611, -1113444755)
		 + W(1, 1041070378, -1095385709, 1034697390, 1049542464)
		 + W(2, -1105417036, 1060080198, -1109633387, -1112382959)
		 + W(3, 1052133240, -1090036408, -1085473397, 1048891757)
		 + W(4, 1042648272, -1090327769, 1057448056, -1111238376)
		 + W(5, -1123398616, 1043184694, -1105658040, -1106505885)
		 + W(6, 1044512510, -1111854479, -1104977148, 1049508979)
		 + W(7, -1105041790, 1043408999, 1041051171, -1110665802);
	sum2 =
		W(0, 1039259027, 1043188759, -1165551167, -1113326246) + W(1, -1119373866, -1082984200, -1105050294, 1045229872)
		+ W(2, -1086821333, -1077733706, -1103802686, -1109909290)
		+ W(3, 1052826002, 1067327309, 1068967257, 1052700624) + W(4, -1117342490, -1149070344, 1054626023, -1098764713)
		+ W(5, 1036052293, 1052358305, -1101813629, -1099183932)
		+ W(6, 1037381955, -1102382047, -1103461210, 1052205497)
		+ W(7, -1101694007, 1050777563, -1106555317, -1096821402);
	WS(1046655614, 1069864308);
	sum1 = W(0, 1035633391, -1106200785, -1105260712, 1050507575) + W(1, 1040943483, 1031319761, 1026979270, 1034433460)
		 + W(2, 1045417382, -1120751363, -1106053451, 1045765948)
		 + W(3, 1043913370, -1093886310, -1121044950, 1041581532)
		 + W(4, 1050212129, -1098821847, 1042106970, 1029812249) + W(5, 1047844019, -1088130094, 1049054225, 1017929306)
		 + W(6, 1039058852, -1092291401, 1041620790, 1028938706)
		 + W(7, 1043891960, -1082722808, 1042598038, 1034869942);
	sum2 = W(0, -1098805029, -1082465618, 1017798412, 1045866690)
		 + W(1, -1101136548, -1084472150, -1108050411, 1039888035)
		 + W(2, -1094351375, -1085764460, 1031330790, 1027046574)
		 + W(3, -1097728468, -1140347496, 1053843229, 1038111290)
		 + W(4, 1040878916, -1100091144, 1043199898, -1100094208) + W(5, 1049713965, 1049328541, 986797508, -1104239104)
		 + W(6, 1037060075, 1062808960, -1119994130, -1098800085)
		 + W(7, 1058810464, 1071144827, -1097822096, 1017716576);
	WS(-1077527440, 1065234224);
	sum1 =
		W(0, 1031059492, -1088676934, 1055802445, -1159469258) + W(1, 1014606833, -1098001853, 1051162632, 1001612013)
		+ W(2, 1041495444, -1087241405, 1059501583, -1109463457)
		+ W(3, 1031584061, -1083911392, 1061276187, -1105280809)
		+ W(4, -1143158030, -1095088526, 1050088278, 1038556792) + W(5, -1140389945, -1096536807, 1049527800, 986827883)
		+ W(6, 1035424519, -1104484775, 1042937212, 1030875577) + W(7, 1013235228, -1100223239, 1037087943, 1047418837);
	sum2 =
		W(0, 1026928347, 1019217071, 1027288437, -1112677997) + W(1, 1006719462, -1098369589, -1099640354, -1146387796)
		+ W(2, -1103317527, 1041304779, 1050941648, -1072403340)
		+ W(3, 1043604137, -1134457784, -1112266437, -1071428003)
		+ W(4, -1106627965, 1048134757, 1027462477, -1082446250) + W(5, 1034526167, -1118427047, 1040843010, 1059493547)
		+ W(6, -1117999031, 1029994729, -1104465031, 1072461191)
		+ W(7, -1134258967, -1113504087, 1054764710, 1077848621);
	WS(1034219259, -1130863201);
	sum1 = W(0, -1122470601, 1036468120, 1033355302, -1104067775)
		 + W(1, -1125729883, 1031973022, -1125640547, -1112351746)
		 + W(2, -1119868741, 1045421587, -1122038588, -1106594245)
		 + W(3, -1092963050, 1062931954, 1044707408, -1094830635)
		 + W(4, -1102984950, 1062738826, -1104269382, -1127079049)
		 + W(5, 1017182198, 1050208654, -1106320445, -1109997276)
		 + W(6, -1107264969, 990945063, -1110744610, -1112571199)
		 + W(7, -1116589116, 1023027040, -1098846428, -1117279521);
	sum2 = W(0, -1120041672, 1041156572, -1103868400, 1036471018) + W(1, 999703935, 1029144962, 1036670980, -1107170022)
		 + W(2, -1109032994, 1037796455, 1043292537, -1115113192) + W(3, 1041627711, 1046556501, 1059414852, 1029249656)
		 + W(4, -1111815622, 1060385029, 1048639871, -1126242312)
		 + W(5, 1029813110, 1040466231, -1105513272, 1043143286)
		 + W(6, -1110751572, -1103822492, -1100107078, -1101226736)
		 + W(7, -1114401610, -1076222058, 1043280503, 1034327293);
	WS(-1097041087, -1081891922);
	sum1 = W(0, 1045201037, -1097075376, -1126257330, -1115394372)
		 + W(1, 1042240134, -1091271089, 1049467348, -1097795722)
		 + W(2, 1049780286, -1094847921, 1057610047, -1097045891)
		 + W(3, 1039927583, 1059654550, -1141428591, -1103383438)
		 + W(4, -1122695635, 1056430510, -1089703504, 1036098616)
		 + W(5, -1110484942, 1057233913, -1087958744, 1033721138)
		 + W(6, -1117417409, 1041827328, -1096746586, 1035539581)
		 + W(7, 1039840796, 1050554535, -1096159486, -1131932502);
	sum2 =
		W(0, 1012982255, 1052214657, -1136022111, 1032353073) + W(1, -1101224821, 1042508745, -1093748656, 1020863779)
		+ W(2, -1109376974, 1042044290, 1045672838, -1113516472) + W(3, -1116588919, 1071547407, 1065241977, 1040242686)
		+ W(4, -1096183361, -1089469015, 1049249478, -1120964187)
		+ W(5, -1092858264, -1090264503, 1047260540, -1103746594)
		+ W(6, -1090462581, 1039700797, 1046964814, -1100885683)
		+ W(7, -1119652925, -1083767147, -1107087862, 1028764718);
	WS(-1088621983, 1079497913);
	sum1 = W(0, 1027161409, 1052712773, -1102058289, -1100368317)
		 + W(1, -1102075462, 1051824794, -1098602113, 1021667349)
		 + W(2, -1120075900, 1057942154, -1096292664, -1106147487)
		 + W(3, -1109063205, 1060662493, -1082645434, 1039175801)
		 + W(4, -1104005172, 1062931830, -1090788424, -1129475640)
		 + W(5, -1136555883, 1057800198, -1090185155, 1036809656)
		 + W(6, -1112015962, 1047971474, -1098101583, 1009161622)
		 + W(7, 1033292370, 1059753504, -1088742454, -1143403778);
	sum2 = W(0, -1150684740, -1095235693, 1044985054, 1035589955)
		 + W(1, -1114056841, -1115238312, -1127339724, -1108218072)
		 + W(2, -1164208415, -1080604054, -1106549807, 1022130402)
		 + W(3, 1034698244, -1071093346, -1080554397, -1106288272)
		 + W(4, -1134574697, -1083926997, -1104923511, 1024268734)
		 + W(5, 1043895716, 1068501149, 1052487431, 1036117000) + W(6, -1101980686, 1079699126, 1054997905, -1130803558)
		 + W(7, 1050191679, 1056576712, 1029700329, 1031345667);
	WS(-1087955103, 1023517655);
	sum1 =
		W(0, -1106663590, -1090071677, 1062902614, 1013889298) + W(1, 1037773274, -1103425461, 1055773525, -1100022495)
		+ W(2, -1116651838, -1089596734, 1059014377, -1101161913)
		+ W(3, 1022742037, -1082614473, 1060267482, 1030094516) + W(4, 1040438284, -1088542372, 1057943128, -1120043085)
		+ W(5, -1117813952, -1092404165, 1054561254, -1116951793)
		+ W(6, 1032561623, -1100716355, 1051603940, 1035114019)
		+ W(7, -1102318801, -1098396937, 1049819671, 1026546470);
	sum2 = W(0, -1107653444, -1094858135, 1084595456, -1065438414)
		 + W(1, 1032757863, 1061839668, 1074196920, -1069856939)
		 + W(2, -1150202006, 1049735190, 1067688119, -1073375528)
		 + W(3, 1037010009, -1123088190, 1070729644, -1082206819)
		 + W(4, 1026258576, -1089824138, 1050587980, -1086758222)
		 + W(5, 1041748319, -1098358767, 1057889952, -1097734258)
		 + W(6, -1131622502, 1049699018, -1127981435, -1106404220)
		 + W(7, -1112646994, -1103776938, 1048602984, -1098587943);
	WS(-1089607615, 1063931357);
	sum1 = W(0, -1156148665, -1089422721, 1059281720, 1041177357)
		 + W(1, 1033042784, -1099513696, 1053472432, -1107985659)
		 + W(2, 1027235975, -1086976804, 1060428066, -1122980350)
		 + W(3, -1117005684, -1083936660, 1061258678, -1103260375)
		 + W(4, 1045226606, -1089259880, 1055780369, -1111710595)
		 + W(5, -1112863441, -1092850238, 1057981025, -1109580750)
		 + W(6, 1040283212, -1096473171, 1051704489, -1125267169)
		 + W(7, -1102751384, -1096124078, 1054893029, 1035448166);
	sum2 = W(0, 1024298597, 1074606150, 1080820206, 1030125639) + W(1, 1037699935, 1048614297, 1047271097, -1121834510)
		 + W(2, 1030404477, -1085515118, -1079656120, -1166463196)
		 + W(3, -1094400051, -1071672142, -1066721483, -1101580999)
		 + W(4, 1052543759, -1091215560, -1078287609, 1028051862)
		 + W(5, 1024136176, -1095087497, -1096732136, 1009399200)
		 + W(6, -1159281410, 1050441058, 1057126689, -1117118368)
		 + W(7, -1102232478, 1071366890, 1074685383, -1113696211);
	WS(-1083901183, 1060981851);
	sum1 =
		W(0, -1106299749, 1048978486, 1016862419, -1121286832) + W(1, 1039492049, -1107896957, -1115539879, 1049662006)
		+ W(2, -1113140273, -1119192025, -1098481927, -1106196840)
		+ W(3, 1055856482, -1090009641, 1058119768, -1149152444)
		+ W(4, -1103186821, -1088174932, 1052019064, -1101797848)
		+ W(5, -1108369378, 1034759564, 1048477348, -1146708651) + W(6, -1115937041, 1008970428, 1034559233, 1024756171)
		+ W(7, -1127954738, 1027686380, 1044214632, -1111878699);
	sum2 = W(0, 1030335348, -1130369060, -1106797797, 1006653296)
		 + W(1, -1110488253, 1056034410, 1040331307, -1094310491)
		 + W(2, -1096373435, -1097486091, 1063611375, -1113782011)
		 + W(3, 1042224202, -1094958491, -1106971469, 1042512890)
		 + W(4, 1038378538, 1057631708, -1093142933, -1140559356)
		 + W(5, -1117770266, -1114209587, 1037075531, -1114686161)
		 + W(6, 1036930446, -1105273765, -1115233817, -1115373149)
		 + W(7, -1168276161, -1115537765, 1025218793, 1026640233);
	WS(1063762143, -1098158381);
	sum1 = W(0, 1027555010, -1106988831, 1031921883, 1033567284)
		 + W(1, -1113176415, 1049655577, 1032851437, -1099137927)
		 + W(2, 1044835884, -1089572014, -1106152127, 1052671923)
		 + W(3, -1094480963, 1041189880, 1057311541, -1101762329)
		 + W(4, 1042205032, 1035602487, -1100163979, -1106014811)
		 + W(5, 1038186408, -1095655321, 1046700975, 1044902280) + W(6, -1112247611, 995617211, 1050763922, -1094051821)
		 + W(7, 1041241393, -1102946366, -1119959180, 1044480349);
	sum2 =
		W(0, 1010916279, 1040615985, -1103581164, -1126424725) + W(1, -1108274646, 1037755544, 1053142923, -1119616718)
		+ W(2, -1108043460, -1107213139, -1091384808, 1062997316)
		+ W(3, 1049469526, -1085933104, -1093682556, 1050086980)
		+ W(4, 1061284555, -1098201753, -1095835641, 1044548392)
		+ W(5, -1097521196, 1027381238, 1044225612, -1099920539) + W(6, 1047936551, 1007266289, -1101597200, 1043928239)
		+ W(7, -1106103943, 1039340208, 1011948943, -1120667237);
	WS(1060336095, -1119657045);
	sum1 =
		W(0, 1023788715, 1048279897, -1106238784, -1110161279) + W(1, -1117126579, 1044311660, -1096869700, -1136931731)
		+ W(2, -1108875843, 1062204714, 1019770348, -1115905233) + W(3, 1022815367, 1060724749, -1081389759, 1034904806)
		+ W(4, -1100562722, 1063043033, -1084472996, -1124661292)
		+ W(5, 1043213137, 1050929706, -1097593661, 1017832853)
		+ W(6, -1111482971, 1037241746, -1106654286, -1109716592)
		+ W(7, -1142747249, 1051192212, -1102133781, -1109353889);
	sum2 =
		W(0, 1036664563, 1009247708, 1013790140, 1035577258) + W(1, -1103288529, -1126560341, -1102369678, 1008412166)
		+ W(2, -1102134383, -1067246446, 1047852878, 1016094574) + W(3, 1057556566, 1067728497, -1093152080, 1045655865)
		+ W(4, -1099512639, 1078180911, -1110504691, -1123477495)
		+ W(5, 1031668335, -1085231458, 1042704555, 1023608957)
		+ W(6, -1103860103, 1047956293, -1132621098, -1112760821)
		+ W(7, 1028018661, -1114058193, 1030531898, -1120624893);
	WS(1035518203, 1045613832);
	sum1 =
		W(0, 1044215468, 1057279232, -1097478568, 1042423606) + W(1, -1096085823, 1043513429, -1096451901, -1098498663)
		+ W(2, -1102751483, 1057361220, -1091716958, 1012832112) + W(3, 1007706274, 1061539183, -1085528932, 1054368634)
		+ W(4, -1098118842, 1057962612, -1093017477, -1103819295)
		+ W(5, 1051305356, 1058710773, -1091718961, 1057808613)
		+ W(6, -1096250919, 1037420261, -1100741095, -1100568821)
		+ W(7, -1106455273, 1053125757, -1097230063, -1111733504);
	sum2 = W(0, -1105709018, 1058997495, -1086433444, 1022365788)
		 + W(1, 1050542737, -1084246791, 1065459234, -1101303092)
		 + W(2, -1106108137, -1103685622, 1055198365, 1040995532)
		 + W(3, 1027983028, -1106510960, -1102412567, 1044759128)
		 + W(4, 1053295819, -1089515541, 1057925132, -1104466949)
		 + W(5, -1091042532, 1066680974, -1080963495, 1043286350)
		 + W(6, 1049054259, -1088412186, 1056230430, -1096360229)
		 + W(7, -1108416827, 1037143386, 1049505110, -1106131860);
	WS(-1103921662, 1072713673);
	sum1 = W(0, 1042712209, -1111681022, 1029885560, -1123292759)
		 + W(1, -1130675027, -1104528338, 1032835743, -1124533373)
		 + W(2, 1041149044, -1103688784, 1053127408, -1101763282)
		 + W(3, -1108819823, 1055222237, -1089836355, -1143773237)
		 + W(4, -1099465033, 1063848575, -1089832742, 1044926036)
		 + W(5, -1102885798, 1053207587, -1090841456, 1032528402)
		 + W(6, -1108891552, 1051374172, -1098121506, 1040294582)
		 + W(7, -1122152216, 1044600823, -1101098252, 1018003689);
	sum2 = W(0, -1116466906, 1017580326, -1100144980, 1018640494) + W(1, 1032691193, 1031996320, 1045143645, 1067424527)
		 + W(2, -1110682367, 1040673767, 1055366708, 1071822180)
		 + W(3, -1134651946, -1121084452, -1112456349, 1057195246)
		 + W(4, 1019799157, 1012141662, 1037079065, -1078565795)
		 + W(5, 1020309206, -1123645954, 1036705771, -1073530916)
		 + W(6, 1028255175, -1125118807, -1112096331, -1087156462)
		 + W(7, -1118897648, 1005021204, 1021253254, 1033125682);
	WS(1054959295, 1011151216);
	sum1 = W(0, -1124554365, 1043778462, -1140499785, -1103855992)
		 + W(1, 1028540695, -1104732576, -1111020475, -1113072532)
		 + W(2, -1107828893, 1063706911, -1098481604, -1121738665)
		 + W(3, -1135601758, 1052343180, -1081762405, 1048654720)
		 + W(4, -1135515507, 1050410381, 1053053447, -1096321673)
		 + W(5, 1032466990, -1128754020, -1112972157, 1012954617)
		 + W(6, -1110097877, 1034222620, 1023071124, -1110289546)
		 + W(7, 950109203, 1043960229, -1120112616, -1114439871);
	sum2 = W(0, -1104841432, 1047456971, 1024424907, 991739097) + W(1, 1047690020, -1094867354, 1033457856, -1129013032)
		 + W(2, -1084375561, 1068880529, 1046341732, -1103560341)
		 + W(3, -1086552004, 1065412328, -1087761187, 1059009805)
		 + W(4, 1046416693, -1080289298, 1062384539, -1098849357)
		 + W(5, 1025710892, -1110380578, -1103331799, 1045332030)
		 + W(6, -1130856953, -1105039836, 1024509174, -1104241974)
		 + W(7, -1113936449, 1016290713, -1126452938, 1019994493);
	WS(1061669311, 1066543312);
	sum1 =
		W(0, -1120030840, -1097490380, 1038501126, 1026361650) + W(1, -1111872182, 1051889621, -1110528784, -1112085217)
		+ W(2, 1046388965, -1085299564, 1050043436, 1019064063) + W(3, -1109640224, 1043197314, 1054292822, -1116217609)
		+ W(4, 1051640445, -1099578605, -1095700775, 1045441021)
		+ W(5, -1104742312, -1114905437, 1056051928, -1097066005)
		+ W(6, 1040612129, 1033952272, -1108619674, -1146667493)
		+ W(7, 1018742870, -1095793020, 1044337364, 1039394788);
	sum2 =
		W(0, 1041249103, -1098300344, 1041141085, -1123648820) + W(1, 1040922446, -1147221163, 1014590689, -1115292810)
		+ W(2, 1047169006, -1097103704, -1094689158, 1021735499) + W(3, -1133026152, 1055827658, 1056443342, 1023898168)
		+ W(4, 1045305983, -1082349433, 1051958562, -1153021086)
		+ W(5, -1121038685, -1105225178, 1035590360, 1038130213) + W(6, 1032067159, 1036618956, -1098250629, 1035045284)
		+ W(7, 986169209, -1102095468, -1145857885, 1030074795);
	WS(1066007616, 1040865170);
	sum1 = W(0, 1016703369, -1154003525, -1104662792, -1111826720)
		 + W(1, -1106398093, 1038441464, 1031083397, -1146451379)
		 + W(2, -1114560988, -1112021256, 1052887594, -1102003526)
		 + W(3, -1096325697, 1050813825, 1061249791, -1102172436)
		 + W(4, -1094335779, 1059033474, -1126656183, -1104413998)
		 + W(5, 1023023221, -1108543232, -1106571274, -1109007926)
		 + W(6, -1113231876, 1040892233, -1121820472, -1112600993)
		 + W(7, 1022983872, 1034570898, -1115038347, -1123919488);
	sum2 = W(0, -1117895883, -1109314178, 1043196819, 1029963629)
		 + W(1, 1036640719, -1103775527, 1047073701, -1117061975)
		 + W(2, -1092695525, -1079308608, 1032498235, 1053147047)
		 + W(3, -1109277526, -1088245301, 1071134194, -1113344034)
		 + W(4, 1054484712, 1032194306, -1098274857, 1027577620)
		 + W(5, -1102073467, 1058556412, -1102222667, -1104158962)
		 + W(6, 1047716642, -1097777200, 1028797614, 1019489703)
		 + W(7, -1115714917, 1049638324, -1109885254, -1106961770);
	WS(-1112959995, -1090797387);
	sum1 =
		W(0, 998546749, -1107113888, 1042251615, 1034524319) + W(1, -1102515009, -1157171375, 1043372984, -1109045169)
		+ W(2, 1018649191, -1095395659, 1057847906, 1025715818) + W(3, 1024148768, -1088418302, 1049085946, -1107024218)
		+ W(4, 1036601843, -1108499994, 1054314562, 1036766314) + W(5, 991750171, -1092700079, 1052242560, -1102346050)
		+ W(6, -1134314668, -1100812608, 1010001228, 1041369791)
		+ W(7, 1024106779, -1106951576, 1043704436, -1136260253);
	sum2 = W(0, -1097076796, 1045091130, 1028367411, 1016501386) + W(1, 1000463738, 1024736081, 1040206702, -1122385083)
		 + W(2, -1083533587, 1064625577, -1112850496, -1104146558)
		 + W(3, 1064100942, -1096201033, -1086258418, 1050125885)
		 + W(4, 1074997490, -1071550159, 1052069491, -1105686824)
		 + W(5, 1043707697, -1106033160, -1098690685, 1041978517)
		 + W(6, 1028507309, -1118548401, 1050202273, -1109567340)
		 + W(7, -1152835380, -1111712908, -1113053149, 1032203802);
	WS(1065286463, -1155116140);
	sum1 = W(0, -1127743664, -1099417962, 1047837241, 1035108393)
		 + W(1, 1036265535, -1091060822, 1038987540, -1121911642)
		 + W(2, -1118137852, -1088882712, 1061626690, -1119901843)
		 + W(3, -1121018025, -1089265061, 1069311516, -1100290432)
		 + W(4, 1024160014, -1088513194, 1053957977, -1101311755) + W(5, 1028265374, -1090887512, 1051214117, 980641778)
		 + W(6, 1031461691, -1097685517, 1050330231, 1030945477)
		 + W(7, -1116217572, -1096201501, 1045642342, 1036102670);
	sum2 = W(0, 1023964675, -1104287950, -1095527688, -1107378538)
		 + W(1, 1054178647, -1098771138, -1106164282, -1107123343)
		 + W(2, -1104607531, 1030951671, 1049293814, -1102317974)
		 + W(3, -1088748842, 1062304002, 1069791349, -1093097006)
		 + W(4, 1034720649, 1056993385, -1106129898, -1107155572)
		 + W(5, 1027793575, -1095484784, -1093744890, -1104614583)
		 + W(6, 1026748348, -1103591056, 1040804508, -1111048704)
		 + W(7, 1048440611, -1115722179, -1102843948, 1036145149);
	WS(-1107864827, -1106183398);
	sum1 = W(0, -1106667222, 1028246417, 1062610107, -1094330385)
		 + W(1, 1032383543, -1105288567, 1048732230, -1113355593)
		 + W(2, -1104095901, 1024277645, 1033194034, -1100412503)
		 + W(3, -1105126732, 1031807228, -1097352540, -1110531197)
		 + W(4, -1119082647, 1024663749, 1042072353, -1106817153)
		 + W(5, -1099092218, 1059042594, -1097841594, -1119219065)
		 + W(6, -1106477481, 1038514313, -1132497297, -1116226478)
		 + W(7, -1100466619, 1061247795, -1116357250, -1112377140);
	sum2 = W(0, -1124057659, 1049202878, 1055877653, 1043135164)
		 + W(1, -1107748661, 1029365940, 1040631102, -1120955446)
		 + W(2, -1106641450, -1100669682, -1121942624, 1048773070)
		 + W(3, -1106278570, -1090514146, -1097531540, -1096084011)
		 + W(4, -1115427744, 1050790854, -1095195500, 1040842880)
		 + W(5, 1045306633, -1101749265, 1044511371, -1101432694)
		 + W(6, -1107251222, 1044664667, -1123742683, -1108344435)
		 + W(7, 1044220643, 1051259000, 1035140356, -1156279482);
	WS(-1107710971, -1103335008);
	sum1 = W(0, 1020774038, 1057965326, -1096736580, -1108312647)
		 + W(1, -1097452822, 1052789750, -1097416740, 1007270548)
		 + W(2, -1103681302, 1061528673, -1090723228, 1008435167)
		 + W(3, -1142400543, 1059882105, -1082070814, 1032878150)
		 + W(4, -1130541650, 1058381533, -1096313647, 1024150455)
		 + W(5, 1035627390, 1052101646, -1092903493, 1029066731) + W(6, 1026485526, 1047827121, -1095953623, 1024752368)
		 + W(7, 1026933710, 1048909172, -1094072619, -1129872006);
	sum2 = W(0, -1091198687, 1051358993, 1026242284, 1036983987)
		 + W(1, -1096592719, 1056674994, -1102658445, -1112372364)
		 + W(2, -1088722291, 1050253089, 1039492851, -1109827680) + W(3, 1017819408, 1057806550, 1048044980, 1033031265)
		 + W(4, -1104841225, -1098514434, 1047848116, -1106004699)
		 + W(5, 1047280108, -1095745001, -1114927114, -1128936304)
		 + W(6, -1133964792, -1121773836, 1009730080, 1044703642)
		 + W(7, 1046210234, -1101840089, -1115459009, -1121859563);
	WS(1046617982, -1079283690);
	sum1 = W(0, -1112235521, -1103103206, 1050398983, 1031782004)
		 + W(1, -1112371935, 1005568807, 1053710959, -1112406582)
		 + W(2, 1046025067, -1082068590, 1059470764, -1109731202)
		 + W(3, -1114138877, 1053438832, 1056782757, -1120370051)
		 + W(4, -1100106092, 1050481934, -1084354719, 1047048563)
		 + W(5, -1106636112, -1113851306, 1044662919, -1114617505)
		 + W(6, 1006684852, -1101804759, 1028720557, -1122334215)
		 + W(7, -1134743124, -1101795702, 1040488963, 1035089325);
	sum2 =
		W(0, -1123583696, -1114190125, -1123424510, 1035265901) + W(1, 1041752924, -1107057915, -1108427412, 1011193218)
		+ W(2, -1096033091, 1054169171, -1101097272, -1097576107) + W(3, 1045050816, 1066165326, 1060681517, 1037309084)
		+ W(4, -1111810372, -1090934807, -1093738003, -1094306097)
		+ W(5, 1044170848, -1094482563, -1094742214, 1047478278) + W(6, 1035342189, 1030376713, -1122528198, 999245333)
		+ W(7, -1107148363, -1140242036, 1046835784, -1118953940);
	WS(1057107647, -1115492411);
	sum1 =
		W(0, 1043432615, 1037909322, -1092726398, 1042270260) + W(1, 1017716083, 1044219192, -1094557923, 1036944691)
		+ W(2, -1115224236, 1059480955, -1089724826, 1049175094) + W(3, 1034158091, 1055275264, -1079486955, 1036017407)
		+ W(4, 1031606075, 1062186253, -1094016652, -1112299996) + W(5, 1040917102, 1051479740, -1090199321, 1012181234)
		+ W(6, -1119339928, 1036604907, -1111430132, 1026270626)
		+ W(7, 1006053250, 1049031914, -1124163213, -1106538704);
	sum2 = W(0, 1018646782, 1037675363, 1056993548, -1095820604)
		 + W(1, -1107779390, 1041358579, -1114299594, -1106961783)
		 + W(2, 1048577488, -1103110037, -1108103869, -1113810892)
		 + W(3, -1094766117, 1063077105, 1069120744, -1094104293)
		 + W(4, 1029078775, -1094239344, 1019393926, -1100654825)
		 + W(5, -1115207772, -1097294293, -1090842684, 1030620215)
		 + W(6, 1041354677, -1106609062, -1103795001, 1015746998)
		 + W(7, -1134027235, 1005749079, -1111892981, 1031888221);
	WS(1038408187, -1104646224);
	sum1 =
		W(0, -1100666444, 1031841147, 1045835257, -1121385297) + W(1, 1032659338, -1095811512, 1046356758, -1115316924)
		+ W(2, -1096791479, 1046629869, 1055310447, -1109718991) + W(3, 1050254507, -1086582314, 1049546009, 1043876936)
		+ W(4, -1125163769, -1092033141, 1059064223, -1115882186)
		+ W(5, 1034716030, -1095590162, 1032941357, 1051195252) + W(6, -1104041563, 1012740704, 1016606100, -1110386378)
		+ W(7, 1024265746, -1097384267, 1043234370, -1121465454);
	sum2 =
		W(0, 1033146053, 1033178697, -1110558215, -1107600367) + W(1, 1034495435, 1013274853, -1103797816, 1046600596)
		+ W(2, 1033891153, 1044565157, -1074394842, -1096372667)
		+ W(3, 1015618236, -1083473003, -1075035519, 1071496075) + W(4, -1102272365, 1047899954, 1070896015, 1070598351)
		+ W(5, 1026402836, 1033829854, -1107786181, -1103057086)
		+ W(6, -1126192412, 1026659107, 1039466503, -1099451771)
		+ W(7, -1130670616, -1129244632, 1033633210, -1106841766);
	WS(1060540543, -1145107984);
	sum1 = W(0, 1016949312, -1111708420, 999025948, -1110878953) + W(1, 1033700674, -1115158282, 1037057540, 1034636061)
		 + W(2, 1008485935, -1112773425, -1111113150, 1006219749)
		 + W(3, 1050394829, -1105627788, -1105528438, 1047777444)
		 + W(4, 1025975118, -1166436080, -1092533512, 1034379342)
		 + W(5, 1027755062, 1049090616, -1097657169, 1023310559)
		 + W(6, -1166944971, -1131929874, -1125616567, 1042471825)
		 + W(7, 1036625882, 1027903943, -1104970374, 1029991232);
	sum2 = W(0, -1112727972, 1028528033, 1050127712, 1039139414)
		 + W(1, 1041061913, 1047913039, -1120606988, -1090975722)
		 + W(2, 1030171918, 1058299937, -1075312291, -1096898908)
		 + W(3, 1049192765, -1088725965, 1051042420, 1056682084) + W(4, -1097932217, 1006741474, 1061621025, 1043329296)
		 + W(5, -1108991614, 1028842331, -1120436768, -1136718330)
		 + W(6, -1128255593, -1119404040, 1041035795, 1019658885)
		 + W(7, -1128975721, 1019613109, 1038145345, 1017746289);
	WS(1058512095, 1047466767);
	sum1 = W(0, 1025672397, -1102753041, 1037445664, 1037433000) + W(1, 1032743763, 1015664161, 1032570339, 1033220516)
		 + W(2, 1046625694, -1102686879, -1091026739, 1035056566)
		 + W(3, 1040236986, -1099087483, -1089271035, 1024398415)
		 + W(4, 1041791363, -1097904327, -1100626131, 1043847942)
		 + W(5, 1042422310, -1097334084, 1051389809, 1042353123) + W(6, 1024317081, -1123206279, 1041773046, 1037697617)
		 + W(7, 1034505416, -1096407969, 1050962859, 1047698739);
	sum2 = W(0, -1111694157, -1097429792, 1052756319, -1115035673)
		 + W(1, -1113457231, 1040318944, -1131566802, -1108486657)
		 + W(2, 1007020677, -1109123041, 1066240251, 1057627634)
		 + W(3, -1110494513, -1087577139, 1071158756, 1052796029)
		 + W(4, 1036239980, -1115766281, 1055974927, 1037312144) + W(5, 1042151096, 1033854974, -1085216854, 1031946717)
		 + W(6, 1014804229, 1056323633, -1076147337, -1107413695)
		 + W(7, 1038268008, 1058473731, -1078122726, -1088208012);
	WS(-1087119871, 1051442968);
	sum1 =
		W(0, -1106951233, -1101188351, 1055191809, -1118371512) + W(1, 1026199466, -1102133666, 1046522759, 1024298399)
		+ W(2, -1111827529, -1096477343, 1061746551, -1102462991)
		+ W(3, 1034911407, -1081083296, 1062137809, -1118895495)
		+ W(4, -1110066258, -1093686286, 1056808794, -1105243164)
		+ W(5, 1036906330, -1089794286, 1061657374, 1028468933) + W(6, -1121489041, -1102503648, 1025414769, 1001909715)
		+ W(7, -1123695161, -1096524016, 1043754020, 1039027467);
	sum2 = W(0, 1036012528, -1111568121, -1125130883, 1019317279)
		 + W(1, -1136414534, 1023613585, 1037328619, -1141870971)
		 + W(2, 1028357901, 1046290638, -1077265349, -1105362146)
		 + W(3, 1018170307, -1086518431, -1068062671, 1041918725) + W(4, 996800246, 1032866656, 1083861052, 1040576139)
		 + W(5, -1115554829, 1040198779, 1057186482, -1110577355)
		 + W(6, 1018408279, -1115393969, -1101393956, 1032099345)
		 + W(7, -1128152611, 1031067220, 1024816461, -1109411807);
	WS(1041081598, -1101063046);
	sum1 = W(0, 1038662072, -1123374599, 1035193857, -1104056554)
		 + W(1, -1105628103, 1048894326, -1098151405, 1009505700)
		 + W(2, 1046838359, 1044003395, -1109376817, -1107771451)
		 + W(3, -1112508084, 1062900743, -1082115704, 1039692648)
		 + W(4, -1112561351, 1058339600, -1087104856, 1049374543)
		 + W(5, 1047812813, 1041428913, -1097118497, -1126547869)
		 + W(6, -1106996345, 1044355834, -1098603955, 1037690530)
		 + W(7, 1045311157, 1013224727, -1110120844, -1121969199);
	sum2 = W(0, 1034938637, -1102665080, -1083931487, -1096043986)
		 + W(1, -1110454828, 1066739686, 1057500561, 1050111041) + W(2, 1044300205, 1063593500, 1069787057, 1057117236)
		 + W(3, -1094841314, -1072571644, -1073076170, -1094917255)
		 + W(4, 1049263704, 1050585763, 1057940110, 992791419) + W(5, -1123904781, 1033188794, 1049962317, -1119131193)
		 + W(6, 1032882093, 1040935597, -1103057884, -1129197337)
		 + W(7, 1018550156, 992411043, 1032437745, -1139242755);
	WS(1047493374, 1019974383);
	sum1 = W(0, 1039818779, 1024992878, -1099980259, -1119405261)
		 + W(1, 1022499782, 1056719767, -1093967742, 1017537921)
		 + W(2, -1111466513, 1056992349, -1089692488, -1134657044)
		 + W(3, -1128872350, 1066523241, -1081677329, 1032226588)
		 + W(4, -1102282821, 1057279594, -1104336096, -1110606353)
		 + W(5, 1027318580, 1050310409, -1095763174, 1029746358)
		 + W(6, -1112367361, 1043633508, -1147598863, -1105211995)
		 + W(7, -1121442618, 1050332018, -1103201160, -1109613299);
	sum2 = W(0, -1109381660, -1099927212, 1032613200, 1013674604)
		 + W(1, 1024006001, 1048105027, 1031703418, -1113331152) + W(2, 1048332575, 1083214625, 1051352300, 1010546556)
		 + W(3, 1030946168, -1068785948, -1082836395, -1137462284)
		 + W(4, -1111460550, -1080184440, 1047472657, 1033485356)
		 + W(5, -1115660792, -1125303858, 1027323348, 1034637753)
		 + W(6, 1027780517, -1129923962, 1006215943, -1112671380)
		 + W(7, -1125113546, 972536438, -1123338357, 1033990282);
	WS(1049191295, 1026054180);
	sum1 =
		W(0, 1015431080, -1104530451, -1120791464, 1041795830) + W(1, -1114491642, 1045418990, -1105318659, -1107859847)
		+ W(2, -1106844240, -1091806904, 1059085476, 1035107546)
		+ W(3, 1052544606, -1092275830, -1096734436, 1050727987)
		+ W(4, -1101337172, 1032037152, 1055073816, -1098252244) + W(5, 1006821496, -1091613549, 1054997266, 1024892180)
		+ W(6, 1048579163, -1136631349, -1117752159, -1114835508)
		+ W(7, -1107367092, -1104046587, 1054027444, -1107321874);
	sum2 = W(0, 1026733028, 1045033945, 1006278578, 1045459634) + W(1, -1099170713, 1052123052, -1100795787, 1045732660)
		 + W(2, -1116840904, 1011374557, -1137517037, 1036547859)
		 + W(3, -1119731112, 1034116255, -1093051584, 1049735621)
		 + W(4, -1105853851, 1042679995, 1032967726, -1115758581)
		 + W(5, 1023766170, -1103542762, 1030006514, 1012804929)
		 + W(6, -1109160117, 1002727514, 1010971477, -1107202197)
		 + W(7, -1110446049, -1116987471, 1032206215, -1108882618);
	WS(1061349183, 1052960956);
	sum1 = W(0, -1129777715, -1091852750, 1051531432, 1028688348)
		 + W(1, -1138324169, -1098630008, 1050117038, 1001458973)
		 + W(2, 1040354025, -1086948121, 1058780391, 1026112190)
		 + W(3, -1113069161, -1087783598, 1063142264, -1101543047)
		 + W(4, 1026875928, -1090578505, 1054898923, 1001807913)
		 + W(5, -1148679486, -1098392878, 1055753851, -1107707133)
		 + W(6, 1026350741, -1105317245, 1035239971, 1009551482)
		 + W(7, -1099366619, -1113156712, 1049214940, 1035358529);
	sum2 = W(0, 1030464194, 1016786912, -1124271380, -1112870762)
		 + W(1, -1114101658, -1111442214, 1036708968, 1035127660)
		 + W(2, 1031167290, 1040962599, -1145350210, -1119263136)
		 + W(3, 1076423743, 1052649879, -1106763968, 1030450749) + W(4, 1075592137, 1059016603, 1036666460, -1114823676)
		 + W(5, -1122765276, -1109148248, -1102467968, 1030453841)
		 + W(6, -1073082101, 1031660172, 1040647493, -1120712732)
		 + W(7, -1067763317, -1093716078, -1123536642, 1004437586);
	WS(1049240575, 1032641532);
	sum1 = W(0, 1013730783, 1058635434, -1096215015, -1112522509)
		 + W(1, -1105480706, 1033988870, -1101342144, -1114702617)
		 + W(2, -1114036922, 1060052265, -1095577996, 1026538642)
		 + W(3, -1113879072, 1060507082, -1090178495, -1118644393)
		 + W(4, -1104229785, 1060417175, -1088104859, 1026113715)
		 + W(5, -1108053747, 1056801557, -1096180920, -1115402364)
		 + W(6, -1114764169, 1045744608, -1096622362, -1165415829)
		 + W(7, -1146082265, 1050162924, 1035143657, -1096614130);
	sum2 = W(0, -1122276311, -1070701037, -1102500792, -1123484857)
		 + W(1, 1035291415, -1088124412, -1135890037, -1122878839)
		 + W(2, -1120194245, 1066415245, 1041496354, 1004310705) + W(3, 1040446858, 1074084237, -1104713726, 1043449641)
		 + W(4, -1120530587, 1049852139, -1121031703, 1033156545)
		 + W(5, -1138075205, -1122804719, -1103825640, 1027648711)
		 + W(6, 1025217366, 1023048268, -1123990667, 1022832518)
		 + W(7, -1118638617, -1139513797, 1028358694, -1136916673);
	WS(1058199967, 1050173679);
	sum1 =
		W(0, 1035142580, 1049466778, -1090097411, -1180331449) + W(1, 1027370573, 1058691576, -1101732588, 1040649373)
		+ W(2, -1130262537, 1039593430, -1086371009, -1120260556)
		+ W(3, 1035504777, 1068404719, -1088745136, 1040680775) + W(4, -1114438555, 1055172389, -1085029652, 1044382793)
		+ W(5, -1117883815, 1049428736, -1087836907, -1124005336)
		+ W(6, 1019391016, 1057860609, -1099893249, 1042216563)
		+ W(7, 1002653538, 1038434456, -1090680108, -1112700144);
	sum2 =
		W(0, -1116884059, -1098591960, 1049382153, -1103314039) + W(1, 1053572077, 1057696884, 1027480579, -1088718218)
		+ W(2, -1098664530, -1094622297, -1090176467, -1083506692)
		+ W(3, 1052736946, 1068603564, 1060239128, -1093271444)
		+ W(4, -1109898534, -1110319390, 1035982822, -1100206230)
		+ W(5, -1100793752, -1092295148, -1110105636, 1032439700) + W(6, 1049155169, 1060435963, 1048950002, 1034453968)
		+ W(7, -1110972354, -1093610507, 1038370396, 1006875670);
	WS(-1089372991, 1071972514);
	sum1 =
		W(0, -1138920887, 1036533027, -1102318256, 994211079) + W(1, -1111770809, -1104793556, 1048489074, -1105180974)
		+ W(2, -1102811010, 1055175791, -1087761408, 1048668925)
		+ W(3, -1115715559, -1099167419, 1059252133, 1002658941)
		+ W(4, 1039086134, -1087507272, 1053162297, -1118760057)
		+ W(5, -1097310634, 1049070430, -1114433380, 1015366427)
		+ W(6, 1031148825, -1119324807, -1118494745, 1042346841) + W(7, 1025838913, 1003453989, 1042268638, 1035401151);
	sum2 = W(0, 1030112837, 1042265630, 1026971571, -1110663804)
		 + W(1, -1120976510, 1036120703, -1114486026, 1036038820) + W(2, 990074782, 1034066763, 1060265655, -1093575269)
		 + W(3, -1093456890, 1054439327, 1048349987, -1097582212)
		 + W(4, 1037465699, -1093016348, -1099844302, 1034062294) + W(5, 1026987255, 1018637880, 1021593632, 1015927322)
		 + W(6, -1141406991, -1135344000, -1122669452, -1131991172)
		 + W(7, -1139369648, 1039303764, -1105461723, -1112258092);
	WS(1064707295, -1106068023);
	sum1 =
		W(0, -1099232505, -1122722466, 1050522762, -1163785122) + W(1, 1035233224, -1096714286, 1050648196, 1029641572)
		+ W(2, 1008917721, -1092366070, 1057836626, -1106158547)
		+ W(3, -1113461090, -1085444145, 1065526616, -1112344246)
		+ W(4, 1030936392, -1087864449, 1058128499, -1120989814) + W(5, 1004172005, -1089654074, 1053303385, 1023496586)
		+ W(6, 1027313190, -1109977746, 1046037453, -1132212895)
		+ W(7, -1115756158, -1096643772, 1045431365, 1026679026);
	sum2 =
		W(0, -1064765544, -1093639717, 1043466147, -1118670633) + W(1, -1081497441, 1052279998, -1106897145, 1026058867)
		+ W(2, 1073825520, 1049786220, -1111313590, -1120615525) + W(3, 1076205171, 1062543003, 1028519541, 1005098917)
		+ W(4, -1119211273, -1112239696, -1110796836, 1002459349)
		+ W(5, 1027623494, -1095053933, 1038884306, 1024155429) + W(6, 1025169073, 1041086677, -1138045203, -1139354443)
		+ W(7, 1044157267, -1111173396, -1103601885, 1031190784);
	WS(-1111449083, -1157616163);
	sum1 = W(0, -1140902742, 1050785866, -1096435822, -1106580347)
		 + W(1, -1108906886, 1041550344, -1095149714, -1111739842)
		 + W(2, -1107746707, 1063519767, -1097214657, -1112949561)
		 + W(3, -1091492130, 1070223306, 1059314470, -1090511327)
		 + W(4, -1106259270, 1056548545, -1091358630, -1115482851)
		 + W(5, -1123578095, 1033679887, -1102873285, -1102694659)
		 + W(6, -1112828291, 1033485706, -1098893397, -1119291392)
		 + W(7, -1129218172, 1037279241, -1105253969, -1105806553);
	sum2 =
		W(0, 1036877913, -1106537131, 1030920508, -1107276407) + W(1, -1107073590, 1029358898, -1148982309, -1158332371)
		+ W(2, -1107699229, 1059152956, -1101290720, -1104066278) + W(3, 1043855187, 1059494373, 1057939604, 1057817844)
		+ W(4, -1112562117, -1100478450, 1054005616, -1089434898)
		+ W(5, 1015957137, 1042289801, -1078154452, 1041374005)
		+ W(6, -1137092650, -1117856531, 1052159854, -1109759735)
		+ W(7, -1113777301, 1034651775, -1095096566, -1112996199);
	WS(-1078462192, -1081042006);
	sum1 = W(0, 1031777492, -1099264287, 1046006998, 987183826) + W(1, 1032754472, 1043123090, -1098614104, 1036343655)
		 + W(2, 1041664052, -1089905073, -1129274543, 1009990171)
		 + W(3, -1097597536, 1061087074, -1106235787, -1097811109)
		 + W(4, -1104816664, 1058804947, -1084543524, 1031138063)
		 + W(5, -1113883983, 1049386855, 1054195792, -1097275448)
		 + W(6, 1034668408, 1033759807, -1107840264, 1026038601)
		 + W(7, -1123431127, 1048603595, 1024992909, -1120606380);
	sum2 = W(0, 1045113399, 1042319052, -1096815184, -1116743882)
		 + W(1, -1114091637, -1104675582, -1111655631, -1101972302)
		 + W(2, -1107885511, -1091877193, -1112520325, 1050965596)
		 + W(3, -1138476145, 1051152873, 1061790396, 1049921296)
		 + W(4, -1105540689, -1091823953, 1058061302, -1092103725)
		 + W(5, 1035866831, 1034466874, -1097657024, 1042351236)
		 + W(6, -1106333432, 1039480371, 1040922298, -1102843808)
		 + W(7, 1027850472, 1012452041, -1158709515, -1125733657);
	WS(1056694143, -1116016311);
	sum1 = W(0, -1113789237, 1051083644, -1097139864, -1123205479)
		 + W(1, -1100431022, -1126988186, -1094809972, 1034447326)
		 + W(2, 1050877939, 1064972735, -1089357240, 1036660918)
		 + W(3, 1018856325, 1040063173, -1094444318, -1108178982)
		 + W(4, 1050520537, 1063261729, -1089641983, 1047968461)
		 + W(5, -1097203011, 1049408537, -1094346349, -1113292277)
		 + W(6, -1103919120, 1026641091, -1100978845, 1038849023)
		 + W(7, -1146363818, 1053332672, -1097363714, -1114302469);
	sum2 = W(0, -1117908102, 1019359999, -1120905960, 1017197102)
		 + W(1, 1013765983, -1145413682, 1028148573, 1027705717)
		 + W(2, 1045942570, -1095749402, 1032861566, -1127537989)
		 + W(3, 1086231745, -1062836828, -1087097136, 1031521084)
		 + W(4, 1048993826, -1094656357, -1145044098, 1027867224)
		 + W(5, -1110131683, 1037693606, 1040390747, -1114691836)
		 + W(6, 1005670802, -1125761673, -1112982831, 1031905995)
		 + W(7, -1126497913, 1018172516, 1016402027, -1122299754);
	WS(1058898623, -1129627348);
	sum1 =
		W(0, -1115961291, 1024824451, 1015893437, -1111982511) + W(1, -1114910804, 1028416398, -1107386562, 1040362701)
		+ W(2, -1099814536, 1053775806, -1081677098, 1049488325) + W(3, 1014875535, 1049045373, 1054905786, 1016424474)
		+ W(4, 1042946610, -1081844071, 1057687981, -1105282974) + W(5, 1008636276, 1031972351, 1045923489, -1118478155)
		+ W(6, -1106406626, 1007262993, 1043411542, 1018226304) + W(7, -1120594878, 1044145240, 1016529769, 1008933435);
	sum2 = W(0, -1133545882, 1024635319, -1123675276, 1049399700)
		 + W(1, 1048887568, -1104650552, 1009836758, -1109494815)
		 + W(2, -1092588040, -1106613727, -1090053582, -1105276085)
		 + W(3, 1040041167, 1061771033, 1063348295, -1099749985)
		 + W(4, -1098849827, 1059347143, -1095509129, -1094328117)
		 + W(5, 1009986974, 1020453405, -1091467004, 1040581639) + W(6, 1044263399, -1100016935, 1034750124, 1041257354)
		 + W(7, -1120224962, 1003801667, 1013849670, -1116729410);
	WS(1051954047, 1053754534);
	sum1 = W(0, -1115617616, 1038078984, 1012663597, -1106689047)
		 + W(1, 1024010640, 1036755054, -1111840872, 1027644834)
		 + W(2, -1105864485, 1063482792, -1094956956, 1000291764)
		 + W(3, -1104806436, 1054877383, -1088048944, -1099610254)
		 + W(4, -1109064955, 1061183100, -1092794954, 1030290339)
		 + W(5, -1116880702, 1032370277, -1106496725, -1110075188)
		 + W(6, -1125878182, 1043596932, -1106933961, -1134690355)
		 + W(7, 1017392662, 1041423460, 1027390113, -1125796047);
	sum2 = W(0, 1032585330, 1041153226, -1098242715, 1045110917)
		 + W(1, -1120362784, 1038083675, -1097998955, 1041971655)
		 + W(2, 1053495069, -1085822417, -1097864806, -1094674500)
		 + W(3, -1103911013, 1062089523, 1056336567, -1090235355)
		 + W(4, -1152525762, -1088542584, 1061326318, -1100885631)
		 + W(5, -1128147020, 1044421032, 1046053205, -1141849761)
		 + W(6, 1012657824, -1113855086, 1042938789, -1114518568)
		 + W(7, -1104983105, 1041652917, -1160964996, 1032164357);
	WS(1061027871, -1104546242);
	sum1 = W(0, -1105616597, 999947493, 1020340785, 1044086916) + W(1, 1044372474, -1093243621, 1054887248, -1111771647)
		 + W(2, 1021564129, -1093936864, 1050165368, 1042456335)
		 + W(3, 1044930783, -1082760108, 1059757863, -1109427891)
		 + W(4, 1046184033, -1089254915, 1059995997, -1109416824)
		 + W(5, 1039863327, -1087020314, 1055330116, -1114227250)
		 + W(6, 1037242932, -1095491356, 1049586618, -1119355674)
		 + W(7, 1036593932, -1089177610, 1053764638, 1025046581);
	sum2 = W(0, -1071093827, 1060306884, 1049935328, -1107356858)
		 + W(1, 1026041138, -1087262504, -1137957530, 1030953599)
		 + W(2, 1068370917, -1080863241, 1024099582, 1026067688)
		 + W(3, 1068180608, -1104665609, -1097098353, -1149593287)
		 + W(4, -1099034443, 1065726420, -1115701817, 1031805059)
		 + W(5, -1126398467, 1036496204, 1043337171, -1111590832)
		 + W(6, -1114641099, 1052019191, -1155572887, -1110320626)
		 + W(7, 1032038973, -1112342652, 1039831002, -1165279566);
	WS(-1085156031, 1045210454);
	sum1 =
		W(0, 1032928297, 1062377574, -1090582815, -1097791665) + W(1, -1111119484, 1050029461, -1097825399, 1025846477)
		+ W(2, 1023710638, 1062121112, -1087364538, 1032229097) + W(3, 1012189550, 1061895670, -1084850381, 1038427330)
		+ W(4, -1119437633, 1058328143, -1086721078, 1040335420) + W(5, 1039427612, 1050106073, -1087870448, 1036234257)
		+ W(6, -1114651991, 1051812528, -1095972450, 1026163704)
		+ W(7, 1039591187, 1050020631, -1089842983, -1146480404);
	sum2 = W(0, -1123647935, 1061817512, 1083879676, 1056516802) + W(1, 1039341132, 1048143772, 1075567701, 1037735150)
		 + W(2, 1035983028, -1106274437, -1081957201, 1028242764)
		 + W(3, -1100132407, -1080635557, -1069811820, -1096421593)
		 + W(4, -1107056231, -1101127944, -1080342730, 1035329144)
		 + W(5, 1035406254, -1113472410, -1083251742, 1030744652)
		 + W(6, -1116224056, 1025367216, -1113852980, -1094803270)
		 + W(7, 1039408558, -1101636583, -1087422720, 1049804166);
	WS(-1079692512, 1054562755);
	sum1 =
		W(0, -1109749038, 1042438683, -1092016161, 1050333996) + W(1, -1107273417, 1049923207, -1091034933, 1042543591)
		+ W(2, -1102577952, 1044388569, -1089719139, 1055304278) + W(3, 1030213964, -1113189609, 1050309800, 1034159515)
		+ W(4, 1036563817, -1089184118, 1048990040, 1040366472) + W(5, 1046944740, -1087748930, 1053009554, -1122229091)
		+ W(6, 1031914983, -1096053014, 1048709856, 1006842402) + W(7, 1050658577, -1091524869, 1049517424, 1034826102);
	sum2 = W(0, 1041125733, -1094982607, 1055140379, 1061130686) + W(1, -1097603156, 1045744428, 1049918932, 990353951)
		 + W(2, -1103003109, -1102781952, -1106862916, 1058588396)
		 + W(3, -1107000988, 1063877853, 1066829095, -1096233798)
		 + W(4, 1032085636, -1096755169, -1090474230, -1095838692)
		 + W(5, 1048646468, 1041101455, -1081598978, -1089860215)
		 + W(6, -1094740103, 1038162032, 1049572267, -1096717844)
		 + W(7, 1056003520, -1106723297, -1085369603, 1044183141);
	WS(-1080283264, 1053171958);
	sum1 =
		W(0, 1045885175, 1054395509, -1083475508, 1028512496) + W(1, -1113658461, 1050045174, -1095192933, 1035446876)
		+ W(2, 1034538909, 1055879386, -1085810962, 1026195253) + W(3, 974135701, 1060600957, -1084797135, 1044250612)
		+ W(4, -1122513036, 1061640838, -1086057732, 1037521197)
		+ W(5, -1118011958, 1060753746, -1087204563, -1117222317) + W(6, 998696774, 1054788217, -1092652351, 1038575473)
		+ W(7, -1108239136, 1061053402, -1108529436, -1101819472);
	sum2 =
		W(0, 1049760823, 1082611215, -1114287788, -1130959534) + W(1, -1132622893, 1077078383, 1055018182, 1035090608)
		+ W(2, 1033001558, 1066257283, -1101461080, -1112584386)
		+ W(3, -1136534149, 986681348, -1078537691, -1090394759) + W(4, 1043696998, -1084657320, 1054805894, 1058031741)
		+ W(5, -1092886300, -1069070549, 1065047159, 1038822180)
		+ W(6, -1098156850, -1072372844, 1049854091, 1041633511)
		+ W(7, 1058228696, -1074505611, -1082348593, -1115499033);
	WS(-1073398920, 1057727890);
	sum1 =
		W(0, 1041979362, 1052994159, -1092671491, -1110295050) + W(1, -1106188342, 1056847849, -1087976920, 1033778006)
		+ W(2, -1108985859, 1060197326, -1085676269, 1040328063)
		+ W(3, 1040300287, 1059196498, -1108460501, -1114468666)
		+ W(4, 1044683952, -1094535618, 1051731585, -1102804911)
		+ W(5, 1046284093, -1094105983, 1046385743, -1098429184)
		+ W(6, 1044621499, -1102914751, 1031818215, -1104640754) + W(7, 990388050, 1043962286, -1104493131, 1033981777);
	sum2 = W(0, 1021160276, -1089430647, -1102895535, 1031984432)
		 + W(1, -1093219342, -1135654176, 1044152573, -1096279754)
		 + W(2, -1089562294, -1079796815, -1095163331, 1011763192)
		 + W(3, -1106388958, 1074674993, 1074136497, -1101895278)
		 + W(4, -1099093932, -1098010580, -1095203310, -1117345690)
		 + W(5, -1180890998, 1052929457, -1099885509, -1095468231)
		 + W(6, -1090965228, 1040584224, 1041387674, -1107912603)
		 + W(7, 1057228486, 1047748991, -1131585606, 1045144673);
	WS(-1087643711, 1073414034);
	sum1 =
		W(0, 1043421796, 1043019738, -1091862260, 1028452722) + W(1, -1116796288, 1056957030, -1093379129, -1112484637)
		+ W(2, 1042590607, 1048028053, -1089120888, 1043084437)
		+ W(3, -1098636497, 1065994910, -1081315117, -1120978641)
		+ W(4, 1008405302, 1061262410, -1088787029, 1046109207) + W(5, 1005024220, 1059267719, -1093593189, -1105879924)
		+ W(6, -1106384411, 1045820026, -1108751805, 1024805700)
		+ W(7, 1029633907, 1054563645, -1106230054, -1095994501);
	sum2 = W(0, 1015257573, -1101361376, -1151605286, -1114431290)
		 + W(1, -1117575950, 1051853927, -1126719224, -1122150057)
		 + W(2, 1040590395, 1007636882, -1099060090, -1123376079)
		 + W(3, 1040031817, -1085239439, -1069257368, -1122292554)
		 + W(4, -1104875608, 1029484438, 1078894141, 1045790053)
		 + W(5, -1111928738, 1055085469, 1065488662, -1105709439)
		 + W(6, -1124331304, -1104410806, -1097362053, 1046590167)
		 + W(7, -1104400845, 1055334030, -1099504604, -1096100911);
	WS(-1089052703, 1050218486);
	sum1 = W(0, 1024924308, 1032977094, -1127622480, 1016061078)
		 + W(1, -1124263665, 1048865735, -1103037451, 1027347950)
		 + W(2, -1114112032, 1032370348, -1093324152, 1047024376)
		 + W(3, -1101857739, 1057017435, -1130658874, -1114101947)
		 + W(4, 1004177297, -1096925880, 1049797356, -1136753151)
		 + W(5, -1132101549, -1106597310, -1147023991, -1136950735)
		 + W(6, 1037546120, -1101706323, -1148374781, 1016234194)
		 + W(7, -1127618735, -1138126252, 1041185327, -1135392976);
	sum2 =
		W(0, -1103127935, 1033687244, 1044282132, -1115309191) + W(1, 1034551493, -1111330163, -1132159854, -1101537844)
		+ W(2, -1131095837, -1111327049, 1043675418, 989659429) + W(3, 1056852609, -1097897810, 1038437355, -1126658673)
		+ W(4, 1041291951, -1092598078, -1085166716, -1101159602)
		+ W(5, 1031312786, 1027703970, -1122838335, 1065573620) + W(6, -1119687326, -1119650108, 1030316614, 1035948285)
		+ W(7, -1125922018, 1037109557, -1115941571, 1021015548);
	WS(1065854560, -1114586365);
	sum1 = W(0, 1025132845, -1093129789, 1039292161, 1052478106)
		 + W(1, -1132208108, -1097600366, 1047014713, -1114318540)
		 + W(2, 1043375962, -1094779500, 1054220253, 1045472794) + W(3, 1036127555, -1085251325, 1059484531, 1040640636)
		 + W(4, 1042813603, -1085614646, 1058902029, 1026772633) + W(5, 1042302785, -1083792532, 1058554289, 1030110605)
		 + W(6, 1041475414, -1088034874, 1049492791, -1123458066)
		 + W(7, 1044294516, -1081301837, 1057966909, 1048041627);
	sum2 =
		W(0, -1082315074, -1085719643, 1072912386, -1097858732) + W(1, 1044643809, 1026206592, -1098026838, -1097387905)
		+ W(2, -1098370418, 1060376399, 1068488422, -1097681385) + W(3, 1032322202, 1066420950, 1072201946, -1095903963)
		+ W(4, -1088636595, 1042910065, 1055106268, -1092707091)
		+ W(5, 1057109638, 1025783712, -1087763572, -1104219349)
		+ W(6, -1093539506, -1117795056, -1084317601, -1087895305)
		+ W(7, 1061431798, -1120476284, -1077472196, -1105350768);
	WS(-1071370880, 1080498273);
	sum1 =
		W(0, -1117491793, -1117320376, 1025681812, -1112958490) + W(1, 1039364315, -1100646881, 1049740511, -1103504723)
		+ W(2, 1035846886, -1094786920, 1058631773, -1105396320) + W(3, 1023528601, 1045848824, -1094741601, 1032469201)
		+ W(4, -1131889533, 1057069771, -1088346742, 1034336534)
		+ W(5, -1106314247, 1055228236, -1102894479, -1144513794)
		+ W(6, 1028375004, 1020389492, -1138962992, -1116565942) + W(7, 1013100112, -1127017775, 995411618, 1002008579);
	sum2 = W(0, -1097850747, -1108946242, -1129761151, 1024320851)
		 + W(1, -1107398437, -1114277717, -1118690429, 1012636527)
		 + W(2, -1085613590, 1063125687, 1040789135, 1029278628)
		 + W(3, 1042292809, -1084555354, -1101999238, 1026191463)
		 + W(4, 1054106205, 1059764079, 1051725304, -1119736004)
		 + W(5, -1106648125, 1041901467, -1128317719, -1127460399)
		 + W(6, 1035361236, -1103098774, 1022272136, -1115360404)
		 + W(7, -1122554235, -1148617751, 1025957669, 997652141);
	WS(1058528159, 1053906024);
	sum1 = W(0, -1112917396, -1104256080, 1023681564, 1039659283)
		 + W(1, 1035675727, -1092229473, 1058833811, 1021887717)
		 + W(2, -1104938189, -1097223269, 1051100098, 1033492802)
		 + W(3, 1040468760, -1082484606, 1061928249, -1119337706)
		 + W(4, -1105254898, -1103704557, 1057519273, -1099217437)
		 + W(5, 1020887917, -1100912091, 1047691241, -1127325712)
		 + W(6, -1113141838, -1118771074, 1047329733, -1114402703)
		 + W(7, -1149793215, -1099449368, 1044776397, 1024214504);
	sum2 = W(0, -1129442596, 1040644144, -1106302200, -1105488042)
		 + W(1, 1023778714, 1033307012, 1056981996, 1014815489) + W(2, -1113953277, 1056896617, 1082625405, 1048992482)
		 + W(3, 1026809294, -1080168883, -1064674592, 1043950232)
		 + W(4, 1035644478, 1030172798, -1098216535, -1120732434)
		 + W(5, 1034718426, 1046899220, -1107268878, -1121557578)
		 + W(6, 1016827280, -1114672577, -1138831353, 1026207834)
		 + W(7, 1038084720, -1138817753, -1118740750, -1122753582);
	WS(1050028863, 1057904824);
	sum1 = W(0, 1016998719, -1115527732, 1049960370, 1033316845)
		 + W(1, 1031484924, -1114471481, -1097014217, 1045307870)
		 + W(2, -1113918453, -1092713340, 1059124695, -1113659631)
		 + W(3, 1035763396, -1086973069, 1055821255, -1113580281)
		 + W(4, -1100192683, 1048884339, 1045748179, -1104759887)
		 + W(5, 1046082071, -1093669960, 1046233018, 1024760783) + W(6, 1023767163, -1109475380, 972758359, 1028768132)
		 + W(7, -1109585801, -1102684193, 1047341446, -1118597711);
	sum2 = W(0, 1042577042, 1058174637, -1093234196, 1036828005) + W(1, 1035985609, 1022451597, 1028288917, 1036599280)
		 + W(2, -1132583692, -1083350192, -1089654696, 1043707159)
		 + W(3, -1108557005, -1102051996, 1066585170, -1099096459)
		 + W(4, 1045882832, -1096734805, -1112976831, -1117191962)
		 + W(5, 1049978360, 1040525485, -1101233023, 1038823523)
		 + W(6, -1123148614, -1111555351, 1016281700, 1010883764)
		 + W(7, 1037998467, 1012738322, 1035922998, -1106116243);
	WS(1064158815, 1035299335);
	sum1 =
		W(0, -1112803360, 1016610641, 1043480489, 1023721675) + W(1, 987363362, -1111853690, -1116662313, -1114846141)
		+ W(2, 1040202935, -1090418272, 1043761841, 1040437218) + W(3, -1148543050, -1086418793, 1062267936, 1044974085)
		+ W(4, -1119103150, -1096774480, 1026731899, -1112576238)
		+ W(5, 1016866897, -1106302329, 1046949595, 1035797256)
		+ W(6, -1120253212, -1125874772, 1044534239, -1118929285)
		+ W(7, -1136961231, -1111706212, 1038415821, 1017229376);
	sum2 = W(0, 982347958, -1130481715, 1039697927, 1029826582)
		 + W(1, 1032509555, -1105443060, -1102232537, -1106323503)
		 + W(2, -1111294086, 1041532435, 1059036310, -1087181565)
		 + W(3, 1034453505, -1090026061, 1065332554, -1095157490)
		 + W(4, -1107492941, -1115327745, 1049776291, 1032022369)
		 + W(5, 1047671755, -1099067440, 1035057967, -1113855935)
		 + W(6, -1114281099, 1007189687, -1116755236, -1137758215)
		 + W(7, 1041657921, -1106888056, 1039394631, -1116441678);
	WS(1064590463, 1056702913);
	sum1 = W(0, 1029043770, -1118119137, 1044521535, -1108622774) + W(1, 1053372231, 1049750478, 1040212560, 1055292354)
		 + W(2, -1096751755, -1090400466, 1048069253, -1086796959)
		 + W(3, 1042753121, -1089893441, -1098259842, 1028130891)
		 + W(4, -1132040847, 1035942347, 1046519145, 1043794349)
		 + W(5, -1098166823, -1098407696, -1126503113, -1097599727)
		 + W(6, 1054745035, 1057009004, 1029470901, 1057963224)
		 + W(7, -1101919647, -1105867448, -1137574860, -1099480944);
	sum2 = W(0, -1112469736, 1047380321, -1107309008, -1130012001)
		 + W(1, -1109993908, 1048112351, -1096267194, 1044766357)
		 + W(2, -1113626244, 1039961237, -1149218892, 1024449363)
		 + W(3, -1101975228, 1053720344, 1041967405, -1105185961)
		 + W(4, -1113395603, 1033059361, -1105421186, 1034928166)
		 + W(5, -1115391866, -1117206471, 1041082150, -1103730760)
		 + W(6, -1111764318, 1050486894, -1097114178, 1041700935)
		 + W(7, -1114050909, 1029031616, -1116211284, -1133808950);
	WS(1049282175, -1081654589);
	sum1 = W(0, 1026879882, 1056840376, -1089715922, 1023576205)
		 + W(1, -1106636470, 1051340514, -1103588481, 1019713064)
		 + W(2, 1025593670, 1059046350, -1087728227, 1018583793)
		 + W(3, -1120434947, 1060994015, -1081081863, -1116831948)
		 + W(4, -1109057316, 1062254571, -1089160278, 1040563949)
		 + W(5, -1103814142, 1054415372, -1110084674, -1148705741)
		 + W(6, -1108405355, 1044610849, -1097611347, -1130543166)
		 + W(7, 1025046173, 1057281100, -1102762237, -1108038889);
	sum2 = W(0, 1021240677, -1112389783, 1025718250, -1104779102)
		 + W(1, -1117500355, -1154883848, -1096682611, 1051908652)
		 + W(2, -1104166105, -1102583420, 1048911763, -1093040032)
		 + W(3, -1110155670, 1061056453, 1065471868, 1051220588)
		 + W(4, -1101525323, -1123615532, -1149445264, -1113750073)
		 + W(5, -1099065181, 1038434309, -1090281103, -1098156535)
		 + W(6, -1135933351, 1041908272, 1042017461, 1046751376)
		 + W(7, -1100288377, -1120914319, -1131934595, -1100861861);
	WS(1044733566, -1111466942);
	sum1 = W(0, 1033634167, 1060020808, -1092913556, -1112663104)
		 + W(1, -1105078967, 1041929508, -1103349137, -1134753630)
		 + W(2, -1104340430, 1062221635, -1092289734, -1126194825)
		 + W(3, -1106426842, 1060048443, -1090785767, -1110397240)
		 + W(4, -1101553619, 1059584252, -1094348262, -1114529117)
		 + W(5, -1110993602, 1054717575, -1097827057, -1113238887)
		 + W(6, -1113465444, 1044713794, -1098824243, -1140846474)
		 + W(7, 1020428386, 1047352089, 1041060918, -1094820883);
	sum2 = W(0, 1040248415, 1084299283, 1054267917, 1002599056) + W(1, -1113076108, 1066146464, 1032173778, 1029289900)
		 + W(2, 1043824330, -1073408210, -1102778436, 1027082476)
		 + W(3, -1105221470, -1067326117, -1084477148, -1116688572)
		 + W(4, 1036602392, -1097425816, -1149511007, 1024010398)
		 + W(5, -1134849104, 1016852200, 1040914456, -1121212984)
		 + W(6, -1163695359, -1119512248, 1026379762, 1007530464)
		 + W(7, 1011808464, -1118870508, 1011171408, 1020903456);
	WS(1041204862, 1020998748);
	sum1 =
		W(0, 1041320410, 1040787048, -1129649268, -1136864165) + W(1, -1111643799, 1044400490, -1096018340, -1123167632)
		+ W(2, 1033147201, -1112000574, 1041936758, 1014392453) + W(3, 1033305824, 1057857240, -1090212595, 1043382402)
		+ W(4, -1110534482, 1058317173, -1083609992, 1046901861) + W(5, 1048653459, 1013490791, -1108280561, 1040774794)
		+ W(6, -1106102028, 1040475768, -1098465902, -1121200123)
		+ W(7, -1129433652, 1032979455, -1104103124, -1123801518);
	sum2 = W(0, 1033367466, -1105739926, 1035166617, -1121294834)
		 + W(1, 1036408153, 1041467605, -1116824529, 1020242785)
		 + W(2, 1049195658, -1097896497, -1127250349, 1024987646)
		 + W(3, -1116950481, 1069287141, -1103787577, -1113169844)
		 + W(4, -1081345874, 1045676499, -1104285546, -1109755223)
		 + W(5, 1035726191, -1097322898, -1110450029, -1162599282)
		 + W(6, -1109751565, 1034595972, 1041775082, -1128984227)
		 + W(7, 1034565507, 1022861151, -1111377560, 1015705141);
	WS(1061587071, -1140717261);
	sum1 = W(0, -1112565188, -1082585266, 1063001355, 1029148274)
		 + W(1, 1035683412, -1091946062, 1057075562, -1133150565)
		 + W(2, 1034588141, -1086181493, 1061257307, -1121255338)
		 + W(3, -1105710858, -1084260507, 1062016535, 1031972073)
		 + W(4, 1024277837, -1087521200, 1059484653, -1140527211)
		 + W(5, -1104681461, -1094344584, 1051726365, 1015752222)
		 + W(6, 1033519565, -1109665588, 1053582679, -1140031633)
		 + W(7, -1097426768, -1092361421, 1050023351, 1054184694);
	sum2 = W(0, 1052095029, -1068831962, -1076286348, 1061242602)
		 + W(1, 1040595366, -1076957703, -1081349117, 1046002483)
		 + W(2, -1098987175, -1081538085, -1088771362, 1040290526)
		 + W(3, -1084153168, 1037971476, 1057908839, -1093902656)
		 + W(4, -1091290481, 1070110671, -1114213425, -1094367529)
		 + W(5, -1096720628, 1069986978, 1063483875, -1094489561)
		 + W(6, -1101102486, 1074264190, 1068552571, -1099236623)
		 + W(7, 1044734380, 1070997731, 1075267150, -1081182731);
	WS(-1071242520, -1095264341);
	sum1 =
		W(0, -1097248122, 1057257956, -1095464807, -1098637431) + W(1, 1017326143, 1050464317, -1098731544, 1039614697)
		+ W(2, -1105336241, 1059871125, -1096805078, 1034135507)
		+ W(3, -1091856432, 1058219580, -1088025845, -1098503641) + W(4, 1051920949, 1056167546, 1032394345, 1057766069)
		+ W(5, -1097210280, 1051126389, -1089070234, -1095933097)
		+ W(6, -1122345698, 1047883744, -1102431837, 1030493340)
		+ W(7, 999615444, 1055359408, -1098523426, -1112287963);
	sum2 = W(0, -1132961311, 1038597560, -1089057302, 1055074030)
		 + W(1, 1034954689, -1114842936, -1113751042, 1048893008)
		 + W(2, -1131131128, 1039456110, -1095192990, 1046429121)
		 + W(3, -1105685093, -1104727669, -1097910004, 1057064004)
		 + W(4, 1044104138, -1085849936, 1064526735, -1091871118)
		 + W(5, -1118659572, 1053272959, 1045257331, -1096323208)
		 + W(6, -1117347443, -1117746499, 1054461586, -1090448877)
		 + W(7, -1140373421, 1049759548, 1062278408, -1081803378);
	WS(1055746431, 1040288248);
	sum1 = W(0, -1154016945, 1057716289, -1093759650, -1122750430)
		 + W(1, -1117613130, 1055590360, -1094487986, -1117149477)
		 + W(2, -1108247483, 1059644857, -1089867895, 1031955359)
		 + W(3, -1114072538, 1067207252, -1085229664, 1016534394)
		 + W(4, -1103530014, 1062212336, -1089860607, 1044969554)
		 + W(5, -1134724696, -1104299500, -1088563377, -1137442922)
		 + W(6, -1102903742, 1049302591, -1097577389, 1035178328)
		 + W(7, 1046496384, 1054319858, -1094962569, -1108831509);
	sum2 = W(0, 1041968914, 1051752153, -1123800846, -1117011966)
		 + W(1, 1026703145, -1115260470, 1035127537, 1031245794) + W(2, 1033601916, 1038625472, 1035458769, -1109678904)
		 + W(3, 1035338047, 1052354182, 1035609386, 1050054059)
		 + W(4, -1106207855, -1118891350, 1057116581, -1098815779)
		 + W(5, -1094112140, -1081023345, -1104080857, 1038926653)
		 + W(6, -1100978937, -1084581041, 1055976243, -1108176195)
		 + W(7, -1106593629, 1066756564, -1101750238, -1107244818);
	WS(-1089881759, 1037957184);
	sum1 =
		W(0, 1000251530, -1098029886, -1105974859, 1041712355) + W(1, -1117869170, -1095515176, 1060224425, 1040628361)
		+ W(2, 1029072469, -1089055515, 1060210489, 1042449912) + W(3, 1031851625, -1079829205, 1061092856, -1119516507)
		+ W(4, 1024508279, -1094362449, 1060581840, -1102207965)
		+ W(5, -1105582638, -1105281331, 1056017638, -1107063314)
		+ W(6, -1121710869, -1112643769, 1040568609, -1112932479)
		+ W(7, -1105403363, -1102959900, 1050032516, -1124065669);
	sum2 = W(0, 1051114274, -1102532150, -1093533301, 1042271071)
		 + W(1, -1105565679, -1114476854, 1038543175, -1112348507)
		 + W(2, 1055378846, -1082969540, -1075201485, -1087360189)
		 + W(3, -1098769061, 1064670328, 1077554590, -1100903801)
		 + W(4, -1106275827, -1102001010, 1048871628, -1115312306)
		 + W(5, -1101598109, 1044770567, 1040464379, 1031777408)
		 + W(6, -1109849433, -1114021751, -1111404687, -1125205988)
		 + W(7, -1104426610, 1049459491, 1049461049, -1104546886);
	WS(-1089609215, -1090633405);
	sum1 = W(0, -1095985139, 1060468726, 1029992257, -1106189340)
		 + W(1, -1131730646, -1114989785, 1035463235, -1121474072)
		 + W(2, -1106836118, -1111340153, 1053834481, -1109753904)
		 + W(3, -1120898567, -1083229835, 1057093887, -1170836447)
		 + W(4, -1122196780, -1097505195, 1060127651, -1099640750)
		 + W(5, -1108220230, -1091862496, 1056095953, -1106303115)
		 + W(6, -1113602180, -1118278055, 1053644551, -1102165833)
		 + W(7, -1111282801, -1094974325, 1060964715, -1114233933);
	sum2 = W(0, -1102755055, 1028184991, 1014375557, 1018724927)
		 + W(1, -1123071369, 1018963304, 1034540123, -1154538439)
		 + W(2, -1101642458, 1042446539, -1110958917, 1030328833)
		 + W(3, -1121616776, 1048904011, 1055634924, -1104340897)
		 + W(4, -1123659230, 1022095962, -1122273513, -1123674010)
		 + W(5, 1034971308, -1102092583, 1047229966, -1103087688)
		 + W(6, -1114444448, -1115812270, 1006913192, -1118183380)
		 + W(7, 992820811, -1115600403, 1032293939, -1116477720);
	WS(-1089497119, -1083970920);
	sum1 =
		W(0, 1049400081, 1017038202, -1096866095, -1129668560) + W(1, -1112985379, 1054102421, -1092440080, 1023489999)
		+ W(2, 1032734776, 1052273107, -1090492445, 1039999326) + W(3, 1046931016, 1050677101, -1077775563, 1047866250)
		+ W(4, 1032966898, 1056472798, -1095500286, 1031139121) + W(5, 1026703569, 1054012759, -1141821439, -1128248842)
		+ W(6, 1023567673, 1046736000, -1103091876, 1037611037)
		+ W(7, 1020804657, 1054561791, -1096856494, -1102316761);
	sum2 = W(0, -1119432539, -1113150368, 1049552369, -1123950204)
		 + W(1, -1114702364, -1107904829, -1109676099, 1034167140)
		 + W(2, -1131454616, 1051795717, 1049548364, 1018171432) + W(3, 1045807900, 1065572002, 1052256292, 1024318084)
		 + W(4, -1107556037, -1104213250, 1058452060, -1104886632)
		 + W(5, -1138592655, -1096394963, -1077576443, -1103410805)
		 + W(6, -1120197723, 991774812, -1102019177, -1103678409)
		 + W(7, -1116354551, 991245404, 1049782966, -1123412946);
	WS(-1092399743, 1070790531);
	sum1 =
		W(0, 1031557241, -1110110152, -1086332927, 1040307665) + W(1, 1024013147, -1123928476, -1104003948, 1029330819)
		+ W(2, 1045977841, -1100428029, -1091187884, 1054647477)
		+ W(3, 1049827334, -1093314535, -1110202001, 1048337215) + W(4, 1044712430, -1098211617, 1031718940, 1045074033)
		+ W(5, 1042539942, -1120318828, 1031171411, 1042256462) + W(6, 1022243624, -1110797385, -1118825252, 1034920639)
		+ W(7, 1042631871, -1103475236, 1047659449, 1041342974);
	sum2 = W(0, 1035080118, 1049091174, 1068767241, 1056655092) + W(1, -1111978522, 1049791001, 1068692590, -1120502660)
		 + W(2, 1043189101, 1038894820, 1041587068, 1054889999)
		 + W(3, -1107203795, -1088677682, -1079138335, -1094007639)
		 + W(4, 1020874649, -1074681252, -1088844169, -1106617291)
		 + W(5, 1040978901, 1032440616, 1033618204, 1037089622)
		 + W(6, -1103963851, -1139760881, 1036797334, -1115116202)
		 + W(7, 1014904337, -1132242473, 1040720920, 1029103732);
	WS(-1076899872, -1090262268);
	sum1 = W(0, -1111775583, -1105212520, 1053805936, -1130865048)
		 + W(1, -1105515965, -1109220950, 1044900104, -1124779047)
		 + W(2, 1031134981, -1105276619, 1061229259, -1108606366)
		 + W(3, -1152866339, -1081197371, 1056451270, 1012899053)
		 + W(4, 1022185487, -1085735312, 1061180827, -1111684786)
		 + W(5, 1031461535, -1090100176, 1061600458, 1038272628) + W(6, 991487050, -1106571081, 1040836429, -1123743158)
		 + W(7, 1013082739, -1094472404, -1114201801, 1043636133);
	sum2 = W(0, -1092758077, 1054372816, 1025999909, 1025560437) + W(1, -1099940688, 1036990346, 1044094629, 1015649794)
		 + W(2, -1096959860, -1102824961, -1093700170, -1134776466)
		 + W(3, -1093749782, 1072234824, 1074465248, -1118772240)
		 + W(4, 1047974360, -1091574668, -1086059593, -1097328702)
		 + W(5, -1120633714, -1098403340, -1083936129, 1035273338)
		 + W(6, 1036248767, -1097220109, 1045585843, -1098634116)
		 + W(7, -1113388587, 1024848209, -1093741871, 1051989609);
	WS(-1097318719, -1106686758);
	sum1 =
		W(0, -1138034233, 1031803579, -1107190316, -1118470609) + W(1, 1022220430, -1105675680, -1110575515, 1013564641)
		+ W(2, -1115259277, 1060345356, -1091489993, 1028754310) + W(3, 1037878284, 1040095311, -1082557626, 1043380040)
		+ W(4, -1109043646, 1057210483, 1054616755, -1126688788)
		+ W(5, -1118564628, 1018511203, -1113047197, -1103180903)
		+ W(6, -1132126739, 1038086620, 1037558661, -1105313401)
		+ W(7, -1123355602, 1040876381, 1040895458, -1110366427);
	sum2 =
		W(0, -1116780480, 1011610145, -1126532250, 1031867194) + W(1, 1034654933, -1109786563, 1049246354, -1117436106)
		+ W(2, 1033980194, 1034290987, -1098441369, 1050453777) + W(3, -1106740681, 1058839838, 1055488745, -1098876833)
		+ W(4, 1037910476, -1112504437, -1081564854, -1101879397)
		+ W(5, -1110588743, 1048688059, -1109313096, -1105182695)
		+ W(6, 1033369701, -1100404580, 1046210019, 1033744368) + W(7, 1006481529, 1024874106, -1122526519, 1042001428);
	WS(1061957727, 1058150789);
	sum1 =
		W(0, 1009728708, -1099288198, 1046412713, 1036440691) + W(1, 1031914819, -1097230757, 1055587995, -1109853493)
		+ W(2, 1043097483, -1087266183, 1056802398, -1106212891) + W(3, -1106863550, 1043273168, 1049133325, 1023154886)
		+ W(4, -1097372952, 1055416522, -1086687979, 1047286155)
		+ W(5, -1108191069, 1050026271, -1105368103, 1036106272)
		+ W(6, 1032793786, -1110590381, -1107437206, 1024106902)
		+ W(7, -1129266281, -1108247452, 1042988739, -1120124353);
	sum2 = W(0, 1021676194, 1026925373, -1130821928, 1011207236)
		 + W(1, -1104415808, 1041631623, 1047340087, -1118374396) + W(2, 1041444786, 1049347642, 1055108729, 1032289888)
		 + W(3, -1104915444, -1075706495, -1078646873, -1097824639)
		 + W(4, 1042839409, 1068941883, 1058328878, 1041964936) + W(5, 1025561656, 1049874161, 1054741696, -1122940124)
		 + W(6, -1111488206, -1096918949, -1108156193, 1033049167)
		 + W(7, -1119893126, 1030080935, -1107876167, -1131526532);
	WS(1058678303, 1013994144);
	sum1 =
		W(0, -1118673511, 1050426208, -1111022430, -1110204509) + W(1, -1145988558, 1032382213, 1019043839, -1116037137)
		+ W(2, -1107600786, 1059103555, -1086017695, 1043824660)
		+ W(3, -1097799452, 1061451838, -1090188381, -1111434373)
		+ W(4, 1050901309, -1098106458, 1050664020, -1123560275) + W(5, 1025019066, 1032049821, -1093177128, 1043538778)
		+ W(6, 1034380585, 1038038624, -1133222475, -1104489131)
		+ W(7, -1117490811, 1043957152, -1113568728, -1110765932);
	sum2 =
		W(0, -1105859137, 1052524883, -1116369180, 1025172812) + W(1, 1047608842, -1096529292, 1033298597, 1035180205)
		+ W(2, -1101390223, -1103682938, -1095014501, -1138831970)
		+ W(3, 1011548907, 1018027622, 1063707518, -1096368530) + W(4, -1098146078, 1039330573, 1056731707, -1094263126)
		+ W(5, 1047719826, -1101134187, -1086128756, 1061932077)
		+ W(6, -1099968186, 1054816538, 1037701277, -1095466983)
		+ W(7, 1028887915, -1105962981, -1150004284, 1016476277);
	WS(1063038079, 1033861047);
	sum1 =
		W(0, -1111914898, 1016779545, -1107257338, -1114919788) + W(1, 1040884807, 1014390112, 1045397811, -1162045399)
		+ W(2, -1102681756, -1109833994, -1096677860, -1101855164)
		+ W(3, 1061986003, -1095449911, 1065846455, 1049909751)
		+ W(4, -1095429920, -1097838100, 1029008656, -1097193708)
		+ W(5, -1109559865, 1019923216, 1039008680, -1113534130) + W(6, 1034752240, -1148961393, 1033037520, 1007645095)
		+ W(7, -1104233906, 1009274926, 1029851870, -1103320918);
	sum2 = W(0, -1112457849, -1117177515, 1031942991, -1106095669)
		 + W(1, -1106002020, 1017665294, 1033022206, 1041685053)
		 + W(2, -1103752624, -1098231154, -1133545004, -1095196752)
		 + W(3, -1114732591, 1062239338, 1061426536, 1046863079)
		 + W(4, -1102536580, -1097906884, -1109528685, -1105989872)
		 + W(5, 1029961226, -1101585142, 1032626487, -1120505375)
		 + W(6, -1114728817, 1037597321, -1114069131, 1028074076)
		 + W(7, 1038070251, -1112453861, 1032988844, -1124888510);
	WS(1060691839, -1121680521);
	sum1 = W(0, -1112633460, -1105323108, 1045243383, -1113361469)
		 + W(1, 1034282296, -1097943963, -1117038833, -1109479713)
		 + W(2, 1016470792, -1091137362, 1060606770, -1110311799)
		 + W(3, -1124091490, -1083253895, 1065759511, -1102522287)
		 + W(4, 1036530779, -1090987401, 1062311590, -1114082482)
		 + W(5, -1110508885, -1090137469, 1056765570, -1104777690)
		 + W(6, 1036991882, -1098291034, 1054157412, 1016563642)
		 + W(7, -1133939630, -1093525810, 1057599172, -1167556095);
	sum2 =
		W(0, -1097189010, 1057901747, -1086723052, -1086497310) + W(1, 1041454563, 1039698409, -1087530727, -1090377488)
		+ W(2, -1110771302, -1122301550, -1094374456, -1110538585)
		+ W(3, 1043926258, -1125642190, 1064818137, 1061014784) + W(4, -1109373654, -1108285138, 1036021291, 1034378960)
		+ W(5, -1109768355, 1020817735, -1109979249, 1044647130) + W(6, -1114304258, 1040279727, 1055924705, 1013465199)
		+ W(7, 1043669875, -1101494695, 1040712355, 1050381101);
	WS(-1087684831, -1094525449);
	sum1 = W(0, 1038107891, -1093934649, 1052573184, 1038198313)
		 + W(1, -1121734275, -1096975274, 1049163549, -1113930844)
		 + W(2, 1035814365, -1093954738, 1040479417, 1035537105)
		 + W(3, -1107604308, -1090018791, 1066601083, -1102439448)
		 + W(4, 1038052214, -1088075930, 1058232216, -1113118893)
		 + W(5, -1101928869, -1090123804, 1057618495, -1148589172)
		 + W(6, -1104767443, -1106254226, 1040796439, -1146582942)
		 + W(7, -1127021124, -1100235009, 1051666987, 1033628463);
	sum2 =
		W(0, -1102391770, 1038892506, -1109920182, 1034045130) + W(1, 1032495868, 1032348345, 1035913564, -1111661823)
		+ W(2, -1140349122, 1055934176, 1043439866, -1148365864) + W(3, 1051494072, 1066287204, 1049172795, 1035742233)
		+ W(4, -1080481573, 1070533091, 1048700512, 1024670194) + W(5, -1072283498, 1056179234, -1122911277, 1043482108)
		+ W(6, -1085993190, -1098172645, 1042548330, -1117726050)
		+ W(7, -1091499210, 1038613315, -1103404378, 1024343165);
	WS(-1095407551, -1073547033);
	sum1 = W(0, -1103915126, 1043640456, -1106314263, -1099126911)
		 + W(1, -1101976843, 1041775803, -1098551608, 1023142916)
		 + W(2, 1024335748, 1061599658, -1096990689, -1110220795)
		 + W(3, -1108044768, 1057524528, -1095708126, -1106562202)
		 + W(4, 1050893513, 1060862745, -1102020840, 1056016670)
		 + W(5, -1095324014, 1028413803, -1092797676, -1099653918)
		 + W(6, -1107189281, 1044362232, -1110398586, 1031215069)
		 + W(7, -1114975198, 1051352312, -1097969466, -1138223071);
	sum2 = W(0, -1112168075, 1034632723, 1034960798, -1112860057)
		 + W(1, -1111493200, -1122920764, 1040740621, -1108202591)
		 + W(2, -1123529566, 1009053647, -1105159128, -1115675116)
		 + W(3, 1022286331, 1049936313, 1057592446, -1112708946)
		 + W(4, -1103466952, 1051909492, -1126339526, -1146770753)
		 + W(5, 1035493883, -1099948229, 1041517424, -1116950762)
		 + W(6, -1113566520, 1029419308, 1016655048, -1115594520)
		 + W(7, -1106265315, -1107051081, 1024151142, -1103163741);
	WS(1063407871, 1051042354);
	sum1 = W(0, 1005154604, 1049807310, -1113122997, -1107282310)
		 + W(1, -1120529264, 1052429035, -1100831547, 1042685852)
		 + W(2, -1106161584, 1057743574, -1088929544, -1113923042)
		 + W(3, -1130858780, 1063894449, -1086654500, -1129272494)
		 + W(4, -1114354154, 1058090310, -1089886688, -1164896285)
		 + W(5, -1127255711, 1052514789, -1092092086, -1131567786)
		 + W(6, 1023693521, 1044231916, -1106897472, -1131959253)
		 + W(7, -1115504868, 1049931918, -1097639884, -1115987013);
	sum2 = W(0, -1113031572, 1043434467, -1088941888, -1067187434)
		 + W(1, 1030565628, -1108784254, 1056568736, -1079041185)
		 + W(2, -1127702936, -1111949688, 1036016830, 1074040966) + W(3, 992883874, 1036810375, 1060861120, 1075709893)
		 + W(4, 1014952720, -1111107284, 1023742716, -1099161149) + W(5, 990495554, 1042918247, -1098281783, 992814626)
		 + W(6, 1018238740, -1120169364, 1022041004, 1039733673)
		 + W(7, 1023316920, -1112993936, -1112517088, 1028892682);
	WS(1053166591, -1107822593);
	sum1 = W(0, 1033874440, -1120335240, -1105709561, 1042509273)
		 + W(1, 1022746982, 1031831786, -1108379508, 1008295657) + W(2, 1035703758, 1052124034, -1093762507, 1044631286)
		 + W(3, 1019810386, 1048792350, 1046826502, -1124953572)
		 + W(4, 1044260196, -1095582904, 1053612659, -1112928126)
		 + W(5, 1042374543, -1088629918, 1045805451, -1113071488)
		 + W(6, 1040749291, -1097950065, 1037463342, -1120529605)
		 + W(7, 1041374685, -1085974448, 1042845918, -1132054272);
	sum2 = W(0, 1010990056, -1096561981, 1040308359, -1119485380)
		 + W(1, 1039106059, -1097601992, 1052717590, -1115258493)
		 + W(2, -1102786881, 1031463124, 1058176412, -1101721469)
		 + W(3, -1114641521, 1058004743, 1045709336, -1138490792)
		 + W(4, -1133768253, 1042505523, 1034355291, -1101570252)
		 + W(5, -1101476912, 1041182740, -1096768246, 1029590734)
		 + W(6, -1103607882, -1105959219, 1033275384, 1037679123)
		 + W(7, -1113060394, -1099775079, -1105804625, 1036565969);
	WS(1028916214, 1067075549);
	sum1 =
		W(0, 1039584518, -1148995491, -1098323934, 1026160863) + W(1, -1119264713, -1109885152, -1096386895, 1022848653)
		+ W(2, 1016298993, 1055889168, -1096985498, -1150434165)
		+ W(3, -1105861885, 1067421167, -1085982162, 1034469007)
		+ W(4, -1113980813, 1059632007, -1087532161, 1044152506) + W(5, 1020015061, 1055091716, -1088331431, 1024761132)
		+ W(6, -1134777055, 1045130509, -1095878225, 1032543553)
		+ W(7, 1032661512, 1052375930, -1104015130, -1104676378);
	sum2 = W(0, -1120016029, -1101422768, -1104653664, -1122344899)
		 + W(1, -1096222017, -1103630239, -1105545071, 1042131820)
		 + W(2, -1119382227, 1040689805, -1120927281, -1120071349)
		 + W(3, -1092715875, 1064582511, 1058022283, -1101606830)
		 + W(4, -1110818689, 1043406218, 1060808344, -1096987934)
		 + W(5, 1049876716, -1089499537, -1107109410, 1051590178)
		 + W(6, -1103484103, 1029271710, -1107008053, -1099435532)
		 + W(7, 1032841990, -1117522613, -1105419897, 1050342947);
	WS(1047020030, 1040511430);
	sum1 =
		W(0, -1108637223, -1092384755, 1057603229, 1031927268) + W(1, 1033110649, -1090443530, 1053549631, -1122999800)
		+ W(2, 1044090139, -1085982557, 1061618217, 1026366340) + W(3, 1043424750, -1080046633, 1047924234, 1032840448)
		+ W(4, 1036624046, -1083957593, 1053999549, 1015929108) + W(5, -1120308481, -1096279270, 1057048888, 1020572028)
		+ W(6, 1033721201, -1149642107, 1057845673, 994286645) + W(7, -1106849700, -1100324533, 1052833857, 1039624063);
	sum2 = W(0, 1035208568, -1124082321, -1093736918, 1048736861)
		 + W(1, 1043030610, 1008382386, 1050323039, -1118377912)
		 + W(2, -1107699159, -1107061123, -1114950423, -1106119918)
		 + W(3, 1044796248, 1049576136, 1074526989, -1111443567) + W(4, 1034655700, 1051573865, 1073198167, -1132389881)
		 + W(5, -1103668262, 1048541752, -1080621030, 1034733436)
		 + W(6, 1045164876, -1093669891, -1074078238, 1034120076)
		 + W(7, -1095424772, -1134934914, -1079139349, 1029501600);
	WS(-1080108544, 1072234904);
	sum1 =
		W(0, -1115070415, 1027588151, 1031137458, 1018404227) + W(1, -1130610603, 1029085890, -1104252646, 1044293186)
		+ W(2, -1098588213, 1032775046, 1056995037, 1028038521) + W(3, 1057466749, -1089931562, -1083673968, 1050777268)
		+ W(4, -1104374087, -1123371019, 1052314097, -1093125043)
		+ W(5, 1029557602, -1094030554, 1050628415, 1046325824) + W(6, 1018553236, 1034779836, 1033643941, -1108340394)
		+ W(7, 1001112594, 999211181, 1036988180, 1020739741);
	sum2 = W(0, -1115557063, 1043108929, -1138826120, -1108049897)
		 + W(1, -1118678156, 1033401680, -1093193803, -1109597407)
		 + W(2, 1045099863, 1036186051, -1079584214, 1013268663)
		 + W(3, -1102856438, -1124450766, 1068262877, 1049634970)
		 + W(4, 1035209289, -1112637977, -1121148137, 1046161245)
		 + W(5, 1035167397, -1114646959, 1041792105, -1111895568)
		 + W(6, -1117208818, 1012643139, -1138286224, -1127251156)
		 + W(7, -1120387027, -1132473655, 1032348301, -1116707942);
	WS(1061770399, 1033097145);
	sum1 = W(0, -1127803310, -1100493560, 1049484359, -1117956049)
		 + W(1, -1108446526, -1122290538, 1040952192, -1101349332)
		 + W(2, 1046619869, -1090144134, 1049567736, 1015706547)
		 + W(3, -1102069216, -1124504076, 1060283011, 1051006353)
		 + W(4, -1115166002, -1096124978, 1036170309, 1027971186)
		 + W(5, -1107462472, -1113245389, 1049188012, -1105896346)
		 + W(6, -1113123881, -1115437168, 1004781969, 1011773295)
		 + W(7, -1109525661, -1114380655, 1043620172, -1118021614);
	sum2 = W(0, -1115090363, 1035607607, 1036976780, -1102631851)
		 + W(1, -1146121477, 1032878473, 1008730983, -1105868946)
		 + W(2, 1029869322, 1020296178, 1050702114, -1106613659) + W(3, 1039239074, -1094567498, 1060438996, 1056742871)
		 + W(4, -1123366919, -1133024223, -1092544833, 1056526109)
		 + W(5, -1123569769, -1111505684, -1088372125, -1103439045)
		 + W(6, -1115297931, 1036037468, -1119747923, -1114092237)
		 + W(7, 1022224092, 1025152664, 1015952550, -1109382916);
	WS(1063262431, 1041246684);
	sum1 =
		W(0, -1095604910, -1094141452, 1054301899, 1050361575) + W(1, 1035931377, -1103734011, 1050116188, 1015464930)
		+ W(2, -1116408259, -1088213584, 1059695011, -1130477940)
		+ W(3, -1113418944, -1084116356, 1063045487, 1005018697)
		+ W(4, 1035543059, -1088057339, 1060587189, -1114430457)
		+ W(5, -1109446615, -1084926720, 1062081288, -1112900435) + W(6, 1041501409, -1095142868, 1055163174, 968128030)
		+ W(7, -1111045021, -1085134126, 1061043357, 1012274924);
	sum2 = W(0, -1088652568, 1079171932, 1068650823, -1089634291)
		 + W(1, -1101936220, 1073764649, 1062997529, -1106083041)
		 + W(2, -1091191468, 1074855165, 1053027607, -1102140198)
		 + W(3, -1102444501, -1113430470, 1039600983, -1123235056)
		 + W(4, -1123800532, -1095064501, -1105207914, 1028735871)
		 + W(5, -1111069004, -1078839186, -1082346847, 1056073450)
		 + W(6, -1088813372, -1078450334, -1088354544, -1114344542)
		 + W(7, 1050243792, -1071519758, -1081653443, 1060600412);
	WS(-1071343712, -1080188504);
	sum1 = W(0, 1048814204, 1024112567, -1101821021, -1155239198)
		 + W(1, -1112944093, 992179242, -1105846854, -1115614373)
		 + W(2, 1038698214, 1035991718, -1110088095, -1117961066)
		 + W(3, -1110388460, 1065540811, -1086620536, 1022833410)
		 + W(4, -1102353903, 1062800155, -1085891530, 1037955557)
		 + W(5, -1113346827, 1057270438, -1092189183, -1130491710)
		 + W(6, -1115354285, 1047814390, -1094362793, 1026576596)
		 + W(7, -1172877482, 1055244391, -1096652125, 1021561214);
	sum2 = W(0, 1077488778, 1057844910, -1110901413, -1157420388)
		 + W(1, 1067869852, 1017329883, -1123912240, 1016773013)
		 + W(2, -1080283979, -1112258962, 1048616910, -1127671945)
		 + W(3, -1070445594, 1038200220, -1103189448, 1027002057)
		 + W(4, -1085461181, 1045877800, 1033584054, -1139116556)
		 + W(5, -1113067149, 1016515143, -1113680120, -1108492850)
		 + W(6, -1135625536, 1029029881, 1006246833, 1033508697)
		 + W(7, -1105631704, 1026840239, 1028070058, -1122607860);
	WS(-1114300667, -1123436789);
	sum1 =
		W(0, 1048745214, 1024457460, -1084727981, -1124831645) + W(1, -1106612992, 1049280824, -1099711469, -1120312678)
		+ W(2, 1040619730, 1061265254, -1091611130, 991636461) + W(3, -1101020989, 1066754197, -1090437274, -1115033343)
		+ W(4, -1120049178, 1060475010, -1087975654, 1037659252)
		+ W(5, -1129452308, 1056957204, -1087165059, 1036876438)
		+ W(6, -1112058252, 1052291799, -1095257281, 1024723233)
		+ W(7, 1040777596, 1051532558, -1091858685, -1128167880);
	sum2 =
		W(0, -1102675226, -1096018291, -1064870457, 1050758265) + W(1, 1045758589, 1033992894, -1078407710, -1091427154)
		+ W(2, -1106608364, 1053924217, 1074354229, 1044800412) + W(3, 1037856863, 1023354017, 1077566439, -1122690967)
		+ W(4, -1121700495, 1045521037, 1055978728, 1037435194)
		+ W(5, 1038509645, -1112080608, -1100523264, -1101170582) + W(6, 1041300787, 1019757091, 1032114149, 1048475585)
		+ W(7, 1013024414, -1111416466, -1096094745, 1031501486);
	WS(-1081349952, -1073531246);
	sum1 =
		W(0, -1130396178, -1092471918, 1052933181, -1120779255) + W(1, -1123247001, -1094799967, 1040552427, 1032899791)
		+ W(2, 1049234666, -1087091570, 1062313536, 1048808240) + W(3, -1123595694, -1083589055, 1056428784, 1047688662)
		+ W(4, 1044575749, -1090515766, 1060166366, 1025076592)
		+ W(5, -1118849787, -1088301188, 1052569014, -1104574961)
		+ W(6, 1027091408, -1100895532, 956727337, -1114767697) + W(7, 1015989072, -1095518837, 1057005798, 1028829344);
	sum2 =
		W(0, 1036727690, -1101780564, 1047063866, -1095151348) + W(1, 1038605852, 1036224480, 1003722492, -1101329253)
		+ W(2, 1000461252, 1043313873, 1071364196, -1071443435) + W(3, -1108807283, 1058417373, 1075919102, -1072909475)
		+ W(4, -1118764382, -1110550387, 1031984760, -1137970650)
		+ W(5, 1040753555, 1041024731, 1052825370, -1094681513) + W(6, 1025474323, 1032765623, -1104266299, -1130737363)
		+ W(7, 1026410269, -1114514162, 1049040777, -1100563228);
	WS(-1087415039, 1075227720);
	sum1 = W(0, 1014202565, 1030200505, 1042588557, 1032642210) + W(1, -1121306305, -1093044977, 1045750086, 1039690838)
		 + W(2, -1115466670, 1052765481, -1099185023, -1099716881)
		 + W(3, 1055732347, -1086016434, -1102841730, 1054066516)
		 + W(4, -1088701572, -1108244135, 1060432915, -1089156724)
		 + W(5, 1045428619, 1044242725, 1001272287, 1045967960) + W(6, -1106855619, -1102530383, 1047811955, 994787170)
		 + W(7, -1113272762, 1042147022, 1043051755, -1114980876);
	sum2 = W(0, 1034817173, 1033088277, -1105460751, -1119967238)
		 + W(1, -1106843150, -1115275500, 1042281307, -1122100142)
		 + W(2, 1035283571, -1108330169, -1117933953, -1118763227)
		 + W(3, -1117324330, 1059951304, 1055263105, 1033190213)
		 + W(4, -1106783723, -1114610359, 1036736577, -1099584511)
		 + W(5, 1033652183, -1130129964, 1034893511, -1097591398)
		 + W(6, -1105003316, -1100855920, 1040893249, 1043864443)
		 + W(7, -1109219720, 1017452836, 1026860110, -1097701018);
	WS(1061885343, -1093433134);
	sum1 = W(0, -1119074171, -1116612499, 1043937396, 1026065358)
		 + W(1, 1040591342, -1106037336, 1035985530, 1035233146) + W(2, 1024365415, -1090085717, 1054530437, 1023445318)
		 + W(3, -1112185530, -1110885309, -1105284753, 1041032751)
		 + W(4, -1102861510, 1058148680, -1085809524, 1043298226)
		 + W(5, 1047951017, -1098920364, 1042740717, 1028431483)
		 + W(6, 1033079635, -1104145445, -1143903027, 1030877520)
		 + W(7, 1030794670, -1102965524, 1048819605, -1110782149);
	sum2 = W(0, -1120425303, -1115506247, -1089905659, -1106986872)
		 + W(1, 1041777983, -1109249837, -1082926483, -1093100415)
		 + W(2, 1008642595, 1051302633, 976609774, -1100742938) + W(3, 1038578170, 1062460419, 1062992305, -1121360027)
		 + W(4, -1103931105, 1046700430, 1016533657, 1026171953)
		 + W(5, -1144970974, -1110379832, 1046952726, -1123505732)
		 + W(6, -1139607395, -1121481149, -1128426413, 1047068010)
		 + W(7, -1105571910, -1125592805, 1044012895, -1108759193);
	WS(1057387711, 1071476886);
	sum1 = W(0, 1029774760, -1088145158, 1058722665, 1026644842)
		 + W(1, 1046876472, -1090879061, 1046940920, -1124024690)
		 + W(2, 1049447728, -1087750555, 1062289140, 1034805113)
		 + W(3, -1104814472, -1081209882, 1060559271, -1101227374)
		 + W(4, 1047761369, -1102041597, 1057163193, 1041428045)
		 + W(5, -1107998911, -1088704948, 1046238393, -1112057972)
		 + W(6, 1035672969, -1101378696, 1049034574, -1123650077)
		 + W(7, 1025453339, -1090772220, 1051154538, 1045125730);
	sum2 =
		W(0, -1079574021, 1066168402, -1106633910, 1033041398) + W(1, -1076424748, 1072246945, 1039775524, 1025560740)
		+ W(2, -1084651933, 1055648588, -1122282375, 1042767844)
		+ W(3, -1079383446, 1069722149, 1050613020, -1122422479)
		+ W(4, -1094010079, -1105729737, -1112550614, 1029478726)
		+ W(5, -1105513599, 1052366950, 1046757765, 1029747528) + W(6, -1094989946, 1046266897, 1041413657, -1132333344)
		+ W(7, -1083946107, 1064021500, -1117589808, -1110924549);
	WS(-1088291167, -1076464582);
	sum1 = W(0, 1038365083, 1048475643, -1115380053, -1113517956)
		 + W(1, 1013092187, 1039614653, -1115741870, -1118168192)
		 + W(2, 1049005176, -1105893787, -1115211424, 1038779144)
		 + W(3, -1096083994, -1090164821, -1106465144, -1103584918)
		 + W(4, 1046666973, 1048630844, -1092124773, 1051487172) + W(5, 1029385568, 1052597003, -1097273638, 1036949051)
		 + W(6, -1130846211, 1030762351, -1104199584, 1029432699)
		 + W(7, 1035921309, 1049653618, -1098780292, 1041505439);
	sum2 = W(0, -1102442432, -1119046775, 1038119755, -1116688635)
		 + W(1, 1042447103, -1103497340, -1117033259, -1109692823)
		 + W(2, 1009200726, -1108371687, -1111757198, -1136365839)
		 + W(3, -1140140535, 1063726871, 1053430514, -1103585210)
		 + W(4, 1018235219, 1023996549, -1097582390, 1035998106)
		 + W(5, 1038566242, -1100556235, -1130738637, -1122627505)
		 + W(6, -1105836948, -1134905751, 1027482933, -1113769016)
		 + W(7, -1119461411, -1115426548, 1038939472, -1131103707);
	WS(1063535295, -1106643391);
	sum1 = W(0, 998897947, 1049160779, -1095715331, 1022592892) + W(1, -1114069468, 1050551697, -1114097198, 1035333911)
		 + W(2, 1030590255, 1037435628, -1091439068, -1105875754)
		 + W(3, -1120649212, 1059662980, -1098500149, 1036951763)
		 + W(4, -1112623985, 1051258674, -1093374928, -1097348874)
		 + W(5, -1135800742, 1051146291, -1112852607, 1021555078)
		 + W(6, -1126057998, 1042046535, -1104302276, 1032877804)
		 + W(7, -1118923687, 1051522915, -1098602138, -1118947123);
	sum2 =
		W(0, 1020791040, 1023004440, -1131522740, -1130592194) + W(1, -1119848331, 1035188360, 1010552055, -1114014595)
		+ W(2, 1028098574, 1036866165, -1087402238, 1057774258) + W(3, 1024075228, -1081188844, -1063807577, 1085749988)
		+ W(4, 1036335573, 1036267331, -1074297638, 1072260443) + W(5, -1114214294, 1020492762, 1044255896, -1101071935)
		+ W(6, 1028067710, 1026996488, -1109527927, 1041502854)
		+ W(7, -1123998545, 1028180222, -1125487816, -1121770211);
	WS(1065370528, -1140007425);
	sum1 = W(0, -1119191691, -1089109360, 1051697742, 1048704645)
		 + W(1, -1123119348, -1093467562, 1051845168, -1120571445)
		 + W(2, 1043193134, -1104035088, 1049231373, 1047054964)
		 + W(3, -1144777506, -1082641845, 1058881533, -1128753754)
		 + W(4, 1048874737, -1090665335, 1060727795, -1122636375)
		 + W(5, -1114692372, -1085597050, 1053776045, -1135014444)
		 + W(6, 1047204584, -1097312497, 1050811579, 962936920) + W(7, 1028382351, -1084438004, 1054559607, 1047044271);
	sum2 = W(0, 1072219394, -1078126224, -1093298188, 1011861728)
		 + W(1, 1068804680, -1079031251, -1110022070, 1040923692)
		 + W(2, 1068134846, -1078951161, -1084926454, -1105857084)
		 + W(3, 1066171639, -1087436811, -1107767815, -1121892273)
		 + W(4, -1095987744, 1039512383, 1055586357, 1026590003) + W(5, -1080918851, 1067164113, 1031793821, 1040751494)
		 + W(6, -1077110574, 1069504242, 1041030661, -1123439499)
		 + W(7, -1071545857, 1075315134, 1055897321, -1109554506);
	WS(-1089696543, -1143233957);
	sum1 =
		W(0, -1115482013, -1129127938, 1041381507, -1122467892) + W(1, 1045323653, -1098483714, -1110243009, 1049605572)
		+ W(2, -1096516931, 1045383939, 1059582003, -1090424421)
		+ W(3, 1035013745, -1091150045, -1106321908, 1043667267)
		+ W(4, -1162367211, 1043411549, 1034020454, -1109629626) + W(5, 1054106403, -1086835476, 1026676964, 1048548650)
		+ W(6, -1107204469, 1048447553, 1034191370, -1105600748)
		+ W(7, 1036179510, -1103773800, -1159158363, 1035568493);
	sum2 = W(0, -1134008573, 1032064725, -1117795542, -1113496357)
		 + W(1, -1125596513, -1121806942, 1035355315, 998755498) + W(2, 1011008945, 1045441656, 1024667789, -1119910472)
		 + W(3, 1051842604, 1065460002, -1089961367, 1041632626)
		 + W(4, -1125276577, -1114964420, -1081892598, 1035390555)
		 + W(5, -1118729604, -1130705389, 1026896379, 1032979221)
		 + W(6, -1111959837, -1121883022, 1020053498, -1129745921)
		 + W(7, -1117720498, 1034360078, 1023648883, -1115672512);
	WS(1065278079, -1120402802);
	sum1 =
		W(0, 1031924074, 1052390115, -1097070063, -1116671142) + W(1, -1115548942, 1049303261, -1099757447, -1118597165)
		+ W(2, -1106896516, 1045251552, 1040981136, 1041336272) + W(3, -1112658654, 1060948388, -1081623390, 1043338841)
		+ W(4, -1103991244, 1062622505, -1085365853, -1145407604)
		+ W(5, -1121670257, 1054395391, -1096062708, 1032773481)
		+ W(6, -1115583119, 1045812503, -1101077740, -1123616408)
		+ W(7, 1031270934, 1048618059, -1099232531, -1127437558);
	sum2 =
		W(0, -1114021356, -1110767736, -1100377718, 1034493514) + W(1, 1032565152, -1122384971, 1041858293, 1019779384)
		+ W(2, 1056835748, -1085457975, -1085697040, 1016590225)
		+ W(3, -1085160508, 1068814369, 1060746614, -1097525969) + W(4, 1058685385, -1085213012, 1057245366, 1043875459)
		+ W(5, -1086618535, 1063574785, -1094120608, -1097974912)
		+ W(6, 1047242231, -1144776155, -1093482365, 1054776673)
		+ W(7, 1032715041, -1097434793, 1056356490, -1096653037);
	WS(1055688959, -1109584743);

	return clamp(mstd0 + 5.0 * vsum / wsum * mstd1, 0.0, 1.0);
}

shared float inp[429];

#define CURRENT_PASS 1

#define GET_SAMPLE(x) dot(x.rgb, rgb2y)
#define imageStore(out_image, pos, val) imageStoreOverride(pos, val.x)
void imageStoreOverride(uint2 pos, float value) { temp[pos] = (value); }

#define INPUT_tex(pos) GET_SAMPLE(vec4(texture(INPUT, pos)))
static const float2 INPUT_size = float2(GetInputSize());
static const float2 INPUT_pt = float2(GetInputPt());

#define HOOKED_tex(pos) INPUT_tex(pos)
#define HOOKED_size INPUT_size
#define HOOKED_pt INPUT_pt

void Pass1(uint2 blockStart, uint3 threadId) {
	ivec2 group_base = ivec2(gl_WorkGroupID) * ivec2(gl_WorkGroupSize);
	int local_pos = int(gl_LocalInvocationID.x) * 11 + int(gl_LocalInvocationID.y);
	for (int id = int(gl_LocalInvocationIndex); id < 429; id += int(gl_WorkGroupSize.x * gl_WorkGroupSize.y)) {
		uint x = (uint)id / 11, y = (uint)id % 11;
		inp[id] =
			HOOKED_tex(HOOKED_pt * vec2(float(group_base.x + x - (3)) + 0.5, float(group_base.y + y - (1)) + 0.5)).x;
	}
	barrier();
	vec4 ret = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 ret0 = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 samples[8];
	samples[0][0] = inp[local_pos + 0];
	samples[0][1] = inp[local_pos + 1];
	samples[0][2] = inp[local_pos + 2];
	samples[0][3] = inp[local_pos + 3];
	samples[1][0] = inp[local_pos + 11];
	samples[1][1] = inp[local_pos + 12];
	samples[1][2] = inp[local_pos + 13];
	samples[1][3] = inp[local_pos + 14];
	samples[2][0] = inp[local_pos + 22];
	samples[2][1] = inp[local_pos + 23];
	samples[2][2] = inp[local_pos + 24];
	samples[2][3] = inp[local_pos + 25];
	samples[3][0] = inp[local_pos + 33];
	samples[3][1] = inp[local_pos + 34];
	samples[3][2] = inp[local_pos + 35];
	samples[3][3] = inp[local_pos + 36];
	samples[4][0] = inp[local_pos + 44];
	samples[4][1] = inp[local_pos + 45];
	samples[4][2] = inp[local_pos + 46];
	samples[4][3] = inp[local_pos + 47];
	samples[5][0] = inp[local_pos + 55];
	samples[5][1] = inp[local_pos + 56];
	samples[5][2] = inp[local_pos + 57];
	samples[5][3] = inp[local_pos + 58];
	samples[6][0] = inp[local_pos + 66];
	samples[6][1] = inp[local_pos + 67];
	samples[6][2] = inp[local_pos + 68];
	samples[6][3] = inp[local_pos + 69];
	samples[7][0] = inp[local_pos + 77];
	samples[7][1] = inp[local_pos + 78];
	samples[7][2] = inp[local_pos + 79];
	samples[7][3] = inp[local_pos + 80];
	ret[0] = nnedi3(samples);
	ret0[0] = inp[local_pos + 34];
#if CURRENT_PASS == LAST_PASS
	uint2 destPos = blockStart + threadId.xy * ivec2(1, 2);
	uint2 outputSize = GetOutputSize();
	if (destPos.x >= outputSize.x || destPos.y >= outputSize.y) {
		return;
	}
#endif
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(1, 2), ret0);
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(1, 2) + ivec2(0, 1), ret);
}
//!PASS 2
//!DESC NNEDI3 (double_x, nns256, win8x4)
//!IN INPUT, temp
//!OUT OUTPUT
//!BLOCK_SIZE 64, 8
//!NUM_THREADS 32, 8
#pragma optionNV(inline none)
float nnedi3(vec4 samples[8]) {
	float sum = 0.0, sumsq = 0.0;
	[unroll] for (int i = 0; i < 8; i++) {
		sum += dot(samples[i], vec4(1.0, 1.0, 1.0, 1.0));
		sumsq += dot(samples[i], samples[i]);
	}
	float mstd0 = sum / 32.0;
	float mstd1 = sumsq / 32.0 - mstd0 * mstd0;
	float mstd2 = mix(0.0, inversesqrt(mstd1), mstd1 >= 1.192092896e-7);
	mstd1 *= mstd2;
	float vsum = 0.0, wsum = 0.0, sum1, sum2;
#define T(x) intBitsToFloat(x)
#define W(i, w0, w1, w2, w3) dot(samples[i], vec4(T(w0), T(w1), T(w2), T(w3)))
#define WS(w0, w1)                                                                                                     \
	sum1 = exp(sum1 * mstd2 + T(w0));                                                                                  \
	sum2 = sum2 * mstd2 + T(w1);                                                                                       \
	wsum += sum1;                                                                                                      \
	vsum += sum1 * (sum2 / (1.0 + abs(sum2)));
	sum1 = W(0, 1024871952, 1026430476, 1041094851, 992987016) + W(1, 1034372511, 1007997243, 1038248733, 1009484684)
		 + W(2, -1091961907, -1103990249, -1086639391, -1085365048)
		 + W(3, -1087585419, -1093414958, -1100793414, -1099588502)
		 + W(4, 1049937838, 1052012307, 1057524239, 1063527595) + W(5, 1061081007, 1057188600, -1104832955, -1114088341)
		 + W(6, 1023328805, 994719130, -1110763811, -1102193240)
		 + W(7, 1046466539, -1131716095, 1042167685, 1037858632);
	sum2 = W(0, -1122170202, -1117362461, -1125932452, -1100385246)
		 + W(1, 1020071642, 1025043913, 1017078274, 1018043750) + W(2, -1115075619, 1050294809, 1041506545, -1100233118)
		 + W(3, -1100362988, 1047005177, 1012082941, -1112302377)
		 + W(4, -1113824159, 1022334174, -1098709995, -1104291570)
		 + W(5, 1072797337, 1053652830, -1100425628, -1155649364) + W(6, 1016746290, 1016781702, 1031697879, 1033455014)
		 + W(7, 1050444141, -1106922881, -1081909907, -1086585813);
	WS(-1096195455, 1061976972);
	sum1 = W(0, -1107583849, 1045016510, -1102048399, 1050507709)
		 + W(1, -1138600128, 1004076226, 1049677870, -1106918697)
		 + W(2, -1094469481, -1104061589, -1082981042, -1086991635)
		 + W(3, -1087760032, -1088999402, -1111975782, -1089081125)
		 + W(4, 1057261454, 1051975353, 1058403546, 1061386858) + W(5, 1052980216, 1052828202, 1055128500, 1048525839)
		 + W(6, 1032308806, 1046697387, -1093320254, 1051876218)
		 + W(7, -1106246183, -1112945129, 1045880594, -1116677906);
	sum2 = W(0, 976892690, 1043646796, -1131052969, 1047930742)
		 + W(1, -1099144563, 1035354913, -1115191227, -1111106463)
		 + W(2, -1095110912, -1114450783, 1052886335, -1113296119)
		 + W(3, -1088067101, 1040578653, -1102673565, 1051335047)
		 + W(4, -1080663089, -1074060607, -1068434194, 1048011859)
		 + W(5, 1042920440, 1058047003, 1057110709, 1038060178) + W(6, 1075827337, 1075290035, 1070007941, 1046007784)
		 + W(7, -1090506241, -1099371585, -1096675048, -1096378099);
	WS(-1095930303, -1128843438);
	sum1 = W(0, -1113225514, 1030842449, -1120882464, -1111398934)
		 + W(1, -1098488134, -1098728413, -1111237296, -1104159890)
		 + W(2, 1000563038, -1103461662, -1098779087, -1156245815)
		 + W(3, 1057689814, 1058114717, 1041725787, 1046074787) + W(4, 1038763268, 1052682210, 1055587560, 1046999855)
		 + W(5, -1090605975, -1106232348, -1106563184, -1119168797)
		 + W(6, -1104281110, -1105449143, -1106219642, -1105879965)
		 + W(7, 1039743648, 1030902068, -1111582036, 1033984854);
	sum2 =
		W(0, -1109947141, -1087141194, 1007133897, -1099413759) + W(1, 1026690396, 1045509921, -1117657274, 1051942463)
		+ W(2, -1078961084, -1081851502, 1057831088, 1067440534) + W(3, -1095618356, 1022398658, 1029712906, 1049871690)
		+ W(4, 1053833634, -1102894339, 1046573470, 1058568743)
		+ W(5, 1058025266, -1115002147, -1109832065, -1099467737)
		+ W(6, 1049299145, 1040634467, 1035108031, -1114324751) + W(7, -1094447449, 1023241606, 987652806, -1104714655);
	WS(1018627052, -1077328537);
	sum1 = W(0, -1107592280, 1011043872, -1138466445, 1041422472)
		 + W(1, -1112294435, 1012707679, -1150731309, -1118891707)
		 + W(2, -1098360952, -1103889731, -1088654431, -1079526160)
		 + W(3, -1109020730, -1095389295, -1102056896, -1101414784)
		 + W(4, 1054425801, 1045838144, 1063939041, 1057394281) + W(5, 1061143403, 1057286118, 1040465365, 1042544156)
		 + W(6, -1121256842, 1016847523, -1114759963, -1109966789)
		 + W(7, -1115564074, -1117689671, -1133534770, 1028492087);
	sum2 = W(0, -1161717665, -1138679732, -1121504639, 1050854432)
		 + W(1, -1106511096, 1030373815, 980628162, 1031200951) + W(2, 1033867626, -1115218580, 1030621655, -1096361601)
		 + W(3, 1044499063, -1104067382, 1040061476, -1122098343)
		 + W(4, 1028201267, -1096378423, 1071708903, 1079482342)
		 + W(5, -1064184100, -1089118805, 1048273255, -1109436715)
		 + W(6, -1124228530, 1029766795, -1128256742, 1035298280)
		 + W(7, 1035336882, -1105361644, -1119150405, 1035049634);
	WS(1045693694, 1057374369);
	sum1 = W(0, 1048369598, -1104752283, 1031950009, -1123958928)
		 + W(1, -1103831441, -1106189273, -1103850789, -1110300085)
		 + W(2, 1034312519, 1045853799, 1057046586, 1065585622) + W(3, 1061666460, 1060939321, 1050689810, 1060417841)
		 + W(4, -1131023893, -1098373234, -1095062180, -1089164628)
		 + W(5, -1092432965, -1087345809, -1092965100, -1091010256)
		 + W(6, -1099588978, 1019902402, -1105510198, 1033283356)
		 + W(7, -1115031649, -1122647270, -1126666680, -1103574093);
	sum2 =
		W(0, -1087427905, 1058683530, -1081734921, 1050776004) + W(1, 1042479954, 1025544982, -1105492903, 1058740427)
		+ W(2, -1098709872, -1099141199, 1032637312, 1072181481)
		+ W(3, 1036599206, -1080357543, -1113642582, -1086527647)
		+ W(4, 1072153031, -1088885778, 1061509476, 1071890032) + W(5, 1052304550, -1080881103, 1050862866, -1078556244)
		+ W(6, -1089481634, 1056590706, -1092495010, 1048814690)
		+ W(7, -1095810808, -1097308566, -1094462248, 1039671439);
	WS(-1081549664, 1060153996);
	sum1 = W(0, 992286043, -1115318586, -1105782456, 1026471870)
		 + W(1, -1114468402, 1037910210, -1130210466, 1043803882) + W(2, 1063391104, 1055271797, 1062019397, 1061503832)
		 + W(3, 1058772501, 1045594046, 1049908468, 1040755007)
		 + W(4, -1087586274, -1095899708, -1085498120, -1089250259)
		 + W(5, -1090055577, -1102496824, -1103786988, -1104619012)
		 + W(6, -1105647870, 1025423024, 1033921889, -1113405924)
		 + W(7, -1113674825, -1106446561, -1118412923, -1096097592);
	sum2 = W(0, 1053790549, -1110257416, 1033688102, -1102619530)
		 + W(1, -1117483359, -1098152061, -1105743952, -1083553679)
		 + W(2, -1080860351, -1097530578, 1041061421, 1064966059) + W(3, 1050344847, 1040479494, 1051151965, 1065962098)
		 + W(4, -1068185653, -1077346152, 1052310674, 1072556372)
		 + W(5, 1075004369, 1064749402, -1110156824, 1045213317)
		 + W(6, -1082483044, -1088866791, 1052658871, -1104178634)
		 + W(7, -1108410079, 1040931499, -1137891932, 1053124980);
	WS(-1079020096, -1097079011);
	sum1 = W(0, -1109501731, 1033910555, 1015347636, -1108027795)
		 + W(1, 1042979875, 1019929124, 1040369234, -1134559750)
		 + W(2, -1096742621, -1092191510, -1089091160, -1087072713)
		 + W(3, -1087558450, -1089417126, -1104831498, -1091818621)
		 + W(4, 1057943754, 1055662529, 1059647341, 1068092504) + W(5, 1059824411, -1117499817, 1043480574, 1050143023)
		 + W(6, 1016000225, 1020967408, -1102027816, -1109882648)
		 + W(7, -1106889398, -1117366414, -1104827345, 1049289276);
	sum2 = W(0, 1037631964, -1105851814, 1036652885, -1110757790)
		 + W(1, 1024508007, -1139201564, -1113225064, -1104657620)
		 + W(2, -1097479797, 1051380185, 1028410699, 1044594400) + W(3, 1041068006, 1046036650, 1054960427, -1105334641)
		 + W(4, 1051023588, -1097950410, 1034374804, 1053237761)
		 + W(5, -1132209182, -1088293598, -1081781977, 1065714224)
		 + W(6, 1045348435, 1028003104, -1113269608, 1041832368)
		 + W(7, 1033918380, -1089693526, -1099925151, -1106359824);
	WS(-1087384991, 1052875812);
	sum1 = W(0, 1041733252, -1138647561, 1034391503, -1106477875)
		 + W(1, -1100509868, -1098694249, -1110959830, -1120730421)
		 + W(2, -1109905397, -1104994285, -1107522048, 1057597757)
		 + W(3, 1062613266, 1055828187, 1052485297, 1044647290) + W(4, 1041497057, 1032882549, 1050093354, -1091247383)
		 + W(5, -1087942224, -1090201627, -1098203032, -1100016695)
		 + W(6, -1113613058, -1117825756, -1108789794, 1028766931)
		 + W(7, 1042722079, 1013355333, 1034047139, 1038812681);
	sum2 = W(0, 1019350107, -1111428867, 1017374087, -1112005123) + W(1, 1028700445, -1112772903, 1027823157, 999439052)
		 + W(2, 1041831066, -1130655130, -1138336400, 1035402260)
		 + W(3, -1116945124, 1041636268, -1107238338, 1033528252)
		 + W(4, 1051650697, -1112274143, -1092155273, -1114034096)
		 + W(5, 1045953881, 1041190902, 1049171133, 1027833254)
		 + W(6, -1103332568, -1077765094, -1073481211, -1087514353)
		 + W(7, 1069095754, 1074086485, 1057277153, -1107727987);
	WS(1050457727, 1041689780);
	sum1 = W(0, -1131312139, -1116681402, 1030961105, -1140959985)
		 + W(1, 1046496193, 1048638526, 1007270019, 1049181764) + W(2, 992358355, 1014710691, 1040368912, -1105027369)
		 + W(3, -1089290871, -1090315138, -1098770776, -1086147588)
		 + W(4, -1092744895, 1027381214, -1089348299, 1050737138) + W(5, 1038810352, 1055368676, 1040416748, 1051301702)
		 + W(6, 1048008788, 1036450832, 1053966377, 933247243) + W(7, 1043432004, -1119062181, 1023583738, 1037141075);
	sum2 = W(0, -1107193278, 1019433289, 1039188525, -1123892633)
		 + W(1, 1039851328, 1032631611, 1044641782, -1097026795) + W(2, 1057496780, 1031729137, 1037283932, -1086728254)
		 + W(3, -1087309268, -1092570464, 1035754242, 1063903066)
		 + W(4, 1072935738, -1080020989, -1078950448, -1087453268)
		 + W(5, 1051352061, 1059438018, 1051006721, 1056300653) + W(6, -1080570956, 1054527180, -1096917141, 1050123895)
		 + W(7, 1053948249, 1042769096, 1029707984, -1106545458);
	WS(-1084263519, -1088250567);
	sum1 = W(0, -1107101246, 1049480649, -1097447514, 1049647488)
		 + W(1, -1099235545, 1018612505, -1103944776, 1032447885)
		 + W(2, 1048954180, -1096698757, 1059331526, -1119095878) + W(3, 1040553109, 1041330418, 1040723088, 1023387386)
		 + W(4, -1118116730, 1027018719, -1108150329, -1090501921)
		 + W(5, 1044929028, -1094468036, 1047463532, -1106285556)
		 + W(6, -1111017296, 1043604572, -1098833704, 1050343697)
		 + W(7, -1096264890, 1044030041, -1121471547, -1175819022);
	sum2 = W(0, 991719940, 1034086314, 1055828179, 1034571486) + W(1, 1049088345, -1098363481, -1111430799, -1111365517)
		 + W(2, -1157381748, -1121095386, -1103829652, -1100672658)
		 + W(3, -1090417467, 1050795943, -1113801830, 1037803588)
		 + W(4, -1100952734, 1027786887, -1085350121, -1118546758)
		 + W(5, 1049271738, -1140682323, 1035813474, -1164121191)
		 + W(6, 1029794653, 1016292894, 1067178121, -1098007098)
		 + W(7, 1008607005, -1110134488, -1115483467, -1133015817);
	WS(1066054400, -1125664425);
	sum1 = W(0, 1015260777, -1108545200, 1023624464, -1109354663)
		 + W(1, 1023465234, -1108921531, -1116445024, -1128865616)
		 + W(2, 1054574294, 1053284635, 1059735702, 1058150961) + W(3, 1058102002, 1063397581, 1046571067, 1046728251)
		 + W(4, -1095241461, -1094415406, -1088764634, -1078845388)
		 + W(5, -1090401103, -1105651068, -1116790272, -1104354311)
		 + W(6, -1127045294, -1111343263, 1041542629, -1130514988)
		 + W(7, 1035892576, -1136829776, 1030749305, -1106930027);
	sum2 =
		W(0, 1041565398, -1103469615, 1029690269, 1035794320) + W(1, 1035452008, -1107146771, -1124704946, 1040850628)
		+ W(2, -1104697837, 1029373537, 1057447179, 1080145714)
		+ W(3, -1103623095, -1066097425, -1097535851, -1103109309)
		+ W(4, -1115419200, 1031260861, 1026403525, 1043319440) + W(5, 1050811672, -1103531154, -1090176537, 1055196268)
		+ W(6, -1158883614, 1035036640, 1034486240, 1041655252)
		+ W(7, -1114789346, -1114794272, 1036709484, -1102936938);
	WS(-1087901375, 1071177135);
	sum1 = W(0, -1121594272, -1122618691, -1114434254, 1044010486)
		 + W(1, -1113833999, -1108159437, 997526195, -1123472883)
		 + W(2, -1110224028, -1109965218, -1120206908, 1010935165)
		 + W(3, -1108541318, 1041417229, -1109330685, 1039497451)
		 + W(4, 1030219348, 1047787782, -1114914192, -1113546820) + W(5, 1046030645, 1035224125, 1017890711, 1022061139)
		 + W(6, 994425384, 1027034090, -1106192913, 1040356168)
		 + W(7, -1112701798, -1130438655, -1151173965, -1125745551);
	sum2 = W(0, 1042217679, -1108814485, 1058334461, -1080767453)
		 + W(1, 1050991857, 1030602271, 1034906705, -1127683613)
		 + W(2, -1116367239, 1042859710, -1078638996, 1073929687)
		 + W(3, -1092080339, -1116721722, -1106162437, 1035114111)
		 + W(4, 1026421701, 1027395369, 1028343990, -1097310248) + W(5, 1042808122, 1051491707, 1024141024, -1112071525)
		 + W(6, -1140328609, -1114630403, -1105295199, 1028261520)
		 + W(7, -1122297114, -1105219597, 997359482, 1017171678);
	WS(1066545696, -1154623394);
	sum1 = W(0, -1105442505, -1115505461, -1102287846, 1023914903)
		 + W(1, 1021900696, 1016559928, -1142506442, -1129232035)
		 + W(2, -1114054203, -1098488296, -1092352928, -1089108436)
		 + W(3, -1087887754, -1096061654, -1097827287, -1095543703)
		 + W(4, 1057182265, 1049322687, 1062190966, 1059635472) + W(5, 1057132007, 1043675118, 1048482034, 1055016957)
		 + W(6, -1123432545, 1010507424, -1097309632, 1045294808)
		 + W(7, -1098559779, 1042399967, -1110816589, 1026256390);
	sum2 =
		W(0, -1094410020, -1073520568, -1076806727, 1007932024) + W(1, -1129053184, -1126774165, 1016297320, 1026440100)
		+ W(2, 1040526244, -1119660436, 1072065972, 1074284701) + W(3, 1045336233, -1114285571, 1027498382, -1109537500)
		+ W(4, 1038890507, -1105577163, 1038803075, -1096715819)
		+ W(5, 1048625414, -1106066396, 1035667090, -1128514892)
		+ W(6, -1120085021, 1014274624, -1119386280, 1032586275)
		+ W(7, -1148623280, 1033069015, -1113847206, 1028560484);
	WS(1055250687, -1106970626);
	sum1 = W(0, 1033119688, -1105149829, 1043588463, -1098690473)
		 + W(1, 1051357302, -1111820283, 1036109552, -1119401059) + W(2, 1042190962, 1055784922, 1039447718, 1060328969)
		 + W(3, -1105877415, 1050469874, -1123255849, 1044861546)
		 + W(4, -1096546392, -1103230410, -1093610964, -1094495495)
		 + W(5, -1104321127, -1102978667, 1034127854, -1097968467)
		 + W(6, -1117586055, -1125652468, 1035816565, -1103963220)
		 + W(7, 1047255951, -1108600424, -1157028943, 1018776031);
	sum2 = W(0, 1038757267, -1111076574, 1036628998, -1107631850)
		 + W(1, 1045867530, -1126199158, 1034641438, 1014361489)
		 + W(2, 1030211853, -1147844455, 1002666567, -1080902130)
		 + W(3, -1089131777, 1067727291, 1050167793, -1114432338)
		 + W(4, 1033894636, 1039985174, -1092985165, -1084645521)
		 + W(5, 1069738325, -1096580382, -1100096489, -1100261485)
		 + W(6, -1133782171, -1117005539, -1150866734, 1049641986)
		 + W(7, 1051354211, -1100550183, -1104598763, 1033251244);
	WS(1063662431, 1022143153);
	sum1 =
		W(0, -1101665898, 1044567949, -1113912242, 1054985008) + W(1, -1089448239, 1031890901, -1106608329, 1016341751)
		+ W(2, 1028101088, -1100200043, -1110575390, -1090770105) + W(3, 1042239925, 1034205190, 1041117720, 1032506575)
		+ W(4, 1045825111, -1112112432, 1011332621, 1036354680) + W(5, 1053092900, 1020582213, -1122250931, 1037368233)
		+ W(6, -1107336877, 1049135824, -1117269540, 1043762234)
		+ W(7, -1090665684, 1045380738, -1108114694, 1027635960);
	sum2 = W(0, -1109621945, 1044140338, 1011973298, 1054192939) + W(1, -1083519810, 1050669158, 1015542539, 1007706050)
		 + W(2, 995625223, -1125871763, 1059194369, -1085775903)
		 + W(3, -1085690186, 1055305067, -1115586758, 1024423563)
		 + W(4, 1033690799, -1131300267, 1019603073, -1105557074)
		 + W(5, 1066625604, -1093331249, 1025625789, -1163078190)
		 + W(6, -1127273987, 1031533647, -1100093028, 1049649037)
		 + W(7, -1099380904, 1041330252, -1109873113, 1021669909);
	WS(1065395904, 1046290614);
	sum1 = W(0, 996799560, 1015596034, -1100668872, -1100927819) + W(1, 1043886221, 1025322396, 1035443240, -1114934548)
		 + W(2, -1125542553, 1043656950, 1056396433, 1054862894)
		 + W(3, -1088911438, -1099487682, -1105531411, -1117673547)
		 + W(4, 1038203972, -1105153011, -1085640859, -1101762943)
		 + W(5, 1057024083, 1036429768, 1021072448, 1035195023) + W(6, -1122586727, 1036793959, 1049715632, 1035554923)
		 + W(7, -1115152096, -1122121748, 1039652277, 1024299964);
	sum2 =
		W(0, 1029237671, -1133651707, -1114304490, -1114162505) + W(1, -1125875827, -1112015576, 1015895733, 1035088799)
		+ W(2, 1017509749, -1140172751, 1030543605, -1092617066) + W(3, 1051105475, 1033357967, 1011455075, -1105982664)
		+ W(4, -1104176053, 1038596873, 1050264307, -1093179067)
		+ W(5, 1071302855, -1090684841, -1100815852, 1003487558) + W(6, 1032328729, 1037378915, -1104642832, 1049979232)
		+ W(7, -1110244360, -1085540383, -1135016203, 1015899853);
	WS(1058730335, 1038095077);
	sum1 = W(0, 1050009523, -1156396202, 1045232946, -1123440788) + W(1, 994853272, 1029074928, -1116532263, 1016043038)
		 + W(2, -1090412329, 1022785342, 990514519, 1051849503) + W(3, 1050259497, 1048747736, 1040337077, 1047238893)
		 + W(4, -1116071407, -1112028282, 1027669243, 1025171300)
		 + W(5, -1091444451, -1091116387, -1095024325, -1085293672)
		 + W(6, -1120619710, 1033123659, -1138222105, 1042856679)
		 + W(7, 1043400402, 1046148791, 1031722640, 1050565349);
	sum2 =
		W(0, 1046272294, -1119023958, -1106071503, -1097641458)
		+ W(1, -1099339001, -1122591395, -1120322169, -1112624405)
		+ W(2, 1056160584, 1047372879, 1066704996, 1062851774) + W(3, -1127558738, -1095719050, 1012197993, -1094334166)
		+ W(4, -1069609928, -1100807597, 1063602974, 1071319304) + W(5, -1123458905, 1049925865, 1037702687, 1046841945)
		+ W(6, -1086350256, 1012350161, -1093103672, -1165704932)
		+ W(7, -1099266547, 1039176837, -1104052164, 1043315186);
	WS(-1102208382, 1082454872);
	sum1 = W(0, -1121527792, 1019782131, -1111677734, 1042764822)
		 + W(1, -1098291428, -1109244559, -1122839755, 1023050790)
		 + W(2, -1097489215, -1109352802, -1089475261, -1094323164)
		 + W(3, 1057233791, 1055571354, 1036609181, 1023873367) + W(4, 1044710709, 1043005718, 1059136208, -1113184692)
		 + W(5, -1102862820, -1113821821, 1016630678, -1122283881)
		 + W(6, 1024559218, 1025756170, -1098383546, 1034230961)
		 + W(7, -1121795355, 1034138424, -1148370726, 1021065311);
	sum2 = W(0, 1012975921, 1033684352, -1119837718, 1048900749)
		 + W(1, -1088385914, -1106132930, -1107812043, 1047279942)
		 + W(2, -1113722375, -1113902527, 1034379158, 1065557700)
		 + W(3, 1033601684, -1078602486, 1048231286, -1117907500)
		 + W(4, -1109752074, -1108511603, 1047596894, 1065261424)
		 + W(5, -1110433219, -1113936114, -1106600777, -1110420048)
		 + W(6, 1009270385, 1034062718, -1096952633, 1042274647)
		 + W(7, -1110816087, 1038223706, 1037668398, -1111923151);
	WS(1055139903, 1066543323);
	sum1 = W(0, -1113216706, 1034160554, -1110997976, -1104052311)
		 + W(1, -1130057219, -1100344024, -1109060119, -1102181302)
		 + W(2, 1025777755, -1106690282, 1025857819, -1108040417) + W(3, 1042814916, 1058801014, 1040801319, 1061190298)
		 + W(4, 1062476912, 1047449287, 1040533578, -1088276389)
		 + W(5, 1043316038, -1096553156, 1003175286, -1109923206)
		 + W(6, -1094834883, -1115394087, -1100641176, -1109281747)
		 + W(7, -1111790927, -1131081926, -1127882001, -1116502963);
	sum2 = W(0, 1032900543, 1026043047, 1011969739, 1005946567)
		 + W(1, -1104378201, -1106573410, -1149079854, -1098913457)
		 + W(2, -1093611286, -1143136704, -1129502699, 1065137024)
		 + W(3, 1034934846, 1044311979, -1128312106, -1107526541)
		 + W(4, -1093105706, -1104881087, 1056641171, 1062580590)
		 + W(5, -1137732946, -1102271464, -1106196955, -1097055308)
		 + W(6, -1103368978, 996537094, -1097512177, 1038772124)
		 + W(7, -1108835309, 1035638256, 1028654910, -1144299515);
	WS(1037662203, -1095462961);
	sum1 = W(0, 1051208476, 1007151360, 1047867778, -1120692693) + W(1, -1102286423, 1029685138, -1117174983, 998066935)
		 + W(2, 1054332722, 1048962332, 1056131053, 1060311124) + W(3, 1053179033, 1057524976, 1045179237, 1053688986)
		 + W(4, -1088537607, -1096098779, -1089718811, -1086623130)
		 + W(5, -1088149909, -1093380227, -1094989189, -1094538289)
		 + W(6, 1009988859, -1120684294, 1043868050, 1008468855)
		 + W(7, 1024446024, 1041242535, -1121112609, 1022948968);
	sum2 = W(0, -1075642964, -1078284587, -1077677369, -1086975712)
		 + W(1, 1050575143, -1109971278, 1043550667, 1046375822) + W(2, 1064397427, 1070403917, 1072178178, 1071930150)
		 + W(3, -1093947328, -1119680819, -1134729809, -1094009133)
		 + W(4, 1042055631, 1050515956, -1094922849, -1096417404)
		 + W(5, -1094640520, 1045435393, -1109099138, -1106076462)
		 + W(6, 1049259770, -1100572061, 1038272909, -1110188613)
		 + W(7, 1033007627, -1109186235, 1040318497, 1038207101);
	WS(-1091974591, 1028524890);
	sum1 = W(0, -1119527298, 1034997099, -1099802012, 1033463662)
		 + W(1, -1090658116, 1044419888, -1099353751, -1110855131)
		 + W(2, 1050666155, -1101120961, 1057798952, -1146674958) + W(3, 1048486316, 1054164791, 1033437822, 1053708795)
		 + W(4, -1104886813, -1100807815, -1099838668, 1021707158)
		 + W(5, 1057612011, -1093871840, 1029138830, -1104286795)
		 + W(6, -1119869997, 1044100139, -1103774309, -1112176434)
		 + W(7, -1094617942, 1036492177, -1113521820, 1028051362);
	sum2 =
		W(0, 1029285075, -1113245689, 1046869988, -1099734421) + W(1, 1045806866, -1099048447, 1040440310, -1129472848)
		+ W(2, -1114745613, 1037297246, -1113507597, 1057852752) + W(3, 1031538739, 1019950674, 1039903515, -1115367833)
		+ W(4, 1024121756, 1034295695, -1081105309, 1063764387) + W(5, -1093953622, 1060684479, -1099720743, 1051222485)
		+ W(6, -1127985632, -1103172653, -1097344586, -1092930743)
		+ W(7, 1039548141, -1113791115, 1024790472, -1106398082);
	WS(1058893599, -1078409713);
	sum1 = W(0, -1115244150, 1036724056, -1098555735, 1049246955)
		 + W(1, 1045222582, -1138283737, 1044966206, -1115412967)
		 + W(2, -1102829117, -1100240992, -1094663483, -1084866106)
		 + W(3, -1085064800, -1093243506, -1093950047, -1095580366)
		 + W(4, 1039336887, 1053376406, 1053054383, 1065100884) + W(5, 1054590883, 1056764679, 1053059489, 1050610273)
		 + W(6, -1115623287, -1114512019, 1041993169, 1018575674)
		 + W(7, -1114852275, -1108377677, -1118180448, -1122449691);
	sum2 =
		W(0, -1130929736, 1009552185, -1084383778, 1050909748) + W(1, 1049209322, -1096700837, 1051369678, -1129474226)
		+ W(2, -1101060123, -1090337753, 1072779570, 1053567468)
		+ W(3, -1079161361, 1057662166, -1097661058, -1112521942)
		+ W(4, 1045192083, 1061442923, 1050903982, -1089269841) + W(5, 1029505799, -1094014597, 1046387683, -1105984421)
		+ W(6, -1105822172, -1103557108, -1106762492, -1117595750)
		+ W(7, -1111371347, 1025228376, -1138825972, 1030887459);
	WS(-1109369595, 1048740969);
	sum1 = W(0, 1040995480, 1030414773, -1118646413, 1043594790) + W(1, -1129436350, 1037121811, 1030207412, 1043560049)
		 + W(2, 1051718495, 1050319297, 1059003715, 1046504696) + W(3, -1135436979, 1043825845, 1049475887, 1058279379)
		 + W(4, -1091711555, -1095167863, -1085356599, -1083562713)
		 + W(5, -1096690237, -1098326935, -1120665100, -1098718953)
		 + W(6, -1125552391, 1032958437, 1042985722, 1045509569)
		 + W(7, 1023899916, 1019546753, -1130219052, -1105013544);
	sum2 =
		W(0, -1113177829, 1043809265, -1095416462, 1034071291) + W(1, -1120341831, 1043900974, 1020015593, -1119209873)
		+ W(2, -1117552581, -1109343151, 1052574118, 1063553374)
		+ W(3, 1070912061, -1112203792, -1091338378, -1072794661)
		+ W(4, -1100446453, 1039662186, -1114145263, 1053677817)
		+ W(5, -1101063801, 1042882834, -1094258913, 1055602011) + W(6, 1041583669, 1009024316, -1118793923, 1018689733)
		+ W(7, 1031195477, -1105538343, -1114748986, -1109237633);
	WS(-1093437503, 1065718162);
	sum1 = W(0, 1037550096, -1101135841, 1044878747, -1107014286)
		 + W(1, 1042111087, 1037051057, -1099961615, 1041500301) + W(2, 1049488055, 1042594425, 1049041945, 1066142676)
		 + W(3, -1100146203, 1045825417, 1040663590, -1119554198)
		 + W(4, -1103061781, 1046266118, -1087470164, -1106438298)
		 + W(5, -1111606545, -1091131027, -1133427370, -1103590594)
		 + W(6, -1114711965, -1097873069, 1046063170, -1091362312)
		 + W(7, 1037494709, 1040258368, -1109172298, 1033770775);
	sum2 = W(0, -1106488910, 1026201604, 1035711566, 1060425407)
		 + W(1, -1098764525, -1096618367, -1182808622, -1127820908)
		 + W(2, -1123106758, -1113590739, -1084666863, 1061776657)
		 + W(3, 1055047321, -1119175762, -1103500958, 1041613778)
		 + W(4, 1050172947, -1092748399, -1097703384, -1099741350)
		 + W(5, -1120322586, 1050324229, 1025620288, -1105222946)
		 + W(6, -1124712996, 1043391307, -1098783459, 1048423650)
		 + W(7, 1041036039, -1099280352, 1048645442, -1118590758);
	WS(1056660607, -1113798601);
	sum1 =
		W(0, -1115305597, -1101671294, 1016801995, 1039904137) + W(1, 1037148876, 1040453028, -1110559226, -1154296528)
		+ W(2, 1041913228, 1008348404, 1031963795, -1093680051) + W(3, -1089471492, 1034024758, -1111400057, 1031051312)
		+ W(4, 1012656821, 998498191, -1102006873, 1057450908) + W(5, 1049874551, -1111681498, -1109457443, 1036430914)
		+ W(6, 1026504084, -1151777337, 1032505286, -1108358078)
		+ W(7, 1031920291, 1043455038, -1129849213, -1125050675);
	sum2 =
		W(0, 1042939003, -1114796094, 1044529628, -1124781020) + W(1, -1106748864, 1016881133, -1108227590, 1027959261)
		+ W(2, 1024638457, -1101207597, 1027593065, -1097759574) + W(3, -1130307786, 1033669310, 1022409637, 1019735589)
		+ W(4, -1123927190, 1042777565, -1098782283, 1059165645)
		+ W(5, 1062760553, 1017094385, -1160993898, -1125388747) + W(6, 998901155, 1022659417, 1017512357, -1104939928)
		+ W(7, -1098668376, -1089791762, -1106217568, -1115680109);
	WS(1066155712, 1004288134);
	sum1 = W(0, 1047132567, 1029697589, 1014062303, 1041631965) + W(1, 991515041, -1123217244, -1154741365, 1030265807)
		 + W(2, 1049267618, 1048612844, 1055750611, 1059093756) + W(3, 1057479944, 1056993158, 1047138005, 1055767146)
		 + W(4, -1089062279, -1092380195, -1088453014, -1084647474)
		 + W(5, -1091963789, -1088742789, -1098495965, -1086886676)
		 + W(6, -1138510971, 1046969501, 1024451359, 1049129552)
		 + W(7, 1040560290, 1043007167, -1122630737, -1122583780);
	sum2 =
		W(0, 1011892235, -1111382628, 1037768402, 1032283234) + W(1, -1114728106, 1009460031, -1112526532, 1030203700)
		+ W(2, 1040858440, -1103755803, -1125277089, -1084511950)
		+ W(3, -1090323786, -1159433014, 1053584755, 1052886875)
		+ W(4, -1127819845, -1109875610, -1096621612, -1071556311)
		+ W(5, -1071973667, -1099343032, 1076043190, 1079690007) + W(6, 1010964983, -1106716388, 1032593498, 1040462902)
		+ W(7, -1100404332, 1040394500, 1007208771, 1051792925);
	WS(-1086041375, 1049976369);
	sum1 = W(0, -1125608345, 1025261033, 1032012444, 1046732297)
		 + W(1, -1114869141, 1036081274, 1036645660, -1119140736)
		 + W(2, -1096855193, -1097190986, -1086237883, -1083643033)
		 + W(3, -1093631755, -1095059844, -1132519191, -1095180224)
		 + W(4, 1037693680, 1051176741, 1059434222, 1062665585) + W(5, 1052924527, 1052562329, 1041010310, 1048775023)
		 + W(6, 1048607039, 1030637974, 1026121224, -1103554484)
		 + W(7, -1110078044, -1109004102, 1035782593, -1118200972);
	sum2 = W(0, 1029601330, -1144560396, 1032763954, -1115106220)
		 + W(1, -1111454114, -1121335223, -1109520646, 1021645795)
		 + W(2, -1115199196, 1026958814, 1032369083, -1106065675) + W(3, 1042189754, 1029124674, 1022674491, 1026253022)
		 + W(4, -1096390757, -1100298556, 1076866217, -1108884178)
		 + W(5, -1116766618, 1025985538, -1115268590, 1011072742)
		 + W(6, -1079547524, -1081990625, 1041174181, 1041059708)
		 + W(7, 1024602232, -1127158528, 1007020790, 1003377428);
	WS(-1111980027, 1060626277);
	sum1 = W(0, 1023621139, 1032179266, 1030954414, 1037158526) + W(1, 1036765152, 1036680203, -1146606447, -1119312598)
		 + W(2, -1102882983, -1092055397, -1089823274, -1095093232)
		 + W(3, -1090725010, -1139402199, -1116432156, -1108873773)
		 + W(4, 1044706422, 1043529367, 1057090380, 1064981515) + W(5, 1047303429, 1042557255, 1028925358, 1041638915)
		 + W(6, 1028429765, -1113080214, -1101761443, -1098683411)
		 + W(7, 1033439719, 1030304674, -1104492078, -1112219839);
	sum2 =
		W(0, -1107703976, 1046455264, -1093472442, 1048924762) + W(1, -1097201227, 1049435664, -1106239872, -1119402461)
		+ W(2, 1045439570, -1090239140, 1028879562, 1064195571) + W(3, 1016778259, 1027385222, 1028121257, -1105208479)
		+ W(4, 1032849260, -1096329612, 1030082819, 1036056807) + W(5, 1059898488, -1091675747, 1053658286, -1117889585)
		+ W(6, -1122224669, 1035962913, -1098806672, 1041148911)
		+ W(7, -1091828205, 1041687668, -1098243254, -1104565052);
	WS(1062681599, 1040842201);
	sum1 =
		W(0, -1108789463, -1115361429, 1048981817, -1092926921) + W(1, 1054602509, 1029602904, -1117967305, 1025443329)
		+ W(2, -1104300209, 1050445194, -1089127203, 1063952639)
		+ W(3, 1043197406, -1106041808, 1039191171, -1114238594) + W(4, 1042117608, -1097788769, 1032428200, 1049970971)
		+ W(5, -1088418847, 1049956321, -1112931212, -1123051255)
		+ W(6, -1118282400, -1114475276, 1049574381, -1090427073)
		+ W(7, 1045778638, -1112080775, -1097758566, 1033393295);
	sum2 = W(0, 1038735267, -1100048068, -1115453090, -1110884051)
		 + W(1, -1090743949, -1153955669, -1112598570, -1103797208)
		 + W(2, -1126315713, 1043050536, 1053683464, 1058830244)
		 + W(3, -1100540415, 1037942519, -1098889179, 1040830228)
		 + W(4, -1111714958, -1115313021, 1046662525, 1061563017)
		 + W(5, 1052621807, -1104363663, -1118760183, 1007755797)
		 + W(6, -1111656758, -1115683900, -1093358619, -1105966973)
		 + W(7, 1037413595, -1101879362, 1044482581, -1098877089);
	WS(1062776447, 1069975051);
	sum1 = W(0, -1130308944, -1112835078, -1113144126, -1094805377)
		 + W(1, -1098008538, -1114270939, -1117364667, -1117827459)
		 + W(2, 1036893844, -1114635034, 1050058840, 1071110128) + W(3, 1061455014, 1044746969, 1018226642, 1049407081)
		 + W(4, -1104137265, -1098478453, -1104852259, 1041368142)
		 + W(5, -1095764665, -1109080309, -1103882015, -1120810969)
		 + W(6, -1108240801, 1029922778, -1111877761, -1088740684)
		 + W(7, -1112520550, -1119589855, -1121527653, -1103102129);
	sum2 =
		W(0, 1028834725, -1110297977, 1035091068, 1034973002) + W(1, -1110025415, -1154986018, -1120031976, 1030684381)
		+ W(2, -1113117380, 1026197871, -1099362318, 1077416661) + W(3, 1050456944, -1112814852, 1027999489, 1016280910)
		+ W(4, 1037052904, 996515330, 1043940575, -1069860026) + W(5, 969317772, 1021906202, -1115577362, 1013156184)
		+ W(6, -1113210551, 1032917698, -1106692355, -1103487680)
		+ W(7, 1034055293, 1006658352, 1018186436, -1124181989);
	WS(-1082599007, -1084302409);
	sum1 = W(0, -1127095446, 1011517278, -1110892475, 1024933540)
		 + W(1, -1111586789, 1039136849, -1108207315, 1049617952) + W(2, 1056665680, 1052281350, 1058821842, 1061132051)
		 + W(3, 1054434479, 1052720805, 1043783817, -1159632952)
		 + W(4, -1087212124, -1096260148, -1085877656, -1087957451)
		 + W(5, -1089270826, -1102718609, -1106422582, -1106709957)
		 + W(6, 1035858193, -1128228554, 1043137767, 1023709101)
		 + W(7, 1037286635, -1111842501, -1130056576, -1115207149);
	sum2 = W(0, 1048459811, 1071226724, 1075494724, 1074401127)
		 + W(1, 1044864951, -1077687291, -1072311776, -1066953112)
		 + W(2, -1095160239, 1065850492, -1121381976, -1099027008)
		 + W(3, 1031151008, 1057399482, 1045213405, -1095971461) + W(4, 1026509768, 1043007163, 1043168485, -1093896652)
		 + W(5, 1012395574, 1019701051, -1109946848, 1027278540)
		 + W(6, -1123792544, -1127547903, 1027169380, -1107011198)
		 + W(7, 1037067951, 1021690579, -1124089088, -1166810856);
	WS(-1118215158, -1130722305);
	sum1 = W(0, 1039784439, -1119983743, 1027132090, -1101267710)
		 + W(1, -1106141431, -1119840977, -1131926580, -1158357571)
		 + W(2, 1045520358, 1040649785, -1126797149, 1070303194) + W(3, 1059129261, 1056727436, 1040938982, 1050582583)
		 + W(4, -1094865274, -1098235299, -1085881139, -1106608186)
		 + W(5, -1088850304, -1093134907, -1098615277, -1104503154)
		 + W(6, 966095017, -1166742058, 1023429181, -1127173569)
		 + W(7, -1112024885, 1030946302, -1160489077, -1106263629);
	sum2 =
		W(0, -1122933952, 1029904221, -1104768174, 1044174015) + W(1, -1122786276, 1032455763, -1118952582, -1120585334)
		+ W(2, 1043676402, -1092335308, 1050667883, -1106663265) + W(3, 1035773679, 1033986578, -1123822916, 1030027555)
		+ W(4, -1122578476, -1096734640, -1067932755, 1078656606)
		+ W(5, 1056344301, -1106732625, 1033374173, -1116084330)
		+ W(6, 1034421913, -1121365342, -1103315560, 1049347404)
		+ W(7, 1027752905, -1114333025, 1025409455, -1129253837);
	WS(-1112296443, -1083191171);
	sum1 = W(0, 1030599873, -1102688301, 1038739494, -1091052013)
		 + W(1, -1120252367, -1118018759, -1105737735, 1036799090)
		 + W(2, 1049894985, 1052276159, 1055519004, 1061107959) + W(3, 1059731464, 1052059899, 1050382861, 1050879021)
		 + W(4, -1100141489, -1095734081, 1044438853, -1078809864)
		 + W(5, -1100785926, -1095185489, -1092887220, -1113977245)
		 + W(6, -1124642344, -1114229790, 1039505712, -1108354137)
		 + W(7, 1037196526, -1129006466, 1034647259, -1123394945);
	sum2 = W(0, -1134366274, 1040286055, -1103185345, -1089934078)
		 + W(1, -1104699884, -1135474394, 1039368980, 984214720) + W(2, 1032198029, -1093721101, 1064064153, 1038410574)
		 + W(3, 1053501328, 1053898256, -1088730122, 1045555557)
		 + W(4, -1102569648, 1059013351, -1076328416, 1075980540)
		 + W(5, -1081344728, -1093863519, 1061819985, -1089334779)
		 + W(6, -1113629492, -1099320981, 1062572765, -1079072621)
		 + W(7, 1057269325, 1039501040, -1089994189, 1050815727);
	WS(1051639487, -1077445112);
	sum1 = W(0, 1023584208, 1019039018, 1046978951, -1114024277) + W(1, 1042440780, 1036430651, 1019910405, 1017051223)
		 + W(2, -1087680633, -1097242582, -1087958558, -1084584703)
		 + W(3, -1089578188, -1090497932, -1100840226, -1089989738)
		 + W(4, 1058381481, 1049175941, 1059595066, 1058705186) + W(5, 1060807824, 1057261083, 1047705823, 1052092149)
		 + W(6, 1019116206, -1110819225, 1041321753, -1110784681)
		 + W(7, -1120949436, -1111841304, -1108976675, 1037750032);
	sum2 = W(0, -1103483317, -1103949071, 1036613850, -1096200772)
		 + W(1, -1094761445, -1090478844, -1091384835, 1024429003)
		 + W(2, 1043027417, 1024633771, 1050158855, -1096718424) + W(3, 1057240079, 1037855330, 1036780676, -1103545669)
		 + W(4, 1043672886, -1105891820, -1113242263, 1053817256) + W(5, 1043447632, 1053166295, 1043680942, 1034776200)
		 + W(6, -1126025102, -1101612494, 1051748473, -1144187697)
		 + W(7, -1129269697, -1114569970, -1102484885, 1044262941);
	WS(-1102141694, 1066754929);
	sum1 = W(0, 1024767465, 1028037205, -1148374821, 996156698) + W(1, 1034886379, 1011245536, 1017269224, 1023537404)
		 + W(2, -1097150806, -1105574095, -1092607882, -1086231302)
		 + W(3, -1085570014, -1090150659, -1093685286, -1100403588)
		 + W(4, -1121670572, 1021251426, 1053426631, 1064662112) + W(5, 1060264850, 1058905527, 1047037217, 1048736520)
		 + W(6, 1047316983, -1123186307, 1027553675, 1037457517)
		 + W(7, -1103359865, 1031219256, -1108923303, 1039125668);
	sum2 = W(0, -1127568330, 1031019669, 1013355589, -1123247753)
		 + W(1, -1131101666, -1126559289, -1128009624, -1122774763)
		 + W(2, 1005444026, -1121000217, -1135062981, -1099801823)
		 + W(3, 1044314830, 1052295626, -1112001042, 1018744598)
		 + W(4, -1099850392, 1052911126, 1040255711, -1120914990)
		 + W(5, 1055431083, -1112663055, 1029993103, -1105142519)
		 + W(6, -1069105992, -1075891845, 1052106082, 1078854269)
		 + W(7, 1061745892, -1097592921, 1033712114, 1037317546);
	WS(-1092827839, 1049601702);
	sum1 = W(0, -1102748075, 1048973336, -1101661842, 1035794226) + W(1, 1035295380, 951002293, 1028700102, 1019995195)
		 + W(2, -1114726817, -1100496851, 1056141590, -1092935501)
		 + W(3, -1090189951, -1127762491, -1107070641, -1116434785)
		 + W(4, 1043768535, 1037939345, -1092531310, 1048278549)
		 + W(5, 1059458263, -1107678146, 1040739973, -1103464157) + W(6, 1001409895, 1025584388, 1043222609, 1028885900)
		 + W(7, -1097823129, 1046084402, 1018269854, 1033486885);
	sum2 = W(0, 1047648616, 1049954711, -1086499077, 1036131868)
		 + W(1, 1021844703, -1144052469, 1036766656, -1114852932)
		 + W(2, -1099866854, -1087014785, 1059941103, 1059724034)
		 + W(3, -1104253425, -1116739540, -1123734224, -1119117496)
		 + W(4, 1040911688, -1127547935, 1006897087, -1147690453)
		 + W(5, -1094365093, 1046092804, -1117733622, 1045874226)
		 + W(6, -1104812914, 1032774583, -1118719608, -1112213150)
		 + W(7, 1020986307, 1037506252, 1020773629, -1120467144);
	WS(1062974879, -1132215613);
	sum1 = W(0, -1181157822, 1033235448, -1120645311, 1032693326) + W(1, 1014937094, 1012846527, 1029466479, 1027727527)
		 + W(2, -1096960767, -1103300066, -1098273063, -1084817024)
		 + W(3, -1086871647, -1093312183, -1094276984, -1099477807)
		 + W(4, 1047884458, 1024586364, 1040665968, 1065496294) + W(5, 1061273423, 1057013666, 1048826162, 1049029078)
		 + W(6, 1046591191, 1028472621, 1027902609, -1105457745)
		 + W(7, -1099580452, -1121668195, -1123904424, 1033797162);
	sum2 =
		W(0, -1120861164, 1023555157, -1114715157, 1039733942) + W(1, -1111876903, -1121732899, 1028106223, -1136150442)
		+ W(2, -1114727130, -1127207629, 1049207316, -1100512081)
		+ W(3, 1044392032, -1113639142, -1107243417, 1035475508) + W(4, 1051943787, 1021361633, -1100379929, 1049204344)
		+ W(5, 1029680046, 1040523175, -1113800818, 1017564481) + W(6, 1073213517, 1067585393, -1095215585, -1072102567)
		+ W(7, -1085077901, 1017790060, -1115100698, -1111101803);
	WS(1038961915, -1122010239);
	sum1 = W(0, 1004620105, -1113106351, -1112775210, -1125534724)
		 + W(1, -1137271196, -1126589322, 1026657556, -1119328748)
		 + W(2, 1048595660, 1052250558, 1058549636, 1061573929) + W(3, 1057522353, 1048822826, 1040718305, 1048641524)
		 + W(4, -1099376311, -1096833644, -1088891129, -1086812373)
		 + W(5, -1093214133, -1095914356, -1105329661, -1103878453)
		 + W(6, -1116246236, 1027857155, 1036452944, 1040782707)
		 + W(7, 1018281129, -1113857108, 1010557432, -1106455448);
	sum2 =
		W(0, -1116580406, 1024927837, -1129828931, -1115420496)
		+ W(1, 1011185933, -1123989928, -1146345634, -1132229127)
		+ W(2, 1027562258, -1162615720, 1047581344, -1109513493) + W(3, 1038795182, -1118168090, 1030671240, 1038841827)
		+ W(4, 1055923683, -1098456431, -1107918233, -1093462217)
		+ W(5, 1043574176, 1042713369, -1118222006, 1029869485) + W(6, 1077914250, 1064911462, -1076359256, -1072190840)
		+ W(7, 1023726209, -1114062645, -1119388396, -1111766417);
	WS(1058520191, -1103814144);
	sum1 = W(0, 1017038583, 1027734728, 1045254802, -1107262661)
		 + W(1, -1105442246, 1031430877, -1126950445, 1024536063)
		 + W(2, -1136595532, 1016280509, -1109207324, 1062837304) + W(3, 1058887264, 1040464732, 1030731221, 1029953906)
		 + W(4, -1118053743, -1128563239, 1044218638, -1096672636)
		 + W(5, -1085861660, -1103880229, -1107144426, -1145128486)
		 + W(6, 1027978638, -1097122909, -1104843131, 1033499055)
		 + W(7, 1025985831, 1030848699, -1131329888, -1109411553);
	sum2 = W(0, 1034702970, -1125598974, -1114553387, 1027536136)
		 + W(1, -1115924578, 1035052048, -1132148431, 1025333585)
		 + W(2, -1176551015, -1168898884, 1041527709, -1101298022)
		 + W(3, 1036785061, -1106074654, 1030578400, 1024211757) + W(4, 1007931783, -1090251816, 1067159008, 1043575777)
		 + W(5, 1028484706, -1104273626, -1148595850, -1114791455)
		 + W(6, -1110263367, -1089294892, -1085860022, 1061443693)
		 + W(7, -1099982080, 1042454777, 1027614804, -1123742626);
	WS(1061983711, -1098811342);
	sum1 = W(0, 1012577103, -1126897281, -1105225996, 1024253613)
		 + W(1, 1053413654, -1137207095, 1042674340, -1109172700) + W(2, 1051270689, 1046420622, 1058683087, 1058369439)
		 + W(3, -1097514912, 1052214131, -1105013139, 1050302029)
		 + W(4, -1108510228, -1106195699, -1088411008, -1089548804)
		 + W(5, -1118840551, -1096732498, -1109015536, -1103000311)
		 + W(6, -1107438075, -1107699151, 1036711743, 1026749110)
		 + W(7, -1116819519, 1024709491, -1140694819, -1154413112);
	sum2 = W(0, 1018267361, -1110181012, -1146613180, 1038715850)
		 + W(1, 1024296823, 1036970119, 1022003098, -1124702635) + W(2, 1036503366, 1041828239, 1050199247, -1085432172)
		 + W(3, 1038941240, -1123003584, 1013422114, 1021003447)
		 + W(4, -1126101987, -1116783782, 1071387060, -1080125372)
		 + W(5, -1093021050, -1114155200, -1149124484, -1143100940)
		 + W(6, -1099489904, -1102883314, 1052019906, 1047113133)
		 + W(7, 1035497971, -1112911441, -1119585859, -1131838862);
	WS(1061194367, -1092415693);
	sum1 = W(0, 1036390333, -1126263470, 1025725222, 1043857157) + W(1, 1035642972, 1044002978, 998479342, 1045699251)
		 + W(2, 1051201914, 1053058480, 1054554894, 1047231542) + W(3, 1057662314, 1050872286, 1045022613, 1049392206)
		 + W(4, -1104881972, -1172862130, -1093268199, -1076465248)
		 + W(5, -1087389459, -1093150623, -1111846627, -1095910796)
		 + W(6, -1115149537, 1030237668, 1021350042, 1036659934) + W(7, 1039247491, 1026362746, 1017611295, 1018350484);
	sum2 = W(0, -1129487679, 1042193002, -1108339354, -1095819059)
		 + W(1, 1041127864, -1103499785, 1034257999, -1118637794)
		 + W(2, 1018376667, -1087595144, 1054016721, 1063707892)
		 + W(3, 1036978867, -1103064253, -1103241982, -1112191100)
		 + W(4, -1097777178, -1098446206, -1106280983, 1068295659)
		 + W(5, 1052165187, -1110264861, -1135489703, -1107248782)
		 + W(6, -1117386048, -1106566736, -1108034123, -1104582586)
		 + W(7, -1102127104, 1036459063, -1104779766, 996655259);
	WS(-1094699455, 1066131816);
	sum1 = W(0, 1049793485, 1029004921, 1050253240, 1043166228) + W(1, 1029407446, 1041612884, 1035949114, 1012128942)
		 + W(2, -1081848423, -1088299640, -1084057276, -1084821317)
		 + W(3, -1084563631, -1104203619, -1099802604, -1096241030)
		 + W(4, 1059460685, 1048637514, 1060796209, 1059873140) + W(5, 1055943200, 1047596309, 1050483936, -1105809528)
		 + W(6, 1042128105, -1139594888, 1026023615, 1020508084)
		 + W(7, -1125172935, 1048504406, -1115227886, 1051471881);
	sum2 = W(0, 1060779432, -1118034101, -1104519356, -1119327164)
		 + W(1, -1101970936, -1106905521, 1002331293, -1082144605)
		 + W(2, 1051802488, -1097493973, 1057101737, 1060027297)
		 + W(3, 1044004337, 1057962293, -1098665363, -1086721729)
		 + W(4, -1086062785, 998397725, -1092333837, 1066349798) + W(5, 979464170, -1133317807, 1046794021, 1070824403)
		 + W(6, -1114203174, -1112558489, -1099984065, -1091352583)
		 + W(7, -1094257268, -1102635709, -1094504499, -1114333706);
	WS(-1074268304, 1079667699);
	sum1 = W(0, -1107189325, 1027760991, -1136873402, -1113641470)
		 + W(1, 1031162561, 1033891144, -1126712892, 1035917755)
		 + W(2, -1101508903, -1090199334, -1090363950, -1087996124)
		 + W(3, -1083961527, -1096484091, -1098094611, -1093567651)
		 + W(4, 1054199089, 1054303683, 1062422475, 1067750847) + W(5, -1113534839, 1052689284, 1031942551, 1045977323)
		 + W(6, 1035260131, -1107632246, 1005391451, -1101800081)
		 + W(7, 1034855959, 1046337921, -1150999418, 1042992013);
	sum2 = W(0, -1109104193, -1121805095, 1045986101, 1048674700)
		 + W(1, -1091901802, 1048446997, -1113936425, 1027039508)
		 + W(2, -1100757902, 1045040397, 1080470972, -1080397282)
		 + W(3, -1070026310, 1054845861, -1109557127, -1113850952)
		 + W(4, 1040683096, -1125556022, 1049174250, -1095181876)
		 + W(5, -1122013099, -1110936398, 1038355211, -1103996340)
		 + W(6, -1125509919, 1026278254, -1112163985, 1050380898)
		 + W(7, -1131668233, 1033243862, -1144282357, 1036778147);
	WS(-1085238047, -1082053459);
	sum1 = W(0, -1106787663, -1138285833, -1108632776, -1094657608)
		 + W(1, -1101713608, 1037328759, -1111697288, -1109379868)
		 + W(2, 1039996894, 1010512412, 1053399812, 1045540841) + W(3, 1051732998, 1044326914, 976543556, 1057105320)
		 + W(4, 1048926451, -1119213276, -1130975030, 1010216242)
		 + W(5, 1034301867, 1025236158, -1128978334, -1109745879)
		 + W(6, -1104330662, -1128637723, -1108017347, -1096910157)
		 + W(7, -1101323868, 1015829447, -1111437732, -1108664266);
	sum2 = W(0, -1124623913, 1032956443, 1027185909, -1101336864)
		 + W(1, -1094263361, 1029736763, -1112090109, 1039412150)
		 + W(2, 1025825838, -1119700813, 1032253087, 1046009611)
		 + W(3, 1060071017, -1108021530, -1111711122, -1092338318)
		 + W(4, 1042257288, -1135835500, 1053804277, 1048892371)
		 + W(5, 1036906607, -1101254223, -1115069322, -1114145526)
		 + W(6, 1021162350, -1114452863, -1109212782, -1102267892)
		 + W(7, -1105958464, 1037505372, 996911332, -1125671849);
	WS(1060867039, -1136390908);
	sum1 = W(0, -1127355032, 1034805910, 1035163860, 1029669941) + W(1, 1042066222, 1021674692, 1040577786, 1021261983)
		 + W(2, -1085412379, -1094311080, -1093352008, -1084691216)
		 + W(3, -1088428116, -1088125293, -1096644095, -1091872390)
		 + W(4, 1049179798, 1049208039, 1060583566, 1063283264) + W(5, 1058522472, 1055147879, 1050065089, 1041474713)
		 + W(6, 1047055468, -1108149971, 1036232649, -1103012671)
		 + W(7, 1024178471, 1026233836, -1126656770, 1049799631);
	sum2 =
		W(0, 1035672114, -1098827199, 1049155846, 1035178389) + W(1, -1107113032, -1144855824, 1035201737, -1127184278)
		+ W(2, -1063752230, -1085747691, 1077059336, 1075347264) + W(3, 1056308660, 1034654874, -1121418857, 1014935340)
		+ W(4, -1093487673, 1041803367, 1041184099, -1096808218)
		+ W(5, -1129382302, -1119639669, -1122522987, 1011408026)
		+ W(6, 1013645866, 1034418818, -1106855503, 1049524211)
		+ W(7, -1122362105, 1030856901, 1027103888, -1115004359);
	WS(-1090674303, -1100343233);
	sum1 = W(0, -1120232797, 1040422273, 1026412864, -1138867958) + W(1, 1033879777, 1033565615, 1019476032, 988102399)
		 + W(2, -1091881416, -1094093465, -1085938046, -1089254334)
		 + W(3, -1089797193, -1085407367, -1095206984, -1105032111)
		 + W(4, 1051419109, 1052500896, 1061270771, 1067891162) + W(5, 1060067146, 1016645247, 1041715172, 1036835111)
		 + W(6, 1036288004, 1023553551, -1112170192, -1115349187)
		 + W(7, -1112030904, 998486818, 1027103050, 1040345019);
	sum2 =
		W(0, 1040618154, -1114130867, -1122148687, 1044229537) + W(1, -1110193301, -1097134960, 1037070268, 1037459780)
		+ W(2, -1101425729, 1043012943, 1049717343, 1078734719) + W(3, 1058416067, -1066172228, -1087270128, 1051160418)
		+ W(4, 1012698939, -1135257643, 1047429512, 1020747990) + W(5, 1045573328, -1105653505, -1098650023, 1029335953)
		+ W(6, -1121139419, 1033653009, 1038119907, -1131387750)
		+ W(7, -1162837210, -1124290574, -1142454518, -1119987003);
	WS(-1083751903, -1076119444);
	sum1 = W(0, -1115245576, -1106029427, -1102084379, -1113929101)
		 + W(1, -1115339007, 1029734646, -1110488366, -1147960477)
		 + W(2, 1056842307, 1054460828, 1062160243, 1061549380) + W(3, 1051628466, 1034628298, 1040780998, 1027250487)
		 + W(4, -1093345814, -1096614035, -1087844584, -1088621915)
		 + W(5, -1095344475, 1039622221, 1023285463, 1052549785)
		 + W(6, -1108216057, -1118873130, 1032187759, -1118044066)
		 + W(7, -1125935063, -1114025640, -1103117229, -1101242061);
	sum2 = W(0, -1142266798, -1105635988, -1108468488, -1104742183)
		 + W(1, 1004562934, -1111519795, 1009402627, 1007186587) + W(2, 1041896729, -1133541327, 1052249127, 1059101684)
		 + W(3, -1116644500, 1022626513, 1036478091, -1114250343)
		 + W(4, -1109207785, -1119640286, -1132044399, 1057719514)
		 + W(5, 1049160976, 1040987637, -1103527129, -1094402391)
		 + W(6, -1116438034, -1143926222, -1116983273, -1107716245)
		 + W(7, 1036001553, -1093640310, -1115139384, -1102449905);
	WS(1032624635, 1033521535);
	sum1 = W(0, -1131553039, -1117491096, -1112834618, 1049918570)
		 + W(1, 1045795365, 1016822387, 1035361729, -1113168565)
		 + W(2, -1098906814, -1100587359, -1081513385, -1078593782)
		 + W(3, -1105649745, -1092053629, -1096260814, -1095243062)
		 + W(4, 1051615627, 1047570260, 1060987922, 1043587024) + W(5, 1056209202, 1059398075, 1049440024, 1051600524)
		 + W(6, 1045470610, 1025984961, 1036113314, 1040182861) + W(7, 1012071435, 1032631435, 1023888652, 1034850724);
	sum2 = W(0, -1111826236, -1099208280, 1026789677, -1106561040)
		 + W(1, -1093448876, 1046407154, -1102666308, 1042570396)
		 + W(2, -1092384767, 1027875109, 1064661507, 1062273543)
		 + W(3, -1087164405, -1108191451, 1044380270, -1104593420)
		 + W(4, -1095745094, -1100947515, -1112642295, 1068550638)
		 + W(5, -1104229197, -1106740917, -1103404028, -1105841536)
		 + W(6, 1034661269, 1048636172, -1098451609, -1099981129)
		 + W(7, -1118651857, 1049739863, -1095995165, 1048025970);
	WS(-1085606847, 1061985400);
	sum1 = W(0, -1108997980, -1117164584, 1031768707, -1103105924)
		 + W(1, 1041900981, -1110420181, 1037113665, 1014163116)
		 + W(2, -1089905075, -1114895517, -1095264598, -1077801587)
		 + W(3, -1097956992, -1088999487, -1098379486, -1096151518)
		 + W(4, 1057688104, 1056544190, 1062390314, 1055481056) + W(5, 1062127874, 1051900674, 1048102065, 1057425872)
		 + W(6, 1040581229, -1114811305, -1107526493, -1110202349)
		 + W(7, -1118208771, -1108027100, 1024450541, 1041210774);
	sum2 =
		W(0, 1025785873, 1048912334, -1096464036, 1056133856) + W(1, -1104154812, -1121968309, 1033410161, 1015120151)
		+ W(2, 1048760593, -1090084783, -1114768213, 1066763200)
		+ W(3, -1086306359, 1058187354, -1113492694, -1128581905)
		+ W(4, 1035955606, -1119218892, 1007739746, 1064934573) + W(5, -1089946445, 1050702067, 1025685973, -1102128709)
		+ W(6, -1126760968, 1008603006, -1094704139, -1080670875)
		+ W(7, 1031309677, -1125625514, -1109240237, 1039335694);
	WS(-1090966143, -1078936607);
	sum1 = W(0, -1116393227, -1108278025, 1051625062, -1105522375)
		 + W(1, 1058727904, -1091195697, 1052016408, -1109728971)
		 + W(2, -1086961670, -1108945587, -1086695325, -1081986687)
		 + W(3, -1089148367, -1086453117, -1092689140, -1091172115)
		 + W(4, 1058706816, 1041859343, 1060094467, 1059190367) + W(5, 1061098519, 1055062080, 1056115606, 1058930855)
		 + W(6, -1116819366, 1035952359, 1041797992, -1104043025)
		 + W(7, 1053094890, -1093101306, 1015960496, 1034498693);
	sum2 = W(0, 1023528661, -1119417071, -1105978590, 1009798795)
		 + W(1, 1040834561, -1111364082, 1041397121, 1033368796)
		 + W(2, -1118025227, 1050920275, -1112399565, -1098493686)
		 + W(3, 1036263434, -1124489419, 1048582480, -1089345484) + W(4, 1075422545, 1065042273, 1069638520, 1067662601)
		 + W(5, -1093932676, -1079439326, -1078082886, -1070108577)
		 + W(6, -1073269716, -1077701631, -1078616397, -1083676116)
		 + W(7, 1044144047, 1070390370, 1068400636, 1077727906);
	WS(-1079921856, 1049308945);
	sum1 =
		W(0, 1030068962, -1133949626, 1050882798, 1018623990) + W(1, -1106924392, -1146454049, -1116987117, 1040905769)
		+ W(2, -1165865787, -1118082277, 1053008345, -1094507016) + W(3, 1052481994, 1043504665, 1047635255, 1026870489)
		+ W(4, -1187780005, -1108803021, 1038634079, -1106873963)
		+ W(5, -1087778738, -1101591143, -1101174683, -1110197734)
		+ W(6, 1025440517, -1111921110, -1120535059, -1104818073)
		+ W(7, 1046575523, 1041667424, 1031519031, 1031554658);
	sum2 =
		W(0, -1116556974, -1095066961, -1100395256, 1050308919) + W(1, 1040792410, 1032406727, 1011901446, -1141998384)
		+ W(2, 1059176005, 1038856572, -1076691076, 1055715442) + W(3, 1046498927, -1123959066, 1028959950, 1032868606)
		+ W(4, -1096412953, 1050790436, 1058179896, -1097771226) + W(5, 1039711359, -1106160519, 1018212767, 1038360912)
		+ W(6, -1114011261, -1173649795, 1024138419, 1040413046)
		+ W(7, -1106323994, 1033840078, -1127468978, -1107910389);
	WS(1060842367, -1123947436);
	sum1 = W(0, 1024730985, 1023159627, -1105241169, 1017803651) + W(1, 1037913699, 1035962309, 1028045772, 1032728670)
		 + W(2, 1048950736, 1047784339, 1057388094, 1060112037) + W(3, 1062491953, 1057656339, -1114528913, 997860858)
		 + W(4, -1097448124, -1098772880, -1087773444, -1085451727)
		 + W(5, -1088044111, -1089872870, -1102522557, -1103124285)
		 + W(6, -1122548355, 1026072115, 1037590622, 1037652837)
		 + W(7, 1034810634, 1033785172, 1008900343, -1114288296);
	sum2 = W(0, 1026131421, -1112740722, 1046858645, 1032928238)
		 + W(1, 1042166107, 1040344552, -1082879617, -1091819295)
		 + W(2, 1001103237, -1121600279, -1108221277, -1097923247)
		 + W(3, 1069212508, 1057336110, -1095628134, -1107037379)
		 + W(4, -1133854939, 1038637096, 1037424280, -1103185020)
		 + W(5, -1120290433, 1019342369, 1039461314, -1122429445)
		 + W(6, -1114822986, -1108393699, 1029862733, -1101308237)
		 + W(7, 1036213344, -1145606165, -1111520861, 1034167562);
	WS(1038606587, 1058047160);
	sum1 = W(0, 1026865207, 1042118304, 1051307036, 1033639368) + W(1, 1046742309, -1109598961, 1028927539, 1015037525)
		 + W(2, -1095018974, -1093024127, -1082724754, -1100730470)
		 + W(3, 1036658562, 1040951763, -1113143704, -1098528366)
		 + W(4, 1044423619, 1048945010, 1054092644, -1097872036) + W(5, -1091674216, 1033100505, 1030352835, 1047837568)
		 + W(6, -1136300775, -1117800769, 1005722288, 1044405134)
		 + W(7, 1047528601, 1044812414, 1032954286, 1044220906);
	sum2 = W(0, 1050657429, -1103301852, 1060573163, -1091436731)
		 + W(1, -1104427284, -1097267636, 1038196249, -1107511544)
		 + W(2, 1045860939, 1052242374, -1100974944, 1066745360)
		 + W(3, -1079344782, -1113016512, -1119497008, -1113648424)
		 + W(4, -1111592920, 1013554208, -1111727364, 1055083328)
		 + W(5, -1098647652, 1034990326, -1110499846, 1042188938)
		 + W(6, -1103122208, -1106328874, 1015168980, -1113723980)
		 + W(7, 1051192034, 1034643320, -1122594772, -1140986496);
	WS(-1095257599, 1052962039);
	sum1 = W(0, -1106746181, 1031300369, 1046667354, 1037361867)
		 + W(1, 1040829967, -1128966365, 1034540700, -1115420664)
		 + W(2, -1097695335, -1111219488, -1083536631, -1088861218)
		 + W(3, -1107201338, -1115618056, -1117058422, -1138753100)
		 + W(4, 1053309708, 1042046133, 1060606673, 1053570633) + W(5, -1101583222, 1033575580, 1029127944, 1041019129)
		 + W(6, 1036635571, 1032102291, -1110849586, -1103814096)
		 + W(7, -1130665360, 1023220920, 1009452933, 1041468947);
	sum2 =
		W(0, -1137205193, -1121249932, -1137006201, -1101149788)
		+ W(1, 1034796937, -1115985020, -1140489533, 1026538132) + W(2, -1089705070, 1025195792, 1049206515, 1054529493)
		+ W(3, 1039074115, 1050074620, -1104546681, -1103055048) + W(4, -1116057142, 1014073009, 1040872535, 1044729510)
		+ W(5, 1024555690, -1108168105, -1105229574, -1093226929)
		+ W(6, -1106134583, -1131583764, 1023734245, 1030258377)
		+ W(7, 1045578999, 1041497164, -1131316168, 1036128894);
	WS(1058062751, -1100017341);
	sum1 = W(0, -1129599006, 1020928695, -1098371705, -1111175932)
		 + W(1, -1108928286, -1108487635, 1028685770, -1134533769)
		 + W(2, 1055064995, 1054737968, 1061839865, 1057524464) + W(3, 1062722401, 1039434185, 1053936411, 1054765971)
		 + W(4, -1094744478, -1108714620, -1089137095, -1081607655)
		 + W(5, -1111400813, -1089739654, 1037008853, -1094983833)
		 + W(6, -1110864465, 1035506764, -1103907470, -1115102560)
		 + W(7, 1038105413, -1103382940, 1038153674, -1101904010);
	sum2 = W(0, 1046625968, -1114205611, -1097342682, -1079666171)
		 + W(1, 1041595755, 977545170, -1106070846, -1145403458) + W(2, 1034733544, -1100522159, 1034693600, 1066071967)
		 + W(3, -1087077400, 1062799024, -1097179722, 1015933409)
		 + W(4, -1147999170, -1093312378, 1057288295, 1059803421)
		 + W(5, -1088579916, 1057064650, -1086854504, 1055355590)
		 + W(6, 1026537136, -1103988998, 1049229753, -1114956972)
		 + W(7, -1104980683, 1050850828, 997711860, -1115357129);
	WS(1033636603, -1075190676);
	sum1 = W(0, 1030520392, -1125697208, -1114269946, -1109653337)
		 + W(1, -1102211630, 1032435172, -1120127764, 996293820) + W(2, 1051253486, 1043969999, 1058583983, 1064791929)
		 + W(3, 1057642082, 1055881859, 1033241689, 1053053914)
		 + W(4, -1096251285, -1100430004, -1085953223, -1093290764)
		 + W(5, -1088005167, -1098086422, -1102333361, -1119839106)
		 + W(6, -1117233131, -1122877346, 1036037681, -1109909101)
		 + W(7, -1123582788, 1029223000, -1125435099, -1103406294);
	sum2 = W(0, -1120200303, 1024626781, 1013431061, -1124733431) + W(1, 1027814217, 999438554, -1116912567, 1007930813)
		 + W(2, -1113787644, 1041562727, -1114475538, -1112371618)
		 + W(3, 1032748777, -1098117165, 1042886038, -1140542509)
		 + W(4, -1109535466, -1106166077, 1029531851, 1051805575)
		 + W(5, 1061661699, -1114245048, 1039886302, -1093997696)
		 + W(6, 1041916719, 1028143351, -1097688999, 1068535590)
		 + W(7, 1074776935, 1029048009, -1076933565, -1072079702);
	WS(1051996799, 1040628126);
	sum1 = W(0, -1106876926, 1042171100, 1014013938, 1040804174) + W(1, 1038633599, 1024260165, 1032103150, -1111941370)
		 + W(2, -1096999331, -1106536569, -1087433914, -1079279688)
		 + W(3, -1085040172, -1090750082, -1096245875, -1091794355)
		 + W(4, 1064227732, 1056769919, 1057736892, 1052514885) + W(5, 1059334684, 1058371760, 1051111478, 1050507101)
		 + W(6, 1032518006, -1132737450, -1121739327, 1035728257)
		 + W(7, -1115112214, -1126170017, -1129820331, 1036168684);
	sum2 =
		W(0, -1097197656, 1040517176, -1107105879, 1050425804) + W(1, -1108102513, 1044838414, 1026907274, 978890108)
		+ W(2, -1105938617, -1119182790, 1048788314, 1048225474) + W(3, 1050055380, -1097162220, 1028263310, 1043193320)
		+ W(4, -1063141508, -1072247475, 1073986693, 1082212097)
		+ W(5, 1063649950, -1108483496, 1040597170, -1096883524) + W(6, 1047663602, -1106333570, 1017343300, 1014706728)
		+ W(7, 1023560998, -1105252179, 1016727612, 1025416282);
	WS(-1079662656, 1075711984);
	sum1 = W(0, -1136749190, -1108214827, -1112256994, -1102094902)
		 + W(1, 1019461885, -1113236619, -1115387518, 1015637672) + W(2, 1054381451, 1049467004, 1060357369, 1064079536)
		 + W(3, 1058102849, 1050217386, 1046694646, 1053154499)
		 + W(4, -1099895821, -1104318006, -1094055613, -1088977984)
		 + W(5, -1094018397, -1093377643, -1102869707, -1097489705)
		 + W(6, -1111920714, -1124862997, -1099490085, -1093653775)
		 + W(7, 1047054555, 1026036560, -1122648846, -1117787456);
	sum2 = W(0, 1021596406, 1027700788, 1031902674, 1035450862) + W(1, -1146279384, 1036068426, -1108044351, 1030087008)
		 + W(2, -1120307380, 1049653321, -1100871897, 1054975194)
		 + W(3, -1106853601, 1042197470, 1034125536, -1133477273) + W(4, 1037868882, 1038499992, 1074972319, 1073269037)
		 + W(5, 992333684, 1032586692, -1129244749, 1010404410)
		 + W(6, -1094559059, -1099826066, -1070411479, -1076192259)
		 + W(7, 1024067187, -1107184127, 1032061183, -1104237818);
	WS(-1121360374, -1077155152);
	sum1 = W(0, -1105583845, 1042009047, -1135496901, 1057317824)
		 + W(1, 1037107234, 1028773828, 1042777544, -1116736729)
		 + W(2, -1092428892, -1091586093, -1087526962, -1088356100)
		 + W(3, -1084718223, -1086275726, -1096882940, -1086839898)
		 + W(4, 1053987635, 1057449542, 1037542524, 1067018703) + W(5, 1053143538, 1051794540, 1049337758, 1050512766)
		 + W(6, 1036329976, 1039912928, -1114441548, 1035631092) + W(7, 1024846769, 1020991498, 1032759069, 1041911145);
	sum2 = W(0, -1122349048, 1027223630, -1123059666, -1097496437)
		 + W(1, -1101147358, 1008041239, -1113710228, -1103013196)
		 + W(2, -1108922684, 1050237475, -1093984844, 1061603028)
		 + W(3, 1054912466, -1136134543, 1050990810, 1037079763)
		 + W(4, -1102817435, 1047134367, -1086242189, 1069845393)
		 + W(5, -1091188340, -1107987422, -1126348732, -1097181289)
		 + W(6, 1024154790, -1105600910, 1041276041, -1090292072)
		 + W(7, -1122818012, -1109079234, 1047206075, -1109791787);
	WS(-1087087711, 1067831143);
	sum1 = W(0, 1034272753, 1043354114, 1046815315, 1041026663)
		 + W(1, -1116058688, -1131457456, -1115558139, 1032034947)
		 + W(2, -1110686621, -1094089577, -1090322161, 1019000899)
		 + W(3, 1048378971, 1054466495, 1045446607, 1043401342) + W(4, 1034360523, 1051348739, 1056352764, 1049291409)
		 + W(5, -1098372646, -1090870248, -1103803571, -1098529593)
		 + W(6, 1006467012, -1097882829, -1098171061, -1099191041)
		 + W(7, 1036956791, 1036945505, -1124941614, 1026141794);
	sum2 =
		W(0, 1046033632, -1114282503, 1044655964, -1106001859) + W(1, -1104436397, -1101664028, 1015764662, 1023732858)
		+ W(2, -1147554302, 1065651536, 1052996561, -1076523823)
		+ W(3, -1095873418, 1059971501, 1037179306, -1119149512) + W(4, 1021728539, 1061103542, 1047372498, -1081697027)
		+ W(5, -1094800655, 1058036758, -1113369666, 1033040332)
		+ W(6, 1034466187, -1117467216, 1040544990, -1105745303)
		+ W(7, -1119054372, -1110996319, -1120190386, 1028498617);
	WS(1040537598, -1164677141);
	sum1 = W(0, 1044447583, 987031402, -1121775302, 1042738997) + W(1, 1038434732, 1049696256, 1024826006, 1044766000)
		 + W(2, 1058921623, 1052904912, 1059494147, 1059765434) + W(3, 1053249925, 1045203303, 1049549231, 1032179929)
		 + W(4, -1079854668, -1089009751, -1082135643, -1085199868)
		 + W(5, -1087718171, -1094593271, -1098502833, -1111725730)
		 + W(6, 1051360885, 1009017491, 1049103971, 1042102879) + W(7, 1037325507, 1033340813, 1040792940, -1103499809);
	sum2 = W(0, -1105450770, -1099930216, -1087670985, -1097641768)
		 + W(1, -1093727900, 1034849198, -1089823109, 1026936119)
		 + W(2, -1076904032, -1110661913, 1054929191, 1067640588) + W(3, 1043325457, 1041628489, 1024934811, 1071055811)
		 + W(4, 1034745372, -1104228342, 1055270313, 1058849806)
		 + W(5, 1055379319, 1047258529, -1091022953, -1093861556)
		 + W(6, 1064235564, -1133206564, -1159337186, -1095527236)
		 + W(7, -1097371942, -1123329564, 1053074558, -1079977593);
	WS(-1072228928, 1076959210);
	sum1 = W(0, 1049440860, -1100954468, 1040518102, 1055014377)
		 + W(1, -1102413547, 1056933930, -1100924366, 1025160513)
		 + W(2, -1102211417, -1090494943, -1089397123, -1085929645)
		 + W(3, -1092416799, -1103710088, -1099959722, -1097219837)
		 + W(4, 1052420434, 1049042513, 1057628335, 1059399711) + W(5, 1055649007, 1056457065, 1043274798, 1043339918)
		 + W(6, 1046258910, -1094165323, -1113742940, -1115570152)
		 + W(7, -1095616949, 1054320058, -1096288332, -1113497047);
	sum2 =
		W(0, 1037249746, -1106259401, -1118512137, 1033553146) + W(1, -1118437421, 1049532353, -1112295163, -1112769969)
		+ W(2, -1091193116, 1057292562, 1045032769, -1101074553) + W(3, 1047290760, -1085599381, 1045403080, 1036239865)
		+ W(4, 1058952598, -1089499743, 990544085, 1052938455) + W(5, -1096914685, 1060306657, -1095081062, 1036770528)
		+ W(6, -1099278743, 1035766214, -1120311473, -1107284433)
		+ W(7, 1032001159, -1105441959, 1037527897, -1117837555);
	WS(-1095248895, -1088416713);
	sum1 = W(0, 991086878, 1041397006, -1100414321, -1106522737)
		 + W(1, 1032194452, 1040515607, -1113785099, -1119710941)
		 + W(2, -1112623265, 1023033498, -1095527100, -1085500137)
		 + W(3, -1103431285, -1093888960, 1025813699, -1112974208)
		 + W(4, 1049658160, -1129854724, 1056723856, 1061179113) + W(5, 1050067968, 1055178889, 1027165141, 1044420741)
		 + W(6, 1025280780, 1018002536, -1101036339, -1098081679)
		 + W(7, -1121954805, 1040437430, -1107604207, -1122583614);
	sum2 = W(0, -1115281709, 1038308115, -1086190321, -1079410563)
		 + W(1, 1055352031, -1106071111, 1042421121, 999244165) + W(2, 1049351198, -1105447726, 1061131477, 1070791012)
		 + W(3, -1080774986, 1050939464, -1096576742, 1021655353)
		 + W(4, -1101546004, 1044927538, -1105825160, -1124003323)
		 + W(5, 1054621998, -1100497740, 1042910101, -1123561791)
		 + W(6, -1132663474, 1036918381, -1104633062, 1035199903)
		 + W(7, -1119052371, 1038597174, -1126972585, -1141223925);
	WS(1057802399, -1081431823);
	sum1 = W(0, -1122831751, -1131892376, 1041203877, 1034931072)
		 + W(1, 1020249162, 1023514439, -1183605377, -1102408215)
		 + W(2, -1093480916, -1097592621, -1087992005, -1086955360)
		 + W(3, -1094219074, -1099624791, -1104094712, -1103351679)
		 + W(4, 1050038833, 1050095280, 1058335651, 1062569267) + W(5, 1052617634, 1053253320, 1037479577, 1047799764)
		 + W(6, 1031929377, 1003466633, -1150646211, -1108251076)
		 + W(7, -1123920403, -1110979235, 1022403704, 1031403703);
	sum2 =
		W(0, -1104748298, 1035677532, -1097271446, -1071563129) + W(1, -1073203825, -1105574565, 1074066983, 1076846054)
		+ W(2, 1032567526, 1015597088, 1042180726, -1131466492) + W(3, -1088097679, 1049167232, -1104411749, 1054919113)
		+ W(4, 1030425414, -1106402955, 1036072793, 1026492053) + W(5, 1021201077, 1046304011, -1108010622, 1040423027)
		+ W(6, 1028805714, 1010146816, -1122721452, -1139412188)
		+ W(7, -1121571686, 1013464552, -1115684312, -1159010626);
	WS(1057159391, -1098185256);
	sum1 = W(0, -1115997840, -1139848194, -1110900998, 1040272534)
		 + W(1, -1124007614, 1022311680, -1122049771, 1025640163) + W(2, 1062337777, 1059107990, 1058844902, 1060188982)
		 + W(3, 1050305613, 1055455830, 1052112283, 1058488623)
		 + W(4, -1099145229, -1096884471, -1083284577, -1081840204)
		 + W(5, -1086268415, -1088086212, -1093503993, -1095187909)
		 + W(6, -1108105457, 1026934458, -1128707950, 1050661700)
		 + W(7, 1025671020, 1018441343, 1032949738, -1115150240);
	sum2 = W(0, 1056249112, -1087901783, 1050240307, -1096100666)
		 + W(1, 1050011361, 1046757851, -1111613200, 1031802636)
		 + W(2, -1063663228, -1065703489, 1050922399, 1074103439) + W(3, 1078895155, 1075028289, 1011769164, 1041242105)
		 + W(4, -1090194820, 1049313091, 1059446328, -1091782161) + W(5, 1051412884, 999915799, -1097222567, 1040180956)
		 + W(6, -1098679170, 1049727089, -1118968312, 1043947681)
		 + W(7, -1103451878, 1046896549, 1036070334, -1120669738);
	WS(-1076050352, 1072169512);
	sum1 = W(0, -1112010473, -1110549812, 1041474168, -1102358403)
		 + W(1, 1035256808, -1103941101, -1126807163, -1127729580)
		 + W(2, -1127017300, -1096217239, -1101316183, -1098236010)
		 + W(3, -1097462672, 1015309803, -1109990262, -1124828306)
		 + W(4, 1032805651, 1055039585, -1107675851, 1058693100) + W(5, 1050718238, 1047069339, 1040782175, 1033573870)
		 + W(6, -1127012698, 1017026201, 1027743346, -1103052317)
		 + W(7, 1025923518, -1108585145, 1029935559, 1030091394);
	sum2 = W(0, -1115222730, -1103808603, -1133607278, 1035011293)
		 + W(1, 1045426354, 1005150868, 1038138903, 1014354189) + W(2, 1013406324, 1044516259, 1056099238, -1093760521)
		 + W(3, -1097063741, 1046105407, -1106358807, 1034790704)
		 + W(4, 1048651312, -1091636530, -1082257366, 1065398243)
		 + W(5, 1052543946, -1105190986, -1143243436, -1124610775)
		 + W(6, -1105744683, 1036643390, 1056116581, -1087652578)
		 + W(7, -1106429625, 1031045850, -1129675875, 1033997397);
	WS(1065781680, 1039008007);
	sum1 = W(0, 1041247860, -1132228043, -1116017645, 1029031978)
		 + W(1, -1114552992, 1018467582, -1119698444, 1039500994) + W(2, 1052873269, 1052030887, 1057769989, 1065817909)
		 + W(3, 1059292430, 1052683781, 1045381867, 1042767258)
		 + W(4, -1087848896, -1090939837, -1086321043, -1090130600)
		 + W(5, -1093123180, -1089813139, -1093950448, -1088918334)
		 + W(6, -1122380132, 1043969975, -1167945460, 1043124941)
		 + W(7, 1037414446, 1037105136, 1016187596, -1139723011);
	sum2 = W(0, 1038177586, 1024852101, 1031995320, 1016571646) + W(1, 1033741319, -1108656521, 1035134998, -1120710323)
		 + W(2, -1105284792, -1131141686, -1123455081, 999573799)
		 + W(3, -1107419527, 1052574782, -1099142208, -1103717942)
		 + W(4, -1114385091, -1105200928, 1057384109, 1073904332)
		 + W(5, 1075963065, -1130292726, -1072886122, -1070457563)
		 + W(6, 1023745983, 1044997454, -1102654886, 1045931554)
		 + W(7, -1113399825, 1041285787, -1101763500, 1044467987);
	WS(-1090516543, -1087531312);
	sum1 = W(0, -1105337757, -1135375282, -1113059195, -1111479074)
		 + W(1, 1044282546, 1036163039, -1123738614, -1110047807)
		 + W(2, 1040358473, 1025750638, 1034124454, -1082649657)
		 + W(3, -1098312091, -1114570479, -1112260786, 1044483760)
		 + W(4, 1026287071, -1109155234, -1111070925, -1113637434)
		 + W(5, 1056333811, 1044131649, 1049914271, 1039433994) + W(6, -1112133319, 1043065477, 1049735832, 1048811350)
		 + W(7, -1104740686, -1111303053, -1128712224, -1136462731);
	sum2 =
		W(0, -1122757257, 1009904581, -1113467627, -1099518373) + W(1, 1032421699, -1095677862, 1020800146, -1112743661)
		+ W(2, 1027164873, -1112829049, 1020364514, 1064179702) + W(3, -1092934445, 1039050377, -1106885375, 1022655162)
		+ W(4, 1002742314, -1115430893, -1098221748, 1059311413)
		+ W(5, -1139891301, 1041708988, -1124766450, 1032689603)
		+ W(6, -1111953049, -1116391321, 1025748661, -1098741962)
		+ W(7, 1036551469, -1119491053, 1025848261, -1122814953);
	WS(1059528063, 1057564569);
	sum1 = W(0, 993737087, 1023855952, 1051519336, -1100822612) + W(1, 1027584566, -1109486813, -1127107174, 1035631854)
		 + W(2, -1096201122, -1112481934, -1089271861, -1101379550)
		 + W(3, -1129312776, -1101173547, 1031993577, -1097162722)
		 + W(4, 1052073475, 1044928820, 1057871347, -1090210244) + W(5, 1027452795, 1051680014, 1038521522, 1050823828)
		 + W(6, 1036364765, -1119101474, 1026047377, -1095066725)
		 + W(7, 1043887545, 1038809676, -1152581582, 1037595092);
	sum2 =
		W(0, -1106514375, 1034094594, -1112949179, 1009317700) + W(1, -1126355148, 1021633582, 1010987268, -1106252693)
		+ W(2, -1115270098, 1029678117, -1095879627, 1052560633) + W(3, -1128108776, 1034084538, 1040297892, 1049223604)
		+ W(4, 1025588625, -1103891997, 1029083209, 1062070608) + W(5, -1100067512, 1035054672, -1117785257, 990783407)
		+ W(6, -1109616345, 1044342701, -1107320484, -1103446924)
		+ W(7, -1131810302, -1098743078, -1123491293, -1102218346);
	WS(1061977215, -1122204685);
	sum1 = W(0, -1124031333, -1109554099, -1105250724, 1036027519)
		 + W(1, 959521497, 1055353398, 1038275624, -1136942561) + W(2, 1053794732, 1053305789, 1058003360, 1059361796)
		 + W(3, 1055117810, 1051669497, 1037705519, 1047158647)
		 + W(4, -1090279300, -1096176108, -1093816822, -1081723655)
		 + W(5, -1090510080, -1097892492, -1101480172, -1098784634)
		 + W(6, 1017895407, 1027213295, 1024566052, 1033714163)
		 + W(7, -1125004641, 1006220452, -1112881733, -1145512357);
	sum2 = W(0, -1113155109, 1032430477, -1105712018, 1048044904)
		 + W(1, -1081128362, -1070110178, -1092435520, -1092804751)
		 + W(2, 1028856727, 1021325630, 1050891972, 1070862297) + W(3, 1074403261, 1035516985, -1108990845, -1122256510)
		 + W(4, 993552399, -1128331832, 1042508384, 1042132916) + W(5, 1044319918, -1115800491, 1033559089, -1109033129)
		 + W(6, 1036996819, -1139715524, -1111526035, 1040898786)
		 + W(7, 1025048067, 1038841221, -1119663830, 1007165668);
	WS(-1096328959, 1070879408);
	sum1 = W(0, 1047483149, -1131726569, 1017405984, 1016192218)
		 + W(1, -1134185032, -1130210629, 1039283496, 1022798351) + W(2, 1056909741, 1050717891, 1049879450, 1064784543)
		 + W(3, 1054175424, 1055866677, 1052923070, 1050331269)
		 + W(4, -1084253114, -1097194674, -1084428714, -1088019878)
		 + W(5, -1087922381, -1096076442, -1098682228, -1089646420)
		 + W(6, 1043610432, -1120381614, 1029856307, 1046790989)
		 + W(7, 1044095416, -1106891777, 1045347898, -1103492015);
	sum2 =
		W(0, -1096731787, 1041094096, 1030029833, -1134738767) + W(1, -1112066554, 1049526473, -1103571503, 1038503381)
		+ W(2, -1092572599, -1083918511, -1081752188, 1050600846) + W(3, 1060518769, 1056806956, 1052566197, 1040255570)
		+ W(4, -1072213302, -1081783724, -1088492050, -1098909280)
		+ W(5, 1054813136, 1066457366, 1061557517, 1074348460) + W(6, 1074300082, 1061218424, 1062246408, 1055931246)
		+ W(7, 1030722387, -1080408758, -1082314750, -1074863778);
	WS(-1093955647, 1022010191);
	sum1 = W(0, 1027472455, -1118029508, 1017520774, -1100976252) + W(1, 1048038797, 1019653215, 1015004427, 1006149335)
		 + W(2, 1051129150, 1040858863, 1058284788, 1064764899) + W(3, -1094249656, 1054989120, -1137681219, 1047833420)
		 + W(4, -1126583382, -1110637352, -1083829535, -1092969620)
		 + W(5, -1093269900, -1098669306, -1101321193, -1092663640)
		 + W(6, -1110971745, -1129027011, 1043546956, 1032062845)
		 + W(7, 1049944248, -1114080636, 1039113958, -1120661351);
	sum2 = W(0, -1125700855, 1010923567, -1097524591, -1086770251)
		 + W(1, -1119687254, -1136610695, 1034141799, -1146172877)
		 + W(2, -1109340305, -1099241242, -1097784845, 1061340682)
		 + W(3, -1091236020, 1059369820, -1103210716, 1042204527)
		 + W(4, 1041739108, -1121076246, -1122648580, 1059475190)
		 + W(5, -1097965354, 1048517727, 1020884025, -1117941982)
		 + W(6, -1138307987, 1010348245, 1043843262, -1104554020)
		 + W(7, 1042867821, -1105357691, 1021404807, 1026766467);
	WS(1057685119, 1067243116);
	sum1 = W(0, -1129459555, 1016923756, 1004671913, -1095493364)
		 + W(1, -1098633785, -1112175056, 1046138501, -1131471418)
		 + W(2, -1098308652, -1100618635, -1090418529, -1088191051)
		 + W(3, -1089905135, -1101363479, -1106099897, -1097291652)
		 + W(4, 1053516928, 1049587364, 1057639529, 1065512192) + W(5, 1058720438, 1052631981, 1043712557, 1052947846)
		 + W(6, 1029422892, -1111775882, -1114348966, -1112549294)
		 + W(7, -1103551521, -1111153757, 995391206, 1020473821);
	sum2 =
		W(0, -1131225411, -1130956898, -1103681442, -1077027280) + W(1, -1076028808, 1031803188, -1101294062, 949706042)
		+ W(2, -1140292462, 1023877693, 1042914798, 1069127322) + W(3, 1071847872, -1103125793, 1043076855, -1132087796)
		+ W(4, 1018110051, -1137158572, -1224504659, 1043315619)
		+ W(5, -1120948958, 1043270022, -1113817590, 1015417250)
		+ W(6, 1018006973, -1128428036, 1020723155, -1147115303) + W(7, 1020554514, -1133954299, 990350747, 1025989218);
	WS(-1097928959, -1082976358);
	sum1 = W(0, 1027664520, -1123678010, -1106569905, 1052451146)
		 + W(1, -1103556709, 1038567635, -1108799690, 1040222651) + W(2, 1057835343, 1050550727, 1057764410, 1062299789)
		 + W(3, 1049034640, 1057826487, 1041175724, 1060823717)
		 + W(4, -1089326063, -1096462854, -1083721351, -1087127986)
		 + W(5, -1097735566, -1094118206, -1100805265, -1089053734)
		 + W(6, -1108038941, 1032858337, 1021803093, 1042469806)
		 + W(7, -1104920125, 1031016631, -1129264698, -1107162784);
	sum2 =
		W(0, 1059738223, 1048150071, 1052511773, -1080186607) + W(1, -1078381471, -1072132845, -1071450961, -1071397334)
		+ W(2, -1087082495, -1095900368, -1108343021, 1063110279) + W(3, 1074904245, 1071639576, 1076364217, 1077341373)
		+ W(4, -1092378156, 1046247330, 1033545850, -1090059649)
		+ W(5, -1107095292, 1039712953, -1113577164, 1049211915) + W(6, 1034470847, 1025055065, 1045395587, -1094453880)
		+ W(7, 1053230483, -1103894182, 1032308634, -1120241798);
	WS(-1093482751, 1040242403);
	sum1 = W(0, -1101135214, -1123956286, -1107524598, -1138012647)
		 + W(1, 1034129455, 1042720691, -1130324184, 998898338) + W(2, 1051279307, 1045008905, 1049489177, -1132973569)
		 + W(3, -1096848358, -1098383795, -1104810279, -1118268600)
		 + W(4, -1160860306, -1106067054, -1101021318, -1113266773)
		 + W(5, 1049504725, 1059206814, 1049756222, 1052043149)
		 + W(6, -1112732162, -1135242283, 1029341500, -1121978915)
		 + W(7, -1098727290, -1102892456, -1104163113, -1099073308);
	sum2 = W(0, 1050603120, -1101078445, 1048531671, -1105220793)
		 + W(1, -1091713187, 1034851673, -1122031169, 1020293663)
		 + W(2, 1055811875, -1122671355, 1038805789, 1066111209)
		 + W(3, 1026095418, -1130092003, -1137910742, -1094690648)
		 + W(4, -1086548128, -1087609936, -1088336312, 1071017234)
		 + W(5, -1115602704, -1089969509, -1121274059, 1053616941)
		 + W(6, 1034695967, -1108269543, -1089139562, -1104320030)
		 + W(7, -1100901763, 1049804877, -1103744367, 1054827086);
	WS(-1112146683, -1077736475);
	sum1 =
		W(0, -1128590341, -1130792414, -1147973299, -1117834531) + W(1, 1007065251, 1033724609, 1024083798, -1122914526)
		+ W(2, -1099064529, -1090490649, -1086623314, -1101063739)
		+ W(3, -1084449173, -1094725676, -1097837640, -1097461352)
		+ W(4, 1049253908, 1028859267, 1040872136, 1068918685) + W(5, 1059458719, 1057886934, 1044653558, 1048946351)
		+ W(6, 1039097715, 1017948777, 1025770233, -1115616742) + W(7, -1104116690, -1132647657, 998082042, 1030833130);
	sum2 =
		W(0, 1038545045, -1104316542, -1098913527, 1054073276) + W(1, 990615436, -1111960943, -1127436605, -1131799749)
		+ W(2, 1044965772, -1073797636, -1069601753, 1079919017)
		+ W(3, 1065620582, -1103381017, 1039512539, -1105195767) + W(4, 1038508364, -1092377302, 1050236814, 1044931722)
		+ W(5, 1034922622, 1033398315, -1113162193, 1039327537) + W(6, 1032278560, -1115941315, -1109127211, 1042591612)
		+ W(7, 997021068, 1042220416, -1138197651, -1121388557);
	WS(-1090505151, -1074550453);
	sum1 = W(0, -1112838599, 1028498739, 1023419227, -1117182312)
		 + W(1, 1018948122, -1126145258, 1024711581, -1125422420)
		 + W(2, -1106878250, -1103427629, -1088602192, -1088941275)
		 + W(3, -1087514842, -1096920942, -1096615233, -1095073209)
		 + W(4, 1057615003, 1042960070, 1063645564, 1053033883) + W(5, 1058641540, 1043052986, 1050742275, 1053972531)
		 + W(6, -1131143051, 1023192930, -1096958907, 1048242260)
		 + W(7, -1098164287, 1045189988, -1105551137, 1026824959);
	sum2 = W(0, 1051549752, 1081443218, 1072492444, 1048388769)
		 + W(1, 1035162847, -1139079606, -1121149576, -1123800689)
		 + W(2, 1021553919, -1111116920, -1073777225, -1067599847)
		 + W(3, -1096587672, 1029232562, -1115288719, 1042218632)
		 + W(4, -1106404197, 1044837835, -1113676512, -1089379201)
		 + W(5, -1109546151, 1030543674, -1122606689, -1125599605)
		 + W(6, 1031994963, -1113046369, 1032624041, 1025956540)
		 + W(7, 1027498280, -1132168419, 1034044071, -1115044631);
	WS(1051119487, 1041244378);
	sum1 = W(0, -1124974044, 1028120435, 1048876359, 1037118035)
		 + W(1, -1131477080, -1118427428, -1120234265, -1125985859)
		 + W(2, -1137238551, -1113671305, 1036964902, 1061504071) + W(3, 1047204942, 1050660570, 1030267847, 1049717597)
		 + W(4, -1116593698, -1103177170, -1099611151, -1104164974)
		 + W(5, -1081804989, -1114906180, -1098831475, -1103929310)
		 + W(6, -1121323393, 1033078132, -1156053771, -1129960608)
		 + W(7, 1048068278, 1011539382, 1035846233, -1115091743);
	sum2 = W(0, 1018090488, -1104952272, -1105226064, -1128161694)
		 + W(1, -1134153828, 1024328280, -1118410723, -1117225997)
		 + W(2, 1027537220, 1048078363, 1055192952, -1102612387)
		 + W(3, -1102761937, -1101688104, 1035228556, 1016223417)
		 + W(4, 1019973834, -1095697091, -1101823824, 1074095781)
		 + W(5, -1074759173, 1063478353, -1092594125, 1041310640)
		 + W(6, -1117503915, 1045164128, -1106818318, -1087428157)
		 + W(7, 1061969021, -1092430375, 1050476000, -1110796930);
	WS(1062303263, 1031082743);
	sum1 = W(0, -1113216195, -1099215391, 1052151297, 1026092610)
		 + W(1, 1051942565, -1098039588, -1101893697, 1008063218) + W(2, 1050954912, 1012178225, 1065129152, 1047492794)
		 + W(3, 1063700475, 1049517720, 1028060738, 1054989200)
		 + W(4, -1095964628, -1095180416, -1088785601, -1089641431)
		 + W(5, -1089295544, -1091476104, -1102410709, -1096414030)
		 + W(6, -1121789260, 1027015379, 1041954507, -1107401421)
		 + W(7, 1049634587, -1112964196, 1035520455, -1114231491);
	sum2 = W(0, 1033145987, -1111827051, -1103256184, -1063595607)
		 + W(1, -1101985731, -1141099147, -1136421288, 1030655939)
		 + W(2, -1175661064, -1152013649, 1050523165, 1084357731)
		 + W(3, 1048919805, 1025442742, -1145624409, -1133270551)
		 + W(4, 1021827842, -1104895942, 1034611383, -1094652398)
		 + W(5, 1029250458, -1102082303, 1021034188, -1121842648)
		 + W(6, -1165845202, -1187919119, -1125020091, 1042933311)
		 + W(7, -1108910008, 1040766920, -1126731425, 1017996705);
	WS(1057958943, -1104691893);
	sum1 =
		W(0, -1111014615, -1128240917, -1146251723, -1095236657) + W(1, 1047913107, -1103203951, 1033356080, 1023941889)
		+ W(2, -1105424217, 1046008396, -1090082375, 1054329938) + W(3, 1003615948, 1013130820, 1044802714, -1101796865)
		+ W(4, 1044401084, -1100901945, 1057785284, 1040293502) + W(5, -1099597392, 1051440085, -1102604718, 1036253756)
		+ W(6, -1118336456, 1038452148, -1119525902, -1093887914)
		+ W(7, 1045607070, -1107674167, -1113361665, 1037874639);
	sum2 =
		W(0, 1010987018, -1105807463, -1102396693, 1054217500) + W(1, -1123211893, 1029628166, -1106898625, 1028744914)
		+ W(2, 1041119120, -1111572952, -1117220749, -1087890507)
		+ W(3, 1070205457, -1101117061, -1113015450, -1121743361)
		+ W(4, -1110188142, 1045029856, 1057260834, -1087358521)
		+ W(5, -1081682663, 1051101181, 1042553654, -1135525482) + W(6, -1127404253, 1029477872, 1019931869, 1056265374)
		+ W(7, -1091128546, -1124058781, 1025549544, 992401866);
	WS(1063883327, -1171419961);
	sum1 = W(0, -1131801844, 1021098616, 1022023532, -1121742227)
		 + W(1, -1090925859, 1024490200, -1102607801, -1123544461)
		 + W(2, 1049833398, -1123871229, 1009731296, 1044941350) + W(3, 1060653970, 1043051923, 1048967870, 1050859794)
		 + W(4, -1102183011, -1097479398, 1056730033, 1041013425)
		 + W(5, -1095529687, -1097251239, -1104750961, -1097963532)
		 + W(6, -1101850371, 1031224740, -1123343997, -1127214008)
		 + W(7, -1107029405, 1042080318, -1107657120, 1009310536);
	sum2 = W(0, -1106082604, 1041248381, -1132935321, -1106587714)
		 + W(1, -1104172881, -1118244665, -1115368488, -1139264801)
		 + W(2, 1047581965, -1108094251, -1111186257, 1050591326)
		 + W(3, 1039028256, 1025922877, -1111866155, -1104769894)
		 + W(4, -1097195715, -1105642610, 1042983438, 1048334662)
		 + W(5, 1046273630, -1128737701, 1044426238, -1122157893)
		 + W(6, -1113941985, -1131232309, 1050509566, -1103031697)
		 + W(7, -1127691207, -1115007353, -1112751356, 1031938310);
	WS(1064944927, 1037595256);
	sum1 = W(0, -1116864018, 1023806679, 1017115436, 1009660557)
		 + W(1, 1028149000, -1109610248, -1148661421, -1102752831)
		 + W(2, -1089228760, -1095304482, -1087165700, -1086682215)
		 + W(3, -1088874517, -1099761351, -1116139780, -1131587330)
		 + W(4, 1063040538, 1057549004, 1060715233, 1064233001) + W(5, 1056983460, 1052917089, 1041500021, 1045020525)
		 + W(6, -1107296590, -1106875789, -1103245163, -1106392275)
		 + W(7, -1132085516, -1107160974, -1129006079, -1152394658);
	sum2 =
		W(0, 1045832950, -1110716731, 1025147898, -1098226948) + W(1, -1099749141, -1098250414, 1042544569, -1089530617)
		+ W(2, -1084008560, 1049995423, -1089165996, 1066542501) + W(3, 1049362032, 1055260506, -1086997229, 1067285885)
		+ W(4, -1084775302, -1093173621, 1054478967, 1068786857)
		+ W(5, 1047038722, -1126019654, -1127724076, -1088213452)
		+ W(6, 1058474163, -1102301410, -1128684365, 1031931484)
		+ W(7, -1091779956, -1105326436, 1053449115, -1090548395);
	WS(-1082101344, -1089856493);
	sum1 = W(0, 1050831902, -1112019073, 1030303546, -1129997454)
		 + W(1, -1110327174, -1117704076, -1112251093, -1131596868)
		 + W(2, -1105691402, 1030717682, 1055521064, 1064695661) + W(3, 1061962758, 1058754169, 1047731210, 1056158989)
		 + W(4, -1101015969, -1098775681, -1097748442, -1085520515)
		 + W(5, -1086646154, -1089610799, -1093958751, -1094349907)
		 + W(6, 1029275441, -1120813832, -1139280937, 965412887)
		 + W(7, 1041358014, -1122362798, 1028938947, 1016935004);
	sum2 =
		W(0, -1065128139, -1076824095, 1067439244, 1079260085) + W(1, 1056740148, -1103928218, -1135208116, 1039164015)
		+ W(2, -1101130808, 1050826865, 1046966330, 1049869634) + W(3, 1051236860, -1114183173, 1033256035, -1104627926)
		+ W(4, 1034565987, -1109355365, -1109830496, -1112614302)
		+ W(5, -1123646153, 1051726295, 1035002893, -1109091637) + W(6, -1119435550, 1023890205, 1012867020, 1015248786)
		+ W(7, -1122661198, -1136992532, -1119472799, -1136910724);
	WS(-1090711679, 1035967541);
	sum1 = W(0, -1111795270, 1015715144, -1118064815, -1124564760)
		 + W(1, 1033380937, 1041725555, 1039158191, 1036708611)
		 + W(2, -1104454427, 1029360119, -1084526809, -1083278737)
		 + W(3, -1083950349, -1091233609, -1102432923, -1097260861)
		 + W(4, 1050513973, 1050454265, 1063535365, 1060834888) + W(5, 1050327592, 1054941014, 1040417584, 1042099839)
		 + W(6, 1030482278, -1138269301, -1132452908, 1007072853)
		 + W(7, 1028355007, 1029566323, -1140656289, 1035976950);
	sum2 = W(0, 1030795338, -1104698754, -1086482027, -1086674278)
		 + W(1, 1048689193, -1101252049, -1127107620, -1097010897)
		 + W(2, -1099705557, -1088930785, -1087114188, 1063363970)
		 + W(3, 1066258058, 1055138353, -1113111809, 1050900036)
		 + W(4, -1100315818, -1129318753, -1088371087, 1059258270)
		 + W(5, 1052412907, 1035784301, -1107499570, 1046424313) + W(6, -1124401732, 1047822852, 1041847465, 1007827043)
		 + W(7, -1114489829, 1039056173, 1036879119, -1112035485);
	WS(-1098505599, -1075865372);
	sum1 = W(0, -1119631078, 1024188415, -1125460739, -1113150415)
		 + W(1, -1098117352, 1028789822, -1115205937, -1134520549)
		 + W(2, -1131715643, 1032178901, 1056750314, 1055366257) + W(3, 1063530169, 1038512989, 1036256496, 1042179631)
		 + W(4, -1121509433, -1128987132, -1131145214, -1096447994)
		 + W(5, -1086227497, -1117796833, 1016180195, 1032402616)
		 + W(6, -1113178620, 1024883696, -1114020928, -1102601578)
		 + W(7, -1111953177, -1101470933, -1141768534, -1114797153);
	sum2 = W(0, -1098762498, -1112826554, -1099883844, -1090598021)
		 + W(1, 1060690639, -1101866176, 1051055486, -1111565268) + W(2, 1039073687, 1047439072, 1024348972, 1068429254)
		 + W(3, -1078855206, 1052294530, -1095975199, 1034134076) + W(4, 1035541163, 1032611741, 1050751610, 1066295533)
		 + W(5, -1081223881, -1097770507, -1126362074, -1121819739)
		 + W(6, 1030962008, 981436096, 1048715774, -1089341195) + W(7, -1094541311, 1041458546, 1044471119, 1024624177);
	WS(1057165023, -1106509195);
	sum1 = W(0, -1110663097, 1023353031, 1009641338, -1116674588)
		 + W(1, -1121179137, -1127866586, 1019708412, -1105922998)
		 + W(2, -1090373040, -1094296089, -1087820187, -1090764772)
		 + W(3, -1101809276, -1095695571, -1097119704, -1088811352)
		 + W(4, 1057389257, 1051297995, 1064196683, 1064337073) + W(5, 1058239248, 1053143796, 1049182394, 1042633923)
		 + W(6, 1036322023, -1110472134, -1103525103, -1108191858)
		 + W(7, -1105116828, -1130262917, -1117889432, 1047174317);
	sum2 = W(0, -1112942365, 1048482322, -1100072975, -1097118067)
		 + W(1, 991349250, -1108096389, 1053525633, 1000921969) + W(2, -1106822390, -1115190843, 1034045428, 1068163863)
		 + W(3, 1063618710, -1107942623, -1090492700, -1076676559)
		 + W(4, -1102090209, 1042851055, -1103979279, 1056641862)
		 + W(5, -1105663689, 1049912171, -1130278628, -1111476815)
		 + W(6, 1043730009, 1035412483, -1105576965, 1028572696)
		 + W(7, -1113934073, -1105853831, 1039916278, -1106999228);
	WS(-1086493375, -1079336981);
	sum1 = W(0, 977772865, -1123924042, -1109993624, -1107908519)
		 + W(1, 1036636329, 1038934102, 1034769240, -1099048778)
		 + W(2, -1102983835, -1108602044, 1041059645, -1094902379)
		 + W(3, -1083260999, -1084987377, -1102484540, -1108629750)
		 + W(4, 1026410857, -1098146918, -1106936850, 1061697492) + W(5, 1061962303, 1057432285, 1051050960, 1050989872)
		 + W(6, 1015269519, 1049374456, 1036994068, 1041174790)
		 + W(7, -1103125248, -1125738921, -1130650164, 1040252563);
	sum2 = W(0, -1104970914, 1018133697, 1040842491, -1093587851)
		 + W(1, -1093237537, -1102375178, -1099804326, 1054809337)
		 + W(2, 1042634099, -1097448347, 1055662701, 1074010545)
		 + W(3, -1089724369, -1099392752, 1049771835, -1092159031)
		 + W(4, 1052960430, -1108255972, 1062139198, 1064732329)
		 + W(5, -1083390778, 1025575413, -1104347883, -1096888027)
		 + W(6, -1112577728, -1096543501, -1090800341, -1093194079)
		 + W(7, 1015865539, 991452982, -1126119433, 1028159711);
	WS(-1088469887, 1068090411);
	sum1 = W(0, -1113244581, -1123900274, 1049496346, -1110903326)
		 + W(1, -1119953152, 1031904934, 1034227191, 1025939062) + W(2, 1001301201, 1023861926, -1082959002, 1050701400)
		 + W(3, 1060902689, 1043052181, 1043817559, 1038313117) + W(4, -1115331947, 1035790701, 1057295251, 1048296635)
		 + W(5, -1081663133, -1113327662, -1110964279, 1034951606)
		 + W(6, -1124374314, -1105829923, -1096521435, -1119292644)
		 + W(7, 1048590454, 1027826066, -1106468266, -1117293966);
	sum2 =
		W(0, 1046922708, 1033420508, -1112865289, -1096930035) + W(1, -1101802092, 1017341032, 1036773342, -1107450994)
		+ W(2, -1106472578, -1114867820, -1087802072, 1058113813)
		+ W(3, 1050476308, -1103417477, -1105807138, 1033379085) + W(4, 1033443280, -1109208012, 1020845388, 1048730658)
		+ W(5, 1059721445, -1107242470, -1136542442, -1104249476)
		+ W(6, -1111979165, 1050643686, -1101832932, -1129026525)
		+ W(7, -1104558996, -1135034393, 1037376476, 1023773731);
	WS(1052578175, -1092643724);
	sum1 =
		W(0, -1106584961, 1030893452, 1033955624, 1037358070) + W(1, 1036710537, -1128189432, -1118327615, -1129060558)
		+ W(2, -1102735475, -1100779014, -1082492039, -1086815439)
		+ W(3, -1088009424, -1095075429, -1106908643, -1102841939)
		+ W(4, 1053304083, 1049737317, 1060101900, 1065824329) + W(5, 1041943502, 1057719155, 1051335460, 1036237087)
		+ W(6, 993436516, 1037510015, -1101687426, -1103135573) + W(7, 1029815263, 1040440469, -1106074638, 1027836379);
	sum2 = W(0, -1115440098, 1029771501, 1018065220, 999202537) + W(1, 1036811205, -1111720654, -1125064265, 1019498859)
		 + W(2, 1015710974, 1033337736, -1094728975, 1039453548) + W(3, 1050012979, 1032576025, -1103861773, 1040788513)
		 + W(4, 1041402597, -1114856806, 1037520917, 1064530169)
		 + W(5, -1094040689, 1073761042, 1063409170, -1090935047)
		 + W(6, -1130229431, 1034787000, -1082769104, -1074584982)
		 + W(7, -1090370130, 1032162938, -1105633547, 1034133532);
	WS(-1104397694, 1058392920);
	sum1 = W(0, 1012876448, -1126111401, -1142522206, -1115125816)
		 + W(1, -1103048369, 999529969, 1016404519, -1117545451) + W(2, 1051523414, 1050625047, 1043902243, 1063861817)
		 + W(3, 1056801600, 1053396405, 1042081404, 1054067798)
		 + W(4, -1094911217, -1106828476, -1089440467, -1093833780)
		 + W(5, -1087921625, -1107310585, -1104958721, -1097217844)
		 + W(6, 1023486907, 1033392977, -1119682235, 1019625524)
		 + W(7, -1096529922, 1015514383, 1039287934, -1113687714);
	sum2 = W(0, -1130009672, 1027809153, -1106384796, 1051460883)
		 + W(1, -1104521112, 1033821004, -1112259960, 1028508475)
		 + W(2, 1013515790, -1106180134, 1042067106, -1094561503)
		 + W(3, 1032257325, -1124940473, -1168427353, -1120291522)
		 + W(4, 1013756514, 1023886448, 1052609397, 1078005003) + W(5, 1072194837, -1094906083, 1046140857, -1140922271)
		 + W(6, -1153587550, 1024050371, -1094102229, -1070026280)
		 + W(7, -1075632186, 1053282219, -1098407638, 1033718481);
	WS(1063327007, -1121248448);
	sum1 = W(0, 1017612078, 1043030576, 1039059525, -1115811128)
		 + W(1, -1095615210, -1099887459, -1140707177, -1120397682)
		 + W(2, -1113236667, -1096763312, -1091103118, 1053297652)
		 + W(3, 1063340055, 1054079124, 1041492110, -1126620524) + W(4, 1042967269, 1049218219, 1058517677, 1033504868)
		 + W(5, -1082785422, -1088587000, -1101731443, 1029718569)
		 + W(6, 1035231217, -1115130868, -1107367965, 1009543939)
		 + W(7, 1047061435, 1042859328, -1120288724, -1104957341);
	sum2 = W(0, 1037909727, -1098298527, -1126569464, -1106955476)
		 + W(1, -1096969233, -1118592354, 1042882430, 1037216424)
		 + W(2, -1119813454, 1048025725, 1041835288, 1067026849)
		 + W(3, -1085288934, 1042571631, -1117602980, -1116313332)
		 + W(4, -1099212072, 1045330821, -1106229244, 1067954224)
		 + W(5, -1095495837, -1108169766, -1164085849, -1100305071)
		 + W(6, 1032936033, -1097673782, -1109675885, -1092590328)
		 + W(7, 1004812688, -1096486003, 1034064234, 1045459772);
	WS(-1114652667, 1051933605);
	sum1 = W(0, 1026700110, 1037508767, -1128033780, 1034155035)
		 + W(1, -1102462575, 1024543544, -1147042251, 1032374633)
		 + W(2, -1102428549, -1105027032, -1106431647, 1043250735)
		 + W(3, 1059213449, 1038435705, 1038748492, 1016229610) + W(4, 1043087092, 1048715843, 1062796090, -1089603768)
		 + W(5, -1090890112, -1106007014, -1119096106, -1104514210)
		 + W(6, -1109604752, -1113263092, -1098797270, 1023780992)
		 + W(7, -1112475685, -1121524254, 986589794, 1007891224);
	sum2 = W(0, -1129141996, -1106880495, 1031191254, -1102244397)
		 + W(1, -1101040753, 1046080919, -1112883155, 1031234782)
		 + W(2, 1043866561, -1096921120, -1123077406, 1064276171)
		 + W(3, 1061828176, -1095750750, 1042185570, -1128566730)
		 + W(4, 1029019378, -1092013580, -1086673510, 1064706574)
		 + W(5, -1113110329, -1091369762, 1042119352, -1105256367)
		 + W(6, 1050935854, -1111274547, -1096956427, -1115781076)
		 + W(7, -1106057540, 1029696990, -1113619581, 1012473722);
	WS(1059465279, -1101420399);
	sum1 = W(0, 1033088680, -1124176798, 1014063089, 1035053989)
		 + W(1, 1045820204, 1038292302, -1115007182, -1131477704) + W(2, 1043444330, 1000916382, 1057398923, 1034190184)
		 + W(3, -1087528660, 1036787650, 1027988010, 1042732770)
		 + W(4, -1101682761, -1126261266, -1089602004, 1039770557)
		 + W(5, 1057859064, -1106381771, -1104773247, -1102530758)
		 + W(6, -1124073107, -1118729178, 1032573720, -1114558729)
		 + W(7, -1096323421, 1041172764, 1024683157, 1029511616);
	sum2 = W(0, -1093261173, -1100338012, 1016590929, -1160318928)
		 + W(1, -1111261089, 1032510827, 1037987285, -1106728517)
		 + W(2, -1081648717, -1096055698, 1049309077, 1060463741)
		 + W(3, -1123677731, 1042247124, 1035681279, 1035240533) + W(4, -1107343332, 1016623505, 1058913944, 1061699617)
		 + W(5, -1095509190, 988275856, -1111758125, 979544481) + W(6, 1020947921, -1121572837, 1035038069, -1121635630)
		 + W(7, -1116667427, -1130213341, 1033159595, -1112486763);
	WS(1060076127, 1072958059);
	sum1 = W(0, -1103118654, 1043365506, -1115420333, 1031523031)
		 + W(1, 1033412302, 1032254402, 1031863013, -1127560355)
		 + W(2, -1090537599, -1097065432, -1086314390, -1088162978)
		 + W(3, -1089193875, -1091959462, -1111327644, -1086013855)
		 + W(4, 1060753617, 1046496158, 1060760746, 1055888777) + W(5, 1052645932, 1054239287, 1044639698, 1056703661)
		 + W(6, -1129584897, 1025963976, -1106610556, 1040410096)
		 + W(7, -1138875303, 1032279415, 1032182482, 1044337291);
	sum2 = W(0, 1034238418, 1026722605, -1123083006, 1044566349)
		 + W(1, -1114043742, 1029836970, -1124457715, -1112207598)
		 + W(2, -1122429687, -1113650971, -1101416602, -1095747837)
		 + W(3, 1044375513, 1032414162, -1132025334, -1112893824) + W(4, 1038471498, 1047703041, 1050567163, 1073798913)
		 + W(5, 1074668356, 1076147895, 1076524889, 1071535287)
		 + W(6, -1105287037, -1106809975, -1099784158, -1077245954)
		 + W(7, -1072322090, -1070521946, -1071353549, -1076180558);
	WS(-1114470395, -1114976351);
	sum1 = W(0, 1017446070, 1040990896, -1129681934, -1120446036)
		 + W(1, -1097641691, -1110115727, -1110184487, 1033457695) + W(2, 991904560, 1041627584, 1047992216, 1061349282)
		 + W(3, 1061559014, 1055187519, 1045114861, 1047040436)
		 + W(4, 1034584479, -1107221597, -1115356259, -1083497834)
		 + W(5, -1089507216, -1098995485, -1109668803, -1107186297)
		 + W(6, -1110976571, -1099251857, -1111571481, 1039733326)
		 + W(7, 1036247843, -1114440077, -1115117640, -1120899067);
	sum2 =
		W(0, -1093678598, 1002676269, 1055748356, 1044340647) + W(1, -1118111722, -1120084888, 1001595675, -1123642691)
		+ W(2, -1084434022, 1057422860, 1066493380, -1079318791)
		+ W(3, -1116089022, 1044705221, -1112694927, 1031220790)
		+ W(4, 1064533419, 1067683118, -1078621547, -1079939901) + W(5, 1054002901, 1039926847, -1112070298, 1023903081)
		+ W(6, 1042743345, -1108978134, -1117769694, 1015093293) + W(7, 1049699290, 986467602, -1107171922, 1037662763);
	WS(1048785023, 1039045299);
	sum1 = W(0, -1104130562, 1043168659, -1117502116, 1029857553)
		 + W(1, 1034838603, 1027207566, 1024393315, -1130533431)
		 + W(2, -1090140327, -1100442863, -1085428843, -1093347651)
		 + W(3, -1089406196, -1093521697, -1120775857, -1086838999)
		 + W(4, 1061197562, 1040570004, 1062309944, 1050495728) + W(5, 1050259320, 1054560318, 1039464338, 1056208688)
		 + W(6, -1133671882, 1032880081, -1102819715, 1038995485)
		 + W(7, -1127149063, 1026681976, 1035433414, 1041402190);
	sum2 = W(0, -1118465298, 1011712973, -1128433260, 1029767219) + W(1, 1021354231, 982009542, 1014788797, 1033540398)
		 + W(2, -1142302474, 1025023956, 1041730218, -1097771962)
		 + W(3, -1094677866, -1122047812, 1028525757, 1020814500)
		 + W(4, -1114395216, -1104707163, -1095905892, -1080533844)
		 + W(5, -1075595300, -1072373863, -1072719492, -1078361330)
		 + W(6, 1037219807, 1039062755, 1046574176, 1069124140) + W(7, 1073795377, 1075522683, 1074436097, 1068741752);
	WS(1040594174, 1002085105);
	sum1 = W(0, 1041861603, -1097746587, 1032164980, 1031577622) + W(1, -1102982955, 1044101411, 1034678964, 1026039088)
		 + W(2, -1113198522, 1055071640, -1088672026, 1050744420)
		 + W(3, 1057599999, -1103363988, 1036351259, 1034848362)
		 + W(4, -1137236930, -1100468781, 1047493466, -1105375081)
		 + W(5, -1087672398, 1050064611, -1102178050, 1033863059)
		 + W(6, 1041085614, -1121524679, -1109849488, 1048884604)
		 + W(7, -1113508732, -1098107838, 1043931332, -1106488144);
	sum2 = W(0, -1099743490, 1035577370, -1115293072, -1102421679)
		 + W(1, 1038726510, 1032210717, -1107407193, -1120037205) + W(2, 1011906269, 1026663055, 1057096352, 979639118)
		 + W(3, 1044440375, 1032214892, 1028754425, -1123040177)
		 + W(4, 1037961444, -1152297667, -1095995741, 1050233559)
		 + W(5, 1022991474, -1139108605, -1115369483, -1104470915)
		 + W(6, -1108436276, 991169347, 1045881501, -1097952901)
		 + W(7, -1122343653, 1026937641, -1105994898, 1022469878);
	WS(1066613200, -1123971367);
	sum1 = W(0, 1021072883, -1125712504, 1041158633, -1106077125) + W(1, 1036847484, 1032267227, 1016782186, 1031886911)
		 + W(2, -1096708150, -1090955664, -1159875842, -1079911082)
		 + W(3, -1093258685, -1103560179, -1089925031, -1106725252)
		 + W(4, 1051074184, 1051398158, 1058934814, 1061682240) + W(5, 1055629981, 1054180539, 1052861897, 1047227273)
		 + W(6, 1026036124, -1108624754, 1040756057, -1090753503)
		 + W(7, -1114271443, 1025501945, -1105228376, 1043536294);
	sum2 = W(0, -1120579723, -1104595791, 1060943463, -1081375340)
		 + W(1, 1048074442, 1049316438, -1088959333, 1054216959)
		 + W(2, -1102098813, 1059079365, -1078775742, 1070420847)
		 + W(3, -1106373275, -1084015554, 1065759760, -1087995034)
		 + W(4, -1103583809, 1035649855, 1055196914, 1036446407) + W(5, 1050043459, 1050724789, -1088425301, 1052608338)
		 + W(6, 1039910130, -1110832147, -1115424415, -1092581761)
		 + W(7, -1101688097, -1115969635, 1051846236, -1103333947);
	WS(1015488492, -1082266482);
	sum1 = W(0, -1115294884, 1041881447, -1116482020, 1028536641)
		 + W(1, 1044897017, -1108243791, 1033207234, 1015505847)
		 + W(2, -1096364772, 1036768790, -1083421327, -1079950554)
		 + W(3, -1088856963, -1096513911, -1104622888, -1096156044)
		 + W(4, 1054950795, 1051075280, 1062057653, 1057564011) + W(5, 1054170231, 1056273768, 1056919206, 1054606378)
		 + W(6, -1109722877, 1018280484, -1105734603, -1124656723)
		 + W(7, -1129161159, -1113027740, -1132093050, 1025701004);
	sum2 =
		W(0, -1103335141, -1087173612, 1045744538, -1106751239) + W(1, -1089877767, 1054342226, 1047940388, -1120076732)
		+ W(2, -1123809016, -1080484881, 1068142929, 1065979347)
		+ W(3, 1048007586, -1086806497, -1098712592, -1082944418) + W(4, 1056172663, 1047550056, 1051886373, 1064817240)
		+ W(5, 1065470183, -1098340366, -1102735881, -1088981287)
		+ W(6, -1093357581, -1112078382, -1102262951, -1097769156)
		+ W(7, -1095892093, 1033891425, -1105000175, 1059622670);
	WS(-1089551423, -1072840444);
	sum1 = W(0, 1041019406, 1022173115, -1113297010, 1015463395) + W(1, -1103473726, 1040814976, 1007312016, 1029778436)
		 + W(2, 1055991358, 1057526040, 1036785718, 1059475300) + W(3, 1056836657, 1050051043, 1050846086, 1053584058)
		 + W(4, -1086576149, -1100702364, -1093552675, -1089572736)
		 + W(5, -1091007140, -1090411145, -1098618125, -1097362556)
		 + W(6, 1027645528, -1141651861, 1016689751, 1031793146)
		 + W(7, -1125097480, 1041821422, 1015074267, -1104623366);
	sum2 = W(0, 1069423067, 1072187327, 1072064387, 1072314518) + W(1, 1066704589, 1063804587, 1053139391, 1042659879)
		 + W(2, -1076703167, -1073855626, -1079134619, -1077864031)
		 + W(3, -1081021850, -1081933355, -1094622730, -1099654949)
		 + W(4, 1041694716, -1115348910, -1107764634, -1089838794)
		 + W(5, 1036250076, 1028352388, -1114321992, 1035224325) + W(6, 1032293264, 1008297781, -1120515458, 1037018177)
		 + W(7, -1121141704, 1025803257, -1123317222, 1027779018);
	WS(1053893247, -1106302313);
	sum1 = W(0, 1031892188, -1110506435, -1127073177, 1047997302)
		 + W(1, 1033243951, -1107646187, -1112186286, -1112631434)
		 + W(2, 1044357278, 1051962248, 1061666784, 1064449402) + W(3, 1041901099, 1053582704, 1037482077, 1050110011)
		 + W(4, -1093335703, -1098499127, -1085429924, -1082436051)
		 + W(5, -1118050391, -1104422127, -1118004236, -1103845867)
		 + W(6, -1124627014, -1121076939, 1038775118, 1042378233)
		 + W(7, -1100759903, -1107823800, -1134911574, -1111029158);
	sum2 =
		W(0, 1045534781, -1136883904, 1027794169, -1091599460) + W(1, -1105954111, -1110353364, 1026306116, -1105327762)
		+ W(2, -1106914963, -1105365809, -1087950271, 1049402813)
		+ W(3, 1059435817, 1056244223, -1106437513, 1049633694) + W(4, -1093884354, 1058094665, -1076257974, 1070891205)
		+ W(5, 1057695328, -1096007662, 1042940020, 1019026622) + W(6, 1048929407, -1099297773, 1057853479, -1101014716)
		+ W(7, -1088483015, -1116753268, -1107558514, -1111740866);
	WS(1043803134, 1031905225);
	sum1 = W(0, -1113675573, -1137620096, 1045527725, 1047471777)
		 + W(1, 1025442024, -1101766076, 1041363873, -1104559247) + W(2, 1045344728, 1015450714, 1036603287, 1057861093)
		 + W(3, 1007995990, 1048683192, -1103914745, 1053784172)
		 + W(4, -1093561052, 1039772705, -1087612823, -1131204708)
		 + W(5, -1109713128, -1098589181, -1142310312, -1096789826)
		 + W(6, -1125193272, -1142985628, 1043570724, 1032608022)
		 + W(7, -1125123818, 1017746514, -1137687994, -1120823545);
	sum2 = W(0, -1102611800, 1042572795, -1143715563, 1047906835)
		 + W(1, 1034463821, -1097650393, 1044772028, -1105069125)
		 + W(2, 1052608919, -1112317124, 1036000712, 1058925768)
		 + W(3, -1089628524, -1097284017, -1090965565, 1053414419)
		 + W(4, -1092971881, 1050084573, -1099050864, 1062269077)
		 + W(5, -1100033854, -1155008883, 1043620595, -1099181286)
		 + W(6, 1033368250, -1099740129, 1046340985, -1106615878)
		 + W(7, -1143169701, 1034459058, -1102441858, -1145018737);
	WS(1065606800, 1041895077);
	sum1 = W(0, 1041785011, -1113293285, 1031552121, -1114204019)
		 + W(1, 1014586031, 1032452466, -1103346054, 1025447425) + W(2, 1041397665, 1050236482, 1063682744, 1055253222)
		 + W(3, 1057927896, 1054837340, 1043307490, 1058487624)
		 + W(4, -1108226929, -1089967688, -1092426598, -1085544687)
		 + W(5, -1092878524, -1094102329, -1097746379, -1098262983)
		 + W(6, -1113822832, -1105474774, 1045393909, -1106251932)
		 + W(7, 1018782386, -1135035573, -1114747425, -1119448485);
	sum2 = W(0, 1038489223, 1032193624, -1137158564, 1048862753)
		 + W(1, -1107218869, -1112577633, 1034028859, -1110240510)
		 + W(2, -1094743304, -1106563024, 1029053577, -1103121169)
		 + W(3, 1018988618, 1015522148, -1107822714, 1017646246)
		 + W(4, -1079775068, -1075431018, -1075905408, 1061439417)
		 + W(5, 1061842524, 1055667456, 1032002642, 1047594841) + W(6, 1069957645, 1074314813, 1067854461, -1090496129)
		 + W(7, -1083145579, -1093776696, 1038458963, -1100108785);
	WS(1050857279, 1035401177);
	sum1 = W(0, 1029370009, -1121232094, -1118971861, -1116554354)
		 + W(1, -1102118870, 1035949272, -1118591397, -1155732684)
		 + W(2, 1049972466, 1045749679, 1054737744, 1064433520) + W(3, 1057059356, 1055161550, 1035470985, 1050840570)
		 + W(4, -1100844155, -1097541146, -1089471141, -1088203652)
		 + W(5, -1089223685, -1095333099, -1098430605, -1105548665)
		 + W(6, -1114359850, -1119608387, 1032044074, 1039513726)
		 + W(7, 1028806533, 1039358524, -1114373271, -1113669781);
	sum2 =
		W(0, 1034282103, -1111920318, 1023538768, -1133376386) + W(1, -1119100907, 1014776166, -1117007635, -1121555310)
		+ W(2, 1040723224, -1118965841, -1128437695, 1038672881) + W(3, 993338648, 1050613235, -1108740075, 1040276790)
		+ W(4, 1028955705, 1031483971, 1043259383, -1148076972) + W(5, -1084940093, 1050550535, -1098463376, 1054296012)
		+ W(6, -1104697256, -1123254751, 1034554870, -1078609243)
		+ W(7, -1075024478, -1100774866, 1069274341, 1072481706);
	WS(1059068159, -1095269543);
	sum1 = W(0, 1022243158, -1126585055, -1113503115, 1034732162) + W(1, 1029695369, 1045709362, 1005846771, 1049870212)
		 + W(2, 1058751902, 1052633434, 1061437964, 1062365313) + W(3, 1054753811, 1047783152, 1043895001, -1119990530)
		 + W(4, -1083015108, -1095802212, -1083734386, -1087136899)
		 + W(5, -1089074173, -1093733821, -1096742887, -1106170901)
		 + W(6, 1040310153, 1009201364, 1040208083, -1116554445)
		 + W(7, 1044292534, -1141695574, 1042140272, -1106848091);
	sum2 = W(0, -1110453349, -1118716929, -1111084235, 1027079271)
		 + W(1, 1058163522, 1060433363, 1058751114, -1077532089) + W(2, 1048158098, -1117235638, 1037169053, 1044450691)
		 + W(3, -1086959067, -1096141012, -1102281652, 1061563184)
		 + W(4, 1064329884, -1122504669, 1037379653, -1106426334)
		 + W(5, -1081956377, -1081432626, -1086790317, 1073667932)
		 + W(6, -1096499673, 1023790996, 1035642078, -1103100998)
		 + W(7, 1059064502, -1109003581, 1048822766, -1089552462);
	WS(-1079238176, -1098575359);
	sum1 = W(0, -1122061272, 1012614613, 1049213476, -1091368434)
		 + W(1, 1050034455, -1115399887, -1105000541, 1040609063)
		 + W(2, 1040856756, -1098659523, 1050219649, 1046432350)
		 + W(3, -1092787824, 1045840143, -1102913028, -1104981396)
		 + W(4, -1106993315, 1049053518, -1088887964, 1061247706)
		 + W(5, -1113029435, -1096901418, 1045569657, -1106428832)
		 + W(6, -1113276757, -1110111537, 1048270483, -1098550683)
		 + W(7, 1053252708, -1120030007, -1144293604, 1037272948);
	sum2 = W(0, 1035271628, 1033447544, -1113618952, -1104023060)
		 + W(1, 1022009109, -1104458884, 1044684178, -1104406640)
		 + W(2, -1096995906, 1032410306, 1053850685, 1054515359)
		 + W(3, -1114408860, 1030897990, -1115683354, -1106540716)
		 + W(4, -1097624644, 1048740225, -1109777102, 1058355960)
		 + W(5, -1139294461, -1116975083, -1099524388, 1036671037)
		 + W(6, 1051183735, -1095652467, 1037584786, -1116173683)
		 + W(7, -1096371453, 1030595307, -1117706649, -1108415342);
	WS(1064155455, 1041078114);
	sum1 = W(0, -1114884791, 1038026665, 1040569148, -1123095214)
		 + W(1, -1113346810, -1098688777, -1106297864, 1033022404)
		 + W(2, -1133388468, -1103926126, -1088265213, -1088521037)
		 + W(3, -1094483240, 1052099081, 1038941559, 1027852876) + W(4, 1031759625, 1051074474, 1049866386, 1060913876)
		 + W(5, 1044072016, 1034732568, -1138713347, 1019301565)
		 + W(6, -1116707016, -1135572861, -1145284192, -1110455500)
		 + W(7, -1116167073, 1029730485, 1017022612, 1028095637);
	sum2 =
		W(0, 1027468398, -1111732215, -1149402831, -1136133524) + W(1, 1058132410, -1084703700, -1103172541, 1011948492)
		+ W(2, -1120484835, -1115316427, 1042551085, -1101059653)
		+ W(3, 1067179636, -1093846517, 1015696434, -1119207903) + W(4, 1033713911, -1113615213, 1015721118, 1005178376)
		+ W(5, -1112798365, 1036573120, 1035924289, -1106241198)
		+ W(6, 1037828351, -1102210431, 1027887653, -1105049969)
		+ W(7, 1033627060, -1112780439, 1025169534, 1034168377);
	WS(1056869759, -1097268032);
	sum1 = W(0, 1018133293, -1105532941, 1027243330, -1097428310)
		 + W(1, -1099204213, -1133851766, -1138393927, -1118550618)
		 + W(2, 1036411431, 1007771751, -1116024394, 1032024955)
		 + W(3, -1130187397, 1034973653, -1114469768, -1118964077)
		 + W(4, 1039633317, 1034605623, 1050783724, 1010531964) + W(5, 1045069064, 1044277428, 1046520720, 1036629184)
		 + W(6, -1111689725, -1107937040, -1105991139, -1109581452)
		 + W(7, -1103861656, 1044990678, -1106353867, -1155661924);
	sum2 =
		W(0, 1031819015, -1113612713, 1040659447, -1113225510) + W(1, 1023788280, -1115035325, 1009487418, 1023947578)
		+ W(2, 1040620760, 1045122152, -1122637452, -1080510307)
		+ W(3, -1103769905, 1050277803, 1041168723, -1112728330)
		+ W(4, -1130428603, -1113774176, -1093905874, -1073670430)
		+ W(5, 1040925011, 1074164392, 1056579340, 1044922942) + W(6, -1130628701, -1118722775, 1015363301, -1129641903)
		+ W(7, 1045479736, 997650792, 1043373785, -1122436477);
	WS(1064095487, 1025785067);
	sum1 = W(0, 1026371284, -1097495743, 1050378694, 1008396404)
		 + W(1, 1042871873, -1103138663, -1136206974, 1034556564)
		 + W(2, -1106851535, 1042476562, -1104849584, -1085976658)
		 + W(3, -1097042470, -1109264236, 1035073279, -1094929447)
		 + W(4, -1128892272, 1049973404, -1115675316, 1058008769)
		 + W(5, -1098054097, 1052615848, 1037088776, 1045135411) + W(6, 1040514533, -1103190740, 1040022019, 1040395090)
		 + W(7, 1050097558, -1102548473, -1157051795, 1023679636);
	sum2 = W(0, -1124722923, -1114618025, 1043439029, 1036363299)
		 + W(1, -1096133271, 1049502378, -1106999272, 1013819494)
		 + W(2, 1033420628, -1100145939, -1115804833, 1057589449)
		 + W(3, 1053618149, -1091358477, 1030436134, -1119548384)
		 + W(4, -1105442746, 1047309531, -1084852425, -1089136554)
		 + W(5, 1028964970, 1056312267, -1100909906, 1043379377) + W(6, 1029168594, 1048079041, -1101613108, 1042227257)
		 + W(7, 1045151454, 1041752672, 1036382707, -1113267324);
	WS(1060109055, 1023402244);
	sum1 = W(0, 1039025762, -1109278395, -1125210976, -1107337262)
		 + W(1, -1119314274, 1038278743, -1120902815, 1024999351) + W(2, 1051909299, 1054481389, 1061074499, 1069080830)
		 + W(3, 991275263, 1049054227, 1043342663, 1051802331)
		 + W(4, -1098089231, -1093104548, -1087624466, -1092709234)
		 + W(5, -1085745760, -1093068092, -1102438460, -1098889074)
		 + W(6, -1107880995, 1018380380, -1167447218, -1119879878)
		 + W(7, 1030906608, 1028271716, -1122586985, -1107737008);
	sum2 = W(0, 995982518, 1033194341, 1038373562, 1040171687) + W(1, -1108098969, 1027047733, -1147696971, 1033796110)
		 + W(2, 1035578813, -1121421677, 1046888388, -1103362299)
		 + W(3, 1050255581, -1096418856, 1042040695, -1116244525)
		 + W(4, -1118279893, -1114972659, 1069469835, 1078927590)
		 + W(5, -1065023683, -1082214759, 1045909115, -1112457727)
		 + W(6, -1115504751, -1108849613, 1041670894, 1050450381)
		 + W(7, -1097423961, -1114805949, 964966831, 1025540676);
	WS(-1092049407, -1078216845);
	sum1 = W(0, 1019093687, 1030002432, -1100550858, 1055647027)
		 + W(1, -1103872766, 1041444210, -1115845919, 1042339236) + W(2, 1057591089, 1050969332, 1056027116, 1063070242)
		 + W(3, 1039049940, 1057957242, 1034942714, 1059965491)
		 + W(4, -1089127853, -1096074010, -1082843219, -1088645600)
		 + W(5, -1097545633, -1095349663, -1103665506, -1089209262)
		 + W(6, -1109784091, 1043174565, -1126191805, 1049441628)
		 + W(7, -1097650089, 1024042875, -1123963793, -1105758607);
	sum2 = W(0, -1086426610, -1096143108, -1089951657, 1062855195)
		 + W(1, 1068897447, 1074016711, 1075026151, 1074160921) + W(2, 1062347208, 1055082976, 1045157118, 1048769854)
		 + W(3, -1073459143, -1078468086, -1071781830, -1072043968)
		 + W(4, 1053593730, -1101252044, -1111940928, 1037201995)
		 + W(5, -1091098547, -1119407664, 1031118734, -1095931446)
		 + W(6, -1108806990, -1138780047, -1099705126, 1058343455)
		 + W(7, -1094950430, 1046274438, -1128975824, 1035271906);
	WS(-1092377983, 1032564911);
	sum1 = W(0, 1026968586, 1001025293, -1101464865, -1099757657)
		 + W(1, -1099131534, 1021990836, -1124857771, 1016095931)
		 + W(2, 1051240140, -1135919542, 1047585891, 1046337282) + W(3, 1042168181, 1042765483, 1039475666, 1031087233)
		 + W(4, -1140824311, -1114206145, 1035412731, -1093593858)
		 + W(5, 1042300945, -1105010841, -1129901419, -1150842169)
		 + W(6, -1108814006, 1031981930, -1105914151, -1111723206)
		 + W(7, -1114245051, 1047084274, -1110153104, 1021006644);
	sum2 = W(0, -1152594313, -1114711758, -1122222477, -1119994373)
		 + W(1, -1117872135, -1136114154, -1118889611, -1120239593)
		 + W(2, -1103837493, -1102219265, 1021928584, 1043085394)
		 + W(3, -1098150014, -1114380427, -1103586212, 999997765)
		 + W(4, -1119502913, 1049238470, 1051353268, 1069806319)
		 + W(5, 1040245198, -1084770114, -1097500544, 1032457879)
		 + W(6, 1035550709, -1111809635, 1038283603, -1113383091)
		 + W(7, 1038911980, -1106271331, -1109409577, -1130668925);
	WS(1066805616, -1146277627);
	sum1 = W(0, -1135230785, -1149155717, 1034010150, 1042337650) + W(1, -1127867356, 1036367663, 1011804270, 998521116)
		 + W(2, -1097679853, -1106566573, -1092037473, -1085421897)
		 + W(3, -1091217395, -1094061036, -1108406741, -1096997053)
		 + W(4, 1046488473, 1047676826, 1047117051, 1062693860) + W(5, 1049537116, 1056189429, 1017502967, 1049188263)
		 + W(6, 1036204713, -1098488427, -1103697017, 1057957971)
		 + W(7, -1114566390, 1034870184, -1103604141, 1029261884);
	sum2 = W(0, -1122819855, 1029215207, -1109976389, 1044451524)
		 + W(1, -1130065951, 1027965847, -1119702735, 1036873692)
		 + W(2, 1035645255, -1111163705, 1026839491, -1095838714)
		 + W(3, -1147512571, -1156411358, -1110332882, -1114357123)
		 + W(4, -1107161682, 1019166485, -1129473215, 1082201538) + W(5, 1052773623, 1033233466, 1034307583, 1001850219)
		 + W(6, 1042480496, -1107159841, -1115971786, -1067229991)
		 + W(7, -1091650896, -1142132409, -1107215185, 1025815163);
	WS(1040205182, 1040987841);
	sum1 = W(0, 1032709552, 1028035406, -1152624047, 1047238622)
		 + W(1, -1110798127, -1160283945, -1129145589, 1035307633)
		 + W(2, 1050828331, 1054299632, 1000765841, 1064828620) + W(3, 1059217829, 1057730984, 1050797759, 1040620053)
		 + W(4, -1098789018, -1102534446, -1087146945, -1084918512)
		 + W(5, -1080798168, -1094152707, -1154982570, -1104995442)
		 + W(6, -1130845956, -1131566290, 1024089890, 1044521480)
		 + W(7, 1041701723, -1105870556, -1121779940, -1110323595);
	sum2 = W(0, -1104834685, -1098615503, -1090508283, -1080862372)
		 + W(1, 1048874616, 1063492499, 1035824034, 1062512173) + W(2, 1039834326, 1050496819, 1045914856, 1070974917)
		 + W(3, -1085801376, -1081343708, 1033985362, -1089072248)
		 + W(4, 1040649104, 1034170750, -1118657109, -1102559609)
		 + W(5, 1041220807, 1047362948, -1099586035, -1130222490)
		 + W(6, -1113573633, -1119108596, -1128160390, -1095002000)
		 + W(7, 1053594264, 1022825140, 1041895669, -1115149866);
	WS(-1087487423, 1060332710);
	sum1 =
		W(0, -1105878689, 1042437466, 1040585322, -1121111477) + W(1, -1112195269, -1112892785, -1122925576, 1012646976)
		+ W(2, -1095746139, -1089004262, -1081828961, -1099866351)
		+ W(3, -1115422148, 1039314504, -1117471766, -1108492170) + W(4, 1053913286, 1055197099, 1059867107, 1061690846)
		+ W(5, -1104536871, -1102951638, -1107184778, -1130420108)
		+ W(6, 1037671952, -1117440135, -1114610404, 1028605502) + W(7, 1040822242, 1041433743, 1048192776, 1029799624);
	sum2 = W(0, 1017331955, -1104677463, -1117673238, -1094338757)
		 + W(1, -1119646366, -1104710153, -1107625181, 1022869095)
		 + W(2, -1097747777, 1040900608, -1081336501, 1073518733)
		 + W(3, -1103573743, -1106204508, 1041186571, -1097636016)
		 + W(4, -1097037835, 1016355419, -1089023490, 1068423959) + W(5, 1048344480, 1057220074, 1033091565, 1053959289)
		 + W(6, -1162485367, -1104406873, -1117660642, -1096388411)
		 + W(7, -1093216188, 1028492960, -1092192530, 1049060345);
	WS(-1096756863, 1051174382);
	sum1 = W(0, 1025372546, -1106905723, -1114360751, 1025624474)
		 + W(1, 1037998160, 1032794399, 1034992970, -1114244794)
		 + W(2, -1115668125, 1039995714, 1043101563, -1089490746)
		 + W(3, -1092891318, -1107085565, -1114405501, -1168885266)
		 + W(4, 1000611497, -1105014230, -1117013085, 1058174613)
		 + W(5, 1045000731, 1035643438, -1121180749, -1120880459)
		 + W(6, 1034391118, 1041916975, 1027806076, -1111998130) + W(7, 1008039732, 1030397185, 1018926829, 1029203969);
	sum2 =
		W(0, -1089960886, -1092452707, 1049541326, 1032119458) + W(1, 1032929374, -1110883627, -1123073435, 1026522309)
		+ W(2, -1095856011, -1106157919, 1074170001, -1085150802)
		+ W(3, 1046048366, -1112079347, 1027735021, -1111935169) + W(4, 1007316785, 1041476280, 1050706137, -1083810164)
		+ W(5, 1043182557, -1129593193, -1214669080, 1009058861)
		+ W(6, 1036775569, -1107942220, 1021239050, -1132331444)
		+ W(7, 1036225521, -1113579728, 1009639193, 1022066674);
	WS(1063524863, 1010978751);
	sum1 = W(0, 1033376264, 1035248130, 1029138555, 1040606570)
		 + W(1, -1146340206, -1122169062, -1113033206, -1115451138)
		 + W(2, -1090913225, -1094935586, -1084407830, -1085174115)
		 + W(3, -1080254739, -1094320024, 1033710501, 955403507) + W(4, 1054337940, 1045510498, 1057961148, 1062831778)
		 + W(5, 1060252175, 1058700983, 1045946247, 1033261261) + W(6, 1034437913, 1040021853, -1141033844, 1032741433)
		 + W(7, -1127614262, -1136275261, 1007782611, 1030604567);
	sum2 = W(0, -1096400044, 1043917783, -1123678571, -1090244436)
		 + W(1, 1046901313, 1048870815, 1033884063, 1053211427) + W(2, 1053621644, 1009306318, 1051339656, 1062093709)
		 + W(3, -1080576226, -1106342004, -1098524562, -1124418811)
		 + W(4, 1017015195, 1005897821, -1141989437, 1065539532)
		 + W(5, -1083332175, -1097183812, -1097464341, -1092155120)
		 + W(6, 1037111777, -1106811629, 1047789047, -1093438727)
		 + W(7, 1049955112, 1043219374, 1050393105, 1044056917);
	WS(-1085369887, -1080302329);
	sum1 = W(0, 1021216124, -1121762938, -1103047566, -1094342263)
		 + W(1, -1105630871, -1107174593, 1025950537, -1146340105)
		 + W(2, -1112260523, -1119192737, 1050211017, 1058411732)
		 + W(3, -1139271463, 1042276856, -1113852108, -1119668597)
		 + W(4, 1035888345, 1049037307, 1061443675, 1044828010)
		 + W(5, -1119204121, -1100915542, -1174284878, -1119790119)
		 + W(6, -1110274640, -1111476420, -1097892613, -1097171068)
		 + W(7, -1112160677, 1026261917, -1110403297, -1132483222);
	sum2 =
		W(0, -1115512925, -1146353705, 1036066439, -1134998124)
		+ W(1, -1093678923, -1122018103, -1110317749, 1002801625) + W(2, 1035074177, 1040461813, 1042528734, 1058355837)
		+ W(3, -1081621864, -1089980594, 1049357806, -1101025299)
		+ W(4, -1191992884, 1043381354, 1059049535, 1058956516) + W(5, -1095612272, 1050844919, -1100731037, 1036998024)
		+ W(6, -1115656893, -1137020948, 1021899784, -1112812041)
		+ W(7, 1012903452, -1123282157, -1122890057, 1023124620);
	WS(-1106521214, -1077666555);
	sum1 = W(0, 1003321829, -1120901013, -1105222370, -1107011833)
		 + W(1, 1029823211, 1000924822, -1127794128, 1027793952) + W(2, 1052142545, 1052094618, 1060439250, 1059969903)
		 + W(3, -1095361591, 1039904896, 1000548911, 1046166153)
		 + W(4, -1102912320, -1105733097, -1085669204, -1113880763)
		 + W(5, 1052882623, -1107186882, -1118745688, -1096551831)
		 + W(6, -1108686032, -1118608535, 1045702647, -1106161276)
		 + W(7, -1103122454, -1106172071, -1113781993, -1132637458);
	sum2 = W(0, 1034079401, -1123608512, 999851902, -1128074608)
		 + W(1, -1102099502, -1109589984, -1127758712, 1032460032)
		 + W(2, 1025264110, -1119278092, 1031056700, 1059405503)
		 + W(3, -1123208440, -1081290516, 1015173988, -1121242732)
		 + W(4, -1123371956, -1104246380, 1051208451, 1063218900)
		 + W(5, -1110007228, -1131612640, -1124651080, 1025045004)
		 + W(6, -1116991392, -1156408861, -1098806852, 1038716729)
		 + W(7, -1136590423, 1034885175, 1009682031, -1115963068);
	WS(1061862175, -1081928168);
	sum1 = W(0, -1105584175, 1024897880, 1038516044, 1040792761)
		 + W(1, 1041867802, -1146323132, 1033649803, -1113939311)
		 + W(2, -1105871745, -1093982770, -1092069365, -1083616743)
		 + W(3, -1089303929, -1089274268, -1106858177, -1096909360)
		 + W(4, 1043886056, 1052657028, 1055074797, 1065026281) + W(5, 1056987882, 1054263413, 1043742846, 1049053899)
		 + W(6, 1027658214, 992865878, -1121064957, -1106374835)
		 + W(7, 1015027694, -1132520748, -1137844354, 1017619030);
	sum2 = W(0, 1078367032, 1056220347, -1078889751, -1073546091)
		 + W(1, -1104234997, -1129365336, -1132392998, -1105729449)
		 + W(2, 1027322757, 1044756153, -1096547764, -1101560565)
		 + W(3, 1042443775, 1048890957, -1104280017, 1028418751)
		 + W(4, 1023449836, -1148770222, 1043960988, -1126862726)
		 + W(5, 1029550531, -1133306383, -1130422948, 1042854212)
		 + W(6, -1115583846, 993742973, -1130380138, -1147412718)
		 + W(7, -1115461788, 1019814478, -1143007558, -1123464959);
	WS(1052938943, -1103606318);
	sum1 = W(0, -1114719934, -1110318513, 1051495307, -1100729633)
		 + W(1, 1058926789, -1090569589, 1050591187, -1120060704)
		 + W(2, -1087051802, -1108424920, -1085940948, -1082198177)
		 + W(3, -1090825863, -1088355266, -1096343413, -1090847836)
		 + W(4, 1058073278, 1044445625, 1060893495, 1058839039) + W(5, 1060585177, 1053564817, 1054456219, 1059253187)
		 + W(6, -1114447856, 1040769086, 1037779432, -1103818980)
		 + W(7, 1053070735, -1091337376, -1131842819, 1026807692);
	sum2 = W(0, 1015621136, 1032703681, 1048700747, -1098355550)
		 + W(1, 1047054427, -1097901072, -1126056922, -1165737020)
		 + W(2, 1033006755, -1098289077, -1098808895, 1046984196)
		 + W(3, -1083721832, 1061110777, -1109410901, 1047097145)
		 + W(4, -1072583370, -1084108607, -1081224226, -1081041246)
		 + W(5, 1069053051, 1046858869, 1068664236, 1076043754) + W(6, 1074691924, 1067219112, 1064576163, 1066863963)
		 + W(7, -1084686190, -1086075738, -1079374171, -1071293986);
	WS(-1083248351, 1041375270);
	sum1 = W(0, 998616699, -1142901727, 1043282847, -1128981712)
		 + W(1, 1049050406, -1110272759, 1045114289, -1170526381)
		 + W(2, -1087439008, -1092067298, -1097778587, -1084179155)
		 + W(3, -1090979219, -1086455104, -1095775369, -1087021556)
		 + W(4, 1054645196, 1052452449, 1050602866, 1058025241) + W(5, 1061357806, 1053431193, 1052134295, 1053157267)
		 + W(6, 1045294540, -1128264947, 1042620067, -1146688137)
		 + W(7, -1127282486, -1125997182, 981342481, 1046767364);
	sum2 = W(0, -1076239116, -1079299620, -1079042334, -1083365485)
		 + W(1, 1049726715, 1066758659, 1069675355, 1075688460) + W(2, 1068235144, 1068687973, 1068481951, 1066921525)
		 + W(3, -1106704213, -1080829299, -1077473679, -1073149491)
		 + W(4, 1054062613, 1019509447, 1057377046, -1100834259)
		 + W(5, -1095788298, -1107253929, -1112126912, -1090199615)
		 + W(6, -1114529265, -1116897962, 1041823371, 1032806429)
		 + W(7, -1104989857, -1107915189, 1021289065, 1034867372);
	WS(-1089965567, 1041739713);
	sum1 = W(0, 1014059625, -1109541748, -1120181702, -1113826001)
		 + W(1, -1099389050, -1107441048, -1110918155, -1129336123)
		 + W(2, 1050606464, 1046384755, 1052952467, 1062759283) + W(3, 1061539071, 1056969105, 1043585729, 1054439728)
		 + W(4, -1097348868, -1098095776, -1098227712, -1097909490)
		 + W(5, -1089710746, -1097990985, -1112431723, -1101291373)
		 + W(6, 1016608410, -1110057610, -1165355548, -1103909923)
		 + W(7, 1018410859, -1097884829, -1109883584, -1118732474);
	sum2 = W(0, 1035083591, -1112359157, 1037205500, -1119560270)
		 + W(1, -1130432545, 1033928454, -1111608107, 1027763767)
		 + W(2, -1113211599, 1037267536, -1110383577, 1053336900)
		 + W(3, 1036846600, 1029308948, 1035214305, -1137000642) + W(4, 1032203968, -1129901649, 1050641640, 1062183610)
		 + W(5, 1052549520, 1037218786, -1098666781, 1041216407) + W(6, -1112771443, 999833884, -1113848439, 1048127168)
		 + W(7, -1087091182, -1080175934, -1106600446, -1105808372);
	WS(1040803966, -1079223548);
	sum1 = W(0, -1103550802, -1113401739, -1105545077, -1095164520)
		 + W(1, -1102562113, -1106149592, -1123094707, -1105989383)
		 + W(2, -1108233168, -1097729981, -1112466052, 1056711305)
		 + W(3, 1033129898, -1100704991, -1106323272, -1109921151)
		 + W(4, -1115946235, 1016715200, 1051122342, 1072346450) + W(5, 1046866637, 1041579689, 1017795558, 1019070562)
		 + W(6, 1021078213, -1123835458, -1103483180, -1092700173)
		 + W(7, -1104392485, 1033532004, -1128003929, -1109398092);
	sum2 =
		W(0, -1132003761, -1126076753, 1028715469, -1094940877) + W(1, -1096054213, 1050064171, -1095828963, 1024912709)
		+ W(2, -1097131135, -1098724323, -1094337061, 1075670208)
		+ W(3, -1092647285, -1119763725, -1104609741, -1103386045)
		+ W(4, 1033952970, -1102131199, 1043946979, 1037045260) + W(5, 1052392413, -1101691459, -1104710657, 1042676905)
		+ W(6, -1114013558, 1027012993, -1109613274, 1026138301)
		+ W(7, -1107006741, 1032910718, -1127911473, -1109320626);
	WS(-1077711088, -1080462700);
	sum1 = W(0, 1016976667, -1143635214, 1050435883, 1025648038)
		 + W(1, 1033190198, -1119077035, -1127874241, -1124293633)
		 + W(2, -1095463505, -1094028818, -1084473735, -1081613943)
		 + W(3, -1092817267, -1089963906, -1112556483, -1096263708)
		 + W(4, 1048382760, 1043759401, 1060944248, 1061061657) + W(5, 1059085444, 1058923652, 1024757337, 1052630131)
		 + W(6, 1033669226, 1023995271, 1038367764, -1104130812) + W(7, 1035230572, -1115548134, 998948881, 1035279350);
	sum2 = W(0, -1118714905, -1128906105, -1104617441, -1102497202)
		 + W(1, 1052988680, 1025452854, -1147569173, 1045309195) + W(2, 1038737245, 1033599435, 1047074065, -1081197801)
		 + W(3, 1051590837, 1036478618, 1034730428, -1096538670)
		 + W(4, 1045939428, -1124872105, 1073600723, -1069501955)
		 + W(5, -1078764847, -1078626366, -1094352359, -1097394746)
		 + W(6, -1084863446, -1120736313, 1072627800, 1076529178)
		 + W(7, 1066278053, -1115729701, -1119746081, 1001372341);
	WS(-1085605823, 1039908372);
	sum1 = W(0, -1110519177, 998302542, -1105109851, 1051114493) + W(1, 1047758692, 1047411644, 1008966514, 1027414133)
		 + W(2, -1101464226, -1097280531, 1050325520, -1093718398)
		 + W(3, -1109283231, -1103804777, -1107759461, -1099881946)
		 + W(4, 1050281295, 1040574050, -1112501642, -1095999987)
		 + W(5, 1052111506, 1013903280, -1131548857, 1037344125) + W(6, -1136474287, 1017687606, 1027599892, 1038451002)
		 + W(7, -1112873934, 1026946257, 1007362713, 1030395745);
	sum2 = W(0, -1115357326, -1129481498, 1037423788, -1149109833)
		 + W(1, -1107237807, -1098320683, -1118016391, -1111060805)
		 + W(2, -1098998597, -1104582263, -1098625511, 1036322812)
		 + W(3, 1050926614, 1045914812, 1029306918, 1035368549) + W(4, 1033193484, 1041990652, 1052524895, 1029624616)
		 + W(5, -1102468922, 1016354632, 1029333966, 1036818044)
		 + W(6, -1119934044, -1109942748, 1028176618, 1032249206)
		 + W(7, -1117055607, 1026298641, -1116685452, -1113790705);
	WS(1066221936, -1112686252);
	sum1 =
		W(0, -1111426931, 1049363148, -1090113310, 1038796336) + W(1, -1102958241, 1041899238, -1104001476, -1112879133)
		+ W(2, 1042737360, -1108750629, 1053136109, -1095853365)
		+ W(3, -1108890233, 1023718298, 1033191264, -1165972390) + W(4, 1039181581, -1105687720, 1051677110, 1031102479)
		+ W(5, 1058267293, -1089545128, 1047293124, 1010166848) + W(6, -1110677245, 1035534704, -1101864162, 1019901392)
		+ W(7, -1107302241, 1048841797, -1106653499, 989728967);
	sum2 =
		W(0, 1019579309, -1115216952, -1101014764, 1035949455) + W(1, -1125343389, 1020295703, -1107189524, 1032252124)
		+ W(2, -1121628281, 1041466962, 1044350744, -1096356807) + W(3, 1019949697, 1011899626, 1020414781, -1108620092)
		+ W(4, -1104132268, -1110659898, -1092586315, 1067161402)
		+ W(5, 1044980625, 1028945397, 1024223321, -1106879950)
		+ W(6, -1133616314, 1046938970, -1089581193, -1097777539)
		+ W(7, 1025080038, 1042942659, 1000298789, 1034429670);
	WS(1065647552, 1042223795);
	sum1 = W(0, -1118213891, 1047859212, -1102035956, 1049817209)
		 + W(1, -1136727619, 1018314812, 1048950515, -1111834851)
		 + W(2, -1090185691, -1099254654, -1085546115, -1090115457)
		 + W(3, -1086839140, -1089622500, -1103143659, -1088857895)
		 + W(4, 1054600851, 1056675965, 1052764224, 1060918524) + W(5, 1050058698, 1053194074, 1055030644, 1046059111)
		 + W(6, 1042956769, 1045938459, -1095542592, 1048397149)
		 + W(7, -1107166488, -1115710386, 1046421002, 1019098869);
	sum2 = W(0, 1038047795, -1100534663, 1043709757, -1098906327)
		 + W(1, 1054998296, -1097979318, 1042447686, -1135615252)
		 + W(2, 1045715537, -1109612723, -1109559353, -1088589586)
		 + W(3, 1046750383, 1030039799, -1112135838, -1108474833) + W(4, 1062099960, 1074456323, 1074047524, 1061406543)
		 + W(5, -1109444720, -1095255331, -1106577876, -1098188594)
		 + W(6, -1074982428, -1071944747, -1086420775, -1087600981)
		 + W(7, 1058024333, 1040647828, 1042372587, 1051479186);
	WS(-1099261566, -1102058551);
	sum1 = W(0, 1037460750, -1118752449, 1048855473, 1046116085) + W(1, 1041532007, 1043443965, 1035797482, 1048656673)
		 + W(2, -1099740733, 1038344912, -1097823268, -1077722267)
		 + W(3, -1086845489, -1109540512, -1112472539, 1006300060)
		 + W(4, 1035868896, 1028635221, -1135561696, -1089090112)
		 + W(5, 1054063629, 1036245196, 1039520068, -1115462467) + W(6, 1046250530, 1040547388, 1049218244, 1053686776)
		 + W(7, 1041462458, 1041323791, -1116084210, 1050214602);
	sum2 = W(0, -1107023704, -1103130345, 1025081245, 1007138702)
		 + W(1, 1020633935, 1042694232, -1116958023, -1117764771)
		 + W(2, -1099880087, 1049640504, -1099241173, 1060797185)
		 + W(3, -1096100738, 1034621436, -1100840753, 1051814059)
		 + W(4, 1047853298, -1100868353, 1050410790, -1096656068)
		 + W(5, 1053061345, -1092716332, 1057695342, -1092707384)
		 + W(6, -1106650230, 1035820630, -1111373979, 1048085306)
		 + W(7, -1098540289, 1045275377, -1095110662, 1026583068);
	WS(-1081437504, -1086037448);
	sum1 = W(0, 1002898847, 1034161364, -1097339820, -1102052735)
		 + W(1, -1122224578, -1116847174, -1124219870, -1114337484)
		 + W(2, 1048903167, 1048827465, 1058952469, 1062493730) + W(3, 1056452878, 1052097743, 1046287775, 1051622635)
		 + W(4, -1098037791, -1110924302, -1089826679, -1082951605)
		 + W(5, -1095802941, -1093057352, -1115921615, -1097214606)
		 + W(6, -1124004134, 1038960439, -1109622563, 1046141833)
		 + W(7, 1037494008, -1142221339, 1018754897, -1115514650);
	sum2 = W(0, 1026296217, 1046658552, -1092482457, 1048926974)
		 + W(1, -1093986590, 1051240634, 1031417427, -1116201775)
		 + W(2, -1098267531, 1054123387, 1031912087, -1103258874)
		 + W(3, 1064081451, -1081783631, 1052301313, -1136084293)
		 + W(4, 1056065541, -1080723543, 1068312252, -1095327126)
		 + W(5, -1101319294, 1054428583, -1095108256, 1032992382)
		 + W(6, -1107249906, 1049528827, -1094476247, -1114829012)
		 + W(7, -1110151549, -1109929036, 1023898518, -1131461985);
	WS(1059931039, 1045326059);
	sum1 = W(0, -1105339195, -1116497429, -1104905094, 1048600749)
		 + W(1, 1017781140, 1028510504, -1104151378, 1006123003)
		 + W(2, 1027626820, -1102542884, 1042432944, -1087368655)
		 + W(3, -1090841955, -1098837680, -1135818261, -1102238241)
		 + W(4, 1035394960, 1045819641, 1050447189, 1050459387) + W(5, 1058872902, 1038310627, 1009721182, 1039487803)
		 + W(6, 1020852317, -1110241387, -1120454715, 1028063406)
		 + W(7, -1135766366, 1046575867, -1121800177, -1138241103);
	sum2 = W(0, -1108715925, -1125695753, -1106861101, 1037467647)
		 + W(1, 1049447879, -1108013135, 1016159100, 1025122350)
		 + W(2, 1033521028, -1107049318, -1126359337, 1024736242)
		 + W(3, -1096919459, 1030099711, 1038861546, 1027296385) + W(4, -1130002309, 1043711791, 1069432650, 1069236178)
		 + W(5, -1089672176, -1104043463, -1102967963, -1115278753)
		 + W(6, 1043372642, -1096562690, 1055907536, -1077602923)
		 + W(7, -1079492159, 1048192702, 1041544949, 1038199238);
	WS(1065273279, -1155200022);
	sum1 = W(0, 1032043190, 1042748400, 1044363154, -1101712885) + W(1, 1020290996, 1042545917, 1023679047, 969146311)
		 + W(2, -1110724474, -1113644224, -1103694886, 1049530899)
		 + W(3, 1032343156, -1119655327, -1113927803, 1014066252)
		 + W(4, 1048813356, -1113329098, -1138873982, 1013956115)
		 + W(5, -1088512539, -1118975351, -1112426340, -1102619473)
		 + W(6, -1107914275, 1017813644, -1119126921, 1030506334)
		 + W(7, 1047677002, 1035449518, 1040385292, 1037002750);
	sum2 =
		W(0, -1105379539, -1114326988, -1128505094, -1127815582) + W(1, -1144273240, 1011114412, 1010998384, 1008109660)
		+ W(2, 1040024171, 1033596237, 1027874005, -1090164335) + W(3, 1026082941, -1098155637, 1010514392, -1110656550)
		+ W(4, 1054804566, -1100858724, -1108932212, 1015111122) + W(5, 1057491035, -1123558275, 1041639386, 1025837089)
		+ W(6, 1020126178, 1058095820, -1095228668, -1114002666)
		+ W(7, -1109234902, -1117423595, -1148517800, 1028462436);
	WS(1064822335, -1095840736);
	sum1 = W(0, 1049019197, -1114924672, 1006539024, 1027273471) + W(1, 1024001604, 1023329786, 1034076369, 1032078653)
		 + W(2, 1056391992, 1052717533, 1053226600, 1063307800) + W(3, 1051465786, 1056189595, 1051405604, 1049885284)
		 + W(4, -1082098174, -1097259572, -1083318869, -1085358981)
		 + W(5, -1093212548, -1096912972, -1097995110, -1090164049)
		 + W(6, 1047279757, -1158101509, 1028150783, 1048033194)
		 + W(7, 1040827508, -1122795750, 1040247311, -1102713147);
	sum2 = W(0, 1044291516, -1105536143, -1123279074, -1102729189)
		 + W(1, 1019015608, -1098099014, 1041233257, -1116414073)
		 + W(2, 1057945825, 1059138923, 1064153610, -1117658388)
		 + W(3, -1082824416, -1088923796, -1114762777, -1093119165)
		 + W(4, 1075245425, 1063262829, 1058517731, 1055818216)
		 + W(5, -1095331241, -1082492094, -1084810008, -1076437009)
		 + W(6, -1075047571, -1084742426, -1087050661, -1094508761)
		 + W(7, -1107921801, 1066223948, 1065694420, 1070896480);
	WS(-1090760447, 1052695066);
	sum1 = W(0, 1032827391, 1004836815, 1040820154, 1033221771) + W(1, -1142824410, 1019263487, 1033909728, 1030288497)
		 + W(2, -1086160295, -1100507696, -1085279840, -1085951050)
		 + W(3, -1090476887, -1096291378, -1104244158, -1096098979)
		 + W(4, 1058956361, 1050270371, 1061054293, 1060000376) + W(5, 1053225609, 1052048107, 1044967298, -1123372967)
		 + W(6, -1122589400, 1011775197, -1126907788, -1109718672)
		 + W(7, 1031459881, 1014310644, 1002236306, 1050105184);
	sum2 = W(0, -1115548553, 1010795990, 1025233265, -1108773712)
		 + W(1, 1028577219, -1123367926, 1027045545, 1016487959)
		 + W(2, -1119133376, 1054475337, -1126101085, -1096206384)
		 + W(3, 1025243447, -1123699076, -1116348436, 1026289255) + W(4, 1034230379, 1049648601, 1031862009, 1056453743)
		 + W(5, -1092511031, 1040231624, 1052333940, -1098871930)
		 + W(6, -1106450540, -1130742967, 1074765700, 1076253468)
		 + W(7, 1067142167, -1082850789, -1074864896, -1066441953);
	WS(-1098442559, 1026469881);
	sum1 = W(0, -1149983818, -1119522441, -1111872220, -1148708523)
		 + W(1, 1033974589, 1034687077, -1121497336, 1040191316) + W(2, 1050517915, 1049663660, 1057681670, 1054270423)
		 + W(3, 1065584902, 1060962908, 1043551013, 1037520938)
		 + W(4, -1114000872, -1102209381, -1097110004, -1080449641)
		 + W(5, -1089390067, -1088971425, -1096207069, -1098201593)
		 + W(6, -1106643136, -1107005098, -1107624656, 1044397088)
		 + W(7, 1040137492, 1011262833, -1152197144, -1111636393);
	sum2 = W(0, -1093666199, 1049995354, -1104373549, -1108191449)
		 + W(1, -1086862321, -1109961150, -1105617480, 1057348983)
		 + W(2, 1067471948, -1083836095, 1067519925, 1075025493)
		 + W(3, -1079149522, -1092122258, -1118106953, -1090446878)
		 + W(4, 1044138823, -1089657247, 1068116530, 1070698122)
		 + W(5, -1077256496, -1092830464, -1104600439, -1095892285)
		 + W(6, -1087858714, 1040673003, -1086283540, -1107890740)
		 + W(7, 1052510667, 1044801958, -1113062539, 1040940184);
	WS(-1089367999, -1080592817);
	sum1 = W(0, 1050901372, -1142600967, 1043029392, 1042662963) + W(1, -1131715556, 1028335344, 1009439676, 1040529906)
		 + W(2, 1020565079, 1046045566, 1051791856, 1059303201) + W(3, 1060541458, 1057651322, 1050310918, 1061742083)
		 + W(4, -1098563453, -1094642094, -1092783656, -1082254536)
		 + W(5, -1088235102, -1083519131, -1088554180, -1084895582)
		 + W(6, -1123752726, 1032349343, 1017360893, 1040706037) + W(7, 1038984656, 1042767141, 1039511244, 1037250730);
	sum2 = W(0, -1086948904, 1044777691, -1085906527, -1107333159)
		 + W(1, -1094251850, -1101622483, 1054103540, -1095334551)
		 + W(2, 1072921984, -1096214776, 1069427540, 1069014322)
		 + W(3, 1068759557, -1095651744, -1080635176, -1071443034)
		 + W(4, -1102597600, -1086612116, 1055370552, 1068187895)
		 + W(5, 1049876941, -1098339283, -1098368915, -1119710681)
		 + W(6, -1081008410, 1053678014, -1094318103, 1040782350)
		 + W(7, -1097053445, 1052418274, -1116179967, 1057760894);
	WS(-1072329816, 1074376722);
	sum1 = W(0, -1119826815, 1034466519, -1121811611, 1040071236) + W(1, 1034412551, -1125783811, 1025497578, 989295697)
		 + W(2, -1097135645, -1100415357, -1123247055, -1078161261)
		 + W(3, -1086793716, -1092987820, -1117997032, -1097292445)
		 + W(4, 1051061560, 1050212013, 1057003368, 1050094223) + W(5, 1060987117, 1053182609, 1030369595, 1040352158)
		 + W(6, 1001332238, 1009264740, -1119531350, 1047608180)
		 + W(7, -1139666027, 1053959834, -1130537576, 1003451511);
	sum2 = W(0, 1010850411, -1119692159, -1110113403, 1041465994)
		 + W(1, 1019542894, 1041361680, -1128076954, 1035827461) + W(2, 1033963983, 1024673399, -1107122545, 1041917938)
		 + W(3, 1031918417, 1016152214, -1119110501, -1108745692)
		 + W(4, 1041326744, -1126975570, 1049177676, 1075051781)
		 + W(5, 1057547658, -1100210466, -1101468559, -1111890885)
		 + W(6, -1110591524, 1039643589, -1098235771, 1061676083)
		 + W(7, -1072022345, -1080793678, 1038326573, -1115279667);
	WS(-1089734463, 1065567745);
	sum1 = W(0, -1115310942, 1048676446, 1051913151, 1041943745)
		 + W(1, 1032260949, -1123414147, 1025799735, -1118314271)
		 + W(2, -1089748010, 1033541431, -1091844976, -1078026925)
		 + W(3, -1083863979, -1088695462, -1097284573, -1090712276)
		 + W(4, 1053493076, 1047890913, 1060749357, 1057682191) + W(5, 1060855949, 1057895644, 1049355215, 1052101531)
		 + W(6, 1041536229, -1111760907, 1031051700, 1033727319)
		 + W(7, -1117552023, -1123512523, -1134918146, 1037093278);
	sum2 = W(0, -1087048499, -1089227831, -1081828818, -1106022394)
		 + W(1, 1057638724, 1053589051, 1030725267, 1050363813) + W(2, 1067110585, -1073947481, -1100054441, 1057992187)
		 + W(3, -1096117153, 1049824990, 1008667589, 1047082764) + W(4, 1062551012, -1107011493, 1044700801, 1053279159)
		 + W(5, 1047077354, -1098858111, 1055551992, -1093863007)
		 + W(6, -1088705293, 1063056164, -1091908804, 1049660447)
		 + W(7, 1041467137, -1112699600, 991046018, -1118599281);
	WS(-1079109040, -1085312521);
	sum1 = W(0, 1023769582, -1140282322, -1105105824, 1041551140)
		 + W(1, 1030694836, -1111084358, 955351653, -1133450021) + W(2, 1037365911, -1117579705, 1052645482, 1061549365)
		 + W(3, -1092653220, 1050958145, -1113919416, 1047664699)
		 + W(4, -1113299189, 1042794748, -1086336671, -1087637436)
		 + W(5, 1051894263, -1111723928, 1039072513, -1111528112)
		 + W(6, -1127522065, -1098682508, 1041518392, 1049784787)
		 + W(7, -1104535548, -1112540051, 997865134, -1121426302);
	sum2 =
		W(0, -1112127727, 1037755147, -1117076760, -1096944427) + W(1, 920706880, -1126463908, 1025583781, 1016301114)
		+ W(2, -1182735741, -1116775242, -1110833901, 1050960349)
		+ W(3, 1057824022, 1025802869, -1117624689, -1106817101) + W(4, 1027967369, -1108084106, 1047419656, 1057406540)
		+ W(5, -1106635563, 1030718323, -1129307942, -1146210056)
		+ W(6, -1099828018, -1106208929, -1106621688, -1093670465)
		+ W(7, 1046907280, -1104727129, 1024731263, -1133403952);
	WS(1066445424, -1114782683);
	sum1 = W(0, -1105169880, 1037849343, -1111719878, 1053025475)
		 + W(1, -1106443352, -1118185334, -1115180998, -1104379365)
		 + W(2, -1110498524, -1092096849, -1089773556, -1093199580)
		 + W(3, -1085224723, 1017432168, -1097477655, -1120659192)
		 + W(4, 1042140161, 1045982494, 1059787797, 1058443885) + W(5, 1058982105, 1051015495, 1049335790, 1047806371)
		 + W(6, 1033176686, 1027992139, -1104315937, 1034263873)
		 + W(7, -1099213011, 1015617473, -1134277975, -1124174113);
	sum2 =
		W(0, 1035156885, 1010861092, 1053142713, 1050643378) + W(1, -1093995815, -1100307988, -1094190457, -1095534688)
		+ W(2, -1104443938, -1111353322, -1092519845, 1033492110)
		+ W(3, 1061622434, 1045835461, 1054276307, -1118030035) + W(4, 1020765936, -1131256669, 1043066295, -1093594884)
		+ W(5, -1090891830, 1051701313, -1115303200, 1044764145)
		+ W(6, 1034215267, -1119467871, 1043572605, -1120345789)
		+ W(7, 1035132204, -1120193257, -1107758441, 1010759898);
	WS(1053797695, 1034928741);
	sum1 = W(0, -1113709609, -1101985872, -1098832221, -1106547453)
		 + W(1, 1032341932, 1038712045, 1020651977, 1037110646) + W(2, 1027306577, 1036410350, 1048222316, 1049396519)
		 + W(3, -1093507345, -1098128846, -1102358117, -1095739626)
		 + W(4, -1089618673, -1094568298, -1089721378, 1057932790)
		 + W(5, 1051551069, 1042310981, 1032076306, 1049811664) + W(6, 1039738506, 1041675949, 1049870789, 1032602030)
		 + W(7, 1041034929, 1020376402, 1038606871, 1036847389);
	sum2 =
		W(0, -1107569978, 1048834253, 1032955728, 1047116738) + W(1, -1095875849, 1024141754, -1117854930, 1031286951)
		+ W(2, -1096371488, -1100415470, -1097656368, 1057366407) + W(3, 1049724515, 1047568587, 1025784853, 1040928209)
		+ W(4, -1091206842, -1140716449, -1099982688, 1067804624)
		+ W(5, -1107732848, -1101898886, -1104360749, -1099991629)
		+ W(6, -1113379832, -1098639187, -1102236471, -1112454303)
		+ W(7, 1037256860, 1039735469, 1034482735, -1122662653);
	WS(-1100599294, -1113486107);
	sum1 = W(0, 1041832895, -1113994869, -1101582062, -1100675730)
		 + W(1, 1015862616, 1033573462, -1123901241, -1147102474) + W(2, 1058015130, 1043005476, 1065539217, 1054749782)
		 + W(3, 1046936430, 1043027144, -1122192647, 1047923809)
		 + W(4, -1095482492, -1095369841, -1088297536, -1085935041)
		 + W(5, 1054414015, -1096194081, -1118572185, -1106262926)
		 + W(6, -1123207408, -1120610968, 1040056719, -1111595960)
		 + W(7, -1110844045, 1041950395, 1007333963, -1097939280);
	sum2 = W(0, 1033496750, -1118187780, 1041080086, -1102935461) + W(1, 1023898015, -1122438380, 1007185073, 999989929)
		 + W(2, -1105017139, 1043450683, -1106458832, 1057933296)
		 + W(3, -1098239652, -1111698692, 1023645924, 1034431733)
		 + W(4, -1118941046, -1142467441, -1096734279, 1063076098)
		 + W(5, -1119844388, 1048742138, -1096898561, -1090457759)
		 + W(6, 1012703263, 1009095593, 1025973118, -1089439993)
		 + W(7, -1124882200, 1004297609, 1046154393, 1048791679);
	WS(1058454143, -1086058342);
	sum1 = W(0, -1115074879, -1099743710, -1103933280, -1113530407)
		 + W(1, -1124606630, -1115568198, -1123572016, -1118699368)
		 + W(2, 1051341170, 1054019099, 1057240637, -1085932301)
		 + W(3, -1090466976, -1097279225, -1108988935, -1095706385)
		 + W(4, -1123276713, -1112675511, -1095853513, 1048593300)
		 + W(5, 1059272419, 1052135974, 1039376368, 1041536544) + W(6, 1040408770, 1042487060, 1044345774, 1034191179)
		 + W(7, -1105205160, -1111240730, -1135917288, 1043157563);
	sum2 = W(0, 1047642666, -1094360366, -1111839157, -1101124559)
		 + W(1, -1119401007, -1114275291, 1010413358, 1018914035)
		 + W(2, -1106684338, -1104496052, -1101578828, 1062389037)
		 + W(3, -1099504899, -1102577927, -1121638606, -1100286365)
		 + W(4, -1097565895, -1137000462, 1017360469, 1056361687)
		 + W(5, 1057357121, -1111580608, 1047557438, -1108198790)
		 + W(6, 1038757740, -1120606628, 1043520604, -1110716481)
		 + W(7, -1121032787, -1174578992, 1020758339, 1031842399);
	WS(-1116191222, -1087222261);
	sum1 = W(0, 1051378220, 1026061480, 1051132746, -1131139769) + W(1, 1029438530, 1010253799, -1140691900, 1032111196)
		 + W(2, -1092140039, 1041212802, 1028855632, 1054776996) + W(3, 1052461054, 1056191968, 1041996679, 1051463563)
		 + W(4, -1098282527, -1108686318, -1114615088, -1096808426)
		 + W(5, -1090181940, -1089672580, -1095415146, -1084069643)
		 + W(6, -1115126509, 1018050395, 1028919646, 1031880915) + W(7, 1047407636, 1041055121, 1025713945, 1049760258);
	sum2 =
		W(0, -1120688670, 988781159, 1023531678, 1034244658) + W(1, 1038669521, -1125227753, -1122152897, -1123518214)
		+ W(2, 1075791226, -1079951996, -1080919050, -1078043585) + W(3, 1061514147, 1050383220, 1043495776, 1056154705)
		+ W(4, 1072772368, -1096143661, -1087274515, -1074830486)
		+ W(5, -1138433181, -1091737459, 1043710967, 1064633897)
		+ W(6, 1033088733, -1126178338, 1039982901, -1153355920)
		+ W(7, 1047086021, -1117938706, 1036258954, -1090859740);
	WS(-1086114623, -1084816591);
	sum1 = W(0, -1119067590, 1041053515, -1123050946, 1050414506)
		 + W(1, 1017204584, 1033253648, -1109025761, -1142909644)
		 + W(2, 1036163639, -1112478813, 1045609440, -1091176571)
		 + W(3, -1096458464, -1092456237, 1039781304, 1019336538)
		 + W(4, -1106221778, -1114565991, -1102274148, 1041957568)
		 + W(5, -1140250052, 1042499428, 1024592194, -1110741472) + W(6, 1015833809, 1041839788, 1038604869, 1049671879)
		 + W(7, 1016035267, 1004159150, 1019624502, 1038938427);
	sum2 =
		W(0, 1006657945, -1145756082, -1102183527, 1043063832) + W(1, 1048257970, 1030027167, -1129422896, -1120006792)
		+ W(2, -1115603798, -1129023472, 1024575987, -1070476153) + W(3, 1078068971, 1034687231, 1014471457, 998969122)
		+ W(4, 1043167348, 1029036192, -1134024937, -1079118960) + W(5, 1058188063, 1026633068, -1138449465, 1035752331)
		+ W(6, 1032033598, -1122908214, 1013148193, -1117007948)
		+ W(7, 1026806223, -1106350665, 1037397710, -1119066852);
	WS(1058895967, -1115291633);
	sum1 = W(0, -1125313920, -1110715998, -1110540830, -1093243535)
		 + W(1, -1098773368, -1114664694, -1108229374, -1128878150)
		 + W(2, -1118075736, 1028840739, 1050429809, 1056177832) + W(3, 1050921353, 1021103494, 1039051533, 1048765371)
		 + W(4, -1101537045, -1106860038, -1109809347, 1062536899)
		 + W(5, 1050429425, 1042267175, -1104944731, 1019165331)
		 + W(6, -1102743433, -1113756805, -1112821659, -1094426092)
		 + W(7, -1112140166, -1105504016, -1123143221, -1113092552);
	sum2 =
		W(0, -1118991740, 1035161218, 1031409558, 1025873763) + W(1, -1130385854, -1109675818, 1035221069, -1106515599)
		+ W(2, 1049660250, -1092533458, 1052404039, 1059098325) + W(3, 1035329255, 1033133876, -1100849576, 1041079456)
		+ W(4, -1072802862, -1084844108, 1059153934, 1066715964) + W(5, 1054800035, -1121630224, 1017402854, 1051036492)
		+ W(6, -1093107290, -1131472334, -1099814906, 1050189246)
		+ W(7, 1033113369, 1032032260, 999987753, -1109656332);
	WS(-1088275071, -1079832501);
	sum1 = W(0, -1121609972, 1054795207, -1091175970, 1036185063)
		 + W(1, 1036253081, -1095852779, 1056993046, -1099614386)
		 + W(2, -1140631216, 1001216956, -1109051587, -1108520810)
		 + W(3, -1112588624, -1111932116, 1018114011, -1114447781)
		 + W(4, 1031902612, 1053928586, -1100362195, -1118566269)
		 + W(5, 1050418310, -1106845532, 1057036918, -1106898567)
		 + W(6, -1114449795, 1049117898, -1089874193, 1024185910)
		 + W(7, 1033419200, -1098704820, 1052334541, -1103629998);
	sum2 = W(0, 1034198694, 981839325, 1050051875, 1043520387) + W(1, -1099547613, 1020237946, -1112528204, 1032634213)
		 + W(2, -1099753021, 1036479145, -1087878645, -1099082069)
		 + W(3, 1049181233, -1106552091, 1051666481, -1105193718) + W(4, 1052074243, 1033443852, 1061175239, 1044393022)
		 + W(5, 1036533430, -1125692060, -1100952955, 1038429221)
		 + W(6, -1101897553, -1125560160, -1090657055, -1126528836)
		 + W(7, -1113239720, -1111189720, 1038783930, -1110455840);
	WS(1055684799, 1057467177);
	sum1 = W(0, -1115635180, 1040983065, 1033664034, 1047016048) + W(1, 1040303666, 1031194256, 1036112338, 1031542812)
		 + W(2, -1084593518, -1097583958, -1088354001, -1083875169)
		 + W(3, -1089538899, -1090088564, -1096939300, -1092334596)
		 + W(4, 1057349085, 1048845932, 1059080519, 1057461395) + W(5, 1055847004, 1052697432, 1050363555, 1025617138)
		 + W(6, 1044528285, -1108137881, 1042415046, -1130549589)
		 + W(7, 1025308788, 1040121956, -1124884732, 1051059157);
	sum2 = W(0, 1039076253, 1043377438, -1111770710, -1129064764)
		 + W(1, 1041506513, -1117340191, -1113661124, 1006037802)
		 + W(2, 1084724252, 1057352437, -1070809771, -1070013447)
		 + W(3, 1024963427, -1115045950, 1037860995, -1120758055)
		 + W(4, 1055999642, -1108204793, -1115649819, -1084654208)
		 + W(5, 1027889169, 1023558847, -1108774739, 1034794526) + W(6, -1111202323, 982595482, 1026864091, 1008953953)
		 + W(7, 1041107952, -1112891517, -1161342746, 1036271073);
	WS(-1089965247, 1033154456);
	sum1 =
		W(0, -1118330000, 1043361746, 1028536899, -1106541856) + W(1, -1103233833, 1037178020, -1122355891, -1148310999)
		+ W(2, 1037068672, -1091726905, -1106295439, -1087991002)
		+ W(3, -1094017778, 1026207675, -1102222128, -1106998176) + W(4, 1043453383, 1027410848, 1047994631, 1053447482)
		+ W(5, 1058853977, 1049286760, 1044913013, 1056026770) + W(6, -1112803845, 1030795409, -1111747193, -1109712917)
		+ W(7, -1110327970, -1111739348, 1037236782, -1104668925);
	sum2 = W(0, -1104081637, -1115350296, -1102551062, 1033477476)
		 + W(1, 1048930937, -1092653578, 1049862570, -1095610208)
		 + W(2, -1104712414, 1065017407, -1101193417, 1054909386)
		 + W(3, -1096226206, -1094950793, 1042131871, -1100838677)
		 + W(4, 1038273275, 1027805677, -1097697554, 1069044481)
		 + W(5, 1051154993, -1097937335, -1115393002, -1090656582)
		 + W(6, -1102746442, 1038124336, 1025981021, -1090398660)
		 + W(7, 1049254524, -1111378843, -1100983150, 1038627466);
	WS(1053522367, -1088249107);
	sum1 = W(0, 1041083642, -1109062519, 1041255149, -1129341567)
		 + W(1, -1122816004, 1034422596, -1105678140, 1002201935) + W(2, 1049354980, 1050121221, 1062047573, 1050256849)
		 + W(3, 1058306025, 1054029415, 1043380368, 1057986114)
		 + W(4, -1104528935, -1089361286, -1094323010, -1085946707)
		 + W(5, -1092704114, -1096738148, -1095183726, -1098664466)
		 + W(6, -1116245577, -1108913352, 1044478835, -1106612546)
		 + W(7, 1010650184, -1127765836, 1004046811, -1116617606);
	sum2 = W(0, -1115691041, -1122196578, -1133382325, -1119943136)
		 + W(1, 1035619338, 1026693101, -1121646682, 1035287249)
		 + W(2, 1047105417, 1040512713, -1115639944, -1093984910)
		 + W(3, -1128164365, -1112542694, 1040561229, -1122951759)
		 + W(4, 1066880006, 1072356775, 1070833917, -1106032356)
		 + W(5, -1084317659, -1103058628, -1106694088, -1109474775)
		 + W(6, -1078420733, -1074089832, -1079250237, 1053171659)
		 + W(7, 1063302165, 1050228647, -1111273903, 1041535222);
	WS(1054980735, -1118400611);
	sum1 = W(0, 1023857233, -1136534172, -1109579886, 1024279465) + W(1, 1031638446, 1042081899, 1025101580, 1037741818)
		 + W(2, 1056052581, 1054619866, 1062631892, 1063340895) + W(3, 1054891904, 1032051762, 1036582853, 1040187076)
		 + W(4, -1108899938, -1084632317, -1087670245, -1087714282)
		 + W(5, -1089981519, -1091518889, -1100292439, -1096282711)
		 + W(6, -1098911041, 1014993130, 1019079234, 984908360) + W(7, 1040973935, 1034243544, 1038263499, 1035333164);
	sum2 = W(0, 1048663857, -1115607290, 1050959246, -1094885185)
		 + W(1, 1032263390, -1094433235, 1034671855, -1100445080)
		 + W(2, -1103126769, -1089284711, -1106476140, 1065597134)
		 + W(3, -1114774312, 1044112203, -1110680696, 1044150663)
		 + W(4, -1090522781, -1135630263, -1116194786, 1068281966)
		 + W(5, -1114594327, 1034641663, -1120338125, 1039802827)
		 + W(6, -1135969141, -1096474341, -1110761886, -1097679100)
		 + W(7, 1030603925, 1025157613, -1121778209, -1101519530);
	WS(-1099426814, 1028666567);
	sum1 =
		W(0, 1017347599, -1114817850, -1102332157, 1038414608) + W(1, 1040863441, 1043586729, 1033560385, 1024225691)
		+ W(2, 1050515008, 1054909169, 1058789976, 1049870885) + W(3, -1096181150, -1094822147, -1110297504, 1035801215)
		+ W(4, -1097546199, -1091252816, -1088740593, 1026332624)
		+ W(5, 1050979384, 1046083753, 1043042893, -1106319780) + W(6, -1122852442, 1034424401, 1040697053, -1119196265)
		+ W(7, -1096850298, -1101867410, -1112505198, 1022200238);
	sum2 =
		W(0, 1032296335, -1113414658, 1032045591, -1096252543) + W(1, 1039836782, -1130462124, 1032505935, 1017080436)
		+ W(2, -1113854030, 1056314261, 1056282685, -1076472908)
		+ W(3, 1041975936, 1060789196, -1113045826, -1114544525)
		+ W(4, -1123218166, 1057288090, 1048444709, -1076465599) + W(5, 1054239999, 1064414385, -1101415652, 1017354944)
		+ W(6, 1034439881, -1106401889, 1027355020, -1099548772)
		+ W(7, 1041344971, -1137373456, 1031341874, -1131418272);
	WS(1048405758, 1021439377);
	sum1 = W(0, -1095783591, 1004365570, -1111296393, -1090472608)
		 + W(1, 1053249340, -1096289768, -1116930177, 1031327257) + W(2, 1056714988, 1053912029, 1060368018, 1058906144)
		 + W(3, 1059710205, 1050004859, 1050104788, 1057263364)
		 + W(4, -1095028931, -1097931508, -1093355890, -1084869763)
		 + W(5, -1111710658, -1089344390, -1098648430, -1095692170)
		 + W(6, -1099026446, 1040281084, 1042667324, -1099317986)
		 + W(7, 1058667863, -1094050929, 1032145973, -1127343131);
	sum2 = W(0, -1137650289, -1108324664, -1107068637, 1053004242)
		 + W(1, -1096186406, 1044011702, 1031462490, 1016473473)
		 + W(2, -1102128439, 1038586891, -1102631398, -1096144010)
		 + W(3, 1065778432, -1087564484, 1041037240, -1095964556) + W(4, 1065729447, 1042582877, 1055966210, 1066736444)
		 + W(5, -1077760412, -1109340585, -1088233524, -1079487884)
		 + W(6, -1085103011, -1096095433, -1096657292, -1084794119)
		 + W(7, 1061684194, 1053274132, 1060428365, 1070082531);
	WS(-1120621558, -1109747932);
	sum1 = W(0, 1041405257, 1034046808, -1118447615, 1031113092) + W(1, -1118172841, 1039149197, 1025628006, 1023987646)
		 + W(2, 1056552380, 1057052863, 1034826244, 1061462741) + W(3, 1057041023, 1051800560, 1051243933, 1054503948)
		 + W(4, -1086075216, -1102283433, -1089852749, -1087896594)
		 + W(5, -1089300195, -1089266110, -1098077639, -1098034299)
		 + W(6, 1021959803, 1009707220, 1002695151, 1030648525) + W(7, 1017359341, 1034838445, 1033512688, -1099231069);
	sum2 = W(0, -1072120352, -1071453180, -1069998225, -1071241469)
		 + W(1, -1073669228, -1079882002, -1086087106, -1096258120)
		 + W(2, 1076686179, 1075980741, 1075876198, 1076219984) + W(3, 1072219376, 1071235859, 1056170781, 1057784547)
		 + W(4, -1096491690, 1055107632, -1100816518, 1048961210)
		 + W(5, -1123192163, -1097056656, 1049622318, -1098632303)
		 + W(6, -1109988374, -1125676035, 1033428305, 1018908197)
		 + W(7, 1040773271, -1129279043, 1030403985, -1116156171);
	WS(1014286296, 1057122707);
	sum1 = W(0, -1100574608, -1134927261, -1096946922, -1115033128)
		 + W(1, -1104533485, -1121259095, -1131995140, -1118839498)
		 + W(2, 1045128364, -1112841149, 1023155519, -1094208427)
		 + W(3, -1099169249, -1097752701, -1111007544, -1093400894)
		 + W(4, 1045637171, 1041785732, 1051848326, 1066937726) + W(5, 1058599142, 1049921902, -1118760834, 1043420320)
		 + W(6, -1113867461, 1021982785, -1106336253, -1099783438)
		 + W(7, -1105189673, -1131816685, -1114789302, -1116552190);
	sum2 =
		W(0, 1049653051, -1094509070, 1050525055, -1103662151) + W(1, 1043452805, -1102028885, -1109754017, -1111709279)
		+ W(2, -1095117458, 1054995367, 1042728281, 1058124872) + W(3, 1049859565, -1097129382, -1098619851, 1051259496)
		+ W(4, 1052542945, 1021265631, 1046926465, 1063131010) + W(5, 1029162962, -1116537562, -1092457406, -1078653130)
		+ W(6, 1018695699, -1101605993, 1044635344, -1104882803)
		+ W(7, 1042944443, -1110047725, -1107003327, -1114867517);
	WS(-1089617919, -1078924764);
	sum1 = W(0, 1038586191, -1112517470, 1021690773, -1148410045)
		 + W(1, -1123773533, 1037589846, -1114886949, 1015916580) + W(2, 1054651431, 1043170193, 1058605998, 1062049174)
		 + W(3, 1056236357, 1058401044, 1034515388, 1056139353)
		 + W(4, -1087542485, -1101086846, -1088163691, -1087004528)
		 + W(5, -1089020247, -1089711896, -1095006441, -1089662071)
		 + W(6, 1032587193, -1121720345, 1034793549, -1139319682)
		 + W(7, 1040971627, 1052009144, 1017461287, -1138694970);
	sum2 =
		W(0, 1041183203, -1109901203, 1047303939, -1146453442) + W(1, -1103370030, 1035308463, -1107592095, -1129723226)
		+ W(2, -1104791361, -1103309504, -1109225788, 1050748307)
		+ W(3, 1032462009, 1055570013, -1104507532, 1050955773) + W(4, -1113641717, 1018299463, 993644855, 1050538753)
		+ W(5, 1024125183, 1058013570, 1044744090, -1110543421) + W(6, 1040266660, -1124518657, 1039912380, -1107008276)
		+ W(7, -1094411631, -1087158984, -1091454514, -1122733934);
	WS(-1102088830, 1068463311);
	sum1 = W(0, 1007817678, -1114291787, -1106493040, -1121377148)
		 + W(1, -1120569345, 1037434082, -1121570543, 1048479966) + W(2, 1054791531, 1051084317, 1059023407, 1060487316)
		 + W(3, 1053262386, 1049438849, 1043319351, 1037267389)
		 + W(4, -1088166471, -1097682087, -1087032011, -1087032009)
		 + W(5, -1090195409, -1104445288, -1110294871, -1112047510)
		 + W(6, 1034628887, -1130503387, 1042839161, 1025313797)
		 + W(7, 1040112167, -1112558866, -1130274577, -1107488086);
	sum2 = W(0, -1092702026, -1078842502, -1073165872, -1075365553)
		 + W(1, -1101579557, 1066341075, 1071992070, 1076187261) + W(2, 1046572938, -1092761370, 1048469719, 1050413401)
		 + W(3, -1110447061, -1104166524, -1123716833, 1056626852)
		 + W(4, -1113806693, 1010298098, -1106037347, 1041503306)
		 + W(5, 1037192623, 1033398310, 1031702363, -1110743783)
		 + W(6, 1023924734, -1134107544, -1114438827, 1017902665)
		 + W(7, 1011674154, -1109271682, 1028552632, -1123830383);
	WS(1050299903, -1120086405);
	sum1 = W(0, 1001761330, 1051426245, -1097473350, 1050955122)
		 + W(1, -1098718343, -1119699408, 1038117517, -1107622229)
		 + W(2, 1015037916, 1042953374, -1103780307, -1082933123)
		 + W(3, 1055455844, -1145769035, -1132909758, 1039587926)
		 + W(4, 1045981578, -1094503950, 1055197076, -1099126616)
		 + W(5, -1118831961, 1049761702, -1105955296, 1047033256)
		 + W(6, 1032160884, -1131440192, -1100940622, 1056645367)
		 + W(7, -1095742542, 1031622998, 1041481643, -1103124921);
	sum2 = W(0, 1033493706, 1004282338, 1032395114, 1035721710)
		 + W(1, -1138557465, -1094630455, 1050323990, -1102984389)
		 + W(2, -1100025935, 1036668146, 1043333590, 1058018229) + W(3, 1035348312, 1040910383, 1034465026, 1044530527)
		 + W(4, -1117747708, -1097774825, -1106149887, -1110236537)
		 + W(5, -1105971349, 1017216296, -1110352462, -1108832665)
		 + W(6, -1131691420, 1042472719, -1122758767, -1106477628)
		 + W(7, 1046834331, -1101697584, 1040100106, -1099114129);
	WS(1059761855, -1093333930);
	sum1 = W(0, -1114738580, -1114617627, -1102727321, 1053910378)
		 + W(1, -1094270689, -1107452471, -1130455238, -1108958070)
		 + W(2, 1026403632, 1045397583, 1028768699, 1067649611) + W(3, -1104323849, 1042776267, 1036450873, 1044075076)
		 + W(4, -1105736123, -1109519752, -1092041414, -1090720496)
		 + W(5, -1112030179, -1103704317, -1131764742, -1106063752)
		 + W(6, -1114933837, 1044731740, -1111636685, 1058839312)
		 + W(7, -1095377736, 1034877772, 1031929286, -1113359528);
	sum2 = W(0, 1033753751, -1102724392, -1104466296, -1083668043)
		 + W(1, 1048180527, -1130490520, -1103926430, 1029490699)
		 + W(2, -1111931472, 1032416705, 1029992729, 1069568682)
		 + W(3, -1114422988, -1133345747, 1038116955, -1129834714)
		 + W(4, 1037689465, -1105246922, 1052475163, -1090236396)
		 + W(5, -1122305941, -1123788932, -1127253836, -1122171294)
		 + W(6, 1023732592, -1126463180, -1118149766, -1106129378)
		 + W(7, 1038071226, -1124715334, -1117123194, 1029091180);
	WS(1058247519, 1058950523);
	sum1 = W(0, -1149972914, 1038957612, 1039970419, 1008158544) + W(1, 1041515382, 1036144305, 1048236362, -1101573740)
		 + W(2, -1088063023, -1093535488, -1086741707, -1077128706)
		 + W(3, -1087332234, 1032313207, -1113848378, -1089306475)
		 + W(4, 1055543086, 1052729022, 1058924163, 1057693884) + W(5, 1060656868, 1056531259, 1049522521, 1052006205)
		 + W(6, 1037155715, 1026693813, 1030719286, 1032127358)
		 + W(7, 1000958261, -1112386573, -1144612480, 1039554949);
	sum2 =
		W(0, 1037957789, -1128637884, -1110859440, 1052981065) + W(1, 1040710261, -1090346288, -1107045102, -1092015484)
		+ W(2, 1050553491, 1004874497, -1106433025, 1058989771) + W(3, 1058251934, -1076253449, -1079150504, 1073146781)
		+ W(4, -1089722328, 1058234547, -1098594890, 1052545864) + W(5, -1106724054, 1032950959, 1055215751, 993278274)
		+ W(6, 1050994656, -1095571828, 1041665953, -1129708900)
		+ W(7, -1111634443, 1015279680, 1053553553, -1088813426);
	WS(-1079689312, 1054955487);
	sum1 = W(0, -1112827293, 1038847520, -1106748654, 1038138418)
		 + W(1, 1035397268, 1020226162, 1030022886, -1108673687)
		 + W(2, -1094091800, -1099397203, -1102151838, -1086663035)
		 + W(3, -1087965823, -1095805620, -1098762192, -1096846716)
		 + W(4, 1053343716, 1057879171, 1023820222, 1057249493) + W(5, 1057985827, 1053821069, 1051466543, 1049463311)
		 + W(6, 1046408387, -1099233409, -1154890390, 1012875058)
		 + W(7, -1109124523, -1126965269, 1036334304, 1027304762);
	sum2 = W(0, 1029906557, -1110945783, 1046588193, -1121400966)
		 + W(1, -1106274145, 1040948990, -1114149785, 1030737726)
		 + W(2, -1118908362, -1110004947, -1089040350, -1106443118)
		 + W(3, 1054044230, -1115139995, -1112260837, 1025987216)
		 + W(4, -1075330978, -1081100797, -1089891752, -1103643831)
		 + W(5, -1095873523, -1120742988, -1107023588, 1017833328)
		 + W(6, 1069116571, 1067844910, 1066162938, 1048795077) + W(7, 1049522444, 1042365723, 1011222152, 1031208089);
	WS(1045323518, -1099573370);
	sum1 = W(0, 1043494028, -1110296205, -1129034139, 1040205415)
		 + W(1, 1019451328, 1037480760, -1144942569, 1019441962) + W(2, 1054678847, 1050638833, 1058657792, 1062545342)
		 + W(3, 1053087270, 1054717567, 1044080591, 1056118375)
		 + W(4, -1087400961, -1098183847, -1085969705, -1082320511)
		 + W(5, -1092792902, -1090230188, -1094581114, -1090342307)
		 + W(6, 1041221965, 1038272854, 1035507984, 1038672050) + W(7, 1018934299, 1028598065, 1032398451, -1135273190);
	sum2 =
		W(0, -1115726367, 1028786141, 1044450180, -1097529180) + W(1, 1047479398, -1105649332, -1127420023, 1035799966)
		+ W(2, -1100272494, -1113941052, -1104186275, 1042859033)
		+ W(3, -1097402721, 1051025911, 1025042835, -1139194229) + W(4, 1026681555, -1107020345, 1044693748, 1067055887)
		+ W(5, 1064288021, 1073649944, 1067916626, 1054550763) + W(6, -1095030133, 1043410282, -1120312046, -1093369648)
		+ W(7, -1083945294, -1073003592, -1079526678, -1086831079);
	WS(-1086660959, -1095040438);
	sum1 = W(0, -1137772688, -1103872010, 1033664792, -1114303830)
		 + W(1, 1043631948, -1110960013, -1112201312, 1004207675)
		 + W(2, -1101831491, -1108733164, -1099393082, -1091611870)
		 + W(3, -1111668992, -1092153253, -1104258339, -1111896549)
		 + W(4, 1047762270, 1048734598, 1053294440, 1032897582) + W(5, 1054700448, 1051790266, 1038982672, 1042342295)
		 + W(6, 1026497863, -1112526127, 1036444877, -1105948909)
		 + W(7, 1045765800, -1102627253, 1030853145, 1024477884);
	sum2 = W(0, 1047134358, 1032860761, 1058187056, -1089859690)
		 + W(1, -1073724300, -1113017653, -1123513506, 1005834992)
		 + W(2, -1100773581, 1019143260, -1086969962, 1060822499) + W(3, 1074524802, -1127402252, 986153015, 1026902445)
		 + W(4, 1038575217, -1097448906, 1050436365, -1092585260)
		 + W(5, -1097001013, 1052022456, -1101541136, 1040058169)
		 + W(6, -1121016162, 1027754828, -1118814167, 1047705700)
		 + W(7, 992280012, -1115523910, 1026625966, -1115254226);
	WS(1065625968, 1033455989);
	sum1 = W(0, 1037701789, -1137040283, 1000406064, -1094784938)
		 + W(1, 1050863995, -1103592251, 1032127959, 1038622703)
		 + W(2, -1151616802, -1099349487, 1047711372, -1115632781)
		 + W(3, -1088133648, 1049293870, -1118922740, -1120882929)
		 + W(4, -1102944307, 1053320242, -1098462560, 1053161728)
		 + W(5, 1049613697, -1128175786, 1017489163, -1119810116)
		 + W(6, 1035789757, -1106274637, 1048627484, -1098374228)
		 + W(7, -1120581030, -1114622845, 1038993832, -1165953346);
	sum2 =
		W(0, 1035866397, -1103116216, 1059558286, 1058384307) + W(1, -1096953271, 1042132369, -1111426470, -1128202268)
		+ W(2, -1099238508, 1047962584, -1082734190, -1088122523)
		+ W(3, 1056069525, -1106560803, 1038442279, 1028886015) + W(4, 1052038184, -1105248240, 1057669233, -1091086098)
		+ W(5, -1083280561, 1032403631, -1104452063, -1150402298)
		+ W(6, -1107491561, 1027069673, -1098068789, 1053762892)
		+ W(7, 1064349048, -1107462772, 1040922744, 1012204557);
	WS(1066439152, -1108830929);
	sum1 = W(0, -1102916748, -1108788820, -1097607254, -1099017414)
		 + W(1, -1168846782, -1109193920, -1128476473, -1106724277)
		 + W(2, 1055608939, 1051866141, 1058768962, 1030462560)
		 + W(3, -1113005110, -1109987210, -1109670205, -1105116142)
		 + W(4, -1103898045, -1097938907, -1093577324, -1125603603)
		 + W(5, 1040477611, 1050862423, 1039038758, 1053895221) + W(6, 1013732302, 1035488645, 1043113957, 1027216291)
		 + W(7, -1143171172, -1118580993, -1107320747, -1107171108);
	sum2 = W(0, 1050905005, 1051922636, 1052154527, 1005525738)
		 + W(1, 1024591478, -1094205878, -1094330307, -1105421569)
		 + W(2, 1051409035, -1107944278, 1040207956, 1060123319)
		 + W(3, 1032045878, -1096175996, -1086096303, -1081193369)
		 + W(4, -1123874142, -1131839644, -1100926997, 1046139234)
		 + W(5, -1113252250, 1039675350, -1128729660, 1062516858)
		 + W(6, -1099079861, 1035659117, -1109355656, 1029590720)
		 + W(7, 1032543174, 1044310065, -1129395200, 1042520685);
	WS(-1094347903, 1040885342);
	sum1 = W(0, 1027015666, -1097151811, 1050782150, -1106442815)
		 + W(1, 1051184308, -1091810963, 1034433919, 1042242605)
		 + W(2, -1119901274, 1047615033, -1115052947, 1051587896)
		 + W(3, -1105704339, 1046407197, 1009768300, -1122889273)
		 + W(4, -1109404651, 1051228067, -1096976391, -1096200649)
		 + W(5, -1126487153, 1040585575, -1132445914, -1108464678)
		 + W(6, -1145327523, -1096635113, 1048638245, -1105180361)
		 + W(7, 1051518582, -1092825760, 1038762547, 1040013733);
	sum2 =
		W(0, -1121205117, 1031829824, -1105324964, -1090390675) + W(1, -1110420773, 1018005966, -1113281242, 1032068637)
		+ W(2, -1124056141, -1109805410, 1045427632, 1059020251)
		+ W(3, -1107061510, -1118368537, -1115675784, -1113920834)
		+ W(4, -1106581817, 1007706034, 1046732003, 1057752640) + W(5, -1101115525, -1103994134, 1036673543, 1042522746)
		+ W(6, 1026565438, 1029970286, 1047283254, -1089850616)
		+ W(7, 1031976810, 1036394258, -1112565336, -1145818031);
	WS(1066366016, -1121083386);
	sum1 = W(0, -1127500850, -1122305754, 1025706181, -1104671484)
		 + W(1, 1043832110, -1111488580, -1123271764, 1015742169)
		 + W(2, 1026624689, -1114017662, -1088657475, -1098749979)
		 + W(3, -1085705014, 1037547214, -1112264441, -1105147876)
		 + W(4, 1013565235, 1052467062, -1121688536, 1066224034) + W(5, -1112016562, 1041900405, 1043675185, 1022047173)
		 + W(6, -1127181143, 1035730049, 1045310349, 1026340635)
		 + W(7, -1121566277, -1127673329, 998683632, -1132045794);
	sum2 = W(0, -1102951634, 1044058166, 1037657608, -1091261805)
		 + W(1, 1057746121, -1106029228, 1006392595, -1119100020)
		 + W(2, 1043023116, -1093545812, -1093647750, 1070997171)
		 + W(3, -1082044166, 1051593249, -1100798567, 1013819138)
		 + W(4, -1104735391, 1058451408, -1104370519, -1105620254)
		 + W(5, -1091103100, -1096225251, 1052307063, -1121077487)
		 + W(6, 1035018995, -1112978123, 1043811519, 1052846459)
		 + W(7, -1097428497, -1127092852, -1107453736, 1041369362);
	WS(1059191103, 1030618557);
	sum1 = W(0, 1034200101, 1053678608, -1114145283, 1047695489)
		 + W(1, -1114663316, -1137634576, -1125278731, -1138534517)
		 + W(2, 1032351793, 1049973094, 1058794603, 1053292689) + W(3, 1055818163, 1053263444, 1041016873, 1043320696)
		 + W(4, -1100440271, -1098031908, -1087452589, -1078695803)
		 + W(5, -1125225546, -1094543429, -1116533557, -1104858229)
		 + W(6, -1148363237, 1026486548, -1194991971, 1043453347)
		 + W(7, 1033675947, 966472909, -1115520783, -1119664758);
	sum2 = W(0, 1021496216, -1072453458, -1079530578, 1063841069)
		 + W(1, -1095958945, 1042172731, 1015153576, -1132334880)
		 + W(2, -1095812325, -1094113031, 1068683999, 1074699170)
		 + W(3, 1043477830, 1031880682, -1121439437, -1115200049)
		 + W(4, -1116672596, -1112299630, -1135088113, -1126165044)
		 + W(5, -1107446259, -1119142347, 1037216194, 1034903618) + W(6, 1031503244, 1023122856, 1036078566, 1036242384)
		 + W(7, -1100441243, 1009915385, -1114450875, 1017712520);
	WS(-1096433855, 1052342409);
	sum1 = W(0, -1117693364, 1041070378, -1105417036, 1052133240)
		 + W(1, 1042648272, -1123398616, 1044512510, -1105041790)
		 + W(2, 1042163431, -1095385709, 1060080198, -1090036408)
		 + W(3, -1090327769, 1043184694, -1111854479, 1043408999)
		 + W(4, 1006023611, 1034697390, -1109633387, -1085473397)
		 + W(5, 1057448056, -1105658040, -1104977148, 1041051171)
		 + W(6, -1113444755, 1049542464, -1112382959, 1048891757)
		 + W(7, -1111238376, -1106505885, 1049508979, -1110665802);
	sum2 = W(0, 1039259027, -1119373866, -1086821333, 1052826002)
		 + W(1, -1117342490, 1036052293, 1037381955, -1101694007)
		 + W(2, 1043188759, -1082984200, -1077733706, 1067327309)
		 + W(3, -1149070344, 1052358305, -1102382047, 1050777563)
		 + W(4, -1165551167, -1105050294, -1103802686, 1068967257)
		 + W(5, 1054626023, -1101813629, -1103461210, -1106555317)
		 + W(6, -1113326246, 1045229872, -1109909290, 1052700624)
		 + W(7, -1098764713, -1099183932, 1052205497, -1096821402);
	WS(1046655614, 1069864308);
	sum1 = W(0, 1035633391, 1040943483, 1045417382, 1043913370) + W(1, 1050212129, 1047844019, 1039058852, 1043891960)
		 + W(2, -1106200785, 1031319761, -1120751363, -1093886310)
		 + W(3, -1098821847, -1088130094, -1092291401, -1082722808)
		 + W(4, -1105260712, 1026979270, -1106053451, -1121044950)
		 + W(5, 1042106970, 1049054225, 1041620790, 1042598038) + W(6, 1050507575, 1034433460, 1045765948, 1041581532)
		 + W(7, 1029812249, 1017929306, 1028938706, 1034869942);
	sum2 = W(0, -1098805029, -1101136548, -1094351375, -1097728468)
		 + W(1, 1040878916, 1049713965, 1037060075, 1058810464)
		 + W(2, -1082465618, -1084472150, -1085764460, -1140347496)
		 + W(3, -1100091144, 1049328541, 1062808960, 1071144827) + W(4, 1017798412, -1108050411, 1031330790, 1053843229)
		 + W(5, 1043199898, 986797508, -1119994130, -1097822096) + W(6, 1045866690, 1039888035, 1027046574, 1038111290)
		 + W(7, -1100094208, -1104239104, -1098800085, 1017716576);
	WS(-1077527440, 1065234224);
	sum1 = W(0, 1031059492, 1014606833, 1041495444, 1031584061) + W(1, -1143158030, -1140389945, 1035424519, 1013235228)
		 + W(2, -1088676934, -1098001853, -1087241405, -1083911392)
		 + W(3, -1095088526, -1096536807, -1104484775, -1100223239)
		 + W(4, 1055802445, 1051162632, 1059501583, 1061276187) + W(5, 1050088278, 1049527800, 1042937212, 1037087943)
		 + W(6, -1159469258, 1001612013, -1109463457, -1105280809)
		 + W(7, 1038556792, 986827883, 1030875577, 1047418837);
	sum2 =
		W(0, 1026928347, 1006719462, -1103317527, 1043604137) + W(1, -1106627965, 1034526167, -1117999031, -1134258967)
		+ W(2, 1019217071, -1098369589, 1041304779, -1134457784)
		+ W(3, 1048134757, -1118427047, 1029994729, -1113504087)
		+ W(4, 1027288437, -1099640354, 1050941648, -1112266437) + W(5, 1027462477, 1040843010, -1104465031, 1054764710)
		+ W(6, -1112677997, -1146387796, -1072403340, -1071428003)
		+ W(7, -1082446250, 1059493547, 1072461191, 1077848621);
	WS(1034219259, -1130863201);
	sum1 = W(0, -1122470601, -1125729883, -1119868741, -1092963050)
		 + W(1, -1102984950, 1017182198, -1107264969, -1116589116)
		 + W(2, 1036468120, 1031973022, 1045421587, 1062931954) + W(3, 1062738826, 1050208654, 990945063, 1023027040)
		 + W(4, 1033355302, -1125640547, -1122038588, 1044707408)
		 + W(5, -1104269382, -1106320445, -1110744610, -1098846428)
		 + W(6, -1104067775, -1112351746, -1106594245, -1094830635)
		 + W(7, -1127079049, -1109997276, -1112571199, -1117279521);
	sum2 =
		W(0, -1120041672, 999703935, -1109032994, 1041627711) + W(1, -1111815622, 1029813110, -1110751572, -1114401610)
		+ W(2, 1041156572, 1029144962, 1037796455, 1046556501) + W(3, 1060385029, 1040466231, -1103822492, -1076222058)
		+ W(4, -1103868400, 1036670980, 1043292537, 1059414852) + W(5, 1048639871, -1105513272, -1100107078, 1043280503)
		+ W(6, 1036471018, -1107170022, -1115113192, 1029249656)
		+ W(7, -1126242312, 1043143286, -1101226736, 1034327293);
	WS(-1097041087, -1081891922);
	sum1 = W(0, 1045201037, 1042240134, 1049780286, 1039927583)
		 + W(1, -1122695635, -1110484942, -1117417409, 1039840796)
		 + W(2, -1097075376, -1091271089, -1094847921, 1059654550)
		 + W(3, 1056430510, 1057233913, 1041827328, 1050554535) + W(4, -1126257330, 1049467348, 1057610047, -1141428591)
		 + W(5, -1089703504, -1087958744, -1096746586, -1096159486)
		 + W(6, -1115394372, -1097795722, -1097045891, -1103383438)
		 + W(7, 1036098616, 1033721138, 1035539581, -1131932502);
	sum2 = W(0, 1012982255, -1101224821, -1109376974, -1116588919)
		 + W(1, -1096183361, -1092858264, -1090462581, -1119652925)
		 + W(2, 1052214657, 1042508745, 1042044290, 1071547407)
		 + W(3, -1089469015, -1090264503, 1039700797, -1083767147)
		 + W(4, -1136022111, -1093748656, 1045672838, 1065241977)
		 + W(5, 1049249478, 1047260540, 1046964814, -1107087862) + W(6, 1032353073, 1020863779, -1113516472, 1040242686)
		 + W(7, -1120964187, -1103746594, -1100885683, 1028764718);
	WS(-1088621983, 1079497913);
	sum1 = W(0, 1027161409, -1102075462, -1120075900, -1109063205)
		 + W(1, -1104005172, -1136555883, -1112015962, 1033292370)
		 + W(2, 1052712773, 1051824794, 1057942154, 1060662493) + W(3, 1062931830, 1057800198, 1047971474, 1059753504)
		 + W(4, -1102058289, -1098602113, -1096292664, -1082645434)
		 + W(5, -1090788424, -1090185155, -1098101583, -1088742454)
		 + W(6, -1100368317, 1021667349, -1106147487, 1039175801)
		 + W(7, -1129475640, 1036809656, 1009161622, -1143403778);
	sum2 =
		W(0, -1150684740, -1114056841, -1164208415, 1034698244) + W(1, -1134574697, 1043895716, -1101980686, 1050191679)
		+ W(2, -1095235693, -1115238312, -1080604054, -1071093346)
		+ W(3, -1083926997, 1068501149, 1079699126, 1056576712)
		+ W(4, 1044985054, -1127339724, -1106549807, -1080554397)
		+ W(5, -1104923511, 1052487431, 1054997905, 1029700329) + W(6, 1035589955, -1108218072, 1022130402, -1106288272)
		+ W(7, 1024268734, 1036117000, -1130803558, 1031345667);
	WS(-1087955103, 1023517655);
	sum1 = W(0, -1106663590, 1037773274, -1116651838, 1022742037)
		 + W(1, 1040438284, -1117813952, 1032561623, -1102318801)
		 + W(2, -1090071677, -1103425461, -1089596734, -1082614473)
		 + W(3, -1088542372, -1092404165, -1100716355, -1098396937)
		 + W(4, 1062902614, 1055773525, 1059014377, 1060267482) + W(5, 1057943128, 1054561254, 1051603940, 1049819671)
		 + W(6, 1013889298, -1100022495, -1101161913, 1030094516)
		 + W(7, -1120043085, -1116951793, 1035114019, 1026546470);
	sum2 = W(0, -1107653444, 1032757863, -1150202006, 1037010009)
		 + W(1, 1026258576, 1041748319, -1131622502, -1112646994)
		 + W(2, -1094858135, 1061839668, 1049735190, -1123088190)
		 + W(3, -1089824138, -1098358767, 1049699018, -1103776938)
		 + W(4, 1084595456, 1074196920, 1067688119, 1070729644) + W(5, 1050587980, 1057889952, -1127981435, 1048602984)
		 + W(6, -1065438414, -1069856939, -1073375528, -1082206819)
		 + W(7, -1086758222, -1097734258, -1106404220, -1098587943);
	WS(-1089607615, 1063931357);
	sum1 = W(0, -1156148665, 1033042784, 1027235975, -1117005684)
		 + W(1, 1045226606, -1112863441, 1040283212, -1102751384)
		 + W(2, -1089422721, -1099513696, -1086976804, -1083936660)
		 + W(3, -1089259880, -1092850238, -1096473171, -1096124078)
		 + W(4, 1059281720, 1053472432, 1060428066, 1061258678) + W(5, 1055780369, 1057981025, 1051704489, 1054893029)
		 + W(6, 1041177357, -1107985659, -1122980350, -1103260375)
		 + W(7, -1111710595, -1109580750, -1125267169, 1035448166);
	sum2 = W(0, 1024298597, 1037699935, 1030404477, -1094400051)
		 + W(1, 1052543759, 1024136176, -1159281410, -1102232478)
		 + W(2, 1074606150, 1048614297, -1085515118, -1071672142)
		 + W(3, -1091215560, -1095087497, 1050441058, 1071366890)
		 + W(4, 1080820206, 1047271097, -1079656120, -1066721483)
		 + W(5, -1078287609, -1096732136, 1057126689, 1074685383)
		 + W(6, 1030125639, -1121834510, -1166463196, -1101580999)
		 + W(7, 1028051862, 1009399200, -1117118368, -1113696211);
	WS(-1083901183, 1060981851);
	sum1 = W(0, -1106299749, 1039492049, -1113140273, 1055856482)
		 + W(1, -1103186821, -1108369378, -1115937041, -1127954738)
		 + W(2, 1048978486, -1107896957, -1119192025, -1090009641)
		 + W(3, -1088174932, 1034759564, 1008970428, 1027686380)
		 + W(4, 1016862419, -1115539879, -1098481927, 1058119768) + W(5, 1052019064, 1048477348, 1034559233, 1044214632)
		 + W(6, -1121286832, 1049662006, -1106196840, -1149152444)
		 + W(7, -1101797848, -1146708651, 1024756171, -1111878699);
	sum2 = W(0, 1030335348, -1110488253, -1096373435, 1042224202)
		 + W(1, 1038378538, -1117770266, 1036930446, -1168276161)
		 + W(2, -1130369060, 1056034410, -1097486091, -1094958491)
		 + W(3, 1057631708, -1114209587, -1105273765, -1115537765)
		 + W(4, -1106797797, 1040331307, 1063611375, -1106971469)
		 + W(5, -1093142933, 1037075531, -1115233817, 1025218793)
		 + W(6, 1006653296, -1094310491, -1113782011, 1042512890)
		 + W(7, -1140559356, -1114686161, -1115373149, 1026640233);
	WS(1063762143, -1098158381);
	sum1 =
		W(0, 1027555010, -1113176415, 1044835884, -1094480963) + W(1, 1042205032, 1038186408, -1112247611, 1041241393)
		+ W(2, -1106988831, 1049655577, -1089572014, 1041189880) + W(3, 1035602487, -1095655321, 995617211, -1102946366)
		+ W(4, 1031921883, 1032851437, -1106152127, 1057311541) + W(5, -1100163979, 1046700975, 1050763922, -1119959180)
		+ W(6, 1033567284, -1099137927, 1052671923, -1101762329)
		+ W(7, -1106014811, 1044902280, -1094051821, 1044480349);
	sum2 =
		W(0, 1010916279, -1108274646, -1108043460, 1049469526) + W(1, 1061284555, -1097521196, 1047936551, -1106103943)
		+ W(2, 1040615985, 1037755544, -1107213139, -1085933104) + W(3, -1098201753, 1027381238, 1007266289, 1039340208)
		+ W(4, -1103581164, 1053142923, -1091384808, -1093682556)
		+ W(5, -1095835641, 1044225612, -1101597200, 1011948943)
		+ W(6, -1126424725, -1119616718, 1062997316, 1050086980)
		+ W(7, 1044548392, -1099920539, 1043928239, -1120667237);
	WS(1060336095, -1119657045);
	sum1 = W(0, 1023788715, -1117126579, -1108875843, 1022815367)
		 + W(1, -1100562722, 1043213137, -1111482971, -1142747249)
		 + W(2, 1048279897, 1044311660, 1062204714, 1060724749) + W(3, 1063043033, 1050929706, 1037241746, 1051192212)
		 + W(4, -1106238784, -1096869700, 1019770348, -1081389759)
		 + W(5, -1084472996, -1097593661, -1106654286, -1102133781)
		 + W(6, -1110161279, -1136931731, -1115905233, 1034904806)
		 + W(7, -1124661292, 1017832853, -1109716592, -1109353889);
	sum2 = W(0, 1036664563, -1103288529, -1102134383, 1057556566)
		 + W(1, -1099512639, 1031668335, -1103860103, 1028018661)
		 + W(2, 1009247708, -1126560341, -1067246446, 1067728497)
		 + W(3, 1078180911, -1085231458, 1047956293, -1114058193)
		 + W(4, 1013790140, -1102369678, 1047852878, -1093152080)
		 + W(5, -1110504691, 1042704555, -1132621098, 1030531898) + W(6, 1035577258, 1008412166, 1016094574, 1045655865)
		 + W(7, -1123477495, 1023608957, -1112760821, -1120624893);
	WS(1035518203, 1045613832);
	sum1 = W(0, 1044215468, -1096085823, -1102751483, 1007706274)
		 + W(1, -1098118842, 1051305356, -1096250919, -1106455273)
		 + W(2, 1057279232, 1043513429, 1057361220, 1061539183) + W(3, 1057962612, 1058710773, 1037420261, 1053125757)
		 + W(4, -1097478568, -1096451901, -1091716958, -1085528932)
		 + W(5, -1093017477, -1091718961, -1100741095, -1097230063)
		 + W(6, 1042423606, -1098498663, 1012832112, 1054368634)
		 + W(7, -1103819295, 1057808613, -1100568821, -1111733504);
	sum2 = W(0, -1105709018, 1050542737, -1106108137, 1027983028)
		 + W(1, 1053295819, -1091042532, 1049054259, -1108416827)
		 + W(2, 1058997495, -1084246791, -1103685622, -1106510960)
		 + W(3, -1089515541, 1066680974, -1088412186, 1037143386)
		 + W(4, -1086433444, 1065459234, 1055198365, -1102412567)
		 + W(5, 1057925132, -1080963495, 1056230430, 1049505110) + W(6, 1022365788, -1101303092, 1040995532, 1044759128)
		 + W(7, -1104466949, 1043286350, -1096360229, -1106131860);
	WS(-1103921662, 1072713673);
	sum1 = W(0, 1042712209, -1130675027, 1041149044, -1108819823)
		 + W(1, -1099465033, -1102885798, -1108891552, -1122152216)
		 + W(2, -1111681022, -1104528338, -1103688784, 1055222237)
		 + W(3, 1063848575, 1053207587, 1051374172, 1044600823) + W(4, 1029885560, 1032835743, 1053127408, -1089836355)
		 + W(5, -1089832742, -1090841456, -1098121506, -1101098252)
		 + W(6, -1123292759, -1124533373, -1101763282, -1143773237)
		 + W(7, 1044926036, 1032528402, 1040294582, 1018003689);
	sum2 = W(0, -1116466906, 1032691193, -1110682367, -1134651946)
		 + W(1, 1019799157, 1020309206, 1028255175, -1118897648) + W(2, 1017580326, 1031996320, 1040673767, -1121084452)
		 + W(3, 1012141662, -1123645954, -1125118807, 1005021204)
		 + W(4, -1100144980, 1045143645, 1055366708, -1112456349)
		 + W(5, 1037079065, 1036705771, -1112096331, 1021253254) + W(6, 1018640494, 1067424527, 1071822180, 1057195246)
		 + W(7, -1078565795, -1073530916, -1087156462, 1033125682);
	WS(1054959295, 1011151216);
	sum1 = W(0, -1124554365, 1028540695, -1107828893, -1135601758)
		 + W(1, -1135515507, 1032466990, -1110097877, 950109203) + W(2, 1043778462, -1104732576, 1063706911, 1052343180)
		 + W(3, 1050410381, -1128754020, 1034222620, 1043960229)
		 + W(4, -1140499785, -1111020475, -1098481604, -1081762405)
		 + W(5, 1053053447, -1112972157, 1023071124, -1120112616)
		 + W(6, -1103855992, -1113072532, -1121738665, 1048654720)
		 + W(7, -1096321673, 1012954617, -1110289546, -1114439871);
	sum2 =
		W(0, -1104841432, 1047690020, -1084375561, -1086552004) + W(1, 1046416693, 1025710892, -1130856953, -1113936449)
		+ W(2, 1047456971, -1094867354, 1068880529, 1065412328)
		+ W(3, -1080289298, -1110380578, -1105039836, 1016290713)
		+ W(4, 1024424907, 1033457856, 1046341732, -1087761187) + W(5, 1062384539, -1103331799, 1024509174, -1126452938)
		+ W(6, 991739097, -1129013032, -1103560341, 1059009805)
		+ W(7, -1098849357, 1045332030, -1104241974, 1019994493);
	WS(1061669311, 1066543312);
	sum1 =
		W(0, -1120030840, -1111872182, 1046388965, -1109640224) + W(1, 1051640445, -1104742312, 1040612129, 1018742870)
		+ W(2, -1097490380, 1051889621, -1085299564, 1043197314)
		+ W(3, -1099578605, -1114905437, 1033952272, -1095793020)
		+ W(4, 1038501126, -1110528784, 1050043436, 1054292822) + W(5, -1095700775, 1056051928, -1108619674, 1044337364)
		+ W(6, 1026361650, -1112085217, 1019064063, -1116217609)
		+ W(7, 1045441021, -1097066005, -1146667493, 1039394788);
	sum2 = W(0, 1041249103, 1040922446, 1047169006, -1133026152) + W(1, 1045305983, -1121038685, 1032067159, 986169209)
		 + W(2, -1098300344, -1147221163, -1097103704, 1055827658)
		 + W(3, -1082349433, -1105225178, 1036618956, -1102095468)
		 + W(4, 1041141085, 1014590689, -1094689158, 1056443342)
		 + W(5, 1051958562, 1035590360, -1098250629, -1145857885)
		 + W(6, -1123648820, -1115292810, 1021735499, 1023898168)
		 + W(7, -1153021086, 1038130213, 1035045284, 1030074795);
	WS(1066007616, 1040865170);
	sum1 = W(0, 1016703369, -1106398093, -1114560988, -1096325697)
		 + W(1, -1094335779, 1023023221, -1113231876, 1022983872)
		 + W(2, -1154003525, 1038441464, -1112021256, 1050813825)
		 + W(3, 1059033474, -1108543232, 1040892233, 1034570898) + W(4, -1104662792, 1031083397, 1052887594, 1061249791)
		 + W(5, -1126656183, -1106571274, -1121820472, -1115038347)
		 + W(6, -1111826720, -1146451379, -1102003526, -1102172436)
		 + W(7, -1104413998, -1109007926, -1112600993, -1123919488);
	sum2 = W(0, -1117895883, 1036640719, -1092695525, -1109277526)
		 + W(1, 1054484712, -1102073467, 1047716642, -1115714917)
		 + W(2, -1109314178, -1103775527, -1079308608, -1088245301)
		 + W(3, 1032194306, 1058556412, -1097777200, 1049638324) + W(4, 1043196819, 1047073701, 1032498235, 1071134194)
		 + W(5, -1098274857, -1102222667, 1028797614, -1109885254)
		 + W(6, 1029963629, -1117061975, 1053147047, -1113344034)
		 + W(7, 1027577620, -1104158962, 1019489703, -1106961770);
	WS(-1112959995, -1090797387);
	sum1 = W(0, 998546749, -1102515009, 1018649191, 1024148768) + W(1, 1036601843, 991750171, -1134314668, 1024106779)
		 + W(2, -1107113888, -1157171375, -1095395659, -1088418302)
		 + W(3, -1108499994, -1092700079, -1100812608, -1106951576)
		 + W(4, 1042251615, 1043372984, 1057847906, 1049085946) + W(5, 1054314562, 1052242560, 1010001228, 1043704436)
		 + W(6, 1034524319, -1109045169, 1025715818, -1107024218)
		 + W(7, 1036766314, -1102346050, 1041369791, -1136260253);
	sum2 = W(0, -1097076796, 1000463738, -1083533587, 1064100942)
		 + W(1, 1074997490, 1043707697, 1028507309, -1152835380) + W(2, 1045091130, 1024736081, 1064625577, -1096201033)
		 + W(3, -1071550159, -1106033160, -1118548401, -1111712908)
		 + W(4, 1028367411, 1040206702, -1112850496, -1086258418)
		 + W(5, 1052069491, -1098690685, 1050202273, -1113053149)
		 + W(6, 1016501386, -1122385083, -1104146558, 1050125885)
		 + W(7, -1105686824, 1041978517, -1109567340, 1032203802);
	WS(1065286463, -1155116140);
	sum1 = W(0, -1127743664, 1036265535, -1118137852, -1121018025)
		 + W(1, 1024160014, 1028265374, 1031461691, -1116217572)
		 + W(2, -1099417962, -1091060822, -1088882712, -1089265061)
		 + W(3, -1088513194, -1090887512, -1097685517, -1096201501)
		 + W(4, 1047837241, 1038987540, 1061626690, 1069311516) + W(5, 1053957977, 1051214117, 1050330231, 1045642342)
		 + W(6, 1035108393, -1121911642, -1119901843, -1100290432)
		 + W(7, -1101311755, 980641778, 1030945477, 1036102670);
	sum2 = W(0, 1023964675, 1054178647, -1104607531, -1088748842) + W(1, 1034720649, 1027793575, 1026748348, 1048440611)
		 + W(2, -1104287950, -1098771138, 1030951671, 1062304002)
		 + W(3, 1056993385, -1095484784, -1103591056, -1115722179)
		 + W(4, -1095527688, -1106164282, 1049293814, 1069791349)
		 + W(5, -1106129898, -1093744890, 1040804508, -1102843948)
		 + W(6, -1107378538, -1107123343, -1102317974, -1093097006)
		 + W(7, -1107155572, -1104614583, -1111048704, 1036145149);
	WS(-1107864827, -1106183398);
	sum1 = W(0, -1106667222, 1032383543, -1104095901, -1105126732)
		 + W(1, -1119082647, -1099092218, -1106477481, -1100466619)
		 + W(2, 1028246417, -1105288567, 1024277645, 1031807228) + W(3, 1024663749, 1059042594, 1038514313, 1061247795)
		 + W(4, 1062610107, 1048732230, 1033194034, -1097352540)
		 + W(5, 1042072353, -1097841594, -1132497297, -1116357250)
		 + W(6, -1094330385, -1113355593, -1100412503, -1110531197)
		 + W(7, -1106817153, -1119219065, -1116226478, -1112377140);
	sum2 = W(0, -1124057659, -1107748661, -1106641450, -1106278570)
		 + W(1, -1115427744, 1045306633, -1107251222, 1044220643)
		 + W(2, 1049202878, 1029365940, -1100669682, -1090514146)
		 + W(3, 1050790854, -1101749265, 1044664667, 1051259000)
		 + W(4, 1055877653, 1040631102, -1121942624, -1097531540)
		 + W(5, -1095195500, 1044511371, -1123742683, 1035140356)
		 + W(6, 1043135164, -1120955446, 1048773070, -1096084011)
		 + W(7, 1040842880, -1101432694, -1108344435, -1156279482);
	WS(-1107710971, -1103335008);
	sum1 =
		W(0, 1020774038, -1097452822, -1103681302, -1142400543) + W(1, -1130541650, 1035627390, 1026485526, 1026933710)
		+ W(2, 1057965326, 1052789750, 1061528673, 1059882105) + W(3, 1058381533, 1052101646, 1047827121, 1048909172)
		+ W(4, -1096736580, -1097416740, -1090723228, -1082070814)
		+ W(5, -1096313647, -1092903493, -1095953623, -1094072619)
		+ W(6, -1108312647, 1007270548, 1008435167, 1032878150) + W(7, 1024150455, 1029066731, 1024752368, -1129872006);
	sum2 = W(0, -1091198687, -1096592719, -1088722291, 1017819408)
		 + W(1, -1104841225, 1047280108, -1133964792, 1046210234) + W(2, 1051358993, 1056674994, 1050253089, 1057806550)
		 + W(3, -1098514434, -1095745001, -1121773836, -1101840089)
		 + W(4, 1026242284, -1102658445, 1039492851, 1048044980)
		 + W(5, 1047848116, -1114927114, 1009730080, -1115459009)
		 + W(6, 1036983987, -1112372364, -1109827680, 1033031265)
		 + W(7, -1106004699, -1128936304, 1044703642, -1121859563);
	WS(1046617982, -1079283690);
	sum1 = W(0, -1112235521, -1112371935, 1046025067, -1114138877)
		 + W(1, -1100106092, -1106636112, 1006684852, -1134743124)
		 + W(2, -1103103206, 1005568807, -1082068590, 1053438832)
		 + W(3, 1050481934, -1113851306, -1101804759, -1101795702)
		 + W(4, 1050398983, 1053710959, 1059470764, 1056782757) + W(5, -1084354719, 1044662919, 1028720557, 1040488963)
		 + W(6, 1031782004, -1112406582, -1109731202, -1120370051)
		 + W(7, 1047048563, -1114617505, -1122334215, 1035089325);
	sum2 =
		W(0, -1123583696, 1041752924, -1096033091, 1045050816) + W(1, -1111810372, 1044170848, 1035342189, -1107148363)
		+ W(2, -1114190125, -1107057915, 1054169171, 1066165326)
		+ W(3, -1090934807, -1094482563, 1030376713, -1140242036)
		+ W(4, -1123424510, -1108427412, -1101097272, 1060681517)
		+ W(5, -1093738003, -1094742214, -1122528198, 1046835784)
		+ W(6, 1035265901, 1011193218, -1097576107, 1037309084) + W(7, -1094306097, 1047478278, 999245333, -1118953940);
	WS(1057107647, -1115492411);
	sum1 = W(0, 1043432615, 1017716083, -1115224236, 1034158091) + W(1, 1031606075, 1040917102, -1119339928, 1006053250)
		 + W(2, 1037909322, 1044219192, 1059480955, 1055275264) + W(3, 1062186253, 1051479740, 1036604907, 1049031914)
		 + W(4, -1092726398, -1094557923, -1089724826, -1079486955)
		 + W(5, -1094016652, -1090199321, -1111430132, -1124163213)
		 + W(6, 1042270260, 1036944691, 1049175094, 1036017407)
		 + W(7, -1112299996, 1012181234, 1026270626, -1106538704);
	sum2 = W(0, 1018646782, -1107779390, 1048577488, -1094766117)
		 + W(1, 1029078775, -1115207772, 1041354677, -1134027235)
		 + W(2, 1037675363, 1041358579, -1103110037, 1063077105)
		 + W(3, -1094239344, -1097294293, -1106609062, 1005749079)
		 + W(4, 1056993548, -1114299594, -1108103869, 1069120744)
		 + W(5, 1019393926, -1090842684, -1103795001, -1111892981)
		 + W(6, -1095820604, -1106961783, -1113810892, -1094104293)
		 + W(7, -1100654825, 1030620215, 1015746998, 1031888221);
	WS(1038408187, -1104646224);
	sum1 =
		W(0, -1100666444, 1032659338, -1096791479, 1050254507) + W(1, -1125163769, 1034716030, -1104041563, 1024265746)
		+ W(2, 1031841147, -1095811512, 1046629869, -1086582314)
		+ W(3, -1092033141, -1095590162, 1012740704, -1097384267) + W(4, 1045835257, 1046356758, 1055310447, 1049546009)
		+ W(5, 1059064223, 1032941357, 1016606100, 1043234370) + W(6, -1121385297, -1115316924, -1109718991, 1043876936)
		+ W(7, -1115882186, 1051195252, -1110386378, -1121465454);
	sum2 =
		W(0, 1033146053, 1034495435, 1033891153, 1015618236) + W(1, -1102272365, 1026402836, -1126192412, -1130670616)
		+ W(2, 1033178697, 1013274853, 1044565157, -1083473003) + W(3, 1047899954, 1033829854, 1026659107, -1129244632)
		+ W(4, -1110558215, -1103797816, -1074394842, -1075035519)
		+ W(5, 1070896015, -1107786181, 1039466503, 1033633210) + W(6, -1107600367, 1046600596, -1096372667, 1071496075)
		+ W(7, 1070598351, -1103057086, -1099451771, -1106841766);
	WS(1060540543, -1145107984);
	sum1 = W(0, 1016949312, 1033700674, 1008485935, 1050394829) + W(1, 1025975118, 1027755062, -1166944971, 1036625882)
		 + W(2, -1111708420, -1115158282, -1112773425, -1105627788)
		 + W(3, -1166436080, 1049090616, -1131929874, 1027903943)
		 + W(4, 999025948, 1037057540, -1111113150, -1105528438)
		 + W(5, -1092533512, -1097657169, -1125616567, -1104970374)
		 + W(6, -1110878953, 1034636061, 1006219749, 1047777444) + W(7, 1034379342, 1023310559, 1042471825, 1029991232);
	sum2 =
		W(0, -1112727972, 1041061913, 1030171918, 1049192765) + W(1, -1097932217, -1108991614, -1128255593, -1128975721)
		+ W(2, 1028528033, 1047913039, 1058299937, -1088725965) + W(3, 1006741474, 1028842331, -1119404040, 1019613109)
		+ W(4, 1050127712, -1120606988, -1075312291, 1051042420) + W(5, 1061621025, -1120436768, 1041035795, 1038145345)
		+ W(6, 1039139414, -1090975722, -1096898908, 1056682084)
		+ W(7, 1043329296, -1136718330, 1019658885, 1017746289);
	WS(1058512095, 1047466767);
	sum1 = W(0, 1025672397, 1032743763, 1046625694, 1040236986) + W(1, 1041791363, 1042422310, 1024317081, 1034505416)
		 + W(2, -1102753041, 1015664161, -1102686879, -1099087483)
		 + W(3, -1097904327, -1097334084, -1123206279, -1096407969)
		 + W(4, 1037445664, 1032570339, -1091026739, -1089271035)
		 + W(5, -1100626131, 1051389809, 1041773046, 1050962859) + W(6, 1037433000, 1033220516, 1035056566, 1024398415)
		 + W(7, 1043847942, 1042353123, 1037697617, 1047698739);
	sum2 = W(0, -1111694157, -1113457231, 1007020677, -1110494513)
		 + W(1, 1036239980, 1042151096, 1014804229, 1038268008)
		 + W(2, -1097429792, 1040318944, -1109123041, -1087577139)
		 + W(3, -1115766281, 1033854974, 1056323633, 1058473731) + W(4, 1052756319, -1131566802, 1066240251, 1071158756)
		 + W(5, 1055974927, -1085216854, -1076147337, -1078122726)
		 + W(6, -1115035673, -1108486657, 1057627634, 1052796029)
		 + W(7, 1037312144, 1031946717, -1107413695, -1088208012);
	WS(-1087119871, 1051442968);
	sum1 = W(0, -1106951233, 1026199466, -1111827529, 1034911407)
		 + W(1, -1110066258, 1036906330, -1121489041, -1123695161)
		 + W(2, -1101188351, -1102133666, -1096477343, -1081083296)
		 + W(3, -1093686286, -1089794286, -1102503648, -1096524016)
		 + W(4, 1055191809, 1046522759, 1061746551, 1062137809) + W(5, 1056808794, 1061657374, 1025414769, 1043754020)
		 + W(6, -1118371512, 1024298399, -1102462991, -1118895495)
		 + W(7, -1105243164, 1028468933, 1001909715, 1039027467);
	sum2 =
		W(0, 1036012528, -1136414534, 1028357901, 1018170307) + W(1, 996800246, -1115554829, 1018408279, -1128152611)
		+ W(2, -1111568121, 1023613585, 1046290638, -1086518431) + W(3, 1032866656, 1040198779, -1115393969, 1031067220)
		+ W(4, -1125130883, 1037328619, -1077265349, -1068062671)
		+ W(5, 1083861052, 1057186482, -1101393956, 1024816461) + W(6, 1019317279, -1141870971, -1105362146, 1041918725)
		+ W(7, 1040576139, -1110577355, 1032099345, -1109411807);
	WS(1041081598, -1101063046);
	sum1 = W(0, 1038662072, -1105628103, 1046838359, -1112508084)
		 + W(1, -1112561351, 1047812813, -1106996345, 1045311157)
		 + W(2, -1123374599, 1048894326, 1044003395, 1062900743) + W(3, 1058339600, 1041428913, 1044355834, 1013224727)
		 + W(4, 1035193857, -1098151405, -1109376817, -1082115704)
		 + W(5, -1087104856, -1097118497, -1098603955, -1110120844)
		 + W(6, -1104056554, 1009505700, -1107771451, 1039692648)
		 + W(7, 1049374543, -1126547869, 1037690530, -1121969199);
	sum2 =
		W(0, 1034938637, -1110454828, 1044300205, -1094841314) + W(1, 1049263704, -1123904781, 1032882093, 1018550156)
		+ W(2, -1102665080, 1066739686, 1063593500, -1072571644) + W(3, 1050585763, 1033188794, 1040935597, 992411043)
		+ W(4, -1083931487, 1057500561, 1069787057, -1073076170) + W(5, 1057940110, 1049962317, -1103057884, 1032437745)
		+ W(6, -1096043986, 1050111041, 1057117236, -1094917255)
		+ W(7, 992791419, -1119131193, -1129197337, -1139242755);
	WS(1047493374, 1019974383);
	sum1 = W(0, 1039818779, 1022499782, -1111466513, -1128872350)
		 + W(1, -1102282821, 1027318580, -1112367361, -1121442618)
		 + W(2, 1024992878, 1056719767, 1056992349, 1066523241) + W(3, 1057279594, 1050310409, 1043633508, 1050332018)
		 + W(4, -1099980259, -1093967742, -1089692488, -1081677329)
		 + W(5, -1104336096, -1095763174, -1147598863, -1103201160)
		 + W(6, -1119405261, 1017537921, -1134657044, 1032226588)
		 + W(7, -1110606353, 1029746358, -1105211995, -1109613299);
	sum2 =
		W(0, -1109381660, 1024006001, 1048332575, 1030946168) + W(1, -1111460550, -1115660792, 1027780517, -1125113546)
		+ W(2, -1099927212, 1048105027, 1083214625, -1068785948)
		+ W(3, -1080184440, -1125303858, -1129923962, 972536438) + W(4, 1032613200, 1031703418, 1051352300, -1082836395)
		+ W(5, 1047472657, 1027323348, 1006215943, -1123338357) + W(6, 1013674604, -1113331152, 1010546556, -1137462284)
		+ W(7, 1033485356, 1034637753, -1112671380, 1033990282);
	WS(1049191295, 1026054180);
	sum1 = W(0, 1015431080, -1114491642, -1106844240, 1052544606)
		 + W(1, -1101337172, 1006821496, 1048579163, -1107367092)
		 + W(2, -1104530451, 1045418990, -1091806904, -1092275830)
		 + W(3, 1032037152, -1091613549, -1136631349, -1104046587)
		 + W(4, -1120791464, -1105318659, 1059085476, -1096734436)
		 + W(5, 1055073816, 1054997266, -1117752159, 1054027444) + W(6, 1041795830, -1107859847, 1035107546, 1050727987)
		 + W(7, -1098252244, 1024892180, -1114835508, -1107321874);
	sum2 = W(0, 1026733028, -1099170713, -1116840904, -1119731112)
		 + W(1, -1105853851, 1023766170, -1109160117, -1110446049)
		 + W(2, 1045033945, 1052123052, 1011374557, 1034116255) + W(3, 1042679995, -1103542762, 1002727514, -1116987471)
		 + W(4, 1006278578, -1100795787, -1137517037, -1093051584)
		 + W(5, 1032967726, 1030006514, 1010971477, 1032206215) + W(6, 1045459634, 1045732660, 1036547859, 1049735621)
		 + W(7, -1115758581, 1012804929, -1107202197, -1108882618);
	WS(1061349183, 1052960956);
	sum1 =
		W(0, -1129777715, -1138324169, 1040354025, -1113069161) + W(1, 1026875928, -1148679486, 1026350741, -1099366619)
		+ W(2, -1091852750, -1098630008, -1086948121, -1087783598)
		+ W(3, -1090578505, -1098392878, -1105317245, -1113156712)
		+ W(4, 1051531432, 1050117038, 1058780391, 1063142264) + W(5, 1054898923, 1055753851, 1035239971, 1049214940)
		+ W(6, 1028688348, 1001458973, 1026112190, -1101543047) + W(7, 1001807913, -1107707133, 1009551482, 1035358529);
	sum2 =
		W(0, 1030464194, -1114101658, 1031167290, 1076423743) + W(1, 1075592137, -1122765276, -1073082101, -1067763317)
		+ W(2, 1016786912, -1111442214, 1040962599, 1052649879) + W(3, 1059016603, -1109148248, 1031660172, -1093716078)
		+ W(4, -1124271380, 1036708968, -1145350210, -1106763968)
		+ W(5, 1036666460, -1102467968, 1040647493, -1123536642)
		+ W(6, -1112870762, 1035127660, -1119263136, 1030450749)
		+ W(7, -1114823676, 1030453841, -1120712732, 1004437586);
	WS(1049240575, 1032641532);
	sum1 = W(0, 1013730783, -1105480706, -1114036922, -1113879072)
		 + W(1, -1104229785, -1108053747, -1114764169, -1146082265)
		 + W(2, 1058635434, 1033988870, 1060052265, 1060507082) + W(3, 1060417175, 1056801557, 1045744608, 1050162924)
		 + W(4, -1096215015, -1101342144, -1095577996, -1090178495)
		 + W(5, -1088104859, -1096180920, -1096622362, 1035143657)
		 + W(6, -1112522509, -1114702617, 1026538642, -1118644393)
		 + W(7, 1026113715, -1115402364, -1165415829, -1096614130);
	sum2 = W(0, -1122276311, 1035291415, -1120194245, 1040446858)
		 + W(1, -1120530587, -1138075205, 1025217366, -1118638617)
		 + W(2, -1070701037, -1088124412, 1066415245, 1074084237)
		 + W(3, 1049852139, -1122804719, 1023048268, -1139513797)
		 + W(4, -1102500792, -1135890037, 1041496354, -1104713726)
		 + W(5, -1121031703, -1103825640, -1123990667, 1028358694)
		 + W(6, -1123484857, -1122878839, 1004310705, 1043449641)
		 + W(7, 1033156545, 1027648711, 1022832518, -1136916673);
	WS(1058199967, 1050173679);
	sum1 = W(0, 1035142580, 1027370573, -1130262537, 1035504777)
		 + W(1, -1114438555, -1117883815, 1019391016, 1002653538) + W(2, 1049466778, 1058691576, 1039593430, 1068404719)
		 + W(3, 1055172389, 1049428736, 1057860609, 1038434456)
		 + W(4, -1090097411, -1101732588, -1086371009, -1088745136)
		 + W(5, -1085029652, -1087836907, -1099893249, -1090680108)
		 + W(6, -1180331449, 1040649373, -1120260556, 1040680775)
		 + W(7, 1044382793, -1124005336, 1042216563, -1112700144);
	sum2 = W(0, -1116884059, 1053572077, -1098664530, 1052736946)
		 + W(1, -1109898534, -1100793752, 1049155169, -1110972354)
		 + W(2, -1098591960, 1057696884, -1094622297, 1068603564)
		 + W(3, -1110319390, -1092295148, 1060435963, -1093610507)
		 + W(4, 1049382153, 1027480579, -1090176467, 1060239128) + W(5, 1035982822, -1110105636, 1048950002, 1038370396)
		 + W(6, -1103314039, -1088718218, -1083506692, -1093271444)
		 + W(7, -1100206230, 1032439700, 1034453968, 1006875670);
	WS(-1089372991, 1071972514);
	sum1 = W(0, -1138920887, -1111770809, -1102811010, -1115715559)
		 + W(1, 1039086134, -1097310634, 1031148825, 1025838913)
		 + W(2, 1036533027, -1104793556, 1055175791, -1099167419)
		 + W(3, -1087507272, 1049070430, -1119324807, 1003453989)
		 + W(4, -1102318256, 1048489074, -1087761408, 1059252133)
		 + W(5, 1053162297, -1114433380, -1118494745, 1042268638) + W(6, 994211079, -1105180974, 1048668925, 1002658941)
		 + W(7, -1118760057, 1015366427, 1042346841, 1035401151);
	sum2 = W(0, 1030112837, -1120976510, 990074782, -1093456890)
		 + W(1, 1037465699, 1026987255, -1141406991, -1139369648) + W(2, 1042265630, 1036120703, 1034066763, 1054439327)
		 + W(3, -1093016348, 1018637880, -1135344000, 1039303764)
		 + W(4, 1026971571, -1114486026, 1060265655, 1048349987)
		 + W(5, -1099844302, 1021593632, -1122669452, -1105461723)
		 + W(6, -1110663804, 1036038820, -1093575269, -1097582212)
		 + W(7, 1034062294, 1015927322, -1131991172, -1112258092);
	WS(1064707295, -1106068023);
	sum1 = W(0, -1099232505, 1035233224, 1008917721, -1113461090)
		 + W(1, 1030936392, 1004172005, 1027313190, -1115756158)
		 + W(2, -1122722466, -1096714286, -1092366070, -1085444145)
		 + W(3, -1087864449, -1089654074, -1109977746, -1096643772)
		 + W(4, 1050522762, 1050648196, 1057836626, 1065526616) + W(5, 1058128499, 1053303385, 1046037453, 1045431365)
		 + W(6, -1163785122, 1029641572, -1106158547, -1112344246)
		 + W(7, -1120989814, 1023496586, -1132212895, 1026679026);
	sum2 = W(0, -1064765544, -1081497441, 1073825520, 1076205171)
		 + W(1, -1119211273, 1027623494, 1025169073, 1044157267) + W(2, -1093639717, 1052279998, 1049786220, 1062543003)
		 + W(3, -1112239696, -1095053933, 1041086677, -1111173396)
		 + W(4, 1043466147, -1106897145, -1111313590, 1028519541)
		 + W(5, -1110796836, 1038884306, -1138045203, -1103601885)
		 + W(6, -1118670633, 1026058867, -1120615525, 1005098917)
		 + W(7, 1002459349, 1024155429, -1139354443, 1031190784);
	WS(-1111449083, -1157616163);
	sum1 = W(0, -1140902742, -1108906886, -1107746707, -1091492130)
		 + W(1, -1106259270, -1123578095, -1112828291, -1129218172)
		 + W(2, 1050785866, 1041550344, 1063519767, 1070223306) + W(3, 1056548545, 1033679887, 1033485706, 1037279241)
		 + W(4, -1096435822, -1095149714, -1097214657, 1059314470)
		 + W(5, -1091358630, -1102873285, -1098893397, -1105253969)
		 + W(6, -1106580347, -1111739842, -1112949561, -1090511327)
		 + W(7, -1115482851, -1102694659, -1119291392, -1105806553);
	sum2 =
		W(0, 1036877913, -1107073590, -1107699229, 1043855187) + W(1, -1112562117, 1015957137, -1137092650, -1113777301)
		+ W(2, -1106537131, 1029358898, 1059152956, 1059494373) + W(3, -1100478450, 1042289801, -1117856531, 1034651775)
		+ W(4, 1030920508, -1148982309, -1101290720, 1057939604)
		+ W(5, 1054005616, -1078154452, 1052159854, -1095096566)
		+ W(6, -1107276407, -1158332371, -1104066278, 1057817844)
		+ W(7, -1089434898, 1041374005, -1109759735, -1112996199);
	WS(-1078462192, -1081042006);
	sum1 = W(0, 1031777492, 1032754472, 1041664052, -1097597536)
		 + W(1, -1104816664, -1113883983, 1034668408, -1123431127)
		 + W(2, -1099264287, 1043123090, -1089905073, 1061087074) + W(3, 1058804947, 1049386855, 1033759807, 1048603595)
		 + W(4, 1046006998, -1098614104, -1129274543, -1106235787)
		 + W(5, -1084543524, 1054195792, -1107840264, 1024992909) + W(6, 987183826, 1036343655, 1009990171, -1097811109)
		 + W(7, 1031138063, -1097275448, 1026038601, -1120606380);
	sum2 =
		W(0, 1045113399, -1114091637, -1107885511, -1138476145) + W(1, -1105540689, 1035866831, -1106333432, 1027850472)
		+ W(2, 1042319052, -1104675582, -1091877193, 1051152873) + W(3, -1091823953, 1034466874, 1039480371, 1012452041)
		+ W(4, -1096815184, -1111655631, -1112520325, 1061790396)
		+ W(5, 1058061302, -1097657024, 1040922298, -1158709515)
		+ W(6, -1116743882, -1101972302, 1050965596, 1049921296)
		+ W(7, -1092103725, 1042351236, -1102843808, -1125733657);
	WS(1056694143, -1116016311);
	sum1 = W(0, -1113789237, -1100431022, 1050877939, 1018856325)
		 + W(1, 1050520537, -1097203011, -1103919120, -1146363818)
		 + W(2, 1051083644, -1126988186, 1064972735, 1040063173) + W(3, 1063261729, 1049408537, 1026641091, 1053332672)
		 + W(4, -1097139864, -1094809972, -1089357240, -1094444318)
		 + W(5, -1089641983, -1094346349, -1100978845, -1097363714)
		 + W(6, -1123205479, 1034447326, 1036660918, -1108178982)
		 + W(7, 1047968461, -1113292277, 1038849023, -1114302469);
	sum2 =
		W(0, -1117908102, 1013765983, 1045942570, 1086231745) + W(1, 1048993826, -1110131683, 1005670802, -1126497913)
		+ W(2, 1019359999, -1145413682, -1095749402, -1062836828)
		+ W(3, -1094656357, 1037693606, -1125761673, 1018172516)
		+ W(4, -1120905960, 1028148573, 1032861566, -1087097136)
		+ W(5, -1145044098, 1040390747, -1112982831, 1016402027) + W(6, 1017197102, 1027705717, -1127537989, 1031521084)
		+ W(7, 1027867224, -1114691836, 1031905995, -1122299754);
	WS(1058898623, -1129627348);
	sum1 = W(0, -1115961291, -1114910804, -1099814536, 1014875535)
		 + W(1, 1042946610, 1008636276, -1106406626, -1120594878) + W(2, 1024824451, 1028416398, 1053775806, 1049045373)
		 + W(3, -1081844071, 1031972351, 1007262993, 1044145240)
		 + W(4, 1015893437, -1107386562, -1081677098, 1054905786) + W(5, 1057687981, 1045923489, 1043411542, 1016529769)
		 + W(6, -1111982511, 1040362701, 1049488325, 1016424474)
		 + W(7, -1105282974, -1118478155, 1018226304, 1008933435);
	sum2 =
		W(0, -1133545882, 1048887568, -1092588040, 1040041167) + W(1, -1098849827, 1009986974, 1044263399, -1120224962)
		+ W(2, 1024635319, -1104650552, -1106613727, 1061771033) + W(3, 1059347143, 1020453405, -1100016935, 1003801667)
		+ W(4, -1123675276, 1009836758, -1090053582, 1063348295)
		+ W(5, -1095509129, -1091467004, 1034750124, 1013849670)
		+ W(6, 1049399700, -1109494815, -1105276085, -1099749985)
		+ W(7, -1094328117, 1040581639, 1041257354, -1116729410);
	WS(1051954047, 1053754534);
	sum1 = W(0, -1115617616, 1024010640, -1105864485, -1104806436)
		 + W(1, -1109064955, -1116880702, -1125878182, 1017392662)
		 + W(2, 1038078984, 1036755054, 1063482792, 1054877383) + W(3, 1061183100, 1032370277, 1043596932, 1041423460)
		 + W(4, 1012663597, -1111840872, -1094956956, -1088048944)
		 + W(5, -1092794954, -1106496725, -1106933961, 1027390113)
		 + W(6, -1106689047, 1027644834, 1000291764, -1099610254)
		 + W(7, 1030290339, -1110075188, -1134690355, -1125796047);
	sum2 =
		W(0, 1032585330, -1120362784, 1053495069, -1103911013) + W(1, -1152525762, -1128147020, 1012657824, -1104983105)
		+ W(2, 1041153226, 1038083675, -1085822417, 1062089523) + W(3, -1088542584, 1044421032, -1113855086, 1041652917)
		+ W(4, -1098242715, -1097998955, -1097864806, 1056336567)
		+ W(5, 1061326318, 1046053205, 1042938789, -1160964996) + W(6, 1045110917, 1041971655, -1094674500, -1090235355)
		+ W(7, -1100885631, -1141849761, -1114518568, 1032164357);
	WS(1061027871, -1104546242);
	sum1 = W(0, -1105616597, 1044372474, 1021564129, 1044930783) + W(1, 1046184033, 1039863327, 1037242932, 1036593932)
		 + W(2, 999947493, -1093243621, -1093936864, -1082760108)
		 + W(3, -1089254915, -1087020314, -1095491356, -1089177610)
		 + W(4, 1020340785, 1054887248, 1050165368, 1059757863) + W(5, 1059995997, 1055330116, 1049586618, 1053764638)
		 + W(6, 1044086916, -1111771647, 1042456335, -1109427891)
		 + W(7, -1109416824, -1114227250, -1119355674, 1025046581);
	sum2 =
		W(0, -1071093827, 1026041138, 1068370917, 1068180608) + W(1, -1099034443, -1126398467, -1114641099, 1032038973)
		+ W(2, 1060306884, -1087262504, -1080863241, -1104665609)
		+ W(3, 1065726420, 1036496204, 1052019191, -1112342652) + W(4, 1049935328, -1137957530, 1024099582, -1097098353)
		+ W(5, -1115701817, 1043337171, -1155572887, 1039831002)
		+ W(6, -1107356858, 1030953599, 1026067688, -1149593287)
		+ W(7, 1031805059, -1111590832, -1110320626, -1165279566);
	WS(-1085156031, 1045210454);
	sum1 =
		W(0, 1032928297, -1111119484, 1023710638, 1012189550) + W(1, -1119437633, 1039427612, -1114651991, 1039591187)
		+ W(2, 1062377574, 1050029461, 1062121112, 1061895670) + W(3, 1058328143, 1050106073, 1051812528, 1050020631)
		+ W(4, -1090582815, -1097825399, -1087364538, -1084850381)
		+ W(5, -1086721078, -1087870448, -1095972450, -1089842983)
		+ W(6, -1097791665, 1025846477, 1032229097, 1038427330) + W(7, 1040335420, 1036234257, 1026163704, -1146480404);
	sum2 =
		W(0, -1123647935, 1039341132, 1035983028, -1100132407) + W(1, -1107056231, 1035406254, -1116224056, 1039408558)
		+ W(2, 1061817512, 1048143772, -1106274437, -1080635557)
		+ W(3, -1101127944, -1113472410, 1025367216, -1101636583)
		+ W(4, 1083879676, 1075567701, -1081957201, -1069811820)
		+ W(5, -1080342730, -1083251742, -1113852980, -1087422720)
		+ W(6, 1056516802, 1037735150, 1028242764, -1096421593) + W(7, 1035329144, 1030744652, -1094803270, 1049804166);
	WS(-1079692512, 1054562755);
	sum1 = W(0, -1109749038, -1107273417, -1102577952, 1030213964)
		 + W(1, 1036563817, 1046944740, 1031914983, 1050658577) + W(2, 1042438683, 1049923207, 1044388569, -1113189609)
		 + W(3, -1089184118, -1087748930, -1096053014, -1091524869)
		 + W(4, -1092016161, -1091034933, -1089719139, 1050309800)
		 + W(5, 1048990040, 1053009554, 1048709856, 1049517424) + W(6, 1050333996, 1042543591, 1055304278, 1034159515)
		 + W(7, 1040366472, -1122229091, 1006842402, 1034826102);
	sum2 =
		W(0, 1041125733, -1097603156, -1103003109, -1107000988) + W(1, 1032085636, 1048646468, -1094740103, 1056003520)
		+ W(2, -1094982607, 1045744428, -1102781952, 1063877853)
		+ W(3, -1096755169, 1041101455, 1038162032, -1106723297) + W(4, 1055140379, 1049918932, -1106862916, 1066829095)
		+ W(5, -1090474230, -1081598978, 1049572267, -1085369603) + W(6, 1061130686, 990353951, 1058588396, -1096233798)
		+ W(7, -1095838692, -1089860215, -1096717844, 1044183141);
	WS(-1080283264, 1053171958);
	sum1 = W(0, 1045885175, -1113658461, 1034538909, 974135701) + W(1, -1122513036, -1118011958, 998696774, -1108239136)
		 + W(2, 1054395509, 1050045174, 1055879386, 1060600957) + W(3, 1061640838, 1060753746, 1054788217, 1061053402)
		 + W(4, -1083475508, -1095192933, -1085810962, -1084797135)
		 + W(5, -1086057732, -1087204563, -1092652351, -1108529436)
		 + W(6, 1028512496, 1035446876, 1026195253, 1044250612)
		 + W(7, 1037521197, -1117222317, 1038575473, -1101819472);
	sum2 = W(0, 1049760823, -1132622893, 1033001558, -1136534149)
		 + W(1, 1043696998, -1092886300, -1098156850, 1058228696) + W(2, 1082611215, 1077078383, 1066257283, 986681348)
		 + W(3, -1084657320, -1069070549, -1072372844, -1074505611)
		 + W(4, -1114287788, 1055018182, -1101461080, -1078537691)
		 + W(5, 1054805894, 1065047159, 1049854091, -1082348593)
		 + W(6, -1130959534, 1035090608, -1112584386, -1090394759)
		 + W(7, 1058031741, 1038822180, 1041633511, -1115499033);
	WS(-1073398920, 1057727890);
	sum1 =
		W(0, 1041979362, -1106188342, -1108985859, 1040300287) + W(1, 1044683952, 1046284093, 1044621499, 990388050)
		+ W(2, 1052994159, 1056847849, 1060197326, 1059196498) + W(3, -1094535618, -1094105983, -1102914751, 1043962286)
		+ W(4, -1092671491, -1087976920, -1085676269, -1108460501)
		+ W(5, 1051731585, 1046385743, 1031818215, -1104493131) + W(6, -1110295050, 1033778006, 1040328063, -1114468666)
		+ W(7, -1102804911, -1098429184, -1104640754, 1033981777);
	sum2 = W(0, 1021160276, -1093219342, -1089562294, -1106388958)
		 + W(1, -1099093932, -1180890998, -1090965228, 1057228486)
		 + W(2, -1089430647, -1135654176, -1079796815, 1074674993)
		 + W(3, -1098010580, 1052929457, 1040584224, 1047748991)
		 + W(4, -1102895535, 1044152573, -1095163331, 1074136497)
		 + W(5, -1095203310, -1099885509, 1041387674, -1131585606)
		 + W(6, 1031984432, -1096279754, 1011763192, -1101895278)
		 + W(7, -1117345690, -1095468231, -1107912603, 1045144673);
	WS(-1087643711, 1073414034);
	sum1 = W(0, 1043421796, -1116796288, 1042590607, -1098636497)
		 + W(1, 1008405302, 1005024220, -1106384411, 1029633907) + W(2, 1043019738, 1056957030, 1048028053, 1065994910)
		 + W(3, 1061262410, 1059267719, 1045820026, 1054563645)
		 + W(4, -1091862260, -1093379129, -1089120888, -1081315117)
		 + W(5, -1088787029, -1093593189, -1108751805, -1106230054)
		 + W(6, 1028452722, -1112484637, 1043084437, -1120978641)
		 + W(7, 1046109207, -1105879924, 1024805700, -1095994501);
	sum2 =
		W(0, 1015257573, -1117575950, 1040590395, 1040031817) + W(1, -1104875608, -1111928738, -1124331304, -1104400845)
		+ W(2, -1101361376, 1051853927, 1007636882, -1085239439) + W(3, 1029484438, 1055085469, -1104410806, 1055334030)
		+ W(4, -1151605286, -1126719224, -1099060090, -1069257368)
		+ W(5, 1078894141, 1065488662, -1097362053, -1099504604)
		+ W(6, -1114431290, -1122150057, -1123376079, -1122292554)
		+ W(7, 1045790053, -1105709439, 1046590167, -1096100911);
	WS(-1089052703, 1050218486);
	sum1 = W(0, 1024924308, -1124263665, -1114112032, -1101857739)
		 + W(1, 1004177297, -1132101549, 1037546120, -1127618735) + W(2, 1032977094, 1048865735, 1032370348, 1057017435)
		 + W(3, -1096925880, -1106597310, -1101706323, -1138126252)
		 + W(4, -1127622480, -1103037451, -1093324152, -1130658874)
		 + W(5, 1049797356, -1147023991, -1148374781, 1041185327)
		 + W(6, 1016061078, 1027347950, 1047024376, -1114101947)
		 + W(7, -1136753151, -1136950735, 1016234194, -1135392976);
	sum2 =
		W(0, -1103127935, 1034551493, -1131095837, 1056852609) + W(1, 1041291951, 1031312786, -1119687326, -1125922018)
		+ W(2, 1033687244, -1111330163, -1111327049, -1097897810)
		+ W(3, -1092598078, 1027703970, -1119650108, 1037109557) + W(4, 1044282132, -1132159854, 1043675418, 1038437355)
		+ W(5, -1085166716, -1122838335, 1030316614, -1115941571)
		+ W(6, -1115309191, -1101537844, 989659429, -1126658673)
		+ W(7, -1101159602, 1065573620, 1035948285, 1021015548);
	WS(1065854560, -1114586365);
	sum1 = W(0, 1025132845, -1132208108, 1043375962, 1036127555) + W(1, 1042813603, 1042302785, 1041475414, 1044294516)
		 + W(2, -1093129789, -1097600366, -1094779500, -1085251325)
		 + W(3, -1085614646, -1083792532, -1088034874, -1081301837)
		 + W(4, 1039292161, 1047014713, 1054220253, 1059484531) + W(5, 1058902029, 1058554289, 1049492791, 1057966909)
		 + W(6, 1052478106, -1114318540, 1045472794, 1040640636)
		 + W(7, 1026772633, 1030110605, -1123458066, 1048041627);
	sum2 =
		W(0, -1082315074, 1044643809, -1098370418, 1032322202) + W(1, -1088636595, 1057109638, -1093539506, 1061431798)
		+ W(2, -1085719643, 1026206592, 1060376399, 1066420950) + W(3, 1042910065, 1025783712, -1117795056, -1120476284)
		+ W(4, 1072912386, -1098026838, 1068488422, 1072201946)
		+ W(5, 1055106268, -1087763572, -1084317601, -1077472196)
		+ W(6, -1097858732, -1097387905, -1097681385, -1095903963)
		+ W(7, -1092707091, -1104219349, -1087895305, -1105350768);
	WS(-1071370880, 1080498273);
	sum1 = W(0, -1117491793, 1039364315, 1035846886, 1023528601)
		 + W(1, -1131889533, -1106314247, 1028375004, 1013100112)
		 + W(2, -1117320376, -1100646881, -1094786920, 1045848824)
		 + W(3, 1057069771, 1055228236, 1020389492, -1127017775) + W(4, 1025681812, 1049740511, 1058631773, -1094741601)
		 + W(5, -1088346742, -1102894479, -1138962992, 995411618)
		 + W(6, -1112958490, -1103504723, -1105396320, 1032469201)
		 + W(7, 1034336534, -1144513794, -1116565942, 1002008579);
	sum2 = W(0, -1097850747, -1107398437, -1085613590, 1042292809)
		 + W(1, 1054106205, -1106648125, 1035361236, -1122554235)
		 + W(2, -1108946242, -1114277717, 1063125687, -1084555354)
		 + W(3, 1059764079, 1041901467, -1103098774, -1148617751)
		 + W(4, -1129761151, -1118690429, 1040789135, -1101999238)
		 + W(5, 1051725304, -1128317719, 1022272136, 1025957669) + W(6, 1024320851, 1012636527, 1029278628, 1026191463)
		 + W(7, -1119736004, -1127460399, -1115360404, 997652141);
	WS(1058528159, 1053906024);
	sum1 = W(0, -1112917396, 1035675727, -1104938189, 1040468760)
		 + W(1, -1105254898, 1020887917, -1113141838, -1149793215)
		 + W(2, -1104256080, -1092229473, -1097223269, -1082484606)
		 + W(3, -1103704557, -1100912091, -1118771074, -1099449368)
		 + W(4, 1023681564, 1058833811, 1051100098, 1061928249) + W(5, 1057519273, 1047691241, 1047329733, 1044776397)
		 + W(6, 1039659283, 1021887717, 1033492802, -1119337706)
		 + W(7, -1099217437, -1127325712, -1114402703, 1024214504);
	sum2 = W(0, -1129442596, 1023778714, -1113953277, 1026809294) + W(1, 1035644478, 1034718426, 1016827280, 1038084720)
		 + W(2, 1040644144, 1033307012, 1056896617, -1080168883)
		 + W(3, 1030172798, 1046899220, -1114672577, -1138817753)
		 + W(4, -1106302200, 1056981996, 1082625405, -1064674592)
		 + W(5, -1098216535, -1107268878, -1138831353, -1118740750)
		 + W(6, -1105488042, 1014815489, 1048992482, 1043950232)
		 + W(7, -1120732434, -1121557578, 1026207834, -1122753582);
	WS(1050028863, 1057904824);
	sum1 = W(0, 1016998719, 1031484924, -1113918453, 1035763396)
		 + W(1, -1100192683, 1046082071, 1023767163, -1109585801)
		 + W(2, -1115527732, -1114471481, -1092713340, -1086973069)
		 + W(3, 1048884339, -1093669960, -1109475380, -1102684193)
		 + W(4, 1049960370, -1097014217, 1059124695, 1055821255) + W(5, 1045748179, 1046233018, 972758359, 1047341446)
		 + W(6, 1033316845, 1045307870, -1113659631, -1113580281)
		 + W(7, -1104759887, 1024760783, 1028768132, -1118597711);
	sum2 =
		W(0, 1042577042, 1035985609, -1132583692, -1108557005) + W(1, 1045882832, 1049978360, -1123148614, 1037998467)
		+ W(2, 1058174637, 1022451597, -1083350192, -1102051996)
		+ W(3, -1096734805, 1040525485, -1111555351, 1012738322)
		+ W(4, -1093234196, 1028288917, -1089654696, 1066585170)
		+ W(5, -1112976831, -1101233023, 1016281700, 1035922998) + W(6, 1036828005, 1036599280, 1043707159, -1099096459)
		+ W(7, -1117191962, 1038823523, 1010883764, -1106116243);
	WS(1064158815, 1035299335);
	sum1 = W(0, -1112803360, 987363362, 1040202935, -1148543050)
		 + W(1, -1119103150, 1016866897, -1120253212, -1136961231)
		 + W(2, 1016610641, -1111853690, -1090418272, -1086418793)
		 + W(3, -1096774480, -1106302329, -1125874772, -1111706212)
		 + W(4, 1043480489, -1116662313, 1043761841, 1062267936) + W(5, 1026731899, 1046949595, 1044534239, 1038415821)
		 + W(6, 1023721675, -1114846141, 1040437218, 1044974085)
		 + W(7, -1112576238, 1035797256, -1118929285, 1017229376);
	sum2 = W(0, 982347958, 1032509555, -1111294086, 1034453505) + W(1, -1107492941, 1047671755, -1114281099, 1041657921)
		 + W(2, -1130481715, -1105443060, 1041532435, -1090026061)
		 + W(3, -1115327745, -1099067440, 1007189687, -1106888056)
		 + W(4, 1039697927, -1102232537, 1059036310, 1065332554) + W(5, 1049776291, 1035057967, -1116755236, 1039394631)
		 + W(6, 1029826582, -1106323503, -1087181565, -1095157490)
		 + W(7, 1032022369, -1113855935, -1137758215, -1116441678);
	WS(1064590463, 1056702913);
	sum1 =
		W(0, 1029043770, 1053372231, -1096751755, 1042753121) + W(1, -1132040847, -1098166823, 1054745035, -1101919647)
		+ W(2, -1118119137, 1049750478, -1090400466, -1089893441)
		+ W(3, 1035942347, -1098407696, 1057009004, -1105867448) + W(4, 1044521535, 1040212560, 1048069253, -1098259842)
		+ W(5, 1046519145, -1126503113, 1029470901, -1137574860)
		+ W(6, -1108622774, 1055292354, -1086796959, 1028130891)
		+ W(7, 1043794349, -1097599727, 1057963224, -1099480944);
	sum2 = W(0, -1112469736, -1109993908, -1113626244, -1101975228)
		 + W(1, -1113395603, -1115391866, -1111764318, -1114050909)
		 + W(2, 1047380321, 1048112351, 1039961237, 1053720344) + W(3, 1033059361, -1117206471, 1050486894, 1029031616)
		 + W(4, -1107309008, -1096267194, -1149218892, 1041967405)
		 + W(5, -1105421186, 1041082150, -1097114178, -1116211284)
		 + W(6, -1130012001, 1044766357, 1024449363, -1105185961)
		 + W(7, 1034928166, -1103730760, 1041700935, -1133808950);
	WS(1049282175, -1081654589);
	sum1 = W(0, 1026879882, -1106636470, 1025593670, -1120434947)
		 + W(1, -1109057316, -1103814142, -1108405355, 1025046173)
		 + W(2, 1056840376, 1051340514, 1059046350, 1060994015) + W(3, 1062254571, 1054415372, 1044610849, 1057281100)
		 + W(4, -1089715922, -1103588481, -1087728227, -1081081863)
		 + W(5, -1089160278, -1110084674, -1097611347, -1102762237)
		 + W(6, 1023576205, 1019713064, 1018583793, -1116831948)
		 + W(7, 1040563949, -1148705741, -1130543166, -1108038889);
	sum2 = W(0, 1021240677, -1117500355, -1104166105, -1110155670)
		 + W(1, -1101525323, -1099065181, -1135933351, -1100288377)
		 + W(2, -1112389783, -1154883848, -1102583420, 1061056453)
		 + W(3, -1123615532, 1038434309, 1041908272, -1120914319)
		 + W(4, 1025718250, -1096682611, 1048911763, 1065471868)
		 + W(5, -1149445264, -1090281103, 1042017461, -1131934595)
		 + W(6, -1104779102, 1051908652, -1093040032, 1051220588)
		 + W(7, -1113750073, -1098156535, 1046751376, -1100861861);
	WS(1044733566, -1111466942);
	sum1 = W(0, 1033634167, -1105078967, -1104340430, -1106426842)
		 + W(1, -1101553619, -1110993602, -1113465444, 1020428386)
		 + W(2, 1060020808, 1041929508, 1062221635, 1060048443) + W(3, 1059584252, 1054717575, 1044713794, 1047352089)
		 + W(4, -1092913556, -1103349137, -1092289734, -1090785767)
		 + W(5, -1094348262, -1097827057, -1098824243, 1041060918)
		 + W(6, -1112663104, -1134753630, -1126194825, -1110397240)
		 + W(7, -1114529117, -1113238887, -1140846474, -1094820883);
	sum2 =
		W(0, 1040248415, -1113076108, 1043824330, -1105221470) + W(1, 1036602392, -1134849104, -1163695359, 1011808464)
		+ W(2, 1084299283, 1066146464, -1073408210, -1067326117)
		+ W(3, -1097425816, 1016852200, -1119512248, -1118870508)
		+ W(4, 1054267917, 1032173778, -1102778436, -1084477148) + W(5, -1149511007, 1040914456, 1026379762, 1011171408)
		+ W(6, 1002599056, 1029289900, 1027082476, -1116688572) + W(7, 1024010398, -1121212984, 1007530464, 1020903456);
	WS(1041204862, 1020998748);
	sum1 = W(0, 1041320410, -1111643799, 1033147201, 1033305824)
		 + W(1, -1110534482, 1048653459, -1106102028, -1129433652)
		 + W(2, 1040787048, 1044400490, -1112000574, 1057857240) + W(3, 1058317173, 1013490791, 1040475768, 1032979455)
		 + W(4, -1129649268, -1096018340, 1041936758, -1090212595)
		 + W(5, -1083609992, -1108280561, -1098465902, -1104103124)
		 + W(6, -1136864165, -1123167632, 1014392453, 1043382402)
		 + W(7, 1046901861, 1040774794, -1121200123, -1123801518);
	sum2 =
		W(0, 1033367466, 1036408153, 1049195658, -1116950481) + W(1, -1081345874, 1035726191, -1109751565, 1034565507)
		+ W(2, -1105739926, 1041467605, -1097896497, 1069287141) + W(3, 1045676499, -1097322898, 1034595972, 1022861151)
		+ W(4, 1035166617, -1116824529, -1127250349, -1103787577)
		+ W(5, -1104285546, -1110450029, 1041775082, -1111377560)
		+ W(6, -1121294834, 1020242785, 1024987646, -1113169844)
		+ W(7, -1109755223, -1162599282, -1128984227, 1015705141);
	WS(1061587071, -1140717261);
	sum1 = W(0, -1112565188, 1035683412, 1034588141, -1105710858)
		 + W(1, 1024277837, -1104681461, 1033519565, -1097426768)
		 + W(2, -1082585266, -1091946062, -1086181493, -1084260507)
		 + W(3, -1087521200, -1094344584, -1109665588, -1092361421)
		 + W(4, 1063001355, 1057075562, 1061257307, 1062016535) + W(5, 1059484653, 1051726365, 1053582679, 1050023351)
		 + W(6, 1029148274, -1133150565, -1121255338, 1031972073)
		 + W(7, -1140527211, 1015752222, -1140031633, 1054184694);
	sum2 =
		W(0, 1052095029, 1040595366, -1098987175, -1084153168) + W(1, -1091290481, -1096720628, -1101102486, 1044734380)
		+ W(2, -1068831962, -1076957703, -1081538085, 1037971476) + W(3, 1070110671, 1069986978, 1074264190, 1070997731)
		+ W(4, -1076286348, -1081349117, -1088771362, 1057908839)
		+ W(5, -1114213425, 1063483875, 1068552571, 1075267150) + W(6, 1061242602, 1046002483, 1040290526, -1093902656)
		+ W(7, -1094367529, -1094489561, -1099236623, -1081182731);
	WS(-1071242520, -1095264341);
	sum1 = W(0, -1097248122, 1017326143, -1105336241, -1091856432)
		 + W(1, 1051920949, -1097210280, -1122345698, 999615444) + W(2, 1057257956, 1050464317, 1059871125, 1058219580)
		 + W(3, 1056167546, 1051126389, 1047883744, 1055359408)
		 + W(4, -1095464807, -1098731544, -1096805078, -1088025845)
		 + W(5, 1032394345, -1089070234, -1102431837, -1098523426)
		 + W(6, -1098637431, 1039614697, 1034135507, -1098503641)
		 + W(7, 1057766069, -1095933097, 1030493340, -1112287963);
	sum2 = W(0, -1132961311, 1034954689, -1131131128, -1105685093)
		 + W(1, 1044104138, -1118659572, -1117347443, -1140373421)
		 + W(2, 1038597560, -1114842936, 1039456110, -1104727669)
		 + W(3, -1085849936, 1053272959, -1117746499, 1049759548)
		 + W(4, -1089057302, -1113751042, -1095192990, -1097910004)
		 + W(5, 1064526735, 1045257331, 1054461586, 1062278408) + W(6, 1055074030, 1048893008, 1046429121, 1057064004)
		 + W(7, -1091871118, -1096323208, -1090448877, -1081803378);
	WS(1055746431, 1040288248);
	sum1 = W(0, -1154016945, -1117613130, -1108247483, -1114072538)
		 + W(1, -1103530014, -1134724696, -1102903742, 1046496384)
		 + W(2, 1057716289, 1055590360, 1059644857, 1067207252) + W(3, 1062212336, -1104299500, 1049302591, 1054319858)
		 + W(4, -1093759650, -1094487986, -1089867895, -1085229664)
		 + W(5, -1089860607, -1088563377, -1097577389, -1094962569)
		 + W(6, -1122750430, -1117149477, 1031955359, 1016534394)
		 + W(7, 1044969554, -1137442922, 1035178328, -1108831509);
	sum2 =
		W(0, 1041968914, 1026703145, 1033601916, 1035338047) + W(1, -1106207855, -1094112140, -1100978937, -1106593629)
		+ W(2, 1051752153, -1115260470, 1038625472, 1052354182)
		+ W(3, -1118891350, -1081023345, -1084581041, 1066756564)
		+ W(4, -1123800846, 1035127537, 1035458769, 1035609386) + W(5, 1057116581, -1104080857, 1055976243, -1101750238)
		+ W(6, -1117011966, 1031245794, -1109678904, 1050054059)
		+ W(7, -1098815779, 1038926653, -1108176195, -1107244818);
	WS(-1089881759, 1037957184);
	sum1 = W(0, 1000251530, -1117869170, 1029072469, 1031851625)
		 + W(1, 1024508279, -1105582638, -1121710869, -1105403363)
		 + W(2, -1098029886, -1095515176, -1089055515, -1079829205)
		 + W(3, -1094362449, -1105281331, -1112643769, -1102959900)
		 + W(4, -1105974859, 1060224425, 1060210489, 1061092856) + W(5, 1060581840, 1056017638, 1040568609, 1050032516)
		 + W(6, 1041712355, 1040628361, 1042449912, -1119516507)
		 + W(7, -1102207965, -1107063314, -1112932479, -1124065669);
	sum2 = W(0, 1051114274, -1105565679, 1055378846, -1098769061)
		 + W(1, -1106275827, -1101598109, -1109849433, -1104426610)
		 + W(2, -1102532150, -1114476854, -1082969540, 1064670328)
		 + W(3, -1102001010, 1044770567, -1114021751, 1049459491)
		 + W(4, -1093533301, 1038543175, -1075201485, 1077554590)
		 + W(5, 1048871628, 1040464379, -1111404687, 1049461049)
		 + W(6, 1042271071, -1112348507, -1087360189, -1100903801)
		 + W(7, -1115312306, 1031777408, -1125205988, -1104546886);
	WS(-1089609215, -1090633405);
	sum1 = W(0, -1095985139, -1131730646, -1106836118, -1120898567)
		 + W(1, -1122196780, -1108220230, -1113602180, -1111282801)
		 + W(2, 1060468726, -1114989785, -1111340153, -1083229835)
		 + W(3, -1097505195, -1091862496, -1118278055, -1094974325)
		 + W(4, 1029992257, 1035463235, 1053834481, 1057093887) + W(5, 1060127651, 1056095953, 1053644551, 1060964715)
		 + W(6, -1106189340, -1121474072, -1109753904, -1170836447)
		 + W(7, -1099640750, -1106303115, -1102165833, -1114233933);
	sum2 = W(0, -1102755055, -1123071369, -1101642458, -1121616776)
		 + W(1, -1123659230, 1034971308, -1114444448, 992820811) + W(2, 1028184991, 1018963304, 1042446539, 1048904011)
		 + W(3, 1022095962, -1102092583, -1115812270, -1115600403)
		 + W(4, 1014375557, 1034540123, -1110958917, 1055634924) + W(5, -1122273513, 1047229966, 1006913192, 1032293939)
		 + W(6, 1018724927, -1154538439, 1030328833, -1104340897)
		 + W(7, -1123674010, -1103087688, -1118183380, -1116477720);
	WS(-1089497119, -1083970920);
	sum1 = W(0, 1049400081, -1112985379, 1032734776, 1046931016) + W(1, 1032966898, 1026703569, 1023567673, 1020804657)
		 + W(2, 1017038202, 1054102421, 1052273107, 1050677101) + W(3, 1056472798, 1054012759, 1046736000, 1054561791)
		 + W(4, -1096866095, -1092440080, -1090492445, -1077775563)
		 + W(5, -1095500286, -1141821439, -1103091876, -1096856494)
		 + W(6, -1129668560, 1023489999, 1039999326, 1047866250)
		 + W(7, 1031139121, -1128248842, 1037611037, -1102316761);
	sum2 = W(0, -1119432539, -1114702364, -1131454616, 1045807900)
		 + W(1, -1107556037, -1138592655, -1120197723, -1116354551)
		 + W(2, -1113150368, -1107904829, 1051795717, 1065572002) + W(3, -1104213250, -1096394963, 991774812, 991245404)
		 + W(4, 1049552369, -1109676099, 1049548364, 1052256292)
		 + W(5, 1058452060, -1077576443, -1102019177, 1049782966)
		 + W(6, -1123950204, 1034167140, 1018171432, 1024318084)
		 + W(7, -1104886632, -1103410805, -1103678409, -1123412946);
	WS(-1092399743, 1070790531);
	sum1 = W(0, 1031557241, 1024013147, 1045977841, 1049827334) + W(1, 1044712430, 1042539942, 1022243624, 1042631871)
		 + W(2, -1110110152, -1123928476, -1100428029, -1093314535)
		 + W(3, -1098211617, -1120318828, -1110797385, -1103475236)
		 + W(4, -1086332927, -1104003948, -1091187884, -1110202001)
		 + W(5, 1031718940, 1031171411, -1118825252, 1047659449) + W(6, 1040307665, 1029330819, 1054647477, 1048337215)
		 + W(7, 1045074033, 1042256462, 1034920639, 1041342974);
	sum2 = W(0, 1035080118, -1111978522, 1043189101, -1107203795)
		 + W(1, 1020874649, 1040978901, -1103963851, 1014904337) + W(2, 1049091174, 1049791001, 1038894820, -1088677682)
		 + W(3, -1074681252, 1032440616, -1139760881, -1132242473)
		 + W(4, 1068767241, 1068692590, 1041587068, -1079138335) + W(5, -1088844169, 1033618204, 1036797334, 1040720920)
		 + W(6, 1056655092, -1120502660, 1054889999, -1094007639)
		 + W(7, -1106617291, 1037089622, -1115116202, 1029103732);
	WS(-1076899872, -1090262268);
	sum1 = W(0, -1111775583, -1105515965, 1031134981, -1152866339) + W(1, 1022185487, 1031461535, 991487050, 1013082739)
		 + W(2, -1105212520, -1109220950, -1105276619, -1081197371)
		 + W(3, -1085735312, -1090100176, -1106571081, -1094472404)
		 + W(4, 1053805936, 1044900104, 1061229259, 1056451270) + W(5, 1061180827, 1061600458, 1040836429, -1114201801)
		 + W(6, -1130865048, -1124779047, -1108606366, 1012899053)
		 + W(7, -1111684786, 1038272628, -1123743158, 1043636133);
	sum2 = W(0, -1092758077, -1099940688, -1096959860, -1093749782)
		 + W(1, 1047974360, -1120633714, 1036248767, -1113388587)
		 + W(2, 1054372816, 1036990346, -1102824961, 1072234824)
		 + W(3, -1091574668, -1098403340, -1097220109, 1024848209)
		 + W(4, 1025999909, 1044094629, -1093700170, 1074465248)
		 + W(5, -1086059593, -1083936129, 1045585843, -1093741871)
		 + W(6, 1025560437, 1015649794, -1134776466, -1118772240)
		 + W(7, -1097328702, 1035273338, -1098634116, 1051989609);
	WS(-1097318719, -1106686758);
	sum1 = W(0, -1138034233, 1022220430, -1115259277, 1037878284)
		 + W(1, -1109043646, -1118564628, -1132126739, -1123355602)
		 + W(2, 1031803579, -1105675680, 1060345356, 1040095311) + W(3, 1057210483, 1018511203, 1038086620, 1040876381)
		 + W(4, -1107190316, -1110575515, -1091489993, -1082557626)
		 + W(5, 1054616755, -1113047197, 1037558661, 1040895458) + W(6, -1118470609, 1013564641, 1028754310, 1043380040)
		 + W(7, -1126688788, -1103180903, -1105313401, -1110366427);
	sum2 = W(0, -1116780480, 1034654933, 1033980194, -1106740681)
		 + W(1, 1037910476, -1110588743, 1033369701, 1006481529) + W(2, 1011610145, -1109786563, 1034290987, 1058839838)
		 + W(3, -1112504437, 1048688059, -1100404580, 1024874106)
		 + W(4, -1126532250, 1049246354, -1098441369, 1055488745)
		 + W(5, -1081564854, -1109313096, 1046210019, -1122526519)
		 + W(6, 1031867194, -1117436106, 1050453777, -1098876833)
		 + W(7, -1101879397, -1105182695, 1033744368, 1042001428);
	WS(1061957727, 1058150789);
	sum1 = W(0, 1009728708, 1031914819, 1043097483, -1106863550)
		 + W(1, -1097372952, -1108191069, 1032793786, -1129266281)
		 + W(2, -1099288198, -1097230757, -1087266183, 1043273168)
		 + W(3, 1055416522, 1050026271, -1110590381, -1108247452) + W(4, 1046412713, 1055587995, 1056802398, 1049133325)
		 + W(5, -1086687979, -1105368103, -1107437206, 1042988739)
		 + W(6, 1036440691, -1109853493, -1106212891, 1023154886)
		 + W(7, 1047286155, 1036106272, 1024106902, -1120124353);
	sum2 = W(0, 1021676194, -1104415808, 1041444786, -1104915444)
		 + W(1, 1042839409, 1025561656, -1111488206, -1119893126)
		 + W(2, 1026925373, 1041631623, 1049347642, -1075706495) + W(3, 1068941883, 1049874161, -1096918949, 1030080935)
		 + W(4, -1130821928, 1047340087, 1055108729, -1078646873)
		 + W(5, 1058328878, 1054741696, -1108156193, -1107876167)
		 + W(6, 1011207236, -1118374396, 1032289888, -1097824639)
		 + W(7, 1041964936, -1122940124, 1033049167, -1131526532);
	WS(1058678303, 1013994144);
	sum1 = W(0, -1118673511, -1145988558, -1107600786, -1097799452)
		 + W(1, 1050901309, 1025019066, 1034380585, -1117490811) + W(2, 1050426208, 1032382213, 1059103555, 1061451838)
		 + W(3, -1098106458, 1032049821, 1038038624, 1043957152)
		 + W(4, -1111022430, 1019043839, -1086017695, -1090188381)
		 + W(5, 1050664020, -1093177128, -1133222475, -1113568728)
		 + W(6, -1110204509, -1116037137, 1043824660, -1111434373)
		 + W(7, -1123560275, 1043538778, -1104489131, -1110765932);
	sum2 = W(0, -1105859137, 1047608842, -1101390223, 1011548907)
		 + W(1, -1098146078, 1047719826, -1099968186, 1028887915)
		 + W(2, 1052524883, -1096529292, -1103682938, 1018027622)
		 + W(3, 1039330573, -1101134187, 1054816538, -1105962981)
		 + W(4, -1116369180, 1033298597, -1095014501, 1063707518)
		 + W(5, 1056731707, -1086128756, 1037701277, -1150004284)
		 + W(6, 1025172812, 1035180205, -1138831970, -1096368530)
		 + W(7, -1094263126, 1061932077, -1095466983, 1016476277);
	WS(1063038079, 1033861047);
	sum1 = W(0, -1111914898, 1040884807, -1102681756, 1061986003)
		 + W(1, -1095429920, -1109559865, 1034752240, -1104233906)
		 + W(2, 1016779545, 1014390112, -1109833994, -1095449911)
		 + W(3, -1097838100, 1019923216, -1148961393, 1009274926)
		 + W(4, -1107257338, 1045397811, -1096677860, 1065846455) + W(5, 1029008656, 1039008680, 1033037520, 1029851870)
		 + W(6, -1114919788, -1162045399, -1101855164, 1049909751)
		 + W(7, -1097193708, -1113534130, 1007645095, -1103320918);
	sum2 = W(0, -1112457849, -1106002020, -1103752624, -1114732591)
		 + W(1, -1102536580, 1029961226, -1114728817, 1038070251)
		 + W(2, -1117177515, 1017665294, -1098231154, 1062239338)
		 + W(3, -1097906884, -1101585142, 1037597321, -1112453861)
		 + W(4, 1031942991, 1033022206, -1133545004, 1061426536)
		 + W(5, -1109528685, 1032626487, -1114069131, 1032988844)
		 + W(6, -1106095669, 1041685053, -1095196752, 1046863079)
		 + W(7, -1105989872, -1120505375, 1028074076, -1124888510);
	WS(1060691839, -1121680521);
	sum1 = W(0, -1112633460, 1034282296, 1016470792, -1124091490)
		 + W(1, 1036530779, -1110508885, 1036991882, -1133939630)
		 + W(2, -1105323108, -1097943963, -1091137362, -1083253895)
		 + W(3, -1090987401, -1090137469, -1098291034, -1093525810)
		 + W(4, 1045243383, -1117038833, 1060606770, 1065759511) + W(5, 1062311590, 1056765570, 1054157412, 1057599172)
		 + W(6, -1113361469, -1109479713, -1110311799, -1102522287)
		 + W(7, -1114082482, -1104777690, 1016563642, -1167556095);
	sum2 = W(0, -1097189010, 1041454563, -1110771302, 1043926258)
		 + W(1, -1109373654, -1109768355, -1114304258, 1043669875)
		 + W(2, 1057901747, 1039698409, -1122301550, -1125642190)
		 + W(3, -1108285138, 1020817735, 1040279727, -1101494695)
		 + W(4, -1086723052, -1087530727, -1094374456, 1064818137)
		 + W(5, 1036021291, -1109979249, 1055924705, 1040712355)
		 + W(6, -1086497310, -1090377488, -1110538585, 1061014784)
		 + W(7, 1034378960, 1044647130, 1013465199, 1050381101);
	WS(-1087684831, -1094525449);
	sum1 = W(0, 1038107891, -1121734275, 1035814365, -1107604308)
		 + W(1, 1038052214, -1101928869, -1104767443, -1127021124)
		 + W(2, -1093934649, -1096975274, -1093954738, -1090018791)
		 + W(3, -1088075930, -1090123804, -1106254226, -1100235009)
		 + W(4, 1052573184, 1049163549, 1040479417, 1066601083) + W(5, 1058232216, 1057618495, 1040796439, 1051666987)
		 + W(6, 1038198313, -1113930844, 1035537105, -1102439448)
		 + W(7, -1113118893, -1148589172, -1146582942, 1033628463);
	sum2 = W(0, -1102391770, 1032495868, -1140349122, 1051494072)
		 + W(1, -1080481573, -1072283498, -1085993190, -1091499210)
		 + W(2, 1038892506, 1032348345, 1055934176, 1066287204) + W(3, 1070533091, 1056179234, -1098172645, 1038613315)
		 + W(4, -1109920182, 1035913564, 1043439866, 1049172795)
		 + W(5, 1048700512, -1122911277, 1042548330, -1103404378)
		 + W(6, 1034045130, -1111661823, -1148365864, 1035742233)
		 + W(7, 1024670194, 1043482108, -1117726050, 1024343165);
	WS(-1095407551, -1073547033);
	sum1 = W(0, -1103915126, -1101976843, 1024335748, -1108044768)
		 + W(1, 1050893513, -1095324014, -1107189281, -1114975198)
		 + W(2, 1043640456, 1041775803, 1061599658, 1057524528) + W(3, 1060862745, 1028413803, 1044362232, 1051352312)
		 + W(4, -1106314263, -1098551608, -1096990689, -1095708126)
		 + W(5, -1102020840, -1092797676, -1110398586, -1097969466)
		 + W(6, -1099126911, 1023142916, -1110220795, -1106562202)
		 + W(7, 1056016670, -1099653918, 1031215069, -1138223071);
	sum2 = W(0, -1112168075, -1111493200, -1123529566, 1022286331)
		 + W(1, -1103466952, 1035493883, -1113566520, -1106265315)
		 + W(2, 1034632723, -1122920764, 1009053647, 1049936313)
		 + W(3, 1051909492, -1099948229, 1029419308, -1107051081)
		 + W(4, 1034960798, 1040740621, -1105159128, 1057592446) + W(5, -1126339526, 1041517424, 1016655048, 1024151142)
		 + W(6, -1112860057, -1108202591, -1115675116, -1112708946)
		 + W(7, -1146770753, -1116950762, -1115594520, -1103163741);
	WS(1063407871, 1051042354);
	sum1 = W(0, 1005154604, -1120529264, -1106161584, -1130858780)
		 + W(1, -1114354154, -1127255711, 1023693521, -1115504868)
		 + W(2, 1049807310, 1052429035, 1057743574, 1063894449) + W(3, 1058090310, 1052514789, 1044231916, 1049931918)
		 + W(4, -1113122997, -1100831547, -1088929544, -1086654500)
		 + W(5, -1089886688, -1092092086, -1106897472, -1097639884)
		 + W(6, -1107282310, 1042685852, -1113923042, -1129272494)
		 + W(7, -1164896285, -1131567786, -1131959253, -1115987013);
	sum2 =
		W(0, -1113031572, 1030565628, -1127702936, 992883874) + W(1, 1014952720, 990495554, 1018238740, 1023316920)
		+ W(2, 1043434467, -1108784254, -1111949688, 1036810375)
		+ W(3, -1111107284, 1042918247, -1120169364, -1112993936)
		+ W(4, -1088941888, 1056568736, 1036016830, 1060861120) + W(5, 1023742716, -1098281783, 1022041004, -1112517088)
		+ W(6, -1067187434, -1079041185, 1074040966, 1075709893) + W(7, -1099161149, 992814626, 1039733673, 1028892682);
	WS(1053166591, -1107822593);
	sum1 = W(0, 1033874440, 1022746982, 1035703758, 1019810386) + W(1, 1044260196, 1042374543, 1040749291, 1041374685)
		 + W(2, -1120335240, 1031831786, 1052124034, 1048792350)
		 + W(3, -1095582904, -1088629918, -1097950065, -1085974448)
		 + W(4, -1105709561, -1108379508, -1093762507, 1046826502)
		 + W(5, 1053612659, 1045805451, 1037463342, 1042845918) + W(6, 1042509273, 1008295657, 1044631286, -1124953572)
		 + W(7, -1112928126, -1113071488, -1120529605, -1132054272);
	sum2 = W(0, 1010990056, 1039106059, -1102786881, -1114641521)
		 + W(1, -1133768253, -1101476912, -1103607882, -1113060394)
		 + W(2, -1096561981, -1097601992, 1031463124, 1058004743)
		 + W(3, 1042505523, 1041182740, -1105959219, -1099775079) + W(4, 1040308359, 1052717590, 1058176412, 1045709336)
		 + W(5, 1034355291, -1096768246, 1033275384, -1105804625)
		 + W(6, -1119485380, -1115258493, -1101721469, -1138490792)
		 + W(7, -1101570252, 1029590734, 1037679123, 1036565969);
	WS(1028916214, 1067075549);
	sum1 =
		W(0, 1039584518, -1119264713, 1016298993, -1105861885) + W(1, -1113980813, 1020015061, -1134777055, 1032661512)
		+ W(2, -1148995491, -1109885152, 1055889168, 1067421167) + W(3, 1059632007, 1055091716, 1045130509, 1052375930)
		+ W(4, -1098323934, -1096386895, -1096985498, -1085982162)
		+ W(5, -1087532161, -1088331431, -1095878225, -1104015130)
		+ W(6, 1026160863, 1022848653, -1150434165, 1034469007) + W(7, 1044152506, 1024761132, 1032543553, -1104676378);
	sum2 = W(0, -1120016029, -1096222017, -1119382227, -1092715875)
		 + W(1, -1110818689, 1049876716, -1103484103, 1032841990)
		 + W(2, -1101422768, -1103630239, 1040689805, 1064582511)
		 + W(3, 1043406218, -1089499537, 1029271710, -1117522613)
		 + W(4, -1104653664, -1105545071, -1120927281, 1058022283)
		 + W(5, 1060808344, -1107109410, -1107008053, -1105419897)
		 + W(6, -1122344899, 1042131820, -1120071349, -1101606830)
		 + W(7, -1096987934, 1051590178, -1099435532, 1050342947);
	WS(1047020030, 1040511430);
	sum1 = W(0, -1108637223, 1033110649, 1044090139, 1043424750)
		 + W(1, 1036624046, -1120308481, 1033721201, -1106849700)
		 + W(2, -1092384755, -1090443530, -1085982557, -1080046633)
		 + W(3, -1083957593, -1096279270, -1149642107, -1100324533)
		 + W(4, 1057603229, 1053549631, 1061618217, 1047924234) + W(5, 1053999549, 1057048888, 1057845673, 1052833857)
		 + W(6, 1031927268, -1122999800, 1026366340, 1032840448) + W(7, 1015929108, 1020572028, 994286645, 1039624063);
	sum2 = W(0, 1035208568, 1043030610, -1107699159, 1044796248)
		 + W(1, 1034655700, -1103668262, 1045164876, -1095424772)
		 + W(2, -1124082321, 1008382386, -1107061123, 1049576136)
		 + W(3, 1051573865, 1048541752, -1093669891, -1134934914)
		 + W(4, -1093736918, 1050323039, -1114950423, 1074526989)
		 + W(5, 1073198167, -1080621030, -1074078238, -1079139349)
		 + W(6, 1048736861, -1118377912, -1106119918, -1111443567)
		 + W(7, -1132389881, 1034733436, 1034120076, 1029501600);
	WS(-1080108544, 1072234904);
	sum1 =
		W(0, -1115070415, -1130610603, -1098588213, 1057466749) + W(1, -1104374087, 1029557602, 1018553236, 1001112594)
		+ W(2, 1027588151, 1029085890, 1032775046, -1089931562) + W(3, -1123371019, -1094030554, 1034779836, 999211181)
		+ W(4, 1031137458, -1104252646, 1056995037, -1083673968) + W(5, 1052314097, 1050628415, 1033643941, 1036988180)
		+ W(6, 1018404227, 1044293186, 1028038521, 1050777268) + W(7, -1093125043, 1046325824, -1108340394, 1020739741);
	sum2 = W(0, -1115557063, -1118678156, 1045099863, -1102856438)
		 + W(1, 1035209289, 1035167397, -1117208818, -1120387027)
		 + W(2, 1043108929, 1033401680, 1036186051, -1124450766)
		 + W(3, -1112637977, -1114646959, 1012643139, -1132473655)
		 + W(4, -1138826120, -1093193803, -1079584214, 1068262877)
		 + W(5, -1121148137, 1041792105, -1138286224, 1032348301)
		 + W(6, -1108049897, -1109597407, 1013268663, 1049634970)
		 + W(7, 1046161245, -1111895568, -1127251156, -1116707942);
	WS(1061770399, 1033097145);
	sum1 = W(0, -1127803310, -1108446526, 1046619869, -1102069216)
		 + W(1, -1115166002, -1107462472, -1113123881, -1109525661)
		 + W(2, -1100493560, -1122290538, -1090144134, -1124504076)
		 + W(3, -1096124978, -1113245389, -1115437168, -1114380655)
		 + W(4, 1049484359, 1040952192, 1049567736, 1060283011) + W(5, 1036170309, 1049188012, 1004781969, 1043620172)
		 + W(6, -1117956049, -1101349332, 1015706547, 1051006353)
		 + W(7, 1027971186, -1105896346, 1011773295, -1118021614);
	sum2 =
		W(0, -1115090363, -1146121477, 1029869322, 1039239074) + W(1, -1123366919, -1123569769, -1115297931, 1022224092)
		+ W(2, 1035607607, 1032878473, 1020296178, -1094567498) + W(3, -1133024223, -1111505684, 1036037468, 1025152664)
		+ W(4, 1036976780, 1008730983, 1050702114, 1060438996) + W(5, -1092544833, -1088372125, -1119747923, 1015952550)
		+ W(6, -1102631851, -1105868946, -1106613659, 1056742871)
		+ W(7, 1056526109, -1103439045, -1114092237, -1109382916);
	WS(1063262431, 1041246684);
	sum1 =
		W(0, -1095604910, 1035931377, -1116408259, -1113418944) + W(1, 1035543059, -1109446615, 1041501409, -1111045021)
		+ W(2, -1094141452, -1103734011, -1088213584, -1084116356)
		+ W(3, -1088057339, -1084926720, -1095142868, -1085134126)
		+ W(4, 1054301899, 1050116188, 1059695011, 1063045487) + W(5, 1060587189, 1062081288, 1055163174, 1061043357)
		+ W(6, 1050361575, 1015464930, -1130477940, 1005018697) + W(7, -1114430457, -1112900435, 968128030, 1012274924);
	sum2 = W(0, -1088652568, -1101936220, -1091191468, -1102444501)
		 + W(1, -1123800532, -1111069004, -1088813372, 1050243792)
		 + W(2, 1079171932, 1073764649, 1074855165, -1113430470)
		 + W(3, -1095064501, -1078839186, -1078450334, -1071519758)
		 + W(4, 1068650823, 1062997529, 1053027607, 1039600983)
		 + W(5, -1105207914, -1082346847, -1088354544, -1081653443)
		 + W(6, -1089634291, -1106083041, -1102140198, -1123235056)
		 + W(7, 1028735871, 1056073450, -1114344542, 1060600412);
	WS(-1071343712, -1080188504);
	sum1 = W(0, 1048814204, -1112944093, 1038698214, -1110388460)
		 + W(1, -1102353903, -1113346827, -1115354285, -1172877482)
		 + W(2, 1024112567, 992179242, 1035991718, 1065540811) + W(3, 1062800155, 1057270438, 1047814390, 1055244391)
		 + W(4, -1101821021, -1105846854, -1110088095, -1086620536)
		 + W(5, -1085891530, -1092189183, -1094362793, -1096652125)
		 + W(6, -1155239198, -1115614373, -1117961066, 1022833410)
		 + W(7, 1037955557, -1130491710, 1026576596, 1021561214);
	sum2 = W(0, 1077488778, 1067869852, -1080283979, -1070445594)
		 + W(1, -1085461181, -1113067149, -1135625536, -1105631704)
		 + W(2, 1057844910, 1017329883, -1112258962, 1038200220) + W(3, 1045877800, 1016515143, 1029029881, 1026840239)
		 + W(4, -1110901413, -1123912240, 1048616910, -1103189448)
		 + W(5, 1033584054, -1113680120, 1006246833, 1028070058)
		 + W(6, -1157420388, 1016773013, -1127671945, 1027002057)
		 + W(7, -1139116556, -1108492850, 1033508697, -1122607860);
	WS(-1114300667, -1123436789);
	sum1 = W(0, 1048745214, -1106612992, 1040619730, -1101020989)
		 + W(1, -1120049178, -1129452308, -1112058252, 1040777596)
		 + W(2, 1024457460, 1049280824, 1061265254, 1066754197) + W(3, 1060475010, 1056957204, 1052291799, 1051532558)
		 + W(4, -1084727981, -1099711469, -1091611130, -1090437274)
		 + W(5, -1087975654, -1087165059, -1095257281, -1091858685)
		 + W(6, -1124831645, -1120312678, 991636461, -1115033343)
		 + W(7, 1037659252, 1036876438, 1024723233, -1128167880);
	sum2 = W(0, -1102675226, 1045758589, -1106608364, 1037856863)
		 + W(1, -1121700495, 1038509645, 1041300787, 1013024414) + W(2, -1096018291, 1033992894, 1053924217, 1023354017)
		 + W(3, 1045521037, -1112080608, 1019757091, -1111416466)
		 + W(4, -1064870457, -1078407710, 1074354229, 1077566439)
		 + W(5, 1055978728, -1100523264, 1032114149, -1096094745)
		 + W(6, 1050758265, -1091427154, 1044800412, -1122690967)
		 + W(7, 1037435194, -1101170582, 1048475585, 1031501486);
	WS(-1081349952, -1073531246);
	sum1 = W(0, -1130396178, -1123247001, 1049234666, -1123595694)
		 + W(1, 1044575749, -1118849787, 1027091408, 1015989072)
		 + W(2, -1092471918, -1094799967, -1087091570, -1083589055)
		 + W(3, -1090515766, -1088301188, -1100895532, -1095518837)
		 + W(4, 1052933181, 1040552427, 1062313536, 1056428784) + W(5, 1060166366, 1052569014, 956727337, 1057005798)
		 + W(6, -1120779255, 1032899791, 1048808240, 1047688662)
		 + W(7, 1025076592, -1104574961, -1114767697, 1028829344);
	sum2 = W(0, 1036727690, 1038605852, 1000461252, -1108807283) + W(1, -1118764382, 1040753555, 1025474323, 1026410269)
		 + W(2, -1101780564, 1036224480, 1043313873, 1058417373)
		 + W(3, -1110550387, 1041024731, 1032765623, -1114514162) + W(4, 1047063866, 1003722492, 1071364196, 1075919102)
		 + W(5, 1031984760, 1052825370, -1104266299, 1049040777)
		 + W(6, -1095151348, -1101329253, -1071443435, -1072909475)
		 + W(7, -1137970650, -1094681513, -1130737363, -1100563228);
	WS(-1087415039, 1075227720);
	sum1 =
		W(0, 1014202565, -1121306305, -1115466670, 1055732347) + W(1, -1088701572, 1045428619, -1106855619, -1113272762)
		+ W(2, 1030200505, -1093044977, 1052765481, -1086016434)
		+ W(3, -1108244135, 1044242725, -1102530383, 1042147022)
		+ W(4, 1042588557, 1045750086, -1099185023, -1102841730) + W(5, 1060432915, 1001272287, 1047811955, 1043051755)
		+ W(6, 1032642210, 1039690838, -1099716881, 1054066516) + W(7, -1089156724, 1045967960, 994787170, -1114980876);
	sum2 = W(0, 1034817173, -1106843150, 1035283571, -1117324330)
		 + W(1, -1106783723, 1033652183, -1105003316, -1109219720)
		 + W(2, 1033088277, -1115275500, -1108330169, 1059951304)
		 + W(3, -1114610359, -1130129964, -1100855920, 1017452836)
		 + W(4, -1105460751, 1042281307, -1117933953, 1055263105) + W(5, 1036736577, 1034893511, 1040893249, 1026860110)
		 + W(6, -1119967238, -1122100142, -1118763227, 1033190213)
		 + W(7, -1099584511, -1097591398, 1043864443, -1097701018);
	WS(1061885343, -1093433134);
	sum1 =
		W(0, -1119074171, 1040591342, 1024365415, -1112185530) + W(1, -1102861510, 1047951017, 1033079635, 1030794670)
		+ W(2, -1116612499, -1106037336, -1090085717, -1110885309)
		+ W(3, 1058148680, -1098920364, -1104145445, -1102965524)
		+ W(4, 1043937396, 1035985530, 1054530437, -1105284753) + W(5, -1085809524, 1042740717, -1143903027, 1048819605)
		+ W(6, 1026065358, 1035233146, 1023445318, 1041032751) + W(7, 1043298226, 1028431483, 1030877520, -1110782149);
	sum2 = W(0, -1120425303, 1041777983, 1008642595, 1038578170)
		 + W(1, -1103931105, -1144970974, -1139607395, -1105571910)
		 + W(2, -1115506247, -1109249837, 1051302633, 1062460419)
		 + W(3, 1046700430, -1110379832, -1121481149, -1125592805)
		 + W(4, -1089905659, -1082926483, 976609774, 1062992305) + W(5, 1016533657, 1046952726, -1128426413, 1044012895)
		 + W(6, -1106986872, -1093100415, -1100742938, -1121360027)
		 + W(7, 1026171953, -1123505732, 1047068010, -1108759193);
	WS(1057387711, 1071476886);
	sum1 = W(0, 1029774760, 1046876472, 1049447728, -1104814472) + W(1, 1047761369, -1107998911, 1035672969, 1025453339)
		 + W(2, -1088145158, -1090879061, -1087750555, -1081209882)
		 + W(3, -1102041597, -1088704948, -1101378696, -1090772220)
		 + W(4, 1058722665, 1046940920, 1062289140, 1060559271) + W(5, 1057163193, 1046238393, 1049034574, 1051154538)
		 + W(6, 1026644842, -1124024690, 1034805113, -1101227374)
		 + W(7, 1041428045, -1112057972, -1123650077, 1045125730);
	sum2 = W(0, -1079574021, -1076424748, -1084651933, -1079383446)
		 + W(1, -1094010079, -1105513599, -1094989946, -1083946107)
		 + W(2, 1066168402, 1072246945, 1055648588, 1069722149) + W(3, -1105729737, 1052366950, 1046266897, 1064021500)
		 + W(4, -1106633910, 1039775524, -1122282375, 1050613020)
		 + W(5, -1112550614, 1046757765, 1041413657, -1117589808)
		 + W(6, 1033041398, 1025560740, 1042767844, -1122422479)
		 + W(7, 1029478726, 1029747528, -1132333344, -1110924549);
	WS(-1088291167, -1076464582);
	sum1 = W(0, 1038365083, 1013092187, 1049005176, -1096083994) + W(1, 1046666973, 1029385568, -1130846211, 1035921309)
		 + W(2, 1048475643, 1039614653, -1105893787, -1090164821) + W(3, 1048630844, 1052597003, 1030762351, 1049653618)
		 + W(4, -1115380053, -1115741870, -1115211424, -1106465144)
		 + W(5, -1092124773, -1097273638, -1104199584, -1098780292)
		 + W(6, -1113517956, -1118168192, 1038779144, -1103584918)
		 + W(7, 1051487172, 1036949051, 1029432699, 1041505439);
	sum2 = W(0, -1102442432, 1042447103, 1009200726, -1140140535)
		 + W(1, 1018235219, 1038566242, -1105836948, -1119461411)
		 + W(2, -1119046775, -1103497340, -1108371687, 1063726871)
		 + W(3, 1023996549, -1100556235, -1134905751, -1115426548)
		 + W(4, 1038119755, -1117033259, -1111757198, 1053430514)
		 + W(5, -1097582390, -1130738637, 1027482933, 1038939472)
		 + W(6, -1116688635, -1109692823, -1136365839, -1103585210)
		 + W(7, 1035998106, -1122627505, -1113769016, -1131103707);
	WS(1063535295, -1106643391);
	sum1 = W(0, 998897947, -1114069468, 1030590255, -1120649212)
		 + W(1, -1112623985, -1135800742, -1126057998, -1118923687)
		 + W(2, 1049160779, 1050551697, 1037435628, 1059662980) + W(3, 1051258674, 1051146291, 1042046535, 1051522915)
		 + W(4, -1095715331, -1114097198, -1091439068, -1098500149)
		 + W(5, -1093374928, -1112852607, -1104302276, -1098602138)
		 + W(6, 1022592892, 1035333911, -1105875754, 1036951763)
		 + W(7, -1097348874, 1021555078, 1032877804, -1118947123);
	sum2 = W(0, 1020791040, -1119848331, 1028098574, 1024075228)
		 + W(1, 1036335573, -1114214294, 1028067710, -1123998545)
		 + W(2, 1023004440, 1035188360, 1036866165, -1081188844) + W(3, 1036267331, 1020492762, 1026996488, 1028180222)
		 + W(4, -1131522740, 1010552055, -1087402238, -1063807577)
		 + W(5, -1074297638, 1044255896, -1109527927, -1125487816)
		 + W(6, -1130592194, -1114014595, 1057774258, 1085749988)
		 + W(7, 1072260443, -1101071935, 1041502854, -1121770211);
	WS(1065370528, -1140007425);
	sum1 = W(0, -1119191691, -1123119348, 1043193134, -1144777506)
		 + W(1, 1048874737, -1114692372, 1047204584, 1028382351)
		 + W(2, -1089109360, -1093467562, -1104035088, -1082641845)
		 + W(3, -1090665335, -1085597050, -1097312497, -1084438004)
		 + W(4, 1051697742, 1051845168, 1049231373, 1058881533) + W(5, 1060727795, 1053776045, 1050811579, 1054559607)
		 + W(6, 1048704645, -1120571445, 1047054964, -1128753754)
		 + W(7, -1122636375, -1135014444, 962936920, 1047044271);
	sum2 = W(0, 1072219394, 1068804680, 1068134846, 1066171639)
		 + W(1, -1095987744, -1080918851, -1077110574, -1071545857)
		 + W(2, -1078126224, -1079031251, -1078951161, -1087436811)
		 + W(3, 1039512383, 1067164113, 1069504242, 1075315134)
		 + W(4, -1093298188, -1110022070, -1084926454, -1107767815)
		 + W(5, 1055586357, 1031793821, 1041030661, 1055897321) + W(6, 1011861728, 1040923692, -1105857084, -1121892273)
		 + W(7, 1026590003, 1040751494, -1123439499, -1109554506);
	WS(-1089696543, -1143233957);
	sum1 =
		W(0, -1115482013, 1045323653, -1096516931, 1035013745) + W(1, -1162367211, 1054106403, -1107204469, 1036179510)
		+ W(2, -1129127938, -1098483714, 1045383939, -1091150045)
		+ W(3, 1043411549, -1086835476, 1048447553, -1103773800)
		+ W(4, 1041381507, -1110243009, 1059582003, -1106321908) + W(5, 1034020454, 1026676964, 1034191370, -1159158363)
		+ W(6, -1122467892, 1049605572, -1090424421, 1043667267)
		+ W(7, -1109629626, 1048548650, -1105600748, 1035568493);
	sum2 = W(0, -1134008573, -1125596513, 1011008945, 1051842604)
		 + W(1, -1125276577, -1118729604, -1111959837, -1117720498)
		 + W(2, 1032064725, -1121806942, 1045441656, 1065460002)
		 + W(3, -1114964420, -1130705389, -1121883022, 1034360078)
		 + W(4, -1117795542, 1035355315, 1024667789, -1089961367)
		 + W(5, -1081892598, 1026896379, 1020053498, 1023648883) + W(6, -1113496357, 998755498, -1119910472, 1041632626)
		 + W(7, 1035390555, 1032979221, -1129745921, -1115672512);
	WS(1065278079, -1120402802);
	sum1 = W(0, 1031924074, -1115548942, -1106896516, -1112658654)
		 + W(1, -1103991244, -1121670257, -1115583119, 1031270934)
		 + W(2, 1052390115, 1049303261, 1045251552, 1060948388) + W(3, 1062622505, 1054395391, 1045812503, 1048618059)
		 + W(4, -1097070063, -1099757447, 1040981136, -1081623390)
		 + W(5, -1085365853, -1096062708, -1101077740, -1099232531)
		 + W(6, -1116671142, -1118597165, 1041336272, 1043338841)
		 + W(7, -1145407604, 1032773481, -1123616408, -1127437558);
	sum2 =
		W(0, -1114021356, 1032565152, 1056835748, -1085160508) + W(1, 1058685385, -1086618535, 1047242231, 1032715041)
		+ W(2, -1110767736, -1122384971, -1085457975, 1068814369)
		+ W(3, -1085213012, 1063574785, -1144776155, -1097434793)
		+ W(4, -1100377718, 1041858293, -1085697040, 1060746614)
		+ W(5, 1057245366, -1094120608, -1093482365, 1056356490) + W(6, 1034493514, 1019779384, 1016590225, -1097525969)
		+ W(7, 1043875459, -1097974912, 1054776673, -1096653037);
	WS(1055688959, -1109584743);

	return clamp(mstd0 + 5.0 * vsum / wsum * mstd1, 0.0, 1.0);
}

shared float inp[525];

#define CURRENT_PASS 2

#define GET_SAMPLE(x) dot(x.rgb, rgb2y)
#define imageStore(out_image, pos, val) imageStoreOverride(pos, val.x)
void imageStoreOverride(uint2 pos, float value) {
	float2 UV = mul(rgb2uv, INPUT.SampleLevel(sam_INPUT_LINEAR, HOOKED_map(pos), 0).rgb);
	OUTPUT[pos] = float4(mul(yuv2rgb, float3(value.x, UV)), 1.0);
}

#define INPUT_tex(pos) GET_SAMPLE(vec4(texture(INPUT, pos)))
static const float2 INPUT_size = float2(GetInputSize());
static const float2 INPUT_pt = float2(GetInputPt());

#define temp_tex(pos) (float(texture(temp, pos).x))
static const float2 temp_size = float2(GetInputSize().x * 1, GetInputSize().y * 2);
static const float2 temp_pt = float2(1.0 / (temp_size.x), 1.0 / (temp_size.y));

#define HOOKED_tex(pos) temp_tex(pos)
#define HOOKED_size temp_size
#define HOOKED_pt temp_pt

void Pass2(uint2 blockStart, uint3 threadId) {
	ivec2 group_base = ivec2(gl_WorkGroupID) * ivec2(gl_WorkGroupSize);
	int local_pos = int(gl_LocalInvocationID.x) * 15 + int(gl_LocalInvocationID.y);
	for (int id = int(gl_LocalInvocationIndex); id < 525; id += int(gl_WorkGroupSize.x * gl_WorkGroupSize.y)) {
		uint x = (uint)id / 15, y = (uint)id % 15;
		inp[id] =
			HOOKED_tex(HOOKED_pt * vec2(float(group_base.x + x - (1)) + 0.5, float(group_base.y + y - (3)) + 0.5)).x;
	}
	barrier();
	vec4 ret = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 ret0 = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 samples[8];
	samples[0][0] = inp[local_pos + 0];
	samples[0][1] = inp[local_pos + 1];
	samples[0][2] = inp[local_pos + 2];
	samples[0][3] = inp[local_pos + 3];
	samples[1][0] = inp[local_pos + 4];
	samples[1][1] = inp[local_pos + 5];
	samples[1][2] = inp[local_pos + 6];
	samples[1][3] = inp[local_pos + 7];
	samples[2][0] = inp[local_pos + 15];
	samples[2][1] = inp[local_pos + 16];
	samples[2][2] = inp[local_pos + 17];
	samples[2][3] = inp[local_pos + 18];
	samples[3][0] = inp[local_pos + 19];
	samples[3][1] = inp[local_pos + 20];
	samples[3][2] = inp[local_pos + 21];
	samples[3][3] = inp[local_pos + 22];
	samples[4][0] = inp[local_pos + 30];
	samples[4][1] = inp[local_pos + 31];
	samples[4][2] = inp[local_pos + 32];
	samples[4][3] = inp[local_pos + 33];
	samples[5][0] = inp[local_pos + 34];
	samples[5][1] = inp[local_pos + 35];
	samples[5][2] = inp[local_pos + 36];
	samples[5][3] = inp[local_pos + 37];
	samples[6][0] = inp[local_pos + 45];
	samples[6][1] = inp[local_pos + 46];
	samples[6][2] = inp[local_pos + 47];
	samples[6][3] = inp[local_pos + 48];
	samples[7][0] = inp[local_pos + 49];
	samples[7][1] = inp[local_pos + 50];
	samples[7][2] = inp[local_pos + 51];
	samples[7][3] = inp[local_pos + 52];
	ret[0] = nnedi3(samples);
	ret0[0] = inp[local_pos + 18];
#if CURRENT_PASS == LAST_PASS
	uint2 destPos = blockStart + threadId.xy * ivec2(2, 1);
	uint2 outputSize = GetOutputSize();
	if (destPos.x >= outputSize.x || destPos.y >= outputSize.y) {
		return;
	}
#endif
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(2, 1), ret0);
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(2, 1) + ivec2(1, 0), ret);
}
