//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//!BGFX EFFECT
//!VERSION 1
//!NAME NNEDI3_nns32_win8x6
//!CATEGORY Neural Network
//!DESCRIPTION NNEDI3 - Neural network edge-directed interpolation for high-quality image upscaling

//!TEXTURE
Texture2D INPUT;

//!SAMPLER
//!FILTER POINT
SamplerState sam_INPUT;

//!TEXTURE
//!WIDTH  INPUT_WIDTH * 1 * 2
//!HEIGHT INPUT_HEIGHT * 2 * 1
Texture2D OUTPUT;

//!SAMPLER
//!FILTER LINEAR
SamplerState sam_INPUT_LINEAR;

//!TEXTURE
//!FORMAT R16_FLOAT
//!WIDTH  INPUT_WIDTH * 1
//!HEIGHT INPUT_HEIGHT * 2
Texture2D temp;

//!SAMPLER
//!FILTER POINT
SamplerState sam_temp;

//!COMMON
#include "prescalers.hlsli"

#define LAST_PASS 2

//!PASS 1
//!DESC NNEDI3 (double_y, nns32, win8x6)
//!IN INPUT
//!OUT temp
//!BLOCK_SIZE 32, 16
//!NUM_THREADS 32, 8
#pragma optionNV(inline none)
float nnedi3(vec4 samples[12]) {
	float sum = 0.0, sumsq = 0.0;
	[unroll] for (int i = 0; i < 12; i++) {
		sum += dot(samples[i], vec4(1.0, 1.0, 1.0, 1.0));
		sumsq += dot(samples[i], samples[i]);
	}
	float mstd0 = sum / 48.0;
	float mstd1 = sumsq / 48.0 - mstd0 * mstd0;
	float mstd2 = mix(0.0, inversesqrt(mstd1), mstd1 >= 1.192092896e-7);
	mstd1 *= mstd2;
	float vsum = 0.0, wsum = 0.0, sum1, sum2;
#define T(x) intBitsToFloat(x)
#define W(i, w0, w1, w2, w3) dot(samples[i], vec4(T(w0), T(w1), T(w2), T(w3)))
#define WS(w0, w1)                                                                                                     \
	sum1 = exp(sum1 * mstd2 + T(w0));                                                                                  \
	sum2 = sum2 * mstd2 + T(w1);                                                                                       \
	wsum += sum1;                                                                                                      \
	vsum += sum1 * (sum2 / (1.0 + abs(sum2)));
	sum1 = W(0, -1120567290, 994153301, -1139074345, 1021572063)
		 + W(1, -1117468940, -1119615974, -1132374181, 1016607238)
		 + W(2, 992947237, -1137843051, -1125619459, 1000210819)
		 + W(3, -1132591953, -1122316900, 1053527378, -1096186409)
		 + W(4, -1144213939, -1121684346, -1125130389, -1146864427)
		 + W(5, 1046512564, 1056444330, -1138699933, -1129869365)
		 + W(6, -1117911182, 1031756856, -1093298645, 1051252577) + W(7, 1023905988, 979248533, -1119806663, 1024055745)
		 + W(8, -1112059294, -1109040755, 1033651817, -1119537890)
		 + W(9, -1121091407, 1003125923, -1120338466, -1148456803)
		 + W(10, -1133630411, -1141776739, -1126690796, 1029429758)
		 + W(11, -1110173889, -1113641375, 1032546877, -1127458445);
	sum2 =
		W(0, -1126549409, 1022573468, -1140490164, -1114833146) + W(1, 1021805248, 1003196031, -1119263575, -1114028928)
		+ W(2, -1119708173, 1024108770, -1146392599, -1113990054)
		+ W(3, 1019494412, -1116443736, 1032492771, 1037187519) + W(4, 1026983682, 1006796332, -1124834267, -1099458226)
		+ W(5, 1055169273, 1055452063, -1095922228, -1126677517) + W(6, 1007192676, 1017309436, 1044169825, -1106256028)
		+ W(7, -1122158651, 1022777176, -1122284082, -1118444706)
		+ W(8, 1039787167, -1112035826, -1118290710, -1130573089)
		+ W(9, -1127647730, -1121042004, -1145097543, -1125070906)
		+ W(10, -1129575364, -1123455912, 1010488320, -1109973330)
		+ W(11, 1044065299, -1121131548, -1121253833, 1019346120);
	WS(1060265584, 1063714812);
	sum1 = W(0, 1021450242, -1128788280, -1111111528, 1039397963)
		 + W(1, -1131322533, 1011253684, -1123065753, 1022311347) + W(2, 999728711, -1108349889, 1022720848, 974355898)
		 + W(3, -1137050988, 1028928107, -1119265827, 1026074151)
		 + W(4, 1019796282, -1136338948, 1021294882, -1140362288)
		 + W(5, -1137639751, -1102959280, 1043907075, 1025863841)
		 + W(6, -1118036885, 1024570351, -1101623708, 1041760911)
		 + W(7, -1151514983, -1136816500, 1009531192, 1035626828)
		 + W(8, -1106406289, 1036057270, -1132552740, 1027651305)
		 + W(9, -1118665549, 1025121435, -1128138578, 1017790822)
		 + W(10, -1124857459, -1139070668, 992320459, 1029327365)
		 + W(11, -1106167682, 1037788386, -1134343810, 1024478285);
	sum2 = W(0, 1023758242, -1130878336, -1120671625, 1027498838)
		 + W(1, -1144315403, -1131041230, -1124053764, 1017938673)
		 + W(2, -1145138723, 1027873020, -1122179044, -1127336921)
		 + W(3, 1000956747, 1028583936, 1005174931, 1053869854) + W(4, -1093535895, 1009416925, -1122894214, 1031015106)
		 + W(5, -1104963408, 1073183850, -1074622268, 1033668418) + W(6, 999883691, 994031846, 1001047899, 1053107786)
		 + W(7, -1094361386, 990806038, 1004424067, 999096115) + W(8, -1126082311, 1035733703, -1114468554, 992895974)
		 + W(9, -1150041590, -1134395125, 1002728051, 1022225293)
		 + W(10, -1123867271, -1131337021, 1009546537, 1005722235)
		 + W(11, -1135618057, 1023923178, -1126165581, -1138321549);
	WS(1067199072, 981674447);
	sum1 =
		W(0, -1113726457, -1105288827, 1040785760, 1032552483) + W(1, -1124907206, -1139898486, 1018794771, -1113372949)
		+ W(2, -1099180638, 1040483381, -1114167068, -1127069135)
		+ W(3, -1115871564, -1095136821, 1050678235, 1054762461)
		+ W(4, -1107257499, -1118671794, 1008735750, -1102105679)
		+ W(5, 1052734745, 1065065389, -1097429016, 1035770473) + W(6, -1125817867, -1103744656, 1044281884, 1044820043)
		+ W(7, -1104994292, -1122788302, -1125149117, -1108798620)
		+ W(8, 1033282170, -1097094388, 1027211226, -1125646899)
		+ W(9, 1001830321, -1137689902, -1121192922, 1010644366)
		+ W(10, -1114303237, -1123221796, 1016463803, -1099284685)
		+ W(11, 1032013917, -1124668651, 1015961570, -1114483455);
	sum2 =
		W(0, -1124538541, 1021627528, -1127440395, 1027300307) + W(1, 1020622605, -1130074937, -1139313841, 989560618)
		+ W(2, 1028695072, 1011050585, 999023778, 1015498074) + W(3, -1119374292, 1014774531, -1102978428, 1052523334)
		+ W(4, -1119874204, -1126569197, 1010830983, 1026431506)
		+ W(5, -1087762234, 1053318756, 1038687085, -1128231773)
		+ W(6, 1020827626, -1118520012, 1027251929, -1113197028) + W(7, 1029469191, 1018969905, -1125616841, 1018739126)
		+ W(8, -1109480314, 1034265115, -1125820221, -1123965604)
		+ W(9, 1008596323, 1014458179, 1023848922, -1134832277)
		+ W(10, -1159659466, 1024095771, -1136528497, -1129452021)
		+ W(11, -1132845253, 1022117249, -1150305989, -1130502215);
	WS(-1082327904, -1101742629);
	sum1 =
		W(0, -1128942355, 994965062, -1116531225, 1027052286) + W(1, -1127603958, 1021969515, 1007179909, -1124051394)
		+ W(2, 1022855203, -1119991818, 1015495233, -1129777663)
		+ W(3, -1172666584, 1029361427, 1044526075, -1110346311) + W(4, 1026992677, 1017142675, -1115398989, 1047686461)
		+ W(5, -1095192109, -1106285700, 1037065627, -1113404469)
		+ W(6, -1145393643, 1028067431, -1123739865, 1043850022)
		+ W(7, -1119388383, -1130059467, -1126910957, 1025118144)
		+ W(8, -1116394763, 1030498357, 1013662917, 1016457699)
		+ W(9, -1153678686, -1121058723, -1123838961, 1032721886)
		+ W(10, -1119902562, -1131255799, -1127439210, 1018201755)
		+ W(11, -1120454737, 1034890279, 1021249778, 1017348651);
	sum2 =
		W(0, 1014279427, -1130890464, -1129394348, 1014973315) + W(1, -1152876382, 1004833335, -1131491186, -1137235679)
		+ W(2, 1024729347, -1130557096, -1150339726, -1141673719)
		+ W(3, 1026571161, -1097554196, 1048952496, 1014221291) + W(4, 1016692910, -1159625756, 1042930837, -1073378768)
		+ W(5, 1073588633, -1105375875, 1035354953, -1124590261) + W(6, 1025279833, -1092458255, 1053816664, 1016092170)
		+ W(7, -1129170378, 989537980, 993445038, -1130245298) + W(8, 1029166823, -1119905200, 1027382919, -1138326931)
		+ W(9, -1133457551, -1120075373, 1030737081, -1147013927)
		+ W(10, -1124802440, 1017200998, 1014707171, -1135266971)
		+ W(11, -1151431678, -1161525308, 979085751, 1009604643);
	WS(1067891072, -1132872541);
	sum1 =
		W(0, 1025237873, -1122834636, -1117007553, -1114151507) + W(1, 1031366707, 984935338, 1014334757, 1020114356)
		+ W(2, -1118569017, 976917621, 1039451348, -1152616053) + W(3, 1030238795, -1105197551, 1049984500, -1088419628)
		+ W(4, 1049092386, -1123762161, 1029025473, -1121917372)
		+ W(5, -1114461425, 1051488823, 1008484089, -1145922699) + W(6, 1007260181, 1038150728, -1084792932, 1053317187)
		+ W(7, -1122288663, 1012164149, -1121222990, 1024596920) + W(8, 1039495098, 987986858, -1131993235, 1000937675)
		+ W(9, 988616634, 1024170379, -1124531763, 1026119523) + W(10, 1022258228, 1011615629, -1123834925, 1015271403)
		+ W(11, 1027254009, 993078101, 999667975, 1004174827);
	sum2 = W(0, -1144599930, -1116760996, 1032730282, 1032901632)
		 + W(1, 985378521, -1129170670, -1136232721, 1019759527)
		 + W(2, -1125055029, 1027655943, 1005941018, -1131155477)
		 + W(3, -1137221455, -1111064134, 1047170030, -1115058011)
		 + W(4, -1129460922, -1129924333, -1128645029, 1041961890)
		 + W(5, 1050767412, -1130649513, 1019394239, 1022276751)
		 + W(6, -1151231836, 1036336113, -1093680614, -1116185015)
		 + W(7, -1115704458, -1148456898, -1156748756, 1033905549)
		 + W(8, -1120368706, -1105887613, 1024734935, 1015791177)
		 + W(9, -1160295481, 1022489781, -1115425401, 1012694293)
		 + W(10, -1147415538, -1140100033, 1020235585, -1122711401)
		 + W(11, -1132924343, -1122854992, 1018590227, 1012472897);
	WS(1059709408, 1024973287);
	sum1 =
		W(0, -1126012593, 996494647, -1119189544, 1028092109) + W(1, -1124577204, 1023428420, 1004611460, -1122880609)
		+ W(2, 1030391200, -1114579692, 1016065247, -1127475101)
		+ W(3, -1134152138, 1020165829, 1046947367, -1111968183) + W(4, 1002304420, 1021721777, -1114032340, 1049657976)
		+ W(5, -1094041084, -1106474499, 1040268033, -1114564220)
		+ W(6, -1131432537, 1014735450, 1018380112, 1044458845)
		+ W(7, -1114168306, -1128430825, -1126017195, 1032225804)
		+ W(8, -1112475533, 1030371012, 1023640576, 1019190017) + W(9, 991561039, -1115613273, -1123292160, 1033263557)
		+ W(10, -1119951545, -1127717781, -1124178504, 1022764985)
		+ W(11, -1122300512, 1034006830, 1017080432, 1017178441);
	sum2 =
		W(0, -1125800395, 1024962708, 1023886172, -1122338700) + W(1, -1171853367, 973576887, 1011909323, -1143341847)
		+ W(2, -1144213999, 1018807292, 1000330119, 984068764) + W(3, -1116511680, 1052819438, -1097320166, -1115186882)
		+ W(4, -1140479659, 1001426319, -1103527255, 1076690943)
		+ W(5, -1072687587, -1098249874, 1023038428, 1007326739)
		+ W(6, -1120293374, 1057154431, -1091630497, -1117298851)
		+ W(7, 1029135274, -1135413483, -1148349175, 990717342) + W(8, 1012280135, 1010582795, -1122270538, 1008233815)
		+ W(9, 1015270352, 1025045202, -1118805022, 990164302) + W(10, 1020995472, -1129534965, -1125483347, 1023577182)
		+ W(11, 1016249338, -1125194137, 1003973863, -1140102471);
	WS(1066253200, 1009489111);
	sum1 =
		W(0, -1121073890, -1102592607, 1041243549, 1033075644) + W(1, -1123366116, -1130535196, 1024085178, -1107707469)
		+ W(2, 1026388586, -1107162241, 1004872905, -1145989825)
		+ W(3, -1130104696, -1106598971, -1121496677, 1050587318)
		+ W(4, -1113976447, -1120961954, 1023275236, -1116780301)
		+ W(5, 1049328440, 1057262167, -1116780079, 1023066500) + W(6, -1128214764, -1111680448, 1018012708, 1027096831)
		+ W(7, -1113850464, -1121521086, -1135799996, 1032050668)
		+ W(8, -1096674093, 1040843700, 1015552212, 1008378152)
		+ W(9, -1141685621, -1131519352, -1122519370, 1028580820)
		+ W(10, -1123000331, -1124335656, -1121776782, 1028096678)
		+ W(11, -1101864235, -1117086438, 1040749648, -1135644600);
	sum2 =
		W(0, 1013104936, -1106333857, 1041445982, -1143812784)
		+ W(1, -1111423698, -1153458272, -1117172679, -1121647283)
		+ W(2, 1046293466, -1098323478, 1025469214, -1123006845) + W(3, -1127525498, 1031691189, 1054977467, 1032669672)
		+ W(4, -1110723238, 1018478818, -1135146700, 1030458550) + W(5, 1051999059, 1016608418, 1041509878, -1111394764)
		+ W(6, -1122718205, -1111791784, 1044523088, -1093831562)
		+ W(7, 1024902469, -1127833490, 1027187072, 1009508096)
		+ W(8, -1099681845, 1044831040, -1110045970, -1140396324)
		+ W(9, -1119344027, -1127767754, -1185033988, -1117227205)
		+ W(10, -1129401382, -1129041118, -1128814570, 1037784205)
		+ W(11, -1107269301, -1118967703, -1121987113, 1021194206);
	WS(1055988095, 1068562120);
	sum1 = W(0, 1025054956, 1041692938, 1040251631, -1141880069)
		 + W(1, -1113980711, 1011769695, -1130996743, 1036197410) + W(2, 1032351834, 1043619883, 1002392085, 1020511427)
		 + W(3, 1024941510, 1042434277, -1100356972, 1026325313) + W(4, 1040781794, -1124414423, 1026193148, 1039706891)
		 + W(5, -1093055992, -1087193164, 1032223740, -1163338101)
		 + W(6, 1035977616, 1036807045, 1047058383, -1087410536) + W(7, 1047196369, 1015241743, 1028839961, 1029783554)
		 + W(8, 1043491547, -1097265155, 1027612260, -1129538215)
		 + W(9, 1016648336, 1019008523, 1044781893, -1104034167) + W(10, 1036828166, 1018634427, 1025665319, 1026886128)
		 + W(11, 1048991774, -1099060796, -1113322870, -1180507092);
	sum2 = W(0, -1109623534, -1098330057, 1051762285, -1105318233)
		 + W(1, -1120494292, 1036873688, -1119308996, -1121926087)
		 + W(2, 1045894429, -1111281216, 1002875661, -1152598618)
		 + W(3, -1108667787, 1031129408, 1029096148, -1116694436)
		 + W(4, 1042501069, -1117793653, -1107757858, -1111457821)
		 + W(5, 1060518836, -1103134861, -1104320409, 1023528108)
		 + W(6, -1126585969, -1091241820, 1065480819, 1017373783)
		 + W(7, 1041202422, -1117516356, -1144042093, -1092220222)
		 + W(8, -1120268316, 1034184394, -1131983911, -1123122827)
		 + W(9, 1004201965, -1112242725, 1035423856, -1129342463)
		 + W(10, 1023586732, -1131565835, 1024608852, -1104308532)
		 + W(11, -1105721536, -1134873838, 1017105251, 1015347387);
	WS(-1073915832, -1098883962);
	sum1 = W(0, 1030932360, 1024626915, -1098288699, -1130380922)
		 + W(1, 1033018229, 1021355752, -1131602112, 1032898976)
		 + W(2, -1117814224, -1103847418, 1040490540, -1120290302)
		 + W(3, -1125999684, -1122370130, 1056014501, -1096397881)
		 + W(4, 1031863906, -1131922448, 1018154928, 1011274315)
		 + W(5, -1106175819, -1105327485, 1044317365, -1139369119)
		 + W(6, -1122265980, -1113904235, -1097956311, 1059753579)
		 + W(7, -1098424101, -1121102372, -1122315861, 1029902191)
		 + W(8, -1115232133, 1040451325, -1122968848, 1033247800)
		 + W(9, 1018577993, -1115348785, -1126206816, 1039068637)
		 + W(10, -1136273729, -1121007738, -1120663220, -1111387910)
		 + W(11, 1017122848, 1042824131, 1021433455, -1143567007);
	sum2 =
		W(0, -1118315643, 1046909717, -1100980148, -1129801877) + W(1, -1122172234, 1010610423, -1126395193, 1025514844)
		+ W(2, -1112473945, 1030594060, -1111527676, -1135186433)
		+ W(3, 1014636591, 1026986728, 1040985677, -1101816290) + W(4, 1023795758, 1030475382, -1138413531, -1112879553)
		+ W(5, 1027746798, -1094641835, 1027030278, -1121095046) + W(6, 1013622247, -1122377333, 1051150943, 1041324898)
		+ W(7, -1113671456, 1015864126, -1129252552, -1114813410)
		+ W(8, 1057006779, -1106485598, -1133454616, 999966259)
		+ W(9, -1122713894, -1144089687, -1138866101, -1115757412)
		+ W(10, 1001347783, -1127643580, -1131632742, -1140190295)
		+ W(11, 1035155819, 1016695560, -1139893847, -1124292419);
	WS(1058139200, 1067005003);
	sum1 = W(0, -1131277347, -1103206155, 1015263811, 1048238354)
		 + W(1, -1106607621, -1122297405, -1128484819, -1112832909)
		 + W(2, -1111332237, 1044526364, -1104751670, -1124214159)
		 + W(3, 1014594990, -1108301118, 1004409248, 1056580635)
		 + W(4, -1107635783, 1017238947, -1112913457, -1111811582)
		 + W(5, 1031432468, -1114379264, -1107787999, -1110162105)
		 + W(6, 1028891109, -1113179152, 1057408386, 1025802539)
		 + W(7, 1020725062, 1002560364, -1118434446, -1100757638)
		 + W(8, 1053177162, -1104236495, -1114959053, -1113724157)
		 + W(9, -1125459884, -1116265771, 1035803645, -1124751623)
		 + W(10, -1129296244, -1123244163, -1151139539, -1119227733)
		 + W(11, 1052437131, -1121289813, -1120069105, -1115210511);
	sum2 =
		W(0, -1121057595, 1023292260, -1111891368, 1035766063) + W(1, 1032208606, -1122161823, 1016432775, -1124268922)
		+ W(2, 1029388268, -1118389960, -1122510207, 1028529468)
		+ W(3, -1112629457, -1116199054, -1123843875, 1033023394)
		+ W(4, -1113138713, -1118001871, 1031151061, -1110795130) + W(5, 1054055516, 1054507013, 1019595258, 1026811027)
		+ W(6, -1126819952, -1103006120, 1020478730, -1104664187)
		+ W(7, -1114598707, -1116707921, 1021228732, -1134369449)
		+ W(8, -1135412321, -1121918429, 1023542227, 1018790016) + W(9, 1009585899, -1120667087, 993043492, 982538191)
		+ W(10, 993709924, -1146185904, -1127402608, 1016333862)
		+ W(11, 996548072, -1108029597, -1129671373, -1152045912);
	WS(-1091835967, 1038509097);
	sum1 = W(0, 1002958335, 1041562959, -1124369824, -1093861855)
		 + W(1, 1039801017, -1132073944, 1031236696, 1038000620) + W(2, 1029288008, -1100002304, 1038306915, 1032364667)
		 + W(3, -1122124314, 1042029266, -1104824881, -1087002164)
		 + W(4, 1037725118, -1122032128, 1034973544, 1034473413) + W(5, 1049571184, 1052741396, 1041619283, 1036587856)
		 + W(6, -1120202292, 1040514695, -1089024373, 1044570703)
		 + W(7, 1031782758, -1138629744, 1015820538, 1042048878) + W(8, -1089426268, 1042398171, 1038671876, 1010685600)
		 + W(9, 1033636218, 1029242778, -1107643796, 1023923250)
		 + W(10, 1025678032, 1027566834, -1121967836, 1042898689)
		 + W(11, -1091407169, 1030369604, 1043274836, -1153060031);
	sum2 = W(0, 1016791821, -1110538641, -1114409767, 1045544748)
		 + W(1, -1111278622, -1127655665, 1013192458, 1023566599)
		 + W(2, -1113846927, 1029704719, -1125617069, 1012727082)
		 + W(3, -1123883287, 1000152052, -1109610416, 1034122997)
		 + W(4, -1110039103, -1131212885, 1015528749, -1112636904)
		 + W(5, 1054155729, 1054056541, -1108588248, 1000573476)
		 + W(6, -1131825297, -1116367667, -1109117303, 1030522539)
		 + W(7, -1132906850, -1123699129, -1132736674, -1130121037)
		 + W(8, 1016394661, -1116026974, -1135451026, -1126704253)
		 + W(9, 1019880949, -1114305335, 1030290683, 992430312) + W(10, -1134728538, 988228497, -1117749640, 1033496981)
		 + W(11, -1157815185, -1107824982, 1016739853, -1123545619);
	WS(-1089794384, 1053743764);
	sum1 =
		W(0, 977181200, -1124062435, 1045792382, -1096122984) + W(1, 1035356461, -1146772642, 1022034304, -1123589329)
		+ W(2, 1045687772, -1100185218, 1029423919, 1022712508) + W(3, 999195154, 1008939465, 1043214811, -1089534650)
		+ W(4, 1037071922, 986801416, -1173982736, 967031199) + W(5, 1051096635, -1128424615, -1130937578, 1009586465)
		+ W(6, -1131079992, 1031201254, -1106608558, 1022835035) + W(7, 1033635179, 1012941585, -1117753925, 1038421055)
		+ W(8, -1104815387, 1033659882, -1112564552, 1008485953) + W(9, 1011212627, 1023184516, 975115280, 1025453978)
		+ W(10, -1148354182, 1023442138, -1131210280, 1042888267)
		+ W(11, -1113606040, -1114474998, -1115626236, 1020831720);
	sum2 =
		W(0, 1025756371, 1038582018, -1095235720, -1097242729) + W(1, 1048188946, -1145714840, -1152866061, -1136865390)
		+ W(2, 1027392563, -1108446917, 1009460859, 1022755591) + W(3, 1022411083, 1028991375, -1094985700, -1092586393)
		+ W(4, 1013992713, 1033471029, 1021941035, -1102180290) + W(5, 1062263751, 1055770556, -1098658877, 1018658879)
		+ W(6, 1018807869, -1127151005, 1023141397, 1024429444)
		+ W(7, -1162587434, 1032105067, -1162131898, -1103213990)
		+ W(8, 1032099771, 1045256871, -1104388978, -1135748387)
		+ W(9, 1030478695, -1148467374, -1139645537, -1115314196)
		+ W(10, 1033707193, 1008760659, -1117519259, -1101731450)
		+ W(11, 1050734432, 1044538365, -1097902791, 1019361371);
	WS(-1092258911, -1089815334);
	sum1 = W(0, -1139634407, 1045821685, -1119357002, 1034361159)
		 + W(1, -1137425069, -1130196683, -1147044493, 1034203057)
		 + W(2, 1015718019, 1051668019, -1115826689, 1023465264) + W(3, 1017866535, 1044613801, -1104936487, 1032636456)
		 + W(4, 1035725147, 1015877619, -1130890003, 1035729090)
		 + W(5, -1090722234, -1086460492, 1010439579, -1117806874)
		 + W(6, 1027130446, 1029847032, 1052628837, -1094763749) + W(7, 1043916211, 1025832214, 1016637069, -1102281888)
		 + W(8, 1057948020, -1095562645, -1114240161, -1123952546)
		 + W(9, 1016500860, -1131657511, 1044884520, -1106362539)
		 + W(10, 1035145793, 1029577644, 1026913637, -1121093118)
		 + W(11, 1053191568, -1098187032, -1102258214, 1011300119);
	sum2 =
		W(0, -1128703433, -1113670137, 1038503213, 1040684472) + W(1, -1099552212, 993905065, 1012757410, 1024378351)
		+ W(2, -1102109659, -1100043210, 1026887817, 1003273444) + W(3, 1007787634, -1111552612, 1041322248, 1041989415)
		+ W(4, -1104965070, -1144755940, 1023396449, -1131966925)
		+ W(5, 1061982310, 1066879681, -1107386978, 1019447753)
		+ W(6, 1017560605, -1114649634, -1104769108, -1101238360)
		+ W(7, -1104448348, 1019550873, 1012244530, 1040107467) + W(8, -1098175974, -1089047102, 1016563929, 1024790159)
		+ W(9, -1143125556, -1122758108, 1026757617, 1023979343)
		+ W(10, -1107880053, -1138003290, 1024938353, 1032092801)
		+ W(11, -1105089779, -1100231891, 1036400101, 1014825186);
	WS(-1086002512, -1084928660);
	sum1 =
		W(0, -1131929465, -1115340892, 1050776738, -1103148388)
		+ W(1, -1143173743, -1130358353, 1017039401, -1113717074)
		+ W(2, 1042912513, 1010821235, -1128281895, -1122997746)
		+ W(3, 1020173741, -1102662114, 1053707114, -1104889757)
		+ W(4, -1111952748, -1139775729, -1134499377, -1097984585)
		+ W(5, 1055825787, 1049797700, -1098746549, -1117617116) + W(6, -1129468257, 999020755, -1108349590, 1042555580)
		+ W(7, -1106170922, 1014563169, -1138890277, -1114393442)
		+ W(8, 1033511359, 1041826234, -1103706929, 1010736529) + W(9, -1132813939, 1028151894, -1108075378, 1032548919)
		+ W(10, -1127274842, -1137959865, -1143488833, -1132982017)
		+ W(11, -1138015505, 1041074464, -1110410462, -1123442568);
	sum2 =
		W(0, 1000102260, -1118205558, 1051204856, 1041999613) + W(1, -1135930364, 1019347314, -1126633986, 1029900308)
		+ W(2, 1063980475, 1037162912, -1134402620, -1137379540)
		+ W(3, -1144291760, -1140439712, 1066576503, -1167793729)
		+ W(4, 1020225891, 1012525172, -1119827470, 1041420529)
		+ W(5, -1075398805, -1085093765, -1133429672, -1123883092)
		+ W(6, 1016232493, 979974721, -1098954833, 1017117707) + W(7, 1028764817, -1139078108, 1023762781, 1006017080)
		+ W(8, -1114660078, 1033481679, 1018587503, 990744512) + W(9, -1141218312, -1137204884, 1021034547, -1137323924)
		+ W(10, -1132685152, -1137103964, 1025293286, 1002898232)
		+ W(11, -1117648930, 1002077480, 1026769102, 1022792204);
	WS(-1084377664, 1027078466);
	sum1 =
		W(0, 1028609881, 1023875764, -1113303893, 1031700430) + W(1, -1138486380, 1025866053, -1129675619, 1032239673)
		+ W(2, -1114746833, 1026119482, -1122216064, 1016759071) + W(3, 1022038247, 1043647401, -1084547118, 1051850662)
		+ W(4, -1132199979, 1032834541, 1010908070, 1024809124) + W(5, -1156932707, -1104988345, 1033025459, 1029398137)
		+ W(6, 1026611885, -1131519215, 1050946557, -1083734174) + W(7, 1043104191, 1007914454, 1030113110, -1128260416)
		+ W(8, 1047159719, 1027361605, 1018468419, 1021351811) + W(9, -1132403564, 1026951667, 1020650755, -1111325382)
		+ W(10, 1014159432, 1014779182, 1031201461, -1115829469)
		+ W(11, 1037768177, 1042797655, -1108759836, 1018395723);
	sum2 = W(0, -1123315648, 1034590473, 1026150549, 1030314237)
		 + W(1, -1113579452, 1014056813, -1139192721, -1139997869)
		 + W(2, 969235347, -1112534256, -1158492453, -1132289868)
		 + W(3, -1123875414, -1115134908, 1042477897, 1037120039)
		 + W(4, -1098184684, 1018097190, 1030816333, 1008365317) + W(5, 1046059603, 1027803789, 1032895251, 1032146261)
		 + W(6, -1123326315, -1110803030, -1155992274, -1102080708)
		 + W(7, -1126452160, -1114996104, 1016532474, 1028786615)
		 + W(8, -1122978967, -1135183209, 1047700729, 1011346781)
		 + W(9, -1130303816, 1004595129, -1119026545, -1120008811)
		 + W(10, 999072441, -1115756663, -1131093304, 1015409534)
		 + W(11, -1111529432, -1109468455, 1047312851, -1122411639);
	WS(1043014014, -1087744322);
	sum1 =
		W(0, 1027952711, -1123526530, 1008337244, 1035059438) + W(1, -1116610857, 1026995059, 1020523582, -1138321214)
		+ W(2, 1022379422, -1120526792, 1037330895, -1156487121)
		+ W(3, 1002118409, -1110182129, 1057818171, -1086364127) + W(4, 1040407761, 1009757724, 1021435438, 1032339433)
		+ W(5, -1110004232, -1118604170, 1040846837, -1153254001)
		+ W(6, -1138414444, 1035386835, -1083267015, 1057062103)
		+ W(7, -1107059287, 1021783366, 1003104545, -1137297015) + W(8, 1007303460, 1036507098, -1128420830, 1034169880)
		+ W(9, 1021955143, -1119534945, -1115695919, 1038869533)
		+ W(10, 1017909759, -1138765796, 1013303243, -1108462406)
		+ W(11, 1036022088, 1036993862, -1142792885, 1027514579);
	sum2 =
		W(0, -1129567658, -1117738234, 1034622765, 1030957051) + W(1, 1029443337, -1132249217, -1156092221, -1131091573)
		+ W(2, -1128107850, -1118479197, 1005860107, 969559787) + W(3, -1123579911, -1115037144, 1017778197, 1041246295)
		+ W(4, -1110926783, -1132354551, 1008715269, -1115010115)
		+ W(5, 1050631618, 1054490255, -1157251077, 1024782459)
		+ W(6, -1125160256, -1101087826, 1045062017, -1117275788) + W(7, -1108959270, 998415619, 1026524337, 1015586863)
		+ W(8, -1095615964, 1025836507, 1020928095, 1012990901) + W(9, -1137738801, -1113332277, 1020345131, 1027688491)
		+ W(10, -1122972204, -1161032699, 1017463077, 1019720419)
		+ W(11, -1101223712, -1120912313, 983922363, 1011300789);
	WS(1054959103, -1083836992);
	sum1 =
		W(0, -1144415487, 1023853723, -1123173616, -1121737045)
		+ W(1, -1124541667, 1017937944, -1132171248, -1118146184)
		+ W(2, 1018672592, -1123041056, -1120856711, -1131928876)
		+ W(3, -1133053416, 1039313221, -1090265426, -1161038260) + W(4, 1034290206, 1027902624, 980216825, -1107434917)
		+ W(5, 1057912142, 1053211380, -1109871174, -1129566080) + W(6, 1018609320, 1027331294, 1044087220, -1089253699)
		+ W(7, 1040602782, -1121689404, 1017404666, -1111685883) + W(8, 1046306952, 1036559366, -1113560292, 1010241568)
		+ W(9, -1127349353, -1129432820, -1133031712, -1110305609)
		+ W(10, -1148202051, -1124796708, -1154920122, -1126004808)
		+ W(11, 1039769364, 1035028498, -1109624712, -1127304152);
	sum2 = W(0, 1018338338, -1110884586, -1136808221, 1026570078)
		 + W(1, -1136194357, -1120452457, -1139755941, -1129406227)
		 + W(2, -1118232763, 1021052542, 1020321772, 1004896115)
		 + W(3, 1025801614, -1108237236, -1115176435, -1114736489)
		 + W(4, 1048907220, -1119060361, -1122001203, 1037408540)
		 + W(5, -1113269344, 1041519115, 1046652366, -1107310106)
		 + W(6, 1010171613, 1040327756, -1105808410, 1047951095)
		 + W(7, 1035402835, 1033649944, -1132321439, -1123391437)
		 + W(8, -1110685464, -1115014721, -1111631696, -1126977687)
		 + W(9, 1016232007, -1129086463, -1168436052, -1113536502)
		 + W(10, 1026410761, 1026056519, 1013259501, -1132299663)
		 + W(11, 1021765462, -1123780081, -1102273277, 1027695361);
	WS(1057903600, 1067139767);
	sum1 = W(0, -1130009103, -1107061793, 1043136838, -1102099951)
		 + W(1, -1115498357, -1123992244, 1012511358, -1111029392)
		 + W(2, 1028125200, 992918145, -1117969679, -1145160172)
		 + W(3, -1137761926, -1104154592, 1051222763, -1106189879)
		 + W(4, -1104467697, -1125356943, -1124300975, -1103367501)
		 + W(5, 1060113955, 1050079197, -1108729546, -1117739880) + W(6, 1008012526, 1009980758, 1024983063, 1048697267)
		 + W(7, -1111781863, -1165450354, -1117250069, -1113394087)
		 + W(8, 1016245011, 1034440698, -1104780916, -1114615608)
		 + W(9, -1162310274, 1026647906, -1117690736, 1041096574)
		 + W(10, -1117169584, -1139440358, -1115259538, -1114684710)
		 + W(11, 1025498192, 1041574755, -1120787335, -1118506516);
	sum2 = W(0, 1011962608, 1038855085, -1122245118, -1126451804)
		 + W(1, -1106947014, 1026864717, -1120699406, -1131692032)
		 + W(2, -1112627842, -1110442893, 1008646548, -1123527836)
		 + W(3, 1007214128, 1038467393, -1122221782, 1042136464) + W(4, -1113116412, 999106843, 1026799984, -1112343444)
		 + W(5, -1106597578, 1054959792, -1109079281, 1011333214)
		 + W(6, -1145867047, -1113849522, 1026356645, 1031831390)
		 + W(7, -1109881757, -1117815384, 1029224075, -1138735380)
		 + W(8, -1114988845, 1046305460, -1109725169, 1032922020)
		 + W(9, -1116434980, -1120001434, 1020413259, 1008343524)
		 + W(10, -1123390380, -1119479700, 1022659583, -1118784264)
		 + W(11, -1123194990, 1047204017, -1114571313, 1000599735);
	WS(-1101058110, 1058505899);
	sum1 = W(0, 1008909245, -1123852394, 1037579744, 1024016996)
		 + W(1, -1121096497, 1022516663, 1015324303, -1112299044)
		 + W(2, 992056181, -1124723744, -1131134189, -1130344395)
		 + W(3, -1151491221, -1128516275, -1098678002, 1056678303)
		 + W(4, -1109419958, 1021039583, -1139701245, -1102217815)
		 + W(5, 1045087960, 1021619781, -1098726544, -1132041247)
		 + W(6, 1009250957, -1104833467, 1058072040, -1095085849)
		 + W(7, -1109643932, -1140161581, 1031005836, -1113648843)
		 + W(8, 1036986521, 1041104615, -1121889031, 1026848535)
		 + W(9, -1131857944, -1119585353, 1024521495, -1129179587)
		 + W(10, -1127292144, -1125244995, 1009310828, -1121962739)
		 + W(11, 1032839164, 1025292595, 1017031326, 1005622747);
	sum2 = W(0, 992821683, 1023078017, 1023704638, -1112719649) + W(1, 1027637582, 1021903376, 1017011277, -1140746852)
		 + W(2, -1139829185, 1034266306, -1119668356, 1016759855) + W(3, 1011814063, 959773689, -1107874815, 1032357888)
		 + W(4, -1113625790, 1034398452, 999390943, -1112338116)
		 + W(5, -1113377165, 1057654961, -1086342498, 1051594315)
		 + W(6, -1121326865, 1035095219, -1108229047, 1012152366)
		 + W(7, -1101720659, 1035110699, -1128713872, 1024063493)
		 + W(8, 1033653422, -1122811174, -1136544465, 1031049449)
		 + W(9, -1144442308, 1023948090, -1133039950, 1020168485)
		 + W(10, -1121720102, 1018271190, -1138094133, 1032024680)
		 + W(11, -1140161389, -1113617432, 1019370668, 1021410443);
	WS(-1098338111, 1023498750);
	sum1 =
		W(0, -1138701849, -1121510465, 1040383254, 1010706669) + W(1, -1149170878, 1021863397, 1022617405, -1112416999)
		+ W(2, 1041395124, -1110248019, 1020223099, 1016227961)
		+ W(3, -1168316434, -1180399652, -1097293461, 1058209828) + W(4, -1106291545, 1018489101, 989875557, 1037491593)
		+ W(5, -1094988553, -1095385553, 984962665, 1021609037) + W(6, 1014043241, -1102495433, 1059563452, -1097437690)
		+ W(7, -1119747464, -1145092370, 1028694643, -1121884733)
		+ W(8, -1118903112, 1046085501, -1122110350, 1026243438)
		+ W(9, 1012653195, -1122132512, 1027507886, -1130301425)
		+ W(10, -1123237039, 992349061, -1123740578, 1036415429)
		+ W(11, -1126796061, -1128488725, 989067449, -1164474953);
	sum2 =
		W(0, -1164068108, 1029420636, -1112077059, -1110964317) + W(1, 1028276360, -1148255859, -1120898035, 1036981221)
		+ W(2, -1106651210, -1141413971, 1028557670, -1129246253)
		+ W(3, 1013829433, 1035658823, -1106432341, 1035230257) + W(4, 1017251513, -1131530425, 972583599, 1039879187)
		+ W(5, -1108370344, 1044568046, 1026800348, -1126980980) + W(6, 1016837545, -1102894380, 1027609202, 1041920264)
		+ W(7, -1124056839, -1121785123, -1128855117, -1128781606)
		+ W(8, 1035930993, -1110600858, 1023713154, -1124361549)
		+ W(9, -1120505887, 1013125305, 1026372950, -1125837008)
		+ W(10, -1132458450, 1009116645, -1130000643, 1008550341)
		+ W(11, 1017927697, 1019426133, -1129712212, -1127748642);
	WS(1064075168, -1085260633);
	sum1 =
		W(0, 1020097830, -1104011171, 1041894009, 1034297780) + W(1, -1113914242, -1138151419, 1004279127, -1113516590)
		+ W(2, 1036855277, -1106861493, 1031661466, -1151789197)
		+ W(3, 1028112237, -1103036207, 1045116105, -1112331770)
		+ W(4, 1017072798, -1129921062, 1026532451, -1102348791) + W(5, 1027716980, 1058153819, -1100287056, 1026370483)
		+ W(6, 961537748, -1120389361, -1096376936, 1043898973) + W(7, -1119328440, 1025128111, -1130706656, 1038928889)
		+ W(8, -1096709211, 1048347472, 1032287909, -1140511211)
		+ W(9, -1135275149, -1129088474, 996846509, -1164071066) + W(10, 1019059671, -1167790389, 994604265, 1031068695)
		+ W(11, -1102472071, -1118081687, 1040008649, -1140610427);
	sum2 =
		W(0, 1014633478, 1033869831, -1114935893, -1111281510) + W(1, 1016908923, 990649086, -1138053524, -1133342724)
		+ W(2, -1126366588, -1128243618, -1145483991, 996067150)
		+ W(3, -1140130516, 1003291347, 1043822142, -1107071420) + W(4, 1006526455, 1012165262, -1120104172, 1033872317)
		+ W(5, -1086850225, -1084734921, 1045857736, -1119271334) + W(6, 1012698026, 1006625651, 1030145358, 1067004758)
		+ W(7, 1020093203, -1129772456, -1123853902, -1121932314)
		+ W(8, 1040015383, 1046081705, -1118176982, -1144422823) + W(9, 1013120742, 1004319943, -1150276254, 1002809783)
		+ W(10, -1161820989, -1141799647, -1133638700, 975983930)
		+ W(11, 1028724356, 1031930717, -1104669476, -1143148999);
	WS(-1102756414, -1120030182);
	sum1 = W(0, -1114857721, -1102767115, 1043961809, -1124210446)
		 + W(1, -1117667780, -1120413918, 1007304745, -1115971707)
		 + W(2, -1101676399, 1028311347, -1113057893, -1125847632)
		 + W(3, -1113282502, -1095987354, 1053600405, 1046261656)
		 + W(4, -1103902228, -1114932345, -1135708169, -1101194087)
		 + W(5, 1065521342, 1068133511, -1095174540, 1027169042)
		 + W(6, -1130226572, -1099422340, 1046696200, 1042816511)
		 + W(7, -1101926052, -1125196828, -1115825727, -1109693396)
		 + W(8, 997946179, -1098872988, 1020822452, -1114420141)
		 + W(9, -1142173365, -1122657804, -1112668237, -1133742993)
		 + W(10, -1113901869, -1121096548, -1136250680, -1100198174)
		 + W(11, 1025742970, -1113205915, -1140085511, -1110338975);
	sum2 =
		W(0, 1022430051, -1119384349, -1127804673, 1011315171) + W(1, -1121146859, 1009328259, -1126993785, -1117046041)
		+ W(2, 1014745875, -1106680506, 1009189211, -1125156477)
		+ W(3, 1027244407, -1113440146, -1129639049, 1020590601)
		+ W(4, -1115604020, 1000906166, -1136699515, -1099757367)
		+ W(5, 1065124465, 1034863647, -1111752578, 1017063165) + W(6, -1115987625, 1038214736, -1113943514, 1035633573)
		+ W(7, -1124061319, -1117062841, 1024283610, -1152620459)
		+ W(8, -1130768777, -1116743921, -1120130033, 1024425511)
		+ W(9, -1120680273, 1013074835, -1113854522, -1127682237)
		+ W(10, -1148961286, -1119191933, -1137060371, 1015902709)
		+ W(11, -1112590762, 1012706011, -1113078716, 1024105421);
	WS(-1077988040, -1098609713);
	sum1 = W(0, 1020152245, 1040202093, -1114910389, -1104283732)
		 + W(1, 1039298438, -1125387021, 1002836371, 1027276515) + W(2, 1037438449, -1105856183, 1028081393, 1013826369)
		 + W(3, -1132015209, 1049452385, -1100627367, -1098108347)
		 + W(4, 1024125142, 1018674229, 1010566313, 1032875267) + W(5, 1030654167, -1102427678, -1131705423, 1017725301)
		 + W(6, 1010053945, 1036663212, -1113362709, -1104090280)
		 + W(7, 1042947115, -1141124531, 1020486319, 1034908465) + W(8, -1095852652, 1048934265, 1019783717, 1015682181)
		 + W(9, 1030571159, -1114877050, 1025947458, -1126406169)
		 + W(10, 1021770278, 1006527587, -1132252076, 1038229775)
		 + W(11, -1105166249, -1138504825, 1035155325, 1016700365);
	sum2 = W(0, -1142267837, -1132626695, 1023852808, 1039691642)
		 + W(1, -1114839167, -1147709133, -1139598567, -1138132903)
		 + W(2, 1033876712, -1110747637, -1127924867, -1155304986)
		 + W(3, 967895252, -1131100139, 1012220303, 1061640184) + W(4, -1122160974, -1121532798, 1008554815, 1032537913)
		 + W(5, -1095058264, 1037101696, 1049832068, 992067354)
		 + W(6, -1145406733, -1112410791, -1110252153, -1091888991)
		 + W(7, 1027903240, -1128735955, 1024473654, 1023361695)
		 + W(8, -1104029741, -1161200181, -1126050715, 1025251228)
		 + W(9, -1120792990, -1130141475, 1031843465, -1119701362)
		 + W(10, -1132864167, -1157362170, 1020245499, 1015868043)
		 + W(11, -1196949327, 977066218, -1118663498, 1009680879);
	WS(1050097375, -1144620389);
	sum1 = W(0, -1128715377, 1044211901, -1107032850, -1104047251)
		 + W(1, 1044522647, -1128884681, 1011057731, 1033637193) + W(2, 1022227585, 1028225817, 1008625791, 1011579579)
		 + W(3, -1134438475, 1048874276, -1096643663, -1092741994)
		 + W(4, 1044273989, 1018667761, 1019193873, 1034983634) + W(5, -1114392598, 1036584266, -1113959235, 1025301657)
		 + W(6, 1022275225, 1042543166, -1092702793, 1025153498) + W(7, 1042105869, 1024565397, 1009602711, 1017343103)
		 + W(8, -1097617495, 1028276325, 1041046056, -1123355105)
		 + W(9, 1032927683, -1149239594, -1139445891, -1142331733)
		 + W(10, 1025445761, 1027058603, -1136253330, 1037918654)
		 + W(11, -1097624368, -1118553533, 1045159742, 1015982985);
	sum2 =
		W(0, -1125113091, 1033296420, 1004274749, -1102915066) + W(1, 1028147108, 1017918867, -1172679141, -1128383915)
		+ W(2, 1016688407, 1037338868, -1144981581, 991135609) + W(3, -1152889753, 1019343075, -1103752812, -1089888071)
		+ W(4, 1030353331, 1022111055, -1126905475, 1031861037)
		+ W(5, -1097163724, -1090194983, -1121675098, -1117974458)
		+ W(6, 1006649294, 1038268779, 1062746712, 1041005261) + W(7, 1019962267, 1026630548, -1117488938, -1113645001)
		+ W(8, 1051715314, -1118523722, 1006661278, -1115156997) + W(9, 1019337735, 1028739248, -1124587947, 1027501384)
		+ W(10, 1023891692, 1018829507, -1172252645, -1120621430)
		+ W(11, 1035778038, -1154227385, 1013440998, -1136345798);
	WS(-1098112447, -1125216946);
	sum1 =
		W(0, 1010417568, -1112042689, 1004161984, 1041397655) + W(1, -1114418485, 1021110568, 1006322176, -1119953952)
		+ W(2, -1112614584, 1018267345, 1024614191, -1137912440)
		+ W(3, -1140685064, -1116450322, -1090400895, 1058507679)
		+ W(4, -1104618697, -1127130192, 1017991280, -1112784281)
		+ W(5, -1113885864, 1050855349, 1027345269, 1019594896)
		+ W(6, -1126853432, -1105219289, 1051228911, -1097135921)
		+ W(7, 1037685358, -1116355204, -1146614696, 1023451023) + W(8, -1126136276, -1122997076, 1039454784, 987030015)
		+ W(9, 1004323364, -1153582112, 1016683168, -1149231824)
		+ W(10, -1140802306, 988441407, 1019294567, -1110071894)
		+ W(11, 983864831, 1012208560, 1030420791, -1149650752);
	sum2 =
		W(0, 1035141604, -1152950404, -1100547860, -1104792229) + W(1, 1037875812, -1138078871, -1134943159, 1010887850)
		+ W(2, 1025641276, -1119115361, 1021611837, 1016878804)
		+ W(3, 1031353634, -1122370025, -1101375945, -1100366049)
		+ W(4, 1015511489, 1015482099, -1120750640, -1101926585)
		+ W(5, 1057546844, 1042205116, -1109199537, -1140091328) + W(6, 1025254666, -1104605825, 1048526282, 1042952063)
		+ W(7, -1105787312, 1032201266, -1114509439, 1035852377)
		+ W(8, -1108641700, 1039483674, -1109299079, -1132053601)
		+ W(9, 1028756554, -1114959163, 1033576762, 1030776026)
		+ W(10, -1143994351, 1007578680, -1113538005, -1148680422)
		+ W(11, 1037895648, 1041006229, -1107406256, -1124574444);
	WS(1027823864, 1049081066);
	sum1 = W(0, 1012131718, 1045092167, -1108779609, 1031292119)
		 + W(1, -1168425160, -1123848398, -1130128499, 1032126573)
		 + W(2, -1127539283, 1050389010, -1113259988, 1017365039) + W(3, 1020918007, 1043895467, -1101697729, 998802811)
		 + W(4, 1036534559, 1015583683, -1147020173, 1034108246)
		 + W(5, -1094495268, -1089568357, 1026355631, -1120941186)
		 + W(6, 1027080278, 1035993776, 1047905888, -1096020979) + W(7, 1044370080, 1024649726, 1020448605, -1104998342)
		 + W(8, 1057437086, -1097851474, -1112197645, -1123264842)
		 + W(9, 1012408472, -1129990263, 1041161122, -1105719893)
		 + W(10, 1035394325, 1027345300, 1024273997, -1123698278)
		 + W(11, 1052750589, -1101687913, -1103284196, 966350543);
	sum2 =
		W(0, 1023788251, -1115639872, 1042970848, 1041100183) + W(1, -1120506242, -1214633659, 982227227, -1150596845)
		+ W(2, 1046665761, 1053945290, -1121383639, -1143798279) + W(3, 1006064903, 1015277390, 1037025188, -1128807740)
		+ W(4, 1017634434, 1023282498, -1119196045, 1006169559) + W(5, -1080187678, -1078236510, 998104205, -1114831851)
		+ W(6, 1022374646, 1034991246, 1047303977, 1053440142) + W(7, 1037533712, 1023435593, -1139981943, -1110295858)
		+ W(8, 1052132899, 1058969577, -1112892146, -1124500500) + W(9, 1006364327, -1148612007, 1033799186, 1029728171)
		+ W(10, 1033828190, 1015376522, -1130167410, -1131776900)
		+ W(11, 1035867784, 1005561207, -1110685126, 1014287051);
	WS(-1088189216, 1043089281);
	sum1 =
		W(0, -1140748743, 1049770738, -1088213532, 1042644994) + W(1, 1041481493, 1008330103, -1121398410, 1041680407)
		+ W(2, -1096476823, 1047024381, -1107153702, 1031833588) + W(3, 1026065228, 1048806759, -1084369379, 1050638745)
		+ W(4, 1035104215, 1020682979, -1149048846, 1043836791) + W(5, -1108723571, -1101872740, 1041455384, 1026205458)
		+ W(6, 1020127051, 1034371336, 1036745881, -1094226627) + W(7, 1040593116, 1006701623, 1036138263, 1024770968)
		+ W(8, 1041309981, -1096464492, 1045395982, -1120876186)
		+ W(9, -1128555260, 1037337862, 1011670631, -1106071481)
		+ W(10, 1040128941, 1024336228, 1038047047, -1137213911)
		+ W(11, 1028379642, -1102959693, 1016152290, 1028740542);
	sum2 =
		W(0, -1129618765, 1028575755, 1018469269, -1109549862) + W(1, 1022763469, -1123897489, 1004169862, -1114659435)
		+ W(2, 1020493837, 1025826707, -1116607191, -1153284395)
		+ W(3, -1163586391, 1025093243, -1120959857, 1018231561)
		+ W(4, 1017295613, -1131222849, 1012667011, -1110197183) + W(5, 1045602812, 1050121196, -1110473213, 1019030581)
		+ W(6, 1004789414, -1140439179, -1119013866, 1009644755)
		+ W(7, -1143499366, -1125130849, 1006867267, -1110600679)
		+ W(8, 1007539419, 1038682513, -1107944702, 1009132883) + W(9, -1148564598, 1019765437, -1126956769, 1017107081)
		+ W(10, -1123266847, 1006886939, 1023888443, -1106146141)
		+ W(11, 1005311510, 1040899502, -1114206671, -1127991173);
	WS(-1082596160, 1043517696);
	sum1 =
		W(0, 1028909798, -1154689545, -1104169149, 1025985531) + W(1, 1029418231, 1024711058, -1153492953, 1032486047)
		+ W(2, -1117361518, -1118729126, 1034798166, -1125485751) + W(3, 967933898, -1128767583, 1049441299, 1031994846)
		+ W(4, 1006099469, 1008177302, 1019116907, 1037703496) + W(5, -1087176649, -1089391227, 1046438773, 986175666)
		+ W(6, -1132218099, -1115978788, -1115448907, 1056185125)
		+ W(7, -1106352341, -1125946755, -1129844133, 1027446332) + W(8, 1018413135, 1032249225, 991686873, 1030151438)
		+ W(9, 1011144392, -1146849277, -1154137305, 1036574828)
		+ W(10, -1131200252, 1006963806, 999709323, -1114471573)
		+ W(11, -1130624603, 1042483386, 1022706506, 1019997155);
	sum2 = W(0, 987806561, -1103978637, 1039699877, 1032745921) + W(1, -1106709297, 1017765222, 1024001581, -1138508200)
		 + W(2, -1109586411, 1036006171, 984628641, -1151113585)
		 + W(3, -1132313544, -1113576691, -1109697688, 1041044376)
		 + W(4, -1135869680, -1128136972, -1138298076, 1037869389)
		 + W(5, 1004783368, 1057490671, -1123523352, -1126668402)
		 + W(6, 1003342504, 1041829747, -1101655248, -1120283284)
		 + W(7, 1037905909, -1142518888, -1131321664, -1102361734)
		 + W(8, 1023850463, -1118937466, -1133053924, -1119975873)
		 + W(9, 1015369606, 995389041, -1123567230, -1137071480)
		 + W(10, 1008345900, 1015435786, 1016585830, -1103350916)
		 + W(11, 1033013495, 1023653113, -1123775069, -1153724113);
	WS(1066487464, -1081148228);
	sum1 =
		W(0, -1156758047, 1045622655, -1121579186, 1016497454) + W(1, 1026804003, 1025331662, -1115667101, 1039828621)
		+ W(2, 1016276052, 1034243041, -1129971954, 1022570928) + W(3, 1032245054, 1043227835, -1107379682, -1125065087)
		+ W(4, 1036683903, 1033790001, -1120457266, 1051174634) + W(5, -1081882686, -1081200961, 1050524446, 950141917)
		+ W(6, 1025970038, 1038187760, -1114502289, -1121918554) + W(7, 1033938044, 1035886143, 1028999903, 1035936180)
		+ W(8, -1110627634, -1121754318, 1045144826, -1123227402)
		+ W(9, -1129094085, 1028125692, 1032926021, -1138807120) + W(10, 1028558202, 1023360168, 1031685286, 1038703027)
		+ W(11, -1130240468, -1128847308, 1036935449, 1033245399);
	sum2 = W(0, 990406129, 1013162021, -1111903383, 1031481662) + W(1, -1112035485, 1026146121, -1109318105, 1040565489)
		 + W(2, -1098989385, 1036428343, -1111376696, 1020848344)
		 + W(3, 1032976305, -1125670617, -1114873385, 1043786440) + W(4, 1007686716, 993596601, -1108583903, 1041812300)
		 + W(5, 1042303391, 1039454897, 1044627344, -1114987237) + W(6, 1009651516, -1123723867, 1001920896, 1032603577)
		 + W(7, -1107723593, 1030752081, 1027268958, 1031967357)
		 + W(8, -1113158574, -1097549253, 1043104932, -1112152994)
		 + W(9, -1109295843, 1033460548, 1015358203, -1117993943)
		 + W(10, -1142055788, -1128311189, 1034160517, -1113698315)
		 + W(11, 1032025507, -1119346601, -1111706149, 1024170945);
	WS(-1085700080, -1080808385);
	sum1 =
		W(0, 1024296914, -1130852634, -1113008209, 1037784580) + W(1, -1128041639, 1011155704, -1122227946, 1020782261)
		+ W(2, 1011762792, -1106441949, 1023563097, 1007950112) + W(3, -1137292464, 1018157624, -1132968658, 1034492712)
		+ W(4, 1002605936, -1130475172, 1023737634, 1000516328) + W(5, -1126768286, -1096045179, 1048917408, 1027876850)
		+ W(6, -1114666035, 1007198528, -1104353680, 1044579508)
		+ W(7, -1126595297, -1148910448, 1017074878, 1034334952)
		+ W(8, -1108931914, 1035021791, -1127030516, 1030237498)
		+ W(9, -1116342907, 1028012332, -1128335092, 1016641544)
		+ W(10, -1124799637, -1178616327, 998628462, 1030076118)
		+ W(11, -1106440695, 1037317931, -1122557970, 1026212766);
	sum2 =
		W(0, -1127545645, 1009004191, 1015771798, -1131692274) + W(1, 1014637794, 996126556, 1018138398, -1136885460)
		+ W(2, -1151865619, -1125888003, 1023581282, 1018938725)
		+ W(3, -1144042592, -1141392422, -1107745249, -1091675886)
		+ W(4, 1057331451, -1136255574, 999025130, 1032831862) + W(5, -1097510643, -1072938398, 1076041086, -1112160457)
		+ W(6, -1139402988, 1017820345, -1117369881, -1091916978)
		+ W(7, 1056314077, -1150817344, -1150259805, -1138954980)
		+ W(8, 1017078443, -1117354278, 1032772879, -1138128772) + W(9, 985356315, 1013413304, -1132039248, -1124163047)
		+ W(10, 1020965023, 1018397555, -1133933532, -1164078621)
		+ W(11, -1132951491, -1138824868, 1026258229, 985080995);
	WS(1065410184, 989310727);
	sum1 = W(0, -1129262375, -1109321255, 1036945010, 1026154888)
		 + W(1, -1134197844, -1125355007, -1140125102, -1114916286)
		 + W(2, 1039766830, -1115626794, -1121887434, 1012320294)
		 + W(3, -1116437485, -1113105487, 1017194412, 1060001058)
		 + W(4, -1094555822, -1137406030, -1133156750, -1103994248)
		 + W(5, 1046741097, 1017259310, -1114897776, -1133486286)
		 + W(6, 1013595422, -1113291025, 1059311888, -1103200016)
		 + W(7, 1023750749, -1124720479, -1140436482, -1135877737)
		 + W(8, -1110004779, 1018378495, -1113774366, -1115411390)
		 + W(9, 1001232640, 1027066925, -1131666807, -1131905035)
		 + W(10, -1124072268, 1004266540, -1120957855, 1020121135)
		 + W(11, -1115618446, -1127100975, -1116648163, -1123146591);
	sum2 = W(0, -1134742142, 1015903261, 1020154303, -1137672551) + W(1, 1024853570, 1005131169, 994239369, 1014594226)
		 + W(2, -1150882457, 1023023759, 1017377705, -1125421078)
		 + W(3, -1134258278, -1129761964, 1022217883, 1027518631)
		 + W(4, -1148789809, 1001175413, -1126643555, 1031995313)
		 + W(5, 1040302074, -1097618001, 1026258033, -1138047636)
		 + W(6, -1124787402, 1009465920, 1049285742, -1098762324)
		 + W(7, -1132512970, -1148246653, 1015413679, 1021296491)
		 + W(8, 1029784509, -1122992412, 1015729459, 1016986651)
		 + W(9, 991423945, -1131866907, -1135790753, -1126884057)
		 + W(10, -1130065044, -1142203369, 1010959842, 1022764367)
		 + W(11, -1122024941, -1118740892, 980872325, 992745521);
	WS(1051937311, 1019742014);
	sum1 = W(0, -1128733562, -1110586220, 1044317379, 1034449865)
		 + W(1, -1129053661, -1126315858, 997229903, 1007594774)
		 + W(2, -1115449474, 1040493967, -1122019556, -1118602611)
		 + W(3, 1023734487, -1114376035, 1058430122, -1106892452)
		 + W(4, -1137597924, 1007433460, -1116159949, -1126695312)
		 + W(5, -1131615423, -1096043495, -1114653189, -1115826781)
		 + W(6, -1132293538, 1032525373, 1028795565, 1048571437)
		 + W(7, -1104742917, 1027349977, -1139661928, -1154941499)
		 + W(8, 1043036192, -1110832404, -1106286569, 1018237258)
		 + W(9, -1123545457, 1019369518, -1111719346, 1031893623)
		 + W(10, -1118024837, -1123671919, 1016780849, 1026460481)
		 + W(11, -1122201669, 1016066306, -1121789868, 1018711058);
	sum2 = W(0, 1008400273, -1127535498, -1110432262, -1120718262)
		 + W(1, -1113670226, 1025653041, 1016157529, -1127740478)
		 + W(2, -1101104373, -1108362087, -1146032407, -1134925453)
		 + W(3, -1144490357, 1041994790, -1088501039, 1042410198)
		 + W(4, -1132649478, 1011207517, -1138058389, 1049438349)
		 + W(5, 1056816205, -1105949033, 1045816390, -1153231998)
		 + W(6, -1125392389, -1105215135, 1056199589, -1108549667)
		 + W(7, -1122823248, -1127906971, -1130565626, -1113276412)
		 + W(8, 1025802623, 1029274599, -1139374331, 1000306913) + W(9, 965128306, -1135958083, 1003347845, -1152613734)
		 + W(10, -1123972337, -1157554354, -1135290574, -1114929610)
		 + W(11, 1003318865, 1031964529, 1019133207, -1130500213);
	WS(-1117640696, 1034706864);

	return clamp(mstd0 + 5.0 * vsum / wsum * mstd1, 0.0, 1.0);
}

shared float inp[507];

#define CURRENT_PASS 1

#define GET_SAMPLE(x) dot(x.rgb, rgb2y)
#define imageStore(out_image, pos, val) imageStoreOverride(pos, val.x)
void imageStoreOverride(uint2 pos, float value) { temp[pos] = (value); }

#define INPUT_tex(pos) GET_SAMPLE(vec4(texture(INPUT, pos)))
static const float2 INPUT_size = float2(GetInputSize());
static const float2 INPUT_pt = float2(GetInputPt());

#define HOOKED_tex(pos) INPUT_tex(pos)
#define HOOKED_size INPUT_size
#define HOOKED_pt INPUT_pt

void Pass1(uint2 blockStart, uint3 threadId) {
	ivec2 group_base = ivec2(gl_WorkGroupID) * ivec2(gl_WorkGroupSize);
	int local_pos = int(gl_LocalInvocationID.x) * 13 + int(gl_LocalInvocationID.y);
	for (int id = int(gl_LocalInvocationIndex); id < 507; id += int(gl_WorkGroupSize.x * gl_WorkGroupSize.y)) {
		uint x = (uint)id / 13, y = (uint)id % 13;
		inp[id] =
			HOOKED_tex(HOOKED_pt * vec2(float(group_base.x + x - (3)) + 0.5, float(group_base.y + y - (2)) + 0.5)).x;
	}
	barrier();
	vec4 ret = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 ret0 = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 samples[12];
	samples[0][0] = inp[local_pos + 0];
	samples[0][1] = inp[local_pos + 1];
	samples[0][2] = inp[local_pos + 2];
	samples[0][3] = inp[local_pos + 3];
	samples[1][0] = inp[local_pos + 4];
	samples[1][1] = inp[local_pos + 5];
	samples[1][2] = inp[local_pos + 13];
	samples[1][3] = inp[local_pos + 14];
	samples[2][0] = inp[local_pos + 15];
	samples[2][1] = inp[local_pos + 16];
	samples[2][2] = inp[local_pos + 17];
	samples[2][3] = inp[local_pos + 18];
	samples[3][0] = inp[local_pos + 26];
	samples[3][1] = inp[local_pos + 27];
	samples[3][2] = inp[local_pos + 28];
	samples[3][3] = inp[local_pos + 29];
	samples[4][0] = inp[local_pos + 30];
	samples[4][1] = inp[local_pos + 31];
	samples[4][2] = inp[local_pos + 39];
	samples[4][3] = inp[local_pos + 40];
	samples[5][0] = inp[local_pos + 41];
	samples[5][1] = inp[local_pos + 42];
	samples[5][2] = inp[local_pos + 43];
	samples[5][3] = inp[local_pos + 44];
	samples[6][0] = inp[local_pos + 52];
	samples[6][1] = inp[local_pos + 53];
	samples[6][2] = inp[local_pos + 54];
	samples[6][3] = inp[local_pos + 55];
	samples[7][0] = inp[local_pos + 56];
	samples[7][1] = inp[local_pos + 57];
	samples[7][2] = inp[local_pos + 65];
	samples[7][3] = inp[local_pos + 66];
	samples[8][0] = inp[local_pos + 67];
	samples[8][1] = inp[local_pos + 68];
	samples[8][2] = inp[local_pos + 69];
	samples[8][3] = inp[local_pos + 70];
	samples[9][0] = inp[local_pos + 78];
	samples[9][1] = inp[local_pos + 79];
	samples[9][2] = inp[local_pos + 80];
	samples[9][3] = inp[local_pos + 81];
	samples[10][0] = inp[local_pos + 82];
	samples[10][1] = inp[local_pos + 83];
	samples[10][2] = inp[local_pos + 91];
	samples[10][3] = inp[local_pos + 92];
	samples[11][0] = inp[local_pos + 93];
	samples[11][1] = inp[local_pos + 94];
	samples[11][2] = inp[local_pos + 95];
	samples[11][3] = inp[local_pos + 96];
	ret[0] = nnedi3(samples);
	ret0[0] = inp[local_pos + 41];
#if CURRENT_PASS == LAST_PASS
	uint2 destPos = blockStart + threadId.xy * ivec2(1, 2);
	uint2 outputSize = GetOutputSize();
	if (destPos.x >= outputSize.x || destPos.y >= outputSize.y) {
		return;
	}
#endif
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(1, 2), ret0);
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(1, 2) + ivec2(0, 1), ret);
}
//!PASS 2
//!DESC NNEDI3 (double_x, nns32, win8x6)
//!IN INPUT, temp
//!OUT OUTPUT
//!BLOCK_SIZE 64, 8
//!NUM_THREADS 32, 8
#pragma optionNV(inline none)
float nnedi3(vec4 samples[12]) {
	float sum = 0.0, sumsq = 0.0;
	[unroll] for (int i = 0; i < 12; i++) {
		sum += dot(samples[i], vec4(1.0, 1.0, 1.0, 1.0));
		sumsq += dot(samples[i], samples[i]);
	}
	float mstd0 = sum / 48.0;
	float mstd1 = sumsq / 48.0 - mstd0 * mstd0;
	float mstd2 = mix(0.0, inversesqrt(mstd1), mstd1 >= 1.192092896e-7);
	mstd1 *= mstd2;
	float vsum = 0.0, wsum = 0.0, sum1, sum2;
#define T(x) intBitsToFloat(x)
#define W(i, w0, w1, w2, w3) dot(samples[i], vec4(T(w0), T(w1), T(w2), T(w3)))
#define WS(w0, w1)                                                                                                     \
	sum1 = exp(sum1 * mstd2 + T(w0));                                                                                  \
	sum2 = sum2 * mstd2 + T(w1);                                                                                       \
	wsum += sum1;                                                                                                      \
	vsum += sum1 * (sum2 / (1.0 + abs(sum2)));
	sum1 = W(0, -1120567290, -1132374181, -1132591953, -1125130389)
		 + W(1, -1117911182, -1119806663, -1121091407, -1126690796)
		 + W(2, 994153301, 1016607238, -1122316900, -1146864427) + W(3, 1031756856, 1024055745, 1003125923, 1029429758)
		 + W(4, -1139074345, 992947237, 1053527378, 1046512564)
		 + W(5, -1093298645, -1112059294, -1120338466, -1110173889)
		 + W(6, 1021572063, -1137843051, -1096186409, 1056444330)
		 + W(7, 1051252577, -1109040755, -1148456803, -1113641375)
		 + W(8, -1117468940, -1125619459, -1144213939, -1138699933)
		 + W(9, 1023905988, 1033651817, -1133630411, 1032546877)
		 + W(10, -1119615974, 1000210819, -1121684346, -1129869365)
		 + W(11, 979248533, -1119537890, -1141776739, -1127458445);
	sum2 = W(0, -1126549409, -1119263575, 1019494412, -1124834267)
		 + W(1, 1007192676, -1122284082, -1127647730, 1010488320)
		 + W(2, 1022573468, -1114028928, -1116443736, -1099458226)
		 + W(3, 1017309436, -1118444706, -1121042004, -1109973330)
		 + W(4, -1140490164, -1119708173, 1032492771, 1055169273)
		 + W(5, 1044169825, 1039787167, -1145097543, 1044065299) + W(6, -1114833146, 1024108770, 1037187519, 1055452063)
		 + W(7, -1106256028, -1112035826, -1125070906, -1121131548)
		 + W(8, 1021805248, -1146392599, 1026983682, -1095922228)
		 + W(9, -1122158651, -1118290710, -1129575364, -1121253833)
		 + W(10, 1003196031, -1113990054, 1006796332, -1126677517)
		 + W(11, 1022777176, -1130573089, -1123455912, 1019346120);
	WS(1060265584, 1063714812);
	sum1 = W(0, 1021450242, -1123065753, -1137050988, 1021294882)
		 + W(1, -1118036885, 1009531192, -1118665549, 992320459)
		 + W(2, -1128788280, 1022311347, 1028928107, -1140362288) + W(3, 1024570351, 1035626828, 1025121435, 1029327365)
		 + W(4, -1111111528, 999728711, -1119265827, -1137639751)
		 + W(5, -1101623708, -1106406289, -1128138578, -1106167682)
		 + W(6, 1039397963, -1108349889, 1026074151, -1102959280) + W(7, 1041760911, 1036057270, 1017790822, 1037788386)
		 + W(8, -1131322533, 1022720848, 1019796282, 1043907075)
		 + W(9, -1151514983, -1132552740, -1124857459, -1134343810)
		 + W(10, 1011253684, 974355898, -1136338948, 1025863841)
		 + W(11, -1136816500, 1027651305, -1139070668, 1024478285);
	sum2 = W(0, 1023758242, -1124053764, 1000956747, -1122894214) + W(1, 999883691, 1004424067, -1150041590, 1009546537)
		 + W(2, -1130878336, 1017938673, 1028583936, 1031015106) + W(3, 994031846, 999096115, -1134395125, 1005722235)
		 + W(4, -1120671625, -1145138723, 1005174931, -1104963408)
		 + W(5, 1001047899, -1126082311, 1002728051, -1135618057) + W(6, 1027498838, 1027873020, 1053869854, 1073183850)
		 + W(7, 1053107786, 1035733703, 1022225293, 1023923178)
		 + W(8, -1144315403, -1122179044, -1093535895, -1074622268)
		 + W(9, -1094361386, -1114468554, -1123867271, -1126165581)
		 + W(10, -1131041230, -1127336921, 1009416925, 1033668418)
		 + W(11, 990806038, 992895974, -1131337021, -1138321549);
	WS(1067199072, 981674447);
	sum1 = W(0, -1113726457, 1018794771, -1115871564, 1008735750)
		 + W(1, -1125817867, -1125149117, 1001830321, 1016463803)
		 + W(2, -1105288827, -1113372949, -1095136821, -1102105679)
		 + W(3, -1103744656, -1108798620, -1137689902, -1099284685)
		 + W(4, 1040785760, -1099180638, 1050678235, 1052734745) + W(5, 1044281884, 1033282170, -1121192922, 1032013917)
		 + W(6, 1032552483, 1040483381, 1054762461, 1065065389) + W(7, 1044820043, -1097094388, 1010644366, -1124668651)
		 + W(8, -1124907206, -1114167068, -1107257499, -1097429016)
		 + W(9, -1104994292, 1027211226, -1114303237, 1015961570)
		 + W(10, -1139898486, -1127069135, -1118671794, 1035770473)
		 + W(11, -1122788302, -1125646899, -1123221796, -1114483455);
	sum2 = W(0, -1124538541, -1139313841, -1119374292, 1010830983)
		 + W(1, 1020827626, -1125616841, 1008596323, -1136528497) + W(2, 1021627528, 989560618, 1014774531, 1026431506)
		 + W(3, -1118520012, 1018739126, 1014458179, -1129452021)
		 + W(4, -1127440395, 1028695072, -1102978428, -1087762234)
		 + W(5, 1027251929, -1109480314, 1023848922, -1132845253) + W(6, 1027300307, 1011050585, 1052523334, 1053318756)
		 + W(7, -1113197028, 1034265115, -1134832277, 1022117249) + W(8, 1020622605, 999023778, -1119874204, 1038687085)
		 + W(9, 1029469191, -1125820221, -1159659466, -1150305989)
		 + W(10, -1130074937, 1015498074, -1126569197, -1128231773)
		 + W(11, 1018969905, -1123965604, 1024095771, -1130502215);
	WS(-1082327904, -1101742629);
	sum1 = W(0, -1128942355, 1007179909, -1172666584, -1115398989)
		 + W(1, -1145393643, -1126910957, -1153678686, -1127439210)
		 + W(2, 994965062, -1124051394, 1029361427, 1047686461) + W(3, 1028067431, 1025118144, -1121058723, 1018201755)
		 + W(4, -1116531225, 1022855203, 1044526075, -1095192109)
		 + W(5, -1123739865, -1116394763, -1123838961, -1120454737)
		 + W(6, 1027052286, -1119991818, -1110346311, -1106285700)
		 + W(7, 1043850022, 1030498357, 1032721886, 1034890279) + W(8, -1127603958, 1015495233, 1026992677, 1037065627)
		 + W(9, -1119388383, 1013662917, -1119902562, 1021249778)
		 + W(10, 1021969515, -1129777663, 1017142675, -1113404469)
		 + W(11, -1130059467, 1016457699, -1131255799, 1017348651);
	sum2 = W(0, 1014279427, -1131491186, 1026571161, 1042930837) + W(1, 1025279833, 993445038, -1133457551, 1014707171)
		 + W(2, -1130890464, -1137235679, -1097554196, -1073378768)
		 + W(3, -1092458255, -1130245298, -1120075373, -1135266971)
		 + W(4, -1129394348, 1024729347, 1048952496, 1073588633) + W(5, 1053816664, 1029166823, 1030737081, -1151431678)
		 + W(6, 1014973315, -1130557096, 1014221291, -1105375875)
		 + W(7, 1016092170, -1119905200, -1147013927, -1161525308)
		 + W(8, -1152876382, -1150339726, 1016692910, 1035354953)
		 + W(9, -1129170378, 1027382919, -1124802440, 979085751)
		 + W(10, 1004833335, -1141673719, -1159625756, -1124590261)
		 + W(11, 989537980, -1138326931, 1017200998, 1009604643);
	WS(1067891072, -1132872541);
	sum1 = W(0, 1025237873, 1014334757, 1030238795, 1029025473) + W(1, 1007260181, -1121222990, 988616634, -1123834925)
		 + W(2, -1122834636, 1020114356, -1105197551, -1121917372)
		 + W(3, 1038150728, 1024596920, 1024170379, 1015271403)
		 + W(4, -1117007553, -1118569017, 1049984500, -1114461425)
		 + W(5, -1084792932, 1039495098, -1124531763, 1027254009)
		 + W(6, -1114151507, 976917621, -1088419628, 1051488823) + W(7, 1053317187, 987986858, 1026119523, 993078101)
		 + W(8, 1031366707, 1039451348, 1049092386, 1008484089) + W(9, -1122288663, -1131993235, 1022258228, 999667975)
		 + W(10, 984935338, -1152616053, -1123762161, -1145922699)
		 + W(11, 1012164149, 1000937675, 1011615629, 1004174827);
	sum2 = W(0, -1144599930, -1136232721, -1137221455, -1128645029)
		 + W(1, -1151231836, -1156748756, -1160295481, 1020235585)
		 + W(2, -1116760996, 1019759527, -1111064134, 1041961890)
		 + W(3, 1036336113, 1033905549, 1022489781, -1122711401) + W(4, 1032730282, -1125055029, 1047170030, 1050767412)
		 + W(5, -1093680614, -1120368706, -1115425401, -1132924343)
		 + W(6, 1032901632, 1027655943, -1115058011, -1130649513)
		 + W(7, -1116185015, -1105887613, 1012694293, -1122854992)
		 + W(8, 985378521, 1005941018, -1129460922, 1019394239) + W(9, -1115704458, 1024734935, -1147415538, 1018590227)
		 + W(10, -1129170670, -1131155477, -1129924333, 1022276751)
		 + W(11, -1148456898, 1015791177, -1140100033, 1012472897);
	WS(1059709408, 1024973287);
	sum1 =
		W(0, -1126012593, 1004611460, -1134152138, -1114032340) + W(1, -1131432537, -1126017195, 991561039, -1124178504)
		+ W(2, 996494647, -1122880609, 1020165829, 1049657976) + W(3, 1014735450, 1032225804, -1115613273, 1022764985)
		+ W(4, -1119189544, 1030391200, 1046947367, -1094041084)
		+ W(5, 1018380112, -1112475533, -1123292160, -1122300512)
		+ W(6, 1028092109, -1114579692, -1111968183, -1106474499) + W(7, 1044458845, 1030371012, 1033263557, 1034006830)
		+ W(8, -1124577204, 1016065247, 1002304420, 1040268033) + W(9, -1114168306, 1023640576, -1119951545, 1017080432)
		+ W(10, 1023428420, -1127475101, 1021721777, -1114564220)
		+ W(11, -1128430825, 1019190017, -1127717781, 1017178441);
	sum2 = W(0, -1125800395, 1011909323, -1116511680, -1103527255)
		 + W(1, -1120293374, -1148349175, 1015270352, -1125483347)
		 + W(2, 1024962708, -1143341847, 1052819438, 1076690943) + W(3, 1057154431, 990717342, 1025045202, 1023577182)
		 + W(4, 1023886172, -1144213999, -1097320166, -1072687587)
		 + W(5, -1091630497, 1012280135, -1118805022, 1016249338)
		 + W(6, -1122338700, 1018807292, -1115186882, -1098249874)
		 + W(7, -1117298851, 1010582795, 990164302, -1125194137)
		 + W(8, -1171853367, 1000330119, -1140479659, 1023038428)
		 + W(9, 1029135274, -1122270538, 1020995472, 1003973863) + W(10, 973576887, 984068764, 1001426319, 1007326739)
		 + W(11, -1135413483, 1008233815, -1129534965, -1140102471);
	WS(1066253200, 1009489111);
	sum1 = W(0, -1121073890, 1024085178, -1130104696, 1023275236)
		 + W(1, -1128214764, -1135799996, -1141685621, -1121776782)
		 + W(2, -1102592607, -1107707469, -1106598971, -1116780301)
		 + W(3, -1111680448, 1032050668, -1131519352, 1028096678)
		 + W(4, 1041243549, 1026388586, -1121496677, 1049328440)
		 + W(5, 1018012708, -1096674093, -1122519370, -1101864235)
		 + W(6, 1033075644, -1107162241, 1050587318, 1057262167) + W(7, 1027096831, 1040843700, 1028580820, -1117086438)
		 + W(8, -1123366116, 1004872905, -1113976447, -1116780079)
		 + W(9, -1113850464, 1015552212, -1123000331, 1040749648)
		 + W(10, -1130535196, -1145989825, -1120961954, 1023066500)
		 + W(11, -1121521086, 1008378152, -1124335656, -1135644600);
	sum2 = W(0, 1013104936, -1117172679, -1127525498, -1135146700)
		 + W(1, -1122718205, 1027187072, -1119344027, -1128814570)
		 + W(2, -1106333857, -1121647283, 1031691189, 1030458550)
		 + W(3, -1111791784, 1009508096, -1127767754, 1037784205) + W(4, 1041445982, 1046293466, 1054977467, 1051999059)
		 + W(5, 1044523088, -1099681845, -1185033988, -1107269301)
		 + W(6, -1143812784, -1098323478, 1032669672, 1016608418)
		 + W(7, -1093831562, 1044831040, -1117227205, -1118967703)
		 + W(8, -1111423698, 1025469214, -1110723238, 1041509878)
		 + W(9, 1024902469, -1110045970, -1129401382, -1121987113)
		 + W(10, -1153458272, -1123006845, 1018478818, -1111394764)
		 + W(11, -1127833490, -1140396324, -1129041118, 1021194206);
	WS(1055988095, 1068562120);
	sum1 = W(0, 1025054956, -1130996743, 1024941510, 1026193148) + W(1, 1035977616, 1028839961, 1016648336, 1025665319)
		 + W(2, 1041692938, 1036197410, 1042434277, 1039706891) + W(3, 1036807045, 1029783554, 1019008523, 1026886128)
		 + W(4, 1040251631, 1032351834, -1100356972, -1093055992) + W(5, 1047058383, 1043491547, 1044781893, 1048991774)
		 + W(6, -1141880069, 1043619883, 1026325313, -1087193164)
		 + W(7, -1087410536, -1097265155, -1104034167, -1099060796)
		 + W(8, -1113980711, 1002392085, 1040781794, 1032223740) + W(9, 1047196369, 1027612260, 1036828166, -1113322870)
		 + W(10, 1011769695, 1020511427, -1124414423, -1163338101)
		 + W(11, 1015241743, -1129538215, 1018634427, -1180507092);
	sum2 = W(0, -1109623534, -1119308996, -1108667787, -1107757858)
		 + W(1, -1126585969, -1144042093, 1004201965, 1024608852)
		 + W(2, -1098330057, -1121926087, 1031129408, -1111457821)
		 + W(3, -1091241820, -1092220222, -1112242725, -1104308532)
		 + W(4, 1051762285, 1045894429, 1029096148, 1060518836) + W(5, 1065480819, -1120268316, 1035423856, -1105721536)
		 + W(6, -1105318233, -1111281216, -1116694436, -1103134861)
		 + W(7, 1017373783, 1034184394, -1129342463, -1134873838)
		 + W(8, -1120494292, 1002875661, 1042501069, -1104320409)
		 + W(9, 1041202422, -1131983911, 1023586732, 1017105251)
		 + W(10, 1036873688, -1152598618, -1117793653, 1023528108)
		 + W(11, -1117516356, -1123122827, -1131565835, 1015347387);
	WS(-1073915832, -1098883962);
	sum1 = W(0, 1030932360, -1131602112, -1125999684, 1018154928)
		 + W(1, -1122265980, -1122315861, 1018577993, -1120663220)
		 + W(2, 1024626915, 1032898976, -1122370130, 1011274315)
		 + W(3, -1113904235, 1029902191, -1115348785, -1111387910)
		 + W(4, -1098288699, -1117814224, 1056014501, -1106175819)
		 + W(5, -1097956311, -1115232133, -1126206816, 1017122848)
		 + W(6, -1130380922, -1103847418, -1096397881, -1105327485)
		 + W(7, 1059753579, 1040451325, 1039068637, 1042824131) + W(8, 1033018229, 1040490540, 1031863906, 1044317365)
		 + W(9, -1098424101, -1122968848, -1136273729, 1021433455)
		 + W(10, 1021355752, -1120290302, -1131922448, -1139369119)
		 + W(11, -1121102372, 1033247800, -1121007738, -1143567007);
	sum2 = W(0, -1118315643, -1126395193, 1014636591, -1138413531)
		 + W(1, 1013622247, -1129252552, -1122713894, -1131632742)
		 + W(2, 1046909717, 1025514844, 1026986728, -1112879553)
		 + W(3, -1122377333, -1114813410, -1144089687, -1140190295)
		 + W(4, -1100980148, -1112473945, 1040985677, 1027746798)
		 + W(5, 1051150943, 1057006779, -1138866101, 1035155819)
		 + W(6, -1129801877, 1030594060, -1101816290, -1094641835)
		 + W(7, 1041324898, -1106485598, -1115757412, 1016695560)
		 + W(8, -1122172234, -1111527676, 1023795758, 1027030278)
		 + W(9, -1113671456, -1133454616, 1001347783, -1139893847)
		 + W(10, 1010610423, -1135186433, 1030475382, -1121095046)
		 + W(11, 1015864126, 999966259, -1127643580, -1124292419);
	WS(1058139200, 1067005003);
	sum1 = W(0, -1131277347, -1128484819, 1014594990, -1112913457)
		 + W(1, 1028891109, -1118434446, -1125459884, -1151139539)
		 + W(2, -1103206155, -1112832909, -1108301118, -1111811582)
		 + W(3, -1113179152, -1100757638, -1116265771, -1119227733)
		 + W(4, 1015263811, -1111332237, 1004409248, 1031432468) + W(5, 1057408386, 1053177162, 1035803645, 1052437131)
		 + W(6, 1048238354, 1044526364, 1056580635, -1114379264)
		 + W(7, 1025802539, -1104236495, -1124751623, -1121289813)
		 + W(8, -1106607621, -1104751670, -1107635783, -1107787999)
		 + W(9, 1020725062, -1114959053, -1129296244, -1120069105)
		 + W(10, -1122297405, -1124214159, 1017238947, -1110162105)
		 + W(11, 1002560364, -1113724157, -1123244163, -1115210511);
	sum2 =
		W(0, -1121057595, 1016432775, -1112629457, 1031151061) + W(1, -1126819952, 1021228732, 1009585899, -1127402608)
		+ W(2, 1023292260, -1124268922, -1116199054, -1110795130)
		+ W(3, -1103006120, -1134369449, -1120667087, 1016333862)
		+ W(4, -1111891368, 1029388268, -1123843875, 1054055516) + W(5, 1020478730, -1135412321, 993043492, 996548072)
		+ W(6, 1035766063, -1118389960, 1033023394, 1054507013) + W(7, -1104664187, -1121918429, 982538191, -1108029597)
		+ W(8, 1032208606, -1122510207, -1113138713, 1019595258) + W(9, -1114598707, 1023542227, 993709924, -1129671373)
		+ W(10, -1122161823, 1028529468, -1118001871, 1026811027)
		+ W(11, -1116707921, 1018790016, -1146185904, -1152045912);
	WS(-1091835967, 1038509097);
	sum1 = W(0, 1002958335, 1031236696, -1122124314, 1034973544)
		 + W(1, -1120202292, 1015820538, 1033636218, -1121967836) + W(2, 1041562959, 1038000620, 1042029266, 1034473413)
		 + W(3, 1040514695, 1042048878, 1029242778, 1042898689) + W(4, -1124369824, 1029288008, -1104824881, 1049571184)
		 + W(5, -1089024373, -1089426268, -1107643796, -1091407169)
		 + W(6, -1093861855, -1100002304, -1087002164, 1052741396)
		 + W(7, 1044570703, 1042398171, 1023923250, 1030369604) + W(8, 1039801017, 1038306915, 1037725118, 1041619283)
		 + W(9, 1031782758, 1038671876, 1025678032, 1043274836)
		 + W(10, -1132073944, 1032364667, -1122032128, 1036587856)
		 + W(11, -1138629744, 1010685600, 1027566834, -1153060031);
	sum2 = W(0, 1016791821, 1013192458, -1123883287, 1015528749)
		 + W(1, -1131825297, -1132736674, 1019880949, -1117749640)
		 + W(2, -1110538641, 1023566599, 1000152052, -1112636904)
		 + W(3, -1116367667, -1130121037, -1114305335, 1033496981)
		 + W(4, -1114409767, -1113846927, -1109610416, 1054155729)
		 + W(5, -1109117303, 1016394661, 1030290683, -1157815185) + W(6, 1045544748, 1029704719, 1034122997, 1054056541)
		 + W(7, 1030522539, -1116026974, 992430312, -1107824982)
		 + W(8, -1111278622, -1125617069, -1110039103, -1108588248)
		 + W(9, -1132906850, -1135451026, -1134728538, 1016739853)
		 + W(10, -1127655665, 1012727082, -1131212885, 1000573476)
		 + W(11, -1123699129, -1126704253, 988228497, -1123545619);
	WS(-1089794384, 1053743764);
	sum1 = W(0, 977181200, 1022034304, 999195154, -1173982736) + W(1, -1131079992, -1117753925, 1011212627, -1131210280)
		 + W(2, -1124062435, -1123589329, 1008939465, 967031199) + W(3, 1031201254, 1038421055, 1023184516, 1042888267)
		 + W(4, 1045792382, 1045687772, 1043214811, 1051096635) + W(5, -1106608558, -1104815387, 975115280, -1113606040)
		 + W(6, -1096122984, -1100185218, -1089534650, -1128424615)
		 + W(7, 1022835035, 1033659882, 1025453978, -1114474998) + W(8, 1035356461, 1029423919, 1037071922, -1130937578)
		 + W(9, 1033635179, -1112564552, -1148354182, -1115626236)
		 + W(10, -1146772642, 1022712508, 986801416, 1009586465)
		 + W(11, 1012941585, 1008485953, 1023442138, 1020831720);
	sum2 =
		W(0, 1025756371, -1152866061, 1022411083, 1021941035) + W(1, 1018807869, -1162131898, 1030478695, -1117519259)
		+ W(2, 1038582018, -1136865390, 1028991375, -1102180290)
		+ W(3, -1127151005, -1103213990, -1148467374, -1101731450)
		+ W(4, -1095235720, 1027392563, -1094985700, 1062263751) + W(5, 1023141397, 1032099771, -1139645537, 1050734432)
		+ W(6, -1097242729, -1108446917, -1092586393, 1055770556)
		+ W(7, 1024429444, 1045256871, -1115314196, 1044538365) + W(8, 1048188946, 1009460859, 1013992713, -1098658877)
		+ W(9, -1162587434, -1104388978, 1033707193, -1097902791)
		+ W(10, -1145714840, 1022755591, 1033471029, 1018658879)
		+ W(11, 1032105067, -1135748387, 1008760659, 1019361371);
	WS(-1092258911, -1089815334);
	sum1 = W(0, -1139634407, -1147044493, 1017866535, -1130890003)
		 + W(1, 1027130446, 1016637069, 1016500860, 1026913637) + W(2, 1045821685, 1034203057, 1044613801, 1035729090)
		 + W(3, 1029847032, -1102281888, -1131657511, -1121093118)
		 + W(4, -1119357002, 1015718019, -1104936487, -1090722234)
		 + W(5, 1052628837, 1057948020, 1044884520, 1053191568) + W(6, 1034361159, 1051668019, 1032636456, -1086460492)
		 + W(7, -1094763749, -1095562645, -1106362539, -1098187032)
		 + W(8, -1137425069, -1115826689, 1035725147, 1010439579)
		 + W(9, 1043916211, -1114240161, 1035145793, -1102258214)
		 + W(10, -1130196683, 1023465264, 1015877619, -1117806874)
		 + W(11, 1025832214, -1123952546, 1029577644, 1011300119);
	sum2 =
		W(0, -1128703433, 1012757410, 1007787634, 1023396449) + W(1, 1017560605, 1012244530, -1143125556, 1024938353)
		+ W(2, -1113670137, 1024378351, -1111552612, -1131966925)
		+ W(3, -1114649634, 1040107467, -1122758108, 1032092801) + W(4, 1038503213, -1102109659, 1041322248, 1061982310)
		+ W(5, -1104769108, -1098175974, 1026757617, -1105089779)
		+ W(6, 1040684472, -1100043210, 1041989415, 1066879681)
		+ W(7, -1101238360, -1089047102, 1023979343, -1100231891)
		+ W(8, -1099552212, 1026887817, -1104965070, -1107386978)
		+ W(9, -1104448348, 1016563929, -1107880053, 1036400101) + W(10, 993905065, 1003273444, -1144755940, 1019447753)
		+ W(11, 1019550873, 1024790159, -1138003290, 1014825186);
	WS(-1086002512, -1084928660);
	sum1 = W(0, -1131929465, 1017039401, 1020173741, -1134499377)
		 + W(1, -1129468257, -1138890277, -1132813939, -1143488833)
		 + W(2, -1115340892, -1113717074, -1102662114, -1097984585)
		 + W(3, 999020755, -1114393442, 1028151894, -1132982017) + W(4, 1050776738, 1042912513, 1053707114, 1055825787)
		 + W(5, -1108349590, 1033511359, -1108075378, -1138015505)
		 + W(6, -1103148388, 1010821235, -1104889757, 1049797700) + W(7, 1042555580, 1041826234, 1032548919, 1041074464)
		 + W(8, -1143173743, -1128281895, -1111952748, -1098746549)
		 + W(9, -1106170922, -1103706929, -1127274842, -1110410462)
		 + W(10, -1130358353, -1122997746, -1139775729, -1117617116)
		 + W(11, 1014563169, 1010736529, -1137959865, -1123442568);
	sum2 =
		W(0, 1000102260, -1126633986, -1144291760, -1119827470) + W(1, 1016232493, 1023762781, -1141218312, 1025293286)
		+ W(2, -1118205558, 1029900308, -1140439712, 1041420529) + W(3, 979974721, 1006017080, -1137204884, 1002898232)
		+ W(4, 1051204856, 1063980475, 1066576503, -1075398805)
		+ W(5, -1098954833, -1114660078, 1021034547, -1117648930)
		+ W(6, 1041999613, 1037162912, -1167793729, -1085093765) + W(7, 1017117707, 1033481679, -1137323924, 1002077480)
		+ W(8, -1135930364, -1134402620, 1020225891, -1133429672)
		+ W(9, 1028764817, 1018587503, -1132685152, 1026769102)
		+ W(10, 1019347314, -1137379540, 1012525172, -1123883092)
		+ W(11, -1139078108, 990744512, -1137103964, 1022792204);
	WS(-1084377664, 1027078466);
	sum1 = W(0, 1028609881, -1129675619, 1022038247, 1010908070) + W(1, 1026611885, 1030113110, -1132403564, 1031201461)
		 + W(2, 1023875764, 1032239673, 1043647401, 1024809124)
		 + W(3, -1131519215, -1128260416, 1026951667, -1115829469)
		 + W(4, -1113303893, -1114746833, -1084547118, -1156932707)
		 + W(5, 1050946557, 1047159719, 1020650755, 1037768177) + W(6, 1031700430, 1026119482, 1051850662, -1104988345)
		 + W(7, -1083734174, 1027361605, -1111325382, 1042797655)
		 + W(8, -1138486380, -1122216064, -1132199979, 1033025459)
		 + W(9, 1043104191, 1018468419, 1014159432, -1108759836) + W(10, 1025866053, 1016759071, 1032834541, 1029398137)
		 + W(11, 1007914454, 1021351811, 1014779182, 1018395723);
	sum2 = W(0, -1123315648, -1139192721, -1123875414, 1030816333)
		 + W(1, -1123326315, 1016532474, -1130303816, -1131093304)
		 + W(2, 1034590473, -1139997869, -1115134908, 1008365317)
		 + W(3, -1110803030, 1028786615, 1004595129, 1015409534) + W(4, 1026150549, 969235347, 1042477897, 1046059603)
		 + W(5, -1155992274, -1122978967, -1119026545, -1111529432)
		 + W(6, 1030314237, -1112534256, 1037120039, 1027803789)
		 + W(7, -1102080708, -1135183209, -1120008811, -1109468455)
		 + W(8, -1113579452, -1158492453, -1098184684, 1032895251)
		 + W(9, -1126452160, 1047700729, 999072441, 1047312851) + W(10, 1014056813, -1132289868, 1018097190, 1032146261)
		 + W(11, -1114996104, 1011346781, -1115756663, -1122411639);
	WS(1043014014, -1087744322);
	sum1 = W(0, 1027952711, 1020523582, 1002118409, 1021435438) + W(1, -1138414444, 1003104545, 1021955143, 1013303243)
		 + W(2, -1123526530, -1138321214, -1110182129, 1032339433)
		 + W(3, 1035386835, -1137297015, -1119534945, -1108462406)
		 + W(4, 1008337244, 1022379422, 1057818171, -1110004232)
		 + W(5, -1083267015, 1007303460, -1115695919, 1036022088)
		 + W(6, 1035059438, -1120526792, -1086364127, -1118604170)
		 + W(7, 1057062103, 1036507098, 1038869533, 1036993862) + W(8, -1116610857, 1037330895, 1040407761, 1040846837)
		 + W(9, -1107059287, -1128420830, 1017909759, -1142792885)
		 + W(10, 1026995059, -1156487121, 1009757724, -1153254001)
		 + W(11, 1021783366, 1034169880, -1138765796, 1027514579);
	sum2 =
		W(0, -1129567658, -1156092221, -1123579911, 1008715269) + W(1, -1125160256, 1026524337, -1137738801, 1017463077)
		+ W(2, -1117738234, -1131091573, -1115037144, -1115010115)
		+ W(3, -1101087826, 1015586863, -1113332277, 1019720419) + W(4, 1034622765, -1128107850, 1017778197, 1050631618)
		+ W(5, 1045062017, -1095615964, 1020345131, -1101223712) + W(6, 1030957051, -1118479197, 1041246295, 1054490255)
		+ W(7, -1117275788, 1025836507, 1027688491, -1120912313)
		+ W(8, 1029443337, 1005860107, -1110926783, -1157251077) + W(9, -1108959270, 1020928095, -1122972204, 983922363)
		+ W(10, -1132249217, 969559787, -1132354551, 1024782459)
		+ W(11, 998415619, 1012990901, -1161032699, 1011300789);
	WS(1054959103, -1083836992);
	sum1 =
		W(0, -1144415487, -1132171248, -1133053416, 980216825) + W(1, 1018609320, 1017404666, -1127349353, -1154920122)
		+ W(2, 1023853723, -1118146184, 1039313221, -1107434917)
		+ W(3, 1027331294, -1111685883, -1129432820, -1126004808)
		+ W(4, -1123173616, 1018672592, -1090265426, 1057912142) + W(5, 1044087220, 1046306952, -1133031712, 1039769364)
		+ W(6, -1121737045, -1123041056, -1161038260, 1053211380)
		+ W(7, -1089253699, 1036559366, -1110305609, 1035028498)
		+ W(8, -1124541667, -1120856711, 1034290206, -1109871174)
		+ W(9, 1040602782, -1113560292, -1148202051, -1109624712)
		+ W(10, 1017937944, -1131928876, 1027902624, -1129566080)
		+ W(11, -1121689404, 1010241568, -1124796708, -1127304152);
	sum2 =
		W(0, 1018338338, -1139755941, 1025801614, -1122001203) + W(1, 1010171613, -1132321439, 1016232007, 1013259501)
		+ W(2, -1110884586, -1129406227, -1108237236, 1037408540)
		+ W(3, 1040327756, -1123391437, -1129086463, -1132299663)
		+ W(4, -1136808221, -1118232763, -1115176435, -1113269344)
		+ W(5, -1105808410, -1110685464, -1168436052, 1021765462)
		+ W(6, 1026570078, 1021052542, -1114736489, 1041519115)
		+ W(7, 1047951095, -1115014721, -1113536502, -1123780081)
		+ W(8, -1136194357, 1020321772, 1048907220, 1046652366) + W(9, 1035402835, -1111631696, 1026410761, -1102273277)
		+ W(10, -1120452457, 1004896115, -1119060361, -1107310106)
		+ W(11, 1033649944, -1126977687, 1026056519, 1027695361);
	WS(1057903600, 1067139767);
	sum1 = W(0, -1130009103, 1012511358, -1137761926, -1124300975)
		 + W(1, 1008012526, -1117250069, -1162310274, -1115259538)
		 + W(2, -1107061793, -1111029392, -1104154592, -1103367501)
		 + W(3, 1009980758, -1113394087, 1026647906, -1114684710) + W(4, 1043136838, 1028125200, 1051222763, 1060113955)
		 + W(5, 1024983063, 1016245011, -1117690736, 1025498192) + W(6, -1102099951, 992918145, -1106189879, 1050079197)
		 + W(7, 1048697267, 1034440698, 1041096574, 1041574755)
		 + W(8, -1115498357, -1117969679, -1104467697, -1108729546)
		 + W(9, -1111781863, -1104780916, -1117169584, -1120787335)
		 + W(10, -1123992244, -1145160172, -1125356943, -1117739880)
		 + W(11, -1165450354, -1114615608, -1139440358, -1118506516);
	sum2 = W(0, 1011962608, -1120699406, 1007214128, 1026799984)
		 + W(1, -1145867047, 1029224075, -1116434980, 1022659583)
		 + W(2, 1038855085, -1131692032, 1038467393, -1112343444)
		 + W(3, -1113849522, -1138735380, -1120001434, -1118784264)
		 + W(4, -1122245118, -1112627842, -1122221782, -1106597578)
		 + W(5, 1026356645, -1114988845, 1020413259, -1123194990)
		 + W(6, -1126451804, -1110442893, 1042136464, 1054959792) + W(7, 1031831390, 1046305460, 1008343524, 1047204017)
		 + W(8, -1106947014, 1008646548, -1113116412, -1109079281)
		 + W(9, -1109881757, -1109725169, -1123390380, -1114571313)
		 + W(10, 1026864717, -1123527836, 999106843, 1011333214)
		 + W(11, -1117815384, 1032922020, -1119479700, 1000599735);
	WS(-1101058110, 1058505899);
	sum1 =
		W(0, 1008909245, 1015324303, -1151491221, -1139701245) + W(1, 1009250957, 1031005836, -1131857944, 1009310828)
		+ W(2, -1123852394, -1112299044, -1128516275, -1102217815)
		+ W(3, -1104833467, -1113648843, -1119585353, -1121962739)
		+ W(4, 1037579744, 992056181, -1098678002, 1045087960) + W(5, 1058072040, 1036986521, 1024521495, 1032839164)
		+ W(6, 1024016996, -1124723744, 1056678303, 1021619781) + W(7, -1095085849, 1041104615, -1129179587, 1025292595)
		+ W(8, -1121096497, -1131134189, -1109419958, -1098726544)
		+ W(9, -1109643932, -1121889031, -1127292144, 1017031326)
		+ W(10, 1022516663, -1130344395, 1021039583, -1132041247)
		+ W(11, -1140161581, 1026848535, -1125244995, 1005622747);
	sum2 =
		W(0, 992821683, 1017011277, 1011814063, 999390943) + W(1, -1121326865, -1128713872, -1144442308, -1138094133)
		+ W(2, 1023078017, -1140746852, 959773689, -1112338116) + W(3, 1035095219, 1024063493, 1023948090, 1032024680)
		+ W(4, 1023704638, -1139829185, -1107874815, -1113377165)
		+ W(5, -1108229047, 1033653422, -1133039950, -1140161389)
		+ W(6, -1112719649, 1034266306, 1032357888, 1057654961) + W(7, 1012152366, -1122811174, 1020168485, -1113617432)
		+ W(8, 1027637582, -1119668356, -1113625790, -1086342498)
		+ W(9, -1101720659, -1136544465, -1121720102, 1019370668)
		+ W(10, 1021903376, 1016759855, 1034398452, 1051594315) + W(11, 1035110699, 1031049449, 1018271190, 1021410443);
	WS(-1098338111, 1023498750);
	sum1 = W(0, -1138701849, 1022617405, -1168316434, 989875557) + W(1, 1014043241, 1028694643, 1012653195, -1123740578)
		 + W(2, -1121510465, -1112416999, -1180399652, 1037491593)
		 + W(3, -1102495433, -1121884733, -1122132512, 1036415429)
		 + W(4, 1040383254, 1041395124, -1097293461, -1094988553)
		 + W(5, 1059563452, -1118903112, 1027507886, -1126796061)
		 + W(6, 1010706669, -1110248019, 1058209828, -1095385553)
		 + W(7, -1097437690, 1046085501, -1130301425, -1128488725)
		 + W(8, -1149170878, 1020223099, -1106291545, 984962665)
		 + W(9, -1119747464, -1122110350, -1123237039, 989067449)
		 + W(10, 1021863397, 1016227961, 1018489101, 1021609037)
		 + W(11, -1145092370, 1026243438, 992349061, -1164474953);
	sum2 = W(0, -1164068108, -1120898035, 1013829433, 972583599)
		 + W(1, 1016837545, -1128855117, -1120505887, -1130000643)
		 + W(2, 1029420636, 1036981221, 1035658823, 1039879187) + W(3, -1102894380, -1128781606, 1013125305, 1008550341)
		 + W(4, -1112077059, -1106651210, -1106432341, -1108370344)
		 + W(5, 1027609202, 1035930993, 1026372950, 1017927697) + W(6, -1110964317, -1141413971, 1035230257, 1044568046)
		 + W(7, 1041920264, -1110600858, -1125837008, 1019426133) + W(8, 1028276360, 1028557670, 1017251513, 1026800348)
		 + W(9, -1124056839, 1023713154, -1132458450, -1129712212)
		 + W(10, -1148255859, -1129246253, -1131530425, -1126980980)
		 + W(11, -1121785123, -1124361549, 1009116645, -1127748642);
	WS(1064075168, -1085260633);
	sum1 = W(0, 1020097830, 1004279127, 1028112237, 1026532451) + W(1, 961537748, -1130706656, -1135275149, 994604265)
		 + W(2, -1104011171, -1113516590, -1103036207, -1102348791)
		 + W(3, -1120389361, 1038928889, -1129088474, 1031068695) + W(4, 1041894009, 1036855277, 1045116105, 1027716980)
		 + W(5, -1096376936, -1096709211, 996846509, -1102472071)
		 + W(6, 1034297780, -1106861493, -1112331770, 1058153819)
		 + W(7, 1043898973, 1048347472, -1164071066, -1118081687)
		 + W(8, -1113914242, 1031661466, 1017072798, -1100287056)
		 + W(9, -1119328440, 1032287909, 1019059671, 1040008649)
		 + W(10, -1138151419, -1151789197, -1129921062, 1026370483)
		 + W(11, 1025128111, -1140511211, -1167790389, -1140610427);
	sum2 =
		W(0, 1014633478, -1138053524, -1140130516, -1120104172) + W(1, 1012698026, -1123853902, 1013120742, -1133638700)
		+ W(2, 1033869831, -1133342724, 1003291347, 1033872317) + W(3, 1006625651, -1121932314, 1004319943, 975983930)
		+ W(4, -1114935893, -1126366588, 1043822142, -1086850225)
		+ W(5, 1030145358, 1040015383, -1150276254, 1028724356)
		+ W(6, -1111281510, -1128243618, -1107071420, -1084734921)
		+ W(7, 1067004758, 1046081705, 1002809783, 1031930717) + W(8, 1016908923, -1145483991, 1006526455, 1045857736)
		+ W(9, 1020093203, -1118176982, -1161820989, -1104669476) + W(10, 990649086, 996067150, 1012165262, -1119271334)
		+ W(11, -1129772456, -1144422823, -1141799647, -1143148999);
	WS(-1102756414, -1120030182);
	sum1 = W(0, -1114857721, 1007304745, -1113282502, -1135708169)
		 + W(1, -1130226572, -1115825727, -1142173365, -1136250680)
		 + W(2, -1102767115, -1115971707, -1095987354, -1101194087)
		 + W(3, -1099422340, -1109693396, -1122657804, -1100198174)
		 + W(4, 1043961809, -1101676399, 1053600405, 1065521342) + W(5, 1046696200, 997946179, -1112668237, 1025742970)
		 + W(6, -1124210446, 1028311347, 1046261656, 1068133511)
		 + W(7, 1042816511, -1098872988, -1133742993, -1113205915)
		 + W(8, -1117667780, -1113057893, -1103902228, -1095174540)
		 + W(9, -1101926052, 1020822452, -1113901869, -1140085511)
		 + W(10, -1120413918, -1125847632, -1114932345, 1027169042)
		 + W(11, -1125196828, -1114420141, -1121096548, -1110338975);
	sum2 =
		W(0, 1022430051, -1126993785, 1027244407, -1136699515) + W(1, -1115987625, 1024283610, -1120680273, -1137060371)
		+ W(2, -1119384349, -1117046041, -1113440146, -1099757367)
		+ W(3, 1038214736, -1152620459, 1013074835, 1015902709) + W(4, -1127804673, 1014745875, -1129639049, 1065124465)
		+ W(5, -1113943514, -1130768777, -1113854522, -1112590762)
		+ W(6, 1011315171, -1106680506, 1020590601, 1034863647) + W(7, 1035633573, -1116743921, -1127682237, 1012706011)
		+ W(8, -1121146859, 1009189211, -1115604020, -1111752578)
		+ W(9, -1124061319, -1120130033, -1148961286, -1113078716)
		+ W(10, 1009328259, -1125156477, 1000906166, 1017063165)
		+ W(11, -1117062841, 1024425511, -1119191933, 1024105421);
	WS(-1077988040, -1098609713);
	sum1 = W(0, 1020152245, 1002836371, -1132015209, 1010566313) + W(1, 1010053945, 1020486319, 1030571159, -1132252076)
		 + W(2, 1040202093, 1027276515, 1049452385, 1032875267) + W(3, 1036663212, 1034908465, -1114877050, 1038229775)
		 + W(4, -1114910389, 1037438449, -1100627367, 1030654167)
		 + W(5, -1113362709, -1095852652, 1025947458, -1105166249)
		 + W(6, -1104283732, -1105856183, -1098108347, -1102427678)
		 + W(7, -1104090280, 1048934265, -1126406169, -1138504825)
		 + W(8, 1039298438, 1028081393, 1024125142, -1131705423) + W(9, 1042947115, 1019783717, 1021770278, 1035155325)
		 + W(10, -1125387021, 1013826369, 1018674229, 1017725301)
		 + W(11, -1141124531, 1015682181, 1006527587, 1016700365);
	sum2 =
		W(0, -1142267837, -1139598567, 967895252, 1008554815) + W(1, -1145406733, 1024473654, -1120792990, 1020245499)
		+ W(2, -1132626695, -1138132903, -1131100139, 1032537913)
		+ W(3, -1112410791, 1023361695, -1130141475, 1015868043) + W(4, 1023852808, 1033876712, 1012220303, -1095058264)
		+ W(5, -1110252153, -1104029741, 1031843465, -1196949327)
		+ W(6, 1039691642, -1110747637, 1061640184, 1037101696) + W(7, -1091888991, -1161200181, -1119701362, 977066218)
		+ W(8, -1114839167, -1127924867, -1122160974, 1049832068)
		+ W(9, 1027903240, -1126050715, -1132864167, -1118663498)
		+ W(10, -1147709133, -1155304986, -1121532798, 992067354)
		+ W(11, -1128735955, 1025251228, -1157362170, 1009680879);
	WS(1050097375, -1144620389);
	sum1 =
		W(0, -1128715377, 1011057731, -1134438475, 1019193873) + W(1, 1022275225, 1009602711, 1032927683, -1136253330)
		+ W(2, 1044211901, 1033637193, 1048874276, 1034983634) + W(3, 1042543166, 1017343103, -1149239594, 1037918654)
		+ W(4, -1107032850, 1022227585, -1096643663, -1114392598)
		+ W(5, -1092702793, -1097617495, -1139445891, -1097624368)
		+ W(6, -1104047251, 1028225817, -1092741994, 1036584266)
		+ W(7, 1025153498, 1028276325, -1142331733, -1118553533) + W(8, 1044522647, 1008625791, 1044273989, -1113959235)
		+ W(9, 1042105869, 1041046056, 1025445761, 1045159742) + W(10, -1128884681, 1011579579, 1018667761, 1025301657)
		+ W(11, 1024565397, -1123355105, 1027058603, 1015982985);
	sum2 =
		W(0, -1125113091, -1172679141, -1152889753, -1126905475)
		+ W(1, 1006649294, -1117488938, 1019337735, -1172252645) + W(2, 1033296420, -1128383915, 1019343075, 1031861037)
		+ W(3, 1038268779, -1113645001, 1028739248, -1120621430)
		+ W(4, 1004274749, 1016688407, -1103752812, -1097163724) + W(5, 1062746712, 1051715314, -1124587947, 1035778038)
		+ W(6, -1102915066, 1037338868, -1089888071, -1090194983)
		+ W(7, 1041005261, -1118523722, 1027501384, -1154227385)
		+ W(8, 1028147108, -1144981581, 1030353331, -1121675098) + W(9, 1019962267, 1006661278, 1023891692, 1013440998)
		+ W(10, 1017918867, 991135609, 1022111055, -1117974458)
		+ W(11, 1026630548, -1115156997, 1018829507, -1136345798);
	WS(-1098112447, -1125216946);
	sum1 =
		W(0, 1010417568, 1006322176, -1140685064, 1017991280) + W(1, -1126853432, -1146614696, 1004323364, 1019294567)
		+ W(2, -1112042689, -1119953952, -1116450322, -1112784281)
		+ W(3, -1105219289, 1023451023, -1153582112, -1110071894)
		+ W(4, 1004161984, -1112614584, -1090400895, -1113885864) + W(5, 1051228911, -1126136276, 1016683168, 983864831)
		+ W(6, 1041397655, 1018267345, 1058507679, 1050855349) + W(7, -1097135921, -1122997076, -1149231824, 1012208560)
		+ W(8, -1114418485, 1024614191, -1104618697, 1027345269) + W(9, 1037685358, 1039454784, -1140802306, 1030420791)
		+ W(10, 1021110568, -1137912440, -1127130192, 1019594896)
		+ W(11, -1116355204, 987030015, 988441407, -1149650752);
	sum2 =
		W(0, 1035141604, -1134943159, 1031353634, -1120750640) + W(1, 1025254666, -1114509439, 1028756554, -1113538005)
		+ W(2, -1152950404, 1010887850, -1122370025, -1101926585)
		+ W(3, -1104605825, 1035852377, -1114959163, -1148680422)
		+ W(4, -1100547860, 1025641276, -1101375945, 1057546844) + W(5, 1048526282, -1108641700, 1033576762, 1037895648)
		+ W(6, -1104792229, -1119115361, -1100366049, 1042205116) + W(7, 1042952063, 1039483674, 1030776026, 1041006229)
		+ W(8, 1037875812, 1021611837, 1015511489, -1109199537)
		+ W(9, -1105787312, -1109299079, -1143994351, -1107406256)
		+ W(10, -1138078871, 1016878804, 1015482099, -1140091328)
		+ W(11, 1032201266, -1132053601, 1007578680, -1124574444);
	WS(1027823864, 1049081066);
	sum1 = W(0, 1012131718, -1130128499, 1020918007, -1147020173) + W(1, 1027080278, 1020448605, 1012408472, 1024273997)
		 + W(2, 1045092167, 1032126573, 1043895467, 1034108246)
		 + W(3, 1035993776, -1104998342, -1129990263, -1123698278)
		 + W(4, -1108779609, -1127539283, -1101697729, -1094495268)
		 + W(5, 1047905888, 1057437086, 1041161122, 1052750589) + W(6, 1031292119, 1050389010, 998802811, -1089568357)
		 + W(7, -1096020979, -1097851474, -1105719893, -1101687913)
		 + W(8, -1168425160, -1113259988, 1036534559, 1026355631)
		 + W(9, 1044370080, -1112197645, 1035394325, -1103284196)
		 + W(10, -1123848398, 1017365039, 1015583683, -1120941186)
		 + W(11, 1024649726, -1123264842, 1027345300, 966350543);
	sum2 = W(0, 1023788251, 982227227, 1006064903, -1119196045) + W(1, 1022374646, -1139981943, 1006364327, -1130167410)
		 + W(2, -1115639872, -1150596845, 1015277390, 1006169559)
		 + W(3, 1034991246, -1110295858, -1148612007, -1131776900)
		 + W(4, 1042970848, 1046665761, 1037025188, -1080187678) + W(5, 1047303977, 1052132899, 1033799186, 1035867784)
		 + W(6, 1041100183, 1053945290, -1128807740, -1078236510) + W(7, 1053440142, 1058969577, 1029728171, 1005561207)
		 + W(8, -1120506242, -1121383639, 1017634434, 998104205)
		 + W(9, 1037533712, -1112892146, 1033828190, -1110685126)
		 + W(10, -1214633659, -1143798279, 1023282498, -1114831851)
		 + W(11, 1023435593, -1124500500, 1015376522, 1014287051);
	WS(-1088189216, 1043089281);
	sum1 = W(0, -1140748743, -1121398410, 1026065228, -1149048846)
		 + W(1, 1020127051, 1036138263, -1128555260, 1038047047) + W(2, 1049770738, 1041680407, 1048806759, 1043836791)
		 + W(3, 1034371336, 1024770968, 1037337862, -1137213911)
		 + W(4, -1088213532, -1096476823, -1084369379, -1108723571)
		 + W(5, 1036745881, 1041309981, 1011670631, 1028379642) + W(6, 1042644994, 1047024381, 1050638745, -1101872740)
		 + W(7, -1094226627, -1096464492, -1106071481, -1102959693)
		 + W(8, 1041481493, -1107153702, 1035104215, 1041455384) + W(9, 1040593116, 1045395982, 1040128941, 1016152290)
		 + W(10, 1008330103, 1031833588, 1020682979, 1026205458)
		 + W(11, 1006701623, -1120876186, 1024336228, 1028740542);
	sum2 =
		W(0, -1129618765, 1004169862, -1163586391, 1012667011) + W(1, 1004789414, 1006867267, -1148564598, 1023888443)
		+ W(2, 1028575755, -1114659435, 1025093243, -1110197183)
		+ W(3, -1140439179, -1110600679, 1019765437, -1106146141)
		+ W(4, 1018469269, 1020493837, -1120959857, 1045602812) + W(5, -1119013866, 1007539419, -1126956769, 1005311510)
		+ W(6, -1109549862, 1025826707, 1018231561, 1050121196) + W(7, 1009644755, 1038682513, 1017107081, 1040899502)
		+ W(8, 1022763469, -1116607191, 1017295613, -1110473213)
		+ W(9, -1143499366, -1107944702, -1123266847, -1114206671)
		+ W(10, -1123897489, -1153284395, -1131222849, 1019030581)
		+ W(11, -1125130849, 1009132883, 1006886939, -1127991173);
	WS(-1082596160, 1043517696);
	sum1 = W(0, 1028909798, -1153492953, 967933898, 1019116907) + W(1, -1132218099, -1129844133, 1011144392, 999709323)
		 + W(2, -1154689545, 1032486047, -1128767583, 1037703496)
		 + W(3, -1115978788, 1027446332, -1146849277, -1114471573)
		 + W(4, -1104169149, -1117361518, 1049441299, -1087176649)
		 + W(5, -1115448907, 1018413135, -1154137305, -1130624603)
		 + W(6, 1025985531, -1118729126, 1031994846, -1089391227) + W(7, 1056185125, 1032249225, 1036574828, 1042483386)
		 + W(8, 1029418231, 1034798166, 1006099469, 1046438773) + W(9, -1106352341, 991686873, -1131200252, 1022706506)
		 + W(10, 1024711058, -1125485751, 1008177302, 986175666)
		 + W(11, -1125946755, 1030151438, 1006963806, 1019997155);
	sum2 = W(0, 987806561, 1024001581, -1132313544, -1138298076) + W(1, 1003342504, -1131321664, 1015369606, 1016585830)
		 + W(2, -1103978637, -1138508200, -1113576691, 1037869389)
		 + W(3, 1041829747, -1102361734, 995389041, -1103350916)
		 + W(4, 1039699877, -1109586411, -1109697688, 1004783368)
		 + W(5, -1101655248, 1023850463, -1123567230, 1033013495) + W(6, 1032745921, 1036006171, 1041044376, 1057490671)
		 + W(7, -1120283284, -1118937466, -1137071480, 1023653113)
		 + W(8, -1106709297, 984628641, -1135869680, -1123523352)
		 + W(9, 1037905909, -1133053924, 1008345900, -1123775069)
		 + W(10, 1017765222, -1151113585, -1128136972, -1126668402)
		 + W(11, -1142518888, -1119975873, 1015435786, -1153724113);
	WS(1066487464, -1081148228);
	sum1 =
		W(0, -1156758047, -1115667101, 1032245054, -1120457266) + W(1, 1025970038, 1028999903, -1129094085, 1031685286)
		+ W(2, 1045622655, 1039828621, 1043227835, 1051174634) + W(3, 1038187760, 1035936180, 1028125692, 1038703027)
		+ W(4, -1121579186, 1016276052, -1107379682, -1081882686)
		+ W(5, -1114502289, -1110627634, 1032926021, -1130240468)
		+ W(6, 1016497454, 1034243041, -1125065087, -1081200961)
		+ W(7, -1121918554, -1121754318, -1138807120, -1128847308)
		+ W(8, 1026804003, -1129971954, 1036683903, 1050524446) + W(9, 1033938044, 1045144826, 1028558202, 1036935449)
		+ W(10, 1025331662, 1022570928, 1033790001, 950141917) + W(11, 1035886143, -1123227402, 1023360168, 1033245399);
	sum2 = W(0, 990406129, -1109318105, 1032976305, -1108583903) + W(1, 1009651516, 1027268958, -1109295843, 1034160517)
		 + W(2, 1013162021, 1040565489, -1125670617, 1041812300)
		 + W(3, -1123723867, 1031967357, 1033460548, -1113698315)
		 + W(4, -1111903383, -1098989385, -1114873385, 1042303391)
		 + W(5, 1001920896, -1113158574, 1015358203, 1032025507) + W(6, 1031481662, 1036428343, 1043786440, 1039454897)
		 + W(7, 1032603577, -1097549253, -1117993943, -1119346601)
		 + W(8, -1112035485, -1111376696, 1007686716, 1044627344)
		 + W(9, -1107723593, 1043104932, -1142055788, -1111706149)
		 + W(10, 1026146121, 1020848344, 993596601, -1114987237)
		 + W(11, 1030752081, -1112152994, -1128311189, 1024170945);
	WS(-1085700080, -1080808385);
	sum1 = W(0, 1024296914, -1122227946, -1137292464, 1023737634)
		 + W(1, -1114666035, 1017074878, -1116342907, 998628462) + W(2, -1130852634, 1020782261, 1018157624, 1000516328)
		 + W(3, 1007198528, 1034334952, 1028012332, 1030076118)
		 + W(4, -1113008209, 1011762792, -1132968658, -1126768286)
		 + W(5, -1104353680, -1108931914, -1128335092, -1106440695)
		 + W(6, 1037784580, -1106441949, 1034492712, -1096045179) + W(7, 1044579508, 1035021791, 1016641544, 1037317931)
		 + W(8, -1128041639, 1023563097, 1002605936, 1048917408)
		 + W(9, -1126595297, -1127030516, -1124799637, -1122557970)
		 + W(10, 1011155704, 1007950112, -1130475172, 1027876850)
		 + W(11, -1148910448, 1030237498, -1178616327, 1026212766);
	sum2 = W(0, -1127545645, 1018138398, -1144042592, 999025130)
		 + W(1, -1139402988, -1150259805, 985356315, -1133933532)
		 + W(2, 1009004191, -1136885460, -1141392422, 1032831862)
		 + W(3, 1017820345, -1138954980, 1013413304, -1164078621)
		 + W(4, 1015771798, -1151865619, -1107745249, -1097510643)
		 + W(5, -1117369881, 1017078443, -1132039248, -1132951491)
		 + W(6, -1131692274, -1125888003, -1091675886, -1072938398)
		 + W(7, -1091916978, -1117354278, -1124163047, -1138824868)
		 + W(8, 1014637794, 1023581282, 1057331451, 1076041086) + W(9, 1056314077, 1032772879, 1020965023, 1026258229)
		 + W(10, 996126556, 1018938725, -1136255574, -1112160457)
		 + W(11, -1150817344, -1138128772, 1018397555, 985080995);
	WS(1065410184, 989310727);
	sum1 = W(0, -1129262375, -1140125102, -1116437485, -1133156750)
		 + W(1, 1013595422, -1140436482, 1001232640, -1120957855)
		 + W(2, -1109321255, -1114916286, -1113105487, -1103994248)
		 + W(3, -1113291025, -1135877737, 1027066925, 1020121135) + W(4, 1036945010, 1039766830, 1017194412, 1046741097)
		 + W(5, 1059311888, -1110004779, -1131666807, -1115618446)
		 + W(6, 1026154888, -1115626794, 1060001058, 1017259310)
		 + W(7, -1103200016, 1018378495, -1131905035, -1127100975)
		 + W(8, -1134197844, -1121887434, -1094555822, -1114897776)
		 + W(9, 1023750749, -1113774366, -1124072268, -1116648163)
		 + W(10, -1125355007, 1012320294, -1137406030, -1133486286)
		 + W(11, -1124720479, -1115411390, 1004266540, -1123146591);
	sum2 = W(0, -1134742142, 994239369, -1134258278, -1126643555) + W(1, -1124787402, 1015413679, 991423945, 1010959842)
		 + W(2, 1015903261, 1014594226, -1129761964, 1031995313) + W(3, 1009465920, 1021296491, -1131866907, 1022764367)
		 + W(4, 1020154303, -1150882457, 1022217883, 1040302074)
		 + W(5, 1049285742, 1029784509, -1135790753, -1122024941)
		 + W(6, -1137672551, 1023023759, 1027518631, -1097618001)
		 + W(7, -1098762324, -1122992412, -1126884057, -1118740892)
		 + W(8, 1024853570, 1017377705, -1148789809, 1026258033) + W(9, -1132512970, 1015729459, -1130065044, 980872325)
		 + W(10, 1005131169, -1125421078, 1001175413, -1138047636)
		 + W(11, -1148246653, 1016986651, -1142203369, 992745521);
	WS(1051937311, 1019742014);
	sum1 =
		W(0, -1128733562, 997229903, 1023734487, -1116159949) + W(1, -1132293538, -1139661928, -1123545457, 1016780849)
		+ W(2, -1110586220, 1007594774, -1114376035, -1126695312)
		+ W(3, 1032525373, -1154941499, 1019369518, 1026460481) + W(4, 1044317379, -1115449474, 1058430122, -1131615423)
		+ W(5, 1028795565, 1043036192, -1111719346, -1122201669)
		+ W(6, 1034449865, 1040493967, -1106892452, -1096043495) + W(7, 1048571437, -1110832404, 1031893623, 1016066306)
		+ W(8, -1129053661, -1122019556, -1137597924, -1114653189)
		+ W(9, -1104742917, -1106286569, -1118024837, -1121789868)
		+ W(10, -1126315858, -1118602611, 1007433460, -1115826781)
		+ W(11, 1027349977, 1018237258, -1123671919, 1018711058);
	sum2 =
		W(0, 1008400273, 1016157529, -1144490357, -1138058389) + W(1, -1125392389, -1130565626, 965128306, -1135290574)
		+ W(2, -1127535498, -1127740478, 1041994790, 1049438349)
		+ W(3, -1105215135, -1113276412, -1135958083, -1114929610)
		+ W(4, -1110432262, -1101104373, -1088501039, 1056816205) + W(5, 1056199589, 1025802623, 1003347845, 1003318865)
		+ W(6, -1120718262, -1108362087, 1042410198, -1105949033)
		+ W(7, -1108549667, 1029274599, -1152613734, 1031964529)
		+ W(8, -1113670226, -1146032407, -1132649478, 1045816390)
		+ W(9, -1122823248, -1139374331, -1123972337, 1019133207)
		+ W(10, 1025653041, -1134925453, 1011207517, -1153231998)
		+ W(11, -1127906971, 1000306913, -1157554354, -1130500213);
	WS(-1117640696, 1034706864);

	return clamp(mstd0 + 5.0 * vsum / wsum * mstd1, 0.0, 1.0);
}

shared float inp[555];

#define CURRENT_PASS 2

#define GET_SAMPLE(x) dot(x.rgb, rgb2y)
#define imageStore(out_image, pos, val) imageStoreOverride(pos, val.x)
void imageStoreOverride(uint2 pos, float value) {
	float2 UV = mul(rgb2uv, INPUT.SampleLevel(sam_INPUT_LINEAR, HOOKED_map(pos), 0).rgb);
	OUTPUT[pos] = float4(mul(yuv2rgb, float3(value.x, UV)), 1.0);
}

#define INPUT_tex(pos) GET_SAMPLE(vec4(texture(INPUT, pos)))
static const float2 INPUT_size = float2(GetInputSize());
static const float2 INPUT_pt = float2(GetInputPt());

#define temp_tex(pos) (float(texture(temp, pos).x))
static const float2 temp_size = float2(GetInputSize().x * 1, GetInputSize().y * 2);
static const float2 temp_pt = float2(1.0 / (temp_size.x), 1.0 / (temp_size.y));

#define HOOKED_tex(pos) temp_tex(pos)
#define HOOKED_size temp_size
#define HOOKED_pt temp_pt

void Pass2(uint2 blockStart, uint3 threadId) {
	ivec2 group_base = ivec2(gl_WorkGroupID) * ivec2(gl_WorkGroupSize);
	int local_pos = int(gl_LocalInvocationID.x) * 15 + int(gl_LocalInvocationID.y);
	for (int id = int(gl_LocalInvocationIndex); id < 555; id += int(gl_WorkGroupSize.x * gl_WorkGroupSize.y)) {
		uint x = (uint)id / 15, y = (uint)id % 15;
		inp[id] =
			HOOKED_tex(HOOKED_pt * vec2(float(group_base.x + x - (2)) + 0.5, float(group_base.y + y - (3)) + 0.5)).x;
	}
	barrier();
	vec4 ret = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 ret0 = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 samples[12];
	samples[0][0] = inp[local_pos + 0];
	samples[0][1] = inp[local_pos + 1];
	samples[0][2] = inp[local_pos + 2];
	samples[0][3] = inp[local_pos + 3];
	samples[1][0] = inp[local_pos + 4];
	samples[1][1] = inp[local_pos + 5];
	samples[1][2] = inp[local_pos + 6];
	samples[1][3] = inp[local_pos + 7];
	samples[2][0] = inp[local_pos + 15];
	samples[2][1] = inp[local_pos + 16];
	samples[2][2] = inp[local_pos + 17];
	samples[2][3] = inp[local_pos + 18];
	samples[3][0] = inp[local_pos + 19];
	samples[3][1] = inp[local_pos + 20];
	samples[3][2] = inp[local_pos + 21];
	samples[3][3] = inp[local_pos + 22];
	samples[4][0] = inp[local_pos + 30];
	samples[4][1] = inp[local_pos + 31];
	samples[4][2] = inp[local_pos + 32];
	samples[4][3] = inp[local_pos + 33];
	samples[5][0] = inp[local_pos + 34];
	samples[5][1] = inp[local_pos + 35];
	samples[5][2] = inp[local_pos + 36];
	samples[5][3] = inp[local_pos + 37];
	samples[6][0] = inp[local_pos + 45];
	samples[6][1] = inp[local_pos + 46];
	samples[6][2] = inp[local_pos + 47];
	samples[6][3] = inp[local_pos + 48];
	samples[7][0] = inp[local_pos + 49];
	samples[7][1] = inp[local_pos + 50];
	samples[7][2] = inp[local_pos + 51];
	samples[7][3] = inp[local_pos + 52];
	samples[8][0] = inp[local_pos + 60];
	samples[8][1] = inp[local_pos + 61];
	samples[8][2] = inp[local_pos + 62];
	samples[8][3] = inp[local_pos + 63];
	samples[9][0] = inp[local_pos + 64];
	samples[9][1] = inp[local_pos + 65];
	samples[9][2] = inp[local_pos + 66];
	samples[9][3] = inp[local_pos + 67];
	samples[10][0] = inp[local_pos + 75];
	samples[10][1] = inp[local_pos + 76];
	samples[10][2] = inp[local_pos + 77];
	samples[10][3] = inp[local_pos + 78];
	samples[11][0] = inp[local_pos + 79];
	samples[11][1] = inp[local_pos + 80];
	samples[11][2] = inp[local_pos + 81];
	samples[11][3] = inp[local_pos + 82];
	ret[0] = nnedi3(samples);
	ret0[0] = inp[local_pos + 33];
#if CURRENT_PASS == LAST_PASS
	uint2 destPos = blockStart + threadId.xy * ivec2(2, 1);
	uint2 outputSize = GetOutputSize();
	if (destPos.x >= outputSize.x || destPos.y >= outputSize.y) {
		return;
	}
#endif
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(2, 1), ret0);
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(2, 1) + ivec2(1, 0), ret);
}
