// SMAA Ultra Quality Anti-Aliasing
// Subpixel Morphological Anti-Aliasing

//!BGFX EFFECT
//!VERSION 1
//!NAME SMAA Ultra
//!CATEGORY Anti-Aliasing
//!DESCRIPTION Subpixel Morphological Anti-Aliasing with ultra quality preset. Maximum 32 search steps with full diagonal detection (16 steps) and 25% corner rounding for the best possible edge quality.


//!TEXTURE
Texture2D INPUT;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
Texture2D OUTPUT;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16_FLOAT
//!DESC Detected edge map for the current frame (high precision)
Texture2D edgesTex;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R16G16B16A16_FLOAT
//!DESC Blending weight map computed from edge patterns (high precision)
Texture2D blendTex;

//!TEXTURE
//!SOURCE AreaTex.dds
//!FORMAT R8G8B8A8_UNORM
//!DESC Precomputed area lookup table for pattern matching
Texture2D areaTex;

//!TEXTURE
//!SOURCE SearchTex.dds
//!FORMAT R8_UNORM
//!DESC Precomputed search lookup table for edge traversal
Texture2D searchTex;

//!SAMPLER
//!FILTER POINT
SamplerState PointSampler;

//!SAMPLER
//!FILTER LINEAR
SamplerState LinearSampler;


//!COMMON

#define SMAA_RT_METRICS float4(GetInputPt(), GetInputSize())
#define SMAA_LINEAR_SAMPLER LinearSampler
#define SMAA_POINT_SAMPLER PointSampler
#define SMAA_PRESET_ULTRA
#include "SMAA.hlsli"

//!PASS 1
//!DESC Edge Detection - Detect edges using luma differences
//!STYLE PS
//!IN INPUT
//!OUT edgesTex

float2 Pass1(float2 pos) {
	return SMAALumaEdgeDetectionPS(pos, INPUT);
}

//!PASS 2
//!DESC Weight Calculation - Compute blending weights from edge patterns
//!STYLE PS
//!IN edgesTex, areaTex, searchTex
//!OUT blendTex

float4 Pass2(float2 pos) {
	return SMAABlendingWeightCalculationPS(pos, edgesTex, areaTex, searchTex, 0);
}

//!PASS 3
//!DESC Neighborhood Blend - Apply anti-aliasing using calculated weights
//!STYLE PS
//!IN INPUT, blendTex
//!OUT OUTPUT

float4 Pass3(float2 pos) {
	return SMAANeighborhoodBlendingPS(pos, INPUT, blendTex);
}
