//!BGFX EFFECT
//!VERSION 1
//!NAME Bilinear Interpolation
//!CATEGORY Scaling
//!DESCRIPTION Simple bilinear texture filtering for smooth image scaling with linear interpolation between neighboring pixels.

//!TEXTURE
Texture2D INPUT;

//!TEXTURE
Texture2D OUTPUT;

//!SAMPLER
//!FILTER LINEAR
SamplerState linearSampler;

//!PASS 1
//!STYLE PS
//!IN INPUT
//!OUT OUTPUT

float4 Pass1(float2 texCoord) {
	return INPUT.SampleLevel(linearSampler, texCoord, 0);
}
