//!BGFX EFFECT
//!VERSION 1
//!NAME Nearest Neighbor
//!CATEGORY Scaling
//!DESCRIPTION Point sampling filter that preserves sharp pixel edges. Ideal for pixel art and retro graphics where you want to maintain crisp boundaries.

//!TEXTURE
Texture2D INPUT;

//!TEXTURE
Texture2D OUTPUT;

//!SAMPLER
//!FILTER POINT
SamplerState pointSampler;

//!PASS 1
//!STYLE PS
//!IN INPUT
//!OUT OUTPUT

float4 Pass1(float2 texCoord) {
	return INPUT.SampleLevel(pointSampler, texCoord, 0);
}
