//!BGFX EFFECT
//!VERSION 1
//!NAME Temporal Accumulate
//!CATEGORY Temporal
//!DESCRIPTION Accumulates current frame with previous output for temporal persistence.
//!USE _DYNAMIC

// Uses PassFeedback to blend current input with previous output
// Creates smooth motion trails and temporal anti-aliasing effect
// Higher retention = stronger persistence/ghosting

//!PARAMETER
//!LABEL Retention
//!DEFAULT 0.8
//!MIN 0.0
//!MAX 0.95
//!STEP 0.05
float retention;

//!TEXTURE
Texture2D INPUT;

//!TEXTURE
Texture2D OUTPUT;

//!TEXTURE
//!FEEDBACK Accumulate
Texture2D PrevOutput;

//!SAMPLER
//!FILTER LINEAR
SamplerState sam;

//!PASS 1
//!NAME Accumulate
//!STYLE PS
//!IN INPUT, PrevOutput
//!OUT OUTPUT

float4 Pass1(float2 pos) {
    float4 current = INPUT.SampleLevel(sam, pos, 0);
    float4 prev = PrevOutput.SampleLevel(sam, pos, 0);

    // Blend current with accumulated previous output
    float4 result = lerp(current, prev, retention);
    result.a = 1.0;
    return result;
}
