//!BGFX EFFECT
//!VERSION 1
//!NAME Temporal Blend
//!CATEGORY Temporal
//!DESCRIPTION Blends current frame with previous INPUT frames for motion smoothing.
//!USE _DYNAMIC

// Uses OriginalHistory to blend multiple previous INPUT frames
// Creates a smooth, slightly ghosted image that reduces temporal noise

//!PARAMETER
//!LABEL Blend Strength
//!DEFAULT 0.5
//!MIN 0.0
//!MAX 0.9
//!STEP 0.05
float blendStrength;

//!TEXTURE
Texture2D INPUT;

//!TEXTURE
Texture2D OUTPUT;

//!TEXTURE
//!HISTORY 1
Texture2D Prev1;

//!TEXTURE
//!HISTORY 2
Texture2D Prev2;

//!TEXTURE
//!HISTORY 3
Texture2D Prev3;

//!SAMPLER
//!FILTER LINEAR
SamplerState sam;

//!PASS 1
//!STYLE PS
//!IN INPUT, Prev1, Prev2, Prev3
//!OUT OUTPUT

float4 Pass1(float2 pos) {
    float4 current = INPUT.SampleLevel(sam, pos, 0);
    float4 prev1 = Prev1.SampleLevel(sam, pos, 0);
    float4 prev2 = Prev2.SampleLevel(sam, pos, 0);
    float4 prev3 = Prev3.SampleLevel(sam, pos, 0);

    // Weighted average of history frames (more recent = higher weight)
    float4 history = prev1 * 0.5 + prev2 * 0.3 + prev3 * 0.2;

    // Blend current with history
    float4 result = lerp(current, history, blendStrength);
    result.a = 1.0;
    return result;
}
