@echo off
setlocal enabledelayedexpansion

echo ========================================
echo Disable Fullscreen Optimization Tool
echo ========================================
echo.

:: Get exe directory (bat is in ...\GameName_Data\StreamingAssets, exe is one level above GameName_Data)
set "TEMP_DIR=%~dp0..\.."
cd /d "%TEMP_DIR%"

if errorlevel 1 (
    echo [ERROR] Cannot switch to exe directory: %TEMP_DIR%
    goto :error
)

:: Use %CD% to get resolved absolute path
set "EXE_DIR=%CD%"

if not exist "%EXE_DIR%" (
    echo [ERROR] Cannot find exe directory: %EXE_DIR%
    goto :error
)

echo [INFO] Current directory: %EXE_DIR%
echo.

:: Auto-find the unique exe file
set GAME_EXE=
for %%i in (*.exe) do (
    set GAME_EXE=%%i
    goto :found_exe
)

:found_exe
if "%GAME_EXE%"=="" (
    echo [ERROR] No exe file found in current directory
    goto :error
)

echo [INFO] Found game exe file: %GAME_EXE%
echo.

:: Build full exe path (using absolute path)
set "FULL_EXE_PATH=%EXE_DIR%\%GAME_EXE%"
echo [INFO] Full path: %FULL_EXE_PATH%
echo.

:: Registry path
set REG_PATH=HKCU\Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\Layers

echo [INFO] Writing to registry...
echo [INFO] Registry path: %REG_PATH%
echo [INFO] Value name: %FULL_EXE_PATH%
echo [INFO] Value data: ~ DISABLEDXMAXIMIZEDWINDOWEDMODE
echo.

:: Write disable fullscreen optimization
REG ADD "%REG_PATH%" /v "%FULL_EXE_PATH%" /t REG_SZ /d "~ DISABLEDXMAXIMIZEDWINDOWEDMODE" /f
if errorlevel 1 (
    echo [ERROR] Registry write failed! Error code: %errorlevel%
    goto :error
)

echo.
echo [SUCCESS] Registry written successfully!
echo [SUCCESS] Fullscreen optimization disabled
goto :end

:error
echo.
echo ========================================
echo Operation failed, please check error messages
echo ========================================
goto :end

:end
echo.
timeout /t 1 /nobreak >nul
exit /b 0
endlocal