/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamException;
import com.codedisaster.steamworks.SteamLibraryLoader;
import java.io.PrintStream;

public class SteamAPI {
    private static boolean isRunning = false;
    private static boolean isNativeAPILoaded = false;

    public static boolean loadLibraries(SteamLibraryLoader loader) {
        if (!isNativeAPILoaded) {
            isNativeAPILoaded = loader.loadLibrary("steam_api");
            isNativeAPILoaded = isNativeAPILoaded && loader.loadLibrary("steamworks4j");
        }
        return isNativeAPILoaded;
    }

    public static boolean restartAppIfNecessary(int appId) throws SteamException {
        if (!isNativeAPILoaded) {
            throw new SteamException("Native libraries not loaded.\nEnsure to call SteamAPI.loadLibraries() first!");
        }
        return SteamAPI.nativeRestartAppIfNecessary(appId);
    }

    public static boolean init() throws SteamException {
        return SteamAPI.initEx() == InitResult.OK;
    }

    public static InitResult initEx() throws SteamException {
        if (!isNativeAPILoaded) {
            throw new SteamException("Native libraries not loaded.\nEnsure to call SteamAPI.loadLibraries() first!");
        }
        InitResult result = InitResult.byOrdinal(SteamAPI.nativeInit());
        isRunning = result == InitResult.OK;
        return result;
    }

    public static void shutdown() {
        isRunning = false;
        SteamAPI.nativeShutdown();
    }

    public static boolean isSteamRunning() {
        return SteamAPI.isSteamRunning(false);
    }

    public static boolean isSteamRunning(boolean checkNative) {
        return isRunning && (!checkNative || SteamAPI.isSteamRunningNative());
    }

    public static void printDebugInfo(PrintStream stream) {
        stream.println("  Steam API initialized: " + isRunning);
        stream.println("  Steam client active: " + SteamAPI.isSteamRunning());
    }

    static boolean isIsNativeAPILoaded() {
        return isNativeAPILoaded;
    }

    private static native boolean nativeRestartAppIfNecessary(int var0);

    public static native void releaseCurrentThreadMemory();

    private static native int nativeInit();

    private static native void nativeShutdown();

    public static native void runCallbacks();

    private static native boolean isSteamRunningNative();

    public static enum InitResult {
        OK,
        FailedGeneric,
        NoSteamClient,
        VersionMismatch;

        private static final InitResult[] values;

        static InitResult byOrdinal(int result) {
            return values[result];
        }

        static {
            values = InitResult.values();
        }
    }
}

