/*
 * Decompiled with CFR 0.152.
 */
package com.codedisaster.steamworks;

import com.codedisaster.steamworks.SteamAPINetworkingDebugOutputHook;
import com.codedisaster.steamworks.SteamInterface;
import com.codedisaster.steamworks.SteamNetworkingUtilsCallback;
import com.codedisaster.steamworks.SteamNetworkingUtilsCallbackAdapter;
import com.codedisaster.steamworks.SteamNetworkingUtilsNative;

public class SteamNetworkingUtils
extends SteamInterface {
    private final SteamNetworkingUtilsCallbackAdapter callbackAdapter = new SteamNetworkingUtilsCallbackAdapter(new SteamNetworkingUtilsCallback(){});

    public SteamNetworkingUtils() {
        this.setCallback(SteamNetworkingUtilsNative.createCallback(this.callbackAdapter));
    }

    public void setDebugOutputHook(SteamNetworkingSocketsDebugOutputType detailLevel, SteamAPINetworkingDebugOutputHook debutOutputHook) {
        this.callbackAdapter.setDebugOutputHook(debutOutputHook);
        SteamNetworkingUtilsNative.enableDebugOutputHook(this.callback, debutOutputHook != null, detailLevel.apiIndex);
    }

    @Override
    public void dispose() {
        this.setDebugOutputHook(SteamNetworkingSocketsDebugOutputType.Everything, null);
        super.dispose();
    }

    public static enum SteamNetworkingSocketsDebugOutputType {
        None(0),
        Bug(1),
        Error(2),
        Important(3),
        Warning(4),
        Msg(5),
        Verbose(6),
        Debug(7),
        Everything(8),
        _Force32Bit(Integer.MAX_VALUE);

        private final int apiIndex;

        private SteamNetworkingSocketsDebugOutputType(int apiIndex) {
            this.apiIndex = apiIndex;
        }
    }
}

