/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon;

import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.messages.Languages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.services.analytics.Analytics;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.Payment;
import com.watabou.noosa.Game;
import com.watabou.noosa.audio.Music;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.DeviceCompat;
import com.watabou.utils.GameSettings;
import com.watabou.utils.Point;
import java.util.Locale;

public class SPDSettings
extends GameSettings {
    public static final String KEY_VERSION = "version";
    public static final String KEY_FULLSCREEN = "fullscreen";
    public static final String KEY_LANDSCAPE = "force_landscape";
    public static final String KEY_ZOOM = "zoom";
    public static final String KEY_BRIGHTNESS = "brightness";
    public static final String KEY_GRID = "visual_grid";
    public static final String KEY_CAMERA_FOLLOW = "camera_follow";
    public static final String KEY_SCREEN_SHAKE = "screen_shake";
    public static final String KEY_UI_SIZE = "full_ui";
    public static final String KEY_SCALE = "scale";
    public static final String KEY_QUICK_SWAP = "quickslot_swapper";
    public static final String KEY_FLIPTOOLBAR = "flipped_ui";
    public static final String KEY_FLIPTAGS = "flip_tags";
    public static final String KEY_BARMODE = "toolbar_mode";
    public static final String KEY_SLOTWATERSKIN = "quickslot_waterskin";
    public static final String KEY_SYSTEMFONT = "system_font";
    public static final String KEY_VIBRATION = "vibration";
    public static final String KEY_GAMES_SORT = "games_sort";
    public static final String KEY_LAST_CLASS = "last_class";
    public static final String KEY_CHALLENGES = "challenges";
    public static final String KEY_CUSTOM_SEED = "custom_seed";
    public static final String KEY_LAST_DAILY = "last_daily";
    public static final String KEY_INTRO = "intro";
    public static final String KEY_SUPPORT_NAGGED = "support_nagged";
    public static final String KEY_VICTORY_NAGGED = "victory_nagged";
    public static final String KEY_CONTROLLER_SENS = "controller_sens";
    public static final String KEY_MOVE_SENS = "move_sens";
    public static final String KEY_NEWS = "news";
    public static final String KEY_UPDATES = "updates";
    public static final String KEY_BETAS = "betas";
    public static final String KEY_WIFI = "wifi";
    public static final String KEY_NEWS_LAST_READ = "news_last_read";
    public static final String KEY_MUSIC = "music";
    public static final String KEY_MUSIC_VOL = "music_vol";
    public static final String KEY_SOUND_FX = "soundfx";
    public static final String KEY_SFX_VOL = "sfx_vol";
    public static final String KEY_IGNORE_SILENT = "ignore_silent";
    public static final String KEY_MUSIC_BG = "music_bg";
    public static final String KEY_LANG = "language";
    public static final String KEY_WINDOW_WIDTH = "window_width";
    public static final String KEY_WINDOW_HEIGHT = "window_height";
    public static final String KEY_WINDOW_MAXIMIZED = "window_maximized";
    public static final String KEY_FULLSCREEN_MONITOR = "fullscreen_monitor";
    public static final String KEY_ANALYTICS = "analytics";
    public static final String KEY_NAME = "name";
    public static final String KEY_DONATIONICON = "donation_icon";
    public static final String KEY_GOLDENUI = "golden_ui";

    public static void version(int value) {
        SPDSettings.put((String)KEY_VERSION, (int)value);
    }

    public static int version() {
        return SPDSettings.getInt((String)KEY_VERSION, (int)0);
    }

    public static void fullscreen(boolean value) {
        SPDSettings.put((String)KEY_FULLSCREEN, (boolean)value);
        ShatteredPixelDungeon.updateSystemUI();
    }

    public static boolean fullscreen() {
        return SPDSettings.getBoolean((String)KEY_FULLSCREEN, (boolean)true);
    }

    public static void landscape(boolean value) {
        SPDSettings.put((String)KEY_LANDSCAPE, (boolean)value);
        ((ShatteredPixelDungeon)ShatteredPixelDungeon.instance).updateDisplaySize();
    }

    public static boolean landscape() {
        return SPDSettings.getBoolean((String)KEY_LANDSCAPE, (boolean)false);
    }

    public static void zoom(int value) {
        SPDSettings.put((String)KEY_ZOOM, (int)value);
    }

    public static int zoom() {
        return SPDSettings.getInt((String)KEY_ZOOM, (int)0);
    }

    public static void brightness(int value) {
        SPDSettings.put((String)KEY_BRIGHTNESS, (int)value);
        GameScene.updateFog();
    }

    public static int brightness() {
        return SPDSettings.getInt((String)KEY_BRIGHTNESS, (int)0, (int)-1, (int)1);
    }

    public static void visualGrid(int value) {
        SPDSettings.put((String)KEY_GRID, (int)value);
        GameScene.updateMap();
    }

    public static int visualGrid() {
        return SPDSettings.getInt((String)KEY_GRID, (int)0, (int)-1, (int)2);
    }

    public static void cameraFollow(int value) {
        SPDSettings.put((String)KEY_CAMERA_FOLLOW, (int)value);
    }

    public static int cameraFollow() {
        return SPDSettings.getInt((String)KEY_CAMERA_FOLLOW, (int)4, (int)1, (int)4);
    }

    public static void screenShake(int value) {
        SPDSettings.put((String)KEY_SCREEN_SHAKE, (int)value);
    }

    public static int screenShake() {
        return SPDSettings.getInt((String)KEY_SCREEN_SHAKE, (int)2, (int)0, (int)4);
    }

    public static void interfaceSize(int value) {
        SPDSettings.put((String)KEY_UI_SIZE, (int)value);
    }

    public static int interfaceSize() {
        float hMin;
        float wMin;
        int size = SPDSettings.getInt((String)KEY_UI_SIZE, (int)(DeviceCompat.isDesktop() ? 2 : 0));
        if (size > 0 && Math.min(wMin = (float)Game.width / 360.0f, hMin = (float)Game.height / 200.0f) < 2.0f * Game.density) {
            size = 0;
        }
        return size;
    }

    public static void scale(int value) {
        SPDSettings.put((String)KEY_SCALE, (int)value);
    }

    public static int scale() {
        return SPDSettings.getInt((String)KEY_SCALE, (int)0);
    }

    public static void quickSwapper(boolean value) {
        SPDSettings.put((String)KEY_QUICK_SWAP, (boolean)value);
    }

    public static boolean quickSwapper() {
        return SPDSettings.getBoolean((String)KEY_QUICK_SWAP, (boolean)true);
    }

    public static void flipToolbar(boolean value) {
        SPDSettings.put((String)KEY_FLIPTOOLBAR, (boolean)value);
    }

    public static boolean flipToolbar() {
        return SPDSettings.getBoolean((String)KEY_FLIPTOOLBAR, (boolean)false);
    }

    public static void flipTags(boolean value) {
        SPDSettings.put((String)KEY_FLIPTAGS, (boolean)value);
    }

    public static boolean flipTags() {
        return SPDSettings.getBoolean((String)KEY_FLIPTAGS, (boolean)false);
    }

    public static void toolbarMode(String value) {
        SPDSettings.put((String)KEY_BARMODE, (String)value);
    }

    public static String toolbarMode() {
        return SPDSettings.getString((String)KEY_BARMODE, (String)(PixelScene.landscape() ? "GROUP" : "SPLIT"));
    }

    public static void quickslotWaterskin(boolean value) {
        SPDSettings.put((String)KEY_SLOTWATERSKIN, (boolean)value);
    }

    public static boolean quickslotWaterskin() {
        return SPDSettings.getBoolean((String)KEY_SLOTWATERSKIN, (boolean)true);
    }

    public static void systemFont(boolean value) {
        SPDSettings.put((String)KEY_SYSTEMFONT, (boolean)value);
    }

    public static boolean systemFont() {
        return SPDSettings.getBoolean((String)KEY_SYSTEMFONT, (SPDSettings.language() == Languages.CHI_SMPL || SPDSettings.language() == Languages.CHI_TRAD || SPDSettings.language() == Languages.KOREAN || SPDSettings.language() == Languages.JAPANESE ? 1 : 0) != 0);
    }

    public static void vibration(boolean value) {
        SPDSettings.put((String)KEY_VIBRATION, (boolean)value);
    }

    public static boolean vibration() {
        return SPDSettings.getBoolean((String)KEY_VIBRATION, (boolean)true);
    }

    public static String gamesInProgressSort() {
        return SPDSettings.getString((String)KEY_GAMES_SORT, (String)"level");
    }

    public static void gamesInProgressSort(String value) {
        SPDSettings.put((String)KEY_GAMES_SORT, (String)value);
    }

    public static void intro(boolean value) {
        SPDSettings.put((String)KEY_INTRO, (boolean)value);
    }

    public static boolean intro() {
        return SPDSettings.getBoolean((String)KEY_INTRO, (boolean)true);
    }

    public static void lastClass(int value) {
        SPDSettings.put((String)KEY_LAST_CLASS, (int)value);
    }

    public static int lastClass() {
        return SPDSettings.getInt((String)KEY_LAST_CLASS, (int)0, (int)0, (int)3);
    }

    public static void challenges(int value) {
        SPDSettings.put((String)KEY_CHALLENGES, (int)value);
    }

    public static int challenges() {
        return SPDSettings.getInt((String)KEY_CHALLENGES, (int)0, (int)0, (int)511);
    }

    public static void customSeed(String value) {
        SPDSettings.put((String)KEY_CUSTOM_SEED, (String)value);
    }

    public static String customSeed() {
        return SPDSettings.getString((String)KEY_CUSTOM_SEED, (String)"", (int)20);
    }

    public static void lastDaily(long value) {
        SPDSettings.put((String)KEY_LAST_DAILY, (long)value);
    }

    public static long lastDaily() {
        return SPDSettings.getLong((String)KEY_LAST_DAILY, (long)0L);
    }

    public static void supportNagged(boolean value) {
        SPDSettings.put((String)KEY_SUPPORT_NAGGED, (boolean)value);
    }

    public static boolean supportNagged() {
        return SPDSettings.getBoolean((String)KEY_SUPPORT_NAGGED, (boolean)false);
    }

    public static void victoryNagged(boolean value) {
        SPDSettings.put((String)KEY_VICTORY_NAGGED, (boolean)value);
    }

    public static boolean victoryNagged() {
        return SPDSettings.getBoolean((String)KEY_VICTORY_NAGGED, (boolean)false);
    }

    public static void controllerPointerSensitivity(int value) {
        SPDSettings.put((String)KEY_CONTROLLER_SENS, (int)value);
    }

    public static int controllerPointerSensitivity() {
        return SPDSettings.getInt((String)KEY_CONTROLLER_SENS, (int)5, (int)1, (int)10);
    }

    public static void movementHoldSensitivity(int value) {
        SPDSettings.put((String)KEY_MOVE_SENS, (int)value);
    }

    public static int movementHoldSensitivity() {
        return SPDSettings.getInt((String)KEY_MOVE_SENS, (int)3, (int)0, (int)4);
    }

    public static void news(boolean value) {
        SPDSettings.put((String)KEY_NEWS, (boolean)value);
    }

    public static boolean news() {
        return SPDSettings.getBoolean((String)KEY_NEWS, (boolean)true);
    }

    public static void updates(boolean value) {
        SPDSettings.put((String)KEY_UPDATES, (boolean)value);
    }

    public static boolean updates() {
        return SPDSettings.getBoolean((String)KEY_UPDATES, (boolean)true);
    }

    public static void betas(boolean value) {
        SPDSettings.put((String)KEY_BETAS, (boolean)value);
    }

    public static boolean betas() {
        return SPDSettings.getBoolean((String)KEY_BETAS, (Game.version.contains("BETA") || Game.version.contains("RC") ? 1 : 0) != 0);
    }

    public static void WiFi(boolean value) {
        SPDSettings.put((String)KEY_WIFI, (boolean)value);
    }

    public static boolean WiFi() {
        return SPDSettings.getBoolean((String)KEY_WIFI, (boolean)true);
    }

    public static void newsLastRead(long lastRead) {
        SPDSettings.put((String)KEY_NEWS_LAST_READ, (long)lastRead);
    }

    public static long newsLastRead() {
        return SPDSettings.getLong((String)KEY_NEWS_LAST_READ, (long)0L);
    }

    public static void music(boolean value) {
        Music.INSTANCE.enable(value);
        SPDSettings.put((String)KEY_MUSIC, (boolean)value);
    }

    public static boolean music() {
        return SPDSettings.getBoolean((String)KEY_MUSIC, (boolean)true);
    }

    public static void musicVol(int value) {
        Music.INSTANCE.volume((float)(value * value) / 100.0f);
        SPDSettings.put((String)KEY_MUSIC_VOL, (int)value);
    }

    public static int musicVol() {
        return SPDSettings.getInt((String)KEY_MUSIC_VOL, (int)10, (int)0, (int)10);
    }

    public static void soundFx(boolean value) {
        Sample.INSTANCE.enable(value);
        SPDSettings.put((String)KEY_SOUND_FX, (boolean)value);
    }

    public static boolean soundFx() {
        return SPDSettings.getBoolean((String)KEY_SOUND_FX, (boolean)true);
    }

    public static void SFXVol(int value) {
        Sample.INSTANCE.volume((float)(value * value) / 100.0f);
        SPDSettings.put((String)KEY_SFX_VOL, (int)value);
    }

    public static int SFXVol() {
        return SPDSettings.getInt((String)KEY_SFX_VOL, (int)10, (int)0, (int)10);
    }

    public static void ignoreSilentMode(boolean value) {
        SPDSettings.put((String)KEY_IGNORE_SILENT, (boolean)value);
        Game.platform.setHonorSilentSwitch(!value);
    }

    public static boolean ignoreSilentMode() {
        return SPDSettings.getBoolean((String)KEY_IGNORE_SILENT, (boolean)false);
    }

    public static void playMusicInBackground(boolean value) {
        SPDSettings.put((String)KEY_MUSIC_BG, (boolean)value);
    }

    public static boolean playMusicInBackground() {
        return SPDSettings.getBoolean((String)KEY_MUSIC_BG, (boolean)true);
    }

    public static void language(Languages lang) {
        SPDSettings.put((String)KEY_LANG, (String)lang.code());
    }

    public static Languages language() {
        String code = SPDSettings.getString((String)KEY_LANG, null);
        if (code == null) {
            return Languages.matchLocale(Locale.getDefault());
        }
        return Languages.matchCode(code);
    }

    public static void windowResolution(Point p) {
        SPDSettings.put((String)KEY_WINDOW_WIDTH, (int)p.x);
        SPDSettings.put((String)KEY_WINDOW_HEIGHT, (int)p.y);
    }

    public static Point windowResolution() {
        return new Point(SPDSettings.getInt((String)KEY_WINDOW_WIDTH, (int)800, (int)720, (int)Integer.MAX_VALUE), SPDSettings.getInt((String)KEY_WINDOW_HEIGHT, (int)600, (int)400, (int)Integer.MAX_VALUE));
    }

    public static void windowMaximized(boolean value) {
        SPDSettings.put((String)KEY_WINDOW_MAXIMIZED, (boolean)value);
    }

    public static boolean windowMaximized() {
        return SPDSettings.getBoolean((String)KEY_WINDOW_MAXIMIZED, (boolean)false);
    }

    public static void fulLScreenMonitor(int value) {
        SPDSettings.put((String)KEY_FULLSCREEN_MONITOR, (int)value);
    }

    public static int fulLScreenMonitor() {
        return SPDSettings.getInt((String)KEY_FULLSCREEN_MONITOR, (int)0);
    }

    public static void analytics(boolean value) {
        SPDSettings.put((String)KEY_ANALYTICS, (boolean)value);
    }

    public static boolean analytics() {
        return Analytics.supportsAnalytics() && SPDSettings.getBoolean((String)KEY_ANALYTICS, (boolean)true);
    }

    public static void heroName(HeroClass cls, String value) {
        SPDSettings.put((String)("name_" + String.valueOf((Object)cls)), (String)value);
    }

    public static String heroName(HeroClass cls) {
        if (!Payment.isTierUnlocked(1) || cls == null) {
            return "";
        }
        return SPDSettings.getString((String)("name_" + cls.name()), (String)"", (int)20);
    }

    public static void donationIcon(int value) {
        SPDSettings.put((String)KEY_DONATIONICON, (int)value);
    }

    public static int donationIcon() {
        return Math.min(Payment.getHighestTierUnlocked(), SPDSettings.getInt((String)KEY_DONATIONICON, (int)0, (int)0, (int)3));
    }

    public static void goldenUI(boolean value) {
        SPDSettings.put((String)KEY_GOLDENUI, (boolean)value);
    }

    public static boolean goldenUI() {
        return Payment.isTierUnlocked(3) && SPDSettings.getBoolean((String)KEY_GOLDENUI, (boolean)true);
    }
}

