/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.effects.particles;

import com.watabou.noosa.particles.Emitter;
import com.watabou.noosa.particles.PixelParticle;
import com.watabou.utils.ColorMath;
import com.watabou.utils.Random;

public class PurpleParticle
extends PixelParticle {
    public static final Emitter.Factory MISSILE = new Emitter.Factory(){

        public void emit(Emitter emitter, int index, float x, float y) {
            ((PurpleParticle)emitter.recycle(PurpleParticle.class)).reset(x, y);
        }
    };
    public static final Emitter.Factory BURST = new Emitter.Factory(){

        public void emit(Emitter emitter, int index, float x, float y) {
            ((PurpleParticle)emitter.recycle(PurpleParticle.class)).resetBurst(x, y);
        }

        public boolean lightMode() {
            return true;
        }
    };

    public PurpleParticle() {
        this.lifespan = 0.5f;
    }

    public void reset(float x, float y) {
        this.revive();
        this.x = x;
        this.y = y;
        this.speed.set(Random.Float((float)-5.0f, (float)5.0f), Random.Float((float)-5.0f, (float)5.0f));
        this.left = this.lifespan;
    }

    public void resetBurst(float x, float y) {
        this.revive();
        this.x = x;
        this.y = y;
        this.speed.polar(Random.Float((float)6.283185f), Random.Float((float)16.0f, (float)32.0f));
        this.left = this.lifespan;
    }

    public void update() {
        super.update();
        this.am = this.left / this.lifespan;
        this.size(5.0f - this.am * 4.0f);
        this.color(ColorMath.interpolate((int)0x220066, (int)0xFF0044, (float)this.am));
    }
}

