/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.effects.particles;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.watabou.noosa.particles.Emitter;
import com.watabou.noosa.particles.PixelParticle;
import com.watabou.utils.ColorMath;
import com.watabou.utils.Random;

public class SpectralWallParticle
extends PixelParticle {
    public static final Emitter.Factory FACTORY = new Emitter.Factory(){

        public void emit(Emitter emitter, int index, float x, float y) {
            int type = 1 + Dungeon.depth / 5;
            if (type > 5) {
                type = 5;
            }
            switch (type) {
                case 1: {
                    if (Random.Int((int)2) == 0) break;
                    return;
                }
                case 2: {
                    if (Random.Int((int)3) == 0) break;
                    return;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    if (Random.Int((int)4) == 0) break;
                    return;
                }
            }
            ((SpectralWallParticle)emitter.recycle(SpectralWallParticle.class)).reset(x, y);
        }

        public boolean lightMode() {
            return false;
        }
    };
    private int type = 0;

    public SpectralWallParticle() {
        this.lifespan = 4.0f;
        this.am = 0.6f;
    }

    public void reset(float x, float y) {
        this.revive();
        this.type = 1 + Dungeon.depth / 5;
        if (this.type > 5) {
            this.type = 5;
        }
        this.x = x;
        this.y = y;
        this.left = this.lifespan;
        switch (this.type) {
            case 1: {
                this.x = Math.round(x / 7.0f) * 7;
                this.y = Math.round(y / 4.0f) * 4 - 6;
                this.x += (float)Math.round(this.y % 8.0f) / 4.0f - 1.0f;
                this.color(ColorMath.random((int)0xD4D4D4, (int)0xABABAB));
                break;
            }
            case 2: {
                this.x = Math.round(x / 7.0f) * 7;
                this.y = Math.round(y / 6.0f) * 6 - 6;
                this.x += (float)Math.round(this.y % 8.0f) / 4.0f - 1.0f;
                this.color(ColorMath.random((int)12893852, (int)10261117));
                break;
            }
            case 3: {
                this.y -= 6.0f;
                float colorScale = this.x % 16.0f / 16.0f + this.y % 16.0f / 16.0f;
                if (colorScale > 1.0f) {
                    colorScale = 2.0f - colorScale;
                }
                this.color(ColorMath.interpolate((int)12038309, (int)0x6A6662, (float)colorScale));
                break;
            }
            case 4: {
                this.x = Math.round(x / 4.0f) * 4;
                this.y = Math.round(y / 4.0f) * 4 - 6;
                this.x += (float)Math.round(this.y % 16.0f) / 4.0f - 2.0f;
                this.color(ColorMath.interpolate((float)1.3679779E7f, (int[])new int[]{10718593}));
                break;
            }
            case 5: {
                this.x = Math.round(x / 4.0f) * 4;
                this.y = Math.round((y + 8.0f) / 16.0f) * 16 - 14;
                this.color(ColorMath.interpolate((float)1.0654845E7f, (int[])new int[]{5851207}));
            }
        }
    }

    public void update() {
        super.update();
        float sizeFactor = this.left / this.lifespan;
        switch (this.type) {
            case 1: {
                this.scale.set(sizeFactor * 6.0f, sizeFactor * 3.0f);
                break;
            }
            case 2: {
                this.scale.set(sizeFactor * 6.0f, sizeFactor * 5.0f);
                break;
            }
            case 3: {
                this.scale.set(sizeFactor * 4.0f, sizeFactor * 4.0f);
                break;
            }
            case 4: {
                this.scale.set(sizeFactor * 3.0f, sizeFactor * 3.0f);
                break;
            }
            case 5: {
                this.scale.set(sizeFactor * 4.0f, sizeFactor * 20.0f);
            }
        }
    }
}

