/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.rooms.quest;

import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Skeleton;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Gold;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfLiquidFlame;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.CorpseDust;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.SpecialRoom;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.tiles.CustomTilemap;
import com.watabou.noosa.Image;
import com.watabou.noosa.Tilemap;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class MassGraveRoom
extends SpecialRoom {
    @Override
    public int minWidth() {
        return 7;
    }

    @Override
    public int minHeight() {
        return 7;
    }

    @Override
    public void paint(Level level) {
        Room.Door entrance = this.entrance();
        entrance.set(Room.Door.Type.BARRICADE);
        level.addItemToSpawn(new PotionOfLiquidFlame());
        Painter.fill(level, this, 4);
        Painter.fill(level, this, 1, 32);
        Bones b = new Bones();
        b.setRect(this.left + 1, this.top, this.width() - 2, this.height() - 1);
        level.customTiles.add(b);
        for (int i = 0; i <= Random.Int((int)2); ++i) {
            int pos;
            Skeleton skele = new Skeleton();
            while (level.map[pos = level.pointToCell(this.random())] != 32 || level.findMob(pos) != null) {
            }
            skele.pos = pos;
            level.mobs.add(skele);
        }
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(new CorpseDust());
        items.add(new Gold(1));
        items.add(new Gold(1));
        if (Random.Float() <= 0.3f) {
            items.add(new Gold());
        }
        if (Random.Float() <= 0.3f) {
            items.add(new Gold());
        }
        if (Random.Float() <= 0.6f) {
            items.add(Generator.random());
        }
        if (Random.Float() <= 0.3f) {
            items.add(Generator.randomArmor());
        }
        for (Item item : items) {
            int pos;
            while (level.map[pos = level.pointToCell(this.random())] != 32 || level.heaps.get(pos) != null) {
            }
            Heap h = level.drop(item, pos);
            h.setHauntedIfCursed();
            h.type = Heap.Type.SKELETON;
        }
    }

    @Override
    public boolean canConnect(Room r) {
        if (r.isEntrance()) {
            return false;
        }
        for (Room r1 : r.connected.keySet()) {
            if (r1.isEntrance()) {
                return false;
            }
            for (Room r2 : r1.connected.keySet()) {
                if (r2.isEntrance()) {
                    return false;
                }
                for (Room r3 : r2.connected.keySet()) {
                    if (!r3.isEntrance()) continue;
                    return false;
                }
            }
        }
        return super.canConnect(r);
    }

    public static class Bones
    extends CustomTilemap {
        private static final int WALL_OVERLAP = 3;
        private static final int FLOOR = 7;

        public Bones() {
            this.texture = "environment/custom_tiles/prison_quest.png";
        }

        @Override
        public Tilemap create() {
            Tilemap v = super.create();
            int[] data = new int[this.tileW * this.tileH];
            for (int i = 0; i < data.length; ++i) {
                data[i] = i < this.tileW ? 3 : 7;
            }
            v.map(data, this.tileW);
            return v;
        }

        @Override
        public Image image(int tileX, int tileY) {
            if (tileY == 0) {
                return null;
            }
            return super.image(tileX, tileY);
        }

        @Override
        public String name(int tileX, int tileY) {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc(int tileX, int tileY) {
            return Messages.get(this, "desc", new Object[0]);
        }
    }
}

