/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard;

import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.StandardRoom;
import com.watabou.utils.Point;
import com.watabou.utils.Random;
import com.watabou.utils.Rect;

public class SegmentedLibraryRoom
extends StandardRoom {
    @Override
    public float[] sizeCatProbs() {
        return new float[]{0.0f, 3.0f, 1.0f};
    }

    @Override
    public void paint(Level level) {
        Painter.fill(level, this, 4);
        Painter.fill(level, this, 1, 27);
        Painter.fill(level, this, 2, 14);
        for (Room.Door door : this.connected.values()) {
            door.set(Room.Door.Type.REGULAR);
            Painter.drawInside(level, this, door, 2, 14);
        }
        this.createWalls(level, new Rect(this.left + 2, this.top + 2, this.right - 2, this.bottom - 2));
    }

    private void createWalls(Level level, Rect area) {
        if (Math.max(area.width() + 1, area.height() + 1) < 4 || Math.min(area.width() + 1, area.height() + 1) < 3) {
            return;
        }
        int tries = 10;
        if (area.width() > area.height() || area.width() == area.height() && Random.Int((int)2) == 0) {
            do {
                int splitX;
                if (level.map[(splitX = Random.IntRange((int)(area.left + 2), (int)(area.right - 2))) + level.width() * (area.top - 1)] != 27 || level.map[splitX + level.width() * (area.bottom + 1)] != 27) continue;
                tries = 0;
                Painter.drawLine(level, new Point(splitX, area.top), new Point(splitX, area.bottom), 27);
                int spaceTop = Random.IntRange((int)area.top, (int)(area.bottom - 1));
                Painter.set(level, splitX, spaceTop, 14);
                this.createWalls(level, new Rect(area.left, area.top, splitX - 1, area.bottom));
                this.createWalls(level, new Rect(splitX + 1, area.top, area.right, area.bottom));
            } while (--tries > 0);
        } else {
            do {
                int splitY = Random.IntRange((int)(area.top + 2), (int)(area.bottom - 2));
                if (level.map[area.left - 1 + level.width() * splitY] != 27 || level.map[area.right + 1 + level.width() * splitY] != 27) continue;
                tries = 0;
                Painter.drawLine(level, new Point(area.left, splitY), new Point(area.right, splitY), 27);
                int spaceLeft = Random.IntRange((int)area.left, (int)(area.right - 1));
                Painter.set(level, spaceLeft, splitY, 14);
                this.createWalls(level, new Rect(area.left, area.top, area.right, splitY - 1));
                this.createWalls(level, new Rect(area.left, splitY + 1, area.right, area.bottom));
            } while (--tries > 0);
        }
    }
}

