/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.scenes;

import com.shatteredpixel.shatteredpixeldungeon.Chrome;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Languages;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.TitleScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.ExitButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.ScrollPane;
import com.shatteredpixel.shatteredpixeldungeon.ui.StyledButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.TitleBackground;
import com.shatteredpixel.shatteredpixeldungeon.ui.changelist.ChangeInfo;
import com.shatteredpixel.shatteredpixeldungeon.ui.changelist.WndChanges;
import com.shatteredpixel.shatteredpixeldungeon.ui.changelist.WndChangesTabbed;
import com.shatteredpixel.shatteredpixeldungeon.ui.changelist.v0_1_X_Changes;
import com.shatteredpixel.shatteredpixeldungeon.ui.changelist.v0_2_X_Changes;
import com.shatteredpixel.shatteredpixeldungeon.ui.changelist.v0_3_X_Changes;
import com.shatteredpixel.shatteredpixeldungeon.ui.changelist.v0_4_X_Changes;
import com.shatteredpixel.shatteredpixeldungeon.ui.changelist.v0_5_X_Changes;
import com.shatteredpixel.shatteredpixeldungeon.ui.changelist.v0_6_X_Changes;
import com.shatteredpixel.shatteredpixeldungeon.ui.changelist.v0_7_X_Changes;
import com.shatteredpixel.shatteredpixeldungeon.ui.changelist.v0_8_X_Changes;
import com.shatteredpixel.shatteredpixeldungeon.ui.changelist.v0_9_X_Changes;
import com.shatteredpixel.shatteredpixeldungeon.ui.changelist.v1_X_Changes;
import com.shatteredpixel.shatteredpixeldungeon.ui.changelist.v2_X_Changes;
import com.shatteredpixel.shatteredpixeldungeon.ui.changelist.v3_X_Changes;
import com.shatteredpixel.shatteredpixeldungeon.windows.IconTitle;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;
import com.watabou.noosa.NinePatch;
import com.watabou.noosa.Scene;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Music;
import com.watabou.noosa.ui.Component;
import com.watabou.utils.RectF;
import java.util.ArrayList;

public class ChangesScene
extends PixelScene {
    public static int changesSelected = 0;
    private NinePatch rightPanel;
    private ScrollPane rightScroll;
    private IconTitle changeTitle;
    private RenderedTextBlock changeBody;

    @Override
    public void create() {
        super.create();
        Music.INSTANCE.playTracks(new String[]{"music/theme_1.ogg", "music/theme_2.ogg"}, new float[]{1.0f, 1.0f}, false);
        int w = Camera.main.width;
        int h = Camera.main.height;
        RectF insets = this.getCommonInsets();
        TitleBackground BG = new TitleBackground(w, h);
        w = (int)((float)w - (insets.left + insets.right));
        h = (int)((float)h - (insets.top + insets.bottom));
        IconTitle title = new IconTitle(Icons.CHANGES.get(), Messages.get((Object)this, "title", new Object[0]));
        title.setSize(200.0f, 0.0f);
        title.setPos(insets.left + ((float)w - title.reqWidth()) / 2.0f, insets.top + (20.0f - title.height()) / 2.0f);
        ChangesScene.align(title);
        this.add((Gizmo)title);
        ExitButton btnExit = new ExitButton();
        btnExit.setPos(insets.left + (float)w - btnExit.width(), insets.top);
        this.add((Gizmo)btnExit);
        NinePatch panel = Chrome.get(Chrome.Type.TOAST);
        int pw = 135 + panel.marginLeft() + panel.marginRight() - 2;
        int ph = h - 36;
        if ((float)h >= 200.0f && w >= 300) {
            panel.size((float)pw, (float)ph);
            panel.x = insets.left + (float)(w - pw) / 2.0f - (float)(pw / 2) - 1.0f;
            panel.y = insets.top + 20.0f;
            this.rightPanel = Chrome.get(Chrome.Type.TOAST);
            this.rightPanel.size((float)pw, (float)ph);
            this.rightPanel.x = (float)(w - pw) / 2.0f + (float)(pw / 2) + 1.0f;
            this.rightPanel.y = 20.0f;
            this.add((Gizmo)this.rightPanel);
            this.rightScroll = new ScrollPane(new Component());
            this.add((Gizmo)this.rightScroll);
            this.rightScroll.setRect(this.rightPanel.x + (float)this.rightPanel.marginLeft(), this.rightPanel.y + (float)this.rightPanel.marginTop() - 1.0f, this.rightPanel.innerWidth() + 2.0f, this.rightPanel.innerHeight() + 2.0f);
            this.rightScroll.scrollTo(0.0f, 0.0f);
            this.changeTitle = new IconTitle(Icons.get(Icons.CHANGES), Messages.get((Object)this, "right_title", new Object[0]));
            this.changeTitle.setPos(0.0f, 1.0f);
            this.changeTitle.setSize(pw, 20.0f);
            this.rightScroll.content().add((Gizmo)this.changeTitle);
            String body = Messages.get((Object)this, "right_body", new Object[0]);
            this.changeBody = PixelScene.renderTextBlock(body, 6);
            this.changeBody.maxWidth(pw - panel.marginHor());
            this.changeBody.setPos(0.0f, this.changeTitle.bottom() + 2.0f);
            this.rightScroll.content().add((Gizmo)this.changeBody);
        } else {
            panel.size((float)pw, (float)ph);
            panel.x = insets.left + (float)(w - pw) / 2.0f;
            panel.y = insets.top + 20.0f;
        }
        ChangesScene.align((Visual)panel);
        this.add((Gizmo)panel);
        final ArrayList<ChangeInfo> changeInfos = new ArrayList<ChangeInfo>();
        if (Messages.lang() != Languages.ENGLISH) {
            ChangeInfo langWarn = new ChangeInfo("", true, Messages.get((Object)this, "lang_warn", new Object[0]));
            langWarn.hardlight(0xFF8800);
            changeInfos.add(langWarn);
        }
        switch (changesSelected) {
            default: {
                v3_X_Changes.addAllChanges(changeInfos);
                break;
            }
            case 1: {
                v2_X_Changes.addAllChanges(changeInfos);
                break;
            }
            case 2: {
                v1_X_Changes.addAllChanges(changeInfos);
                break;
            }
            case 3: {
                v0_9_X_Changes.addAllChanges(changeInfos);
                break;
            }
            case 4: {
                v0_8_X_Changes.addAllChanges(changeInfos);
                break;
            }
            case 5: {
                v0_7_X_Changes.addAllChanges(changeInfos);
                break;
            }
            case 6: {
                v0_6_X_Changes.addAllChanges(changeInfos);
                break;
            }
            case 7: {
                v0_5_X_Changes.addAllChanges(changeInfos);
                v0_4_X_Changes.addAllChanges(changeInfos);
                v0_3_X_Changes.addAllChanges(changeInfos);
                v0_2_X_Changes.addAllChanges(changeInfos);
                v0_1_X_Changes.addAllChanges(changeInfos);
            }
        }
        ScrollPane list = new ScrollPane(new Component()){

            @Override
            public void onClick(float x, float y) {
                for (ChangeInfo info : changeInfos) {
                    if (!info.onClick(x, y)) continue;
                    return;
                }
            }
        };
        this.add((Gizmo)list);
        Component content = list.content();
        content.clear();
        float posY = 0.0f;
        float nextPosY = 0.0f;
        boolean second = false;
        for (ChangeInfo info : changeInfos) {
            if (info.major) {
                posY = nextPosY;
                second = false;
                info.setRect(0.0f, posY, panel.innerWidth(), 0.0f);
                content.add((Gizmo)info);
                posY = nextPosY = info.bottom();
                continue;
            }
            if (!second) {
                second = true;
                info.setRect(0.0f, posY, panel.innerWidth() / 2.0f, 0.0f);
                content.add((Gizmo)info);
                nextPosY = info.bottom();
                continue;
            }
            second = false;
            info.setRect(panel.innerWidth() / 2.0f, posY, panel.innerWidth() / 2.0f, 0.0f);
            content.add((Gizmo)info);
            posY = nextPosY = Math.max(info.bottom(), nextPosY);
        }
        content.setSize(panel.innerWidth(), (float)((int)Math.ceil(posY)));
        list.setRect(panel.x + (float)panel.marginLeft(), panel.y + (float)panel.marginTop() - 1.0f, panel.innerWidth() + 2.0f, panel.innerHeight() + 2.0f);
        list.scrollTo(0.0f, 0.0f);
        StyledButton btn3_X = new StyledButton(Chrome.Type.GREY_BUTTON_TR, "3.X", 8){

            @Override
            protected void onClick() {
                super.onClick();
                if (changesSelected != 0) {
                    changesSelected = 0;
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }
        };
        if (changesSelected != 0) {
            btn3_X.textColor(0xBBBBBB);
        }
        btn3_X.setRect(list.left() - 4.0f, list.bottom(), 19.0f, changesSelected == 0 ? 19.0f : 15.0f);
        this.addToBack((Gizmo)btn3_X);
        StyledButton btn2_X = new StyledButton(Chrome.Type.GREY_BUTTON_TR, "2.X", 8){

            @Override
            protected void onClick() {
                super.onClick();
                if (changesSelected != 1) {
                    changesSelected = 1;
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }
        };
        if (changesSelected != 1) {
            btn2_X.textColor(0xBBBBBB);
        }
        btn2_X.setRect(btn3_X.right() - 2.0f, list.bottom(), 19.0f, changesSelected == 1 ? 19.0f : 15.0f);
        this.addToBack((Gizmo)btn2_X);
        StyledButton btn1_X = new StyledButton(Chrome.Type.GREY_BUTTON_TR, "1.X", 8){

            @Override
            protected void onClick() {
                super.onClick();
                if (changesSelected != 2) {
                    changesSelected = 2;
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }
        };
        if (changesSelected != 2) {
            btn1_X.textColor(0xBBBBBB);
        }
        btn1_X.setRect(btn2_X.right() - 2.0f, list.bottom(), 19.0f, changesSelected == 2 ? 19.0f : 15.0f);
        this.addToBack((Gizmo)btn1_X);
        StyledButton btn0_9 = new StyledButton(Chrome.Type.GREY_BUTTON_TR, "0.9", 8){

            @Override
            protected void onClick() {
                super.onClick();
                if (changesSelected != 3) {
                    changesSelected = 3;
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }
        };
        if (changesSelected != 3) {
            btn0_9.textColor(0xBBBBBB);
        }
        btn0_9.setRect(btn1_X.right() - 2.0f, list.bottom(), 19.0f, changesSelected == 3 ? 19.0f : 15.0f);
        this.addToBack((Gizmo)btn0_9);
        StyledButton btn0_8 = new StyledButton(Chrome.Type.GREY_BUTTON_TR, "0.8", 8){

            @Override
            protected void onClick() {
                super.onClick();
                if (changesSelected != 4) {
                    changesSelected = 4;
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }
        };
        if (changesSelected != 4) {
            btn0_8.textColor(0xBBBBBB);
        }
        btn0_8.setRect(btn0_9.right() - 2.0f, list.bottom(), 19.0f, changesSelected == 4 ? 19.0f : 15.0f);
        this.addToBack((Gizmo)btn0_8);
        StyledButton btn0_7 = new StyledButton(Chrome.Type.GREY_BUTTON_TR, "0.7", 8){

            @Override
            protected void onClick() {
                super.onClick();
                if (changesSelected != 5) {
                    changesSelected = 5;
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }
        };
        if (changesSelected != 5) {
            btn0_7.textColor(0xBBBBBB);
        }
        btn0_7.setRect(btn0_8.right() - 2.0f, btn0_8.top(), 19.0f, changesSelected == 5 ? 19.0f : 15.0f);
        this.addToBack((Gizmo)btn0_7);
        StyledButton btn0_6 = new StyledButton(Chrome.Type.GREY_BUTTON_TR, "0.6", 8){

            @Override
            protected void onClick() {
                super.onClick();
                if (changesSelected != 6) {
                    changesSelected = 6;
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }
        };
        if (changesSelected != 6) {
            btn0_6.textColor(0xBBBBBB);
        }
        btn0_6.setRect(btn0_7.right() - 2.0f, btn0_8.top(), 19.0f, changesSelected == 6 ? 19.0f : 15.0f);
        this.addToBack((Gizmo)btn0_6);
        StyledButton btnOld = new StyledButton(Chrome.Type.GREY_BUTTON_TR, "0.5-", 8){

            @Override
            protected void onClick() {
                super.onClick();
                if (changesSelected != 7) {
                    changesSelected = 7;
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }
        };
        if (changesSelected != 7) {
            btnOld.textColor(0xBBBBBB);
        }
        btnOld.setRect(btn0_6.right() - 2.0f, btn0_8.top(), 22.0f, changesSelected == 7 ? 19.0f : 15.0f);
        this.addToBack((Gizmo)btnOld);
        this.addToBack((Gizmo)BG);
        this.fadeIn();
    }

    private void updateChangesText(Image icon, String title, String ... messages) {
        if (this.changeTitle != null) {
            this.changeTitle.icon(icon);
            this.changeTitle.label(title);
            this.changeTitle.setPos(this.changeTitle.left(), this.changeTitle.top());
            Object message = "";
            for (int i = 0; i < messages.length; ++i) {
                message = (String)message + messages[i];
                if (i == messages.length - 1) continue;
                message = (String)message + "\n\n";
            }
            this.changeBody.text((String)message);
            this.rightScroll.content().setSize(this.rightScroll.width(), this.changeBody.bottom() + 2.0f);
            this.rightScroll.setSize(this.rightScroll.width(), this.rightScroll.height());
            this.rightScroll.scrollTo(0.0f, 0.0f);
        } else if (messages.length == 1) {
            this.addToFront((Gizmo)new WndChanges(icon, title, messages[0]));
        } else {
            this.addToFront((Gizmo)new WndChangesTabbed(icon, title, messages));
        }
    }

    public static void showChangeInfo(Image icon, String title, String ... messages) {
        Scene s = ShatteredPixelDungeon.scene();
        if (s instanceof ChangesScene) {
            ((ChangesScene)s).updateChangesText(icon, title, messages);
            return;
        }
        if (messages.length == 1) {
            s.addToFront((Gizmo)new WndChanges(icon, title, messages[0]));
        } else {
            s.addToFront((Gizmo)new WndChangesTabbed(icon, title, messages));
        }
    }

    protected void onBackPressed() {
        ShatteredPixelDungeon.switchNoFade(TitleScene.class);
    }
}

