/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.scenes;

import com.shatteredpixel.shatteredpixeldungeon.Rankings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.RankingsScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.TitleScene;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.Payment;
import com.shatteredpixel.shatteredpixeldungeon.services.sync.Sync;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.ExitButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.IconButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.TitleBackground;
import com.shatteredpixel.shatteredpixeldungeon.windows.IconTitle;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;
import com.watabou.utils.GameMath;
import com.watabou.utils.RectF;

public class HallOfHeroesScene
extends PixelScene {
    private static final float ROW_HEIGHT_MAX = 20.0f;
    private static final float ROW_HEIGHT_MIN = 12.0f;
    private static final float MAX_ROW_WIDTH = 160.0f;
    private static final float GAP = 4.0f;
    public static int page = 0;
    public static final int MAX_PAGES = 10;
    public static boolean inHOH = false;

    public static int pagesAvailable() {
        switch (Payment.getHighestTierUnlocked()) {
            default: {
                return 0;
            }
            case 2: {
                return 4;
            }
            case 3: 
        }
        return 10;
    }

    @Override
    public void create() {
        super.create();
        inHOH = true;
        HallOfHeroesScene.uiCamera.visible = false;
        int w = Camera.main.width;
        int h = Camera.main.height;
        RectF insets = this.getCommonInsets();
        TitleBackground BG = new TitleBackground(w, h);
        this.add((Gizmo)BG);
        w = (int)((float)w - (insets.left + insets.right));
        h = (int)((float)h - (insets.top + insets.bottom));
        Rankings.INSTANCE.loadHall();
        IconTitle title = new IconTitle(Icons.BLANKAMMY.get(), Messages.get((Object)this, "title", new Object[0]));
        title.color(0x3399FF);
        title.setSize(200.0f, 0.0f);
        title.setPos(insets.left + ((float)w - title.reqWidth()) / 2.0f, insets.top + (20.0f - title.height()) / 2.0f);
        HallOfHeroesScene.align(title);
        this.add((Gizmo)title);
        if (!Rankings.INSTANCE.hallRecords.get(page).isEmpty()) {
            float rowHeight = GameMath.gate((float)12.0f, (float)((h - 26) / Rankings.INSTANCE.hallRecords.get(page).size()), (float)20.0f);
            float left = ((float)w - Math.min(160.0f, (float)w)) / 2.0f + 4.0f;
            float top = ((float)h - rowHeight * (float)Rankings.INSTANCE.hallRecords.get(page).size()) / 2.0f;
            int pos = 0;
            for (Rankings.Record rec : Rankings.INSTANCE.hallRecords.get(page)) {
                HallRecord row = new HallRecord(pos, rec);
                float offset = 0.0f;
                if (rowHeight <= 14.0f) {
                    offset = pos % 2 == 1 ? 5.0f : -5.0f;
                }
                row.setRect(insets.left + left + offset, insets.top + top + (float)pos * rowHeight, (float)w - left * 2.0f, rowHeight);
                this.add((Gizmo)row);
                ++pos;
            }
        } else {
            RenderedTextBlock noRec = PixelScene.renderTextBlock(Messages.get((Object)this, "no_games", new Object[0]), 8);
            noRec.hardlight(0x3399FF);
            noRec.setPos(insets.left + ((float)w - noRec.width()) / 2.0f, insets.top + ((float)h - noRec.height()) / 2.0f);
            HallOfHeroesScene.align(noRec);
            this.add((Gizmo)noRec);
        }
        ExitButton btnExit = new ExitButton(){

            @Override
            protected void onClick() {
                inHOH = false;
                ShatteredPixelDungeon.switchScene(RankingsScene.class);
            }
        };
        btnExit.setPos((float)Camera.main.width - btnExit.width() - insets.right, insets.top);
        this.add((Gizmo)btnExit);
        RenderedTextBlock pageDisp = PixelScene.renderTextBlock(Messages.get((Object)this, "page", page + 1, HallOfHeroesScene.pagesAvailable()), 8);
        pageDisp.hardlight(0x3399FF);
        pageDisp.setPos(insets.left + ((float)w - pageDisp.width()) / 2.0f, insets.top + (float)h - pageDisp.height() - 8.0f);
        HallOfHeroesScene.align(pageDisp);
        this.add((Gizmo)pageDisp);
        int BTN_SIZE = 20;
        IconButton btnNext = new IconButton(Icons.RIGHTARROW.get()){

            @Override
            protected void onClick() {
                if (++page >= HallOfHeroesScene.pagesAvailable()) {
                    page = 0;
                }
                ShatteredPixelDungeon.switchNoFade(HallOfHeroesScene.class);
            }
        };
        btnNext.setRect(insets.left + (float)w - 8.0f - (float)BTN_SIZE, insets.top + (float)h - 1.0f - (float)BTN_SIZE, BTN_SIZE, BTN_SIZE);
        this.add((Gizmo)btnNext);
        IconButton btnPrev = new IconButton(Icons.LEFTARROW.get()){

            @Override
            protected void onClick() {
                if (--page < 0) {
                    page = Math.max(0, HallOfHeroesScene.pagesAvailable() - 1);
                }
                ShatteredPixelDungeon.switchNoFade(HallOfHeroesScene.class);
            }
        };
        btnPrev.setRect(insets.left + 8.0f, insets.top + (float)h - 1.0f - (float)BTN_SIZE, BTN_SIZE, BTN_SIZE);
        this.add((Gizmo)btnPrev);
        this.fadeIn();
    }

    protected void onBackPressed() {
        inHOH = false;
        Sync.syncHallOfHeroes();
        ShatteredPixelDungeon.switchScene(TitleScene.class);
    }

    public void onPause() {
        Sync.syncHallOfHeroes();
    }

    public class HallRecord
    extends RankingsScene.Record {
        public HallRecord(int pos, Rankings.Record rec) {
            super(pos, false, rec);
        }

        @Override
        protected void createChildren() {
            super.createChildren();
            this.shield.copy((Image)new ItemSprite(ItemSpriteSheet.GRAVE, null));
        }
    }
}

