/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.ui;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.watabou.noosa.ColorBlock;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.ui.Component;

public class HealthBar
extends Component {
    private static final int COLOR_BG = -3407872;
    private static final int COLOR_HP = -16716288;
    private static final int COLOR_SHLD = -1;
    private static final int HEIGHT = 2;
    private ColorBlock Bg;
    private ColorBlock Shld;
    private ColorBlock Hp;
    private float health;
    private float shield;

    protected void createChildren() {
        this.Bg = new ColorBlock(1.0f, 1.0f, -3407872);
        this.add((Gizmo)this.Bg);
        this.Shld = new ColorBlock(1.0f, 1.0f, -1);
        this.add((Gizmo)this.Shld);
        this.Hp = new ColorBlock(1.0f, 1.0f, -16716288);
        this.add((Gizmo)this.Hp);
        this.height = 2.0f;
    }

    protected void layout() {
        this.Shld.x = this.Hp.x = this.x;
        this.Bg.x = this.Hp.x;
        this.Shld.y = this.Hp.y = this.y;
        this.Bg.y = this.Hp.y;
        this.Bg.size(this.width, this.height);
        float pixelWidth = this.width;
        if (this.camera() != null) {
            pixelWidth *= this.camera().zoom;
        }
        this.Shld.size(this.width * (float)Math.ceil(this.shield * pixelWidth) / pixelWidth, this.height);
        this.Hp.size(this.width * (float)Math.ceil(this.health * pixelWidth) / pixelWidth, this.height);
    }

    public void level(float value) {
        this.level(value, 0.0f);
    }

    public void level(float health, float shield) {
        this.health = health;
        this.shield = shield;
        this.layout();
    }

    public void level(Char c) {
        float health = c.HP;
        float shield = c.shielding();
        float max = Math.max(health + shield, (float)c.HT);
        this.level(health / max, (health + shield) / max);
    }
}

