/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.ui;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.trinkets.Trinket;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.Wand;
import com.shatteredpixel.shatteredpixeldungeon.journal.Notes;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.SupporterScene;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.Payment;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.ui.CustomNoteButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.IconButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndGame;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTextInput;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTitledMessage;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndUseItem;
import com.watabou.noosa.Image;

public class ItemJournalButton
extends IconButton {
    Item item;
    Window parentWnd;

    public ItemJournalButton(Item item, Window parentWnd) {
        super(Icons.JOURNAL.get());
        this.item = item;
        this.parentWnd = parentWnd;
    }

    @Override
    protected void onClick() {
        if (Payment.isTierUnlocked(2) && (this.item instanceof EquipableItem || this.item instanceof Wand || this.item instanceof Trinket)) {
            GameScene.show(new WndOptions((Image)new ItemSprite(this.item), Messages.titleCase(this.item.name()), null, new String[]{Messages.get(WndGame.class, "rename_item", new Object[0]), Messages.get(WndGame.class, "custom_note", new Object[0])}){

                @Override
                protected void onSelect(int index) {
                    if (index == 0) {
                        GameScene.show(new WndTextInput(Messages.get(WndGame.class, "dialog_title", new Object[0]), null, ItemJournalButton.this.item.name(), 30, false, Messages.get(WndGame.class, "dialog_rename", new Object[0]), Messages.get(WndGame.class, "dialog_revert", new Object[0])){

                            @Override
                            public void onSelect(boolean positive, String text) {
                                if (positive) {
                                    if (ItemJournalButton.this.item instanceof EquipableItem) {
                                        ((EquipableItem)ItemJournalButton.this.item).customName = text;
                                    } else if (ItemJournalButton.this.item instanceof Wand) {
                                        ((Wand)ItemJournalButton.this.item).customName = text;
                                    } else if (ItemJournalButton.this.item instanceof Trinket) {
                                        ((Trinket)ItemJournalButton.this.item).customName = text;
                                    }
                                } else if (ItemJournalButton.this.item instanceof EquipableItem) {
                                    ((EquipableItem)ItemJournalButton.this.item).customName = "";
                                } else if (ItemJournalButton.this.item instanceof Wand) {
                                    ((Wand)ItemJournalButton.this.item).customName = "";
                                } else if (ItemJournalButton.this.item instanceof Trinket) {
                                    ((Trinket)ItemJournalButton.this.item).customName = "";
                                }
                                if (ItemJournalButton.this.parentWnd instanceof WndUseItem) {
                                    GameScene.show(new WndUseItem(((WndUseItem)ItemJournalButton.this.parentWnd).owner, ItemJournalButton.this.item));
                                }
                            }
                        });
                    } else if (index == 1) {
                        ItemJournalButton.this.customNote();
                    }
                }
            });
        } else {
            this.customNote();
        }
    }

    private void customNote() {
        Notes.CustomRecord note = null;
        note = this.item instanceof EquipableItem || this.item instanceof Wand || this.item instanceof Trinket ? Notes.findCustomRecord(this.item.customNoteID) : Notes.findCustomRecord(this.item.getClass());
        if (note == null) {
            if (Notes.getRecords(Notes.CustomRecord.class).size() >= Notes.customRecordLimit()) {
                if (Payment.isIAPSupported() && Payment.getHighestTierUnlocked() < 3) {
                    GameScene.show(new WndOptions(Icons.INFO.get(), Messages.get(CustomNoteButton.class, "limit_title", new Object[0]), Messages.get(CustomNoteButton.class, "limit_text", new Object[0]) + "\n\n" + Messages.get(CustomNoteButton.class, "limit_support_text", new Object[0]), new String[]{Messages.get(CustomNoteButton.class, "limit_support_button", new Object[0])}){

                        @Override
                        protected void onSelect(int index) {
                            if (index == 0) {
                                try {
                                    Dungeon.saveAll();
                                    ShatteredPixelDungeon.switchScene(SupporterScene.class);
                                }
                                catch (Exception e) {
                                    ShatteredPixelDungeon.reportException((Throwable)e);
                                }
                            }
                        }
                    });
                } else {
                    GameScene.show(new WndTitledMessage(Icons.INFO.get(), Messages.get(CustomNoteButton.class, "limit_title", new Object[0]), Messages.get(CustomNoteButton.class, "limit_text", new Object[0])));
                }
                return;
            }
            if (this.item instanceof EquipableItem || this.item instanceof Wand || this.item instanceof Trinket) {
                note = new Notes.CustomRecord(this.item, "", "");
                note.assignID();
                this.item.customNoteID = note.ID();
            } else {
                note = new Notes.CustomRecord(this.item.getClass(), "", "");
                note.assignID();
            }
            ItemJournalButton.addNote(this.parentWnd, note, Messages.get(CustomNoteButton.class, "new_inv", new Object[0]), Messages.get(CustomNoteButton.class, "new_item_title", Messages.titleCase(this.item.name())));
        } else {
            GameScene.show(new CustomNoteButton.CustomNoteWindow(note, this.parentWnd));
        }
    }

    private static void addNote(final Window parentWindow, final Notes.CustomRecord note, String promptTitle, String prompttext) {
        GameScene.show(new WndTextInput(promptTitle, prompttext, "", 50, false, Messages.get(CustomNoteButton.CustomNoteWindow.class, "confirm", new Object[0]), Messages.get(CustomNoteButton.CustomNoteWindow.class, "cancel", new Object[0])){

            @Override
            public void onSelect(boolean positive, String text) {
                if (positive && !text.isEmpty()) {
                    Notes.add(note);
                    note.editText(text, "");
                    if (parentWindow != null) {
                        parentWindow.hide();
                    }
                    this.hide();
                    if (parentWindow instanceof WndUseItem) {
                        GameScene.show(new WndUseItem(((WndUseItem)parentWindow).owner, ((WndUseItem)parentWindow).item));
                    }
                }
            }
        });
    }
}

