/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.services.sync;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Os;
import com.badlogic.gdx.utils.SharedLibraryLoadRuntimeException;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import com.codedisaster.steamworks.SteamAPI;
import com.codedisaster.steamworks.SteamException;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamLeaderboardEntriesHandle;
import com.codedisaster.steamworks.SteamLeaderboardHandle;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUserStats;
import com.codedisaster.steamworks.SteamUserStatsCallback;
import com.codedisaster.steamworks.SteamUtils;
import com.codedisaster.steamworks.SteamUtilsCallback;
import com.shatteredpixel.shatteredpixeldungeon.services.sync.SyncService;
import com.watabou.noosa.Game;

public class SteamSync
extends SyncService {
    SteamUserStats stats = null;
    SteamUtils utils = null;
    private boolean loadAttempted = false;

    public void connect(SyncService.ConnectionStyle style, SyncService.ConnectionResultCallback callback) {
        block9: {
            if (!this.loadAttempted) {
                this.loadAttempted = true;
                try {
                    if (SharedLibraryLoader.os == Os.Windows) {
                        new SharedLibraryLoader().load("steam_api");
                        new SharedLibraryLoader().load("steamworks4j");
                        SteamAPI.skipLoadLibraries();
                    } else {
                        SteamAPI.loadLibraries();
                    }
                    if (SteamAPI.init()) {
                        this.utils = new SteamUtils(new SteamUtilsCallback(){

                            public void onSteamShutdown() {
                            }
                        });
                        this.utils.setOverlayNotificationPosition(SteamUtils.NotificationPosition.TopLeft);
                        this.stats = new SteamUserStats(new SteamUserStatsCallback(){

                            public void onUserStatsReceived(long gameId, SteamID steamIDUser, SteamResult result) {
                            }

                            public void onUserStatsStored(long gameId, SteamResult result) {
                            }

                            public void onUserStatsUnloaded(SteamID steamIDUser) {
                            }

                            public void onUserAchievementStored(long gameId, boolean isGroupAchievement, String achievementName, int curProgress, int maxProgress) {
                            }

                            public void onLeaderboardFindResult(SteamLeaderboardHandle leaderboard, boolean found) {
                            }

                            public void onLeaderboardScoresDownloaded(SteamLeaderboardHandle leaderboard, SteamLeaderboardEntriesHandle entries, int numEntries) {
                            }

                            public void onLeaderboardScoreUploaded(boolean success, SteamLeaderboardHandle leaderboard, int score, boolean scoreChanged, int globalRankNew, int globalRankPrevious) {
                            }

                            public void onNumberOfCurrentPlayersReceived(boolean success, int players) {
                            }

                            public void onGlobalStatsReceived(long gameId, SteamResult result) {
                            }
                        });
                        this.stats.requestCurrentStats();
                        new Runnable(){

                            @Override
                            public void run() {
                                SteamAPI.runCallbacks();
                                Gdx.app.postRunnable((Runnable)this);
                            }
                        }.run();
                        callback.onSuccess();
                        break block9;
                    }
                    Game.reportException((Throwable)new Exception("SteamAPI.init Failed!"));
                }
                catch (SharedLibraryLoadRuntimeException | SteamException e) {
                    Game.reportException((Throwable)e);
                }
            } else if (SteamAPI.isSteamRunning()) {
                callback.onSuccess();
            } else {
                callback.onFail();
            }
        }
    }

    public void disconnect() {
    }

    public boolean isConnected() {
        return this.loadAttempted && this.stats != null && SteamAPI.isSteamRunning();
    }

    public boolean alwaysConnected() {
        return true;
    }

    public void unlockAchievements(String ... badgeNames) {
        for (String badgeName : badgeNames) {
            this.stats.setAchievement(badgeName);
        }
        this.stats.storeStats();
    }

    public boolean supportsAchievementView() {
        return false;
    }

    public void showAchievementView() {
    }

    public void syncBadges(SyncService.ReceiveDataCallback receiver) {
        receiver.receiveData(new byte[0], new SyncService.SendDataCallback(){

            public void sendData(byte[] data) {
            }
        });
    }

    public void syncJournal(SyncService.ReceiveDataCallback receiver) {
    }

    public void syncRankings(SyncService.ReceiveDataCallback receiver) {
    }

    public void syncHallOfHeroes(SyncService.ReceiveDataCallback receiver) {
    }

    public void setOnscreenKeyboardVisible(boolean visible) {
        if (visible) {
            this.utils.showFloatingGamepadTextInput(SteamUtils.FloatingGamepadTextInputMode.ModeMultipleLines, 0, 0, Game.width, Game.height / 2);
        } else {
            this.utils.dismissFloatingGamepadTextInput();
        }
    }
}

