/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Gold;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.Waterskin;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfHealing;
import com.shatteredpixel.shatteredpixeldungeon.items.remains.RemainsItem;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.Payment;
import com.watabou.utils.Bundle;
import com.watabou.utils.FileUtils;
import com.watabou.utils.Random;
import com.watabou.utils.Reflection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class Bones {
    private static final String BONES_FILE = "bones.dat";
    private static final String LEVEL = "level";
    private static final String BRANCH = "branch";
    private static final String ITEM = "item";
    private static final String HERO_CLASS = "hero_class";
    private static final String NAME = "hero_name";
    private static final String KILLED = "enemies_slain";
    private static final String HEALING = "available_healing";
    private static String name;
    private static int killed;
    private static int healing;
    private static int depth;
    private static int branch;
    private static Item item;
    private static HeroClass heroClass;

    public static void leave() {
        depth = Math.max(Dungeon.depth, Statistics.deepestFloor - 5);
        branch = Dungeon.branch;
        if (Dungeon.daily) {
            branch = -1;
            depth = -1;
            return;
        }
        item = Bones.pickItem(Dungeon.hero);
        heroClass = Dungeon.hero.heroClass;
        Bundle bundle = new Bundle();
        bundle.put(LEVEL, depth);
        bundle.put(BRANCH, branch);
        bundle.put(ITEM, item);
        bundle.put(HERO_CLASS, heroClass);
        if (Payment.isTierUnlocked(1)) {
            Bones.setEpitaphProps(bundle);
        }
        try {
            FileUtils.bundleToFile(BONES_FILE, bundle);
        }
        catch (IOException e) {
            ShatteredPixelDungeon.reportException(e);
        }
    }

    private static Item pickItem(Hero hero) {
        Item item = null;
        if (!Dungeon.customSeedText.isEmpty()) {
            return null;
        }
        if (Random.Int(3) != 0) {
            switch (Random.Int(7)) {
                case 0: {
                    item = hero.belongings.weapon;
                    if (hero.belongings.secondWep == null || item != null && hero.belongings.secondWep.trueLevel() <= item.trueLevel()) break;
                    item = hero.belongings.secondWep;
                    break;
                }
                case 1: {
                    item = hero.belongings.armor;
                    break;
                }
                case 2: {
                    item = hero.belongings.artifact;
                    break;
                }
                case 3: {
                    item = hero.belongings.misc;
                    break;
                }
                case 4: {
                    item = hero.belongings.ring;
                    break;
                }
                case 5: 
                case 6: {
                    item = Dungeon.quickslot.randomNonePlaceholder();
                }
            }
            if (item == null || !item.bones) {
                return Bones.pickItem(hero);
            }
        } else {
            Iterator<Item> iterator = hero.belongings.backpack.iterator();
            ArrayList<Item> items = new ArrayList<Item>();
            while (iterator.hasNext()) {
                Item curItem = iterator.next();
                if (!curItem.bones) continue;
                items.add(curItem);
            }
            if (Random.Int(3) < items.size()) {
                item = (Item)Random.element(items);
                if (item.stackable) {
                    item.quantity(Random.NormalIntRange(1, (item.quantity() + 1) / 2));
                    if (item.quantity() > 3) {
                        item.quantity(3);
                    }
                }
            } else {
                item = null;
            }
        }
        return item;
    }

    public static ArrayList<Item> get() {
        if (Dungeon.daily) {
            return null;
        }
        if (depth == -1) {
            try {
                Bundle bundle = FileUtils.bundleFromFile(BONES_FILE);
                depth = bundle.getInt(LEVEL);
                branch = bundle.getInt(BRANCH);
                if (depth > 0) {
                    item = bundle.contains(ITEM) ? (Item)bundle.get(ITEM) : null;
                    heroClass = bundle.contains(HERO_CLASS) ? bundle.getEnum(HERO_CLASS, HeroClass.class) : null;
                    Bones.loadEpitaphProps(bundle);
                }
                return Bones.get();
            }
            catch (IOException e) {
                return null;
            }
        }
        if (Bones.lootAtCurLevel()) {
            Bundle emptyBones = new Bundle();
            emptyBones.put(LEVEL, 0);
            try {
                FileUtils.bundleToFile(BONES_FILE, emptyBones);
            }
            catch (IOException e) {
                ShatteredPixelDungeon.reportException(e);
            }
            depth = 0;
            if (Dungeon.challenges != 0 || !Dungeon.customSeedText.isEmpty()) {
                item = null;
            }
            if (item instanceof Artifact) {
                if (Generator.removeArtifact(((Artifact)item).getClass())) {
                    Artifact artifact = (Artifact)Reflection.newInstance(((Artifact)item).getClass());
                    if (artifact != null) {
                        artifact.cursed = true;
                        artifact.cursedKnown = true;
                    }
                    item = artifact;
                } else {
                    item = new Gold(item.value());
                }
            }
            if (item != null) {
                if (item.isUpgradable() && !(item instanceof MissileWeapon)) {
                    Bones.item.cursed = true;
                    Bones.item.cursedKnown = true;
                }
                if (item.isUpgradable()) {
                    if (item.level() > 3) {
                        item.degrade(item.level() - 3);
                    }
                    Bones.item.levelKnown = item instanceof MissileWeapon;
                }
                item.reset();
            }
            ArrayList<Item> result = new ArrayList<Item>();
            if (heroClass != null) {
                result.add(RemainsItem.get(heroClass));
                if (Dungeon.bossLevel()) {
                    Statistics.qualifiedForBossRemainsBadge = true;
                }
            }
            if (item != null) {
                result.add(item);
            }
            return result.isEmpty() ? null : result;
        }
        return null;
    }

    private static boolean lootAtCurLevel() {
        if (branch == Dungeon.branch) {
            if (branch == 0) {
                return depth == Dungeon.depth;
            }
            if (branch == 1) {
                return depth / 5 == Dungeon.depth / 5;
            }
        }
        return false;
    }

    private static void clearEpitaphProps() {
        name = null;
        killed = 0;
        healing = 0;
    }

    private static void setEpitaphProps(Bundle bundle) {
        name = Dungeon.hero.name().equals(Dungeon.hero.className()) ? "" : Dungeon.hero.name();
        killed = Statistics.enemiesSlain;
        healing = 0;
        Waterskin waterskin = Dungeon.hero.belongings.getItem(Waterskin.class);
        if (waterskin != null && waterskin.isFull()) {
            healing = 2;
        } else if (Dungeon.hero.belongings.getItem(PotionOfHealing.class) != null) {
            healing = 1;
        }
        bundle.put(NAME, name);
        bundle.put(KILLED, killed);
        bundle.put(HEALING, healing);
    }

    private static void loadEpitaphProps(Bundle bundle) {
        if (bundle.contains(NAME)) {
            name = bundle.getString(NAME);
            healing = bundle.getInt(HEALING);
            killed = bundle.getInt(KILLED);
        } else {
            Bones.clearEpitaphProps();
        }
    }

    public static String getEpitaph() {
        if (!Payment.isTierUnlocked(1)) {
            return null;
        }
        if (depth != 0) {
            return null;
        }
        if (name == null || heroClass == null) {
            return null;
        }
        Object result = "";
        result = name.equals("") ? (String)result + Messages.get(Bones.class, "here_lies_nameless", heroClass.title()) : (String)result + Messages.get(Bones.class, "here_lies_named", name, heroClass.title());
        result = (String)result + "\n\n";
        result = killed == 0 ? (String)result + Messages.get(Bones.class, "pacifist", new Object[0]) : (Dungeon.depth < 4 ? (String)result + Messages.get(Bones.class, "rats", killed) : (Dungeon.depth < 7 ? (String)result + Messages.get(Bones.class, "crabs", killed) : (Dungeon.depth < 9 ? (String)result + Messages.get(Bones.class, "undead", killed) : (Dungeon.depth < 11 ? (String)result + Messages.get(Bones.class, "thieves", killed) : (Dungeon.depth < 14 ? (String)result + Messages.get(Bones.class, "bats", killed) : (Dungeon.depth < 17 ? (String)result + Messages.get(Bones.class, "brutes", killed) : (Dungeon.depth < 19 ? (String)result + Messages.get(Bones.class, "monks", killed) : (Dungeon.depth < 21 ? (String)result + Messages.get(Bones.class, "golems", killed) : (Dungeon.depth < 25 ? (String)result + Messages.get(Bones.class, "demons", killed) : (String)result + Messages.get(Bones.class, "yog", killed))))))))));
        if (healing == 1) {
            result = (String)result + "\n\n" + Messages.get(Bones.class, "forgot_waterskin", new Object[0]);
        } else if (healing == 2) {
            result = (String)result + "\n\n" + Messages.get(Bones.class, "forgot_potion", new Object[0]);
        }
        result = (String)result + "\n\n" + Messages.get(Bones.class, "rest_in_peace", new Object[0]);
        Bones.clearEpitaphProps();
        return result;
    }

    static {
        depth = -1;
        branch = -1;
    }
}

