/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon;

import com.shatteredpixel.shatteredpixeldungeon.Assets;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.SPDAction;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.WornKey;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.SupporterScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.TitleScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.WelcomeScene;
import com.shatteredpixel.shatteredpixeldungeon.services.analytics.Analytics;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.Payment;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.PaymentService;
import com.shatteredpixel.shatteredpixeldungeon.services.sync.Sync;
import com.watabou.noosa.Game;
import com.watabou.noosa.audio.Music;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.DeviceCompat;
import com.watabou.utils.PlatformSupport;

public class ShatteredPixelDungeon
extends Game {
    public static final int v1_2_3 = 628;
    public static final int v2_5_4 = 802;
    public static final int v3_0_2 = 833;
    public static final int v3_1_1 = 850;
    public static final int v3_2_5 = 877;
    public static final int v3_3_0 = 883;

    public ShatteredPixelDungeon(PlatformSupport platform) {
        super(sceneClass == null ? WelcomeScene.class : sceneClass, platform);
        Bundle.addAlias(WornKey.class, "com.shatteredpixel.shatteredpixeldungeon.items.keys.SkeletonKey");
    }

    @Override
    public void create() {
        super.create();
        ShatteredPixelDungeon.updateSystemUI();
        SPDAction.loadBindings();
        Music.INSTANCE.enable(SPDSettings.music());
        Music.INSTANCE.volume((float)(SPDSettings.musicVol() * SPDSettings.musicVol()) / 100.0f);
        Sample.INSTANCE.enable(SPDSettings.soundFx());
        Sample.INSTANCE.volume((float)(SPDSettings.SFXVol() * SPDSettings.SFXVol()) / 100.0f);
        Sample.INSTANCE.load(Assets.Sounds.all);
        this.updatePurchases();
    }

    @Override
    public void finish() {
        if (!DeviceCompat.isiOS()) {
            super.finish();
        } else {
            ShatteredPixelDungeon.switchScene(TitleScene.class);
        }
    }

    public static void switchNoFade(Class<? extends PixelScene> c) {
        ShatteredPixelDungeon.switchNoFade(c, null);
    }

    public static void switchNoFade(Class<? extends PixelScene> c, Game.SceneChangeCallback callback) {
        PixelScene.noFade = true;
        ShatteredPixelDungeon.switchScene(c, callback);
    }

    public static void seamlessResetScene(Game.SceneChangeCallback callback) {
        if (ShatteredPixelDungeon.scene() instanceof PixelScene) {
            ((PixelScene)ShatteredPixelDungeon.scene()).saveWindows();
            ShatteredPixelDungeon.switchNoFade(sceneClass, callback);
        } else {
            ShatteredPixelDungeon.resetScene();
        }
    }

    public static void seamlessResetScene() {
        ShatteredPixelDungeon.seamlessResetScene(null);
    }

    @Override
    protected void switchScene() {
        super.switchScene();
        if (this.scene instanceof PixelScene) {
            ((PixelScene)this.scene).restoreWindows();
        }
        if (sceneClass == GameScene.class) {
            Analytics.trackScreen(Dungeon.level.getClass().getSimpleName());
        } else if (sceneClass != InterlevelScene.class) {
            Analytics.trackScreen(sceneClass.getSimpleName());
        }
    }

    @Override
    public void resize(int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        if (this.scene instanceof PixelScene && (height != Game.height || width != Game.width)) {
            PixelScene.noFade = true;
            ((PixelScene)this.scene).saveWindows();
        }
        super.resize(width, height);
        this.updateDisplaySize();
    }

    @Override
    public void destroy() {
        super.destroy();
        GameScene.endActorThread();
    }

    public void updateDisplaySize() {
        platform.updateDisplaySize();
    }

    public static void updateSystemUI() {
        platform.updateSystemUI();
    }

    @Override
    protected void logException(Throwable tr) {
        super.logException(tr);
        Analytics.trackException(tr);
    }

    @Override
    public void resume() {
        super.resume();
        this.updatePurchases();
        if (Sync.supportsSync() && this.scene != null && this.scene.getClass() != WelcomeScene.class) {
            Sync.connectSilent();
        }
        if (sceneClass != null) {
            if (sceneClass == GameScene.class) {
                Analytics.trackScreen(Dungeon.level.getClass().getSimpleName());
            } else if (sceneClass != InterlevelScene.class) {
                Analytics.trackScreen(sceneClass.getSimpleName());
            }
        }
    }

    private void updatePurchases() {
        final int oldHighestTier = Payment.getHighestTierUnlocked();
        Payment.updatePurchaseStates(false, new PaymentService.RefreshCallback(){

            @Override
            public void onSuccess() {
                if (oldHighestTier != Payment.getHighestTierUnlocked() && (sceneClass == TitleScene.class || sceneClass == SupporterScene.class)) {
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }

            @Override
            public void onFail() {
                if (oldHighestTier > 0) {
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }
        });
    }
}

