/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.scenes;

import com.shatteredpixel.shatteredpixeldungeon.Chrome;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.TitleScene;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.Payment;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.PaymentService;
import com.shatteredpixel.shatteredpixeldungeon.ui.ExitButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.StyledButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.TitleBackground;
import com.shatteredpixel.shatteredpixeldungeon.windows.IconTitle;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndSupporterTiers;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Image;
import com.watabou.noosa.NinePatch;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.ui.Component;
import com.watabou.utils.Callback;
import com.watabou.utils.RectF;

public class SupporterScene
extends PixelScene {
    private static final int BTN_HEIGHT = 22;
    private static final int GAP = 2;

    @Override
    public void create() {
        super.create();
        SupporterScene.uiCamera.visible = false;
        int w = Camera.main.width;
        int h = Camera.main.height;
        final RectF insets = this.getCommonInsets();
        int elementWidth = PixelScene.landscape() ? 202 : 120;
        TitleBackground BG = new TitleBackground(w, h);
        this.add(BG);
        w = (int)((float)w - (insets.right + insets.left));
        h = (int)((float)h - (insets.top + insets.bottom));
        ExitButton btnExit = new ExitButton();
        btnExit.setPos(insets.left + (float)w - btnExit.width(), insets.top);
        this.add(btnExit);
        IconTitle title = new IconTitle(Icons.GOLD.get(), Messages.get(this, "title", new Object[0]));
        title.setSize(200.0f, 0.0f);
        title.setPos(insets.left + ((float)w - title.reqWidth()) / 2.0f, insets.top + (20.0f - title.height()) / 2.0f);
        SupporterScene.align(title);
        this.add(title);
        final SupporterMessage msg = new SupporterMessage();
        msg.setSize(elementWidth, 0.0f);
        this.add(msg);
        float elementHeight = msg.height() + 66.0f + 6.0f;
        if (PixelScene.landscape()) {
            elementHeight -= 24.0f;
        }
        float top = insets.top + 16.0f + ((float)(h - 16) - elementHeight) / 2.0f;
        float left = insets.left + (float)(w - elementWidth) / 2.0f;
        msg.setPos(left, top);
        SupporterScene.align(msg);
        if (!Payment.areSKUsLoaded()) {
            final Image busy = Icons.BUSY.get();
            busy.origin.set(busy.width / 2.0f, busy.height / 2.0f);
            busy.angularSpeed = 720.0f;
            this.add(busy);
            final RenderedTextBlock connectingMsg = PixelScene.renderTextBlock(Messages.get(SupporterScene.class, "loading", new Object[0]), 9);
            connectingMsg.align(2);
            this.add(connectingMsg);
            connectingMsg.setPos(insets.left + ((float)w - connectingMsg.width() + 10.0f) / 2.0f, msg.bottom() + 20.0f);
            busy.x = connectingMsg.left() - 10.0f;
            busy.y = connectingMsg.top();
            final int finalW = w;
            Payment.loadSKUDetails(new PaymentService.RefreshCallback(){

                @Override
                public void onSuccess() {
                    ShatteredPixelDungeon.seamlessResetScene();
                }

                @Override
                public void onFail() {
                    ShatteredPixelDungeon.runOnRenderThread(new Callback(){

                        @Override
                        public void call() {
                            busy.visible = false;
                            if (connectingMsg.parent != null) {
                                connectingMsg.text(Messages.get(SupporterScene.class, "failed", new Object[0]), finalW);
                                connectingMsg.hardlight(0xFF8800);
                                connectingMsg.setPos(insets.left + ((float)finalW - connectingMsg.width()) / 2.0f, msg.bottom() + 20.0f);
                            }
                        }
                    });
                }
            });
        } else {
            Object silvText = Messages.get(this, "silver", new Object[0]);
            silvText = Payment.isTierUnlocked(1) ? (String)silvText + "\n" + Messages.get(this, "purchased", new Object[0]) : (Payment.isTierPending(1) ? (String)silvText + "\n" + Messages.get(this, "pending", new Object[0]) : (String)silvText + "\n" + Payment.getTierPrice(1));
            StyledButton silver = new StyledButton(Chrome.Type.GREY_BUTTON_TR, (String)silvText){
                {
                    if (!SPDSettings.goldenUI()) {
                        this.bg.hardlight(1.67f, 1.67f, 1.67f);
                    }
                }

                @Override
                protected void layout() {
                    super.layout();
                    this.icon.x = this.x + (float)this.bg.marginLeft() + 2.0f;
                    this.text.align(2);
                }

                @Override
                protected void onPointerDown() {
                    if (!SPDSettings.goldenUI()) {
                        this.bg.hardlight(2.0f, 2.0f, 2.0f);
                    }
                    Sample.INSTANCE.play("sounds/click.mp3");
                }

                @Override
                protected void onPointerUp() {
                    if (!SPDSettings.goldenUI()) {
                        this.bg.hardlight(1.67f, 1.67f, 1.67f);
                    }
                }

                @Override
                protected void onClick() {
                    super.onClick();
                    ShatteredPixelDungeon.scene().addToFront(new WndSupporterTiers.WndTier1());
                }
            };
            silver.icon(Icons.get(Icons.TIER1));
            silver.textColor(0xCCCCCC);
            silver.setSize(120.0f, 22.0f);
            this.add(silver);
            Object goldText = Messages.get(this, "gold", new Object[0]);
            goldText = Payment.isTierUnlocked(2) ? (String)goldText + "\n" + Messages.get(this, "purchased", new Object[0]) : (Payment.isTierPending(2) ? (String)goldText + "\n" + Messages.get(this, "pending", new Object[0]) : (String)goldText + "\n" + Payment.getTierPrice(2));
            StyledButton gold = new StyledButton(Chrome.Type.GREY_BUTTON_TR, (String)goldText){
                {
                    if (!SPDSettings.goldenUI()) {
                        this.bg.hardlight(1.5f, 1.25f, 0.2f);
                    }
                }

                @Override
                protected void layout() {
                    super.layout();
                    this.icon.x = this.x + (float)this.bg.marginLeft() + 2.0f;
                    this.text.align(2);
                }

                @Override
                protected void onPointerDown() {
                    if (!SPDSettings.goldenUI()) {
                        this.bg.hardlight(2.1f, 1.5f, 0.25f);
                    }
                    Sample.INSTANCE.play("sounds/click.mp3");
                }

                @Override
                protected void onPointerUp() {
                    if (!SPDSettings.goldenUI()) {
                        this.bg.hardlight(1.5f, 1.25f, 0.2f);
                    }
                }

                @Override
                protected void onClick() {
                    super.onClick();
                    ShatteredPixelDungeon.scene().addToFront(new WndSupporterTiers.WndTier2());
                }
            };
            gold.icon(Icons.get(Icons.TIER2));
            gold.textColor(16762394);
            gold.setSize(120.0f, 22.0f);
            this.add(gold);
            Object shatteredText = Messages.get(this, "shattered", new Object[0]);
            shatteredText = Payment.isTierUnlocked(3) ? (String)shatteredText + "\n" + Messages.get(this, "purchased", new Object[0]) : (Payment.isTierPending(3) ? (String)shatteredText + "\n" + Messages.get(this, "pending", new Object[0]) : (String)shatteredText + "\n" + Payment.getTierPrice(3));
            StyledButton shattered = new StyledButton(Chrome.Type.GREY_BUTTON_TR, (String)shatteredText){
                {
                    if (!SPDSettings.goldenUI()) {
                        this.bg.hardlight(0.0f, 1.0f, 0.0f);
                    }
                }

                @Override
                protected void layout() {
                    super.layout();
                    this.icon.x = this.x + (float)this.bg.marginLeft() + 2.0f;
                    this.text.align(2);
                }

                @Override
                protected void onPointerDown() {
                    if (!SPDSettings.goldenUI()) {
                        this.bg.hardlight(0.0f, 1.2f, 0.0f);
                    }
                    Sample.INSTANCE.play("sounds/click.mp3");
                }

                @Override
                protected void onPointerUp() {
                    if (!SPDSettings.goldenUI()) {
                        this.bg.hardlight(0.0f, 1.0f, 0.0f);
                    }
                }

                @Override
                protected void onClick() {
                    super.onClick();
                    ShatteredPixelDungeon.scene().addToFront(new WndSupporterTiers.WndTier3());
                }
            };
            shattered.icon(Icons.get(Icons.TIER3));
            shattered.textColor(52224);
            shattered.setSize(120.0f, 22.0f);
            this.add(shattered);
            if (PixelScene.landscape()) {
                silver.setPos(msg.left() - 20.0f, msg.bottom() + 2.0f);
                gold.setPos(silver.right() + 2.0f, msg.bottom() + 2.0f);
                shattered.setPos(silver.left() + 61.0f, gold.bottom() + 2.0f);
            } else {
                silver.setPos(msg.left(), msg.bottom() + 2.0f);
                gold.setPos(silver.left(), silver.bottom() + 2.0f);
                shattered.setPos(gold.left(), gold.bottom() + 2.0f);
            }
        }
    }

    @Override
    protected void onBackPressed() {
        ShatteredPixelDungeon.switchNoFade(TitleScene.class);
    }

    private static class SupporterMessage
    extends Component {
        NinePatch bg;
        RenderedTextBlock text;
        Image icon;

        private SupporterMessage() {
        }

        @Override
        protected void createChildren() {
            this.bg = Chrome.get(Chrome.Type.GREY_BUTTON_TR);
            this.add(this.bg);
            Object message = Messages.get(SupporterScene.class, "intro", new Object[0]);
            message = (String)message + "\n\n" + Messages.get(SupporterScene.class, "gplay_msg", new Object[0]);
            message = (String)message + "\n\n- Evan";
            this.text = PixelScene.renderTextBlock((String)message, 6);
            this.add(this.text);
            this.icon = Icons.get(Icons.SHPX);
            this.add(this.icon);
        }

        @Override
        protected void layout() {
            this.bg.x = this.x;
            this.bg.y = this.y;
            this.text.maxWidth((int)this.width - this.bg.marginHor());
            this.text.setPos(this.x + (float)this.bg.marginLeft(), this.y + (float)this.bg.marginTop() + 1.0f);
            this.icon.y = this.text.bottom() - this.icon.height() + 4.0f;
            this.icon.x = this.x + 25.0f;
            this.height = this.text.bottom() + 3.0f - this.y;
            this.height += (float)this.bg.marginBottom();
            this.bg.size(this.width, this.height);
        }
    }
}

