/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.services.payment;

import com.shatteredpixel.shatteredpixeldungeon.services.payment.PaymentService;

public class Payment {
    public static PaymentService service;

    public static boolean supportsPayment() {
        return service != null;
    }

    public static boolean isTierPending(int tier) {
        if (!Payment.supportsPayment()) {
            return false;
        }
        return service.getPurchaseState(tier) == PaymentService.PurchaseState.PENDING;
    }

    public static boolean isTierUnlocked(int tier) {
        if (!Payment.supportsPayment()) {
            return false;
        }
        return service.getPurchaseState(tier) == PaymentService.PurchaseState.PURCHASED;
    }

    public static int getHighestTierUnlocked() {
        for (int i = 3; i > 0; --i) {
            if (!Payment.isTierUnlocked(i)) continue;
            return i;
        }
        return 0;
    }

    public static void updatePurchaseStates(boolean canUseNetwork, PaymentService.RefreshCallback callback) {
        if (!Payment.supportsPayment()) {
            if (callback != null) {
                callback.onFail();
            }
        } else {
            service.updatePurchaseStates(callback);
        }
    }

    public static boolean areSKUsLoaded() {
        if (!Payment.supportsPayment()) {
            return false;
        }
        return service.areSKUsLoaded();
    }

    public static void loadSKUDetails(PaymentService.RefreshCallback callback) {
        if (!Payment.supportsPayment()) {
            if (callback != null) {
                callback.onFail();
            }
        } else {
            service.loadSKUDetails(callback);
        }
    }

    public static boolean isIAPSupported() {
        return Payment.supportsPayment() && service.supportsIAP();
    }

    public static String getTierPrice(int tier) {
        if (!Payment.supportsPayment() || !Payment.areSKUsLoaded()) {
            return null;
        }
        return service.getTierPrice(tier);
    }

    public static void initiatePurchase(int tier, PaymentService.RefreshCallback callback) {
        if (!Payment.supportsPayment()) {
            if (callback != null) {
                callback.onFail();
            }
        } else {
            service.initiatePurchase(tier, callback);
        }
    }
}

