/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.services.sync;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Os;
import com.badlogic.gdx.utils.SharedLibraryLoadRuntimeException;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import com.codedisaster.steamworks.SteamAPI;
import com.codedisaster.steamworks.SteamException;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamLeaderboardEntriesHandle;
import com.codedisaster.steamworks.SteamLeaderboardHandle;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUserStats;
import com.codedisaster.steamworks.SteamUserStatsCallback;
import com.codedisaster.steamworks.SteamUtils;
import com.codedisaster.steamworks.SteamUtilsCallback;
import com.shatteredpixel.shatteredpixeldungeon.services.sync.SyncService;
import com.watabou.noosa.Game;

public class SteamSync
extends SyncService {
    SteamUserStats stats = null;
    SteamUtils utils = null;
    private boolean loadAttempted = false;

    @Override
    public void connect(SyncService.ConnectionStyle style, SyncService.ConnectionResultCallback callback) {
        block9: {
            if (!this.loadAttempted) {
                this.loadAttempted = true;
                try {
                    if (SharedLibraryLoader.os == Os.Windows) {
                        new SharedLibraryLoader().load("steam_api");
                        new SharedLibraryLoader().load("steamworks4j");
                        SteamAPI.skipLoadLibraries();
                    } else {
                        SteamAPI.loadLibraries();
                    }
                    if (SteamAPI.init()) {
                        this.utils = new SteamUtils(new SteamUtilsCallback(){

                            @Override
                            public void onSteamShutdown() {
                            }
                        });
                        this.utils.setOverlayNotificationPosition(SteamUtils.NotificationPosition.TopLeft);
                        this.stats = new SteamUserStats(new SteamUserStatsCallback(){

                            @Override
                            public void onUserStatsReceived(long gameId, SteamID steamIDUser, SteamResult result) {
                            }

                            @Override
                            public void onUserStatsStored(long gameId, SteamResult result) {
                            }

                            @Override
                            public void onUserStatsUnloaded(SteamID steamIDUser) {
                            }

                            @Override
                            public void onUserAchievementStored(long gameId, boolean isGroupAchievement, String achievementName, int curProgress, int maxProgress) {
                            }

                            @Override
                            public void onLeaderboardFindResult(SteamLeaderboardHandle leaderboard, boolean found) {
                            }

                            @Override
                            public void onLeaderboardScoresDownloaded(SteamLeaderboardHandle leaderboard, SteamLeaderboardEntriesHandle entries, int numEntries) {
                            }

                            @Override
                            public void onLeaderboardScoreUploaded(boolean success, SteamLeaderboardHandle leaderboard, int score, boolean scoreChanged, int globalRankNew, int globalRankPrevious) {
                            }

                            @Override
                            public void onNumberOfCurrentPlayersReceived(boolean success, int players) {
                            }

                            @Override
                            public void onGlobalStatsReceived(long gameId, SteamResult result) {
                            }
                        });
                        this.stats.requestCurrentStats();
                        new Runnable(){

                            @Override
                            public void run() {
                                SteamAPI.runCallbacks();
                                Gdx.app.postRunnable(this);
                            }
                        }.run();
                        callback.onSuccess();
                        break block9;
                    }
                    Game.reportException(new Exception("SteamAPI.init Failed!"));
                }
                catch (SharedLibraryLoadRuntimeException | SteamException e) {
                    Game.reportException(e);
                }
            } else if (SteamAPI.isSteamRunning()) {
                callback.onSuccess();
            } else {
                callback.onFail();
            }
        }
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isConnected() {
        return this.loadAttempted && this.stats != null && SteamAPI.isSteamRunning();
    }

    @Override
    public boolean alwaysConnected() {
        return true;
    }

    @Override
    public void unlockAchievements(String ... badgeNames) {
        for (String badgeName : badgeNames) {
            this.stats.setAchievement(badgeName);
        }
        this.stats.storeStats();
    }

    @Override
    public boolean supportsAchievementView() {
        return false;
    }

    @Override
    public void showAchievementView() {
    }

    @Override
    public void syncBadges(SyncService.ReceiveDataCallback receiver) {
        receiver.receiveData(new byte[0], new SyncService.SendDataCallback(){

            @Override
            public void sendData(byte[] data) {
            }
        });
    }

    @Override
    public void syncJournal(SyncService.ReceiveDataCallback receiver) {
    }

    @Override
    public void syncRankings(SyncService.ReceiveDataCallback receiver) {
    }

    @Override
    public void syncHallOfHeroes(SyncService.ReceiveDataCallback receiver) {
    }

    @Override
    public void setOnscreenKeyboardVisible(boolean visible) {
        if (visible) {
            this.utils.showFloatingGamepadTextInput(SteamUtils.FloatingGamepadTextInputMode.ModeMultipleLines, 0, 0, Game.width, Game.height / 2);
        } else {
            this.utils.dismissFloatingGamepadTextInput();
        }
    }
}

