/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.services.sync;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Rankings;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.journal.Bestiary;
import com.shatteredpixel.shatteredpixeldungeon.journal.Catalog;
import com.shatteredpixel.shatteredpixeldungeon.journal.Document;
import com.shatteredpixel.shatteredpixeldungeon.journal.Journal;
import com.shatteredpixel.shatteredpixeldungeon.scenes.HallOfHeroesScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.JournalScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.RankingsScene;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.Payment;
import com.shatteredpixel.shatteredpixeldungeon.services.sync.SyncService;
import com.watabou.noosa.Game;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class Sync {
    public static SyncService service;

    public static boolean supportsSync() {
        return service != null;
    }

    public static void connectSilent() {
        Sync.connect(SyncService.ConnectionStyle.SILENT);
    }

    public static void connectWithSignIn() {
        Sync.connect(SyncService.ConnectionStyle.SIGNIN);
    }

    private static void connect(final SyncService.ConnectionStyle style) {
        if (!Sync.supportsSync() || Sync.isConnected()) {
            return;
        }
        service.connect(style, new SyncService.ConnectionResultCallback(){

            @Override
            public void onSuccess() {
                Sync.syncBadges();
                Sync.syncJournal();
                Sync.syncRankings();
                if (Payment.isTierUnlocked(2)) {
                    Sync.syncHallOfHeroes();
                }
                if (style == SyncService.ConnectionStyle.SIGNIN) {
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }

            @Override
            public void onFail() {
                if (style == SyncService.ConnectionStyle.SIGNIN) {
                    ShatteredPixelDungeon.seamlessResetScene();
                }
            }
        });
    }

    public static void disconnect() {
        if (!Sync.supportsSync()) {
            return;
        }
        service.disconnect();
    }

    public static boolean isConnected() {
        return Sync.supportsSync() && service.isConnected();
    }

    public static boolean alwaysConnected() {
        return Sync.supportsSync() && service.alwaysConnected();
    }

    public static void unlockNewAchievement(String badgeName) {
        if (Sync.supportsSync() && Sync.isConnected()) {
            service.unlockAchievements(badgeName);
        }
    }

    public static boolean supportsAchievementView() {
        return Sync.supportsSync() && Sync.isConnected() && service.supportsAchievementView();
    }

    public static void showAchievementView() {
        if (Sync.supportsSync() && Sync.isConnected()) {
            service.showAchievementView();
        }
    }

    public static void syncBadges() {
        Badges.loadGlobal();
        if (!Sync.supportsSync()) {
            return;
        }
        if (!Sync.isConnected()) {
            Sync.connectSilent();
            return;
        }
        service.syncBadges(new SyncService.ReceiveDataCallback(){

            @Override
            public void receiveData(byte[] data, SyncService.SendDataCallback sender) {
                int cloudVersionCode;
                HashSet<Object> cloudBadges;
                Bundle cloudBundle = null;
                try {
                    if (data.length > 0) {
                        cloudBundle = Bundle.read(new ByteArrayInputStream(data));
                        cloudBadges = Badges.restore(cloudBundle);
                        cloudVersionCode = cloudBundle.getInt("version");
                    } else {
                        cloudBadges = new HashSet();
                        cloudVersionCode = 0;
                    }
                }
                catch (Exception e) {
                    ShatteredPixelDungeon.reportException(e);
                    cloudBadges = new HashSet();
                    cloudVersionCode = 0;
                }
                boolean imported = false;
                for (Badges.Badge badge : cloudBadges) {
                    if (Badges.isUnlocked(badge)) continue;
                    Badges.unlockViaSync(badge);
                    imported = true;
                }
                if (imported) {
                    Badges.saveGlobal();
                    if (Game.scene() instanceof JournalScene) {
                        ShatteredPixelDungeon.switchNoFade(JournalScene.class);
                    }
                }
                HashSet<String> achievementsToUnlock = new HashSet<String>();
                for (Badges.Badge badge : cloudBadges) {
                    achievementsToUnlock.add(badge.name());
                }
                for (Badges.Badge badge : Badges.allUnlocked()) {
                    if (ShatteredPixelDungeon.versionCode <= cloudVersionCode && cloudBadges.contains((Object)badge)) continue;
                    Bundle bundle = new Bundle();
                    Badges.store(bundle, Badges.allUnlocked());
                    bundle.put("version", ShatteredPixelDungeon.versionCode);
                    if (ShatteredPixelDungeon.versionCode < cloudVersionCode) {
                        bundle.put("version", cloudVersionCode);
                        ArrayList<String> badgeNames = new ArrayList<String>(Arrays.asList(bundle.getStringArray("badges")));
                        for (String cloudBadge : cloudBundle.getStringArray("badges")) {
                            if (badgeNames.contains(cloudBadge)) continue;
                            badgeNames.add(cloudBadge);
                        }
                        bundle.put("badges", badgeNames.toArray(new String[0]));
                    }
                    for (Badges.Badge unlocked : Badges.allUnlocked()) {
                        achievementsToUnlock.add(unlocked.name());
                    }
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    Bundle.write(bundle, stream);
                    sender.sendData(stream.toByteArray());
                    break;
                }
                if (!achievementsToUnlock.isEmpty()) {
                    service.unlockAchievements(achievementsToUnlock.toArray(new String[0]));
                }
            }
        });
    }

    public static void syncJournal() {
        Journal.loadGlobal();
        if (!Sync.supportsSync()) {
            return;
        }
        if (!Sync.isConnected()) {
            Sync.connectSilent();
            return;
        }
        service.syncJournal(new SyncService.ReceiveDataCallback(){

            @Override
            public void receiveData(byte[] data, SyncService.SendDataCallback sender) {
                LinkedHashMap cloudDocPages;
                int toAdd;
                int i;
                int cloudVersionCode;
                int[] cloudBestiaryEncounters;
                boolean[] cloudBestiarySeen;
                Class[] cloudBestiaryClasses;
                int[] cloudCatalogUses;
                boolean[] cloudCatalogSeen;
                Class[] cloudCatalogClasses;
                LinkedHashMap cloudJournalPages = new LinkedHashMap();
                Bundle cloudBundle = null;
                try {
                    if (data.length > 0) {
                        cloudBundle = Bundle.read(new ByteArrayInputStream(data));
                        if (cloudBundle.contains("catalog_items")) {
                            cloudCatalogClasses = cloudBundle.getClassArray("catalog_items");
                            cloudCatalogSeen = new boolean[cloudCatalogClasses.length];
                            cloudCatalogUses = new int[cloudCatalogClasses.length];
                            for (int i2 = 0; i2 < cloudCatalogSeen.length; ++i2) {
                                cloudCatalogSeen[i2] = true;
                                cloudCatalogUses[i2] = 0;
                            }
                            cloudBestiaryClasses = new Class[]{};
                            cloudBestiarySeen = new boolean[]{};
                            cloudBestiaryEncounters = new int[]{};
                        } else {
                            cloudCatalogClasses = cloudBundle.getClassArray("catalog_classes");
                            cloudCatalogSeen = cloudBundle.getBooleanArray("catalog_seen");
                            cloudCatalogUses = cloudBundle.getIntArray("catalog_uses");
                            cloudBestiaryClasses = cloudBundle.getClassArray("bestiary_classes");
                            cloudBestiarySeen = cloudBundle.getBooleanArray("bestiary_seen");
                            cloudBestiaryEncounters = cloudBundle.getIntArray("bestiary_encounters");
                        }
                        Bundle cloudDocs = cloudBundle.getBundle("documents");
                        Document[] documentArray = Document.values();
                        int n = documentArray.length;
                        for (int j = 0; j < n; ++j) {
                            Document doc = documentArray[j];
                            if (!cloudDocs.contains(doc.name())) continue;
                            LinkedHashMap<String, Integer> cloudDoc = new LinkedHashMap<String, Integer>();
                            Bundle pagesBundle = cloudDocs.getBundle(doc.name());
                            for (String page : doc.pageNames()) {
                                if (!pagesBundle.contains(page)) continue;
                                cloudDoc.put(page, pagesBundle.getInt(page));
                            }
                            cloudJournalPages.put(doc, cloudDoc);
                        }
                        cloudVersionCode = cloudBundle.getInt("version");
                    } else {
                        cloudCatalogClasses = new Class[]{};
                        cloudCatalogSeen = new boolean[]{};
                        cloudCatalogUses = new int[]{};
                        cloudBestiaryClasses = new Class[]{};
                        cloudBestiarySeen = new boolean[]{};
                        cloudBestiaryEncounters = new int[]{};
                        cloudJournalPages = new LinkedHashMap();
                        cloudVersionCode = 0;
                    }
                }
                catch (Exception e) {
                    cloudCatalogClasses = new Class[]{};
                    cloudCatalogSeen = new boolean[]{};
                    cloudCatalogUses = new int[]{};
                    cloudBestiaryClasses = new Class[]{};
                    cloudBestiarySeen = new boolean[]{};
                    cloudBestiaryEncounters = new int[]{};
                    cloudJournalPages = new LinkedHashMap();
                    cloudVersionCode = 0;
                }
                boolean syncNeeded = false;
                for (i = 0; i < cloudCatalogClasses.length; ++i) {
                    if (cloudCatalogSeen[i]) {
                        Catalog.setSeen(cloudCatalogClasses[i]);
                    }
                    if ((toAdd = cloudCatalogUses[i] - Catalog.useCount(cloudCatalogClasses[i])) > 0) {
                        Catalog.countUses(cloudCatalogClasses[i], toAdd);
                        continue;
                    }
                    if (toAdd >= 0) continue;
                    syncNeeded = true;
                }
                for (i = 0; i < cloudBestiaryClasses.length; ++i) {
                    if (cloudBestiarySeen[i]) {
                        Bestiary.setSeen(cloudBestiaryClasses[i]);
                    }
                    if ((toAdd = cloudBestiaryEncounters[i] - Bestiary.encounterCount(cloudBestiaryClasses[i])) > 0) {
                        Bestiary.countEncounters(cloudBestiaryClasses[i], toAdd);
                        continue;
                    }
                    if (toAdd >= 0) continue;
                    syncNeeded = true;
                }
                for (Document d : Document.values()) {
                    if (!cloudJournalPages.containsKey((Object)d)) continue;
                    cloudDocPages = (LinkedHashMap)cloudJournalPages.get((Object)d);
                    for (String page : d.pageNames()) {
                        if (!cloudDocPages.containsKey(page)) continue;
                        if ((Integer)cloudDocPages.get(page) == 2) {
                            d.readPage(page);
                            continue;
                        }
                        if ((Integer)cloudDocPages.get(page) != 1) continue;
                        d.findPage(page);
                    }
                }
                if (!syncNeeded) {
                    block9: for (Document d : Document.values()) {
                        cloudDocPages = (LinkedHashMap)cloudJournalPages.get((Object)d);
                        if (cloudDocPages == null || syncNeeded) {
                            syncNeeded = true;
                            break;
                        }
                        for (String page : d.pageNames()) {
                            int pageState;
                            int n = d.isPageRead(page) ? 2 : (pageState = d.isPageFound(page) ? 1 : 0);
                            if (cloudDocPages.containsKey(page) && (Integer)cloudDocPages.get(page) >= pageState) continue;
                            syncNeeded = true;
                            continue block9;
                        }
                    }
                }
                if (!syncNeeded) {
                    int totalSeen = 0;
                    for (Catalog c : Catalog.values()) {
                        totalSeen += c.totalSeen();
                    }
                    if (totalSeen > cloudCatalogSeen.length) {
                        syncNeeded = true;
                    }
                }
                if (!syncNeeded) {
                    int totalSeen = 0;
                    for (Bestiary b : Bestiary.values()) {
                        totalSeen += b.totalSeen();
                    }
                    if (totalSeen > cloudBestiarySeen.length) {
                        syncNeeded = true;
                    }
                }
                if (ShatteredPixelDungeon.versionCode > cloudVersionCode || syncNeeded) {
                    Bundle bundle = new Bundle();
                    Document.store(bundle);
                    Catalog.store(bundle);
                    Bestiary.store(bundle);
                    bundle.put("version", ShatteredPixelDungeon.versionCode);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    Bundle.write(bundle, stream);
                    sender.sendData(stream.toByteArray());
                }
            }
        });
    }

    public static void syncRankings() {
        Rankings.INSTANCE.load();
        if (!Sync.supportsSync()) {
            return;
        }
        if (!Sync.isConnected()) {
            Sync.connectSilent();
            return;
        }
        service.syncRankings(new SyncService.ReceiveDataCallback(){

            @Override
            public void receiveData(byte[] data, SyncService.SendDataCallback sender) {
                ArrayList<Rankings.Record> cloudRecords = new ArrayList<Rankings.Record>();
                int cloudTotal = 0;
                int cloudWon = 0;
                Rankings.Record cloudLatestDaily = null;
                long[] cloudDailyDates = new long[]{};
                int[] cloudDailyScores = new int[]{};
                try {
                    if (data.length > 0) {
                        Bundle cloudData = Bundle.read(new ByteArrayInputStream(data));
                        for (Bundlable bundlable : cloudData.getCollection("records")) {
                            cloudRecords.add((Rankings.Record)bundlable);
                        }
                        cloudTotal = cloudData.getInt("total");
                        cloudWon = cloudData.getInt("won");
                        if (cloudData.contains("latest_daily")) {
                            cloudLatestDaily = (Rankings.Record)cloudData.get("latest_daily");
                            cloudDailyDates = cloudData.getLongArray("daily_history_dates");
                            cloudDailyScores = cloudData.getIntArray("daily_history_scores");
                        }
                    }
                }
                catch (Exception e) {
                    ShatteredPixelDungeon.reportException(e);
                    cloudRecords = new ArrayList();
                }
                boolean syncNeeded = false;
                ArrayList<Rankings.Record> mergedRecords = new ArrayList<Rankings.Record>(Rankings.INSTANCE.records);
                for (Rankings.Record rec : cloudRecords) {
                    if (mergedRecords.contains(rec)) continue;
                    mergedRecords.add(rec);
                    syncNeeded = true;
                }
                Collections.sort(mergedRecords, Rankings.scoreComparator);
                while (mergedRecords.size() >= 11) {
                    mergedRecords.remove(mergedRecords.size() - 1);
                }
                for (Rankings.Record rec : mergedRecords) {
                    if (cloudRecords.contains(rec)) continue;
                    syncNeeded = true;
                    break;
                }
                int n = Rankings.INSTANCE.localTotal;
                int newWon = Rankings.INSTANCE.localWon;
                if (n > 0 || newWon > 0) {
                    syncNeeded = true;
                    cloudTotal += n;
                    cloudWon += newWon;
                }
                if (cloudTotal < Rankings.INSTANCE.totalNumber || cloudWon < Rankings.INSTANCE.wonNumber) {
                    syncNeeded = true;
                    cloudTotal = Rankings.INSTANCE.totalNumber;
                    cloudWon = Rankings.INSTANCE.wonNumber;
                }
                if (Rankings.INSTANCE.totalNumber != cloudTotal || Rankings.INSTANCE.wonNumber != cloudWon) {
                    syncNeeded = true;
                }
                if (cloudLatestDaily == null && Rankings.INSTANCE.latestDaily != null) {
                    cloudLatestDaily = Rankings.INSTANCE.latestDaily;
                    syncNeeded = true;
                } else if (cloudLatestDaily != null && Rankings.INSTANCE.latestDaily != null) {
                    if (!cloudLatestDaily.equals(Rankings.INSTANCE.latestDaily)) {
                        long localSeed;
                        syncNeeded = true;
                        long cloudSeed = cloudLatestDaily.gameData != null ? cloudLatestDaily.gameData.getLong("seed") : 0L;
                        long l = localSeed = Rankings.INSTANCE.latestDaily.gameData != null ? Rankings.INSTANCE.latestDaily.gameData.getLong("seed") : 0L;
                        if (cloudSeed <= localSeed) {
                            if (cloudSeed < localSeed) {
                                cloudLatestDaily = Rankings.INSTANCE.latestDaily;
                            } else if (cloudLatestDaily.score > Rankings.INSTANCE.latestDaily.score) {
                                cloudLatestDaily = Rankings.INSTANCE.latestDaily;
                            }
                        }
                    }
                } else if (cloudLatestDaily != null || Rankings.INSTANCE.latestDaily != null) {
                    syncNeeded = true;
                }
                boolean identical = true;
                if (cloudDailyDates.length != Rankings.INSTANCE.dailyScoreHistory.size()) {
                    identical = false;
                } else {
                    for (int i = 0; i < cloudDailyDates.length; ++i) {
                        if (Rankings.INSTANCE.dailyScoreHistory.containsKey(cloudDailyDates[i]) && Rankings.INSTANCE.dailyScoreHistory.get(cloudDailyDates[i]) == cloudDailyScores[i]) continue;
                        identical = false;
                        break;
                    }
                }
                LinkedHashMap<Long, Integer> mergedDailyHistory = new LinkedHashMap<Long, Integer>();
                if (!identical) {
                    long localCur;
                    syncNeeded = true;
                    LinkedHashMap<Long, Integer> cloudDailyHistory = new LinkedHashMap<Long, Integer>();
                    for (int i = 0; i < cloudDailyDates.length; ++i) {
                        cloudDailyHistory.put(cloudDailyDates[i], cloudDailyScores[i]);
                    }
                    Iterator cloudIt = cloudDailyHistory.keySet().iterator();
                    Iterator<Long> localIt = Rankings.INSTANCE.dailyScoreHistory.keySet().iterator();
                    long latestDate = 0L;
                    long cloudCur = cloudIt.hasNext() ? (Long)cloudIt.next() : Long.MAX_VALUE;
                    long l = localCur = localIt.hasNext() ? localIt.next() : Long.MAX_VALUE;
                    while (cloudCur != Long.MAX_VALUE || localCur != Long.MAX_VALUE) {
                        if (cloudCur < localCur) {
                            mergedDailyHistory.put(cloudCur, (Integer)cloudDailyHistory.get(cloudCur));
                            latestDate = cloudCur;
                            cloudCur = cloudIt.hasNext() ? (Long)cloudIt.next() : Long.MAX_VALUE;
                            continue;
                        }
                        if (localCur < cloudCur) {
                            mergedDailyHistory.put(localCur, Rankings.INSTANCE.dailyScoreHistory.get(localCur));
                            latestDate = localCur;
                            localCur = localIt.hasNext() ? localIt.next() : Long.MAX_VALUE;
                            continue;
                        }
                        if ((Integer)cloudDailyHistory.get(cloudCur) <= Rankings.INSTANCE.dailyScoreHistory.get(localCur)) {
                            mergedDailyHistory.put(cloudCur, (Integer)cloudDailyHistory.get(cloudCur));
                        } else {
                            mergedDailyHistory.put(localCur, Rankings.INSTANCE.dailyScoreHistory.get(localCur));
                        }
                        latestDate = cloudCur;
                        cloudCur = cloudIt.hasNext() ? (Long)cloudIt.next() : Long.MAX_VALUE;
                        localCur = localIt.hasNext() ? localIt.next() : Long.MAX_VALUE;
                    }
                    cloudDailyDates = new long[mergedDailyHistory.size()];
                    cloudDailyScores = new int[mergedDailyHistory.size()];
                    int i = 0;
                    for (Long l2 : mergedDailyHistory.keySet()) {
                        cloudDailyDates[i] = l2;
                        cloudDailyScores[i] = (Integer)mergedDailyHistory.get(l2);
                        ++i;
                    }
                    if (SPDSettings.lastDaily() < latestDate) {
                        SPDSettings.lastDaily(latestDate);
                    }
                }
                if (syncNeeded) {
                    Bundle bundle = new Bundle();
                    bundle.put("records", mergedRecords);
                    bundle.put("total", cloudTotal);
                    bundle.put("won", cloudWon);
                    bundle.put("latest_daily", cloudLatestDaily);
                    bundle.put("daily_history_dates", cloudDailyDates);
                    bundle.put("daily_history_scores", cloudDailyScores);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    Bundle.write(bundle, stream);
                    sender.sendData(stream.toByteArray());
                    ArrayList<Rankings.Record> localRecs = Rankings.INSTANCE.records;
                    int localLast = Rankings.INSTANCE.lastRecord;
                    if (localRecs.size() == 11) {
                        mergedRecords.add(localRecs.get(10));
                    }
                    localLast = localLast >= 0 && localLast < localRecs.size() ? mergedRecords.indexOf(localRecs.get(localLast)) : -1;
                    Rankings.INSTANCE.totalNumber = cloudTotal;
                    Rankings.INSTANCE.wonNumber = cloudWon;
                    Rankings.INSTANCE.localWon = 0;
                    Rankings.INSTANCE.localTotal = 0;
                    Rankings.INSTANCE.lastRecord = localLast;
                    Rankings.INSTANCE.records = mergedRecords;
                    Rankings.INSTANCE.latestDaily = cloudLatestDaily;
                    Rankings.INSTANCE.dailyScoreHistory = mergedDailyHistory;
                    Rankings.INSTANCE.save();
                    for (Rankings.Record rec : mergedRecords) {
                        if (localRecs.contains(rec)) continue;
                        if (ShatteredPixelDungeon.scene() == null || ShatteredPixelDungeon.scene().getClass() != RankingsScene.class) break;
                        ShatteredPixelDungeon.switchNoFade(RankingsScene.class);
                        break;
                    }
                }
            }
        });
    }

    public static void syncHallOfHeroes() {
        Rankings.INSTANCE.loadHall();
        if (!Sync.supportsSync()) {
            return;
        }
        if (!Sync.isConnected()) {
            Sync.connectSilent();
            return;
        }
        service.syncHallOfHeroes(new SyncService.ReceiveDataCallback(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void receiveData(byte[] data, SyncService.SendDataCallback sender) {
                void var8_14;
                long cloudLastUpdated = 0L;
                String cloudLastID = null;
                ArrayList<Object> cloudRecords = new ArrayList();
                while (cloudRecords.size() < 10) {
                    cloudRecords.add(new ArrayList());
                }
                try {
                    if (data.length > 0) {
                        void var8_10;
                        Bundle cloudData = Bundle.read(new ByteArrayInputStream(data));
                        boolean bl = false;
                        while (cloudData.contains("records" + (int)var8_10)) {
                            for (Bundlable record : cloudData.getCollection("records" + (int)var8_10)) {
                                ((ArrayList)cloudRecords.get((int)var8_10)).add((Rankings.Record)record);
                            }
                            ++var8_10;
                        }
                        cloudLastUpdated = cloudData.getLong("updated");
                        cloudLastID = cloudData.getString("id");
                    }
                }
                catch (Exception e) {
                    ShatteredPixelDungeon.reportException(e);
                }
                if (cloudLastUpdated == Rankings.INSTANCE.hallLastUpdated) {
                    Rankings.INSTANCE.hallLastSynced = Game.realTime;
                    return;
                }
                if (cloudLastUpdated == 0L) {
                    cloudRecords = Rankings.INSTANCE.hallRecords;
                    cloudLastUpdated = Rankings.INSTANCE.hallLastUpdated;
                } else if (Rankings.INSTANCE.hallLastUpdated == 0L) {
                    Rankings.INSTANCE.hallRecords = cloudRecords;
                    Rankings.INSTANCE.hallLastUpdated = cloudLastUpdated;
                } else if (Rankings.INSTANCE.hallID.equals(cloudLastID)) {
                    if (Rankings.INSTANCE.hallLastUpdated > cloudLastUpdated) {
                        cloudRecords = Rankings.INSTANCE.hallRecords;
                        cloudLastUpdated = Rankings.INSTANCE.hallLastUpdated;
                    } else {
                        Rankings.INSTANCE.hallRecords = cloudRecords;
                        Rankings.INSTANCE.hallLastUpdated = cloudLastUpdated;
                    }
                } else if (Rankings.INSTANCE.hallLastSynced >= Rankings.INSTANCE.hallLastUpdated) {
                    Rankings.INSTANCE.hallRecords = cloudRecords;
                    Rankings.INSTANCE.hallLastUpdated = cloudLastUpdated;
                } else {
                    for (int i2 = 0; i2 < Rankings.INSTANCE.hallRecords.size(); ++i2) {
                        for (Rankings.Record localRec : Rankings.INSTANCE.hallRecords.get(i2)) {
                            int cloudPage = -1;
                            Rankings.Record cloudRec = null;
                            for (int j = 0; j < cloudRecords.size(); ++j) {
                                if (!((ArrayList)cloudRecords.get(j)).contains(localRec)) continue;
                                cloudPage = j;
                                cloudRec = (Rankings.Record)((ArrayList)cloudRecords.get(j)).get(((ArrayList)cloudRecords.get(j)).indexOf(localRec));
                                break;
                            }
                            if (cloudRec == null) {
                                ((ArrayList)cloudRecords.get(i2)).add(localRec);
                                continue;
                            }
                            if (localRec.lastUpdatedHOH <= cloudRec.lastUpdatedHOH) continue;
                            ((ArrayList)cloudRecords.get(cloudPage)).remove(cloudRec);
                            ((ArrayList)cloudRecords.get(i2)).add(localRec);
                        }
                    }
                    for (ArrayList arrayList : cloudRecords) {
                        Collections.sort(arrayList, Rankings.scoreComparator);
                        while (arrayList.size() > 11) {
                            arrayList.remove(arrayList.size() - 1);
                        }
                    }
                    Rankings.INSTANCE.hallRecords = cloudRecords;
                    if (Rankings.INSTANCE.hallLastUpdated > cloudLastUpdated) {
                        cloudLastUpdated = Rankings.INSTANCE.hallLastUpdated;
                    } else {
                        Rankings.INSTANCE.hallLastUpdated = cloudLastUpdated;
                    }
                }
                Rankings.INSTANCE.hallLastSynced = Game.realTime;
                cloudLastID = Rankings.INSTANCE.hallID;
                Bundle bundle = new Bundle();
                boolean bl = false;
                while (var8_14 < 10) {
                    bundle.put("records" + (int)var8_14, (Collection)cloudRecords.get((int)var8_14));
                    ++var8_14;
                }
                bundle.put("updated", cloudLastUpdated);
                bundle.put("id", cloudLastID);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Bundle.write(bundle, byteArrayOutputStream);
                sender.sendData(byteArrayOutputStream.toByteArray());
                if (ShatteredPixelDungeon.scene() != null && ShatteredPixelDungeon.scene().getClass() == HallOfHeroesScene.class) {
                    ShatteredPixelDungeon.switchNoFade(HallOfHeroesScene.class);
                }
                Rankings.INSTANCE.saveHall();
            }
        });
    }

    public static void setOnscreenKeyboardVisible(boolean visible) {
        if (Sync.isConnected()) {
            service.setOnscreenKeyboardVisible(visible);
        }
    }
}

