/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.services.news;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.XmlReader;
import com.shatteredpixel.shatteredpixeldungeon.services.news.NewsArticle;
import com.shatteredpixel.shatteredpixeldungeon.services.news.NewsService;
import com.watabou.noosa.Game;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShatteredNews
extends NewsService {
    public void checkForArticles(boolean useMetered, final boolean preferHTTPS, final NewsService.NewsResultCallback callback) {
        if (!useMetered && !Game.platform.connectedToUnmeteredNetwork()) {
            callback.onConnectionFailed();
            return;
        }
        Net.HttpRequest httpGet = new Net.HttpRequest("GET");
        if (preferHTTPS) {
            httpGet.setUrl("https://shatteredpixel.com/feed_by_tag/SHPD_INGAME.xml");
        } else {
            httpGet.setUrl("http://shatteredpixel.com/feed_by_tag/SHPD_INGAME.xml");
        }
        Gdx.net.sendHttpRequest(httpGet, new Net.HttpResponseListener(){

            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                ArrayList<NewsArticle> articles = new ArrayList<NewsArticle>();
                XmlReader reader = new XmlReader();
                XmlReader.Element xmlDoc = reader.parse(httpResponse.getResultAsStream());
                SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
                for (XmlReader.Element xmlArticle : xmlDoc.getChildrenByName("entry")) {
                    NewsArticle article = new NewsArticle();
                    article.title = xmlArticle.get("title");
                    try {
                        article.date = dateParser.parse(xmlArticle.get("published"));
                    }
                    catch (ParseException e) {
                        Game.reportException((Throwable)e);
                    }
                    article.summary = xmlArticle.get("summary");
                    article.URL = xmlArticle.getChildByName("link").getAttribute("href");
                    if (!preferHTTPS) {
                        article.URL = article.URL.replace("https://", "http://");
                    }
                    Pattern versionCodeMatcher = Pattern.compile("v[0-9]+");
                    try {
                        Array properties = xmlArticle.getChildrenByName("category");
                        for (XmlReader.Element prop : properties) {
                            int iconGameVer;
                            Matcher m;
                            String propVal = prop.getAttribute("term");
                            if (!propVal.startsWith("SHPD_ICON") || !(m = versionCodeMatcher.matcher(propVal)).find() || (iconGameVer = Integer.parseInt(m.group().substring(1))) > Game.versionCode) continue;
                            article.icon = propVal.substring(propVal.indexOf(": ") + 2);
                        }
                    }
                    catch (Exception e) {
                        article.icon = null;
                    }
                    articles.add(article);
                }
                callback.onArticlesFound(articles);
            }

            public void failed(Throwable t) {
                callback.onConnectionFailed();
            }

            public void cancelled() {
                callback.onConnectionFailed();
            }
        });
    }
}

