#version 430

layout(local_size_x = 8, local_size_y = 1, local_size_z = 1) in;

layout (binding = 0) uniform sampler2D input0Read;

layout (binding = 0, rgba8) uniform restrict image2DRect output0Write;

uniform ivec2 start;
uniform ivec2 direction;
uniform ivec2 end;
uniform ivec2 fixedDimension;
uniform int blendAttribute;

void main() {
	ivec2 offset = ivec2(gl_GlobalInvocationID.xx) * fixedDimension;

	ivec2 at = start;
	vec4 previousPixel = vec4(0);
	bool haveValidPixel = false;
	while (at != end) {
		ivec2 _at = at + offset;
		vec4 here = texelFetch(input0Read, _at, 0);

		if (here[blendAttribute] != 0) {
			previousPixel = here;
			haveValidPixel = true;
		}

		vec4 _output = here;
		if (haveValidPixel) {
			_output[blendAttribute] = previousPixel[blendAttribute];
		}
		imageStore(output0Write, _at, _output);

		at += direction;
	}
}