#version 430

uniform sampler2D displayTexture;
uniform sampler2DArray ambientOcclusionTexture;
uniform int ambientOcclusionLayer;
uniform vec3 lightDirection;
uniform vec3 eyePoint;
uniform vec3 diffuseColour;
uniform float diffuseAmount;
uniform float specularAmount;
uniform float ambientAmount;
uniform int mode;

in vec4	colour;
in vec3	normal;
in vec2	texCoord;
in vec2 aaTexCoord;
in float usingTexture;
in vec3 worldPosition;

out vec4 outputColour;

void main() {
	float diffuse = max(dot(normalize(-normal), lightDirection), 0);
	vec3 viewDir = normalize(eyePoint - worldPosition);
	vec3 reflectDir = reflect(lightDirection, normal);  
	float spec = 1.f;

	if (mode == 0) {
		outputColour = texture(displayTexture, texCoord);
		if (outputColour.a == 0) {
			discard;
		}
		vec4 ambientOcclusion = texture(ambientOcclusionTexture, vec3(aaTexCoord, ambientOcclusionLayer));
		outputColour = outputColour * ambientOcclusion;
	}
	if (mode == 1) {
		if (texCoord.x == 0) {
			outputColour = vec4(1, 0, 0, 1);
		} else {
			discard;
		}
	}
	if (mode == 2) {
		if (texCoord.x != 0) {
			outputColour = vec4(texCoord.x, 0, 0, 1);
		} else {
			discard;
		}
	}
	if (mode == 7) {
		if (texCoord.x == 0) {
			outputColour = vec4(1, 0, 0, 1);
		} else {
			outputColour = vec4(0, 0, 0, 1);
		}
	}
	if (mode == 8) {
		vec4 ambientOcclusion = texture(ambientOcclusionTexture, vec3(aaTexCoord, ambientOcclusionLayer));
		outputColour = ambientOcclusion;
	}
}