#version 430

uniform sampler2D displayTexture;
uniform int mode;

#include "common/octohedral.glsl"

in vec3	normal;
in vec2	texCoord;

out vec4 outputColour;

vec3 rotate(vec3 v, vec3 axis, float angle) {
    float cosTheta = cos(angle);
    float sinTheta = sin(angle);

    return (v * cosTheta) +
           (cross(axis, v) * sinTheta) +
           (axis * dot(axis, v) * (1.0 - cosTheta));
                   
}

void main() {
	if (mode == 4) {
		// variable colour
		if (texCoord.x == 0) {
			outputColour = vec4(getOctahedralCoordinatesFromNormal(normalize(normal)), 0.f, 1.f);
		} else {
			discard;
		}
	}
	if (mode == 5) {
		// fixed colour
		if (texCoord.x != 0) {
			outputColour = vec4(getOctahedralCoordinatesFromNormal(normalize(normal)), 0.f, 1.f);
		} else {
			discard;
		}
	}
}