#version 430

uniform sampler2D input1;
uniform sampler2D input2;
uniform sampler2D input3;
uniform sampler2D input4;

in vec2 texCoord;

out vec4 _output;

void main() {
	vec4 input1Data = texture(input1, texCoord);
	vec4 input2Data = texture(input2, texCoord);
	vec4 input3Data = texture(input3, texCoord);
	vec4 input4Data = texture(input4, texCoord);

	float ambientOcclusion = input2Data[0];
	if (input2Data[3] == 0.f) {
		ambientOcclusion = 1.f;
	}

	_output = vec4(
		input1Data.x,
		ambientOcclusion,
		input3Data.x,
		input4Data.a
	);
}