#version 150

uniform sampler2D uTex0;
uniform bool picking;

in vec4	colour;
in vec2	texCoord;
in float usingTexture;

out vec4 outputColour;

void main() {
	if (picking) {
		outputColour = colour;
		return;
	}

	vec4 textureColour = vec4(1.0, 1.0, 1.0, 1.0);
	if (usingTexture > 0.5) {
		textureColour = texture(uTex0, texCoord);
	}
	if (textureColour.a < 0.5) {
		discard;
	}
	outputColour = vec4(textureColour.rgb * colour.rgb, 1.0);
}