#version 150

in vec4	ciPosition;
in vec2	ciTexCoord0;
in vec3	ciNormal;
in vec4	ciColor;
in vec4 instanceMatrix1;
in vec4 instanceMatrix2;
in vec4 instanceMatrix3;
in vec4 instanceMatrix4;
in vec4 instanceColour;
in vec4 pickingColour;

out highp vec2 texCoord;
out lowp vec4 colour;
out lowp float usingTexture;

uniform mat4 ciModelViewProjection;
uniform mat3 ciNormalMatrix;
uniform bool picking;
uniform mat4 ciModelMatrix;
uniform mat4 ciViewMatrix;
uniform mat4 ciViewMatrixInverse;

void main() {
	mat4 modelMatrix;
	modelMatrix[0].rgba = instanceMatrix1;
	modelMatrix[1].rgba = instanceMatrix2;
	modelMatrix[2].rgba = instanceMatrix3;
	modelMatrix[3].rgba = instanceMatrix4;

	vec4 vertexPosition_worldspace = modelMatrix[3] + (ciViewMatrixInverse * vec4(ciPosition.x, ciPosition.z, ciPosition.y, 0));
	if (modelMatrix[0][0] == 0) {
		gl_Position = vec4(-1000, -1000, -1000, 0);
	} else {
		gl_Position	= (ciModelViewProjection) * vertexPosition_worldspace;
	}

	texCoord = ciTexCoord0;
	colour = ciColor; 
	usingTexture = 1.0;

	// if (ciTexCoord0 == vec2(0,0)) {
	// 	colour = instanceColour;
	// 	usingTexture = 0.0;
	// } else {
	colour = ciColor;
	usingTexture = 1.0;
	// }

	if (picking) {
		usingTexture = 0.0;
		colour = pickingColour;
	}
}
