struct IceFlows {
	float reposeFlows[4];
	float glacierFlows[4];
};

uvec4 packIceFlows(IceFlows flows) {
	uvec4 value;
	for (int i=0; i<4; i++) {
		value[i] = (uint(round(flows.reposeFlows[i] * 1024.f)) << 16) + (uint(round(flows.glacierFlows[i] * 16384.f)) & 0xFFFF);
	}
	return value;
}

IceFlows unpackIceFlows(uvec4 value) {
	IceFlows value;
	for (int i=0; i<4; i++) {
		value.reposeFlows[i] = (value[i] >> 16) / 1024.f;
		value.glacierFlows[i] = (value[i] & 0xFFFF) / 16384.f;
	}
	return value;
}