struct RockLayer {
	uint type;
	float depth;
	bool exists;
};

struct RockLayers {
	RockLayer layers[8];
};

/* 
	Bit 0 exists
	Bit 1 hardcoded to 1 as we're converting to a floatpoint representation and the exponent can't be all 0's
	Bits 2-5 type
	Bits 6-15 depth as uint
*/
uint packRockLayer(RockLayer rockLayer) {
	return ((rockLayer.exists ? 1u : 0u) << 15) | (0x1u << 14) | (clamp(rockLayer.type, 0u, 14u) << 10) | uint(clamp(rockLayer.depth, 0.f, 4092.f) / 4.f);
}

RockLayer unpackRockLayer(uint packedValue) {
	bool exists = ((packedValue >> 15) == 1);
	uint type = (packedValue & 0x3c00) >> 10;
	float depth = (packedValue & 0x03ff) * 4.f;
	return RockLayer(type, depth, exists);
}

vec4 packRockLayers(RockLayers rockLayers) {
	vec4 packedValues;
	for (int i=0; i<4; i++) {
		int at = i * 2;
		packedValues[i] = uintBitsToFloat(
			(packRockLayer(rockLayers.layers[at]) << 16) + packRockLayer(rockLayers.layers[at + 1])
		);
	}

	return packedValues;
}

RockLayers unpackRockLayers(vec4 packedInput) {
	RockLayers rockLayers;
	for (int i=0; i<4; i++) {
		uint value = floatBitsToUint(packedInput[i]);
		int at = i * 2;
		rockLayers.layers[at] = unpackRockLayer((value & 0xffff0000) >> 16);
		rockLayers.layers[at + 1] = unpackRockLayer(value & 0x0000ffff);
	}

	return rockLayers;
}

void pushDownRockLayers(inout RockLayers rockLayers) {
	for (int i=7; i >= 1; i--) {
		rockLayers.layers[i] = rockLayers.layers[i-1];
	}

	rockLayers.layers[0] = RockLayer(0, 0.f, false);
}

void pullUpRockLayers(inout RockLayers rockLayers) {
	for (int i=0; i <= 7; i++) {
		rockLayers.layers[i] = rockLayers.layers[i+1];
	}

	rockLayers.layers[7] = RockLayer(1, 9999.f, true);
}