struct ErosionParams {
	float regularErosionSpeed;
	float thermalErosionSpeed;
	float thermalErosionCutoff;
	float rockErosionSpeed;
	float rockErosionCutoff;
	float chemicalErosionSpeed;
};

uniform float SANDSTONE_REGULAR_EROSION_SPEED;
uniform float SANDSTONE_THERMAL_EROSION_CUTOFF;
uniform float SANDSTONE_ROCK_EROSION_SPEED;
uniform float SANDSTONE_ROCK_EROSION_CUTOFF;
uniform float SANDSTONE_CHEMICAL_EROSION_SPEED;

uniform float IGNEOUS_REGULAR_EROSION_SPEED;
uniform float IGNEOUS_THERMAL_EROSION_CUTOFF;
uniform float IGNEOUS_ROCK_EROSION_SPEED;
uniform float IGNEOUS_ROCK_EROSION_CUTOFF;
uniform float IGNEOUS_CHEMICAL_EROSION_SPEED;

uniform float SLATE_REGULAR_EROSION_SPEED;
uniform float SLATE_THERMAL_EROSION_CUTOFF;
uniform float SLATE_ROCK_EROSION_SPEED;
uniform float SLATE_ROCK_EROSION_CUTOFF;
uniform float SLATE_CHEMICAL_EROSION_SPEED;

uniform float DIRT_REGULAR_EROSION_SPEED;
uniform float DIRT_THERMAL_EROSION_CUTOFF;
uniform float DIRT_ROCK_EROSION_SPEED;
uniform float DIRT_ROCK_EROSION_CUTOFF;
uniform float DIRT_CHEMICAL_EROSION_SPEED;

ErosionParams getRockErosionParams(vec4 rockProperties) {
	if (rockProperties[2] == 1.f) {
		return ErosionParams(
			IGNEOUS_REGULAR_EROSION_SPEED, 
			THERMAL_EROSION_SPEED, IGNEOUS_THERMAL_EROSION_CUTOFF, 
			IGNEOUS_ROCK_EROSION_SPEED, IGNEOUS_ROCK_EROSION_CUTOFF, 
			IGNEOUS_CHEMICAL_EROSION_SPEED
		);
	}
	if (rockProperties[2] == 2.f) {
		return ErosionParams(
			SANDSTONE_REGULAR_EROSION_SPEED, 
			THERMAL_EROSION_SPEED, SANDSTONE_THERMAL_EROSION_CUTOFF, 
			SANDSTONE_ROCK_EROSION_SPEED, SANDSTONE_ROCK_EROSION_CUTOFF, 
			SANDSTONE_CHEMICAL_EROSION_SPEED
		);
	}
	if (rockProperties[2] == 3.f) {
		return ErosionParams (
			SLATE_REGULAR_EROSION_SPEED, 
			THERMAL_EROSION_SPEED, SLATE_THERMAL_EROSION_CUTOFF, 
			SLATE_ROCK_EROSION_SPEED, SLATE_ROCK_EROSION_CUTOFF, 
			SLATE_CHEMICAL_EROSION_SPEED
		);
	}

	return ErosionParams(0.f, THERMAL_EROSION_SPEED, IGNEOUS_THERMAL_EROSION_CUTOFF, 0.f, 0.f, IGNEOUS_CHEMICAL_EROSION_SPEED);
}

ErosionParams getErosionParams(vec4 rockProperties) {
	if (rockProperties[1] > 0.f || rockProperties[2] == 0.f) {
		return ErosionParams(DIRT_REGULAR_EROSION_SPEED, THERMAL_EROSION_SPEED, DIRT_THERMAL_EROSION_CUTOFF, 0.f, 0.f, DIRT_CHEMICAL_EROSION_SPEED);
	}
	return getRockErosionParams(rockProperties);
}