vec4 mod289(vec4 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec4 permute(vec4 x) {
  return mod289(((x*34.0)+1.0)*x);
}

vec4 taylorInvSqrt(vec4 r) {
  return 1.79284291400159 - 0.85373472095314 * r;
}

vec2 fade(vec2 t) {
  return t*t*t*(t*(t*6.0-15.0)+10.0);
}

// Classic Perlin noise
float cnoise(vec2 P) {
	vec4 Pi = floor(P.xyxy) + vec4(0.0, 0.0, 1.0, 1.0);
	vec4 Pf = fract(P.xyxy) - vec4(0.0, 0.0, 1.0, 1.0);
	Pi = mod289(Pi); // To avoid truncation effects in permutation
	vec4 ix = Pi.xzxz;
	vec4 iy = Pi.yyww;
	vec4 fx = Pf.xzxz;
	vec4 fy = Pf.yyww;

	vec4 i = permute(permute(ix) + iy);

	vec4 gx = fract(i * (1.0 / 41.0)) * 2.0 - 1.0 ;
	vec4 gy = abs(gx) - 0.5 ;
	vec4 tx = floor(gx + 0.5);
	gx = gx - tx;

	vec2 g00 = vec2(gx.x,gy.x);
	vec2 g10 = vec2(gx.y,gy.y);
	vec2 g01 = vec2(gx.z,gy.z);
	vec2 g11 = vec2(gx.w,gy.w);

	vec4 norm = taylorInvSqrt(vec4(dot(g00, g00), dot(g01, g01), dot(g10, g10), dot(g11, g11)));
	g00 *= norm.x;  
	g01 *= norm.y;  
	g10 *= norm.z;  
	g11 *= norm.w;  

	float n00 = dot(g00, vec2(fx.x, fy.x));
	float n10 = dot(g10, vec2(fx.y, fy.y));
	float n01 = dot(g01, vec2(fx.z, fy.z));
	float n11 = dot(g11, vec2(fx.w, fy.w));

	vec2 fade_xy = fade(Pf.xy);
	vec2 n_x = mix(vec2(n00, n01), vec2(n10, n11), fade_xy.x);
	float n_xy = mix(n_x.x, n_x.y, fade_xy.y);
	return 2.3 * n_xy;
}

highp float rand(vec2 co) {
	uint x = uint(co.x) + 1u;
	uint y = uint(co.y) + 1u;
	
	// Hash function based on xxhash and other high-quality hashes
	// This provides excellent statistical properties
	uint hash = x;
	hash ^= y << 16u | y >> 16u;
	hash *= 0x9e3779b9u;
	hash ^= hash >> 15u;
	hash *= 0x9e3779b9u;
	hash ^= hash >> 13u;
	hash *= 0xc2b2ae35u;
	hash ^= hash >> 16u;
	
	// Convert to float in range [0, 1) using full 32-bit precision
	// Use 23 bits for mantissa precision (IEEE 754 float)
	return float(hash >> 9u) / 8388608.0; // 2^23
}

// Alternative version with even better statistical properties (slightly slower)
highp float rand_premium(vec2 co) {
	uvec2 v = uvec2(co) + uvec2(1u);
	
	// PCG hash - excellent statistical properties
	v = v * 1664525u + 1013904223u;
	v.x += v.y * 1664525u;
	v.y += v.x * 1664525u;
	v = v ^ (v >> 16u);
	v = v * 2246822507u;
	v = v ^ (v >> 16u);
	
	// Use the full 32-bit output
	return float(v.x) / 4294967296.0; // 2^32
}

uniform sampler2D noiseTexture;
uniform vec2 noiseTextureSize;

float noise(vec2 value) {
	return texture(noiseTexture, value / 512.f)[0];
}