vec2 getOctahedralCoordinatesFromNormal(vec3 normal) {
	normal /= ( abs( normal.x ) + abs( normal.y ) + abs( normal.z ) );
	normal.xy = (normal.z >= 0.0) ? normal.xy : (1.0 - abs(normal.yx)) * sign(normal.xy);
	return 0.5 + 0.5 * normal.xy;
}
 
vec3 getNormalFromOctahedralCoordinates(vec2 coords) {
	coords = (coords * 2.0) - 1.0;
	vec3 normal = vec3(coords, 1.0 - abs(coords.x) - abs(coords.y));
	float t = max(-normal.z, 0.0);
	normal.x += (normal.x > 0.0)? -t : t;
	normal.y += (normal.y > 0.0)? -t : t;
	return normalize(normal);
}

vec2 getHemiOctahedralCoordinatesFromNormal(vec3 normal) {
	vec3 calculateOn = normal.xzy;
	vec3 octant = sign(calculateOn);

	float sum = dot(calculateOn, octant);
	vec3 octahedron = calculateOn / sum;

	return 0.5f * vec2(
		1.0f + octahedron.x + octahedron.y,
		1.0f + octahedron.y - octahedron.x
	);
}

vec3 getNormalFromHemiOctahedralCoordinates(vec2 coordinates) {
	vec3 position = vec3(0.0f + (coordinates.x - coordinates.y), 0.0f, -1.0f + (coordinates.x + coordinates.y));
	position.y = 1.0f - abs(position.x) - abs(position.z);
	return normalize(position);
}