uniform vec2 mousePosition;
uniform float mouseRadius;
uniform int overlayMode;
uniform int water_resolution;
uniform int intensityCurrency;
uniform sampler2DArray overlayTextures;
uniform vec4 buildingColour;

#include "common/data/biomes.glsl"

vec4 renderBiome(vec3 worldPosition) {
	ivec2 dataPos = ivec2(worldPosition.xz / water_resolution);
	vec4 biome1 = texelFetch(biomes1, dataPos);
	vec4 biome2 = texelFetch(biomes2, dataPos);

	int biome1Id = int(biome1[0] * 255.f);
	int biome2Id = biome1Id;
	if (biome1[1] < 0.75f) {
		biome2Id = int(biome2[0] * 255.f);
	} 

	if (fract((worldPosition.x + worldPosition.z) / 32.f) > 0.5f) {
		return texture(overlayTextures, vec3(gl_FragCoord.xy / 128.f, biome1Id));
	} else {
		return texture(overlayTextures, vec3(gl_FragCoord.xy / 128.f, biome2Id));
	}
}

const vec4 minIntensityColour = vec4(1, 1, 1, 1);
const vec4 maxIntensityColour = vec4(0, 1, 0.5, 1.0);
const vec4 invalidColour = vec4(203 / 255.f, 30 / 255.f, 45 / 255.f, 1);

vec4 renderIntensity(vec3 worldPosition) {
	for (int i=0; i<MAX_EXISTING_BUILDINGS; i++) {
		if (currencyBuildings[i].valid != 0.f && distance(worldPosition.xz, currencyBuildings[i].worldPosition) < currencyBuildings[i].range.x) {
			return buildingColour;
		}
	}

	ivec2 dataPos = ivec2(worldPosition.xz / water_resolution);
	vec4 biome1 = texelFetch(biomes1, dataPos);
	vec4 biome2 = texelFetch(biomes2, dataPos);

	int biome1Id = int(biome1[0] * 255.f);
	int biome2Id = int(biome2[0] * 255.f);

	float intensity = 
		(currencyBiomeMappings[intensityCurrency].biomeIntensity[biome1Id] * biome1[1]) +
		(currencyBiomeMappings[intensityCurrency].biomeIntensity[biome2Id] * biome2[1]);
	intensity = clamp(intensity, 0.f, 1.f);

	const float lowPadding = (1/32.f), highPadding = (1.f - (2 /32.f));
	return texture(overlayTextures, vec3(lowPadding + (intensity * highPadding), 0.5f, 16));
}

vec4 renderOverlay(vec4 currentPixel, vec3 worldPosition, bool canRenderBiome) {
	if (overlayMode == 0) return currentPixel;

	float dist = distance(mousePosition, worldPosition.xz) / mouseRadius;
	if (dist > 0.95 && dist < 1) {
		currentPixel = mix(currentPixel, vec4(0, 0, 0, 1), 0.5);
	}
	if (dist <= 0.95){
		if (overlayMode == 1) {
			currentPixel = mix(currentPixel, vec4(0, 0, 0, 1), 0.1);
		}
		if (overlayMode == 2) {
			currentPixel = renderBiome(worldPosition);
		}
		if (overlayMode == 3) {
			currentPixel = renderIntensity(worldPosition);
		}
	}
	return currentPixel;
}