float scale(int fromResolution, int toResolution) {
	int numerator = 1, denominator = 1;
	if (fromResolution > 0) {
		numerator *= fromResolution;
	} else {
		denominator *= -fromResolution;
	}
	if (toResolution > 0) {
		denominator *= toResolution;
	} else {
		numerator *= -toResolution;
	}
	return numerator / float(denominator);
}

vec2 convertCoordinates(vec2 coordinates, int inputResolution, int outputResolution, vec2 inputOffset, vec2 outputOffset) {
	float _scale = scale(inputResolution, outputResolution);
	return vec2((coordinates.x * _scale) + (inputOffset.x * _scale) - (outputOffset.x),
				(coordinates.y * _scale) + (inputOffset.y * _scale) - (outputOffset.y));
}