uniform float CATMULL_ALPHA;
uniform float CATMULL_TENSION;

float catmullRomSplineNormal(float p0, float p1, float p2, float p3, float t) {
    // Ensure t is clamped between 0 and 1
    t = clamp(t, 0.0, 1.0);

    // Calculate t^2 for efficiency
    float t2 = t * t;

    // Derivative of Catmull-Rom spline basis matrix coefficients
    float b0 = -1.5 * t2 + 2.0 * t - 0.5;
    float b1 =  4.5 * t2 - 5.0 * t;
    float b2 = -4.5 * t2 + 4.0 * t + 0.5;
    float b3 =  1.5 * t2 - 1.0 * t;

    // Compute the derivative value
    return b0 * p0 + b1 * p1 + b2 * p2 + b3 * p3;
}

float catmullRomSpline(float p0, float p1, float p2, float p3, float t) {
    // Ensure t is clamped between 0 and 1
    // t = clamp(t, 0.0, 1.0);

    // Calculate t^2 and t^3 for efficiency
    float t2 = t * t;
    float t3 = t2 * t;

    // Catmull-Rom spline basis matrix coefficients
    float a0 = -0.5 * t3 + t2 - 0.5 * t;
    float a1 =  1.5 * t3 - 2.5 * t2 + 1.0;
    float a2 = -1.5 * t3 + 2.0 * t2 + 0.5 * t;
    float a3 =  0.5 * t3 - 0.5 * t2;

    // Compute the interpolated value
    return a0 * p0 + a1 * p1 + a2 * p2 + a3 * p3;
}
