#include "common/constants.glsl"

uniform float TEMPERATURE_VARIATION_CELSIUS;
uniform vec4 TEMPERATURE_SEALEVEL_CELSIUS;
const int DAY_OF_PEAK_TEMPERATURE = 115;
uniform int GAME_YEAR;

float celsiusToNormalised(float celsius) {
	return (celsius + 64.f) / 128.f;
}

float normalisedToCelsius(float normalised) {
	return (normalised - 0.5f) * 128.f;
}

struct Temperature {
	float currentCelsius;
	float meanCelsius;
	float minCelsius;
	float percentageYearAboveZeroCelsius;
};

vec2 normalisedToCelsius(vec2 normalised) {
	return vec2(normalisedToCelsius(normalised[0]), normalisedToCelsius(normalised[1]));
}

float getAddedTemperatureFromSeason(float dayOfYear) {
	float temperatureVariation = sin((float(dayOfYear - DAY_OF_PEAK_TEMPERATURE) / 360.f) * (M_PI * 2) + (M_PI / 2));
	temperatureVariation = pow(abs(temperatureVariation), 0.5f) * sign(temperatureVariation);
	return (TEMPERATURE_VARIATION_CELSIUS / 2.f) * temperatureVariation;
}

Temperature normalisedToTemperature(vec2 normalised) {
	float currentCelsius = normalisedToCelsius(normalised[0]);
	float meanCelsius = normalisedToCelsius(normalised[1]);
	float minCelsius = meanCelsius - (TEMPERATURE_VARIATION_CELSIUS / 2.f);//, max = mean + (TEMPERATURE_VARIATION_CELSIUS / 2.f);
	float percentageYearAboveZeroCelsius = 1.f - clamp((-(minCelsius + 5.f)) / TEMPERATURE_VARIATION_CELSIUS, 0.f, 1.f);
	return Temperature(
		currentCelsius, meanCelsius, minCelsius, percentageYearAboveZeroCelsius
	);
}

