#include "common/perlin_noise.glsl"

float getMeanTemperature(float landHeight, vec2 relativePosition, vec2 absoluteCoordinates) {
	float x1 = mix(TEMPERATURE_SEALEVEL_CELSIUS[0], TEMPERATURE_SEALEVEL_CELSIUS[1], relativePosition.x);
	float x2 = mix(TEMPERATURE_SEALEVEL_CELSIUS[2], TEMPERATURE_SEALEVEL_CELSIUS[3], relativePosition.x);
	return mix(x1, x2, relativePosition.y) - (landHeight / 40.f) + (perlinNoise(absoluteCoordinates + vec2(GAME_YEAR * 13, GAME_YEAR * 179)) * 1.f);
}